/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.model.test;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import org.jboss.resteasy.logging.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RoleModel;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.services.managers.ApplianceBootstrap;
import org.keycloak.services.managers.RealmManager;
import org.keycloak.services.resources.KeycloakApplication;
import org.keycloak.util.JsonSerialization;

public class AbstractModelTest {
    private final Logger log = Logger.getLogger(this.getClass());
    protected KeycloakSessionFactory factory;
    protected KeycloakSession identitySession;
    protected RealmManager realmManager;

    @Before
    public void before() throws Exception {
        this.factory = KeycloakApplication.createSessionFactory();
        this.identitySession = this.factory.createSession();
        this.identitySession.getTransaction().begin();
        this.realmManager = new RealmManager(this.identitySession);
        new ApplianceBootstrap().bootstrap(this.identitySession);
    }

    @After
    public void after() throws Exception {
        this.identitySession.getTransaction().commit();
        this.identitySession.close();
        this.factory.close();
    }

    protected void commit() {
        this.identitySession.getTransaction().commit();
        this.identitySession.close();
        this.identitySession = this.factory.createSession();
        this.identitySession.getTransaction().begin();
        this.realmManager = new RealmManager(this.identitySession);
    }

    public static RealmRepresentation loadJson(String path) throws IOException {
        int c;
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(path);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        while ((c = is.read()) != -1) {
            os.write(c);
        }
        byte[] bytes = os.toByteArray();
        System.out.println(new String(bytes));
        return (RealmRepresentation)JsonSerialization.readValue((byte[])bytes, RealmRepresentation.class);
    }

    public static void assertRolesEquals(Set<RoleModel> expected, Set<RoleModel> actual) {
        Assert.assertEquals((long)expected.size(), (long)actual.size());
        for (RoleModel current : actual) {
            AbstractModelTest.assertRolesContains(current, expected);
        }
    }

    public static void assertRolesContains(RoleModel expected, Set<RoleModel> actual) {
        for (RoleModel current : actual) {
            if (!current.getId().equals(expected.getId())) continue;
            AbstractModelTest.assertRolesEquals(current, expected);
            return;
        }
        Assert.fail((String)("Role with id=" + expected.getId() + " name=" + expected.getName() + " not in set " + actual));
    }

    public static void assertRolesEquals(RoleModel expected, RoleModel actual) {
        Assert.assertEquals((Object)expected.getId(), (Object)actual.getId());
        Assert.assertEquals((Object)expected.getName(), (Object)actual.getName());
        Assert.assertEquals((Object)expected.getDescription(), (Object)actual.getDescription());
        Assert.assertEquals((Object)expected.getContainer(), (Object)actual.getContainer());
        Assert.assertEquals((long)expected.getComposites().size(), (long)actual.getComposites().size());
    }
}

