/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.model.test;

import java.util.Iterator;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.model.test.AbstractModelTest;
import org.keycloak.models.ApplicationModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.representations.idm.ApplicationRepresentation;
import org.keycloak.services.managers.ApplicationManager;

public class ApplicationModelTest
extends AbstractModelTest {
    private ApplicationModel application;
    private RealmModel realm;
    private ApplicationManager appManager;

    @Override
    @Before
    public void before() throws Exception {
        super.before();
        this.appManager = new ApplicationManager(this.realmManager);
        this.realm = this.realmManager.createRealm("original");
        this.application = this.realm.addApplication("application");
        this.application.setBaseUrl("http://base");
        this.application.setManagementUrl("http://management");
        this.application.setName("app-name");
        this.application.addRole("role-1");
        this.application.addRole("role-2");
        this.application.addRole("role-3");
        this.application.addDefaultRole("role-1");
        this.application.addDefaultRole("role-2");
        this.application.addRedirectUri("redirect-1");
        this.application.addRedirectUri("redirect-2");
        this.application.addWebOrigin("origin-1");
        this.application.addWebOrigin("origin-2");
        this.application.updateApplication();
    }

    @Test
    public void persist() {
        RealmModel persisted = this.realmManager.getRealm(this.realm.getId());
        ApplicationModelTest.assertEquals(this.application, (ApplicationModel)persisted.getApplicationNameMap().get("app-name"));
    }

    @Test
    public void json() {
        ApplicationRepresentation representation = this.appManager.toRepresentation(this.application);
        RealmModel realm = this.realmManager.createRealm("copy");
        ApplicationModel copy = this.appManager.createApplication(realm, representation);
        ApplicationModelTest.assertEquals(this.application, copy);
    }

    public static void assertEquals(ApplicationModel expected, ApplicationModel actual) {
        Assert.assertEquals((Object)expected.getName(), (Object)actual.getName());
        Assert.assertEquals((Object)expected.getBaseUrl(), (Object)actual.getBaseUrl());
        Assert.assertEquals((Object)expected.getManagementUrl(), (Object)actual.getManagementUrl());
        Assert.assertEquals((Object)expected.getDefaultRoles(), (Object)actual.getDefaultRoles());
        Assert.assertTrue((boolean)expected.getRedirectUris().containsAll(actual.getRedirectUris()));
        Assert.assertTrue((boolean)expected.getWebOrigins().containsAll(actual.getWebOrigins()));
    }

    public static void assertEquals(List<RoleModel> expected, List<RoleModel> actual) {
        Assert.assertEquals((long)expected.size(), (long)actual.size());
        Iterator<RoleModel> exp = expected.iterator();
        Iterator<RoleModel> act = actual.iterator();
        while (exp.hasNext()) {
            Assert.assertEquals((Object)exp.next().getName(), (Object)act.next().getName());
        }
    }
}

