/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.model.test;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;
import org.keycloak.model.test.AbstractModelTest;
import org.keycloak.models.ApplicationModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RequiredCredentialModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.SocialLinkModel;
import org.keycloak.models.UserModel;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.services.managers.RealmManager;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class ImportTest
extends AbstractModelTest {
    @Test
    public void demoDelete() throws Exception {
        RealmRepresentation rep = AbstractModelTest.loadJson("testrealm2.json");
        RealmModel realm = this.realmManager.importRealm(rep);
        this.commit();
        realm = this.realmManager.getRealmByName("demo-delete");
        this.realmManager.removeRealm(realm);
    }

    @Test
    public void install() throws Exception {
        RealmRepresentation rep = AbstractModelTest.loadJson("testrealm.json");
        RealmModel realm = this.realmManager.createRealm("demo", rep.getRealm());
        this.realmManager.importRealm(rep, realm);
        this.commit();
        realm = this.realmManager.getRealm("demo");
        Assert.assertTrue((boolean)realm.isVerifyEmail());
        Assert.assertFalse((boolean)realm.isUpdateProfileOnInitialSocialLogin());
        List creds = realm.getRequiredCredentials();
        Assert.assertEquals((long)1L, (long)creds.size());
        RequiredCredentialModel cred = (RequiredCredentialModel)creds.get(0);
        Assert.assertEquals((Object)"password", (Object)cred.getFormLabel());
        Assert.assertEquals((long)2L, (long)realm.getDefaultRoles().size());
        Assert.assertNotNull((Object)realm.getRole("foo"));
        Assert.assertNotNull((Object)realm.getRole("bar"));
        UserModel user = realm.getUser("loginclient");
        Assert.assertNotNull((Object)user);
        Assert.assertEquals((long)0L, (long)realm.getSocialLinks(user).size());
        List resources = realm.getApplications();
        Assert.assertEquals((long)3L, (long)resources.size());
        ApplicationModel application = realm.getApplicationByName("Application");
        ApplicationModel otherApp = realm.getApplicationByName("OtherApp");
        ApplicationModel accountApp = realm.getApplicationByName("account");
        ApplicationModel nonExisting = realm.getApplicationByName("NonExisting");
        Assert.assertNotNull((Object)application);
        Assert.assertNotNull((Object)otherApp);
        Assert.assertNull((Object)nonExisting);
        Map apps = realm.getApplicationNameMap();
        Assert.assertEquals((long)3L, (long)apps.size());
        Assert.assertTrue((boolean)apps.values().contains(application));
        Assert.assertTrue((boolean)apps.values().contains(otherApp));
        Assert.assertTrue((boolean)apps.values().contains(accountApp));
        realm.getApplications().containsAll(apps.values());
        Assert.assertNull((Object)realm.getApplicationById("982734"));
        Assert.assertEquals((Object)application, (Object)realm.getApplicationById(application.getId()));
        UserModel admin = realm.getUser("admin");
        Set allRoles = realm.getRoleMappings(admin);
        Assert.assertEquals((long)5L, (long)allRoles.size());
        Assert.assertTrue((boolean)allRoles.contains(realm.getRole("admin")));
        Assert.assertTrue((boolean)allRoles.contains(application.getRole("app-admin")));
        Assert.assertTrue((boolean)allRoles.contains(otherApp.getRole("otherapp-admin")));
        Assert.assertTrue((boolean)allRoles.contains(accountApp.getRole("view-profile")));
        Assert.assertTrue((boolean)allRoles.contains(accountApp.getRole("manage-account")));
        UserModel wburke = realm.getUser("wburke");
        allRoles = realm.getRoleMappings(wburke);
        Assert.assertEquals((long)4L, (long)allRoles.size());
        Assert.assertFalse((boolean)allRoles.contains(realm.getRole("admin")));
        Assert.assertTrue((boolean)allRoles.contains(application.getRole("app-user")));
        Assert.assertTrue((boolean)allRoles.contains(otherApp.getRole("otherapp-user")));
        Assert.assertEquals((long)0L, (long)realm.getRealmRoleMappings(wburke).size());
        Set realmRoles = realm.getRealmRoleMappings(admin);
        Assert.assertEquals((long)1L, (long)realmRoles.size());
        Assert.assertEquals((Object)"admin", (Object)((RoleModel)realmRoles.iterator().next()).getName());
        Set appRoles = application.getApplicationRoleMappings(admin);
        Assert.assertEquals((long)1L, (long)appRoles.size());
        Assert.assertEquals((Object)"app-admin", (Object)((RoleModel)appRoles.iterator().next()).getName());
        ClientModel oauthClient = realm.findClient("oauthclient");
        Assert.assertEquals((Object)"clientpassword", (Object)oauthClient.getSecret());
        Assert.assertEquals((Object)true, (Object)oauthClient.isEnabled());
        Assert.assertNotNull((Object)oauthClient);
        Set allScopes = realm.getScopeMappings(oauthClient);
        Assert.assertEquals((long)2L, (long)allScopes.size());
        Assert.assertTrue((boolean)allScopes.contains(realm.getRole("admin")));
        Assert.assertTrue((boolean)allScopes.contains(application.getRole("app-user")));
        Set realmScopes = realm.getRealmScopeMappings(oauthClient);
        Assert.assertTrue((boolean)realmScopes.contains(realm.getRole("admin")));
        Set appScopes = application.getApplicationScopeMappings(oauthClient);
        Assert.assertTrue((boolean)appScopes.contains(application.getRole("app-user")));
        UserModel socialUser = realm.getUser("mySocialUser");
        Set socialLinks = realm.getSocialLinks(socialUser);
        Assert.assertEquals((long)3L, (long)socialLinks.size());
        boolean facebookFound = false;
        boolean googleFound = false;
        boolean twitterFound = false;
        for (SocialLinkModel socialLinkModel : socialLinks) {
            if ("facebook".equals(socialLinkModel.getSocialProvider())) {
                facebookFound = true;
                Assert.assertEquals((Object)socialLinkModel.getSocialUserId(), (Object)"facebook1");
                Assert.assertEquals((Object)socialLinkModel.getSocialUsername(), (Object)"fbuser1");
                continue;
            }
            if ("google".equals(socialLinkModel.getSocialProvider())) {
                googleFound = true;
                Assert.assertEquals((Object)socialLinkModel.getSocialUserId(), (Object)"google1");
                Assert.assertEquals((Object)socialLinkModel.getSocialUsername(), (Object)"mySocialUser@gmail.com");
                continue;
            }
            if (!"twitter".equals(socialLinkModel.getSocialProvider())) continue;
            twitterFound = true;
            Assert.assertEquals((Object)socialLinkModel.getSocialUserId(), (Object)"twitter1");
            Assert.assertEquals((Object)socialLinkModel.getSocialUsername(), (Object)"twuser1");
        }
        Assert.assertTrue((facebookFound && twitterFound && googleFound ? 1 : 0) != 0);
        UserModel foundSocialUser = realm.getUserBySocialLink(new SocialLinkModel("facebook", "facebook1", "fbuser1"));
        Assert.assertEquals((Object)foundSocialUser.getLoginName(), (Object)socialUser.getLoginName());
        Assert.assertNull((Object)realm.getUserBySocialLink(new SocialLinkModel("facebook", "not-existing", "not-existing")));
        SocialLinkModel foundSocialLink = realm.getSocialLink(socialUser, "facebook");
        Assert.assertEquals((Object)"facebook1", (Object)foundSocialLink.getSocialUserId());
        Assert.assertEquals((Object)"fbuser1", (Object)foundSocialLink.getSocialUsername());
        Assert.assertEquals((Object)"facebook", (Object)foundSocialLink.getSocialProvider());
        Assert.assertTrue((boolean)realm.removeSocialLink(socialUser, "facebook"));
        Assert.assertNull((Object)realm.getSocialLink(socialUser, "facebook"));
        Assert.assertFalse((boolean)realm.removeSocialLink(socialUser, "facebook"));
        this.commit();
        realm = this.realmManager.getRealm("demo");
        this.realmManager.removeRealm(realm);
    }

    @Test
    public void install2() throws Exception {
        RealmManager manager = this.realmManager;
        RealmRepresentation rep = AbstractModelTest.loadJson("testrealm-demo.json");
        RealmModel realm = manager.createRealm("demo", rep.getRealm());
        manager.importRealm(rep, realm);
        Assert.assertFalse((boolean)realm.isUpdateProfileOnInitialSocialLogin());
        Assert.assertEquals((long)600L, (long)realm.getAccessCodeLifespanUserAction());
        this.verifyRequiredCredentials(realm.getRequiredCredentials(), "password");
    }

    private void verifyRequiredCredentials(List<RequiredCredentialModel> requiredCreds, String expectedType) {
        Assert.assertEquals((long)1L, (long)requiredCreds.size());
        Assert.assertEquals((Object)expectedType, (Object)requiredCreds.get(0).getType());
    }
}

