/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.model.test;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.model.test.AbstractModelTest;
import org.keycloak.models.ApplicationModel;
import org.keycloak.models.OAuthClientModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserModel;

public class MultipleRealmsTest
extends AbstractModelTest {
    private RealmModel realm1;
    private RealmModel realm2;

    @Override
    @Before
    public void before() throws Exception {
        super.before();
        this.realm1 = this.identitySession.createRealm("id1", "realm1");
        this.realm2 = this.identitySession.createRealm("id2", "realm2");
        this.createObjects(this.realm1);
        this.createObjects(this.realm2);
    }

    @Test
    public void testUsers() {
        UserModel r1user1 = this.realm1.getUser("user1");
        UserModel r2user1 = this.realm2.getUser("user1");
        Assert.assertEquals((Object)r1user1.getLoginName(), (Object)r2user1.getLoginName());
        Assert.assertNotEquals((Object)r1user1.getId(), (Object)r2user1.getId());
        this.realm1.updateCredential(r1user1, UserCredentialModel.password((String)"pass1"));
        this.realm2.updateCredential(r2user1, UserCredentialModel.password((String)"pass2"));
        Assert.assertTrue((boolean)this.realm1.validatePassword(r1user1, "pass1"));
        Assert.assertFalse((boolean)this.realm1.validatePassword(r1user1, "pass2"));
        Assert.assertFalse((boolean)this.realm2.validatePassword(r2user1, "pass1"));
        Assert.assertTrue((boolean)this.realm2.validatePassword(r2user1, "pass2"));
        Assert.assertEquals((long)2L, (long)this.realm1.searchForUser("user").size());
        this.realm1.removeUser("user1");
        this.realm1.removeUser("user2");
        Assert.assertEquals((long)0L, (long)this.realm1.searchForUser("user").size());
        Assert.assertEquals((long)2L, (long)this.realm2.searchForUser("user").size());
    }

    @Test
    public void testGetById() {
        Assert.assertEquals((Object)this.realm1, (Object)this.identitySession.getRealm("id1"));
        Assert.assertEquals((Object)this.realm1, (Object)this.identitySession.getRealmByName("realm1"));
        Assert.assertEquals((Object)this.realm2, (Object)this.identitySession.getRealm("id2"));
        Assert.assertEquals((Object)this.realm2, (Object)this.identitySession.getRealmByName("realm2"));
        ApplicationModel r1app1 = this.realm1.getApplicationByName("app1");
        ApplicationModel r1app2 = this.realm1.getApplicationByName("app2");
        ApplicationModel r2app1 = this.realm2.getApplicationByName("app1");
        ApplicationModel r2app2 = this.realm2.getApplicationByName("app2");
        Assert.assertEquals((Object)r1app1, (Object)this.realm1.getApplicationById(r1app1.getId()));
        Assert.assertNull((Object)this.realm2.getApplicationById(r1app1.getId()));
        OAuthClientModel r2cl1 = this.realm2.getOAuthClient("cl1");
        Assert.assertNull((Object)this.realm1.getOAuthClientById(r2cl1.getId()));
        Assert.assertEquals((Object)r2cl1.getId(), (Object)this.realm2.getOAuthClientById(r2cl1.getId()).getId());
        RoleModel r1App1Role = r1app1.getRole("app1Role1");
        Assert.assertEquals((Object)r1App1Role, (Object)this.realm1.getRoleById(r1App1Role.getId()));
        Assert.assertNull((Object)this.realm2.getRoleById(r1App1Role.getId()));
        RoleModel r2Role1 = this.realm2.getRole("role2");
        Assert.assertNull((Object)this.realm1.getRoleById(r2Role1.getId()));
        Assert.assertEquals((Object)r2Role1, (Object)this.realm2.getRoleById(r2Role1.getId()));
    }

    private void createObjects(RealmModel realm) {
        ApplicationModel app1 = realm.addApplication("app1");
        realm.addApplication("app2");
        realm.addUser("user1");
        realm.addUser("user2");
        realm.addRole("role1");
        realm.addRole("role2");
        app1.addRole("app1Role1");
        app1.addScope(realm.getRole("role1"));
        realm.addOAuthClient("cl1");
    }
}

