/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.model.test;

import org.junit.Assert;
import org.junit.Test;
import org.keycloak.model.test.AbstractModelTest;
import org.keycloak.models.ApplicationModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;

public class UserModelTest
extends AbstractModelTest {
    @Test
    public void persistUser() {
        RealmModel realm = this.realmManager.createRealm("original");
        UserModel user = realm.addUser("user");
        user.setFirstName("first-name");
        user.setLastName("last-name");
        user.setEmail("email");
        user.addRequiredAction(UserModel.RequiredAction.CONFIGURE_TOTP);
        user.addRequiredAction(UserModel.RequiredAction.UPDATE_PASSWORD);
        UserModel persisted = this.realmManager.getRealm(realm.getId()).getUser("user");
        UserModelTest.assertEquals(user, persisted);
        UserModel persisted2 = this.realmManager.getRealm(realm.getId()).getUserById(user.getId());
        UserModelTest.assertEquals(user, persisted2);
    }

    @Test
    public void webOriginSetTest() {
        RealmModel realm = this.realmManager.createRealm("original");
        ApplicationModel client = realm.addApplication("user");
        Assert.assertTrue((boolean)client.getWebOrigins().isEmpty());
        client.addWebOrigin("origin-1");
        Assert.assertEquals((long)1L, (long)client.getWebOrigins().size());
        client.addWebOrigin("origin-2");
        Assert.assertEquals((long)2L, (long)client.getWebOrigins().size());
        client.removeWebOrigin("origin-2");
        Assert.assertEquals((long)1L, (long)client.getWebOrigins().size());
        client.removeWebOrigin("origin-1");
        Assert.assertTrue((boolean)client.getWebOrigins().isEmpty());
        client = realm.addOAuthClient("oauthclient2");
        Assert.assertTrue((boolean)client.getWebOrigins().isEmpty());
        client.addWebOrigin("origin-1");
        Assert.assertEquals((long)1L, (long)client.getWebOrigins().size());
        client.addWebOrigin("origin-2");
        Assert.assertEquals((long)2L, (long)client.getWebOrigins().size());
        client.removeWebOrigin("origin-2");
        Assert.assertEquals((long)1L, (long)client.getWebOrigins().size());
        client.removeWebOrigin("origin-1");
        Assert.assertTrue((boolean)client.getWebOrigins().isEmpty());
    }

    @Test
    public void testUserRequiredActions() throws Exception {
        RealmModel realm = this.realmManager.createRealm("original");
        UserModel user = realm.addUser("user");
        Assert.assertTrue((boolean)user.getRequiredActions().isEmpty());
        user.addRequiredAction(UserModel.RequiredAction.CONFIGURE_TOTP);
        String id = realm.getId();
        this.commit();
        realm = this.realmManager.getRealm(id);
        user = realm.getUser("user");
        Assert.assertEquals((long)1L, (long)user.getRequiredActions().size());
        Assert.assertTrue((boolean)user.getRequiredActions().contains(UserModel.RequiredAction.CONFIGURE_TOTP));
        user.addRequiredAction(UserModel.RequiredAction.CONFIGURE_TOTP);
        user = realm.getUser("user");
        Assert.assertEquals((long)1L, (long)user.getRequiredActions().size());
        Assert.assertTrue((boolean)user.getRequiredActions().contains(UserModel.RequiredAction.CONFIGURE_TOTP));
        user.addRequiredAction(UserModel.RequiredAction.VERIFY_EMAIL);
        user = realm.getUser("user");
        Assert.assertEquals((long)2L, (long)user.getRequiredActions().size());
        Assert.assertTrue((boolean)user.getRequiredActions().contains(UserModel.RequiredAction.CONFIGURE_TOTP));
        Assert.assertTrue((boolean)user.getRequiredActions().contains(UserModel.RequiredAction.VERIFY_EMAIL));
        user.removeRequiredAction(UserModel.RequiredAction.CONFIGURE_TOTP);
        user = realm.getUser("user");
        Assert.assertEquals((long)1L, (long)user.getRequiredActions().size());
        Assert.assertTrue((boolean)user.getRequiredActions().contains(UserModel.RequiredAction.VERIFY_EMAIL));
        user.removeRequiredAction(UserModel.RequiredAction.VERIFY_EMAIL);
        user = realm.getUser("user");
        Assert.assertTrue((boolean)user.getRequiredActions().isEmpty());
    }

    public static void assertEquals(UserModel expected, UserModel actual) {
        Assert.assertEquals((Object)expected.getLoginName(), (Object)actual.getLoginName());
        Assert.assertEquals((Object)expected.getFirstName(), (Object)actual.getFirstName());
        Assert.assertEquals((Object)expected.getLastName(), (Object)actual.getLastName());
        Assert.assertArrayEquals((Object[])expected.getRequiredActions().toArray(), (Object[])actual.getRequiredActions().toArray());
    }
}

