/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.picketlink.ldap;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.logging.Logger;
import org.keycloak.models.UserFederationProviderModel;
import org.keycloak.picketlink.idm.KeycloakEventBridge;
import org.keycloak.picketlink.idm.LDAPKeycloakCredentialHandler;
import org.picketlink.idm.PartitionManager;
import org.picketlink.idm.config.IdentityConfigurationBuilder;
import org.picketlink.idm.config.LDAPMappingConfigurationBuilder;
import org.picketlink.idm.config.LDAPStoreConfigurationBuilder;
import org.picketlink.idm.event.EventBridge;
import org.picketlink.idm.internal.DefaultPartitionManager;
import org.picketlink.idm.model.basic.User;

public class PartitionManagerRegistry {
    private static final Logger logger = Logger.getLogger(PartitionManagerRegistry.class);
    private Map<String, PartitionManagerContext> partitionManagers = new ConcurrentHashMap<String, PartitionManagerContext>();

    public PartitionManager getPartitionManager(UserFederationProviderModel model) {
        PartitionManagerContext context = this.partitionManagers.get(model.getId());
        Map config = model.getConfig();
        if (context == null || !config.equals(context.config)) {
            this.logLDAPConfig(model.getId(), config);
            PartitionManager manager = PartitionManagerRegistry.createPartitionManager(config);
            context = new PartitionManagerContext(config, manager);
            this.partitionManagers.put(model.getId(), context);
        }
        return context.partitionManager;
    }

    private void logLDAPConfig(String fedProviderId, Map<String, String> ldapConfig) {
        HashMap<String, String> copy = new HashMap<String, String>(ldapConfig);
        copy.remove("bindCredential");
        logger.infof("Creating new LDAP based partition manager for the Federation provider: " + fedProviderId + ", LDAP Configuration: " + copy, new Object[0]);
    }

    public static PartitionManager createPartitionManager(Map<String, String> ldapConfig) {
        IdentityConfigurationBuilder builder = new IdentityConfigurationBuilder();
        Properties connectionProps = new Properties();
        connectionProps.put("com.sun.jndi.ldap.connect.pool", "true");
        PartitionManagerRegistry.checkSystemProperty("com.sun.jndi.ldap.connect.pool.authentication", "none simple");
        PartitionManagerRegistry.checkSystemProperty("com.sun.jndi.ldap.connect.pool.initsize", "1");
        PartitionManagerRegistry.checkSystemProperty("com.sun.jndi.ldap.connect.pool.maxsize", "1000");
        PartitionManagerRegistry.checkSystemProperty("com.sun.jndi.ldap.connect.pool.prefsize", "5");
        PartitionManagerRegistry.checkSystemProperty("com.sun.jndi.ldap.connect.pool.timeout", "300000");
        PartitionManagerRegistry.checkSystemProperty("com.sun.jndi.ldap.connect.pool.protocol", "plain");
        PartitionManagerRegistry.checkSystemProperty("com.sun.jndi.ldap.connect.pool.debug", "off");
        String vendor = ldapConfig.get("vendor");
        boolean activeDirectory = vendor != null && vendor.equals("ad");
        String ldapLoginNameMapping = ldapConfig.get("usernameLDAPAttribute");
        if (ldapLoginNameMapping == null) {
            ldapLoginNameMapping = activeDirectory ? "cn" : "uid";
        }
        String ldapFirstNameMapping = activeDirectory ? "givenName" : "cn";
        String[] userObjectClasses = PartitionManagerRegistry.getUserObjectClasses(ldapConfig);
        LDAPStoreConfigurationBuilder ldapStoreBuilder = (LDAPStoreConfigurationBuilder)((LDAPStoreConfigurationBuilder)builder.named("SIMPLE_LDAP_STORE_CONFIG").stores().ldap().connectionProperties(connectionProps).addCredentialHandler(LDAPKeycloakCredentialHandler.class)).baseDN(ldapConfig.get("baseDn")).bindDN(ldapConfig.get("bindDn")).bindCredential(ldapConfig.get("bindCredential")).url(ldapConfig.get("connectionUrl")).activeDirectory(activeDirectory).supportAllFeatures();
        if (vendor != null && vendor.equals("rhds")) {
            ldapStoreBuilder.uniqueIdentifierAttributeName("nsuniqueid");
        }
        LDAPMappingConfigurationBuilder ldapUserMappingBuilder = ldapStoreBuilder.mapping(User.class).baseDN(ldapConfig.get("userDnSuffix")).objectClasses(userObjectClasses).attribute("loginName", ldapLoginNameMapping, true).attribute("firstName", ldapFirstNameMapping).attribute("lastName", "sn").attribute("email", "mail");
        if (activeDirectory && ldapLoginNameMapping.equals("sAMAccountName")) {
            ldapUserMappingBuilder.bindingAttribute("fullName", "cn");
            logger.infof("Using 'cn' attribute for DN of user and 'sAMAccountName' for username", new Object[0]);
        }
        KeycloakEventBridge eventBridge = new KeycloakEventBridge(activeDirectory && "true".equals(ldapConfig.get("userAccountControlsAfterPasswordUpdate")));
        return new DefaultPartitionManager((Collection)builder.buildAll(), (EventBridge)eventBridge, null);
    }

    private static void checkSystemProperty(String name, String defaultValue) {
        if (System.getProperty(name) == null) {
            System.setProperty(name, defaultValue);
        }
    }

    private static String[] getUserObjectClasses(Map<String, String> ldapConfig) {
        String objClassesCfg = ldapConfig.get("userObjectClasses");
        String objClassesStr = objClassesCfg != null && objClassesCfg.length() > 0 ? objClassesCfg.trim() : "inetOrgPerson, organizationalPerson";
        String[] objectClasses = objClassesStr.split(",");
        String[] userObjectClasses = new String[objectClasses.length];
        for (int i = 0; i < objectClasses.length; ++i) {
            userObjectClasses[i] = objectClasses[i].trim();
        }
        return userObjectClasses;
    }

    private class PartitionManagerContext {
        private Map<String, String> config;
        private PartitionManager partitionManager;

        private PartitionManagerContext(Map<String, String> config, PartitionManager manager) {
            this.config = config;
            this.partitionManager = manager;
        }
    }
}

