/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.util;

import io.undertow.UndertowMessages;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.xnio.Pooled;

public class ReferenceCountedPooled<T>
implements Pooled<T> {
    private final Pooled<T> underlying;
    private volatile int referenceCount;
    private volatile boolean discard = false;
    boolean mainFreed = false;
    private static final AtomicIntegerFieldUpdater<ReferenceCountedPooled> referenceCountUpdater = AtomicIntegerFieldUpdater.newUpdater(ReferenceCountedPooled.class, "referenceCount");

    public ReferenceCountedPooled(Pooled<T> underlying, int referenceCount) {
        this.underlying = underlying;
        this.referenceCount = referenceCount;
    }

    public void discard() {
        this.discard = true;
        if (referenceCountUpdater.decrementAndGet(this) == 0) {
            this.underlying.discard();
        }
    }

    public void free() {
        if (this.mainFreed) {
            throw UndertowMessages.MESSAGES.bufferAlreadyFreed();
        }
        this.mainFreed = true;
        this.freeInternal();
    }

    public void freeInternal() {
        if (referenceCountUpdater.decrementAndGet(this) == 0) {
            if (this.discard) {
                this.underlying.discard();
            } else {
                this.underlying.free();
            }
        }
    }

    public T getResource() throws IllegalStateException {
        return (T)this.underlying.getResource();
    }

    public void close() {
        this.free();
    }

    public Pooled<T> createView(final T newValue) {
        this.increaseReferenceCount();
        return new Pooled<T>(){
            boolean free = false;

            public void discard() {
                if (!this.free) {
                    this.free = true;
                    ReferenceCountedPooled.this.freeInternal();
                }
            }

            public void free() {
                if (!this.free) {
                    this.free = true;
                    ReferenceCountedPooled.this.freeInternal();
                }
            }

            public T getResource() throws IllegalStateException {
                if (this.free) {
                    throw UndertowMessages.MESSAGES.bufferAlreadyFreed();
                }
                return newValue;
            }

            public void close() {
                this.free();
            }
        };
    }

    public void increaseReferenceCount() {
        int val;
        do {
            if ((val = referenceCountUpdater.get(this)) != 0) continue;
            throw UndertowMessages.MESSAGES.objectWasFreed();
        } while (!referenceCountUpdater.compareAndSet(this, val, val + 1));
    }
}

