/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters;

import java.security.PublicKey;
import java.util.List;
import javax.security.cert.X509Certificate;
import org.jboss.logging.Logger;
import org.keycloak.RSATokenVerifier;
import org.keycloak.VerificationException;
import org.keycloak.adapters.AuthChallenge;
import org.keycloak.adapters.AuthOutcome;
import org.keycloak.adapters.HttpFacade;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.representations.AccessToken;

public class BearerTokenRequestAuthenticator {
    protected Logger log = Logger.getLogger(BearerTokenRequestAuthenticator.class);
    protected String tokenString;
    protected AccessToken token;
    protected String surrogate;
    protected AuthChallenge challenge;
    protected KeycloakDeployment deployment;

    public BearerTokenRequestAuthenticator(KeycloakDeployment deployment) {
        this.deployment = deployment;
    }

    public AuthChallenge getChallenge() {
        return this.challenge;
    }

    public String getTokenString() {
        return this.tokenString;
    }

    public AccessToken getToken() {
        return this.token;
    }

    public String getSurrogate() {
        return this.surrogate;
    }

    public AuthOutcome authenticate(HttpFacade exchange) {
        List<String> authHeaders = exchange.getRequest().getHeaders("Authorization");
        if (authHeaders == null || authHeaders.size() == 0) {
            this.challenge = this.challengeResponse(exchange, null, null);
            return AuthOutcome.NOT_ATTEMPTED;
        }
        this.tokenString = null;
        for (String authHeader : authHeaders) {
            String[] split = authHeader.trim().split("\\s+");
            if (split == null || split.length != 2 || !split[0].equalsIgnoreCase("Bearer")) continue;
            this.tokenString = split[1];
        }
        if (this.tokenString == null) {
            this.challenge = this.challengeResponse(exchange, null, null);
            return AuthOutcome.NOT_ATTEMPTED;
        }
        return this.authenticateToken(exchange, this.tokenString);
    }

    protected AuthOutcome authenticateToken(HttpFacade exchange, String tokenString) {
        try {
            this.token = RSATokenVerifier.verifyToken((String)tokenString, (PublicKey)this.deployment.getRealmKey(), (String)this.deployment.getRealmInfoUrl());
        }
        catch (VerificationException e) {
            this.log.error((Object)"Failed to verify token", (Throwable)e);
            this.challenge = this.challengeResponse(exchange, "invalid_token", e.getMessage());
            return AuthOutcome.FAILED;
        }
        if (this.token.getIssuedAt() < this.deployment.getNotBefore()) {
            this.log.error((Object)"Stale token");
            this.challenge = this.challengeResponse(exchange, "invalid_token", "Stale token");
            return AuthOutcome.FAILED;
        }
        boolean verifyCaller = false;
        verifyCaller = this.deployment.isUseResourceRoleMappings() ? this.token.isVerifyCaller(this.deployment.getResourceName()) : this.token.isVerifyCaller();
        this.surrogate = null;
        if (verifyCaller) {
            if (this.token.getTrustedCertificates() == null || this.token.getTrustedCertificates().size() == 0) {
                this.log.warn((Object)"No trusted certificates in token");
                this.challenge = this.clientCertChallenge();
                return AuthOutcome.FAILED;
            }
            X509Certificate[] chain = new X509Certificate[]{};
            try {
                chain = exchange.getCertificateChain();
            }
            catch (Exception ignore) {
                // empty catch block
            }
            if (chain == null || chain.length == 0) {
                this.log.warn((Object)"No certificates provided by undertow to verify the caller");
                this.challenge = this.clientCertChallenge();
                return AuthOutcome.FAILED;
            }
            this.surrogate = chain[0].getSubjectDN().getName();
        }
        return AuthOutcome.AUTHENTICATED;
    }

    protected AuthChallenge clientCertChallenge() {
        return new AuthChallenge(){

            @Override
            public boolean errorPage() {
                return false;
            }

            @Override
            public boolean challenge(HttpFacade exchange) {
                return false;
            }
        };
    }

    protected AuthChallenge challengeResponse(HttpFacade facade, String error, String description) {
        StringBuilder header = new StringBuilder("Bearer realm=\"");
        header.append(this.deployment.getRealm()).append("\"");
        if (error != null) {
            header.append(", error=\"").append(error).append("\"");
        }
        if (description != null) {
            header.append(", error_description=\"").append(description).append("\"");
        }
        final String challenge = header.toString();
        return new AuthChallenge(){

            @Override
            public boolean errorPage() {
                return true;
            }

            @Override
            public boolean challenge(HttpFacade facade) {
                facade.getResponse().setStatus(401);
                facade.getResponse().addHeader("WWW-Authenticate", challenge);
                return true;
            }
        };
    }
}

