/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.protocol.spdy;

import io.undertow.UndertowMessages;
import io.undertow.UndertowOptions;
import io.undertow.protocols.spdy.SpdyChannel;
import io.undertow.server.DelegateOpenListener;
import io.undertow.server.HttpHandler;
import io.undertow.server.protocol.spdy.SpdyReceiveListener;
import java.nio.ByteBuffer;
import org.xnio.ChannelListener;
import org.xnio.OptionMap;
import org.xnio.Pool;
import org.xnio.Pooled;
import org.xnio.StreamConnection;

public final class SpdyOpenListener
implements ChannelListener<StreamConnection>,
DelegateOpenListener {
    public static final String SPDY_3_1 = "spdy/3.1";
    private final Pool<ByteBuffer> bufferPool;
    private final Pool<ByteBuffer> heapBufferPool;
    private final int bufferSize;
    private volatile HttpHandler rootHandler;
    private volatile OptionMap undertowOptions;

    public SpdyOpenListener(Pool<ByteBuffer> pool, Pool<ByteBuffer> heapBufferPool) {
        this(pool, heapBufferPool, OptionMap.EMPTY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SpdyOpenListener(Pool<ByteBuffer> pool, Pool<ByteBuffer> heapBufferPool, OptionMap undertowOptions) {
        this.undertowOptions = undertowOptions;
        this.bufferPool = pool;
        Pooled buf = pool.allocate();
        this.bufferSize = ((ByteBuffer)buf.getResource()).remaining();
        buf.free();
        this.heapBufferPool = heapBufferPool;
        Pooled buff = heapBufferPool.allocate();
        try {
            if (!((ByteBuffer)buff.getResource()).hasArray()) {
                throw UndertowMessages.MESSAGES.mustProvideHeapBuffer();
            }
        }
        finally {
            buff.free();
        }
    }

    public void handleEvent(StreamConnection channel) {
        this.handleEvent(channel, null);
    }

    @Override
    public void handleEvent(StreamConnection channel, Pooled<ByteBuffer> buffer) {
        SpdyChannel spdyChannel = new SpdyChannel(channel, this.bufferPool, buffer, this.heapBufferPool, false);
        Integer idleTimeout = (Integer)this.undertowOptions.get(UndertowOptions.IDLE_TIMEOUT);
        if (idleTimeout != null && idleTimeout > 0) {
            spdyChannel.setIdleTimeout(idleTimeout.intValue());
        }
        spdyChannel.getReceiveSetter().set((ChannelListener)new SpdyReceiveListener(this.rootHandler, this.getUndertowOptions(), this.bufferSize));
        spdyChannel.resumeReceives();
    }

    @Override
    public HttpHandler getRootHandler() {
        return this.rootHandler;
    }

    @Override
    public void setRootHandler(HttpHandler rootHandler) {
        this.rootHandler = rootHandler;
    }

    @Override
    public OptionMap getUndertowOptions() {
        return this.undertowOptions;
    }

    @Override
    public void setUndertowOptions(OptionMap undertowOptions) {
        if (undertowOptions == null) {
            throw UndertowMessages.MESSAGES.argumentCannotBeNull("undertowOptions");
        }
        this.undertowOptions = undertowOptions;
    }

    @Override
    public Pool<ByteBuffer> getBufferPool() {
        return this.bufferPool;
    }
}

