/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class WebSocketExtension {
    private final String name;
    private final List<Parameter> parameters;

    public WebSocketExtension(String name, List<Parameter> parameters) {
        this.name = name;
        this.parameters = Collections.unmodifiableList(new ArrayList<Parameter>(parameters));
    }

    public String getName() {
        return this.name;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public String toString() {
        return "WebSocketExtension{name='" + this.name + '\'' + ", parameters=" + this.parameters + '}';
    }

    public static List<WebSocketExtension> parse(String extensionHeader) {
        String[] parts;
        if (extensionHeader == null || extensionHeader.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<WebSocketExtension> extensions = new ArrayList<WebSocketExtension>();
        for (String part : parts = extensionHeader.split(",")) {
            String[] items = part.split(";");
            if (items.length <= 0) continue;
            ArrayList<Parameter> params = new ArrayList<Parameter>(items.length - 1);
            String name = items[0].trim();
            for (int i = 1; i < items.length; ++i) {
                String[] param = items[i].split("=");
                if (param.length != 2) continue;
                params.add(new Parameter(param[0].trim(), param[1].trim()));
            }
            extensions.add(new WebSocketExtension(name, params));
        }
        return extensions;
    }

    public static final class Parameter {
        private final String name;
        private final String value;

        public Parameter(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return "{'" + this.name + '\'' + ": '" + this.value + '\'' + '}';
        }
    }
}

