/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.authorization;

import java.security.PublicKey;
import java.util.Set;
import org.jboss.logging.Logger;
import org.keycloak.RSATokenVerifier;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.OIDCHttpFacade;
import org.keycloak.adapters.authorization.AbstractPolicyEnforcer;
import org.keycloak.adapters.authorization.PolicyEnforcer;
import org.keycloak.adapters.spi.HttpFacade;
import org.keycloak.authorization.client.AuthorizationDeniedException;
import org.keycloak.authorization.client.AuthzClient;
import org.keycloak.authorization.client.representation.AuthorizationRequest;
import org.keycloak.authorization.client.representation.AuthorizationResponse;
import org.keycloak.authorization.client.representation.EntitlementResponse;
import org.keycloak.authorization.client.representation.PermissionRequest;
import org.keycloak.authorization.client.representation.PermissionResponse;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.adapters.config.PolicyEnforcerConfig;

public class KeycloakAdapterPolicyEnforcer
extends AbstractPolicyEnforcer {
    private static Logger LOGGER = Logger.getLogger(KeycloakAdapterPolicyEnforcer.class);

    public KeycloakAdapterPolicyEnforcer(PolicyEnforcer policyEnforcer) {
        super(policyEnforcer);
    }

    @Override
    protected boolean isAuthorized(PolicyEnforcerConfig.PathConfig pathConfig, Set<String> requiredScopes, AccessToken accessToken, OIDCHttpFacade httpFacade) {
        AccessToken original = accessToken;
        for (int retry = 2; retry >= 0; --retry) {
            if (super.isAuthorized(pathConfig, requiredScopes, accessToken, httpFacade)) {
                original.setAuthorization(accessToken.getAuthorization());
                return true;
            }
            accessToken = this.requestAuthorizationToken(pathConfig, requiredScopes, httpFacade);
            if (accessToken != null) continue;
            return false;
        }
        return false;
    }

    @Override
    protected boolean challenge(PolicyEnforcerConfig.PathConfig pathConfig, Set<String> requiredScopes, OIDCHttpFacade facade) {
        String accessDeniedPath = this.getEnforcerConfig().getAccessDeniedPath();
        HttpFacade.Response response = facade.getResponse();
        if (accessDeniedPath != null) {
            response.setStatus(302);
            response.setHeader("Location", accessDeniedPath);
        } else {
            response.sendError(403);
        }
        return true;
    }

    private AccessToken requestAuthorizationToken(PolicyEnforcerConfig.PathConfig pathConfig, Set<String> requiredScopes, OIDCHttpFacade httpFacade) {
        try {
            String accessToken = httpFacade.getSecurityContext().getTokenString();
            AuthzClient authzClient = this.getAuthzClient();
            KeycloakDeployment deployment = this.getPolicyEnforcer().getDeployment();
            if (this.getEnforcerConfig().getUmaProtocolConfig() != null) {
                LOGGER.debug((Object)"Obtaining authorization for  authenticated user.");
                PermissionRequest permissionRequest = new PermissionRequest();
                permissionRequest.setResourceSetId(pathConfig.getId());
                permissionRequest.setScopes(requiredScopes);
                PermissionResponse permissionResponse = authzClient.protection().permission().forResource(permissionRequest);
                AuthorizationRequest authzRequest = new AuthorizationRequest(permissionResponse.getTicket());
                AuthorizationResponse authzResponse = authzClient.authorization(accessToken).authorize(authzRequest);
                if (authzResponse != null) {
                    return RSATokenVerifier.verifyToken((String)authzResponse.getRpt(), (PublicKey)deployment.getRealmKey(), (String)deployment.getRealmInfoUrl());
                }
                return null;
            }
            LOGGER.debug((Object)"Obtaining entitlements for authenticated user.");
            EntitlementResponse authzResponse = authzClient.entitlement(accessToken).getAll(authzClient.getConfiguration().getClientId());
            return RSATokenVerifier.verifyToken((String)authzResponse.getRpt(), (PublicKey)deployment.getRealmKey(), (String)deployment.getRealmInfoUrl());
        }
        catch (AuthorizationDeniedException e) {
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected error during authorization request.", e);
        }
    }
}

