/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.security.PublicKey;
import org.jboss.logging.Logger;
import org.keycloak.adapters.HttpClientBuilder;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.authentication.ClientCredentialsProviderUtils;
import org.keycloak.adapters.authorization.PolicyEnforcer;
import org.keycloak.adapters.rotation.HardcodedPublicKeyLocator;
import org.keycloak.adapters.rotation.JWKPublicKeyLocator;
import org.keycloak.common.enums.SslRequired;
import org.keycloak.common.util.PemUtils;
import org.keycloak.enums.TokenStore;
import org.keycloak.representations.adapters.config.AdapterConfig;
import org.keycloak.representations.adapters.config.AdapterHttpClientConfig;
import org.keycloak.representations.adapters.config.PolicyEnforcerConfig;
import org.keycloak.util.SystemPropertiesJsonParserFactory;

public class KeycloakDeploymentBuilder {
    private static final Logger log = Logger.getLogger(KeycloakDeploymentBuilder.class);
    protected KeycloakDeployment deployment = new KeycloakDeployment();

    protected KeycloakDeploymentBuilder() {
    }

    protected KeycloakDeployment internalBuild(AdapterConfig adapterConfig) {
        PolicyEnforcerConfig policyEnforcerConfig;
        if (adapterConfig.getRealm() == null) {
            throw new RuntimeException("Must set 'realm' in config");
        }
        this.deployment.setRealm(adapterConfig.getRealm());
        String resource = adapterConfig.getResource();
        if (resource == null) {
            throw new RuntimeException("Must set 'resource' in config");
        }
        this.deployment.setResourceName(resource);
        String realmKeyPem = adapterConfig.getRealmKey();
        if (realmKeyPem != null) {
            try {
                PublicKey realmKey = PemUtils.decodePublicKey((String)realmKeyPem);
                HardcodedPublicKeyLocator pkLocator = new HardcodedPublicKeyLocator(realmKey);
                this.deployment.setPublicKeyLocator(pkLocator);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            JWKPublicKeyLocator pkLocator = new JWKPublicKeyLocator();
            this.deployment.setPublicKeyLocator(pkLocator);
        }
        if (adapterConfig.getSslRequired() != null) {
            this.deployment.setSslRequired(SslRequired.valueOf((String)adapterConfig.getSslRequired().toUpperCase()));
        } else {
            this.deployment.setSslRequired(SslRequired.EXTERNAL);
        }
        if (adapterConfig.getTokenStore() != null) {
            this.deployment.setTokenStore(TokenStore.valueOf((String)adapterConfig.getTokenStore().toUpperCase()));
        } else {
            this.deployment.setTokenStore(TokenStore.SESSION);
        }
        if (adapterConfig.getPrincipalAttribute() != null) {
            this.deployment.setPrincipalAttribute(adapterConfig.getPrincipalAttribute());
        }
        this.deployment.setResourceCredentials(adapterConfig.getCredentials());
        this.deployment.setClientAuthenticator(ClientCredentialsProviderUtils.bootstrapClientAuthenticator(this.deployment));
        this.deployment.setPublicClient(adapterConfig.isPublicClient());
        this.deployment.setUseResourceRoleMappings(adapterConfig.isUseResourceRoleMappings());
        this.deployment.setExposeToken(adapterConfig.isExposeToken());
        if (adapterConfig.isCors()) {
            this.deployment.setCors(true);
            this.deployment.setCorsMaxAge(adapterConfig.getCorsMaxAge());
            this.deployment.setCorsAllowedHeaders(adapterConfig.getCorsAllowedHeaders());
            this.deployment.setCorsAllowedMethods(adapterConfig.getCorsAllowedMethods());
        }
        this.deployment.setBearerOnly(adapterConfig.isBearerOnly());
        this.deployment.setEnableBasicAuth(adapterConfig.isEnableBasicAuth());
        this.deployment.setAlwaysRefreshToken(adapterConfig.isAlwaysRefreshToken());
        this.deployment.setRegisterNodeAtStartup(adapterConfig.isRegisterNodeAtStartup());
        this.deployment.setRegisterNodePeriod(adapterConfig.getRegisterNodePeriod());
        this.deployment.setTokenMinimumTimeToLive(adapterConfig.getTokenMinimumTimeToLive());
        this.deployment.setMinTimeBetweenJwksRequests(adapterConfig.getMinTimeBetweenJwksRequests());
        if (realmKeyPem == null && adapterConfig.isBearerOnly() && adapterConfig.getAuthServerUrl() == null) {
            throw new IllegalArgumentException("For bearer auth, you must set the realm-public-key or auth-server-url");
        }
        if (realmKeyPem == null || !this.deployment.isBearerOnly() || this.deployment.isEnableBasicAuth() || this.deployment.isRegisterNodeAtStartup() || this.deployment.getRegisterNodePeriod() != -1) {
            this.deployment.setClient(new HttpClientBuilder().build((AdapterHttpClientConfig)adapterConfig));
        }
        if (!(adapterConfig.getAuthServerUrl() != null || this.deployment.isBearerOnly() && realmKeyPem != null)) {
            throw new RuntimeException("You must specify auth-server-url");
        }
        this.deployment.setAuthServerBaseUrl(adapterConfig);
        if (adapterConfig.getTurnOffChangeSessionIdOnLogin() != null) {
            this.deployment.setTurnOffChangeSessionIdOnLogin(adapterConfig.getTurnOffChangeSessionIdOnLogin());
        }
        if ((policyEnforcerConfig = adapterConfig.getPolicyEnforcerConfig()) != null) {
            this.deployment.setPolicyEnforcer(new PolicyEnforcer(this.deployment, adapterConfig));
        }
        log.debug((Object)("Use authServerUrl: " + this.deployment.getAuthServerBaseUrl() + ", tokenUrl: " + this.deployment.getTokenUrl() + ", relativeUrls: " + this.deployment.getRelativeUrls()));
        return this.deployment;
    }

    public static KeycloakDeployment build(InputStream is) {
        AdapterConfig adapterConfig = KeycloakDeploymentBuilder.loadAdapterConfig(is);
        return new KeycloakDeploymentBuilder().internalBuild(adapterConfig);
    }

    public static AdapterConfig loadAdapterConfig(InputStream is) {
        AdapterConfig adapterConfig;
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new SystemPropertiesJsonParserFactory());
        mapper.setSerializationInclusion(JsonInclude.Include.NON_DEFAULT);
        try {
            adapterConfig = (AdapterConfig)mapper.readValue(is, AdapterConfig.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return adapterConfig;
    }

    public static KeycloakDeployment build(AdapterConfig adapterConfig) {
        return new KeycloakDeploymentBuilder().internalBuild(adapterConfig);
    }
}

