/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.protocols.http2;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public class Http2PriorityTree {
    private final Http2PriorityNode rootNode;
    private final Map<Integer, Http2PriorityNode> nodesByID = new HashMap<Integer, Http2PriorityNode>();
    private int[] evictionQueue;
    private int evictionQueuePosition;

    public Http2PriorityTree() {
        this.rootNode = new Http2PriorityNode(0, 0);
        this.nodesByID.put(0, this.rootNode);
        this.evictionQueue = new int[10];
    }

    public void registerStream(int streamId, int dependency, int weighting, boolean exclusive) {
        Http2PriorityNode node = new Http2PriorityNode(streamId, weighting);
        if (exclusive) {
            Http2PriorityNode existing = this.nodesByID.get(dependency);
            if (existing != null) {
                existing.exclusive(node);
            }
        } else {
            Http2PriorityNode existing = this.nodesByID.get(dependency);
            if (existing != null) {
                existing.addDependent(node);
            }
        }
        this.nodesByID.put(streamId, node);
    }

    public void streamRemoved(int streamId) {
        Http2PriorityNode node = this.nodesByID.get(streamId);
        if (node == null) {
            return;
        }
        node.dead = true;
        if (!node.hasDependents()) {
            int toEvict = this.evictionQueue[this.evictionQueuePosition];
            this.evictionQueue[this.evictionQueuePosition++] = streamId;
            Http2PriorityNode nodeToEvict = this.nodesByID.get(toEvict);
            if (nodeToEvict != null && !nodeToEvict.hasDependents()) {
                this.nodesByID.remove(toEvict);
            }
        }
    }

    public Comparator<Integer> comparator() {
        return new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                Http2PriorityNode n1 = (Http2PriorityNode)Http2PriorityTree.this.nodesByID.get(o1);
                Http2PriorityNode n2 = (Http2PriorityNode)Http2PriorityTree.this.nodesByID.get(o2);
                if (n1 == null && n2 == null) {
                    return 0;
                }
                if (n1 == null) {
                    return -1;
                }
                if (n2 == null) {
                    return 1;
                }
                double d1 = Http2PriorityTree.this.createWeightingProportion(n1);
                double d2 = Http2PriorityTree.this.createWeightingProportion(n2);
                return Double.compare(d1, d2);
            }
        };
    }

    private double createWeightingProportion(Http2PriorityNode n1) {
        double ret = 1.0;
        Http2PriorityNode node = n1;
        while (node != null) {
            Http2PriorityNode parent = node.parent;
            if (parent != null) {
                ret *= (double)node.weighting / (double)parent.totalWeights;
            }
            node = parent;
        }
        return ret;
    }

    public void priorityFrame(int streamId, int streamDependency, int weight, boolean exlusive) {
        Http2PriorityNode newParent;
        Http2PriorityNode existing = this.nodesByID.get(streamId);
        if (existing == null) {
            return;
        }
        int dif = weight - existing.weighting;
        ((Http2PriorityNode)existing).parent.totalWeights += dif;
        existing.weighting = weight;
        if (exlusive) {
            Http2PriorityNode newParent2 = this.nodesByID.get(streamDependency);
            if (newParent2 != null) {
                existing.parent.removeDependent(existing);
                newParent2.exclusive(existing);
            }
        } else if (existing.parent.streamId != streamDependency && (newParent = this.nodesByID.get(streamDependency)) != null) {
            newParent.addDependent(existing);
        }
    }

    private static class Http2PriorityNode {
        private Http2PriorityNode parent;
        private final int streamId;
        int weighting;
        int totalWeights;
        private Http2PriorityNode[] dependents = null;
        private int dependency;
        boolean dead = false;

        Http2PriorityNode(int streamId, int weighting) {
            this.streamId = streamId;
            this.weighting = weighting;
        }

        void removeDependent(Http2PriorityNode node) {
            if (this.dependents == null) {
                return;
            }
            this.totalWeights -= node.weighting;
            boolean found = false;
            for (int i = 0; i < this.dependents.length - 1; ++i) {
                if (this.dependents[i] == node) {
                    found = true;
                }
                if (found) {
                    this.dependents[i] = this.dependents[i + i];
                }
                if (this.dependents[i] == null) break;
            }
            if (found) {
                this.dependents[i + 1] = null;
            }
        }

        boolean hasDependents() {
            return this.dependents != null && this.dependents[0] != null;
        }

        public void addDependent(Http2PriorityNode node) {
            int i;
            if (this.dependents == null) {
                this.dependents = new Http2PriorityNode[5];
            }
            boolean found = false;
            for (i = 0; i < this.dependents.length; ++i) {
                if (this.dependents[i] != null) continue;
                found = true;
                break;
            }
            if (!found) {
                Http2PriorityNode[] old = this.dependents;
                this.dependents = new Http2PriorityNode[this.dependents.length + 5];
                System.arraycopy(old, 0, this.dependents, 0, old.length);
                ++i;
            }
            this.dependents[i] = node;
            node.parent = this;
            this.totalWeights += node.weighting;
        }

        public void exclusive(Http2PriorityNode node) {
            if (this.dependents == null) {
                this.dependents = new Http2PriorityNode[5];
            }
            for (Http2PriorityNode i : this.dependents) {
                node.addDependent(i);
            }
            this.dependents[0] = node;
            for (int i = 1; i < this.dependents.length; ++i) {
                this.dependents[i] = null;
            }
            this.totalWeights = node.weighting;
        }
    }
}

