/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.proxy;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HttpString;
import java.util.HashMap;
import java.util.Map;
import org.keycloak.adapters.undertow.KeycloakUndertowAccount;
import org.keycloak.proxy.ConstraintMatcherHandler;
import org.keycloak.proxy.SecurityInfo;
import org.keycloak.proxy.SingleConstraintMatch;
import org.keycloak.representations.AccessToken;

public class ConstraintAuthorizationHandler
implements HttpHandler {
    public static final String KEYCLOAK_SUBJECT = "KEYCLOAK_SUBJECT";
    public static final String KEYCLOAK_USERNAME = "KEYCLOAK_USERNAME";
    public static final String KEYCLOAK_EMAIL = "KEYCLOAK_EMAIL";
    public static final String KEYCLOAK_NAME = "KEYCLOAK_NAME";
    public static final String KEYCLOAK_ACCESS_TOKEN = "KEYCLOAK_ACCESS_TOKEN";
    private final Map<String, HttpString> httpHeaderNames;
    protected HttpHandler next;
    protected String errorPage;
    protected boolean sendAccessToken;

    public ConstraintAuthorizationHandler(HttpHandler next, String errorPage, boolean sendAccessToken, Map<String, String> headerNames) {
        this.next = next;
        this.errorPage = errorPage;
        this.sendAccessToken = sendAccessToken;
        this.httpHeaderNames = new HashMap<String, HttpString>();
        this.httpHeaderNames.put(KEYCLOAK_SUBJECT, new HttpString(this.getOrDefault(headerNames, "keycloak-subject", KEYCLOAK_SUBJECT)));
        this.httpHeaderNames.put(KEYCLOAK_USERNAME, new HttpString(this.getOrDefault(headerNames, "keycloak-username", KEYCLOAK_USERNAME)));
        this.httpHeaderNames.put(KEYCLOAK_EMAIL, new HttpString(this.getOrDefault(headerNames, "keycloak-email", KEYCLOAK_EMAIL)));
        this.httpHeaderNames.put(KEYCLOAK_NAME, new HttpString(this.getOrDefault(headerNames, "keycloak-name", KEYCLOAK_NAME)));
        this.httpHeaderNames.put(KEYCLOAK_ACCESS_TOKEN, new HttpString(this.getOrDefault(headerNames, "keycloak-access-token", KEYCLOAK_ACCESS_TOKEN)));
    }

    private String getOrDefault(Map<String, String> map, String key, String defaultValue) {
        return map.containsKey(key) ? map.get(key) : defaultValue;
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        KeycloakUndertowAccount account = (KeycloakUndertowAccount)exchange.getSecurityContext().getAuthenticatedAccount();
        SingleConstraintMatch match = (SingleConstraintMatch)exchange.getAttachment(ConstraintMatcherHandler.CONSTRAINT_KEY);
        if (match == null || match.getRequiredRoles().isEmpty() && match.getEmptyRoleSemantic() == SecurityInfo.EmptyRoleSemantic.AUTHENTICATE) {
            this.authenticatedRequest(account, exchange);
            return;
        }
        if (match != null) {
            if (SecurityInfo.EmptyRoleSemantic.PERMIT_AND_INJECT_IF_AUTHENTICATED.equals((Object)match.getEmptyRoleSemantic())) {
                this.authenticatedRequest(account, exchange);
                return;
            }
            for (String role : match.getRequiredRoles()) {
                if (!account.getRoles().contains(role)) continue;
                this.authenticatedRequest(account, exchange);
                return;
            }
        }
        if (this.errorPage != null) {
            exchange.setRequestPath(this.errorPage);
            exchange.setRelativePath(this.errorPage);
            exchange.setResolvedPath(this.errorPage);
            this.next.handleRequest(exchange);
            return;
        }
        exchange.setResponseCode(403);
        exchange.endExchange();
    }

    public void authenticatedRequest(KeycloakUndertowAccount account, HttpServerExchange exchange) throws Exception {
        if (account != null) {
            AccessToken idToken = account.getKeycloakSecurityContext().getToken();
            if (idToken == null) {
                return;
            }
            if (idToken.getSubject() != null) {
                exchange.getRequestHeaders().put(this.httpHeaderNames.get(KEYCLOAK_SUBJECT), idToken.getSubject());
            }
            if (idToken.getPreferredUsername() != null) {
                exchange.getRequestHeaders().put(this.httpHeaderNames.get(KEYCLOAK_USERNAME), idToken.getPreferredUsername());
            }
            if (idToken.getEmail() != null) {
                exchange.getRequestHeaders().put(this.httpHeaderNames.get(KEYCLOAK_EMAIL), idToken.getEmail());
            }
            if (idToken.getName() != null) {
                exchange.getRequestHeaders().put(this.httpHeaderNames.get(KEYCLOAK_NAME), idToken.getName());
            }
            if (this.sendAccessToken) {
                exchange.getRequestHeaders().put(this.httpHeaderNames.get(KEYCLOAK_ACCESS_TOKEN), account.getKeycloakSecurityContext().getTokenString());
            }
        }
        this.next.handleRequest(exchange);
    }
}

