/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.proxy;

import io.undertow.Undertow;
import io.undertow.security.api.AuthenticationMode;
import io.undertow.security.handlers.AuthenticationMechanismsHandler;
import io.undertow.security.handlers.SecurityInitialHandler;
import io.undertow.security.idm.Account;
import io.undertow.security.idm.Credential;
import io.undertow.security.idm.IdentityManager;
import io.undertow.security.impl.CachedAuthenticatedSessionMechanism;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.PathHandler;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.server.handlers.proxy.ProxyClient;
import io.undertow.server.handlers.proxy.ProxyHandler;
import io.undertow.server.handlers.proxy.SimpleProxyClientProvider;
import io.undertow.server.session.InMemorySessionManager;
import io.undertow.server.session.SessionAttachmentHandler;
import io.undertow.server.session.SessionConfig;
import io.undertow.server.session.SessionCookieConfig;
import io.undertow.server.session.SessionManager;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.jboss.logging.Logger;
import org.keycloak.adapters.AdapterDeploymentContext;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.KeycloakDeploymentBuilder;
import org.keycloak.adapters.NodesRegistrationManagement;
import org.keycloak.adapters.undertow.UndertowAuthenticatedActionsHandler;
import org.keycloak.adapters.undertow.UndertowAuthenticationMechanism;
import org.keycloak.adapters.undertow.UndertowPreAuthActionsHandler;
import org.keycloak.adapters.undertow.UndertowUserSessionManagement;
import org.keycloak.common.enums.SslRequired;
import org.keycloak.common.util.CertificateUtils;
import org.keycloak.common.util.FindFile;
import org.keycloak.proxy.ConstraintAuthorizationHandler;
import org.keycloak.proxy.ConstraintMatcherHandler;
import org.keycloak.proxy.ProxyAuthenticationCallHandler;
import org.keycloak.proxy.ProxyConfig;
import org.keycloak.proxy.SecurityInfo;
import org.keycloak.proxy.SecurityPathMatches;
import org.keycloak.proxy.SslUtil;
import org.keycloak.representations.adapters.config.AdapterConfig;
import org.keycloak.util.SystemPropertiesJsonParserFactory;
import org.xnio.Option;

public class ProxyServerBuilder {
    protected static Logger log = Logger.getLogger(ProxyServerBuilder.class);
    public static final HttpHandler NOT_FOUND = new HttpHandler(){

        public void handleRequest(HttpServerExchange exchange) throws Exception {
            exchange.setResponseCode(404);
            exchange.endExchange();
        }
    };
    protected Undertow.Builder builder = Undertow.builder();
    protected PathHandler root = new PathHandler(NOT_FOUND);
    protected HttpHandler proxyHandler;
    protected boolean sendAccessToken;
    protected Map<String, String> headerNameConfig;

    public ProxyServerBuilder target(String uri) {
        SimpleProxyClientProvider provider = null;
        try {
            provider = new SimpleProxyClientProvider(new URI(uri));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        ProxyHandler handler = new ProxyHandler((ProxyClient)provider, 30000, (HttpHandler)ResponseCodeHandler.HANDLE_404);
        this.proxyHandler = new HttpHandler((HttpHandler)handler){
            final /* synthetic */ HttpHandler val$handler;
            {
                this.val$handler = httpHandler;
            }

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                exchange.setRelativePath(exchange.getRequestPath());
                this.val$handler.handleRequest(exchange);
            }
        };
        return this;
    }

    public ProxyServerBuilder sendAccessToken(boolean flag) {
        this.sendAccessToken = flag;
        return this;
    }

    public ProxyServerBuilder headerNameConfig(Map<String, String> headerNameConfig) {
        this.headerNameConfig = headerNameConfig;
        return this;
    }

    public ApplicationBuilder application(AdapterConfig config) {
        return new ApplicationBuilder(config);
    }

    public Undertow build() {
        this.builder.setHandler((HttpHandler)this.root);
        return this.builder.build();
    }

    public ProxyServerBuilder addHttpListener(int port, String host) {
        this.builder.addHttpListener(port, host);
        return this;
    }

    public ProxyServerBuilder addHttpsListener(int port, String host, KeyManager[] keyManagers, TrustManager[] trustManagers) {
        this.builder.addHttpsListener(port, host, keyManagers, trustManagers);
        return this;
    }

    public ProxyServerBuilder addHttpsListener(int port, String host, SSLContext sslContext) {
        this.builder.addHttpsListener(port, host, sslContext);
        return this;
    }

    public ProxyServerBuilder setBufferSize(int bufferSize) {
        this.builder.setBufferSize(bufferSize);
        return this;
    }

    public ProxyServerBuilder setBuffersPerRegion(int buffersPerRegion) {
        this.builder.setBuffersPerRegion(buffersPerRegion);
        return this;
    }

    public ProxyServerBuilder setIoThreads(int ioThreads) {
        this.builder.setIoThreads(ioThreads);
        return this;
    }

    public ProxyServerBuilder setWorkerThreads(int workerThreads) {
        this.builder.setWorkerThreads(workerThreads);
        return this;
    }

    public ProxyServerBuilder setDirectBuffers(boolean directBuffers) {
        this.builder.setDirectBuffers(directBuffers);
        return this;
    }

    public <T> ProxyServerBuilder setServerOption(Option<T> option, T value) {
        this.builder.setServerOption(option, value);
        return this;
    }

    public <T> ProxyServerBuilder setSocketOption(Option<T> option, T value) {
        this.builder.setSocketOption(option, value);
        return this;
    }

    public <T> ProxyServerBuilder setWorkerOption(Option<T> option, T value) {
        this.builder.setWorkerOption(option, value);
        return this;
    }

    public static ProxyConfig loadConfig(InputStream is) {
        ProxyConfig proxyConfig;
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new SystemPropertiesJsonParserFactory());
        mapper.setSerializationInclusion(JsonSerialize.Inclusion.NON_DEFAULT);
        try {
            proxyConfig = (ProxyConfig)mapper.readValue(is, ProxyConfig.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return proxyConfig;
    }

    public static Undertow build(InputStream configStream) {
        ProxyConfig config = ProxyServerBuilder.loadConfig(configStream);
        return ProxyServerBuilder.build(config);
    }

    public static Undertow build(ProxyConfig config) {
        ProxyServerBuilder builder = new ProxyServerBuilder();
        if (config.getTargetUrl() == null) {
            log.error((Object)"Must set Target URL");
            return null;
        }
        builder.target(config.getTargetUrl());
        if (config.getApplications() == null || config.getApplications().size() == 0) {
            log.error((Object)"No applications defined");
            return null;
        }
        ProxyServerBuilder.initConnections(config, builder);
        ProxyServerBuilder.initOptions(config, builder);
        for (ProxyConfig.Application application : config.getApplications()) {
            ApplicationBuilder applicationBuilder = builder.application(application.getAdapterConfig()).base(application.getBasePath()).errorPage(application.getErrorPage());
            if (application.getConstraints() != null) {
                for (ProxyConfig.Constraint constraint : application.getConstraints()) {
                    ApplicationBuilder.ConstraintBuilder constraintBuilder = applicationBuilder.constraint(constraint.getPattern());
                    if (constraint.getRolesAllowed() != null) {
                        constraintBuilder.roles(constraint.getRolesAllowed());
                    }
                    if (constraint.getMethods() != null) {
                        constraintBuilder.methods(constraint.getMethods());
                    }
                    if (constraint.getExcludedMethods() != null) {
                        constraintBuilder.excludedMethods(constraint.getExcludedMethods());
                    }
                    if (constraint.isDeny()) {
                        constraintBuilder.deny();
                    }
                    if (constraint.isPermit()) {
                        constraintBuilder.permit();
                    }
                    if (constraint.isAuthenticate()) {
                        constraintBuilder.authenticate();
                    }
                    if (constraint.isPermitAndInject()) {
                        constraintBuilder.injectIfAuthenticated();
                    }
                    constraintBuilder.add();
                }
            }
            applicationBuilder.add();
        }
        return builder.build();
    }

    public static void initOptions(ProxyConfig config, ProxyServerBuilder builder) {
        builder.sendAccessToken(config.isSendAccessToken());
        builder.headerNameConfig(config.getHeaderNames());
        if (config.getBufferSize() != null) {
            builder.setBufferSize(config.getBufferSize());
        }
        if (config.getBuffersPerRegion() != null) {
            builder.setBuffersPerRegion(config.getBuffersPerRegion());
        }
        if (config.getIoThreads() != null) {
            builder.setIoThreads(config.getIoThreads());
        }
        if (config.getWorkerThreads() != null) {
            builder.setWorkerThreads(config.getWorkerThreads());
        }
        if (config.getDirectBuffers() != null) {
            builder.setDirectBuffers(config.getDirectBuffers());
        }
    }

    public static void initConnections(ProxyConfig config, ProxyServerBuilder builder) {
        String bindAddress;
        if (config.getHttpPort() == null && config.getHttpsPort() == null) {
            log.warn((Object)"You have not set up HTTP or HTTPS");
        }
        if (config.getHttpPort() != null) {
            bindAddress = "localhost";
            if (config.getBindAddress() != null) {
                bindAddress = config.getBindAddress();
            }
            builder.addHttpListener(config.getHttpPort(), bindAddress);
        }
        if (config.getHttpsPort() != null) {
            bindAddress = "localhost";
            if (config.getBindAddress() != null) {
                bindAddress = config.getBindAddress();
            }
            if (config.getKeystore() != null) {
                InputStream is = FindFile.findFile((String)config.getKeystore());
                SSLContext sslContext = null;
                try {
                    KeyStore keystore = KeyStore.getInstance("jks");
                    keystore.load(is, config.getKeystorePassword().toCharArray());
                    sslContext = SslUtil.createSSLContext(keystore, config.getKeyPassword(), null);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                builder.addHttpsListener(config.getHttpsPort(), bindAddress, sslContext);
            } else {
                log.warn((Object)"Generating temporary SSL cert");
                KeyPair keyPair = null;
                try {
                    KeyPairGenerator generator = KeyPairGenerator.getInstance("RSA");
                    generator.initialize(2048);
                    keyPair = generator.generateKeyPair();
                }
                catch (NoSuchAlgorithmException e) {
                    throw new RuntimeException(e);
                }
                X509Certificate certificate = null;
                try {
                    certificate = CertificateUtils.generateV1SelfSignedCertificate((KeyPair)keyPair, (String)bindAddress);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                try {
                    KeyStore keyStore = KeyStore.getInstance("JKS");
                    keyStore.load(null, null);
                    PrivateKey privateKey = keyPair.getPrivate();
                    Certificate[] chain = new Certificate[]{certificate};
                    keyStore.setKeyEntry(bindAddress, privateKey, "password".toCharArray(), chain);
                    SSLContext sslContext = SslUtil.createSSLContext(keyStore, "password", null);
                    builder.addHttpsListener(config.getHttpsPort(), bindAddress, sslContext);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public class ApplicationBuilder {
        protected NodesRegistrationManagement nodesRegistrationManagement = new NodesRegistrationManagement();
        protected UndertowUserSessionManagement userSessionManagement = new UndertowUserSessionManagement();
        protected AdapterDeploymentContext deploymentContext;
        protected KeycloakDeployment deployment;
        SessionManager sessionManager = new InMemorySessionManager("SESSION_MANAGER");
        protected String base;
        protected SecurityPathMatches.Builder constraintBuilder = new SecurityPathMatches.Builder();
        protected SecurityPathMatches matches;
        protected String errorPage;

        public ApplicationBuilder base(String base) {
            this.base = base;
            return this;
        }

        public ApplicationBuilder errorPage(String errorPage) {
            if (errorPage != null && errorPage.startsWith("/")) {
                errorPage = errorPage.substring(1);
            }
            this.errorPage = errorPage;
            return this;
        }

        public ApplicationBuilder(AdapterConfig config) {
            this.deployment = KeycloakDeploymentBuilder.build((AdapterConfig)config);
            this.deploymentContext = new AdapterDeploymentContext(this.deployment);
        }

        public ProxyServerBuilder add() {
            this.matches = this.constraintBuilder.build();
            HttpHandler handler = this.sessionHandling(this.addSecurity(ProxyServerBuilder.this.proxyHandler));
            ProxyServerBuilder.this.root.addPrefixPath(this.base, handler);
            return ProxyServerBuilder.this;
        }

        public ConstraintBuilder constraint(String pattern) {
            log.debugv("add constraint: {0}", (Object)pattern);
            return new ConstraintBuilder(pattern);
        }

        private HttpHandler addSecurity(HttpHandler toWrap) {
            HttpHandler handler = toWrap;
            handler = new UndertowAuthenticatedActionsHandler(this.deploymentContext, toWrap);
            if (this.errorPage != null) {
                this.errorPage = this.base.endsWith("/") ? this.base + this.errorPage : this.base + "/" + this.errorPage;
            }
            handler = new ConstraintAuthorizationHandler(handler, this.errorPage, ProxyServerBuilder.this.sendAccessToken, ProxyServerBuilder.this.headerNameConfig);
            handler = new ProxyAuthenticationCallHandler(handler);
            handler = new ConstraintMatcherHandler(this.matches, handler, toWrap, this.errorPage);
            LinkedList<Object> mechanisms = new LinkedList<Object>();
            mechanisms.add(new CachedAuthenticatedSessionMechanism());
            mechanisms.add(new UndertowAuthenticationMechanism(this.deploymentContext, this.userSessionManagement, this.nodesRegistrationManagement, -1, null));
            handler = new AuthenticationMechanismsHandler(handler, mechanisms);
            IdentityManager identityManager = new IdentityManager(){

                public Account verify(Account account) {
                    return account;
                }

                public Account verify(String id, Credential credential) {
                    throw new IllegalStateException("Should never be called in Keycloak flow");
                }

                public Account verify(Credential credential) {
                    throw new IllegalStateException("Should never be called in Keycloak flow");
                }
            };
            handler = new UndertowPreAuthActionsHandler(this.deploymentContext, this.userSessionManagement, this.sessionManager, handler);
            return new SecurityInitialHandler(AuthenticationMode.PRO_ACTIVE, identityManager, handler);
        }

        private HttpHandler sessionHandling(HttpHandler toWrap) {
            SessionCookieConfig sessionConfig = new SessionCookieConfig();
            sessionConfig.setCookieName("keycloak." + this.deployment.getResourceName() + ".session");
            sessionConfig.setPath(this.base);
            if (this.deployment.getSslRequired() == SslRequired.ALL) {
                sessionConfig.setSecure(true);
            }
            toWrap = new SessionAttachmentHandler(toWrap, this.sessionManager, (SessionConfig)sessionConfig);
            return toWrap;
        }

        public class ConstraintBuilder {
            protected String pattern;
            protected Set<String> rolesAllowed = new HashSet<String>();
            protected Set<String> methods = new HashSet<String>();
            protected Set<String> excludedMethods = new HashSet<String>();
            protected SecurityInfo.EmptyRoleSemantic semantic = SecurityInfo.EmptyRoleSemantic.AUTHENTICATE;

            public ConstraintBuilder(String pattern) {
                this.pattern = pattern;
            }

            public ConstraintBuilder deny() {
                this.semantic = SecurityInfo.EmptyRoleSemantic.DENY;
                return this;
            }

            public ConstraintBuilder permit() {
                this.semantic = SecurityInfo.EmptyRoleSemantic.PERMIT;
                return this;
            }

            public ConstraintBuilder authenticate() {
                this.semantic = SecurityInfo.EmptyRoleSemantic.AUTHENTICATE;
                return this;
            }

            public ConstraintBuilder injectIfAuthenticated() {
                this.semantic = SecurityInfo.EmptyRoleSemantic.PERMIT_AND_INJECT_IF_AUTHENTICATED;
                return this;
            }

            public ConstraintBuilder excludedMethods(Set<String> excludedMethods) {
                this.excludedMethods = excludedMethods;
                return this;
            }

            public ConstraintBuilder methods(Set<String> methods) {
                this.methods = methods;
                return this;
            }

            public ConstraintBuilder method(String method) {
                this.methods.add(method);
                return this;
            }

            public ConstraintBuilder excludeMethod(String method) {
                this.excludedMethods.add(method);
                return this;
            }

            public ConstraintBuilder roles(String ... roles) {
                for (String role : roles) {
                    this.role(role);
                }
                return this;
            }

            public ConstraintBuilder roles(Set<String> roles) {
                for (String role : roles) {
                    this.role(role);
                }
                return this;
            }

            public ConstraintBuilder role(String role) {
                this.rolesAllowed.add(role);
                return this;
            }

            public ApplicationBuilder add() {
                ApplicationBuilder.this.constraintBuilder.addSecurityConstraint(this.rolesAllowed, this.semantic, this.pattern, this.methods, this.excludedMethods);
                return ApplicationBuilder.this;
            }
        }
    }
}

