/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.it.junit5.extension;

import io.quarkus.test.junit.QuarkusMainTestExtension;
import io.quarkus.test.junit.main.Launch;
import io.quarkus.test.junit.main.LaunchResult;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.keycloak.it.junit5.extension.CLIResult;
import org.keycloak.it.junit5.extension.DistributionTest;
import org.keycloak.it.junit5.extension.DistributionType;
import org.keycloak.it.utils.KeycloakDistribution;
import org.keycloak.quarkus.runtime.Environment;

public class CLITestExtension
extends QuarkusMainTestExtension {
    private KeycloakDistribution dist;

    public void beforeEach(ExtensionContext context) throws Exception {
        DistributionTest distConfig = this.getDistributionConfig(context);
        if (distConfig != null) {
            Launch launch = context.getRequiredTestMethod().getAnnotation(Launch.class);
            if (launch != null) {
                if (this.dist == null) {
                    this.dist = this.createDistribution(distConfig);
                }
                this.dist.start(Arrays.asList(launch.value()));
            }
        } else {
            this.configureProfile(context);
            super.beforeEach(context);
        }
    }

    public void afterEach(ExtensionContext context) throws Exception {
        DistributionTest distConfig = this.getDistributionConfig(context);
        if (distConfig != null && distConfig.keepAlive()) {
            this.dist.stop();
        }
        super.afterEach(context);
    }

    public void afterAll(ExtensionContext context) throws Exception {
        if (this.dist != null) {
            this.dist.stop();
        }
        super.afterAll(context);
    }

    private KeycloakDistribution createDistribution(DistributionTest config) {
        return DistributionType.getCurrent().orElse(DistributionType.RAW).newInstance(config);
    }

    public void beforeAll(ExtensionContext context) throws Exception {
        DistributionTest distConfig = this.getDistributionConfig(context);
        if (distConfig != null) {
            if (DistributionTest.ReInstall.BEFORE_ALL.equals((Object)distConfig.reInstall())) {
                this.dist = this.createDistribution(distConfig);
            }
        } else {
            Environment.forceTestLaunchMode();
        }
        super.beforeAll(context);
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext context) throws ParameterResolutionException {
        Class<?> type = parameterContext.getParameter().getType();
        if (type == LaunchResult.class) {
            int exitCode;
            List errStream;
            List outputStream;
            boolean isDistribution;
            boolean bl = isDistribution = this.getDistributionConfig(context) != null;
            if (isDistribution) {
                outputStream = this.dist.getOutputStream();
                errStream = this.dist.getErrorStream();
                exitCode = this.dist.getExitCode();
            } else {
                LaunchResult result = (LaunchResult)super.resolveParameter(parameterContext, context);
                outputStream = result.getOutputStream();
                errStream = result.getErrorStream();
                exitCode = result.exitCode();
            }
            return CLIResult.create(outputStream, errStream, exitCode, isDistribution);
        }
        throw new RuntimeException("Parameter type [" + type + "] not supported");
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        Class<?> type = parameterContext.getParameter().getType();
        return type == LaunchResult.class;
    }

    private void configureProfile(ExtensionContext context) {
        List<String> cliArgs = this.getCliArgs(context);
        if (cliArgs.contains("start")) {
            Environment.setProfile((String)"prod");
        } else if (cliArgs.contains("start-dev")) {
            Environment.forceDevProfile();
        }
    }

    private List<String> getCliArgs(ExtensionContext context) {
        Launch annotation = context.getRequiredTestMethod().getAnnotation(Launch.class);
        if (annotation != null) {
            return Arrays.asList(annotation.value());
        }
        return Collections.emptyList();
    }

    private DistributionTest getDistributionConfig(ExtensionContext context) {
        return ((Class)context.getTestClass().get()).getDeclaredAnnotation(DistributionTest.class);
    }
}

