/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.it.junit5.extension;

import io.quarkus.test.junit.main.LaunchResult;
import java.util.List;
import org.approvaltests.Approvals;
import org.junit.jupiter.api.Assertions;

public interface CLIResult
extends LaunchResult {
    public static Object create(final List<String> outputStream, final List<String> errStream, final int exitCode) {
        return new CLIResult(){

            public List<String> getOutputStream() {
                return outputStream;
            }

            public List<String> getErrorStream() {
                return errStream;
            }

            public int exitCode() {
                return exitCode;
            }
        };
    }

    default public void assertStarted() {
        Assertions.assertFalse((boolean)this.getOutput().contains("The delayed handler's queue was overrun and log record(s) were lost (Did you forget to configure logging?)"), () -> "The standard Output:\n" + this.getOutput() + "should not contain a warning about log queue overrun.");
        Assertions.assertTrue((boolean)this.getOutput().contains("Listening on:"), () -> "The standard output:\n" + this.getOutput() + "does include \"Listening on:\"");
        this.assertNotDevMode();
    }

    default public void assertNotDevMode() {
        Assertions.assertFalse((boolean)this.getOutput().contains("Running the server in dev mode."), () -> "The standard output:\n" + this.getOutput() + "\ndoes include the Start Dev output");
    }

    default public void assertStartedDevMode() {
        Assertions.assertTrue((boolean)this.getOutput().contains("Running the server in dev mode."), () -> "The standard output:\n" + this.getOutput() + "\ndoesn't include the Start Dev output");
    }

    default public void assertError(String msg) {
        Assertions.assertTrue((boolean)this.getErrorOutput().contains(msg), () -> "The Error Output:\n " + this.getErrorOutput() + "\ndoesn't contains " + msg);
    }

    default public void assertHelp() {
        try {
            Approvals.verify((String)this.getOutput());
        }
        catch (Exception cause) {
            throw new RuntimeException("Failed to assert help", cause);
        }
    }

    default public void assertMessage(String message) {
        Assertions.assertTrue((boolean)this.getOutput().contains(message));
    }
}

