/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.it.junit5.extension;

import java.util.Optional;
import java.util.function.Function;
import org.keycloak.it.junit5.extension.DistributionTest;
import org.keycloak.it.utils.DockerKeycloakDistribution;
import org.keycloak.it.utils.KeycloakDistribution;
import org.keycloak.it.utils.RawKeycloakDistribution;
import org.keycloak.utils.StringUtil;

public enum DistributionType {
    RAW(DistributionType::createRawDistribution),
    DOCKER(DistributionType::createDockerDistribution);

    private final Function<DistributionTest, KeycloakDistribution> factory;

    private static KeycloakDistribution createDockerDistribution(DistributionTest config) {
        return new DockerKeycloakDistribution(config.debug(), config.keepAlive(), !DistributionTest.ReInstall.NEVER.equals((Object)config.reInstall()));
    }

    private static KeycloakDistribution createRawDistribution(DistributionTest config) {
        return new RawKeycloakDistribution(config.debug(), config.keepAlive(), !DistributionTest.ReInstall.NEVER.equals((Object)config.reInstall()));
    }

    private DistributionType(Function<DistributionTest, KeycloakDistribution> factory) {
        this.factory = factory;
    }

    public static Optional<DistributionType> getCurrent() {
        String distributionType = System.getProperty("kc.quarkus.tests.dist");
        if (StringUtil.isBlank((String)distributionType)) {
            return Optional.empty();
        }
        try {
            return Optional.of(DistributionType.valueOf(distributionType.toUpperCase()));
        }
        catch (IllegalStateException cause) {
            throw new RuntimeException("Invalid distribution type: " + distributionType);
        }
    }

    public KeycloakDistribution newInstance(DistributionTest config) {
        return this.factory.apply(config);
    }
}

