/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.persistence.EntityManagerFactory;
import javax.ws.rs.ApplicationPath;
import org.jboss.resteasy.spi.ResteasyDeployment;
import org.keycloak.QuarkusKeycloakSessionFactory;
import org.keycloak.common.util.Resteasy;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.utils.PostMigrationEvent;
import org.keycloak.provider.ProviderEvent;
import org.keycloak.provider.quarkus.QuarkusPlatform;
import org.keycloak.services.resources.KeycloakApplication;
import org.keycloak.services.resources.QuarkusWelcomeResource;
import org.keycloak.services.resources.WelcomeResource;

@ApplicationPath(value="/")
public class QuarkusKeycloakApplication
extends KeycloakApplication {
    @Inject
    Instance<EntityManagerFactory> entityManagerFactory;

    protected void startup() {
        try {
            this.forceEntityManagerInitialization();
            this.initializeKeycloakSessionFactory();
            QuarkusKeycloakApplication.setupScheduledTasks((KeycloakSessionFactory)sessionFactory);
        }
        catch (Throwable cause) {
            QuarkusPlatform.exitOnError(cause);
        }
    }

    public Set<Object> getSingletons() {
        ((ResteasyDeployment)Resteasy.getContextData(ResteasyDeployment.class)).setProperty("resteasy.disable.html.sanitizer", (Object)Boolean.TRUE);
        HashSet<Object> singletons = new HashSet<Object>(super.getSingletons().stream().filter(new Predicate<Object>(){

            @Override
            public boolean test(Object o) {
                return !WelcomeResource.class.isInstance(o);
            }
        }).collect(Collectors.toSet()));
        singletons.add(new QuarkusWelcomeResource());
        return singletons;
    }

    private void initializeKeycloakSessionFactory() {
        QuarkusKeycloakSessionFactory instance = QuarkusKeycloakSessionFactory.getInstance();
        sessionFactory = instance;
        instance.init();
        sessionFactory.publish((ProviderEvent)new PostMigrationEvent());
    }

    private void forceEntityManagerInitialization() {
        ((EntityManagerFactory)this.entityManagerFactory.get()).createEntityManager().close();
    }
}

