/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.jboss.logging.Logger;
import org.keycloak.common.ClientConnection;
import org.keycloak.common.Version;
import org.keycloak.common.util.Base64Url;
import org.keycloak.common.util.MimeTypeUtil;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.services.ForbiddenException;
import org.keycloak.services.ServicesLogger;
import org.keycloak.services.managers.ApplianceBootstrap;
import org.keycloak.services.resources.WelcomeResource;
import org.keycloak.services.util.CacheControlUtil;
import org.keycloak.services.util.CookieHelper;
import org.keycloak.theme.FreeMarkerUtil;
import org.keycloak.theme.Theme;
import org.keycloak.urls.UrlType;

@Path(value="/")
public class QuarkusWelcomeResource {
    protected static final Logger logger = Logger.getLogger(WelcomeResource.class);
    private static final String KEYCLOAK_STATE_CHECKER = "WELCOME_STATE_CHECKER";
    private AtomicBoolean shouldBootstrap;
    @Context
    protected HttpHeaders headers;
    @Context
    private KeycloakSession session;

    @GET
    @Produces(value={"text/html; charset=utf-8"})
    public Response getWelcomePage() throws URISyntaxException {
        String requestUri = this.session.getContext().getUri().getRequestUri().toString();
        if (!requestUri.endsWith("/")) {
            return Response.seeOther((URI)new URI(requestUri + "/")).build();
        }
        return this.createWelcomePage(null, null);
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"text/html; charset=utf-8"})
    public Response createUser(MultivaluedMap<String, String> formData) {
        if (!this.shouldBootstrap()) {
            return this.createWelcomePage(null, null);
        }
        if (!this.isLocal()) {
            ServicesLogger.LOGGER.rejectedNonLocalAttemptToCreateInitialUser(this.session.getContext().getConnection().getRemoteAddr());
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        this.csrfCheck(formData);
        String username = (String)formData.getFirst((Object)"username");
        String password = (String)formData.getFirst((Object)"password");
        String passwordConfirmation = (String)formData.getFirst((Object)"passwordConfirmation");
        if (username != null) {
            username = username.trim();
        }
        if (username == null || username.length() == 0) {
            return this.createWelcomePage(null, "Username is missing");
        }
        if (password == null || password.length() == 0) {
            return this.createWelcomePage(null, "Password is missing");
        }
        if (!password.equals(passwordConfirmation)) {
            return this.createWelcomePage(null, "Password and confirmation doesn't match");
        }
        this.expireCsrfCookie();
        ApplianceBootstrap applianceBootstrap = new ApplianceBootstrap(this.session);
        applianceBootstrap.createMasterRealmUser(username, password);
        this.shouldBootstrap.set(false);
        ServicesLogger.LOGGER.createdInitialAdminUser(username);
        return this.createWelcomePage("User created", null);
    }

    @GET
    @Path(value="/welcome-content/{path}")
    @Produces(value={"text/html; charset=utf-8"})
    public Response getResource(@PathParam(value="path") String path) {
        try {
            InputStream resource = this.getTheme().getResourceAsStream(path);
            if (resource != null) {
                String contentType = MimeTypeUtil.getContentType((String)path);
                Response.ResponseBuilder builder = Response.ok((Object)resource).type(contentType).cacheControl(CacheControlUtil.getDefaultCacheControl());
                return builder.build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (IOException e) {
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private Response createWelcomePage(String successMessage, String errorMessage) {
        try {
            Theme theme = this.getTheme();
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("productName", Version.NAME);
            map.put("productNameFull", Version.NAME_FULL);
            map.put("properties", theme.getProperties());
            map.put("adminUrl", this.session.getContext().getUri(UrlType.ADMIN).getBaseUriBuilder().path("/admin/").build(new Object[0]));
            map.put("resourcesPath", "resources/" + Version.RESOURCES_VERSION + "/" + theme.getType().toString().toLowerCase() + "/" + theme.getName());
            map.put("resourcesCommonPath", "resources/" + Version.RESOURCES_VERSION + "/common/keycloak");
            boolean bootstrap = this.shouldBootstrap();
            map.put("bootstrap", bootstrap);
            if (bootstrap) {
                boolean isLocal = this.isLocal();
                map.put("localUser", isLocal);
                if (isLocal) {
                    String stateChecker = this.setCsrfCookie();
                    map.put("stateChecker", stateChecker);
                }
            }
            if (successMessage != null) {
                map.put("successMessage", successMessage);
            }
            if (errorMessage != null) {
                map.put("errorMessage", errorMessage);
            }
            FreeMarkerUtil freeMarkerUtil = new FreeMarkerUtil();
            String result = freeMarkerUtil.processTemplate(map, "index.ftl", theme);
            Response.ResponseBuilder rb = Response.status((Response.Status)(errorMessage == null ? Response.Status.OK : Response.Status.BAD_REQUEST)).entity((Object)result).cacheControl(CacheControlUtil.noCache());
            return rb.build();
        }
        catch (Exception e) {
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private Theme getTheme() {
        try {
            return this.session.theme().getTheme(Theme.Type.WELCOME);
        }
        catch (IOException e) {
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean shouldBootstrap() {
        if (this.shouldBootstrap == null) {
            QuarkusWelcomeResource quarkusWelcomeResource = this;
            synchronized (quarkusWelcomeResource) {
                if (this.shouldBootstrap == null) {
                    this.shouldBootstrap = new AtomicBoolean(new ApplianceBootstrap(this.session).isNoMasterUser());
                }
            }
        }
        return this.shouldBootstrap.get();
    }

    private boolean isLocal() {
        try {
            ClientConnection clientConnection = this.session.getContext().getConnection();
            InetAddress remoteInetAddress = InetAddress.getByName(clientConnection.getRemoteAddr());
            InetAddress localInetAddress = InetAddress.getByName(clientConnection.getLocalAddr());
            String xForwardedFor = this.headers.getHeaderString("X-Forwarded-For");
            logger.debugf("Checking WelcomePage. Remote address: %s, Local address: %s, X-Forwarded-For header: %s", (Object)remoteInetAddress.toString(), (Object)localInetAddress.toString(), (Object)xForwardedFor);
            return this.isLocalAddress(remoteInetAddress) && this.isLocalAddress(localInetAddress) && xForwardedFor == null;
        }
        catch (UnknownHostException e) {
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private boolean isLocalAddress(InetAddress inetAddress) {
        return inetAddress.isAnyLocalAddress() || inetAddress.isLoopbackAddress();
    }

    private String setCsrfCookie() {
        String stateChecker = Base64Url.encode((byte[])KeycloakModelUtils.generateSecret());
        String cookiePath = this.session.getContext().getUri().getPath();
        boolean secureOnly = this.session.getContext().getUri().getRequestUri().getScheme().equalsIgnoreCase("https");
        CookieHelper.addCookie((String)KEYCLOAK_STATE_CHECKER, (String)stateChecker, (String)cookiePath, null, null, (int)300, (boolean)secureOnly, (boolean)true);
        return stateChecker;
    }

    private void expireCsrfCookie() {
        String cookiePath = this.session.getContext().getUri().getPath();
        boolean secureOnly = this.session.getContext().getUri().getRequestUri().getScheme().equalsIgnoreCase("https");
        CookieHelper.addCookie((String)KEYCLOAK_STATE_CHECKER, (String)"", (String)cookiePath, null, null, (int)0, (boolean)secureOnly, (boolean)true);
    }

    private void csrfCheck(MultivaluedMap<String, String> formData) {
        String formStateChecker = (String)formData.getFirst((Object)"stateChecker");
        Cookie cookie = (Cookie)this.headers.getCookies().get(KEYCLOAK_STATE_CHECKER);
        if (cookie == null) {
            throw new ForbiddenException();
        }
        String cookieStateChecker = cookie.getValue();
        if (cookieStateChecker == null || !cookieStateChecker.equals(formStateChecker)) {
            throw new ForbiddenException();
        }
    }
}

