/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.configuration;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.ConfigSourceProvider;
import org.jboss.logging.Logger;
import org.keycloak.configuration.ConfigArgsConfigSource;
import org.keycloak.configuration.KeycloakPropertiesConfigSource;
import org.keycloak.configuration.PersistedConfigSource;
import org.keycloak.configuration.SysPropConfigSource;
import org.keycloak.util.Environment;

public class KeycloakConfigSourceProvider
implements ConfigSourceProvider {
    private static final Logger log = Logger.getLogger(KeycloakConfigSourceProvider.class);
    public static final String KEYCLOAK_CONFIG_FILE_ENV = "KC_CONFIG_FILE";
    public static final String KEYCLOAK_CONFIG_FILE_PROP = "kc.config.file";
    private static final List<ConfigSource> CONFIG_SOURCES = new ArrayList<ConfigSource>();
    public static PersistedConfigSource PERSISTED_CONFIG_SOURCE;

    private static void initializeSources() {
        String profile = Environment.getProfile();
        if (profile != null) {
            System.setProperty("quarkus.profile", profile);
        }
        CONFIG_SOURCES.add((ConfigSource)new ConfigArgsConfigSource());
        PERSISTED_CONFIG_SOURCE = new PersistedConfigSource(KeycloakConfigSourceProvider.getPersistedConfigFile());
        CONFIG_SOURCES.add((ConfigSource)PERSISTED_CONFIG_SOURCE);
        CONFIG_SOURCES.add(new SysPropConfigSource());
        Path configFile = KeycloakConfigSourceProvider.getConfigurationFile();
        if (configFile != null) {
            CONFIG_SOURCES.add((ConfigSource)new KeycloakPropertiesConfigSource.InFileSystem(configFile));
        } else {
            log.debug((Object)"Loading the default server configuration");
            CONFIG_SOURCES.add((ConfigSource)new KeycloakPropertiesConfigSource.InJar());
        }
    }

    public static void reload() {
        CONFIG_SOURCES.clear();
        KeycloakConfigSourceProvider.initializeSources();
    }

    private static Path getConfigurationFile() {
        File file;
        String homeDir;
        String filePath = System.getProperty(KEYCLOAK_CONFIG_FILE_PROP);
        if (filePath == null) {
            filePath = System.getenv(KEYCLOAK_CONFIG_FILE_ENV);
        }
        if (filePath == null && (homeDir = Environment.getHomeDir()) != null && (file = Paths.get(homeDir, "conf", "keycloak.properties").toFile()).exists()) {
            filePath = file.getAbsolutePath();
        }
        if (filePath == null) {
            return null;
        }
        return Paths.get(filePath, new String[0]);
    }

    public static Path getPersistedConfigFile() {
        String homeDir = Environment.getHomeDir();
        if (homeDir == null) {
            return Paths.get(System.getProperty("java.io.tmpdir"), "persisted.properties");
        }
        return Paths.get(homeDir, "conf", "persisted.properties");
    }

    public Iterable<ConfigSource> getConfigSources(ClassLoader forClassLoader) {
        return CONFIG_SOURCES;
    }

    static {
        KeycloakConfigSourceProvider.initializeSources();
    }
}

