/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.provider.quarkus;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.ext.web.RoutingContext;
import org.keycloak.common.ClientConnection;
import org.keycloak.models.KeycloakSession;
import org.keycloak.services.filters.AbstractRequestFilter;

public class QuarkusRequestFilter
extends AbstractRequestFilter
implements Handler<RoutingContext> {
    private static final Handler<AsyncResult<Object>> EMPTY_RESULT = result -> {};

    public void handle(RoutingContext context) {
        context.vertx().executeBlocking(promise -> this.filter(this.createClientConnection(context.request()), session -> {
            try {
                context.addHeadersEndHandler(event -> this.close((KeycloakSession)session));
                context.next();
                promise.complete();
            }
            catch (Throwable cause) {
                promise.fail(cause);
                throw new RuntimeException(cause);
            }
        }), false, EMPTY_RESULT);
    }

    protected boolean isAutoClose() {
        return false;
    }

    private ClientConnection createClientConnection(final HttpServerRequest request) {
        return new ClientConnection(){

            public String getRemoteAddr() {
                return request.remoteAddress().host();
            }

            public String getRemoteHost() {
                return request.remoteAddress().host();
            }

            public int getRemotePort() {
                return request.remoteAddress().port();
            }

            public String getLocalAddr() {
                return request.localAddress().host();
            }

            public int getLocalPort() {
                return request.localAddress().port();
            }
        };
    }
}

