/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.configuration;

import io.smallrye.config.PropertiesConfigSource;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.jboss.logging.Logger;
import org.keycloak.util.Environment;

public class ConfigArgsConfigSource
extends PropertiesConfigSource {
    private static final Logger log = Logger.getLogger(ConfigArgsConfigSource.class);
    private static final Pattern ARG_SPLIT = Pattern.compile(",");
    private static final Pattern ARG_KEY_VALUE_SPLIT = Pattern.compile("=");
    private static final String ARG_PREFIX = "--";
    private static final Pattern DOT_SPLIT = Pattern.compile("\\.");

    ConfigArgsConfigSource() {
        super(ConfigArgsConfigSource.parseArgument(), "CliConfigSource", 500);
    }

    public String getValue(String propertyName) {
        String prefix = null;
        if (propertyName.startsWith("kc.")) {
            prefix = "kc.";
        } else if (propertyName.startsWith("quarkus.")) {
            prefix = "quarkus.";
        }
        if (prefix == null) {
            return null;
        }
        CharSequence[] parts = DOT_SPLIT.split(propertyName.substring(propertyName.indexOf(prefix) + prefix.length()));
        return super.getValue(prefix + String.join((CharSequence)"-", parts));
    }

    private static Map<String, String> parseArgument() {
        String args = Environment.getConfigArgs();
        if (args == null || "".equals(args.trim())) {
            log.trace((Object)"No command-line arguments provided");
            return Collections.emptyMap();
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        for (String arg : ARG_SPLIT.split(args)) {
            if (!arg.startsWith(ARG_PREFIX)) {
                throw new IllegalArgumentException("Invalid argument format [" + arg + "], arguments must start with '--'");
            }
            String[] keyValue = ARG_KEY_VALUE_SPLIT.split(arg);
            String key = keyValue[0];
            if ("".equals(key.trim())) {
                throw new IllegalArgumentException("Invalid argument key");
            }
            if (keyValue.length != 2) continue;
            String value = keyValue[1];
            key = "kc." + key.substring(2);
            log.tracef("Adding property [%s=%s] from command-line", (Object)key, (Object)value);
            properties.put(key, value);
        }
        return properties;
    }
}

