/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.configuration;

import io.smallrye.config.ConfigValue;
import io.smallrye.config.SmallRyeConfig;
import io.smallrye.config.SmallRyeConfigProviderResolver;
import java.util.Optional;
import java.util.function.Function;
import org.keycloak.configuration.KeycloakConfigSourceProvider;
import org.keycloak.util.Environment;

public final class Configuration {
    private static volatile SmallRyeConfig CONFIG;

    public static synchronized SmallRyeConfig getConfig() {
        if (CONFIG == null) {
            CONFIG = (SmallRyeConfig)SmallRyeConfigProviderResolver.instance().getConfig();
        }
        return CONFIG;
    }

    public static String getBuiltTimeProperty(String name) {
        String value = KeycloakConfigSourceProvider.PERSISTED_CONFIG_SOURCE.getValue(name);
        if (value == null) {
            String profile = Environment.getProfile();
            if (profile == null) {
                profile = Configuration.getConfig().getRawValue("kc.profile");
            }
            value = KeycloakConfigSourceProvider.PERSISTED_CONFIG_SOURCE.getValue("%" + profile + "." + name);
        }
        return value;
    }

    public static String getRawValue(String propertyName) {
        return Configuration.getConfig().getRawValue(propertyName);
    }

    public static Iterable<String> getPropertyNames() {
        return Configuration.getConfig().getPropertyNames();
    }

    public static ConfigValue getConfigValue(String propertyName) {
        return Configuration.getConfig().getConfigValue(propertyName);
    }

    public static Optional<String> getOptionalValue(String name) {
        return Configuration.getConfig().getOptionalValue(name, String.class);
    }

    public static Optional<Boolean> getOptionalBooleanValue(String name) {
        return Configuration.getConfig().getOptionalValue(name, String.class).map(new Function<String, Boolean>(){

            @Override
            public Boolean apply(String s) {
                return Boolean.parseBoolean(s);
            }
        });
    }
}

