/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.configuration;

import java.util.Map;
import java.util.TreeMap;
import org.eclipse.microprofile.config.spi.ConfigSource;

public class SysPropConfigSource
implements ConfigSource {
    private final Map<String, String> properties = new TreeMap<String, String>();

    public SysPropConfigSource() {
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            String key = (String)entry.getKey();
            if (!key.startsWith("kc.")) continue;
            this.properties.put(key, entry.getValue().toString());
        }
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public String getValue(String propertyName) {
        return System.getProperty(propertyName);
    }

    public String getName() {
        return "KcSysPropConfigSource";
    }

    public int getOrdinal() {
        return 400;
    }
}

