/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.provider.quarkus;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.ext.web.RoutingContext;
import org.keycloak.common.ClientConnection;
import org.keycloak.models.KeycloakSession;
import org.keycloak.services.filters.AbstractRequestFilter;

public class QuarkusRequestFilter
extends AbstractRequestFilter
implements Handler<RoutingContext> {
    private static final Handler<AsyncResult<Object>> EMPTY_RESULT = result -> {};

    public void handle(RoutingContext context) {
        context.vertx().executeBlocking(promise -> {
            ClientConnection connection = this.createClientConnection(context.request());
            this.filter(connection, session -> {
                try {
                    this.configureContextualData(context, connection, (KeycloakSession)session);
                    context.addHeadersEndHandler(this.createEndHandler(context, (Promise<Object>)promise, (KeycloakSession)session));
                    context.next();
                }
                catch (Throwable cause) {
                    context.fail(cause);
                    throw new RuntimeException(cause);
                }
            });
        }, false, EMPTY_RESULT);
    }

    private Handler<Void> createEndHandler(RoutingContext context, Promise<Object> promise, KeycloakSession session) {
        return event -> {
            try {
                this.close(session);
                promise.complete();
            }
            catch (Throwable cause) {
                context.fail(cause);
            }
        };
    }

    private void configureContextualData(RoutingContext context, ClientConnection connection, KeycloakSession session) {
        context.data().put(KeycloakSession.class.getName(), session);
        context.data().put(ClientConnection.class.getName(), connection);
    }

    protected boolean isAutoClose() {
        return false;
    }

    private ClientConnection createClientConnection(final HttpServerRequest request) {
        return new ClientConnection(){

            public String getRemoteAddr() {
                return request.remoteAddress().host();
            }

            public String getRemoteHost() {
                return request.remoteAddress().host();
            }

            public int getRemotePort() {
                return request.remoteAddress().port();
            }

            public String getLocalAddr() {
                return request.localAddress().host();
            }

            public int getLocalPort() {
                return request.localAddress().port();
            }
        };
    }
}

