var __create = Object.create;
var __defProp = Object.defineProperty;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __markAsModule = (target) => __defProp(target, "__esModule", {value: true});
var __commonJS = (callback, module2) => () => {
  if (!module2) {
    module2 = {exports: {}};
    callback(module2.exports, module2);
  }
  return module2.exports;
};
var __export = (target, all2) => {
  for (var name in all2)
    __defProp(target, name, {get: all2[name], enumerable: true});
};
var __exportStar = (target, module2, desc) => {
  if (module2 && typeof module2 === "object" || typeof module2 === "function") {
    for (let key of __getOwnPropNames(module2))
      if (!__hasOwnProp.call(target, key) && key !== "default")
        __defProp(target, key, {get: () => module2[key], enumerable: !(desc = __getOwnPropDesc(module2, key)) || desc.enumerable});
  }
  return target;
};
var __toModule = (module2) => {
  return __exportStar(__markAsModule(__defProp(module2 != null ? __create(__getProtoOf(module2)) : {}, "default", module2 && module2.__esModule && "default" in module2 ? {get: () => module2.default, enumerable: true} : {value: module2, enumerable: true})), module2);
};

// build/dashboard/Dashboard.js
var require_Dashboard = __commonJS((exports2) => {
  __markAsModule(exports2);
  __export(exports2, {
    default: () => DashboardSection
  });
  var EmptyDashboard = () => {
    const {t: t5} = useTranslation("dashboard");
    const {realm: realm2} = useRealm();
    return /* @__PURE__ */ react.createElement(PageSection, {
      variant: "light"
    }, /* @__PURE__ */ react.createElement(EmptyState, {
      variant: "large"
    }, /* @__PURE__ */ react.createElement(Brand, {
      src: environment_default.resourceUrl + "/icon.svg",
      alt: "Keycloak icon",
      className: "keycloak__dashboard_icon"
    }), /* @__PURE__ */ react.createElement(Title, {
      headingLevel: "h4",
      size: "3xl"
    }, t5("welcome")), /* @__PURE__ */ react.createElement(Title, {
      headingLevel: "h4",
      size: "4xl"
    }, realm2), /* @__PURE__ */ react.createElement(EmptyStateBody, null, t5("introduction"))));
  };
  var Dashboard = () => {
    const {t: t5} = useTranslation("dashboard");
    const {realm: realm2} = useRealm();
    const serverInfo2 = useServerInfo();
    const enabledFeatures = xor(serverInfo2.profileInfo?.disabledFeatures, serverInfo2.profileInfo?.experimentalFeatures, serverInfo2.profileInfo?.previewFeatures);
    const isExperimentalFeature = (feature) => {
      return serverInfo2.profileInfo?.experimentalFeatures?.includes(feature);
    };
    const isPreviewFeature = (feature) => {
      return serverInfo2.profileInfo?.previewFeatures?.includes(feature);
    };
    return /* @__PURE__ */ react.createElement(react.Fragment, null, /* @__PURE__ */ react.createElement(PageSection, {
      variant: "light"
    }, /* @__PURE__ */ react.createElement(TextContent, {
      className: "pf-u-mr-sm"
    }, /* @__PURE__ */ react.createElement(Text, {
      component: "h1"
    }, t5("realmName", {name: toUpperCase(realm2)})), /* @__PURE__ */ react.createElement(Text, null, /* @__PURE__ */ react.createElement(Trans, {
      t: t5,
      i18nKey: "adminUiVersion"
    }, /* @__PURE__ */ react.createElement("strong", null, "Admin UI version"), {version: environment_default.commitHash})))), /* @__PURE__ */ react.createElement(PageSection, null, /* @__PURE__ */ react.createElement(Grid, {
      hasGutter: true
    }, /* @__PURE__ */ react.createElement(GridItem, {
      lg: 2,
      sm: 12
    }, /* @__PURE__ */ react.createElement(Card, {
      className: "keycloak__dashboard_card"
    }, /* @__PURE__ */ react.createElement(CardTitle, null, t5("serverInfo")), /* @__PURE__ */ react.createElement(CardBody, null, /* @__PURE__ */ react.createElement(DescriptionList, null, /* @__PURE__ */ react.createElement(DescriptionListGroup, null, /* @__PURE__ */ react.createElement(DescriptionListTerm, null, t5("version")), /* @__PURE__ */ react.createElement(DescriptionListDescription, null, serverInfo2.systemInfo?.version), /* @__PURE__ */ react.createElement(DescriptionListTerm, null, t5("product")), /* @__PURE__ */ react.createElement(DescriptionListDescription, null, toUpperCase(serverInfo2.profileInfo?.name))))))), /* @__PURE__ */ react.createElement(GridItem, {
      lg: 10,
      sm: 12
    }, /* @__PURE__ */ react.createElement(Card, {
      className: "keycloak__dashboard_card"
    }, /* @__PURE__ */ react.createElement(CardTitle, null, t5("profile")), /* @__PURE__ */ react.createElement(CardBody, null, /* @__PURE__ */ react.createElement(DescriptionList, null, /* @__PURE__ */ react.createElement(DescriptionListGroup, null, /* @__PURE__ */ react.createElement(DescriptionListTerm, null, t5("enabledFeatures"), " ", /* @__PURE__ */ react.createElement(HelpItem, {
      forID: t5(`common:helpLabel`, {
        label: t5("enabledFeatures")
      }),
      forLabel: t5("enabledFeatures"),
      helpText: "dashboard:infoEnabledFeatures"
    })), /* @__PURE__ */ react.createElement(DescriptionListDescription, null, /* @__PURE__ */ react.createElement(List, {
      variant: ListVariant.inline
    }, enabledFeatures.map((feature) => /* @__PURE__ */ react.createElement(ListItem, {
      key: feature
    }, feature, " ", isExperimentalFeature(feature) ? /* @__PURE__ */ react.createElement(Label, {
      color: "orange"
    }, t5("experimental")) : null, isPreviewFeature(feature) ? /* @__PURE__ */ react.createElement(Label, {
      color: "blue"
    }, t5("preview")) : null))))), /* @__PURE__ */ react.createElement(DescriptionListGroup, null, /* @__PURE__ */ react.createElement(DescriptionListTerm, null, t5("disabledFeatures"), " ", /* @__PURE__ */ react.createElement(HelpItem, {
      forID: t5(`common:helpLabel`, {
        label: t5("disabledFeatures")
      }),
      forLabel: t5("disabledFeatures"),
      helpText: "dashboard:infoDisabledFeatures"
    })), /* @__PURE__ */ react.createElement(DescriptionListDescription, null, /* @__PURE__ */ react.createElement(List, {
      variant: ListVariant.inline
    }, serverInfo2.profileInfo?.disabledFeatures?.map((feature) => /* @__PURE__ */ react.createElement(ListItem, {
      key: feature
    }, feature))))))))))));
  };
  function DashboardSection() {
    const {realm: realm2} = useRealm();
    const isMasterRealm = realm2 === "master";
    return /* @__PURE__ */ react.createElement(react.Fragment, null, !isMasterRealm && /* @__PURE__ */ react.createElement(EmptyDashboard, null), isMasterRealm && /* @__PURE__ */ react.createElement(Dashboard, null));
  }
});

// build/realm/add/NewRealmForm.js
var require_NewRealmForm = __commonJS((exports2) => {
  __markAsModule(exports2);
  __export(exports2, {
    default: () => NewRealmForm
  });
  function NewRealmForm() {
    const {t: t5} = useTranslation("realm");
    const history = useHistory();
    const {refresh} = useWhoAmI();
    const {refresh: refreshRealms} = useRealms();
    const adminClient = useAdminClient();
    const {addAlert, addError} = useAlerts();
    const {register: register2, handleSubmit, control, errors, setValue} = useForm({mode: "onChange"});
    const handleFileChange = (obj) => {
      const defaultRealm = {id: "", realm: "", enabled: true};
      Object.entries(obj || defaultRealm).map((entry) => setValue(entry[0], entry[1]));
    };
    const save = async (realm2) => {
      try {
        await adminClient.realms.create(realm2);
        addAlert(t5("saveRealmSuccess"), AlertVariant.success);
        refresh();
        await refreshRealms();
        history.push(toDashboard({realm: realm2.realm}));
      } catch (error2) {
        addError("realm:saveRealmError", error2);
      }
    };
    return /* @__PURE__ */ react.createElement(react.Fragment, null, /* @__PURE__ */ react.createElement(ViewHeader, {
      titleKey: "realm:createRealm",
      subKey: "realm:realmExplain"
    }), /* @__PURE__ */ react.createElement(PageSection, {
      variant: "light"
    }, /* @__PURE__ */ react.createElement(FormAccess, {
      isHorizontal: true,
      onSubmit: handleSubmit(save),
      role: "manage-realm"
    }, /* @__PURE__ */ react.createElement(JsonFileUpload, {
      id: "kc-realm-filename",
      allowEditingUploadedText: true,
      onChange: handleFileChange
    }), /* @__PURE__ */ react.createElement(FormGroup, {
      label: t5("realmName"),
      isRequired: true,
      fieldId: "kc-realm-name",
      validated: errors.realm ? "error" : "default",
      helperTextInvalid: t5("common:required")
    }, /* @__PURE__ */ react.createElement(TextInput, {
      isRequired: true,
      type: "text",
      id: "kc-realm-name",
      name: "realm",
      validated: errors.realm ? "error" : "default",
      ref: register2({required: true})
    })), /* @__PURE__ */ react.createElement(FormGroup, {
      label: t5("enabled"),
      fieldId: "kc-realm-enabled-switch"
    }, /* @__PURE__ */ react.createElement(Controller, {
      name: "enabled",
      defaultValue: true,
      control,
      render: ({onChange, value}) => /* @__PURE__ */ react.createElement(Switch, {
        id: "kc-realm-enabled-switch",
        name: "enabled",
        label: t5("common:on"),
        labelOff: t5("common:off"),
        isChecked: value,
        onChange
      })
    })), /* @__PURE__ */ react.createElement(ActionGroup, null, /* @__PURE__ */ react.createElement(Button, {
      variant: "primary",
      type: "submit"
    }, t5("common:create")), /* @__PURE__ */ react.createElement(Button, {
      variant: "link",
      onClick: () => history.goBack()
    }, t5("common:cancel"))))));
  }
});

// build/authentication/FlowDetails.js
var require_FlowDetails = __commonJS((exports2) => {
  __markAsModule(exports2);
  __export(exports2, {
    default: () => FlowDetails,
    providerConditionFilter: () => providerConditionFilter3
  });
  var providerConditionFilter3 = (value) => value.displayName?.startsWith("Condition ");
  function FlowDetails() {
    const {t: t5} = useTranslation("authentication");
    const adminClient = useAdminClient();
    const {realm: realm2} = useRealm();
    const {addAlert, addError} = useAlerts();
    const {id: id3, usedBy, builtIn} = useParams();
    const history = useHistory();
    const [key, setKey] = useState(0);
    const refresh = () => setKey(new Date().getTime());
    const [tableView, setTableView] = useState(true);
    const [flow, setFlow] = useState();
    const [executionList, setExecutionList] = useState();
    const [dragged, setDragged] = useState();
    const [liveText, setLiveText] = useState("");
    const [showAddExecutionDialog, setShowAddExecutionDialog] = useState();
    const [showAddSubFlowDialog, setShowSubFlowDialog] = useState();
    const [selectedExecution, setSelectedExecution] = useState();
    const [open2, toggleOpen, setOpen] = useToggle();
    const [edit, setEdit] = useState(false);
    useFetch(async () => {
      const flows = await adminClient.authenticationManagement.getFlows();
      const flow2 = flows.find((f2) => f2.id === id3);
      if (!flow2) {
        throw new Error(t5("common:notFound"));
      }
      const executions = await adminClient.authenticationManagement.getExecutions({
        flow: flow2.alias
      });
      return {flow: flow2, executions};
    }, ({flow: flow2, executions}) => {
      setFlow(flow2);
      setExecutionList(new ExecutionList(executions));
    }, [key]);
    const executeChange = async (ex, change) => {
      try {
        let id22 = ex.id;
        if ("parent" in change) {
          await adminClient.authenticationManagement.delExecution({id: id22});
          const result = await adminClient.authenticationManagement.addExecutionToFlow({
            flow: change.parent?.displayName || flow?.alias,
            provider: ex.providerId
          });
          id22 = result.id;
        }
        const times = change.newIndex - change.oldIndex;
        for (let index3 = 0; index3 < Math.abs(times); index3++) {
          if (times > 0) {
            await adminClient.authenticationManagement.lowerPriorityExecution({
              id: id22
            });
          } else {
            await adminClient.authenticationManagement.raisePriorityExecution({
              id: id22
            });
          }
        }
        refresh();
        addAlert(t5("updateFlowSuccess"), AlertVariant.success);
      } catch (error2) {
        addError("authentication:updateFlowError", error2);
      }
    };
    const update = async (execution) => {
      try {
        await adminClient.authenticationManagement.updateExecution({flow: flow?.alias}, execution);
        refresh();
        addAlert(t5("updateFlowSuccess"), AlertVariant.success);
      } catch (error2) {
        addError("authentication:updateFlowError", error2);
      }
    };
    const addExecution = async (name, type) => {
      try {
        await adminClient.authenticationManagement.addExecutionToFlow({
          flow: name,
          provider: type.id
        });
        refresh();
        addAlert(t5("updateFlowSuccess"), AlertVariant.success);
      } catch (error2) {
        addError("authentication:updateFlowError", error2);
      }
    };
    const addFlow = async (flow2, {name, description = "", type, provider}) => {
      try {
        await adminClient.authenticationManagement.addFlowToFlow({
          flow: flow2,
          alias: name,
          description,
          provider,
          type
        });
        refresh();
        addAlert(t5("updateFlowSuccess"), AlertVariant.success);
      } catch (error2) {
        addError("authentication:updateFlowError", error2);
      }
    };
    const setAsDefault = async () => {
      try {
        const r3 = await adminClient.realms.findOne({realm: realm2});
        await adminClient.realms.update({realm: realm2}, {...r3, browserFlow: flow?.alias});
        addAlert(t5("updateFlowSuccess"), AlertVariant.success);
        history.push(toFlow({id: id3, realm: realm2, usedBy: "default", builtIn}));
      } catch (error2) {
        addError("authentication:updateFlowError", error2);
      }
    };
    const [toggleDeleteDialog, DeleteConfirm] = useConfirmDialog({
      titleKey: "authentication:deleteConfirmExecution",
      children: /* @__PURE__ */ react.createElement(Trans, {
        i18nKey: "authentication:deleteConfirmExecutionMessage"
      }, " ", /* @__PURE__ */ react.createElement("strong", null, {name: selectedExecution?.displayName}), "."),
      continueButtonLabel: "common:delete",
      continueButtonVariant: ButtonVariant.danger,
      onConfirm: async () => {
        try {
          await adminClient.authenticationManagement.delExecution({
            id: selectedExecution?.id
          });
          addAlert(t5("deleteExecutionSuccess"), AlertVariant.success);
          refresh();
        } catch (error2) {
          addError("authentication:deleteExecutionError", error2);
        }
      }
    });
    const [toggleDeleteFlow, DeleteFlowConfirm] = useConfirmDialog({
      titleKey: "authentication:deleteConfirmFlow",
      children: /* @__PURE__ */ react.createElement(Trans, {
        i18nKey: "authentication:deleteConfirmFlowMessage"
      }, " ", /* @__PURE__ */ react.createElement("strong", null, {flow: flow?.alias || ""}), "."),
      continueButtonLabel: "common:delete",
      continueButtonVariant: ButtonVariant.danger,
      onConfirm: async () => {
        try {
          await adminClient.authenticationManagement.deleteFlow({
            flowId: flow.id
          });
          history.push(toAuthentication({realm: realm2}));
          addAlert(t5("deleteFlowSuccess"), AlertVariant.success);
        } catch (error2) {
          addError("authentication:deleteFlowError", error2);
        }
      }
    });
    const hasExecutions = executionList?.expandableList.length !== 0;
    const dropdownItems = [
      ...usedBy !== "default" ? [
        /* @__PURE__ */ react.createElement(DropdownItem, {
          "data-testid": "set-as-default",
          key: "default",
          onClick: () => setAsDefault()
        }, t5("setAsDefault"))
      ] : [],
      /* @__PURE__ */ react.createElement(DropdownItem, {
        key: "duplicate",
        onClick: () => setOpen(true)
      }, t5("duplicate")),
      ...!builtIn ? [
        /* @__PURE__ */ react.createElement(DropdownItem, {
          "data-testid": "edit-flow",
          key: "edit",
          onClick: () => setEdit(true)
        }, t5("editInfo")),
        /* @__PURE__ */ react.createElement(DropdownItem, {
          "data-testid": "delete-flow",
          key: "delete",
          onClick: () => toggleDeleteFlow()
        }, t5("common:delete"))
      ] : []
    ];
    return /* @__PURE__ */ react.createElement(react.Fragment, null, open2 && /* @__PURE__ */ react.createElement(DuplicateFlowModal, {
      name: flow?.alias,
      description: flow?.description,
      toggleDialog: toggleOpen,
      onComplete: () => {
        refresh();
        setOpen(false);
      }
    }), edit && /* @__PURE__ */ react.createElement(EditFlowModal, {
      flow,
      toggleDialog: () => {
        setEdit(!edit);
        refresh();
      }
    }), /* @__PURE__ */ react.createElement(DeleteFlowConfirm, null), /* @__PURE__ */ react.createElement(ViewHeader, {
      titleKey: toUpperCase(flow?.alias || ""),
      badges: [
        {text: /* @__PURE__ */ react.createElement(Label, null, t5(usedBy))},
        builtIn ? {
          text: /* @__PURE__ */ react.createElement(Label, {
            className: "keycloak_authentication-section__usedby_label",
            icon: /* @__PURE__ */ react.createElement(CheckCircleIcon, null)
          }, t5("buildIn")),
          id: "builtIn"
        } : {}
      ],
      dropdownItems
    }), /* @__PURE__ */ react.createElement(PageSection, {
      variant: "light"
    }, hasExecutions && /* @__PURE__ */ react.createElement(Toolbar, {
      id: "toolbar"
    }, /* @__PURE__ */ react.createElement(ToolbarContent, null, /* @__PURE__ */ react.createElement(ToggleGroup, null, /* @__PURE__ */ react.createElement(ToggleGroupItem, {
      icon: /* @__PURE__ */ react.createElement(TableIcon, null),
      "aria-label": t5("tableView"),
      buttonId: "tableView",
      isSelected: tableView,
      onChange: () => setTableView(true)
    }), /* @__PURE__ */ react.createElement(ToggleGroupItem, {
      icon: /* @__PURE__ */ react.createElement("i", {
        className: "fas fa-project-diagram"
      }),
      "aria-label": t5("diagramView"),
      buttonId: "diagramView",
      isSelected: !tableView,
      onChange: () => setTableView(false)
    })))), tableView && executionList && hasExecutions && /* @__PURE__ */ react.createElement(react.Fragment, null, /* @__PURE__ */ react.createElement(DeleteConfirm, null), /* @__PURE__ */ react.createElement(DataList, {
      "aria-label": "flows",
      onDragFinish: (order3) => {
        const withoutHeaderId = order3.slice(1);
        setLiveText(t5("common:onDragFinish", {list: dragged?.displayName}));
        const change = executionList.getChange(dragged, withoutHeaderId);
        executeChange(dragged, change);
      },
      onDragStart: (id22) => {
        const item = executionList.findExecution(id22);
        setLiveText(t5("common:onDragStart", {item: item.displayName}));
        setDragged(item);
        if (!item.isCollapsed) {
          item.isCollapsed = true;
          setExecutionList(executionList.clone());
        }
      },
      onDragMove: () => setLiveText(t5("common:onDragMove", {item: dragged?.displayName})),
      onDragCancel: () => setLiveText(t5("common:onDragCancel")),
      itemOrder: [
        "header",
        ...executionList.order().map((ex) => ex.id)
      ]
    }, /* @__PURE__ */ react.createElement(FlowHeader, null), /* @__PURE__ */ react.createElement(react.Fragment, null, executionList.expandableList.map((execution) => /* @__PURE__ */ react.createElement(FlowRow, {
      builtIn: !!builtIn,
      key: execution.id,
      execution,
      onRowClick: (execution2) => {
        execution2.isCollapsed = !execution2.isCollapsed;
        setExecutionList(executionList.clone());
      },
      onRowChange: update,
      onAddExecution: (execution2, type) => addExecution(execution2.displayName, type),
      onAddFlow: (flow2) => addFlow(execution.displayName, flow2),
      onDelete: () => {
        setSelectedExecution(execution);
        toggleDeleteDialog();
      }
    })))), flow && /* @__PURE__ */ react.createElement(react.Fragment, null, showAddExecutionDialog && /* @__PURE__ */ react.createElement(AddStepModal, {
      name: flow.alias,
      type: flow.providerId === "client-flow" ? "client" : "basic",
      onSelect: (type) => {
        if (type) {
          addExecution(flow.alias, type);
        }
        setShowAddExecutionDialog(false);
      }
    }), showAddSubFlowDialog && /* @__PURE__ */ react.createElement(AddSubFlowModal, {
      name: flow.alias,
      onCancel: () => setShowSubFlowDialog(false),
      onConfirm: (newFlow) => {
        addFlow(flow.alias, newFlow);
        setShowSubFlowDialog(false);
      }
    }), /* @__PURE__ */ react.createElement(ActionGroup, null, /* @__PURE__ */ react.createElement(Button, {
      "data-testid": "addStep",
      variant: "link",
      onClick: () => setShowAddExecutionDialog(true)
    }, /* @__PURE__ */ react.createElement(PlusIcon, null), " ", t5("addStep")), /* @__PURE__ */ react.createElement(Button, {
      "data-testid": "addSubFlow",
      variant: "link",
      onClick: () => setShowSubFlowDialog(true)
    }, /* @__PURE__ */ react.createElement(PlusIcon, null), " ", t5("addSubFlow")))), /* @__PURE__ */ react.createElement("div", {
      className: "pf-screen-reader",
      "aria-live": "assertive"
    }, liveText)), !tableView && executionList?.expandableList && /* @__PURE__ */ react.createElement(FlowDiagram, {
      executionList
    }), !executionList?.expandableList || flow && !hasExecutions && /* @__PURE__ */ react.createElement(EmptyExecutionState, {
      flow,
      onAddExecution: (type) => addExecution(flow.alias, type),
      onAddFlow: (newFlow) => addFlow(flow.alias, newFlow)
    })));
  }
});

// build/authentication/form/CreateFlow.js
var require_CreateFlow = __commonJS((exports2) => {
  __markAsModule(exports2);
  __export(exports2, {
    default: () => CreateFlow
  });
  function CreateFlow() {
    const {t: t5} = useTranslation("authentication");
    const history = useHistory();
    const {realm: realm2} = useRealm();
    const form2 = useForm({
      defaultValues: {builtIn: false, topLevel: true}
    });
    const {handleSubmit, register: register2} = form2;
    const adminClient = useAdminClient();
    const {addAlert} = useAlerts();
    const save = async (flow) => {
      try {
        const {id: id3} = await adminClient.authenticationManagement.createFlow(flow);
        addAlert(t5("flowCreatedSuccess"), AlertVariant.success);
        history.push(toFlow({
          realm: realm2,
          id: id3,
          usedBy: "notInUse"
        }));
      } catch (error2) {
        addAlert(t5("flowCreateError", {
          error: error2.response?.data?.errorMessage || error2
        }), AlertVariant.danger);
      }
    };
    return /* @__PURE__ */ react.createElement(react.Fragment, null, /* @__PURE__ */ react.createElement(ViewHeader, {
      titleKey: "authentication:createFlow",
      subKey: "authentication-help:createFlow"
    }), /* @__PURE__ */ react.createElement(PageSection, {
      variant: "light"
    }, /* @__PURE__ */ react.createElement(FormProvider, {
      ...form2
    }, /* @__PURE__ */ react.createElement(FormAccess, {
      isHorizontal: true,
      role: "manage-authorization",
      onSubmit: handleSubmit(save)
    }, /* @__PURE__ */ react.createElement("input", {
      name: "builtIn",
      type: "hidden",
      ref: register2
    }), /* @__PURE__ */ react.createElement("input", {
      name: "topLevel",
      type: "hidden",
      ref: register2
    }), /* @__PURE__ */ react.createElement(NameDescription, null), /* @__PURE__ */ react.createElement(FlowType, null), /* @__PURE__ */ react.createElement(ActionGroup, null, /* @__PURE__ */ react.createElement(Button, {
      "data-testid": "create",
      type: "submit"
    }, t5("common:create")), /* @__PURE__ */ react.createElement(Button, {
      "data-testid": "cancel",
      variant: "link",
      component: (props) => /* @__PURE__ */ react.createElement(Link, {
        ...props,
        to: toAuthentication({realm: realm2})
      })
    }, t5("common:cancel")))))));
  }
});

// build/authentication/AuthenticationSection.js
var require_AuthenticationSection = __commonJS((exports2) => {
  __markAsModule(exports2);
  __export(exports2, {
    default: () => AuthenticationSection
  });
  var realmFlows = [
    "browserFlow",
    "registrationFlow",
    "directGrantFlow",
    "resetCredentialsFlow",
    "clientAuthenticationFlow",
    "dockerAuthenticationFlow"
  ];
  function AuthenticationSection() {
    const {t: t5} = useTranslation("authentication");
    const adminClient = useAdminClient();
    const {realm: realm2} = useRealm();
    const [key, setKey] = useState(0);
    const refresh = () => setKey(new Date().getTime());
    const {addAlert, addError} = useAlerts();
    const [selectedFlow, setSelectedFlow] = useState();
    const [open2, toggleOpen, setOpen] = useToggle();
    const loader = async () => {
      const clients2 = await adminClient.clients.find();
      const idps = await adminClient.identityProviders.find();
      const realmRep = await adminClient.realms.findOne({realm: realm2});
      if (!realmRep) {
        throw new Error(t5("common:notFound"));
      }
      const defaultFlows = Object.entries(realmRep).filter((entry) => realmFlows.includes(entry[0])).map((entry) => entry[1]);
      const flows = await adminClient.authenticationManagement.getFlows();
      for (const flow of flows) {
        flow.usedBy = {values: []};
        const client2 = clients2.find((client22) => client22.authenticationFlowBindingOverrides && (client22.authenticationFlowBindingOverrides["direct_grant"] === flow.id || client22.authenticationFlowBindingOverrides["browser"] === flow.id));
        if (client2) {
          flow.usedBy.type = "specificClients";
          flow.usedBy.values.push(client2.clientId);
        }
        const idp = idps.find((idp2) => idp2.firstBrokerLoginFlowAlias === flow.alias || idp2.postBrokerLoginFlowAlias === flow.alias);
        if (idp) {
          flow.usedBy.type = "specificProviders";
          flow.usedBy.values.push(idp.alias);
        }
        const isDefault = defaultFlows.includes(flow.alias);
        if (isDefault) {
          flow.usedBy.type = "default";
        }
      }
      return flows;
    };
    const [toggleDeleteDialog, DeleteConfirm] = useConfirmDialog({
      titleKey: "authentication:deleteConfirmFlow",
      children: /* @__PURE__ */ react.createElement(Trans, {
        i18nKey: "authentication:deleteConfirmFlowMessage"
      }, " ", /* @__PURE__ */ react.createElement("strong", null, {flow: selectedFlow ? selectedFlow.alias : ""}), "."),
      continueButtonLabel: "common:delete",
      continueButtonVariant: ButtonVariant.danger,
      onConfirm: async () => {
        try {
          await adminClient.authenticationManagement.deleteFlow({
            flowId: selectedFlow.id
          });
          refresh();
          addAlert(t5("deleteFlowSuccess"), AlertVariant.success);
        } catch (error2) {
          addError("authentication:deleteFlowError", error2);
        }
      }
    });
    const UsedBy = ({id: id3, usedBy: {type, values: values2}}) => /* @__PURE__ */ react.createElement(react.Fragment, null, (type === "specificProviders" || type === "specificClients") && /* @__PURE__ */ react.createElement(Popover, {
      key: id3,
      "aria-label": t5("usedBy"),
      bodyContent: /* @__PURE__ */ react.createElement("div", {
        key: `usedBy-${id3}-${values2}`
      }, t5("appliedBy" + (type === "specificClients" ? "Clients" : "Providers")), " ", values2.map((used, index3) => /* @__PURE__ */ react.createElement(react.Fragment, null, /* @__PURE__ */ react.createElement("strong", null, used), index3 < values2.length - 1 ? ", " : "")))
    }, /* @__PURE__ */ react.createElement(Button, {
      variant: ButtonVariant.link,
      key: `button-${id3}`
    }, /* @__PURE__ */ react.createElement(CheckCircleIcon, {
      className: "keycloak_authentication-section__usedby",
      key: `icon-${id3}`
    }), " ", t5(type))), type === "default" && /* @__PURE__ */ react.createElement(Button, {
      key: id3,
      variant: ButtonVariant.link,
      isDisabled: true
    }, /* @__PURE__ */ react.createElement(CheckCircleIcon, {
      className: "keycloak_authentication-section__usedby",
      key: `icon-${id3}`
    }), " ", t5("default")), !type && /* @__PURE__ */ react.createElement(Button, {
      key: id3,
      variant: ButtonVariant.link,
      isDisabled: true
    }, t5("notInUse")));
    const AliasRenderer = ({
      id: id3,
      alias,
      usedBy,
      builtIn
    }) => /* @__PURE__ */ react.createElement(react.Fragment, null, /* @__PURE__ */ react.createElement(Link, {
      to: toFlow({
        realm: realm2,
        id: id3,
        usedBy: usedBy.type || "notInUse",
        builtIn: builtIn ? "builtIn" : void 0
      }),
      key: `link-${id3}`
    }, toUpperCase(alias)), " ", builtIn && /* @__PURE__ */ react.createElement(Label, {
      key: `label-${id3}`
    }, t5("buildIn")));
    return /* @__PURE__ */ react.createElement(react.Fragment, null, /* @__PURE__ */ react.createElement(DeleteConfirm, null), open2 && /* @__PURE__ */ react.createElement(DuplicateFlowModal, {
      name: selectedFlow ? selectedFlow.alias : "",
      description: selectedFlow?.description,
      toggleDialog: toggleOpen,
      onComplete: () => {
        refresh();
        setOpen(false);
      }
    }), /* @__PURE__ */ react.createElement(ViewHeader, {
      titleKey: "authentication:title",
      divider: false
    }), /* @__PURE__ */ react.createElement(PageSection, {
      variant: "light",
      className: "pf-u-p-0"
    }, /* @__PURE__ */ react.createElement(KeycloakTabs, {
      isBox: true
    }, /* @__PURE__ */ react.createElement(Tab, {
      eventKey: "flows",
      title: /* @__PURE__ */ react.createElement(TabTitleText, null, t5("flows"))
    }, /* @__PURE__ */ react.createElement(KeycloakDataTable, {
      key,
      loader,
      ariaLabelKey: "authentication:title",
      searchPlaceholderKey: "authentication:searchForFlow",
      toolbarItem: /* @__PURE__ */ react.createElement(ToolbarItem, null, /* @__PURE__ */ react.createElement(Button, {
        component: (props) => /* @__PURE__ */ react.createElement(Link, {
          ...props,
          to: toCreateFlow({realm: realm2})
        })
      }, t5("createFlow"))),
      actionResolver: ({data: data2}) => {
        const defaultActions = [
          {
            title: t5("duplicate"),
            onClick: () => {
              setOpen(true);
              setSelectedFlow(data2);
            }
          }
        ];
        if (data2.builtIn || data2.usedBy.values.length > 0) {
          return defaultActions;
        } else {
          return [
            {
              title: t5("common:delete"),
              onClick: () => {
                setSelectedFlow(data2);
                toggleDeleteDialog();
              }
            },
            ...defaultActions
          ];
        }
      },
      columns: [
        {
          name: "alias",
          displayKey: "authentication:flowName",
          cellRenderer: AliasRenderer
        },
        {
          name: "usedBy",
          displayKey: "authentication:usedBy",
          cellRenderer: UsedBy
        },
        {
          name: "description",
          displayKey: "common:description"
        }
      ],
      emptyState: /* @__PURE__ */ react.createElement(ListEmptyState, {
        message: t5("emptyEvents"),
        instructions: t5("emptyEventsInstructions")
      })
    })), /* @__PURE__ */ react.createElement(Tab, {
      id: "requiredActions",
      eventKey: "requiredActions",
      title: /* @__PURE__ */ react.createElement(TabTitleText, null, t5("requiredActions"))
    }, /* @__PURE__ */ react.createElement(RequiredActions, null)), /* @__PURE__ */ react.createElement(Tab, {
      id: "policies",
      eventKey: "policies",
      title: /* @__PURE__ */ react.createElement(TabTitleText, null, t5("policies"))
    }, /* @__PURE__ */ react.createElement(Policies, null)))));
  }
});

// build/client-scopes/ClientScopesSection.js
var require_ClientScopesSection = __commonJS((exports2) => {
  __markAsModule(exports2);
  __export(exports2, {
    default: () => ClientScopesSection
  });
  function ClientScopesSection() {
    const {realm: realm2} = useRealm();
    const {whoAmI: whoAmI2} = useWhoAmI();
    const {t: t5} = useTranslation("client-scopes");
    const adminClient = useAdminClient();
    const {addAlert, addError} = useAlerts();
    const [key, setKey] = useState(0);
    const refresh = () => setKey(new Date().getTime());
    const [kebabOpen, setKebabOpen] = useState(false);
    const [selectedScopes, setSelectedScopes] = useState([]);
    const [searchType, setSearchType] = useState("name");
    const [searchTypeType, setSearchTypeType] = useState(AllClientScopes.none);
    const [searchProtocol, setSearchProtocol] = useState("all");
    const loader = async (first2, max2, search2) => {
      const defaultScopes = await adminClient.clientScopes.listDefaultClientScopes();
      const optionalScopes = await adminClient.clientScopes.listDefaultOptionalClientScopes();
      const clientScopes2 = await adminClient.clientScopes.find();
      const filter3 = searchType === "name" ? nameFilter(search2) : searchType === "type" ? typeFilter(searchTypeType) : protocolFilter(searchProtocol);
      return clientScopes2.map((scope) => {
        const row = {
          ...scope,
          type: defaultScopes.find((defaultScope) => defaultScope.name === scope.name) ? ClientScope.default : optionalScopes.find((optionalScope) => optionalScope.name === scope.name) ? ClientScope.optional : AllClientScopes.none
        };
        return row;
      }).filter(filter3).sort((a2, b2) => a2.name.localeCompare(b2.name, whoAmI2.getLocale())).slice(first2, max2);
    };
    const [toggleDeleteDialog, DeleteConfirm] = useConfirmDialog({
      titleKey: t5("deleteClientScope", {
        count: selectedScopes.length,
        name: selectedScopes[0]?.name
      }),
      messageKey: "client-scopes:deleteConfirm",
      continueButtonLabel: "common:delete",
      continueButtonVariant: ButtonVariant.danger,
      onConfirm: async () => {
        try {
          for (const scope of selectedScopes) {
            try {
              await removeScope(adminClient, scope);
            } catch (error2) {
              console.warn("could not remove scope", error2.response?.data?.errorMessage || error2);
            }
            await adminClient.clientScopes.del({id: scope.id});
          }
          addAlert(t5("deletedSuccess"), AlertVariant.success);
          refresh();
        } catch (error2) {
          addError("client-scopes:deleteError", error2);
        }
      }
    });
    const TypeSelector = (scope) => /* @__PURE__ */ react.createElement(CellDropdown, {
      clientScope: scope,
      type: scope.type,
      all: true,
      onSelect: async (value) => {
        try {
          await changeScope(adminClient, scope, value);
          addAlert(t5("clientScopeSuccess"), AlertVariant.success);
          refresh();
        } catch (error2) {
          addError("client-scopes:clientScopeError", error2);
        }
      }
    });
    const ClientScopeDetailLink = ({
      id: id3,
      type,
      name
    }) => /* @__PURE__ */ react.createElement(Link, {
      key: id3,
      to: toClientScope({realm: realm2, id: id3, type, tab: "settings"})
    }, name);
    return /* @__PURE__ */ react.createElement(react.Fragment, null, /* @__PURE__ */ react.createElement(DeleteConfirm, null), /* @__PURE__ */ react.createElement(ViewHeader, {
      titleKey: "clientScopes",
      subKey: "client-scopes:clientScopeExplain"
    }), /* @__PURE__ */ react.createElement(PageSection, {
      variant: "light",
      className: "pf-u-p-0"
    }, /* @__PURE__ */ react.createElement(KeycloakDataTable, {
      key,
      loader,
      ariaLabelKey: "client-scopes:clientScopeList",
      searchPlaceholderKey: searchType === "name" ? "client-scopes:searchFor" : void 0,
      isSearching: searchType !== "name",
      searchTypeComponent: /* @__PURE__ */ react.createElement(SearchDropdown, {
        searchType,
        onSelect: (searchType2) => setSearchType(searchType2),
        withProtocol: true
      }),
      isPaginated: true,
      onSelect: (clientScopes2) => setSelectedScopes([...clientScopes2]),
      canSelectAll: true,
      toolbarItem: /* @__PURE__ */ react.createElement(react.Fragment, null, /* @__PURE__ */ react.createElement(SearchToolbar, {
        searchType,
        type: searchTypeType,
        onSelect: (searchType2) => setSearchType(searchType2),
        onType: (value) => {
          setSearchTypeType(value);
          refresh();
        },
        protocol: searchProtocol,
        onProtocol: (protocol) => {
          setSearchProtocol(protocol);
          refresh();
        }
      }), /* @__PURE__ */ react.createElement(ToolbarItem, null, /* @__PURE__ */ react.createElement(Button, {
        component: (props) => /* @__PURE__ */ react.createElement(Link, {
          ...props,
          to: toNewClientScope({realm: realm2})
        })
      }, t5("createClientScope"))), /* @__PURE__ */ react.createElement(ToolbarItem, null, /* @__PURE__ */ react.createElement(ChangeTypeDropdown, {
        selectedRows: selectedScopes,
        refresh
      })), /* @__PURE__ */ react.createElement(ToolbarItem, null, /* @__PURE__ */ react.createElement(Dropdown, {
        toggle: /* @__PURE__ */ react.createElement(KebabToggle, {
          onToggle: setKebabOpen
        }),
        isOpen: kebabOpen,
        isPlain: true,
        dropdownItems: [
          /* @__PURE__ */ react.createElement(DropdownItem, {
            key: "action",
            component: "button",
            isDisabled: selectedScopes.length === 0,
            onClick: () => {
              toggleDeleteDialog();
              setKebabOpen(false);
            }
          }, t5("common:delete"))
        ]
      }))),
      actions: [
        {
          title: t5("common:export")
        },
        {
          title: t5("common:delete"),
          onRowClick: (clientScope) => {
            setSelectedScopes([clientScope]);
            toggleDeleteDialog();
          }
        }
      ],
      columns: [
        {
          name: "name",
          cellRenderer: ClientScopeDetailLink
        },
        {
          name: "type",
          displayKey: "client-scopes:assignedType",
          cellRenderer: TypeSelector
        },
        {
          name: "protocol",
          displayKey: "client-scopes:protocol",
          cellRenderer: (client2) => getProtocolName(t5, client2.protocol ?? "openid-connect"),
          transforms: [cellWidth(15)]
        },
        {
          name: "attributes['gui.order']",
          displayKey: "client-scopes:displayOrder",
          cellFormatters: [emptyFormatter()],
          transforms: [cellWidth(15)]
        },
        {name: "description", cellFormatters: [emptyFormatter()]}
      ]
    })));
  }
});

// build/client-scopes/details/MappingDetails.js
var require_MappingDetails = __commonJS((exports2) => {
  __markAsModule(exports2);
  __export(exports2, {
    default: () => MappingDetails
  });
  function MappingDetails() {
    const {t: t5} = useTranslation("client-scopes");
    const adminClient = useAdminClient();
    const {addAlert, addError} = useAlerts();
    const {id: id3, mapperId, type} = useParams();
    const form2 = useForm();
    const {register: register2, setValue, errors, handleSubmit} = form2;
    const [mapping, setMapping] = useState();
    const [config2, setConfig] = useState();
    const history = useHistory();
    const {realm: realm2} = useRealm();
    const serverInfo2 = useServerInfo();
    const isGuid = /^[{]?[0-9a-fA-F]{8}-([0-9a-fA-F]{4}-){3}[0-9a-fA-F]{12}[}]?$/;
    const isUpdating = !!mapperId.match(isGuid);
    const isOnClientScope = !!useRouteMatch(MapperRoute.path);
    const toDetails = () => isOnClientScope ? toClientScope({realm: realm2, id: id3, type, tab: "mappers"}) : `/${realm2}/clients/${id3}/mappers`;
    useFetch(async () => {
      let data2;
      if (isUpdating) {
        if (isOnClientScope) {
          data2 = await adminClient.clientScopes.findProtocolMapper({
            id: id3,
            mapperId
          });
        } else {
          data2 = await adminClient.clients.findProtocolMapperById({
            id: id3,
            mapperId
          });
        }
        if (!data2) {
          throw new Error(t5("common:notFound"));
        }
        const mapperTypes = serverInfo2.protocolMapperTypes[data2.protocol];
        const mapping2 = mapperTypes.find((type2) => type2.id === data2.protocolMapper);
        return {
          config: {
            protocol: data2.protocol,
            protocolMapper: data2.protocolMapper
          },
          mapping: mapping2,
          data: data2
        };
      } else {
        const model = type ? await adminClient.clientScopes.findOne({id: id3}) : await adminClient.clients.findOne({id: id3});
        if (!model) {
          throw new Error(t5("common:notFound"));
        }
        const protocolMappers = serverInfo2.protocolMapperTypes[model.protocol];
        const mapping2 = protocolMappers.find((mapper) => mapper.id === mapperId);
        if (!mapping2) {
          throw new Error(t5("common:notFound"));
        }
        return {
          mapping: mapping2,
          config: {
            protocol: model.protocol,
            protocolMapper: mapperId
          }
        };
      }
    }, ({config: config22, mapping: mapping2, data: data2}) => {
      setConfig(config22);
      setMapping(mapping2);
      if (data2) {
        convertToFormValues(data2, setValue);
      }
    }, []);
    const [toggleDeleteDialog, DeleteConfirm] = useConfirmDialog({
      titleKey: "common:deleteMappingTitle",
      messageKey: "common:deleteMappingConfirm",
      continueButtonLabel: "common:delete",
      continueButtonVariant: ButtonVariant.danger,
      onConfirm: async () => {
        try {
          if (isOnClientScope) {
            await adminClient.clientScopes.delProtocolMapper({
              id: id3,
              mapperId
            });
          } else {
            await adminClient.clients.delProtocolMapper({
              id: id3,
              mapperId
            });
          }
          addAlert(t5("common:mappingDeletedSuccess"), AlertVariant.success);
          history.push(toDetails());
        } catch (error2) {
          addError("common:mappingDeletedError", error2);
        }
      }
    });
    const save = async (formMapping) => {
      const key = isUpdating ? "Updated" : "Created";
      try {
        const mapping2 = {...config2, ...convertFormValuesToObject(formMapping)};
        if (isUpdating) {
          isOnClientScope ? await adminClient.clientScopes.updateProtocolMapper({id: id3, mapperId}, {id: mapperId, ...mapping2}) : await adminClient.clients.updateProtocolMapper({id: id3, mapperId}, {id: mapperId, ...mapping2});
        } else {
          isOnClientScope ? await adminClient.clientScopes.addProtocolMapper({id: id3}, mapping2) : await adminClient.clients.addProtocolMapper({id: id3}, mapping2);
        }
        addAlert(t5(`common:mapping${key}Success`), AlertVariant.success);
      } catch (error2) {
        addError(`common:mapping${key}Error`, error2);
      }
    };
    return /* @__PURE__ */ react.createElement(react.Fragment, null, /* @__PURE__ */ react.createElement(DeleteConfirm, null), /* @__PURE__ */ react.createElement(ViewHeader, {
      titleKey: isUpdating ? mapping?.name : t5("common:addMapper"),
      subKey: isUpdating ? mapperId : "client-scopes:addMapperExplain",
      dropdownItems: isUpdating ? [
        /* @__PURE__ */ react.createElement(DropdownItem, {
          key: "delete",
          value: "delete",
          onClick: toggleDeleteDialog
        }, t5("common:delete"))
      ] : void 0
    }), /* @__PURE__ */ react.createElement(PageSection, {
      variant: "light"
    }, /* @__PURE__ */ react.createElement(FormAccess, {
      isHorizontal: true,
      onSubmit: handleSubmit(save),
      role: "manage-clients",
      className: "keycloak__client-scope-mapping-details__form"
    }, /* @__PURE__ */ react.createElement(FormGroup, {
      label: t5("common:mapperType"),
      fieldId: "mapperType"
    }, /* @__PURE__ */ react.createElement(TextInput, {
      type: "text",
      id: "mapperType",
      name: "mapperType",
      isReadOnly: true,
      value: mapping?.name
    })), /* @__PURE__ */ react.createElement(FormGroup, {
      label: t5("common:name"),
      labelIcon: /* @__PURE__ */ react.createElement(HelpItem, {
        helpText: "client-scopes-help:mapperName",
        forLabel: t5("common:name"),
        forID: "name"
      }),
      fieldId: "name",
      isRequired: true,
      validated: errors.name ? ValidatedOptions.error : ValidatedOptions.default,
      helperTextInvalid: t5("common:required")
    }, /* @__PURE__ */ react.createElement(TextInput, {
      ref: register2({required: true}),
      type: "text",
      id: "name",
      name: "name",
      isReadOnly: isUpdating,
      validated: errors.name ? ValidatedOptions.error : ValidatedOptions.default
    })), /* @__PURE__ */ react.createElement(FormProvider, {
      ...form2
    }, /* @__PURE__ */ react.createElement(DynamicComponents, {
      properties: mapping?.properties || []
    })), /* @__PURE__ */ react.createElement(ActionGroup, null, /* @__PURE__ */ react.createElement(Button, {
      variant: "primary",
      type: "submit"
    }, t5("common:save")), /* @__PURE__ */ react.createElement(Button, {
      variant: "link",
      component: (props) => /* @__PURE__ */ react.createElement(Link, {
        ...props,
        to: toDetails()
      })
    }, t5("common:cancel"))))));
  }
});

// build/client-scopes/form/ClientScopeForm.js
var require_ClientScopeForm = __commonJS((exports2) => {
  __markAsModule(exports2);
  __export(exports2, {
    default: () => ClientScopeForm
  });
  function ClientScopeForm() {
    const {t: t5} = useTranslation("client-scopes");
    const [clientScope, setClientScope] = useState();
    const history = useHistory();
    const {realm: realm2} = useRealm();
    const [hide3, toggleHide] = useToggle();
    const adminClient = useAdminClient();
    const {id: id3, type} = useParams();
    const {addAlert, addError} = useAlerts();
    const [key, setKey] = useState(0);
    const refresh = () => setKey(new Date().getTime());
    useFetch(async () => {
      if (id3) {
        const clientScope2 = await adminClient.clientScopes.findOne({id: id3});
        if (!clientScope2) {
          throw new Error(t5("common:notFound"));
        }
        return {
          ...clientScope2,
          type
        };
      }
    }, (clientScope2) => {
      setClientScope(clientScope2);
    }, [key, id3]);
    const loader = async () => {
      const assignedRoles = (await adminClient.clientScopes.listRealmScopeMappings({id: id3})).map((role) => ({role}));
      const effectiveRoles = (await adminClient.clientScopes.listCompositeRealmScopeMappings({id: id3})).map((role) => ({role}));
      const clients2 = await adminClient.clients.find();
      const clientRoles = (await Promise.all(clients2.map(async (client2) => {
        const clientAssignedRoles = (await adminClient.clientScopes.listClientScopeMappings({
          id: id3,
          client: client2.id
        })).map((role) => ({role, client: client2}));
        const clientEffectiveRoles = (await adminClient.clientScopes.listCompositeClientScopeMappings({
          id: id3,
          client: client2.id
        })).map((role) => ({role, client: client2}));
        return mapRoles(clientAssignedRoles, clientEffectiveRoles, hide3);
      }))).flat();
      return [...mapRoles(assignedRoles, effectiveRoles, hide3), ...clientRoles];
    };
    const save = async (clientScopes2) => {
      try {
        clientScopes2.name = clientScopes2.name?.trim();
        clientScopes2 = convertFormValuesToObject(clientScopes2);
        if (id3) {
          await adminClient.clientScopes.update({id: id3}, clientScopes2);
          changeScope(adminClient, {...clientScopes2, id: id3, type}, clientScopes2.type);
        } else {
          await adminClient.clientScopes.create(clientScopes2);
          const scope = await adminClient.clientScopes.findOneByName({
            name: clientScopes2.name
          });
          if (!scope) {
            throw new Error(t5("common:notFound"));
          }
          changeScope(adminClient, {...clientScopes2, id: scope.id}, clientScopes2.type);
          history.push(toClientScope({
            realm: realm2,
            id: scope.id,
            type: clientScopes2.type || "none",
            tab: "settings"
          }));
        }
        addAlert(t5((id3 ? "update" : "create") + "Success"), AlertVariant.success);
      } catch (error2) {
        addError(`client-scopes:${id3 ? "update" : "create"}Error`, error2);
      }
    };
    const [toggleDeleteDialog, DeleteConfirm] = useConfirmDialog({
      titleKey: t5("deleteClientScope", {
        count: 1,
        name: clientScope?.name
      }),
      messageKey: "client-scopes:deleteConfirm",
      continueButtonLabel: "common:delete",
      continueButtonVariant: ButtonVariant.danger,
      onConfirm: async () => {
        try {
          await adminClient.clientScopes.del({id: id3});
          addAlert(t5("deletedSuccess"), AlertVariant.success);
        } catch (error2) {
          addError("client-scopes:deleteError", error2);
        }
      }
    });
    const assignRoles = async (rows) => {
      try {
        const realmRoles = rows.filter((row) => row.client === void 0).map((row) => row.role).flat();
        await adminClient.clientScopes.addRealmScopeMappings({
          id: id3
        }, realmRoles);
        await Promise.all(rows.filter((row) => row.client !== void 0).map((row) => adminClient.clientScopes.addClientScopeMappings({
          id: id3,
          client: row.client.id
        }, [row.role])));
        addAlert(t5("roleMappingUpdatedSuccess"), AlertVariant.success);
      } catch (error2) {
        addError("client-scopes:roleMappingUpdatedError", error2);
      }
    };
    const addMappers = async (mappers) => {
      if (!Array.isArray(mappers)) {
        const mapper = mappers;
        history.push(toMapper({
          realm: realm2,
          id: clientScope.id,
          type,
          mapperId: mapper.id
        }));
      } else {
        try {
          await adminClient.clientScopes.addMultipleProtocolMappers({id: clientScope.id}, mappers);
          refresh();
          addAlert(t5("common:mappingCreatedSuccess"), AlertVariant.success);
        } catch (error2) {
          addError("common:mappingCreatedError", error2);
        }
      }
    };
    const onDelete = async (mapper) => {
      try {
        await adminClient.clientScopes.delProtocolMapper({
          id: clientScope.id,
          mapperId: mapper.id
        });
        addAlert(t5("common:mappingDeletedSuccess"), AlertVariant.success);
        refresh();
      } catch (error2) {
        addError("common:mappingDeletedError", error2);
      }
      return true;
    };
    if (id3 && !clientScope) {
      return /* @__PURE__ */ react.createElement(KeycloakSpinner, null);
    }
    return /* @__PURE__ */ react.createElement(react.Fragment, null, /* @__PURE__ */ react.createElement(DeleteConfirm, null), /* @__PURE__ */ react.createElement(ViewHeader, {
      titleKey: clientScope ? clientScope.name : "client-scopes:createClientScope",
      dropdownItems: clientScope ? [
        /* @__PURE__ */ react.createElement(DropdownItem, {
          key: "delete",
          onClick: toggleDeleteDialog
        }, t5("common:delete"))
      ] : void 0,
      badges: [{text: clientScope ? clientScope.protocol : void 0}],
      divider: !id3
    }), /* @__PURE__ */ react.createElement(PageSection, {
      variant: "light",
      className: "pf-u-p-0"
    }, !id3 && /* @__PURE__ */ react.createElement(PageSection, {
      variant: "light"
    }, /* @__PURE__ */ react.createElement(ScopeForm, {
      save,
      clientScope: {}
    })), id3 && clientScope && /* @__PURE__ */ react.createElement(KeycloakTabs, {
      isBox: true
    }, /* @__PURE__ */ react.createElement(Tab, {
      eventKey: "settings",
      title: /* @__PURE__ */ react.createElement(TabTitleText, null, t5("common:settings"))
    }, /* @__PURE__ */ react.createElement(PageSection, {
      variant: "light"
    }, /* @__PURE__ */ react.createElement(ScopeForm, {
      save,
      clientScope
    }))), /* @__PURE__ */ react.createElement(Tab, {
      eventKey: "mappers",
      title: /* @__PURE__ */ react.createElement(TabTitleText, null, t5("common:mappers"))
    }, /* @__PURE__ */ react.createElement(MapperList, {
      model: clientScope,
      onAdd: addMappers,
      onDelete,
      detailLink: (id22) => toMapper({realm: realm2, id: clientScope.id, type, mapperId: id22})
    })), /* @__PURE__ */ react.createElement(Tab, {
      "data-testid": "scopeTab",
      eventKey: "scope",
      title: /* @__PURE__ */ react.createElement(TabTitleText, null, t5("scope"))
    }, /* @__PURE__ */ react.createElement(RoleMapping, {
      id: id3,
      name: clientScope.name,
      type: "client-scope",
      loader,
      save: assignRoles,
      onHideRolesToggle: toggleHide
    })))));
  }
});

// build/realm-settings/key-providers/aes-generated/AESGeneratedForm.js
var require_AESGeneratedForm = __commonJS((exports2) => {
  __markAsModule(exports2);
  __export(exports2, {
    AESGeneratedForm: () => AESGeneratedForm2,
    default: () => AESGeneratedSettings
  });
  var AESGeneratedForm2 = ({
    editMode,
    providerType,
    handleModalToggle,
    refresh
  }) => {
    const {t: t5} = useTranslation("realm-settings");
    const serverInfo2 = useServerInfo();
    const [isKeySizeDropdownOpen, setIsKeySizeDropdownOpen] = useState(false);
    const adminClient = useAdminClient();
    const {addAlert, addError} = useAlerts();
    const {id: id3} = useParams();
    const providerId = useRouteMatch("/:providerType?")?.params.providerType;
    const save = async (component) => {
      try {
        if (id3) {
          await adminClient.components.update({id: id3}, {
            ...component,
            parentId: component.parentId,
            providerId: providerType,
            providerType: KEY_PROVIDER_TYPE
          });
          addAlert(t5("saveProviderSuccess"), AlertVariant.success);
        } else {
          await adminClient.components.create({
            ...component,
            parentId: component.parentId,
            providerId: providerType,
            providerType: KEY_PROVIDER_TYPE,
            config: {priority: ["0"]}
          });
          handleModalToggle?.();
          addAlert(t5("saveProviderSuccess"), AlertVariant.success);
          refresh?.();
        }
      } catch (error2) {
        addError("realm-settings:saveProviderError", error2);
      }
    };
    const form2 = useForm({mode: "onChange"});
    const setupForm = (component) => {
      form2.reset();
      convertToFormValues(component, form2.setValue);
    };
    useFetch(async () => {
      if (editMode)
        return await adminClient.components.findOne({id: id3});
    }, (result) => {
      if (result) {
        setupForm(result);
      }
    }, []);
    const allComponentTypes = serverInfo2.componentTypes?.[KEY_PROVIDER_TYPE] ?? [];
    const aesSecretSizeOptions = allComponentTypes[0].properties[3].options;
    return /* @__PURE__ */ react.createElement(FormAccess, {
      isHorizontal: true,
      id: "add-provider",
      className: "pf-u-mt-lg",
      role: "manage-realm",
      onSubmit: form2.handleSubmit(save)
    }, editMode && /* @__PURE__ */ react.createElement(FormGroup, {
      label: t5("providerId"),
      labelIcon: /* @__PURE__ */ react.createElement(HelpItem, {
        helpText: "client-scopes-help:mapperName",
        forLabel: t5("common:name"),
        forID: "name"
      }),
      fieldId: "id",
      isRequired: true,
      validated: form2.errors.name ? ValidatedOptions.error : ValidatedOptions.default,
      helperTextInvalid: t5("common:required")
    }, /* @__PURE__ */ react.createElement(TextInput, {
      ref: form2.register(),
      id: "id",
      type: "text",
      name: "id",
      isReadOnly: editMode,
      "aria-label": t5("consoleDisplayName"),
      defaultValue: id3,
      "data-testid": "display-name-input"
    })), /* @__PURE__ */ react.createElement(FormGroup, {
      label: t5("common:name"),
      labelIcon: /* @__PURE__ */ react.createElement(HelpItem, {
        helpText: "client-scopes-help:mapperName",
        forLabel: t5("common:name"),
        forID: "name"
      }),
      fieldId: "name",
      isRequired: true,
      validated: form2.errors.name ? ValidatedOptions.error : ValidatedOptions.default,
      helperTextInvalid: t5("common:required")
    }, !editMode && /* @__PURE__ */ react.createElement(Controller, {
      name: "name",
      control: form2.control,
      defaultValue: providerType,
      render: ({onChange, value}) => {
        return /* @__PURE__ */ react.createElement(TextInput, {
          id: "name",
          type: "text",
          "aria-label": t5("consoleDisplayName"),
          defaultValue: providerType,
          value,
          onChange: (value2) => onChange(value2),
          "data-testid": "display-name-input"
        });
      }
    }), editMode && /* @__PURE__ */ react.createElement(TextInput, {
      ref: form2.register(),
      type: "text",
      id: "name",
      name: "name",
      defaultValue: providerId,
      validated: form2.errors.name ? ValidatedOptions.error : ValidatedOptions.default
    })), /* @__PURE__ */ react.createElement(FormGroup, {
      label: t5("common:enabled"),
      fieldId: "kc-enabled",
      labelIcon: /* @__PURE__ */ react.createElement(HelpItem, {
        helpText: t5("realm-settings-help:enabled"),
        forLabel: t5("enabled"),
        forID: "kc-enabled"
      })
    }, /* @__PURE__ */ react.createElement(Controller, {
      name: "config.enabled",
      control: form2.control,
      defaultValue: ["true"],
      render: ({onChange, value}) => /* @__PURE__ */ react.createElement(Switch, {
        id: "kc-enabled",
        label: t5("common:on"),
        labelOff: t5("common:off"),
        isChecked: value[0] === "true",
        "data-testid": value[0] === "true" ? "internationalization-enabled" : "internationalization-disabled",
        onChange: (value2) => {
          onChange([value2.toString()]);
        }
      })
    })), /* @__PURE__ */ react.createElement(FormGroup, {
      label: t5("active"),
      fieldId: "kc-active",
      labelIcon: /* @__PURE__ */ react.createElement(HelpItem, {
        helpText: "realm-settings-help:active",
        forLabel: t5("active"),
        forID: "kc-active"
      })
    }, /* @__PURE__ */ react.createElement(Controller, {
      name: "config.active",
      control: form2.control,
      defaultValue: ["true"],
      render: ({onChange, value}) => {
        return /* @__PURE__ */ react.createElement(Switch, {
          id: "kc-active",
          label: t5("common:on"),
          labelOff: t5("common:off"),
          isChecked: value[0] === "true",
          "data-testid": value[0] === "true" ? "internationalization-enabled" : "internationalization-disabled",
          onChange: (value2) => {
            onChange([value2.toString()]);
          }
        });
      }
    })), /* @__PURE__ */ react.createElement(FormGroup, {
      label: t5("AESKeySize"),
      fieldId: "kc-aes-keysize",
      labelIcon: /* @__PURE__ */ react.createElement(HelpItem, {
        helpText: "realm-settings-help:AESKeySize",
        forLabel: t5("AESKeySize"),
        forID: "kc-aes-key-size"
      })
    }, /* @__PURE__ */ react.createElement(Controller, {
      name: "config.secretSize",
      control: form2.control,
      defaultValue: ["16"],
      render: ({onChange, value}) => /* @__PURE__ */ react.createElement(Select, {
        toggleId: "kc-aes-keysize",
        onToggle: () => setIsKeySizeDropdownOpen(!isKeySizeDropdownOpen),
        onSelect: (_23, value2) => {
          onChange([value2.toString()]);
          setIsKeySizeDropdownOpen(false);
        },
        selections: [value.toString()],
        isOpen: isKeySizeDropdownOpen,
        variant: SelectVariant.single,
        "aria-label": t5("aesKeySize"),
        "data-testid": "select-secret-size"
      }, aesSecretSizeOptions?.map((item) => /* @__PURE__ */ react.createElement(SelectOption, {
        selected: item === value,
        key: item,
        value: item
      })))
    })), /* @__PURE__ */ react.createElement(ActionGroup, {
      className: "kc-AESform-buttons"
    }, /* @__PURE__ */ react.createElement(Button, {
      className: "kc-AESform-save-button",
      "data-testid": "add-provider-button",
      variant: "primary",
      type: "submit"
    }, t5("common:save")), /* @__PURE__ */ react.createElement(Button, {
      className: "kc-AESform-cancel-button",
      onClick: !editMode && handleModalToggle || void 0,
      variant: "link"
    }, t5("common:cancel"))));
  };
  function AESGeneratedSettings() {
    const {t: t5} = useTranslation("realm-settings");
    const providerId = useRouteMatch("/:realm/realm-settings/keys/:id?/:providerType?/settings")?.params.providerType;
    return /* @__PURE__ */ react.createElement(react.Fragment, null, /* @__PURE__ */ react.createElement(ViewHeader, {
      titleKey: t5("editProvider"),
      subKey: providerId
    }), /* @__PURE__ */ react.createElement(PageSection, {
      variant: "light"
    }, /* @__PURE__ */ react.createElement(AESGeneratedForm2, {
      providerType: providerId,
      editMode: true
    })));
  }
});

// build/realm-settings/key-providers/java-keystore/JavaKeystoreForm.js
var require_JavaKeystoreForm = __commonJS((exports2) => {
  __markAsModule(exports2);
  __export(exports2, {
    JavaKeystoreForm: () => JavaKeystoreForm2,
    default: () => JavaKeystoreSettings
  });
  var JavaKeystoreForm2 = ({
    editMode,
    providerType,
    handleModalToggle,
    refresh
  }) => {
    const {t: t5} = useTranslation("realm-settings");
    const serverInfo2 = useServerInfo();
    const [isAlgorithmDropdownOpen, setIsAlgorithmDropdownOpen] = useState(false);
    const adminClient = useAdminClient();
    const {addAlert, addError} = useAlerts();
    const {id: id3} = useParams();
    const providerId = useRouteMatch("/:providerType?")?.params.providerType;
    const save = async (component) => {
      try {
        if (id3) {
          await adminClient.components.update({id: id3}, {
            ...component,
            parentId: component.parentId,
            providerId: providerType,
            providerType: KEY_PROVIDER_TYPE
          });
          addAlert(t5("saveProviderSuccess"), AlertVariant.success);
        } else {
          await adminClient.components.create({
            ...component,
            parentId: component.parentId,
            providerId: providerType,
            providerType: KEY_PROVIDER_TYPE,
            config: {priority: ["0"]}
          });
          handleModalToggle?.();
          addAlert(t5("saveProviderSuccess"), AlertVariant.success);
          refresh?.();
        }
      } catch (error2) {
        addError("realm-settings:saveProviderError", error2);
      }
    };
    const form2 = useForm({mode: "onChange"});
    const setupForm = (component) => {
      form2.reset();
      convertToFormValues(component, form2.setValue);
    };
    useFetch(async () => {
      if (editMode)
        return await adminClient.components.findOne({id: id3});
    }, (result) => {
      if (result) {
        setupForm(result);
      }
    }, []);
    const allComponentTypes = serverInfo2.componentTypes?.[KEY_PROVIDER_TYPE] ?? [];
    const javaKeystoreAlgorithmOptions = allComponentTypes[3].properties[3].options;
    return /* @__PURE__ */ react.createElement(FormAccess, {
      isHorizontal: true,
      id: "add-provider",
      className: "pf-u-mt-lg",
      role: "manage-realm",
      onSubmit: form2.handleSubmit(save)
    }, editMode && /* @__PURE__ */ react.createElement(FormGroup, {
      label: t5("providerId"),
      labelIcon: /* @__PURE__ */ react.createElement(HelpItem, {
        helpText: "client-scopes-help:mapperName",
        forLabel: t5("common:name"),
        forID: t5("common:helpLabel", {label: t5("common:name")})
      }),
      fieldId: "id",
      isRequired: true,
      validated: form2.errors.name ? ValidatedOptions.error : ValidatedOptions.default,
      helperTextInvalid: t5("common:required")
    }, /* @__PURE__ */ react.createElement(TextInput, {
      ref: form2.register(),
      id: "id",
      type: "text",
      name: "id",
      isReadOnly: editMode,
      "aria-label": t5("consoleDisplayName"),
      defaultValue: id3,
      "data-testid": "display-name-input"
    })), /* @__PURE__ */ react.createElement(FormGroup, {
      label: t5("common:name"),
      labelIcon: /* @__PURE__ */ react.createElement(HelpItem, {
        helpText: "client-scopes-help:mapperName",
        forLabel: t5("common:name"),
        forID: t5("common:helpLabel", {label: t5("common:name")})
      }),
      fieldId: "name",
      isRequired: true,
      validated: form2.errors.name ? ValidatedOptions.error : ValidatedOptions.default,
      helperTextInvalid: t5("common:required")
    }, !editMode && /* @__PURE__ */ react.createElement(Controller, {
      name: "name",
      control: form2.control,
      defaultValue: providerType,
      render: ({onChange, value}) => {
        return /* @__PURE__ */ react.createElement(TextInput, {
          id: "name",
          type: "text",
          "aria-label": t5("consoleDisplayName"),
          defaultValue: providerType,
          value,
          onChange: (value2) => onChange(value2),
          "data-testid": "display-name-input"
        });
      }
    }), editMode && /* @__PURE__ */ react.createElement(TextInput, {
      ref: form2.register(),
      type: "text",
      id: "name",
      name: "name",
      defaultValue: providerId,
      validated: form2.errors.name ? ValidatedOptions.error : ValidatedOptions.default
    })), /* @__PURE__ */ react.createElement(FormGroup, {
      label: t5("common:enabled"),
      fieldId: "kc-enabled",
      labelIcon: /* @__PURE__ */ react.createElement(HelpItem, {
        helpText: t5("realm-settings-help:enabled"),
        forLabel: t5("enabled"),
        forID: t5("common:helpLabel", {label: t5("enabled")})
      })
    }, /* @__PURE__ */ react.createElement(Controller, {
      name: "config.enabled",
      control: form2.control,
      defaultValue: ["true"],
      render: ({onChange, value}) => /* @__PURE__ */ react.createElement(Switch, {
        id: "kc-enabled-switch",
        label: t5("common:on"),
        labelOff: t5("common:off"),
        isChecked: value[0] === "true",
        "data-testid": value[0] === "true" ? "enabled" : "disabled",
        onChange: (value2) => {
          onChange([value2.toString()]);
        }
      })
    })), /* @__PURE__ */ react.createElement(FormGroup, {
      label: t5("active"),
      fieldId: "kc-active",
      labelIcon: /* @__PURE__ */ react.createElement(HelpItem, {
        helpText: "realm-settings-help:active",
        forLabel: t5("active"),
        forID: t5("common:helpLabel", {label: t5("active")})
      })
    }, /* @__PURE__ */ react.createElement(Controller, {
      name: "config.active",
      control: form2.control,
      defaultValue: ["true"],
      render: ({onChange, value}) => {
        return /* @__PURE__ */ react.createElement(Switch, {
          id: "kc-active-switch",
          label: t5("common:on"),
          labelOff: t5("common:off"),
          isChecked: value[0] === "true",
          "data-testid": value[0] === "true" ? "active" : "passive",
          onChange: (value2) => {
            onChange([value2.toString()]);
          }
        });
      }
    })), /* @__PURE__ */ react.createElement(FormGroup, {
      label: t5("algorithm"),
      fieldId: "kc-algorithm",
      labelIcon: /* @__PURE__ */ react.createElement(HelpItem, {
        helpText: "realm-settings-help:algorithm",
        forLabel: t5("algorithm"),
        forID: t5("common:helpLabel", {label: t5("algorithm")})
      })
    }, /* @__PURE__ */ react.createElement(Controller, {
      name: "config.algorithm",
      control: form2.control,
      defaultValue: ["RS256"],
      render: ({onChange, value}) => /* @__PURE__ */ react.createElement(Select, {
        toggleId: "kc-elliptic",
        onToggle: (isExpanded) => setIsAlgorithmDropdownOpen(isExpanded),
        onSelect: (_23, value2) => {
          onChange([value2.toString()]);
          setIsAlgorithmDropdownOpen(false);
        },
        selections: [value.toString()],
        variant: SelectVariant.single,
        "aria-label": t5("algorithm"),
        isOpen: isAlgorithmDropdownOpen,
        placeholderText: "Select one...",
        "data-testid": "select-algorithm"
      }, javaKeystoreAlgorithmOptions.map((p2, idx) => /* @__PURE__ */ react.createElement(SelectOption, {
        selected: p2 === value,
        key: `algorithm-${idx}`,
        value: p2
      })))
    })), /* @__PURE__ */ react.createElement(FormGroup, {
      label: t5("keystore"),
      fieldId: "kc-keystore",
      labelIcon: /* @__PURE__ */ react.createElement(HelpItem, {
        helpText: "realm-settings-help:keystore",
        forLabel: t5("keystore"),
        forID: "kc-keystore"
      })
    }, /* @__PURE__ */ react.createElement(Controller, {
      name: "config.keystore",
      control: form2.control,
      defaultValue: [],
      render: ({onChange}) => /* @__PURE__ */ react.createElement(TextInput, {
        "aria-label": t5("keystore"),
        onChange: (value) => {
          onChange([value.toString()]);
        },
        "data-testid": "select-display-name"
      })
    })), /* @__PURE__ */ react.createElement(FormGroup, {
      label: t5("keystorePassword"),
      fieldId: "kc-keystore-password",
      labelIcon: /* @__PURE__ */ react.createElement(HelpItem, {
        helpText: "realm-settings-help:keystorePassword",
        forLabel: t5("keystorePassword"),
        forID: t5("common:helpLabel", {label: t5("keystorePassword")})
      })
    }, /* @__PURE__ */ react.createElement(Controller, {
      name: "config.keystorePassword",
      control: form2.control,
      defaultValue: [],
      render: ({onChange}) => /* @__PURE__ */ react.createElement(TextInput, {
        "aria-label": t5("consoleDisplayName"),
        onChange: (value) => {
          onChange([value.toString()]);
        },
        "data-testid": "select-display-name"
      })
    })), /* @__PURE__ */ react.createElement(FormGroup, {
      label: t5("keyAlias"),
      fieldId: "kc-key-alias",
      labelIcon: /* @__PURE__ */ react.createElement(HelpItem, {
        helpText: "realm-settings-help:keyAlias",
        forLabel: t5("keyAlias"),
        forID: t5("common:helpLabel", {label: t5("keyAlias")})
      })
    }, /* @__PURE__ */ react.createElement(Controller, {
      name: "config.keyAlias",
      control: form2.control,
      defaultValue: [],
      render: ({onChange}) => /* @__PURE__ */ react.createElement(TextInput, {
        "aria-label": t5("keyAlias"),
        onChange: (value) => {
          onChange([value.toString()]);
        },
        "data-testid": "key-alias"
      })
    })), /* @__PURE__ */ react.createElement(FormGroup, {
      label: t5("keyPassword"),
      fieldId: "kc-key-password",
      labelIcon: /* @__PURE__ */ react.createElement(HelpItem, {
        helpText: "realm-settings-help:keyPassword",
        forLabel: t5("keyPassword"),
        forID: t5("common:helpLabel", {label: t5("keyPassword")})
      })
    }, /* @__PURE__ */ react.createElement(Controller, {
      name: "config.keyPassword",
      control: form2.control,
      defaultValue: [],
      render: ({onChange}) => /* @__PURE__ */ react.createElement(TextInput, {
        "aria-label": t5("keyPassword"),
        onChange: (value) => {
          onChange([value.toString()]);
        },
        "data-testid": "key-password"
      })
    })), /* @__PURE__ */ react.createElement(ActionGroup, {
      className: "kc-java-keystore-form-buttons"
    }, /* @__PURE__ */ react.createElement(Button, {
      className: "kc-java-keystore-form-save-button",
      "data-testid": "add-provider-button",
      variant: "primary",
      type: "submit"
    }, t5("common:save")), /* @__PURE__ */ react.createElement(Button, {
      className: "kc-java-keystore-form-cancel-button",
      onClick: !editMode && handleModalToggle || void 0,
      variant: "link"
    }, t5("common:cancel"))));
  };
  function JavaKeystoreSettings() {
    const {t: t5} = useTranslation("realm-settings");
    const providerId = useRouteMatch("/:realm/realm-settings/keys/:id?/:providerType?/settings")?.params.providerType;
    return /* @__PURE__ */ react.createElement(react.Fragment, null, /* @__PURE__ */ react.createElement(ViewHeader, {
      titleKey: t5("editProvider"),
      subKey: providerId
    }), /* @__PURE__ */ react.createElement(PageSection, {
      variant: "light"
    }, /* @__PURE__ */ react.createElement(JavaKeystoreForm2, {
      providerType: providerId,
      editMode: true
    })));
  }
});

// build/realm-settings/key-providers/hmac-generated/HMACGeneratedForm.js
var require_HMACGeneratedForm = __commonJS((exports2) => {
  __markAsModule(exports2);
  __export(exports2, {
    HMACGeneratedForm: () => HMACGeneratedForm2,
    default: () => HMACGeneratedSettings
  });
  var HMACGeneratedForm2 = ({
    editMode,
    providerType,
    handleModalToggle,
    refresh
  }) => {
    const {t: t5} = useTranslation("realm-settings");
    const serverInfo2 = useServerInfo();
    const [isKeySizeDropdownOpen, setIsKeySizeDropdownOpen] = useState(false);
    const [isEllipticCurveDropdownOpen, setIsEllipticCurveDropdownOpen] = useState(false);
    const adminClient = useAdminClient();
    const {addAlert, addError} = useAlerts();
    const {id: id3} = useParams();
    const providerId = useRouteMatch("/:providerType?")?.params.providerType;
    const save = async (component) => {
      try {
        if (id3) {
          await adminClient.components.update({id: id3}, {
            ...component,
            parentId: component.parentId,
            providerId: providerType,
            providerType: KEY_PROVIDER_TYPE
          });
          addAlert(t5("saveProviderSuccess"), AlertVariant.success);
        } else {
          await adminClient.components.create({
            ...component,
            parentId: component.parentId,
            providerId: providerType,
            providerType: KEY_PROVIDER_TYPE,
            config: {priority: ["0"]}
          });
          handleModalToggle?.();
          addAlert(t5("saveProviderSuccess"), AlertVariant.success);
          refresh?.();
        }
      } catch (error2) {
        addError("realm-settings:saveProviderError", error2);
      }
    };
    const form2 = useForm({mode: "onChange"});
    const setupForm = (component) => {
      form2.reset();
      convertToFormValues(component, form2.setValue);
    };
    useFetch(async () => {
      if (editMode)
        return await adminClient.components.findOne({id: id3});
    }, (result) => {
      if (result) {
        setupForm(result);
      }
    }, []);
    const allComponentTypes = serverInfo2.componentTypes?.[KEY_PROVIDER_TYPE] ?? [];
    const hmacSecretSizeOptions = allComponentTypes[2].properties[3].options;
    const hmacAlgorithmOptions = allComponentTypes[2].properties[4].options;
    return /* @__PURE__ */ react.createElement(FormAccess, {
      isHorizontal: true,
      id: "add-provider",
      className: "pf-u-mt-lg",
      role: "manage-realm",
      onSubmit: form2.handleSubmit(save)
    }, editMode && /* @__PURE__ */ react.createElement(FormGroup, {
      label: t5("providerId"),
      labelIcon: /* @__PURE__ */ react.createElement(HelpItem, {
        helpText: "client-scopes-help:mapperName",
        forLabel: t5("common:name"),
        forID: t5("common:helpLabel", {label: t5("common:name")})
      }),
      fieldId: "id",
      isRequired: true,
      validated: form2.errors.name ? ValidatedOptions.error : ValidatedOptions.default,
      helperTextInvalid: t5("common:required")
    }, /* @__PURE__ */ react.createElement(TextInput, {
      ref: form2.register(),
      id: "id",
      type: "text",
      name: "id",
      isReadOnly: editMode,
      "aria-label": t5("consoleDisplayName"),
      defaultValue: id3,
      "data-testid": "display-name-input"
    })), /* @__PURE__ */ react.createElement(FormGroup, {
      label: t5("common:name"),
      labelIcon: /* @__PURE__ */ react.createElement(HelpItem, {
        helpText: "client-scopes-help:mapperName",
        forLabel: t5("common:name"),
        forID: t5("common:helpLabel", {label: t5("common:name")})
      }),
      fieldId: "name",
      isRequired: true,
      validated: form2.errors.name ? ValidatedOptions.error : ValidatedOptions.default,
      helperTextInvalid: t5("common:required")
    }, !editMode && /* @__PURE__ */ react.createElement(Controller, {
      name: "name",
      control: form2.control,
      defaultValue: providerType,
      render: ({onChange, value}) => {
        return /* @__PURE__ */ react.createElement(TextInput, {
          id: "name",
          type: "text",
          "aria-label": t5("consoleDisplayName"),
          defaultValue: providerType,
          value,
          onChange: (value2) => onChange(value2),
          "data-testid": "display-name-input"
        });
      }
    }), editMode && /* @__PURE__ */ react.createElement(TextInput, {
      ref: form2.register(),
      type: "text",
      id: "name",
      name: "name",
      defaultValue: providerId,
      validated: form2.errors.name ? ValidatedOptions.error : ValidatedOptions.default
    })), /* @__PURE__ */ react.createElement(FormGroup, {
      label: t5("common:enabled"),
      fieldId: "kc-enabled",
      labelIcon: /* @__PURE__ */ react.createElement(HelpItem, {
        helpText: t5("realm-settings-help:enabled"),
        forLabel: t5("enabled"),
        forID: t5("common:helpLabel", {label: t5("enabled")})
      })
    }, /* @__PURE__ */ react.createElement(Controller, {
      name: "config.enabled",
      control: form2.control,
      defaultValue: ["true"],
      render: ({onChange, value}) => /* @__PURE__ */ react.createElement(Switch, {
        id: "kc-enabled-switch",
        label: t5("common:on"),
        labelOff: t5("common:off"),
        isChecked: value[0] === "true",
        "data-testid": value[0] === "true" ? "enabled" : "disabled",
        onChange: (value2) => {
          onChange([value2.toString()]);
        }
      })
    })), /* @__PURE__ */ react.createElement(FormGroup, {
      label: t5("active"),
      fieldId: "kc-active",
      labelIcon: /* @__PURE__ */ react.createElement(HelpItem, {
        helpText: "realm-settings-help:active",
        forLabel: t5("active"),
        forID: t5("common:helpLabel", {label: t5("active")})
      })
    }, /* @__PURE__ */ react.createElement(Controller, {
      name: "config.active",
      control: form2.control,
      defaultValue: ["true"],
      render: ({onChange, value}) => {
        return /* @__PURE__ */ react.createElement(Switch, {
          id: "kc-active-switch",
          label: t5("common:on"),
          labelOff: t5("common:off"),
          isChecked: value[0] === "true",
          "data-testid": value[0] === "true" ? "active" : "passive",
          onChange: (value2) => {
            onChange([value2.toString()]);
          }
        });
      }
    })), /* @__PURE__ */ react.createElement(FormGroup, {
      label: t5("secretSize"),
      fieldId: "kc-hmac-keysize",
      labelIcon: /* @__PURE__ */ react.createElement(HelpItem, {
        helpText: "realm-settings-help:secretSize",
        forLabel: t5("secretSize"),
        forID: t5("common:helpLabel", {label: t5("secretSize")})
      })
    }, /* @__PURE__ */ react.createElement(Controller, {
      name: "config.secretSize",
      control: form2.control,
      defaultValue: ["64"],
      render: ({onChange, value}) => /* @__PURE__ */ react.createElement(Select, {
        toggleId: "kc-hmac-keysize",
        onToggle: (isExpanded) => setIsKeySizeDropdownOpen(isExpanded),
        onSelect: (_23, value2) => {
          onChange([value2.toString()]);
          setIsKeySizeDropdownOpen(false);
        },
        selections: [value.toString()],
        isOpen: isKeySizeDropdownOpen,
        variant: SelectVariant.single,
        "aria-label": t5("hmacKeySize"),
        "data-testid": "select-secret-size"
      }, hmacSecretSizeOptions.map((item) => /* @__PURE__ */ react.createElement(SelectOption, {
        selected: item === value,
        key: item,
        value: item
      })))
    })), /* @__PURE__ */ react.createElement(FormGroup, {
      label: t5("algorithm"),
      fieldId: "kc-algorithm",
      labelIcon: /* @__PURE__ */ react.createElement(HelpItem, {
        helpText: "realm-settings-help:algorithm",
        forLabel: t5("algorithm"),
        forID: t5("common:helpLabel", {label: t5("algorithm")})
      })
    }, /* @__PURE__ */ react.createElement(Controller, {
      name: "config.algorithm",
      control: form2.control,
      defaultValue: ["HS-256"],
      render: ({onChange, value}) => /* @__PURE__ */ react.createElement(Select, {
        toggleId: "kc-elliptic",
        onToggle: (isExpanded) => setIsEllipticCurveDropdownOpen(isExpanded),
        onSelect: (_23, value2) => {
          onChange([value2.toString()]);
          setIsEllipticCurveDropdownOpen(false);
        },
        selections: [value.toString()],
        variant: SelectVariant.single,
        "aria-label": t5("emailTheme"),
        isOpen: isEllipticCurveDropdownOpen,
        placeholderText: "Select one...",
        "data-testid": "select-email-theme"
      }, hmacAlgorithmOptions.map((p2, idx) => /* @__PURE__ */ react.createElement(SelectOption, {
        selected: p2 === value,
        key: `email-theme-${idx}`,
        value: p2
      })))
    })), /* @__PURE__ */ react.createElement(ActionGroup, {
      className: "kc-hmac-form-buttons"
    }, /* @__PURE__ */ react.createElement(Button, {
      className: "kc-hmac-form-save-button",
      "data-testid": "add-provider-button",
      variant: "primary",
      type: "submit"
    }, t5("common:save")), /* @__PURE__ */ react.createElement(Button, {
      className: "kc-hmac-form-cancel-button",
      onClick: !editMode && handleModalToggle || void 0,
      variant: "link"
    }, t5("common:cancel"))));
  };
  function HMACGeneratedSettings() {
    const {t: t5} = useTranslation("realm-settings");
    const providerId = useRouteMatch("/:realm/realm-settings/keys/:id?/:providerType?/settings")?.params.providerType;
    return /* @__PURE__ */ react.createElement(react.Fragment, null, /* @__PURE__ */ react.createElement(ViewHeader, {
      titleKey: t5("editProvider"),
      subKey: providerId
    }), /* @__PURE__ */ react.createElement(PageSection, {
      variant: "light"
    }, /* @__PURE__ */ react.createElement(HMACGeneratedForm2, {
      providerType: providerId,
      editMode: true
    })));
  }
});

// build/realm-settings/key-providers/ecdsa-generated/ECDSAGeneratedForm.js
var require_ECDSAGeneratedForm = __commonJS((exports2) => {
  __markAsModule(exports2);
  __export(exports2, {
    ECDSAGeneratedForm: () => ECDSAGeneratedForm2,
    default: () => ECDSAGeneratedSettings
  });
  var ECDSAGeneratedForm2 = ({
    editMode,
    providerType,
    handleModalToggle,
    refresh
  }) => {
    const {t: t5} = useTranslation("realm-settings");
    const serverInfo2 = useServerInfo();
    const [isKeySizeDropdownOpen, setIsKeySizeDropdownOpen] = useState(false);
    const adminClient = useAdminClient();
    const {addAlert, addError} = useAlerts();
    const {id: id3} = useParams();
    const providerId = useRouteMatch("/:providerType?")?.params.providerType;
    const save = async (component) => {
      try {
        if (id3) {
          await adminClient.components.update({id: id3}, {
            ...component,
            parentId: component.parentId,
            providerId: providerType,
            providerType: KEY_PROVIDER_TYPE
          });
          addAlert(t5("saveProviderSuccess"), AlertVariant.success);
        } else {
          await adminClient.components.create({
            ...component,
            parentId: component.parentId,
            providerId: providerType,
            providerType: KEY_PROVIDER_TYPE,
            config: {priority: ["0"]}
          });
          handleModalToggle?.();
          addAlert(t5("saveProviderSuccess"), AlertVariant.success);
          refresh?.();
        }
      } catch (error2) {
        addError("realm-settings:saveProviderError", error2);
      }
    };
    const form2 = useForm({mode: "onChange"});
    const setupForm = (component) => {
      form2.reset();
      convertToFormValues(component, form2.setValue);
    };
    useFetch(async () => {
      if (editMode)
        return await adminClient.components.findOne({id: id3});
    }, (result) => {
      if (result) {
        setupForm(result);
      }
    }, []);
    const allComponentTypes = serverInfo2.componentTypes?.[KEY_PROVIDER_TYPE] ?? [];
    const ecdsaEllipticCurveOptions = allComponentTypes[1].properties[3].options;
    return /* @__PURE__ */ react.createElement(FormAccess, {
      isHorizontal: true,
      id: "add-provider",
      className: "pf-u-mt-lg",
      role: "manage-realm",
      onSubmit: form2.handleSubmit(save)
    }, editMode && /* @__PURE__ */ react.createElement(FormGroup, {
      label: t5("providerId"),
      labelIcon: /* @__PURE__ */ react.createElement(HelpItem, {
        helpText: "client-scopes-help:mapperName",
        forLabel: t5("common:name"),
        forID: t5("common:helpLabel", {label: t5("common:name")})
      }),
      fieldId: "id",
      isRequired: true,
      validated: form2.errors.name ? ValidatedOptions.error : ValidatedOptions.default,
      helperTextInvalid: t5("common:required")
    }, /* @__PURE__ */ react.createElement(TextInput, {
      ref: form2.register(),
      id: "id",
      type: "text",
      name: "id",
      isReadOnly: editMode,
      "aria-label": t5("consoleDisplayName"),
      defaultValue: id3,
      "data-testid": "display-name-input"
    })), /* @__PURE__ */ react.createElement(FormGroup, {
      label: t5("common:name"),
      labelIcon: /* @__PURE__ */ react.createElement(HelpItem, {
        helpText: "client-scopes-help:mapperName",
        forLabel: t5("common:name"),
        forID: t5("common:helpLabel", {label: t5("common:name")})
      }),
      fieldId: "name",
      isRequired: true,
      validated: form2.errors.name ? ValidatedOptions.error : ValidatedOptions.default,
      helperTextInvalid: t5("common:required")
    }, !editMode && /* @__PURE__ */ react.createElement(Controller, {
      name: "name",
      control: form2.control,
      defaultValue: providerType,
      render: ({onChange, value}) => {
        return /* @__PURE__ */ react.createElement(TextInput, {
          id: "name",
          type: "text",
          "aria-label": t5("consoleDisplayName"),
          value,
          onChange: (value2) => onChange(value2),
          "data-testid": "display-name-input"
        });
      }
    }), editMode && /* @__PURE__ */ react.createElement(TextInput, {
      ref: form2.register(),
      type: "text",
      id: "name",
      name: "name",
      defaultValue: providerId,
      validated: form2.errors.name ? ValidatedOptions.error : ValidatedOptions.default
    })), /* @__PURE__ */ react.createElement(FormGroup, {
      label: t5("common:enabled"),
      fieldId: "kc-enabled",
      labelIcon: /* @__PURE__ */ react.createElement(HelpItem, {
        helpText: t5("realm-settings-help:enabled"),
        forLabel: t5("enabled"),
        forID: t5("common:helpLabel", {label: t5("enabled")})
      })
    }, /* @__PURE__ */ react.createElement(Controller, {
      name: "config.enabled",
      control: form2.control,
      defaultValue: ["true"],
      render: ({onChange, value}) => /* @__PURE__ */ react.createElement(Switch, {
        id: "kc-enabled-switch",
        label: t5("common:on"),
        labelOff: t5("common:off"),
        isChecked: value[0] === "true",
        "data-testid": value[0] === "true" ? "enabled" : "disabled",
        onChange: (value2) => {
          onChange([value2.toString()]);
        }
      })
    })), /* @__PURE__ */ react.createElement(FormGroup, {
      label: t5("active"),
      fieldId: "kc-active",
      labelIcon: /* @__PURE__ */ react.createElement(HelpItem, {
        helpText: "realm-settings-help:active",
        forLabel: t5("active"),
        forID: t5("common:helpLabel", {label: t5("active")})
      })
    }, /* @__PURE__ */ react.createElement(Controller, {
      name: "config.active",
      control: form2.control,
      defaultValue: ["true"],
      render: ({onChange, value}) => {
        return /* @__PURE__ */ react.createElement(Switch, {
          id: "kc-active-switch",
          label: t5("common:on"),
          labelOff: t5("common:off"),
          isChecked: value[0] === "true",
          "data-testid": value[0] === "true" ? "active" : "passive",
          onChange: (value2) => {
            onChange([value2.toString()]);
          }
        });
      }
    })), /* @__PURE__ */ react.createElement(FormGroup, {
      label: t5("ellipticCurve"),
      fieldId: "kc-elliptic-curve",
      labelIcon: /* @__PURE__ */ react.createElement(HelpItem, {
        helpText: "realm-settings-help:ellipticCurve",
        forLabel: t5("ellipticCurve"),
        forID: t5("common:helpLabel", {label: t5("ellipticCurve")})
      })
    }, /* @__PURE__ */ react.createElement(Controller, {
      name: "config.ecdsaEllipticCurveKey",
      control: form2.control,
      defaultValue: ["P-256"],
      render: ({onChange, value}) => /* @__PURE__ */ react.createElement(Select, {
        toggleId: "kc-ecdsa-elliptic-curve",
        onToggle: (isExpanded) => setIsKeySizeDropdownOpen(isExpanded),
        onSelect: (_23, value2) => {
          onChange([value2.toString()]);
          setIsKeySizeDropdownOpen(false);
        },
        selections: [value.toString()],
        isOpen: isKeySizeDropdownOpen,
        variant: SelectVariant.single,
        "aria-label": t5("ellipticCurve"),
        "data-testid": "select-elliptic-curve-size"
      }, ecdsaEllipticCurveOptions?.map((item) => /* @__PURE__ */ react.createElement(SelectOption, {
        selected: item === value,
        key: item,
        value: item
      })))
    })), /* @__PURE__ */ react.createElement(ActionGroup, {
      className: "kc-ecdsa-form-buttons"
    }, /* @__PURE__ */ react.createElement(Button, {
      className: "kc-ecdsa-form-save-button",
      "data-testid": "add-provider-button",
      variant: "primary",
      type: "submit"
    }, t5("common:save")), /* @__PURE__ */ react.createElement(Button, {
      className: "kc-ecdsa-form-cancel-button",
      onClick: !editMode && handleModalToggle || void 0,
      variant: "link"
    }, t5("common:cancel"))));
  };
  function ECDSAGeneratedSettings() {
    const {t: t5} = useTranslation("realm-settings");
    const providerId = useRouteMatch("/:realm/realm-settings/keys/:id?/:providerType?/settings")?.params.providerType;
    return /* @__PURE__ */ react.createElement(react.Fragment, null, /* @__PURE__ */ react.createElement(ViewHeader, {
      titleKey: t5("editProvider"),
      subKey: providerId
    }), /* @__PURE__ */ react.createElement(PageSection, {
      variant: "light"
    }, /* @__PURE__ */ react.createElement(ECDSAGeneratedForm2, {
      providerType: providerId,
      editMode: true
    })));
  }
});

// build/realm-settings/key-providers/rsa-generated/RSAGeneratedForm.js
var require_RSAGeneratedForm = __commonJS((exports2) => {
  __markAsModule(exports2);
  __export(exports2, {
    RSAGeneratedForm: () => RSAGeneratedForm2,
    default: () => RSAGeneratedSettings
  });
  var RSAGeneratedForm2 = ({
    editMode,
    providerType,
    handleModalToggle,
    refresh
  }) => {
    const {t: t5} = useTranslation("realm-settings");
    const serverInfo2 = useServerInfo();
    const [isKeySizeDropdownOpen, setIsKeySizeDropdownOpen] = useState(false);
    const [isEllipticCurveDropdownOpen, setIsEllipticCurveDropdownOpen] = useState(false);
    const adminClient = useAdminClient();
    const {addAlert, addError} = useAlerts();
    const {id: id3} = useParams();
    const providerId = useRouteMatch("/:providerType?")?.params.providerType;
    const save = async (component) => {
      try {
        if (id3) {
          await adminClient.components.update({id: id3}, {
            ...component,
            parentId: component.parentId,
            providerId: providerType,
            providerType: KEY_PROVIDER_TYPE
          });
          addAlert(t5("saveProviderSuccess"), AlertVariant.success);
        } else {
          await adminClient.components.create({
            ...component,
            parentId: component.parentId,
            providerId: providerType,
            providerType: KEY_PROVIDER_TYPE,
            config: {priority: ["0"]}
          });
          handleModalToggle?.();
          addAlert(t5("saveProviderSuccess"), AlertVariant.success);
          refresh?.();
        }
      } catch (error2) {
        addError("realm-settings:saveProviderError", error2);
      }
    };
    const form2 = useForm({mode: "onChange"});
    const setupForm = (component) => {
      form2.reset();
      convertToFormValues(component, form2.setValue);
    };
    useFetch(async () => {
      if (editMode)
        return await adminClient.components.findOne({id: id3});
    }, (result) => {
      if (result) {
        setupForm(result);
      }
    }, []);
    const allComponentTypes = serverInfo2.componentTypes?.[KEY_PROVIDER_TYPE] ?? [];
    const rsaGeneratedKeySizeOptions = allComponentTypes[5].properties[4].options;
    const rsaGeneratedAlgorithmOptions = allComponentTypes[5].properties[3].options;
    return /* @__PURE__ */ react.createElement(FormAccess, {
      isHorizontal: true,
      id: "add-provider",
      className: "pf-u-mt-lg",
      role: "manage-realm",
      onSubmit: form2.handleSubmit(save)
    }, editMode && /* @__PURE__ */ react.createElement(FormGroup, {
      label: t5("providerId"),
      labelIcon: /* @__PURE__ */ react.createElement(HelpItem, {
        helpText: "client-scopes-help:mapperName",
        forLabel: t5("common:name"),
        forID: t5("common:helpLabel", {label: t5("common:name")})
      }),
      fieldId: "id",
      isRequired: true,
      validated: form2.errors.name ? ValidatedOptions.error : ValidatedOptions.default,
      helperTextInvalid: t5("common:required")
    }, /* @__PURE__ */ react.createElement(TextInput, {
      ref: form2.register(),
      id: "id",
      type: "text",
      name: "id",
      isReadOnly: editMode,
      "aria-label": t5("consoleDisplayName"),
      defaultValue: id3,
      "data-testid": "display-name-input"
    })), /* @__PURE__ */ react.createElement(FormGroup, {
      label: t5("common:name"),
      labelIcon: /* @__PURE__ */ react.createElement(HelpItem, {
        helpText: "client-scopes-help:mapperName",
        forLabel: t5("common:name"),
        forID: t5("common:helpLabel", {label: t5("common:name")})
      }),
      fieldId: "name",
      isRequired: true,
      validated: form2.errors.name ? ValidatedOptions.error : ValidatedOptions.default,
      helperTextInvalid: t5("common:required")
    }, !editMode && /* @__PURE__ */ react.createElement(Controller, {
      name: "name",
      control: form2.control,
      defaultValue: providerType,
      render: ({onChange, value}) => {
        return /* @__PURE__ */ react.createElement(TextInput, {
          id: "name",
          type: "text",
          "aria-label": t5("consoleDisplayName"),
          value,
          onChange: (value2) => onChange(value2),
          "data-testid": "display-name-input"
        });
      }
    }), editMode && /* @__PURE__ */ react.createElement(TextInput, {
      ref: form2.register(),
      type: "text",
      id: "name",
      name: "name",
      defaultValue: providerId,
      validated: form2.errors.name ? ValidatedOptions.error : ValidatedOptions.default
    })), /* @__PURE__ */ react.createElement(FormGroup, {
      label: t5("common:enabled"),
      fieldId: "kc-enabled",
      labelIcon: /* @__PURE__ */ react.createElement(HelpItem, {
        helpText: t5("realm-settings-help:enabled"),
        forLabel: t5("enabled"),
        forID: t5("common:helpLabel", {label: t5("enabled")})
      })
    }, /* @__PURE__ */ react.createElement(Controller, {
      name: "config.enabled",
      control: form2.control,
      defaultValue: ["true"],
      render: ({onChange, value}) => /* @__PURE__ */ react.createElement(Switch, {
        id: "kc-enabled-switch",
        label: t5("common:on"),
        labelOff: t5("common:off"),
        isChecked: value[0] === "true",
        "data-testid": value[0] === "true" ? "enabled" : "disabled",
        onChange: (value2) => {
          onChange([value2.toString()]);
        }
      })
    })), /* @__PURE__ */ react.createElement(FormGroup, {
      label: t5("active"),
      fieldId: "kc-active",
      labelIcon: /* @__PURE__ */ react.createElement(HelpItem, {
        helpText: "realm-settings-help:active",
        forLabel: t5("active"),
        forID: t5("common:helpLabel", {label: t5("active")})
      })
    }, /* @__PURE__ */ react.createElement(Controller, {
      name: "config.active",
      control: form2.control,
      defaultValue: ["true"],
      render: ({onChange, value}) => {
        return /* @__PURE__ */ react.createElement(Switch, {
          id: "kc-active-switch",
          label: t5("common:on"),
          labelOff: t5("common:off"),
          isChecked: value[0] === "true",
          "data-testid": value[0] === "true" ? "active" : "passive",
          onChange: (value2) => {
            onChange([value2.toString()]);
          }
        });
      }
    })), /* @__PURE__ */ react.createElement(FormGroup, {
      label: t5("secretSize"),
      fieldId: "kc-rsa-generated-keysize",
      labelIcon: /* @__PURE__ */ react.createElement(HelpItem, {
        helpText: "realm-settings-help:secretSize",
        forLabel: t5("secretSize"),
        forID: t5("common:helpLabel", {label: t5("secretSize")})
      })
    }, /* @__PURE__ */ react.createElement(Controller, {
      name: "config.secretSize",
      control: form2.control,
      defaultValue: ["2048"],
      render: ({onChange, value}) => /* @__PURE__ */ react.createElement(Select, {
        toggleId: "kc-rsa-generated-keysize",
        onToggle: (isExpanded) => setIsKeySizeDropdownOpen(isExpanded),
        onSelect: (_23, value2) => {
          onChange([value2.toString()]);
          setIsKeySizeDropdownOpen(false);
        },
        selections: [value.toString()],
        isOpen: isKeySizeDropdownOpen,
        variant: SelectVariant.single,
        "aria-label": t5("KeySize"),
        "data-testid": "select-secret-size"
      }, rsaGeneratedKeySizeOptions.map((item) => /* @__PURE__ */ react.createElement(SelectOption, {
        selected: item === value,
        key: item,
        value: item
      })))
    })), /* @__PURE__ */ react.createElement(FormGroup, {
      label: t5("algorithm"),
      fieldId: "kc-algorithm",
      labelIcon: /* @__PURE__ */ react.createElement(HelpItem, {
        helpText: "realm-settings-help:algorithm",
        forLabel: t5("algorithm"),
        forID: t5("common:helpLabel", {label: t5("algorithm")})
      })
    }, /* @__PURE__ */ react.createElement(Controller, {
      name: "config.algorithm",
      control: form2.control,
      defaultValue: ["RS256"],
      render: ({onChange, value}) => /* @__PURE__ */ react.createElement(Select, {
        toggleId: "kc-elliptic",
        onToggle: (isExpanded) => setIsEllipticCurveDropdownOpen(isExpanded),
        onSelect: (_23, value2) => {
          onChange([value2.toString()]);
          setIsEllipticCurveDropdownOpen(false);
        },
        selections: [value.toString()],
        variant: SelectVariant.single,
        "aria-label": t5("emailTheme"),
        isOpen: isEllipticCurveDropdownOpen,
        placeholderText: "Select one...",
        "data-testid": "select-email-theme"
      }, rsaGeneratedAlgorithmOptions.map((p2, idx) => /* @__PURE__ */ react.createElement(SelectOption, {
        selected: p2 === value,
        key: `email-theme-${idx}`,
        value: p2
      })))
    })), /* @__PURE__ */ react.createElement(ActionGroup, {
      className: "kc-rsa-generated-form-buttons"
    }, /* @__PURE__ */ react.createElement(Button, {
      className: "kc-rsa-generated-form-save-button",
      "data-testid": "add-provider-button",
      variant: "primary",
      type: "submit"
    }, t5("common:save")), /* @__PURE__ */ react.createElement(Button, {
      className: "kc-rsa-generated-form-cancel-button",
      onClick: !editMode && handleModalToggle || void 0,
      variant: "link"
    }, t5("common:cancel"))));
  };
  function RSAGeneratedSettings() {
    const {t: t5} = useTranslation("realm-settings");
    const providerId = useRouteMatch("/:realm/realm-settings/keys/:id?/:providerType?/settings")?.params.providerType;
    return /* @__PURE__ */ react.createElement(react.Fragment, null, /* @__PURE__ */ react.createElement(ViewHeader, {
      titleKey: t5("editProvider"),
      subKey: providerId
    }), /* @__PURE__ */ react.createElement(PageSection, {
      variant: "light"
    }, /* @__PURE__ */ react.createElement(RSAGeneratedForm2, {
      providerType: providerId,
      editMode: true
    })));
  }
});

// build/realm-settings/ExecutorForm.js
var require_ExecutorForm = __commonJS((exports2) => {
  __markAsModule(exports2);
  __export(exports2, {
    default: () => ExecutorForm
  });
  var defaultValues2 = {
    config: {},
    executor: ""
  };
  function ExecutorForm() {
    const {t: t5} = useTranslation("realm-settings");
    const history = useHistory();
    const {realm: realm2, profileName} = useParams();
    const {executorName} = useParams();
    const {addAlert, addError} = useAlerts();
    const [selectExecutorTypeOpen, setSelectExecutorTypeOpen] = useState(false);
    const serverInfo2 = useServerInfo();
    const adminClient = useAdminClient();
    const executorTypes = serverInfo2.componentTypes?.["org.keycloak.services.clientpolicy.executor.ClientPolicyExecutorProvider"];
    const [executors, setExecutors] = useState([]);
    const [executorProperties, setExecutorProperties] = useState([]);
    const [globalProfiles, setGlobalProfiles] = useState([]);
    const [profiles, setProfiles] = useState([]);
    const form2 = useForm({defaultValues: defaultValues2});
    const {control, setValue, handleSubmit} = form2;
    const editMode = !!executorName;
    useFetch(() => adminClient.clientPolicies.listProfiles({includeGlobalProfiles: true}), (profiles2) => {
      setGlobalProfiles(profiles2.globalProfiles ?? []);
      setProfiles(profiles2.profiles ?? []);
      const profile = profiles2.profiles.find((profile2) => profile2.name === profileName);
      const profileExecutor = profile?.executors.find((executor) => executor.executor === executorName);
      if (profileExecutor) {
        convertToFormValues(profileExecutor, setValue);
      }
    }, []);
    const save = async () => {
      const formValues = form2.getValues();
      const updatedProfiles = profiles.map((profile) => {
        if (profile.name !== profileName) {
          return profile;
        }
        const profileExecutor = profile.executors.find((executor) => executor.executor === executorName);
        const executors2 = (profile.executors ?? []).concat({
          executor: formValues.executor,
          configuration: formValues.config
        });
        if (editMode) {
          profileExecutor.configuration = {
            ...profileExecutor.configuration,
            ...formValues.config
          };
        }
        if (editMode) {
          return profile;
        }
        return {
          ...profile,
          executors: executors2
        };
      });
      try {
        await adminClient.clientPolicies.createProfiles({
          profiles: updatedProfiles,
          globalProfiles
        });
        addAlert(editMode ? t5("realm-settings:updateExecutorSuccess") : t5("realm-settings:addExecutorSuccess"), AlertVariant.success);
        history.push(toClientProfile({realm: realm2, profileName}));
      } catch (error2) {
        addError(editMode ? "realm-settings:updateExecutorError" : "realm-settings:addExecutorError", error2);
      }
    };
    const globalProfile = globalProfiles.find((globalProfile2) => globalProfile2.name === profileName);
    const profileExecutorType = executorTypes?.find((executor) => executor.id === executorName);
    const editedProfileExecutors = profileExecutorType?.properties.map((property2) => {
      const globalDefaultValues = editMode ? property2.defaultValue : "";
      return {
        ...property2,
        defaultValue: globalDefaultValues
      };
    });
    return /* @__PURE__ */ react.createElement(react.Fragment, null, /* @__PURE__ */ react.createElement(ViewHeader, {
      titleKey: editMode ? executorName : t5("addExecutor"),
      divider: true
    }), /* @__PURE__ */ react.createElement(PageSection, {
      variant: "light"
    }, /* @__PURE__ */ react.createElement(FormAccess, {
      isHorizontal: true,
      role: "manage-realm",
      className: "pf-u-mt-lg"
    }, /* @__PURE__ */ react.createElement(FormGroup, {
      label: t5("executorType"),
      fieldId: "kc-executorType",
      labelIcon: executors.length > 0 && executors[0].helpText !== "" ? /* @__PURE__ */ react.createElement(HelpItem, {
        helpText: executors[0].helpText,
        forLabel: t5("executorTypeHelpText"),
        forID: t5(`common:helpLabel`, {
          label: t5("executorTypeHelpText")
        })
      }) : editMode ? /* @__PURE__ */ react.createElement(HelpItem, {
        helpText: profileExecutorType?.helpText,
        forLabel: t5("executorTypeHelpText"),
        forID: t5(`common:helpLabel`, {
          label: t5("executorTypeHelpText")
        })
      }) : void 0
    }, /* @__PURE__ */ react.createElement(Controller, {
      name: "executor",
      defaultValue: "",
      control,
      render: ({onChange, value}) => /* @__PURE__ */ react.createElement(Select, {
        toggleId: "kc-executor",
        placeholderText: "Select an executor",
        onToggle: (isOpen) => setSelectExecutorTypeOpen(isOpen),
        onSelect: (_23, value2) => {
          onChange(value2.toString());
          const selectedExecutor = executorTypes?.filter((type) => type.id === value2);
          setExecutors(selectedExecutor ?? []);
          setExecutorProperties(selectedExecutor?.[0].properties ?? []);
          setSelectExecutorTypeOpen(false);
        },
        selections: editMode ? executorName : value,
        variant: SelectVariant.single,
        "data-testid": "executorType-select",
        "aria-label": t5("executorType"),
        isOpen: selectExecutorTypeOpen,
        maxHeight: 580,
        isDisabled: editMode
      }, executorTypes?.map((option) => /* @__PURE__ */ react.createElement(SelectOption, {
        selected: option.id === value,
        key: option.id,
        value: option.id,
        description: option.helpText
      })))
    })), /* @__PURE__ */ react.createElement(FormProvider, {
      ...form2
    }, /* @__PURE__ */ react.createElement(DynamicComponents, {
      properties: executorProperties
    }), editMode && /* @__PURE__ */ react.createElement(DynamicComponents, {
      properties: editedProfileExecutors
    })), !globalProfile && /* @__PURE__ */ react.createElement(ActionGroup, null, /* @__PURE__ */ react.createElement(Button, {
      variant: "primary",
      onClick: () => handleSubmit(save)(),
      "data-testid": "addExecutor-saveBtn"
    }, editMode ? t5("common:save") : t5("common:add")), /* @__PURE__ */ react.createElement(Button, {
      variant: "link",
      component: (props) => /* @__PURE__ */ react.createElement(Link, {
        ...props,
        to: toClientProfile({realm: realm2, profileName})
      }),
      "data-testid": "addExecutor-cancelBtn"
    }, t5("common:cancel")))), editMode && globalProfile && /* @__PURE__ */ react.createElement("div", {
      className: "kc-backToProfile"
    }, /* @__PURE__ */ react.createElement(Button, {
      component: (props) => /* @__PURE__ */ react.createElement(Link, {
        ...props,
        to: toClientProfile({realm: realm2, profileName})
      }),
      variant: "primary"
    }, t5("realm-settings:back")))));
  }
});

// build/realm-settings/ClientProfileForm.js
var require_ClientProfileForm = __commonJS((exports2) => {
  __markAsModule(exports2);
  __export(exports2, {
    default: () => ClientProfileForm
  });
  var defaultValues2 = {
    name: "",
    description: "",
    executors: []
  };
  function ClientProfileForm() {
    const {t: t5} = useTranslation("realm-settings");
    const history = useHistory();
    const {
      handleSubmit,
      setValue,
      register: register2,
      errors,
      formState: {isDirty}
    } = useForm({
      defaultValues: defaultValues2,
      mode: "onChange"
    });
    const {addAlert, addError} = useAlerts();
    const adminClient = useAdminClient();
    const [globalProfiles, setGlobalProfiles] = useState([]);
    const [profiles, setProfiles] = useState([]);
    const {realm: realm2, profileName} = useParams();
    const serverInfo2 = useServerInfo();
    const executorTypes = useMemo(() => serverInfo2.componentTypes?.["org.keycloak.services.clientpolicy.executor.ClientPolicyExecutorProvider"], []);
    const [executorToDelete, setExecutorToDelete] = useState();
    const editMode = profileName ? true : false;
    const [key, setKey] = useState(0);
    const reload = () => setKey(new Date().getTime());
    useFetch(() => adminClient.clientPolicies.listProfiles({includeGlobalProfiles: true}), (profiles2) => {
      setGlobalProfiles(profiles2.globalProfiles ?? []);
      setProfiles(profiles2.profiles ?? []);
    }, [key]);
    const save = async (form2) => {
      const updatedProfiles = editMode ? patchProfiles(form2) : addProfile(form2);
      try {
        await adminClient.clientPolicies.createProfiles({
          profiles: updatedProfiles,
          globalProfiles
        });
        addAlert(editMode ? t5("realm-settings:updateClientProfileSuccess") : t5("realm-settings:createClientProfileSuccess"), AlertVariant.success);
        history.push(toClientProfile({realm: realm2, profileName: form2.name}));
      } catch (error2) {
        addError(editMode ? "realm-settings:updateClientProfileError" : "realm-settings:createClientProfileError", error2);
      }
    };
    const patchProfiles = (data2) => profiles.map((profile2) => {
      if (profile2.name !== profileName) {
        return profile2;
      }
      return {
        ...profile2,
        name: data2.name,
        description: data2.description
      };
    });
    const addProfile = (data2) => profiles.concat({
      ...data2,
      executors: []
    });
    const [toggleDeleteDialog, DeleteConfirm] = useConfirmDialog({
      titleKey: executorToDelete?.name ? t5("deleteExecutorProfileConfirmTitle") : t5("deleteClientProfileConfirmTitle"),
      messageKey: executorToDelete?.name ? t5("deleteExecutorProfileConfirm", {
        executorName: executorToDelete.name
      }) : t5("deleteClientProfileConfirm", {
        profileName
      }),
      continueButtonLabel: t5("delete"),
      continueButtonVariant: ButtonVariant.danger,
      onConfirm: async () => {
        if (executorToDelete?.name) {
          profileExecutors.splice(executorToDelete.idx, 1);
          try {
            await adminClient.clientPolicies.createProfiles({
              profiles,
              globalProfiles
            });
            addAlert(t5("deleteExecutorSuccess"), AlertVariant.success);
            history.push(toClientProfile({realm: realm2, profileName}));
          } catch (error2) {
            addError(t5("deleteExecutorError"), error2);
          }
        } else {
          const updatedProfiles = profiles.filter((profile2) => profile2.name !== profileName);
          try {
            await adminClient.clientPolicies.createProfiles({
              profiles: updatedProfiles,
              globalProfiles
            });
            addAlert(t5("deleteClientSuccess"), AlertVariant.success);
            history.push(toClientPolicies({realm: realm2}));
          } catch (error2) {
            addError(t5("deleteClientError"), error2);
          }
        }
      }
    });
    const profile = profiles.find((profile2) => profile2.name === profileName);
    const profileExecutors = profile?.executors || [];
    const globalProfile = globalProfiles.find((globalProfile2) => globalProfile2.name === profileName);
    const globalProfileExecutors = globalProfile?.executors || [];
    useEffect(() => {
      setValue("name", globalProfile?.name ?? profile?.name);
      setValue("description", globalProfile?.description ?? profile?.description);
    }, [profiles]);
    return /* @__PURE__ */ react.createElement(react.Fragment, null, /* @__PURE__ */ react.createElement(DeleteConfirm, null), /* @__PURE__ */ react.createElement(ViewHeader, {
      titleKey: editMode ? profileName : t5("newClientProfile"),
      badges: [
        {
          id: "global-client-profile-badge",
          text: globalProfile ? t5("global") : ""
        }
      ],
      divider: true,
      dropdownItems: !globalProfile ? [
        /* @__PURE__ */ react.createElement(DropdownItem, {
          key: "delete",
          value: "delete",
          onClick: toggleDeleteDialog,
          "data-testid": "deleteClientProfileDropdown"
        }, t5("deleteClientProfile"))
      ] : void 0
    }), /* @__PURE__ */ react.createElement(PageSection, {
      variant: "light"
    }, /* @__PURE__ */ react.createElement(FormAccess, {
      isHorizontal: true,
      role: "view-realm",
      className: "pf-u-mt-lg"
    }, /* @__PURE__ */ react.createElement(FormGroup, {
      label: t5("newClientProfileName"),
      fieldId: "kc-name",
      helperText: t5("createClientProfileNameHelperText"),
      isRequired: true,
      helperTextInvalid: t5("common:required"),
      validated: errors.name ? ValidatedOptions.error : ValidatedOptions.default
    }, /* @__PURE__ */ react.createElement(TextInput, {
      ref: register2({required: true}),
      name: "name",
      type: "text",
      id: "name",
      "aria-label": t5("name"),
      "data-testid": "client-profile-name",
      isReadOnly: !!globalProfile
    })), /* @__PURE__ */ react.createElement(FormGroup, {
      label: t5("common:description"),
      fieldId: "kc-description"
    }, /* @__PURE__ */ react.createElement(TextArea, {
      ref: register2(),
      name: "description",
      type: "text",
      id: "description",
      "aria-label": t5("description"),
      "data-testid": "client-profile-description",
      isReadOnly: !!globalProfile
    })), /* @__PURE__ */ react.createElement(ActionGroup, null, !globalProfile && /* @__PURE__ */ react.createElement(Button, {
      variant: "primary",
      onClick: () => handleSubmit(save)(),
      "data-testid": "saveCreateProfile",
      isDisabled: !isDirty
    }, t5("common:save")), editMode && !globalProfile && /* @__PURE__ */ react.createElement(Button, {
      id: "reloadProfile",
      variant: "link",
      "data-testid": "reloadProfile",
      isDisabled: !isDirty,
      onClick: reload
    }, t5("realm-settings:reload")), !editMode && !globalProfile && /* @__PURE__ */ react.createElement(Button, {
      id: "cancelCreateProfile",
      component: (props) => /* @__PURE__ */ react.createElement(Link, {
        ...props,
        to: `/${realm2}/realm-settings/clientPolicies`
      }),
      "data-testid": "cancelCreateProfile"
    }, t5("common:cancel"))), editMode && /* @__PURE__ */ react.createElement(react.Fragment, null, /* @__PURE__ */ react.createElement(Flex, null, /* @__PURE__ */ react.createElement(FlexItem, null, /* @__PURE__ */ react.createElement(Text, {
      className: "kc-executors",
      component: TextVariants.h1
    }, t5("executors"), /* @__PURE__ */ react.createElement(HelpItem, {
      helpText: t5("realm-settings:executorsHelpText"),
      forLabel: t5("executorsHelpItem"),
      forID: t5("executors")
    }))), profile && /* @__PURE__ */ react.createElement(FlexItem, {
      align: {default: "alignRight"}
    }, /* @__PURE__ */ react.createElement(Button, {
      id: "addExecutor",
      component: (props) => /* @__PURE__ */ react.createElement(Link, {
        ...props,
        to: toAddExecutor({
          realm: realm2,
          profileName
        })
      }),
      variant: "link",
      className: "kc-addExecutor",
      "data-testid": "addExecutor",
      icon: /* @__PURE__ */ react.createElement(PlusCircleIcon, null)
    }, t5("realm-settings:addExecutor")))), profileExecutors.length > 0 && /* @__PURE__ */ react.createElement(DataList, {
      "aria-label": t5("executors"),
      isCompact: true
    }, profileExecutors.map((executor, idx) => /* @__PURE__ */ react.createElement(DataListItem, {
      "aria-labelledby": "executors-list-item",
      key: executor.executor,
      id: executor.executor
    }, /* @__PURE__ */ react.createElement(DataListItemRow, {
      "data-testid": "executors-list-row"
    }, /* @__PURE__ */ react.createElement(DataListItemCells, {
      dataListCells: [
        /* @__PURE__ */ react.createElement(DataListCell, {
          key: "executor",
          "data-testid": "executor-type"
        }, executor.configuration ? /* @__PURE__ */ react.createElement(Button, {
          component: (props) => /* @__PURE__ */ react.createElement(Link, {
            ...props,
            to: toExecutor({
              realm: realm2,
              profileName,
              executorName: executor.executor
            })
          }),
          variant: "link",
          "data-testid": "editExecutor"
        }, executor.executor) : /* @__PURE__ */ react.createElement("span", {
          className: "kc-unclickable-executor"
        }, executor.executor), executorTypes?.filter((type) => type.id === executor.executor).map((type) => /* @__PURE__ */ react.createElement(react.Fragment, null, /* @__PURE__ */ react.createElement(HelpItem, {
          key: type.id,
          helpText: type.helpText,
          forLabel: t5("executorTypeTextHelpText"),
          forID: t5(`common:helpLabel`, {
            label: t5("executorTypeTextHelpText")
          })
        }), /* @__PURE__ */ react.createElement(Button, {
          variant: "link",
          isInline: true,
          icon: /* @__PURE__ */ react.createElement(TrashIcon, {
            key: `executorType-trash-icon-${type.id}`,
            className: "kc-executor-trash-icon",
            "data-testid": "deleteExecutor"
          }),
          onClick: () => {
            toggleDeleteDialog();
            setExecutorToDelete({
              idx,
              name: type.id
            });
          }
        }))))
      ]
    }))))), globalProfileExecutors.length > 0 && /* @__PURE__ */ react.createElement(react.Fragment, null, /* @__PURE__ */ react.createElement(DataList, {
      "aria-label": t5("executors"),
      isCompact: true
    }, globalProfileExecutors.map((executor) => /* @__PURE__ */ react.createElement(DataListItem, {
      "aria-labelledby": "global-executors-list-item",
      key: executor.executor,
      id: executor.executor
    }, /* @__PURE__ */ react.createElement(DataListItemRow, {
      "data-testid": "global-executors-list-row"
    }, /* @__PURE__ */ react.createElement(DataListItemCells, {
      dataListCells: [
        /* @__PURE__ */ react.createElement(DataListCell, {
          key: "executor",
          "data-testid": "global-executor-type"
        }, Object.keys(executor.configuration).length !== 0 ? /* @__PURE__ */ react.createElement(Button, {
          component: (props) => /* @__PURE__ */ react.createElement(Link, {
            ...props,
            to: toExecutor({
              realm: realm2,
              profileName,
              executorName: executor.executor
            })
          }),
          variant: "link",
          "data-testid": "editExecutor"
        }, executor.executor) : /* @__PURE__ */ react.createElement("span", {
          className: "kc-unclickable-executor"
        }, executor.executor), executorTypes?.filter((type) => type.id === executor.executor).map((type) => /* @__PURE__ */ react.createElement(HelpItem, {
          key: type.id,
          helpText: type.helpText,
          forLabel: t5("executorTypeTextHelpText"),
          forID: t5(`common:helpLabel`, {
            label: t5("executorTypeTextHelpText")
          })
        })))
      ]
    }))))), /* @__PURE__ */ react.createElement(Button, {
      id: "backToClientPolicies",
      component: (props) => /* @__PURE__ */ react.createElement(Link, {
        ...props,
        to: `/${realm2}/realm-settings/clientPolicies`
      }),
      variant: "primary",
      className: "kc-backToPolicies",
      "data-testid": "backToClientPolicies"
    }, t5("realm-settings:back"))), profileExecutors.length === 0 && globalProfileExecutors.length === 0 && /* @__PURE__ */ react.createElement(react.Fragment, null, /* @__PURE__ */ react.createElement(Divider, null), /* @__PURE__ */ react.createElement(Text, {
      className: "kc-emptyExecutors",
      component: TextVariants.h6
    }, t5("realm-settings:emptyExecutors")))))));
  }
});

// build/realm-settings/ProfilesTab.js
var require_ProfilesTab = __commonJS((exports2) => {
  __markAsModule(exports2);
  __export(exports2, {
    default: () => ProfilesTab2
  });
  function ProfilesTab2() {
    const {t: t5} = useTranslation("realm-settings");
    const adminClient = useAdminClient();
    const {realm: realm2} = useRealm();
    const {addAlert, addError} = useAlerts();
    const [tableProfiles, setTableProfiles] = useState();
    const [globalProfiles, setGlobalProfiles] = useState();
    const [selectedProfile, setSelectedProfile] = useState();
    const [show2, setShow] = useState(false);
    const [code2, setCode] = useState();
    const [key, setKey] = useState(0);
    useFetch(() => adminClient.clientPolicies.listProfiles({
      includeGlobalProfiles: true
    }), (allProfiles) => {
      setGlobalProfiles(allProfiles.globalProfiles);
      const globalProfiles2 = allProfiles.globalProfiles?.map((globalProfiles3) => ({
        ...globalProfiles3,
        global: true
      }));
      const profiles = allProfiles.profiles?.map((profiles2) => ({
        ...profiles2,
        global: false
      }));
      const allClientProfiles = globalProfiles2?.concat(profiles ?? []);
      setTableProfiles(allClientProfiles || []);
      setCode(JSON.stringify(allClientProfiles, null, 2));
    }, [key]);
    const loader = async () => tableProfiles ?? [];
    const normalizeProfile = (profile) => omit(profile, "global");
    const [toggleDeleteDialog, DeleteConfirm] = useConfirmDialog({
      titleKey: t5("deleteClientProfileConfirmTitle"),
      messageKey: t5("deleteClientProfileConfirm", {
        profileName: selectedProfile?.name
      }),
      continueButtonLabel: t5("delete"),
      continueButtonVariant: ButtonVariant.danger,
      onConfirm: async () => {
        const updatedProfiles = tableProfiles?.filter((profile) => profile.name !== selectedProfile?.name && !profile.global).map((profile) => normalizeProfile(profile));
        try {
          await adminClient.clientPolicies.createProfiles({
            profiles: updatedProfiles,
            globalProfiles
          });
          addAlert(t5("deleteClientSuccess"), AlertVariant.success);
          setKey(key + 1);
        } catch (error2) {
          addError(t5("deleteClientError"), error2);
        }
      }
    });
    const cellFormatter = (row) => /* @__PURE__ */ react.createElement(Link, {
      to: toClientProfile({
        realm: realm2,
        profileName: row.name
      }),
      key: row.name
    }, row.name, " ", row.global && /* @__PURE__ */ react.createElement(Label, {
      color: "blue"
    }, t5("global")));
    if (!tableProfiles) {
      return /* @__PURE__ */ react.createElement(KeycloakSpinner, null);
    }
    const save = async () => {
      if (!code2) {
        return;
      }
      try {
        const obj = JSON.parse(code2);
        const changedProfiles = obj.filter((profile) => !profile.global).map((profile) => normalizeProfile(profile));
        const changedGlobalProfiles = obj.filter((profile) => profile.global).map((profile) => normalizeProfile(profile));
        try {
          await adminClient.clientPolicies.createProfiles({
            profiles: changedProfiles,
            globalProfiles: changedGlobalProfiles
          });
          addAlert(t5("realm-settings:updateClientProfilesSuccess"), AlertVariant.success);
          setKey(key + 1);
        } catch (error2) {
          addError("realm-settings:updateClientProfilesError", error2);
        }
      } catch (error2) {
        console.warn("Invalid json, ignoring value using {}");
      }
    };
    return /* @__PURE__ */ react.createElement(react.Fragment, null, /* @__PURE__ */ react.createElement(DeleteConfirm, null), /* @__PURE__ */ react.createElement(PageSection, null, /* @__PURE__ */ react.createElement(Flex, {
      className: "kc-profiles-config-section"
    }, /* @__PURE__ */ react.createElement(FlexItem, null, /* @__PURE__ */ react.createElement(Title, {
      headingLevel: "h1",
      size: "md"
    }, t5("profilesConfigType"))), /* @__PURE__ */ react.createElement(FlexItem, null, /* @__PURE__ */ react.createElement(Radio, {
      isChecked: !show2,
      name: "profilesView",
      onChange: () => setShow(false),
      label: t5("profilesConfigTypes.formView"),
      id: "formView-profilesView",
      className: "kc-form-radio-btn pf-u-mr-sm pf-u-ml-sm",
      "data-testid": "formView-profilesView"
    })), /* @__PURE__ */ react.createElement(FlexItem, null, /* @__PURE__ */ react.createElement(Radio, {
      isChecked: show2,
      name: "profilesView",
      onChange: () => setShow(true),
      label: t5("profilesConfigTypes.jsonEditor"),
      id: "jsonEditor-profilesView",
      className: "kc-editor-radio-btn",
      "data-testid": "jsonEditor-profilesView"
    })))), /* @__PURE__ */ react.createElement(Divider, null), !show2 ? /* @__PURE__ */ react.createElement(KeycloakDataTable, {
      key: tableProfiles.length,
      ariaLabelKey: "realm-settings:profiles",
      searchPlaceholderKey: "realm-settings:clientProfileSearch",
      loader,
      toolbarItem: /* @__PURE__ */ react.createElement(ToolbarItem, null, /* @__PURE__ */ react.createElement(Button, {
        id: "createProfile",
        component: (props) => /* @__PURE__ */ react.createElement(Link, {
          ...props,
          to: toAddClientProfile({realm: realm2})
        }),
        "data-testid": "createProfile"
      }, t5("createClientProfile"))),
      isRowDisabled: (value) => value.global,
      actions: [
        {
          title: t5("common:delete"),
          onRowClick: (profile) => {
            setSelectedProfile(profile);
            toggleDeleteDialog();
          }
        }
      ],
      columns: [
        {
          name: "name",
          displayKey: t5("common:name"),
          cellRenderer: cellFormatter
        },
        {
          name: "description",
          displayKey: t5("clientProfileDescription")
        }
      ],
      emptyState: /* @__PURE__ */ react.createElement(ListEmptyState, {
        message: t5("emptyClientProfiles"),
        instructions: t5("emptyClientProfilesInstructions")
      })
    }) : /* @__PURE__ */ react.createElement(FormGroup, {
      fieldId: "jsonEditor"
    }, /* @__PURE__ */ react.createElement("div", {
      className: "pf-u-mt-md pf-u-ml-lg"
    }, /* @__PURE__ */ react.createElement(CodeEditor, {
      isLineNumbersVisible: true,
      isLanguageLabelVisible: true,
      isReadOnly: false,
      code: code2,
      language: Language.json,
      height: "30rem",
      onChange: (value) => {
        setCode(value ?? "");
      }
    })), /* @__PURE__ */ react.createElement(ActionGroup, null, /* @__PURE__ */ react.createElement("div", {
      className: "pf-u-mt-md"
    }, /* @__PURE__ */ react.createElement(Button, {
      variant: ButtonVariant.primary,
      className: "pf-u-mr-md pf-u-ml-lg",
      onClick: save,
      "data-testid": "jsonEditor-saveBtn"
    }, t5("save")), /* @__PURE__ */ react.createElement(Button, {
      variant: ButtonVariant.link,
      onClick: () => {
        setCode(prettyPrintJSON(tableProfiles));
      },
      "data-testid": "jsonEditor-reloadBtn"
    }, t5("reload"))))));
  }
});

// build/realm-settings/NewClientPolicyCondition.js
var require_NewClientPolicyCondition = __commonJS((exports2) => {
  __markAsModule(exports2);
  __export(exports2, {
    default: () => NewClientPolicyCondition2
  });
  function NewClientPolicyCondition2() {
    const {t: t5} = useTranslation("realm-settings");
    const {addAlert, addError} = useAlerts();
    const history = useHistory();
    const {realm: realm2} = useRealm();
    const [openConditionType, setOpenConditionType] = useState(false);
    const [policies, setPolicies] = useState([]);
    const [condition, setCondition] = useState([]);
    const [conditionData, setConditionData] = useState();
    const [conditionType, setConditionType] = useState("");
    const [conditionProperties, setConditionProperties] = useState([]);
    const {policyName} = useParams();
    const {conditionName} = useParams();
    const serverInfo2 = useServerInfo();
    const form2 = useForm({
      shouldUnregister: false
    });
    const conditionTypes = serverInfo2.componentTypes?.["org.keycloak.services.clientpolicy.condition.ClientPolicyConditionProvider"];
    const adminClient = useAdminClient();
    const setupForm = (condition2, properties) => {
      form2.reset();
      Object.entries(condition2.configuration).map(([key, value]) => {
        const formKey = `config.${key}`;
        const property2 = properties.find((p2) => p2.name === key);
        if (property2?.type === "MultivaluedString" && property2.name !== "scopes" && property2.name !== "groups") {
          form2.setValue(formKey, convertToMultiline(value));
        } else if (property2?.name === "client-scopes") {
          form2.setValue("config.scopes", value);
        } else {
          form2.setValue(formKey, value);
        }
      });
    };
    useFetch(() => adminClient.clientPolicies.listPolicies(), (policies2) => {
      setPolicies(policies2.policies ?? []);
      if (conditionName) {
        const currentPolicy = policies2.policies?.find((item) => item.name === policyName);
        const typeAndConfigData = currentPolicy?.conditions?.find((item) => item.condition === conditionName);
        const currentCondition = conditionTypes?.find((condition2) => condition2.id === conditionName);
        setConditionData(typeAndConfigData);
        setConditionProperties(currentCondition?.properties);
        setupForm(typeAndConfigData, currentCondition?.properties);
      }
    }, []);
    const save = async (configPolicy) => {
      const configValues = configPolicy.config;
      const writeConfig = () => {
        return conditionProperties.reduce((r3, p2) => {
          p2.type === "MultivaluedString" && p2.name !== "scopes" && p2.name !== "groups" ? r3[p2.name] = toValue(configValues[p2.name]) : r3[p2.name] = configValues[p2.name];
          return r3;
        }, {});
      };
      const updatedPolicies = policies.map((policy) => {
        if (policy.name !== policyName) {
          return policy;
        }
        let conditions = policy.conditions ?? [];
        if (conditionName) {
          const createdCondition = {
            condition: conditionData?.condition,
            configuration: writeConfig()
          };
          const index3 = conditions.findIndex((condition2) => conditionName === condition2.condition);
          if (index3 === -1) {
            return;
          }
          const newConditions = [
            ...conditions.slice(0, index3),
            createdCondition,
            ...conditions.slice(index3 + 1)
          ];
          return {
            ...policy,
            conditions: newConditions
          };
        }
        conditions = conditions.concat({
          condition: condition[0].condition,
          configuration: writeConfig()
        });
        return {
          ...policy,
          conditions
        };
      });
      try {
        await adminClient.clientPolicies.updatePolicy({
          policies: updatedPolicies
        });
        setPolicies(updatedPolicies);
        history.push(`/${realm2}/realm-settings/clientPolicies/${policyName}/edit-policy`);
        addAlert(conditionName ? t5("realm-settings:updateClientConditionSuccess") : t5("realm-settings:createClientConditionSuccess"), AlertVariant.success);
      } catch (error2) {
        addError("realm-settings:createClientConditionError", error2);
      }
    };
    return /* @__PURE__ */ react.createElement(PageSection, {
      variant: "light"
    }, /* @__PURE__ */ react.createElement(FormPanel, {
      className: "kc-login-screen",
      title: conditionName ? t5("editCondition") : t5("addCondition")
    }, /* @__PURE__ */ react.createElement(FormAccess, {
      isHorizontal: true,
      role: "manage-realm",
      className: "pf-u-mt-lg",
      onSubmit: form2.handleSubmit(save)
    }, /* @__PURE__ */ react.createElement(FormGroup, {
      label: t5("conditionType"),
      fieldId: "conditionType",
      labelIcon: /* @__PURE__ */ react.createElement(HelpItem, {
        helpText: conditionType ? t5(`realm-settings-help:${camelCase2(conditionType.replace(/-/g, " "))}`) : t5("anyClient"),
        forLabel: t5("conditionType"),
        forID: "conditionType"
      })
    }, /* @__PURE__ */ react.createElement(Controller, {
      name: "conditions",
      defaultValue: "any-client",
      control: form2.control,
      render: ({onChange, value}) => /* @__PURE__ */ react.createElement(Select, {
        placeholderText: t5("selectACondition"),
        className: "kc-conditionType-select",
        "data-testid": "conditionType-select",
        toggleId: "provider",
        isDisabled: !!conditionName,
        onToggle: (toggle) => setOpenConditionType(toggle),
        onSelect: (_23, value2) => {
          onChange(value2);
          setConditionProperties(value2.properties);
          setConditionType(value2.id);
          setCondition([
            {
              condition: value2.id
            }
          ]);
          setOpenConditionType(false);
        },
        selections: conditionName ? conditionName : conditionType,
        variant: SelectVariant.single,
        "aria-label": t5("conditionType"),
        isOpen: openConditionType
      }, conditionTypes?.map((condition2) => /* @__PURE__ */ react.createElement(SelectOption, {
        selected: condition2.id === value,
        description: t5(`realm-settings-help:${camelCase2(condition2.id.replace(/-/g, " "))}`),
        key: condition2.id,
        value: condition2
      }, condition2.id)))
    })), /* @__PURE__ */ react.createElement(FormProvider, {
      ...form2
    }, conditionProperties.map((property2) => {
      const componentType = property2.type;
      if (property2.name === "roles") {
        return /* @__PURE__ */ react.createElement(MultivaluedRoleComponent, {
          ...property2
        });
      }
      if (property2.name === "scopes" || property2.name === "groups") {
        return /* @__PURE__ */ react.createElement(MultivaluedChipsComponent, {
          defaultValue: property2.name === "scopes" ? "offline_access" : "topgroup",
          ...property2
        });
      }
      if (isValidComponentType(componentType)) {
        const Component = COMPONENTS[componentType];
        return /* @__PURE__ */ react.createElement(Component, {
          key: property2.name,
          ...property2
        });
      } else {
        console.warn(`There is no editor registered for ${componentType}`);
      }
    })), /* @__PURE__ */ react.createElement(ActionGroup, null, /* @__PURE__ */ react.createElement(Button, {
      variant: "primary",
      type: "submit",
      "data-testid": "addCondition-saveBtn",
      isDisabled: conditionType === "" && !conditionName
    }, conditionName ? t5("common:save") : t5("common:add")), /* @__PURE__ */ react.createElement(Button, {
      variant: "link",
      "data-testid": "addCondition-cancelBtn",
      onClick: () => history.push(toEditClientPolicy({realm: realm2, policyName}))
    }, t5("common:cancel"))))));
  }
});

// build/realm-settings/NewClientPolicyForm.js
var require_NewClientPolicyForm = __commonJS((exports2) => {
  __markAsModule(exports2);
  __export(exports2, {
    default: () => NewClientPolicyForm
  });
  var defaultValues2 = {
    name: "",
    description: "",
    conditions: [],
    enabled: true,
    profiles: []
  };
  function NewClientPolicyForm() {
    const {t: t5} = useTranslation("realm-settings");
    const {errors, reset: resetForm} = useForm({
      defaultValues: defaultValues2
    });
    const {realm: realm2} = useRealm();
    const {addAlert, addError} = useAlerts();
    const adminClient = useAdminClient();
    const [policies, setPolicies] = useState([]);
    const [clientProfiles, setClientProfiles] = useState([]);
    const [currentPolicy, setCurrentPolicy] = useState();
    const [
      showAddConditionsAndProfilesForm,
      setShowAddConditionsAndProfilesForm
    ] = useState(false);
    const [conditionToDelete, setConditionToDelete] = useState();
    const [profilesModalOpen, setProfilesModalOpen] = useState(false);
    const [profileToDelete, setProfileToDelete] = useState();
    const {policyName} = useParams();
    const history = useHistory();
    const form2 = useForm({mode: "onChange"});
    const {handleSubmit} = form2;
    const [key, setKey] = useState(0);
    const refresh = () => setKey(new Date().getTime());
    const formValues = form2.getValues();
    const ClientPoliciesHeader = ({
      save: save2,
      onChange,
      value
    }) => {
      const {t: t22} = useTranslation("realm-settings");
      const [toggleDisableDialog, DisableConfirm] = useConfirmDialog({
        titleKey: "realm-settings:disablePolicyConfirmTitle",
        messageKey: "realm-settings:disablePolicyConfirm",
        continueButtonLabel: "common:disable",
        onConfirm: () => {
          onChange(!value);
          save2();
        }
      });
      return /* @__PURE__ */ react.createElement(react.Fragment, null, /* @__PURE__ */ react.createElement(DisableConfirm, null), /* @__PURE__ */ react.createElement(DeleteConfirm, null), /* @__PURE__ */ react.createElement(ViewHeader, {
        titleKey: showAddConditionsAndProfilesForm || policyName ? formValues.name : t22("createPolicy"),
        divider: true,
        dropdownItems: showAddConditionsAndProfilesForm || policyName ? [
          /* @__PURE__ */ react.createElement(DropdownItem, {
            key: "delete",
            value: "delete",
            onClick: () => {
              toggleDeleteDialog();
            },
            "data-testid": "deleteClientPolicyDropdown"
          }, t22("deleteClientPolicy"))
        ] : void 0,
        isEnabled: value,
        onToggle: (value2) => {
          if (!value2) {
            toggleDisableDialog();
          } else {
            onChange(value2);
            save2();
          }
        }
      }));
    };
    useFetch(async () => {
      const [policies2, profiles] = await Promise.all([
        adminClient.clientPolicies.listPolicies(),
        adminClient.clientPolicies.listProfiles({
          includeGlobalProfiles: true
        })
      ]);
      return {policies: policies2, profiles};
    }, ({policies: policies2, profiles}) => {
      const currentPolicy2 = policies2.policies?.find((item) => item.name === policyName);
      const allClientProfiles = [
        ...profiles.globalProfiles ?? [],
        ...profiles.profiles ?? []
      ];
      setPolicies(policies2.policies ?? []);
      if (currentPolicy2) {
        setupForm(currentPolicy2);
        setClientProfiles(allClientProfiles);
        setCurrentPolicy(currentPolicy2);
        setShowAddConditionsAndProfilesForm(true);
      }
    }, [key]);
    const setupForm = (policy2) => {
      resetForm();
      Object.entries(policy2).map(([key2, value]) => {
        form2.setValue(key2, value);
      });
    };
    const policy = policies.filter((policy2) => policy2.name === policyName);
    const policyConditions = policy[0]?.conditions || [];
    const policyProfiles = policy[0]?.profiles || [];
    const serverInfo2 = useServerInfo();
    const conditionTypes = serverInfo2.componentTypes?.["org.keycloak.services.clientpolicy.condition.ClientPolicyConditionProvider"];
    const save = async () => {
      const createdForm = form2.getValues();
      const createdPolicy = {
        ...createdForm,
        profiles: [],
        conditions: []
      };
      const getAllPolicies = () => {
        const policyNameExists = policies.some((policy2) => policy2.name === createdPolicy.name);
        if (policyNameExists) {
          return policies.map((policy2) => policy2.name === createdPolicy.name ? createdPolicy : policy2);
        } else if (createdForm.name !== policyName) {
          return policies.filter((item) => item.name !== policyName).concat(createdForm);
        }
        return policies.concat(createdForm);
      };
      try {
        await adminClient.clientPolicies.updatePolicy({
          policies: getAllPolicies()
        });
        addAlert(policyName ? t5("realm-settings:updateClientPolicySuccess") : t5("realm-settings:createClientPolicySuccess"), AlertVariant.success);
        history.push(`/${realm2}/realm-settings/clientPolicies/${createdForm.name}/edit-policy`);
        setShowAddConditionsAndProfilesForm(true);
        refresh();
      } catch (error2) {
        addError("realm-settings:createClientPolicyError", error2);
      }
    };
    const [toggleDeleteDialog, DeleteConfirm] = useConfirmDialog({
      titleKey: t5("deleteClientPolicyConfirmTitle"),
      messageKey: t5("deleteClientPolicyConfirm", {
        policyName
      }),
      continueButtonLabel: t5("delete"),
      continueButtonVariant: ButtonVariant.danger,
      onConfirm: async () => {
        const updatedPolicies = policies.filter((policy2) => policy2.name !== policyName);
        try {
          await adminClient.clientPolicies.updatePolicy({
            policies: updatedPolicies
          });
          addAlert(t5("deleteClientPolicySuccess"), AlertVariant.success);
          history.push(toClientPolicies({realm: realm2}));
        } catch (error2) {
          addError(t5("deleteClientPolicyError"), error2);
        }
      }
    });
    const [toggleDeleteConditionDialog, DeleteConditionConfirm] = useConfirmDialog({
      titleKey: t5("deleteClientPolicyConditionConfirmTitle"),
      messageKey: t5("deleteClientPolicyConditionConfirm", {
        condition: conditionToDelete?.name
      }),
      continueButtonLabel: t5("delete"),
      continueButtonVariant: ButtonVariant.danger,
      onConfirm: async () => {
        if (conditionToDelete?.name) {
          currentPolicy?.conditions?.splice(conditionToDelete.idx, 1);
          try {
            await adminClient.clientPolicies.updatePolicy({
              policies
            });
            addAlert(t5("deleteConditionSuccess"), AlertVariant.success);
            history.push(`/${realm2}/realm-settings/clientPolicies/${formValues.name}/edit-policy`);
            refresh();
          } catch (error2) {
            addError(t5("deleteConditionError"), error2);
          }
        } else {
          const updatedPolicies = policies.filter((policy2) => policy2.name !== policyName);
          try {
            await adminClient.clientPolicies.updatePolicy({
              policies: updatedPolicies
            });
            addAlert(t5("deleteClientSuccess"), AlertVariant.success);
            history.push(toClientPolicies({realm: realm2}));
          } catch (error2) {
            addError(t5("deleteClientError"), error2);
          }
        }
      }
    });
    const [toggleDeleteProfileDialog, DeleteProfileConfirm] = useConfirmDialog({
      titleKey: t5("deleteClientPolicyProfileConfirmTitle"),
      messageKey: t5("deleteClientPolicyProfileConfirm", {
        profileName: profileToDelete?.name,
        policyName
      }),
      continueButtonLabel: t5("delete"),
      continueButtonVariant: ButtonVariant.danger,
      onConfirm: async () => {
        if (profileToDelete?.name) {
          currentPolicy?.profiles?.splice(profileToDelete.idx, 1);
          try {
            await adminClient.clientPolicies.updatePolicy({
              policies
            });
            addAlert(t5("deleteClientPolicyProfileSuccess"), AlertVariant.success);
            history.push(`/${realm2}/realm-settings/clientPolicies/${formValues.name}/edit-policy`);
          } catch (error2) {
            addError(t5("deleteClientPolicyProfileError"), error2);
          }
        } else {
          const updatedPolicies = policies.filter((policy2) => policy2.name !== policyName);
          try {
            await adminClient.clientPolicies.updatePolicy({
              policies: updatedPolicies
            });
            addAlert(t5("deleteClientSuccess"), AlertVariant.success);
            history.push(toClientPolicies({realm: realm2}));
          } catch (error2) {
            addError(t5("deleteClientError"), error2);
          }
        }
      }
    });
    const reset2 = () => {
      form2.setValue("name", currentPolicy?.name);
      form2.setValue("description", currentPolicy?.description);
    };
    const refreshHeader = () => {
      setKey(new Date().getTime());
    };
    const toggleModal = () => {
      setProfilesModalOpen(!profilesModalOpen);
    };
    const addProfiles = async (profiles) => {
      const createdPolicy = {
        ...currentPolicy,
        profiles: (currentPolicy?.profiles ?? []).concat(profiles),
        conditions: currentPolicy?.conditions
      };
      const index3 = policies.findIndex((policy2) => createdPolicy.name === policy2.name);
      if (index3 === -1) {
        return;
      }
      const newPolicies = [
        ...policies.slice(0, index3),
        createdPolicy,
        ...policies.slice(index3 + 1)
      ];
      try {
        await adminClient.clientPolicies.updatePolicy({
          policies: newPolicies
        });
        setPolicies(newPolicies);
        history.push(`/${realm2}/realm-settings/clientPolicies/${formValues.name}/edit-policy`);
        addAlert(t5("realm-settings:addClientProfileSuccess"), AlertVariant.success);
      } catch (error2) {
        addError("realm-settings:addClientProfileError", error2);
      }
    };
    return /* @__PURE__ */ react.createElement(react.Fragment, null, /* @__PURE__ */ react.createElement(DeleteConditionConfirm, null), /* @__PURE__ */ react.createElement(DeleteProfileConfirm, null), /* @__PURE__ */ react.createElement(AddClientProfileModal, {
      onConfirm: (profiles) => {
        addProfiles(profiles.map((item) => item.name));
      },
      allProfiles: policyProfiles,
      open: profilesModalOpen,
      toggleDialog: toggleModal
    }), /* @__PURE__ */ react.createElement(Controller, {
      name: "enabled",
      defaultValue: true,
      control: form2.control,
      render: ({onChange, value}) => /* @__PURE__ */ react.createElement(ClientPoliciesHeader, {
        value,
        onChange,
        realmName: realm2,
        refresh: refreshHeader,
        save
      })
    }), /* @__PURE__ */ react.createElement(PageSection, {
      variant: "light"
    }, /* @__PURE__ */ react.createElement(FormAccess, {
      onSubmit: handleSubmit(save),
      isHorizontal: true,
      role: "view-realm",
      className: "pf-u-mt-lg"
    }, /* @__PURE__ */ react.createElement(FormGroup, {
      label: t5("common:name"),
      fieldId: "kc-name",
      isRequired: true,
      helperTextInvalid: t5("common:required"),
      validated: errors.name ? ValidatedOptions.error : ValidatedOptions.default
    }, /* @__PURE__ */ react.createElement(TextInput, {
      ref: form2.register({required: true}),
      type: "text",
      id: "kc-client-profile-name",
      name: "name",
      "data-testid": "client-policy-name"
    })), /* @__PURE__ */ react.createElement(FormGroup, {
      label: t5("common:description"),
      fieldId: "kc-description"
    }, /* @__PURE__ */ react.createElement(TextArea, {
      name: "description",
      "aria-label": t5("description"),
      ref: form2.register(),
      type: "text",
      id: "kc-client-policy-description",
      "data-testid": "client-policy-description"
    })), /* @__PURE__ */ react.createElement(ActionGroup, null, /* @__PURE__ */ react.createElement(Button, {
      variant: "primary",
      type: "submit",
      "data-testid": "saveCreatePolicy",
      isDisabled: !formValues.name
    }, t5("common:save")), /* @__PURE__ */ react.createElement(Button, {
      id: "cancelCreatePolicy",
      variant: "secondary",
      onClick: () => showAddConditionsAndProfilesForm || policyName ? reset2() : history.push(toClientPolicies({realm: realm2})),
      "data-testid": "cancelCreatePolicy"
    }, showAddConditionsAndProfilesForm ? t5("common:revert") : t5("common:cancel"))), (showAddConditionsAndProfilesForm || form2.formState.isSubmitted) && /* @__PURE__ */ react.createElement(react.Fragment, null, /* @__PURE__ */ react.createElement(Flex, null, /* @__PURE__ */ react.createElement(FlexItem, null, /* @__PURE__ */ react.createElement(Text, {
      className: "kc-conditions",
      component: TextVariants.h1
    }, t5("conditions"), /* @__PURE__ */ react.createElement(HelpItem, {
      helpText: t5("realm-settings-help:conditions"),
      forLabel: t5("conditionsHelpItem"),
      forID: t5("conditions")
    }))), /* @__PURE__ */ react.createElement(FlexItem, {
      align: {default: "alignRight"}
    }, /* @__PURE__ */ react.createElement(Button, {
      id: "addCondition",
      component: (props) => /* @__PURE__ */ react.createElement(Link, {
        ...props,
        to: toNewClientPolicyCondition({
          realm: realm2,
          policyName: formValues.name
        })
      }),
      variant: "link",
      className: "kc-addCondition",
      "data-testid": "addCondition",
      icon: /* @__PURE__ */ react.createElement(PlusCircleIcon, null)
    }, t5("realm-settings:addCondition")))), policyConditions.length > 0 ? /* @__PURE__ */ react.createElement(DataList, {
      "aria-label": t5("conditions"),
      isCompact: true
    }, policyConditions.map((condition, idx) => /* @__PURE__ */ react.createElement(DataListItem, {
      "aria-labelledby": "conditions-list-item",
      key: `list-item-${idx}`,
      id: condition.condition,
      "data-testid": "conditions-list-item"
    }, /* @__PURE__ */ react.createElement(DataListItemRow, {
      "data-testid": "conditions-list-row"
    }, /* @__PURE__ */ react.createElement(DataListItemCells, {
      dataListCells: [
        /* @__PURE__ */ react.createElement(DataListCell, {
          key: `name-${idx}`,
          "data-testid": "condition-type"
        }, Object.keys(condition.configuration).length !== 0 ? /* @__PURE__ */ react.createElement(Link, {
          key: condition.condition,
          "data-testid": `${condition.condition}-condition-link`,
          to: toEditClientPolicyCondition({
            realm: realm2,
            conditionName: condition.condition,
            policyName
          }),
          className: "kc-condition-link"
        }, condition.condition) : condition.condition, conditionTypes?.map((type) => type.id === condition.condition && /* @__PURE__ */ react.createElement(react.Fragment, null, /* @__PURE__ */ react.createElement(HelpItem, {
          helpText: type.helpText,
          forLabel: t5("conditionTypeHelpText"),
          forID: t5(`common:helpLabel`, {
            label: t5("conditionTypeHelpText")
          })
        }), /* @__PURE__ */ react.createElement(Button, {
          variant: "link",
          isInline: true,
          icon: /* @__PURE__ */ react.createElement(TrashIcon, {
            className: "kc-conditionType-trash-icon",
            "data-testid": `delete-${condition.condition}-condition`,
            onClick: () => {
              toggleDeleteConditionDialog();
              setConditionToDelete({
                idx,
                name: type.id
              });
            }
          })
        }))))
      ]
    }))))) : /* @__PURE__ */ react.createElement(react.Fragment, null, /* @__PURE__ */ react.createElement(Divider, null), /* @__PURE__ */ react.createElement(Text, {
      className: "kc-emptyConditions",
      component: TextVariants.h6
    }, t5("realm-settings:emptyConditions")))), (showAddConditionsAndProfilesForm || form2.formState.isSubmitted) && /* @__PURE__ */ react.createElement(react.Fragment, null, /* @__PURE__ */ react.createElement(Flex, null, /* @__PURE__ */ react.createElement(FlexItem, null, /* @__PURE__ */ react.createElement(Text, {
      className: "kc-client-profiles",
      component: TextVariants.h1
    }, t5("clientProfiles"), /* @__PURE__ */ react.createElement(HelpItem, {
      helpText: t5("realm-settings-help:clientProfiles"),
      forLabel: t5("clientProfilesHelpItem"),
      forID: t5("clientProfiles")
    }))), /* @__PURE__ */ react.createElement(FlexItem, {
      align: {default: "alignRight"}
    }, /* @__PURE__ */ react.createElement(Button, {
      id: "addClientProfile",
      variant: "link",
      className: "kc-addClientProfile",
      "data-testid": "addClientProfile",
      icon: /* @__PURE__ */ react.createElement(PlusCircleIcon, null),
      onClick: toggleModal
    }, t5("realm-settings:addClientProfile")))), policyProfiles.length > 0 ? /* @__PURE__ */ react.createElement(DataList, {
      "aria-label": t5("profiles"),
      isCompact: true
    }, policyProfiles.map((profile, idx) => /* @__PURE__ */ react.createElement(DataListItem, {
      "aria-labelledby": `${profile}-profile-list-item`,
      key: profile,
      id: `${profile}-profile-list-item`,
      "data-testid": "profile-list-item"
    }, /* @__PURE__ */ react.createElement(DataListItemRow, {
      "data-testid": "profile-list-row"
    }, /* @__PURE__ */ react.createElement(DataListItemCells, {
      dataListCells: [
        /* @__PURE__ */ react.createElement(DataListCell, {
          key: "name",
          "data-testid": "profile-name"
        }, profile && /* @__PURE__ */ react.createElement(Link, {
          key: profile,
          "data-testid": "profile-name-link",
          to: "",
          className: "kc-profile-link"
        }, profile), policyProfiles.filter((type) => type === profile).map((type) => /* @__PURE__ */ react.createElement(react.Fragment, null, /* @__PURE__ */ react.createElement(HelpItem, {
          helpText: clientProfiles.find((profile2) => type === profile2.name)?.description,
          forLabel: profile,
          forID: t5(`common:helpLabel`, {
            label: profile
          })
        }), /* @__PURE__ */ react.createElement(Button, {
          variant: "link",
          isInline: true,
          icon: /* @__PURE__ */ react.createElement(TrashIcon, {
            className: "kc-conditionType-trash-icon",
            "data-testid": "deleteClientProfileDropdown",
            onClick: () => {
              toggleDeleteProfileDialog();
              setProfileToDelete({
                idx,
                name: type
              });
            }
          })
        }))))
      ]
    }))))) : /* @__PURE__ */ react.createElement(react.Fragment, null, /* @__PURE__ */ react.createElement(Divider, null), /* @__PURE__ */ react.createElement(Text, {
      className: "kc-emptyClientProfiles",
      component: TextVariants.h6
    }, t5("realm-settings:emptyProfiles")))))));
  }
});

// build/realm-settings/RealmSettingsSection.js
var require_RealmSettingsSection = __commonJS((exports2) => {
  __markAsModule(exports2);
  __export(exports2, {
    EditExecutorCrumb: () => EditExecutorCrumb2,
    EditPolicyCrumb: () => EditPolicyCrumb2,
    EditProfileCrumb: () => EditProfileCrumb2,
    EditProviderCrumb: () => EditProviderCrumb7,
    NewPolicyCrumb: () => NewPolicyCrumb2,
    ToClientPolicies: () => ToClientPolicies,
    default: () => RealmSettingsSection
  });
  var EditProviderCrumb7 = () => {
    const {t: t5} = useTranslation("realm-settings");
    const {realm: realm2} = useRealm();
    return /* @__PURE__ */ react.createElement(Breadcrumb, null, /* @__PURE__ */ react.createElement(BreadcrumbItem, {
      render: (props) => /* @__PURE__ */ react.createElement(Link, {
        ...props,
        to: toRealmSettings({realm: realm2, tab: "keys"})
      }, t5("keys"))
    }), /* @__PURE__ */ react.createElement(BreadcrumbItem, null, t5("providers")), /* @__PURE__ */ react.createElement(BreadcrumbItem, {
      isActive: true
    }, t5("editProvider")));
  };
  var ToClientPolicies = () => {
    const {t: t5} = useTranslation("realm-settings");
    const {realm: realm2} = useRealm();
    return /* @__PURE__ */ react.createElement(BreadcrumbItem, {
      render: (props) => /* @__PURE__ */ react.createElement(Link, {
        ...props,
        to: toClientPolicies({realm: realm2})
      }, t5("clientPolicies"))
    });
  };
  var EditPolicyCrumb2 = () => {
    const {t: t5} = useTranslation("realm-settings");
    return /* @__PURE__ */ react.createElement(Breadcrumb, null, /* @__PURE__ */ react.createElement(ToClientPolicies, null), /* @__PURE__ */ react.createElement(BreadcrumbItem, {
      isActive: true
    }, t5("policyDetails")));
  };
  var EditProfileCrumb2 = () => {
    const {t: t5} = useTranslation("realm-settings");
    const {realm: realm2} = useRealm();
    return /* @__PURE__ */ react.createElement(Breadcrumb, null, /* @__PURE__ */ react.createElement(BreadcrumbItem, {
      render: (props) => /* @__PURE__ */ react.createElement(Link, {
        ...props,
        to: toClientPolicies({realm: realm2})
      }, t5("clientPolicies"))
    }), /* @__PURE__ */ react.createElement(BreadcrumbItem, {
      isActive: true
    }, t5("clientProfile")));
  };
  var EditExecutorCrumb2 = () => {
    const {t: t5} = useTranslation("realm-settings");
    const {realm: realm2} = useRealm();
    return /* @__PURE__ */ react.createElement(Breadcrumb, null, /* @__PURE__ */ react.createElement(BreadcrumbItem, {
      render: (props) => /* @__PURE__ */ react.createElement(Link, {
        ...props,
        to: toClientPolicies({realm: realm2})
      }, t5("clientPolicies"))
    }), /* @__PURE__ */ react.createElement(BreadcrumbItem, {
      isActive: true
    }, t5("executorDetails")));
  };
  var NewPolicyCrumb2 = () => {
    const {t: t5} = useTranslation("realm-settings");
    const {realm: realm2} = useRealm();
    return /* @__PURE__ */ react.createElement(Breadcrumb, null, /* @__PURE__ */ react.createElement(BreadcrumbItem, {
      render: (props) => /* @__PURE__ */ react.createElement(Link, {
        ...props,
        to: toClientPolicies({realm: realm2})
      }, t5("clientPolicies"))
    }), /* @__PURE__ */ react.createElement(BreadcrumbItem, {
      isActive: true
    }, t5("createPolicy")));
  };
  var sortByPriority = (components3) => {
    const sortedComponents = [...components3].sort((a2, b2) => {
      const priorityA = Number(a2.config?.priority);
      const priorityB = Number(b2.config?.priority);
      return (!isNaN(priorityB) ? priorityB : 0) - (!isNaN(priorityA) ? priorityA : 0);
    });
    return sortedComponents;
  };
  function RealmSettingsSection() {
    const adminClient = useAdminClient();
    const {realm: realmName} = useRealm();
    const [realm2, setRealm] = useState();
    const [realmComponents, setRealmComponents] = useState();
    const [key, setKey] = useState(0);
    const refresh = () => {
      setKey(key + 1);
    };
    useFetch(async () => {
      const realm22 = await adminClient.realms.findOne({realm: realmName});
      const realmComponents2 = await adminClient.components.find({
        type: KEY_PROVIDER_TYPE,
        realm: realmName
      });
      return {realm: realm22, realmComponents: realmComponents2};
    }, ({realm: realm22, realmComponents: realmComponents2}) => {
      setRealmComponents(sortByPriority(realmComponents2));
      setRealm(realm22);
    }, [key]);
    if (!realm2 || !realmComponents) {
      return /* @__PURE__ */ react.createElement(KeycloakSpinner, null);
    }
    return /* @__PURE__ */ react.createElement(RealmSettingsTabs, {
      realm: realm2,
      refresh,
      realmComponents
    });
  }
});

// build/realm-roles/RealmRoleTabs.js
var require_RealmRoleTabs = __commonJS((exports2) => {
  __markAsModule(exports2);
  __export(exports2, {
    default: () => RealmRoleTabs
  });
  function RealmRoleTabs() {
    const {t: t5} = useTranslation("roles");
    const form2 = useForm({
      mode: "onChange"
    });
    const {setValue, getValues, trigger, reset: reset2} = form2;
    const history = useHistory();
    const adminClient = useAdminClient();
    const [role, setRole] = useState();
    const {id: id3, clientId} = useParams();
    const {url} = useRouteMatch();
    const {realm: realmName} = useRealm();
    const [key, setKey] = useState("");
    const refresh = () => {
      setKey(`${new Date().getTime()}`);
    };
    const {addAlert, addError} = useAlerts();
    const [open2, setOpen] = useState(false);
    const convert = (role2) => {
      const {attributes, ...rest} = role2;
      return {
        attributes: attributesToArray(attributes),
        ...rest
      };
    };
    const [realm2, setRealm] = useState();
    useFetch(async () => {
      const realm22 = await adminClient.realms.findOne({realm: realmName});
      if (!id3) {
        return {realm: realm22};
      }
      const role2 = await adminClient.roles.findOneById({id: id3});
      return {realm: realm22, role: role2};
    }, ({realm: realm22, role: role2}) => {
      if (!realm22 || !role2 && id3) {
        throw new Error(t5("common:notFound"));
      }
      if (role2) {
        const convertedRole = convert(role2);
        setRole(convertedRole);
        Object.entries(convertedRole).map((entry) => {
          setValue(entry[0], entry[1]);
        });
      }
      setRealm(realm22);
    }, [key]);
    const save = async () => {
      try {
        const values2 = getValues();
        if (values2.attributes && values2.attributes[values2.attributes.length - 1]?.key === "") {
          setValue("attributes", values2.attributes.slice(0, values2.attributes.length - 1));
        }
        if (!await trigger()) {
          return;
        }
        const {attributes, ...rest} = values2;
        let roleRepresentation = rest;
        roleRepresentation.name = roleRepresentation.name?.trim();
        if (id3) {
          if (attributes) {
            roleRepresentation.attributes = arrayToAttributes(attributes);
          }
          roleRepresentation = {
            ...omit(role, "attributes"),
            ...roleRepresentation
          };
          if (!clientId) {
            await adminClient.roles.updateById({id: id3}, roleRepresentation);
          } else {
            await adminClient.clients.updateRole({id: clientId, roleName: values2.name}, roleRepresentation);
          }
          setRole(convert(roleRepresentation));
        } else {
          let createdRole;
          if (!clientId) {
            await adminClient.roles.create(roleRepresentation);
            createdRole = await adminClient.roles.findOneByName({
              name: values2.name
            });
          } else {
            await adminClient.clients.createRole({
              id: clientId,
              name: values2.name
            });
            if (values2.description) {
              await adminClient.clients.updateRole({id: clientId, roleName: values2.name}, roleRepresentation);
            }
            createdRole = await adminClient.clients.findRole({
              id: clientId,
              roleName: values2.name
            });
          }
          if (!createdRole) {
            throw new Error(t5("common:notFound"));
          }
          setRole(convert(createdRole));
          history.push(url.substr(0, url.lastIndexOf("/") + 1) + createdRole.id + "/details");
        }
        addAlert(t5(id3 ? "roleSaveSuccess" : "roleCreated"), AlertVariant.success);
      } catch (error2) {
        addError(`roles:${id3 ? "roleSave" : "roleCreate"}Error`, error2);
      }
    };
    const [toggleDeleteDialog, DeleteConfirm] = useConfirmDialog({
      titleKey: "roles:roleDeleteConfirm",
      messageKey: t5("roles:roleDeleteConfirmDialog", {
        name: role?.name || t5("createRole")
      }),
      continueButtonLabel: "common:delete",
      continueButtonVariant: ButtonVariant.danger,
      onConfirm: async () => {
        try {
          if (!clientId) {
            await adminClient.roles.delById({id: id3});
          } else {
            await adminClient.clients.delRole({
              id: clientId,
              roleName: role.name
            });
          }
          addAlert(t5("roleDeletedSuccess"), AlertVariant.success);
          history.push(url.substr(0, url.indexOf("/roles") + "/roles".length));
        } catch (error2) {
          addError("roles:roleDeleteError", error2);
        }
      }
    });
    const dropdownItems = url.includes("associated-roles") ? [
      /* @__PURE__ */ react.createElement(DropdownItem, {
        key: "delete-all-associated",
        component: "button",
        onClick: () => toggleDeleteAllAssociatedRolesDialog()
      }, t5("roles:removeAllAssociatedRoles")),
      /* @__PURE__ */ react.createElement(DropdownItem, {
        key: "delete-role",
        component: "button",
        onClick: () => {
          toggleDeleteDialog();
        }
      }, t5("deleteRole"))
    ] : [
      /* @__PURE__ */ react.createElement(DropdownItem, {
        key: "toggle-modal",
        "data-testid": "add-roles",
        component: "button",
        onClick: () => toggleModal()
      }, t5("addAssociatedRolesText")),
      /* @__PURE__ */ react.createElement(DropdownItem, {
        key: "delete-role",
        component: "button",
        onClick: () => toggleDeleteDialog()
      }, t5("deleteRole"))
    ];
    const [
      toggleDeleteAllAssociatedRolesDialog,
      DeleteAllAssociatedRolesConfirm
    ] = useConfirmDialog({
      titleKey: t5("roles:removeAllAssociatedRoles") + "?",
      messageKey: t5("roles:removeAllAssociatedRolesConfirmDialog", {
        name: role?.name || t5("createRole")
      }),
      continueButtonLabel: "common:delete",
      continueButtonVariant: ButtonVariant.danger,
      onConfirm: async () => {
        try {
          const additionalRoles = await adminClient.roles.getCompositeRoles({
            id: role.id
          });
          await adminClient.roles.delCompositeRoles({id: id3}, additionalRoles);
          addAlert(t5("compositeRoleOff"), AlertVariant.success, t5("compositesRemovedAlertDescription"));
          const loc = url.replace(/\/AssociatedRoles/g, "/details");
          history.push(loc);
          refresh();
        } catch (error2) {
          addError("roles:roleDeleteError", error2);
        }
      }
    });
    const toggleModal = () => {
      setOpen(!open2);
    };
    const clientRoleRouteMatch = useRouteMatch(ClientRoleRoute.path);
    const toAssociatedRoles = () => {
      const to = clientRoleRouteMatch ? toClientRole({
        ...clientRoleRouteMatch.params,
        tab: "associated-roles"
      }) : toRealmRole({
        realm: realm2?.realm,
        id: id3,
        tab: "associated-roles"
      });
      history.push(to);
    };
    const addComposites = async (composites) => {
      try {
        await adminClient.roles.createComposite({roleId: role?.id, realm: realm2.realm}, composites);
        refresh();
        toAssociatedRoles();
        addAlert(t5("addAssociatedRolesSuccess"), AlertVariant.success);
      } catch (error2) {
        addError("roles:addAssociatedRolesError", error2);
      }
    };
    const isDefaultRole = (name) => realm2?.defaultRole.name === name;
    if (!realm2) {
      return /* @__PURE__ */ react.createElement(KeycloakSpinner, null);
    }
    if (!role) {
      return /* @__PURE__ */ react.createElement(RealmRoleForm, {
        reset: () => reset2(role),
        form: form2,
        save,
        editMode: false
      });
    }
    return /* @__PURE__ */ react.createElement(react.Fragment, null, /* @__PURE__ */ react.createElement(DeleteConfirm, null), /* @__PURE__ */ react.createElement(DeleteAllAssociatedRolesConfirm, null), open2 && /* @__PURE__ */ react.createElement(AssociatedRolesModal, {
      id: id3,
      toggleDialog: toggleModal,
      onConfirm: addComposites
    }), /* @__PURE__ */ react.createElement(ViewHeader, {
      titleKey: role.name || t5("createRole"),
      badges: [
        {
          id: "composite-role-badge",
          text: role.composite ? t5("composite") : "",
          readonly: true
        }
      ],
      subKey: id3 ? "" : "roles:roleCreateExplain",
      actionsDropdownId: "roles-actions-dropdown",
      dropdownItems,
      divider: !id3
    }), /* @__PURE__ */ react.createElement(PageSection, {
      variant: "light",
      className: "pf-u-p-0"
    }, id3 && /* @__PURE__ */ react.createElement(KeycloakTabs, {
      isBox: true,
      mountOnEnter: true
    }, /* @__PURE__ */ react.createElement(Tab, {
      eventKey: "details",
      title: /* @__PURE__ */ react.createElement(TabTitleText, null, t5("common:details"))
    }, /* @__PURE__ */ react.createElement(RealmRoleForm, {
      reset: () => reset2(role),
      form: form2,
      save,
      editMode: true
    })), role.composite && /* @__PURE__ */ react.createElement(Tab, {
      eventKey: "associated-roles",
      title: /* @__PURE__ */ react.createElement(TabTitleText, null, t5("associatedRolesText"))
    }, /* @__PURE__ */ react.createElement(AssociatedRolesTab, {
      parentRole: role,
      refresh
    })), !isDefaultRole(role.name) && /* @__PURE__ */ react.createElement(Tab, {
      eventKey: "attributes",
      className: "kc-attributes-tab",
      title: /* @__PURE__ */ react.createElement(TabTitleText, null, t5("common:attributes"))
    }, /* @__PURE__ */ react.createElement(AttributesForm, {
      form: form2,
      save,
      reset: () => reset2(role)
    })), !isDefaultRole(role.name) && /* @__PURE__ */ react.createElement(Tab, {
      eventKey: "users-in-role",
      title: /* @__PURE__ */ react.createElement(TabTitleText, null, t5("usersInRole"))
    }, /* @__PURE__ */ react.createElement(UsersInRoleTab, {
      "data-cy": "users-in-role-tab"
    })))));
  }
});

// build/_snowpack/pkg/moment.js
var require_moment = __commonJS((exports2, module2) => {
  __markAsModule(exports2);
  __export(exports2, {
    default: () => moment_default
  });
  //! moment.js
  //! version : 2.29.1
  //! authors : Tim Wood, Iskren Chernev, Moment.js contributors
  //! license : MIT
  //! momentjs.com
  var hookCallback;
  function hooks() {
    return hookCallback.apply(null, arguments);
  }
  function setHookCallback(callback) {
    hookCallback = callback;
  }
  function isArray3(input) {
    return input instanceof Array || Object.prototype.toString.call(input) === "[object Array]";
  }
  function isObject5(input) {
    return input != null && Object.prototype.toString.call(input) === "[object Object]";
  }
  function hasOwnProp(a2, b2) {
    return Object.prototype.hasOwnProperty.call(a2, b2);
  }
  function isObjectEmpty(obj) {
    if (Object.getOwnPropertyNames) {
      return Object.getOwnPropertyNames(obj).length === 0;
    } else {
      var k2;
      for (k2 in obj) {
        if (hasOwnProp(obj, k2)) {
          return false;
        }
      }
      return true;
    }
  }
  function isUndefined5(input) {
    return input === void 0;
  }
  function isNumber3(input) {
    return typeof input === "number" || Object.prototype.toString.call(input) === "[object Number]";
  }
  function isDate2(input) {
    return input instanceof Date || Object.prototype.toString.call(input) === "[object Date]";
  }
  function map2(arr, fn) {
    var res = [], i3;
    for (i3 = 0; i3 < arr.length; ++i3) {
      res.push(fn(arr[i3], i3));
    }
    return res;
  }
  function extend3(a2, b2) {
    for (var i3 in b2) {
      if (hasOwnProp(b2, i3)) {
        a2[i3] = b2[i3];
      }
    }
    if (hasOwnProp(b2, "toString")) {
      a2.toString = b2.toString;
    }
    if (hasOwnProp(b2, "valueOf")) {
      a2.valueOf = b2.valueOf;
    }
    return a2;
  }
  function createUTC(input, format3, locale2, strict) {
    return createLocalOrUTC(input, format3, locale2, strict, true).utc();
  }
  function defaultParsingFlags() {
    return {
      empty: false,
      unusedTokens: [],
      unusedInput: [],
      overflow: -2,
      charsLeftOver: 0,
      nullInput: false,
      invalidEra: null,
      invalidMonth: null,
      invalidFormat: false,
      userInvalidated: false,
      iso: false,
      parsedDateParts: [],
      era: null,
      meridiem: null,
      rfc2822: false,
      weekdayMismatch: false
    };
  }
  function getParsingFlags(m2) {
    if (m2._pf == null) {
      m2._pf = defaultParsingFlags();
    }
    return m2._pf;
  }
  var some;
  if (Array.prototype.some) {
    some = Array.prototype.some;
  } else {
    some = function(fun) {
      var t5 = Object(this), len2 = t5.length >>> 0, i3;
      for (i3 = 0; i3 < len2; i3++) {
        if (i3 in t5 && fun.call(this, t5[i3], i3, t5)) {
          return true;
        }
      }
      return false;
    };
  }
  function isValid(m2) {
    if (m2._isValid == null) {
      var flags2 = getParsingFlags(m2), parsedParts = some.call(flags2.parsedDateParts, function(i3) {
        return i3 != null;
      }), isNowValid = !isNaN(m2._d.getTime()) && flags2.overflow < 0 && !flags2.empty && !flags2.invalidEra && !flags2.invalidMonth && !flags2.invalidWeekday && !flags2.weekdayMismatch && !flags2.nullInput && !flags2.invalidFormat && !flags2.userInvalidated && (!flags2.meridiem || flags2.meridiem && parsedParts);
      if (m2._strict) {
        isNowValid = isNowValid && flags2.charsLeftOver === 0 && flags2.unusedTokens.length === 0 && flags2.bigHour === void 0;
      }
      if (Object.isFrozen == null || !Object.isFrozen(m2)) {
        m2._isValid = isNowValid;
      } else {
        return isNowValid;
      }
    }
    return m2._isValid;
  }
  function createInvalid(flags2) {
    var m2 = createUTC(NaN);
    if (flags2 != null) {
      extend3(getParsingFlags(m2), flags2);
    } else {
      getParsingFlags(m2).userInvalidated = true;
    }
    return m2;
  }
  var momentProperties = hooks.momentProperties = [];
  var updateInProgress = false;
  function copyConfig(to2, from2) {
    var i3, prop, val;
    if (!isUndefined5(from2._isAMomentObject)) {
      to2._isAMomentObject = from2._isAMomentObject;
    }
    if (!isUndefined5(from2._i)) {
      to2._i = from2._i;
    }
    if (!isUndefined5(from2._f)) {
      to2._f = from2._f;
    }
    if (!isUndefined5(from2._l)) {
      to2._l = from2._l;
    }
    if (!isUndefined5(from2._strict)) {
      to2._strict = from2._strict;
    }
    if (!isUndefined5(from2._tzm)) {
      to2._tzm = from2._tzm;
    }
    if (!isUndefined5(from2._isUTC)) {
      to2._isUTC = from2._isUTC;
    }
    if (!isUndefined5(from2._offset)) {
      to2._offset = from2._offset;
    }
    if (!isUndefined5(from2._pf)) {
      to2._pf = getParsingFlags(from2);
    }
    if (!isUndefined5(from2._locale)) {
      to2._locale = from2._locale;
    }
    if (momentProperties.length > 0) {
      for (i3 = 0; i3 < momentProperties.length; i3++) {
        prop = momentProperties[i3];
        val = from2[prop];
        if (!isUndefined5(val)) {
          to2[prop] = val;
        }
      }
    }
    return to2;
  }
  function Moment(config2) {
    copyConfig(this, config2);
    this._d = new Date(config2._d != null ? config2._d.getTime() : NaN);
    if (!this.isValid()) {
      this._d = new Date(NaN);
    }
    if (updateInProgress === false) {
      updateInProgress = true;
      hooks.updateOffset(this);
      updateInProgress = false;
    }
  }
  function isMoment(obj) {
    return obj instanceof Moment || obj != null && obj._isAMomentObject != null;
  }
  function warn3(msg) {
    if (hooks.suppressDeprecationWarnings === false && typeof console !== "undefined" && console.warn) {
      console.warn("Deprecation warning: " + msg);
    }
  }
  function deprecate(msg, fn) {
    var firstTime = true;
    return extend3(function() {
      if (hooks.deprecationHandler != null) {
        hooks.deprecationHandler(null, msg);
      }
      if (firstTime) {
        var args = [], arg, i3, key;
        for (i3 = 0; i3 < arguments.length; i3++) {
          arg = "";
          if (typeof arguments[i3] === "object") {
            arg += "\n[" + i3 + "] ";
            for (key in arguments[0]) {
              if (hasOwnProp(arguments[0], key)) {
                arg += key + ": " + arguments[0][key] + ", ";
              }
            }
            arg = arg.slice(0, -2);
          } else {
            arg = arguments[i3];
          }
          args.push(arg);
        }
        warn3(msg + "\nArguments: " + Array.prototype.slice.call(args).join("") + "\n" + new Error().stack);
        firstTime = false;
      }
      return fn.apply(this, arguments);
    }, fn);
  }
  var deprecations = {};
  function deprecateSimple(name, msg) {
    if (hooks.deprecationHandler != null) {
      hooks.deprecationHandler(name, msg);
    }
    if (!deprecations[name]) {
      warn3(msg);
      deprecations[name] = true;
    }
  }
  hooks.suppressDeprecationWarnings = false;
  hooks.deprecationHandler = null;
  function isFunction6(input) {
    return typeof Function !== "undefined" && input instanceof Function || Object.prototype.toString.call(input) === "[object Function]";
  }
  function set3(config2) {
    var prop, i3;
    for (i3 in config2) {
      if (hasOwnProp(config2, i3)) {
        prop = config2[i3];
        if (isFunction6(prop)) {
          this[i3] = prop;
        } else {
          this["_" + i3] = prop;
        }
      }
    }
    this._config = config2;
    this._dayOfMonthOrdinalParseLenient = new RegExp((this._dayOfMonthOrdinalParse.source || this._ordinalParse.source) + "|" + /\d{1,2}/.source);
  }
  function mergeConfigs(parentConfig, childConfig) {
    var res = extend3({}, parentConfig), prop;
    for (prop in childConfig) {
      if (hasOwnProp(childConfig, prop)) {
        if (isObject5(parentConfig[prop]) && isObject5(childConfig[prop])) {
          res[prop] = {};
          extend3(res[prop], parentConfig[prop]);
          extend3(res[prop], childConfig[prop]);
        } else if (childConfig[prop] != null) {
          res[prop] = childConfig[prop];
        } else {
          delete res[prop];
        }
      }
    }
    for (prop in parentConfig) {
      if (hasOwnProp(parentConfig, prop) && !hasOwnProp(childConfig, prop) && isObject5(parentConfig[prop])) {
        res[prop] = extend3({}, res[prop]);
      }
    }
    return res;
  }
  function Locale(config2) {
    if (config2 != null) {
      this.set(config2);
    }
  }
  var keys2;
  if (Object.keys) {
    keys2 = Object.keys;
  } else {
    keys2 = function(obj) {
      var i3, res = [];
      for (i3 in obj) {
        if (hasOwnProp(obj, i3)) {
          res.push(i3);
        }
      }
      return res;
    };
  }
  var defaultCalendar = {
    sameDay: "[Today at] LT",
    nextDay: "[Tomorrow at] LT",
    nextWeek: "dddd [at] LT",
    lastDay: "[Yesterday at] LT",
    lastWeek: "[Last] dddd [at] LT",
    sameElse: "L"
  };
  function calendar(key, mom, now4) {
    var output2 = this._calendar[key] || this._calendar["sameElse"];
    return isFunction6(output2) ? output2.call(mom, now4) : output2;
  }
  function zeroFill(number, targetLength, forceSign) {
    var absNumber = "" + Math.abs(number), zerosToFill = targetLength - absNumber.length, sign2 = number >= 0;
    return (sign2 ? forceSign ? "+" : "" : "-") + Math.pow(10, Math.max(0, zerosToFill)).toString().substr(1) + absNumber;
  }
  var formattingTokens = /(\[[^\[]*\])|(\\)?([Hh]mm(ss)?|Mo|MM?M?M?|Do|DDDo|DD?D?D?|ddd?d?|do?|w[o|w]?|W[o|W]?|Qo?|N{1,5}|YYYYYY|YYYYY|YYYY|YY|y{2,4}|yo?|gg(ggg?)?|GG(GGG?)?|e|E|a|A|hh?|HH?|kk?|mm?|ss?|S{1,9}|x|X|zz?|ZZ?|.)/g;
  var localFormattingTokens = /(\[[^\[]*\])|(\\)?(LTS|LT|LL?L?L?|l{1,4})/g;
  var formatFunctions = {};
  var formatTokenFunctions = {};
  function addFormatToken(token3, padded, ordinal2, callback) {
    var func = callback;
    if (typeof callback === "string") {
      func = function() {
        return this[callback]();
      };
    }
    if (token3) {
      formatTokenFunctions[token3] = func;
    }
    if (padded) {
      formatTokenFunctions[padded[0]] = function() {
        return zeroFill(func.apply(this, arguments), padded[1], padded[2]);
      };
    }
    if (ordinal2) {
      formatTokenFunctions[ordinal2] = function() {
        return this.localeData().ordinal(func.apply(this, arguments), token3);
      };
    }
  }
  function removeFormattingTokens(input) {
    if (input.match(/\[[\s\S]/)) {
      return input.replace(/^\[|\]$/g, "");
    }
    return input.replace(/\\/g, "");
  }
  function makeFormatFunction(format3) {
    var array2 = format3.match(formattingTokens), i3, length;
    for (i3 = 0, length = array2.length; i3 < length; i3++) {
      if (formatTokenFunctions[array2[i3]]) {
        array2[i3] = formatTokenFunctions[array2[i3]];
      } else {
        array2[i3] = removeFormattingTokens(array2[i3]);
      }
    }
    return function(mom) {
      var output2 = "", i4;
      for (i4 = 0; i4 < length; i4++) {
        output2 += isFunction6(array2[i4]) ? array2[i4].call(mom, format3) : array2[i4];
      }
      return output2;
    };
  }
  function formatMoment(m2, format3) {
    if (!m2.isValid()) {
      return m2.localeData().invalidDate();
    }
    format3 = expandFormat(format3, m2.localeData());
    formatFunctions[format3] = formatFunctions[format3] || makeFormatFunction(format3);
    return formatFunctions[format3](m2);
  }
  function expandFormat(format3, locale2) {
    var i3 = 5;
    function replaceLongDateFormatTokens(input) {
      return locale2.longDateFormat(input) || input;
    }
    localFormattingTokens.lastIndex = 0;
    while (i3 >= 0 && localFormattingTokens.test(format3)) {
      format3 = format3.replace(localFormattingTokens, replaceLongDateFormatTokens);
      localFormattingTokens.lastIndex = 0;
      i3 -= 1;
    }
    return format3;
  }
  var defaultLongDateFormat = {
    LTS: "h:mm:ss A",
    LT: "h:mm A",
    L: "MM/DD/YYYY",
    LL: "MMMM D, YYYY",
    LLL: "MMMM D, YYYY h:mm A",
    LLLL: "dddd, MMMM D, YYYY h:mm A"
  };
  function longDateFormat(key) {
    var format3 = this._longDateFormat[key], formatUpper = this._longDateFormat[key.toUpperCase()];
    if (format3 || !formatUpper) {
      return format3;
    }
    this._longDateFormat[key] = formatUpper.match(formattingTokens).map(function(tok) {
      if (tok === "MMMM" || tok === "MM" || tok === "DD" || tok === "dddd") {
        return tok.slice(1);
      }
      return tok;
    }).join("");
    return this._longDateFormat[key];
  }
  var defaultInvalidDate = "Invalid date";
  function invalidDate() {
    return this._invalidDate;
  }
  var defaultOrdinal = "%d";
  var defaultDayOfMonthOrdinalParse = /\d{1,2}/;
  function ordinal(number) {
    return this._ordinal.replace("%d", number);
  }
  var defaultRelativeTime = {
    future: "in %s",
    past: "%s ago",
    s: "a few seconds",
    ss: "%d seconds",
    m: "a minute",
    mm: "%d minutes",
    h: "an hour",
    hh: "%d hours",
    d: "a day",
    dd: "%d days",
    w: "a week",
    ww: "%d weeks",
    M: "a month",
    MM: "%d months",
    y: "a year",
    yy: "%d years"
  };
  function relativeTime(number, withoutSuffix, string2, isFuture) {
    var output2 = this._relativeTime[string2];
    return isFunction6(output2) ? output2(number, withoutSuffix, string2, isFuture) : output2.replace(/%d/i, number);
  }
  function pastFuture(diff2, output2) {
    var format3 = this._relativeTime[diff2 > 0 ? "future" : "past"];
    return isFunction6(format3) ? format3(output2) : format3.replace(/%s/i, output2);
  }
  var aliases = {};
  function addUnitAlias(unit, shorthand) {
    var lowerCase = unit.toLowerCase();
    aliases[lowerCase] = aliases[lowerCase + "s"] = aliases[shorthand] = unit;
  }
  function normalizeUnits(units) {
    return typeof units === "string" ? aliases[units] || aliases[units.toLowerCase()] : void 0;
  }
  function normalizeObjectUnits(inputObject) {
    var normalizedInput = {}, normalizedProp, prop;
    for (prop in inputObject) {
      if (hasOwnProp(inputObject, prop)) {
        normalizedProp = normalizeUnits(prop);
        if (normalizedProp) {
          normalizedInput[normalizedProp] = inputObject[prop];
        }
      }
    }
    return normalizedInput;
  }
  var priorities = {};
  function addUnitPriority(unit, priority) {
    priorities[unit] = priority;
  }
  function getPrioritizedUnits(unitsObj) {
    var units = [], u;
    for (u in unitsObj) {
      if (hasOwnProp(unitsObj, u)) {
        units.push({unit: u, priority: priorities[u]});
      }
    }
    units.sort(function(a2, b2) {
      return a2.priority - b2.priority;
    });
    return units;
  }
  function isLeapYear(year) {
    return year % 4 === 0 && year % 100 !== 0 || year % 400 === 0;
  }
  function absFloor(number) {
    if (number < 0) {
      return Math.ceil(number) || 0;
    } else {
      return Math.floor(number);
    }
  }
  function toInt(argumentForCoercion) {
    var coercedNumber = +argumentForCoercion, value = 0;
    if (coercedNumber !== 0 && isFinite(coercedNumber)) {
      value = absFloor(coercedNumber);
    }
    return value;
  }
  function makeGetSet(unit, keepTime) {
    return function(value) {
      if (value != null) {
        set$12(this, unit, value);
        hooks.updateOffset(this, keepTime);
        return this;
      } else {
        return get7(this, unit);
      }
    };
  }
  function get7(mom, unit) {
    return mom.isValid() ? mom._d["get" + (mom._isUTC ? "UTC" : "") + unit]() : NaN;
  }
  function set$12(mom, unit, value) {
    if (mom.isValid() && !isNaN(value)) {
      if (unit === "FullYear" && isLeapYear(mom.year()) && mom.month() === 1 && mom.date() === 29) {
        value = toInt(value);
        mom._d["set" + (mom._isUTC ? "UTC" : "") + unit](value, mom.month(), daysInMonth(value, mom.month()));
      } else {
        mom._d["set" + (mom._isUTC ? "UTC" : "") + unit](value);
      }
    }
  }
  function stringGet(units) {
    units = normalizeUnits(units);
    if (isFunction6(this[units])) {
      return this[units]();
    }
    return this;
  }
  function stringSet(units, value) {
    if (typeof units === "object") {
      units = normalizeObjectUnits(units);
      var prioritized = getPrioritizedUnits(units), i3;
      for (i3 = 0; i3 < prioritized.length; i3++) {
        this[prioritized[i3].unit](units[prioritized[i3].unit]);
      }
    } else {
      units = normalizeUnits(units);
      if (isFunction6(this[units])) {
        return this[units](value);
      }
    }
    return this;
  }
  var match1 = /\d/;
  var match2 = /\d\d/;
  var match3 = /\d{3}/;
  var match4 = /\d{4}/;
  var match6 = /[+-]?\d{6}/;
  var match1to2 = /\d\d?/;
  var match3to4 = /\d\d\d\d?/;
  var match5to6 = /\d\d\d\d\d\d?/;
  var match1to3 = /\d{1,3}/;
  var match1to4 = /\d{1,4}/;
  var match1to6 = /[+-]?\d{1,6}/;
  var matchUnsigned = /\d+/;
  var matchSigned = /[+-]?\d+/;
  var matchOffset = /Z|[+-]\d\d:?\d\d/gi;
  var matchShortOffset = /Z|[+-]\d\d(?::?\d\d)?/gi;
  var matchTimestamp = /[+-]?\d+(\.\d{1,3})?/;
  var matchWord = /[0-9]{0,256}['a-z\u00A0-\u05FF\u0700-\uD7FF\uF900-\uFDCF\uFDF0-\uFF07\uFF10-\uFFEF]{1,256}|[\u0600-\u06FF\/]{1,256}(\s*?[\u0600-\u06FF]{1,256}){1,2}/i;
  var regexes;
  regexes = {};
  function addRegexToken(token3, regex, strictRegex) {
    regexes[token3] = isFunction6(regex) ? regex : function(isStrict, localeData2) {
      return isStrict && strictRegex ? strictRegex : regex;
    };
  }
  function getParseRegexForToken(token3, config2) {
    if (!hasOwnProp(regexes, token3)) {
      return new RegExp(unescapeFormat(token3));
    }
    return regexes[token3](config2._strict, config2._locale);
  }
  function unescapeFormat(s2) {
    return regexEscape2(s2.replace("\\", "").replace(/\\(\[)|\\(\])|\[([^\]\[]*)\]|\\(.)/g, function(matched, p1, p2, p3, p4) {
      return p1 || p2 || p3 || p4;
    }));
  }
  function regexEscape2(s2) {
    return s2.replace(/[-\/\\^$*+?.()|[\]{}]/g, "\\$&");
  }
  var tokens = {};
  function addParseToken(token3, callback) {
    var i3, func = callback;
    if (typeof token3 === "string") {
      token3 = [token3];
    }
    if (isNumber3(callback)) {
      func = function(input, array2) {
        array2[callback] = toInt(input);
      };
    }
    for (i3 = 0; i3 < token3.length; i3++) {
      tokens[token3[i3]] = func;
    }
  }
  function addWeekParseToken(token3, callback) {
    addParseToken(token3, function(input, array2, config2, token4) {
      config2._w = config2._w || {};
      callback(input, config2._w, config2, token4);
    });
  }
  function addTimeToArrayFromToken(token3, input, config2) {
    if (input != null && hasOwnProp(tokens, token3)) {
      tokens[token3](input, config2._a, config2, token3);
    }
  }
  var YEAR = 0;
  var MONTH = 1;
  var DATE = 2;
  var HOUR = 3;
  var MINUTE = 4;
  var SECOND = 5;
  var MILLISECOND = 6;
  var WEEK = 7;
  var WEEKDAY = 8;
  function mod(n3, x2) {
    return (n3 % x2 + x2) % x2;
  }
  var indexOf;
  if (Array.prototype.indexOf) {
    indexOf = Array.prototype.indexOf;
  } else {
    indexOf = function(o) {
      var i3;
      for (i3 = 0; i3 < this.length; ++i3) {
        if (this[i3] === o) {
          return i3;
        }
      }
      return -1;
    };
  }
  function daysInMonth(year, month) {
    if (isNaN(year) || isNaN(month)) {
      return NaN;
    }
    var modMonth = mod(month, 12);
    year += (month - modMonth) / 12;
    return modMonth === 1 ? isLeapYear(year) ? 29 : 28 : 31 - modMonth % 7 % 2;
  }
  addFormatToken("M", ["MM", 2], "Mo", function() {
    return this.month() + 1;
  });
  addFormatToken("MMM", 0, 0, function(format3) {
    return this.localeData().monthsShort(this, format3);
  });
  addFormatToken("MMMM", 0, 0, function(format3) {
    return this.localeData().months(this, format3);
  });
  addUnitAlias("month", "M");
  addUnitPriority("month", 8);
  addRegexToken("M", match1to2);
  addRegexToken("MM", match1to2, match2);
  addRegexToken("MMM", function(isStrict, locale2) {
    return locale2.monthsShortRegex(isStrict);
  });
  addRegexToken("MMMM", function(isStrict, locale2) {
    return locale2.monthsRegex(isStrict);
  });
  addParseToken(["M", "MM"], function(input, array2) {
    array2[MONTH] = toInt(input) - 1;
  });
  addParseToken(["MMM", "MMMM"], function(input, array2, config2, token3) {
    var month = config2._locale.monthsParse(input, token3, config2._strict);
    if (month != null) {
      array2[MONTH] = month;
    } else {
      getParsingFlags(config2).invalidMonth = input;
    }
  });
  var defaultLocaleMonths = "January_February_March_April_May_June_July_August_September_October_November_December".split("_");
  var defaultLocaleMonthsShort = "Jan_Feb_Mar_Apr_May_Jun_Jul_Aug_Sep_Oct_Nov_Dec".split("_");
  var MONTHS_IN_FORMAT = /D[oD]?(\[[^\[\]]*\]|\s)+MMMM?/;
  var defaultMonthsShortRegex = matchWord;
  var defaultMonthsRegex = matchWord;
  function localeMonths(m2, format3) {
    if (!m2) {
      return isArray3(this._months) ? this._months : this._months["standalone"];
    }
    return isArray3(this._months) ? this._months[m2.month()] : this._months[(this._months.isFormat || MONTHS_IN_FORMAT).test(format3) ? "format" : "standalone"][m2.month()];
  }
  function localeMonthsShort(m2, format3) {
    if (!m2) {
      return isArray3(this._monthsShort) ? this._monthsShort : this._monthsShort["standalone"];
    }
    return isArray3(this._monthsShort) ? this._monthsShort[m2.month()] : this._monthsShort[MONTHS_IN_FORMAT.test(format3) ? "format" : "standalone"][m2.month()];
  }
  function handleStrictParse(monthName, format3, strict) {
    var i3, ii2, mom, llc = monthName.toLocaleLowerCase();
    if (!this._monthsParse) {
      this._monthsParse = [];
      this._longMonthsParse = [];
      this._shortMonthsParse = [];
      for (i3 = 0; i3 < 12; ++i3) {
        mom = createUTC([2e3, i3]);
        this._shortMonthsParse[i3] = this.monthsShort(mom, "").toLocaleLowerCase();
        this._longMonthsParse[i3] = this.months(mom, "").toLocaleLowerCase();
      }
    }
    if (strict) {
      if (format3 === "MMM") {
        ii2 = indexOf.call(this._shortMonthsParse, llc);
        return ii2 !== -1 ? ii2 : null;
      } else {
        ii2 = indexOf.call(this._longMonthsParse, llc);
        return ii2 !== -1 ? ii2 : null;
      }
    } else {
      if (format3 === "MMM") {
        ii2 = indexOf.call(this._shortMonthsParse, llc);
        if (ii2 !== -1) {
          return ii2;
        }
        ii2 = indexOf.call(this._longMonthsParse, llc);
        return ii2 !== -1 ? ii2 : null;
      } else {
        ii2 = indexOf.call(this._longMonthsParse, llc);
        if (ii2 !== -1) {
          return ii2;
        }
        ii2 = indexOf.call(this._shortMonthsParse, llc);
        return ii2 !== -1 ? ii2 : null;
      }
    }
  }
  function localeMonthsParse(monthName, format3, strict) {
    var i3, mom, regex;
    if (this._monthsParseExact) {
      return handleStrictParse.call(this, monthName, format3, strict);
    }
    if (!this._monthsParse) {
      this._monthsParse = [];
      this._longMonthsParse = [];
      this._shortMonthsParse = [];
    }
    for (i3 = 0; i3 < 12; i3++) {
      mom = createUTC([2e3, i3]);
      if (strict && !this._longMonthsParse[i3]) {
        this._longMonthsParse[i3] = new RegExp("^" + this.months(mom, "").replace(".", "") + "$", "i");
        this._shortMonthsParse[i3] = new RegExp("^" + this.monthsShort(mom, "").replace(".", "") + "$", "i");
      }
      if (!strict && !this._monthsParse[i3]) {
        regex = "^" + this.months(mom, "") + "|^" + this.monthsShort(mom, "");
        this._monthsParse[i3] = new RegExp(regex.replace(".", ""), "i");
      }
      if (strict && format3 === "MMMM" && this._longMonthsParse[i3].test(monthName)) {
        return i3;
      } else if (strict && format3 === "MMM" && this._shortMonthsParse[i3].test(monthName)) {
        return i3;
      } else if (!strict && this._monthsParse[i3].test(monthName)) {
        return i3;
      }
    }
  }
  function setMonth(mom, value) {
    var dayOfMonth;
    if (!mom.isValid()) {
      return mom;
    }
    if (typeof value === "string") {
      if (/^\d+$/.test(value)) {
        value = toInt(value);
      } else {
        value = mom.localeData().monthsParse(value);
        if (!isNumber3(value)) {
          return mom;
        }
      }
    }
    dayOfMonth = Math.min(mom.date(), daysInMonth(mom.year(), value));
    mom._d["set" + (mom._isUTC ? "UTC" : "") + "Month"](value, dayOfMonth);
    return mom;
  }
  function getSetMonth(value) {
    if (value != null) {
      setMonth(this, value);
      hooks.updateOffset(this, true);
      return this;
    } else {
      return get7(this, "Month");
    }
  }
  function getDaysInMonth() {
    return daysInMonth(this.year(), this.month());
  }
  function monthsShortRegex(isStrict) {
    if (this._monthsParseExact) {
      if (!hasOwnProp(this, "_monthsRegex")) {
        computeMonthsParse.call(this);
      }
      if (isStrict) {
        return this._monthsShortStrictRegex;
      } else {
        return this._monthsShortRegex;
      }
    } else {
      if (!hasOwnProp(this, "_monthsShortRegex")) {
        this._monthsShortRegex = defaultMonthsShortRegex;
      }
      return this._monthsShortStrictRegex && isStrict ? this._monthsShortStrictRegex : this._monthsShortRegex;
    }
  }
  function monthsRegex(isStrict) {
    if (this._monthsParseExact) {
      if (!hasOwnProp(this, "_monthsRegex")) {
        computeMonthsParse.call(this);
      }
      if (isStrict) {
        return this._monthsStrictRegex;
      } else {
        return this._monthsRegex;
      }
    } else {
      if (!hasOwnProp(this, "_monthsRegex")) {
        this._monthsRegex = defaultMonthsRegex;
      }
      return this._monthsStrictRegex && isStrict ? this._monthsStrictRegex : this._monthsRegex;
    }
  }
  function computeMonthsParse() {
    function cmpLenRev(a2, b2) {
      return b2.length - a2.length;
    }
    var shortPieces = [], longPieces = [], mixedPieces = [], i3, mom;
    for (i3 = 0; i3 < 12; i3++) {
      mom = createUTC([2e3, i3]);
      shortPieces.push(this.monthsShort(mom, ""));
      longPieces.push(this.months(mom, ""));
      mixedPieces.push(this.months(mom, ""));
      mixedPieces.push(this.monthsShort(mom, ""));
    }
    shortPieces.sort(cmpLenRev);
    longPieces.sort(cmpLenRev);
    mixedPieces.sort(cmpLenRev);
    for (i3 = 0; i3 < 12; i3++) {
      shortPieces[i3] = regexEscape2(shortPieces[i3]);
      longPieces[i3] = regexEscape2(longPieces[i3]);
    }
    for (i3 = 0; i3 < 24; i3++) {
      mixedPieces[i3] = regexEscape2(mixedPieces[i3]);
    }
    this._monthsRegex = new RegExp("^(" + mixedPieces.join("|") + ")", "i");
    this._monthsShortRegex = this._monthsRegex;
    this._monthsStrictRegex = new RegExp("^(" + longPieces.join("|") + ")", "i");
    this._monthsShortStrictRegex = new RegExp("^(" + shortPieces.join("|") + ")", "i");
  }
  addFormatToken("Y", 0, 0, function() {
    var y3 = this.year();
    return y3 <= 9999 ? zeroFill(y3, 4) : "+" + y3;
  });
  addFormatToken(0, ["YY", 2], 0, function() {
    return this.year() % 100;
  });
  addFormatToken(0, ["YYYY", 4], 0, "year");
  addFormatToken(0, ["YYYYY", 5], 0, "year");
  addFormatToken(0, ["YYYYYY", 6, true], 0, "year");
  addUnitAlias("year", "y");
  addUnitPriority("year", 1);
  addRegexToken("Y", matchSigned);
  addRegexToken("YY", match1to2, match2);
  addRegexToken("YYYY", match1to4, match4);
  addRegexToken("YYYYY", match1to6, match6);
  addRegexToken("YYYYYY", match1to6, match6);
  addParseToken(["YYYYY", "YYYYYY"], YEAR);
  addParseToken("YYYY", function(input, array2) {
    array2[YEAR] = input.length === 2 ? hooks.parseTwoDigitYear(input) : toInt(input);
  });
  addParseToken("YY", function(input, array2) {
    array2[YEAR] = hooks.parseTwoDigitYear(input);
  });
  addParseToken("Y", function(input, array2) {
    array2[YEAR] = parseInt(input, 10);
  });
  function daysInYear(year) {
    return isLeapYear(year) ? 366 : 365;
  }
  hooks.parseTwoDigitYear = function(input) {
    return toInt(input) + (toInt(input) > 68 ? 1900 : 2e3);
  };
  var getSetYear = makeGetSet("FullYear", true);
  function getIsLeapYear() {
    return isLeapYear(this.year());
  }
  function createDate(y3, m2, d2, h2, M2, s2, ms) {
    var date;
    if (y3 < 100 && y3 >= 0) {
      date = new Date(y3 + 400, m2, d2, h2, M2, s2, ms);
      if (isFinite(date.getFullYear())) {
        date.setFullYear(y3);
      }
    } else {
      date = new Date(y3, m2, d2, h2, M2, s2, ms);
    }
    return date;
  }
  function createUTCDate(y3) {
    var date, args;
    if (y3 < 100 && y3 >= 0) {
      args = Array.prototype.slice.call(arguments);
      args[0] = y3 + 400;
      date = new Date(Date.UTC.apply(null, args));
      if (isFinite(date.getUTCFullYear())) {
        date.setUTCFullYear(y3);
      }
    } else {
      date = new Date(Date.UTC.apply(null, arguments));
    }
    return date;
  }
  function firstWeekOffset(year, dow, doy) {
    var fwd = 7 + dow - doy, fwdlw = (7 + createUTCDate(year, 0, fwd).getUTCDay() - dow) % 7;
    return -fwdlw + fwd - 1;
  }
  function dayOfYearFromWeeks(year, week, weekday, dow, doy) {
    var localWeekday = (7 + weekday - dow) % 7, weekOffset = firstWeekOffset(year, dow, doy), dayOfYear = 1 + 7 * (week - 1) + localWeekday + weekOffset, resYear, resDayOfYear;
    if (dayOfYear <= 0) {
      resYear = year - 1;
      resDayOfYear = daysInYear(resYear) + dayOfYear;
    } else if (dayOfYear > daysInYear(year)) {
      resYear = year + 1;
      resDayOfYear = dayOfYear - daysInYear(year);
    } else {
      resYear = year;
      resDayOfYear = dayOfYear;
    }
    return {
      year: resYear,
      dayOfYear: resDayOfYear
    };
  }
  function weekOfYear(mom, dow, doy) {
    var weekOffset = firstWeekOffset(mom.year(), dow, doy), week = Math.floor((mom.dayOfYear() - weekOffset - 1) / 7) + 1, resWeek, resYear;
    if (week < 1) {
      resYear = mom.year() - 1;
      resWeek = week + weeksInYear(resYear, dow, doy);
    } else if (week > weeksInYear(mom.year(), dow, doy)) {
      resWeek = week - weeksInYear(mom.year(), dow, doy);
      resYear = mom.year() + 1;
    } else {
      resYear = mom.year();
      resWeek = week;
    }
    return {
      week: resWeek,
      year: resYear
    };
  }
  function weeksInYear(year, dow, doy) {
    var weekOffset = firstWeekOffset(year, dow, doy), weekOffsetNext = firstWeekOffset(year + 1, dow, doy);
    return (daysInYear(year) - weekOffset + weekOffsetNext) / 7;
  }
  addFormatToken("w", ["ww", 2], "wo", "week");
  addFormatToken("W", ["WW", 2], "Wo", "isoWeek");
  addUnitAlias("week", "w");
  addUnitAlias("isoWeek", "W");
  addUnitPriority("week", 5);
  addUnitPriority("isoWeek", 5);
  addRegexToken("w", match1to2);
  addRegexToken("ww", match1to2, match2);
  addRegexToken("W", match1to2);
  addRegexToken("WW", match1to2, match2);
  addWeekParseToken(["w", "ww", "W", "WW"], function(input, week, config2, token3) {
    week[token3.substr(0, 1)] = toInt(input);
  });
  function localeWeek(mom) {
    return weekOfYear(mom, this._week.dow, this._week.doy).week;
  }
  var defaultLocaleWeek = {
    dow: 0,
    doy: 6
  };
  function localeFirstDayOfWeek() {
    return this._week.dow;
  }
  function localeFirstDayOfYear() {
    return this._week.doy;
  }
  function getSetWeek(input) {
    var week = this.localeData().week(this);
    return input == null ? week : this.add((input - week) * 7, "d");
  }
  function getSetISOWeek(input) {
    var week = weekOfYear(this, 1, 4).week;
    return input == null ? week : this.add((input - week) * 7, "d");
  }
  addFormatToken("d", 0, "do", "day");
  addFormatToken("dd", 0, 0, function(format3) {
    return this.localeData().weekdaysMin(this, format3);
  });
  addFormatToken("ddd", 0, 0, function(format3) {
    return this.localeData().weekdaysShort(this, format3);
  });
  addFormatToken("dddd", 0, 0, function(format3) {
    return this.localeData().weekdays(this, format3);
  });
  addFormatToken("e", 0, 0, "weekday");
  addFormatToken("E", 0, 0, "isoWeekday");
  addUnitAlias("day", "d");
  addUnitAlias("weekday", "e");
  addUnitAlias("isoWeekday", "E");
  addUnitPriority("day", 11);
  addUnitPriority("weekday", 11);
  addUnitPriority("isoWeekday", 11);
  addRegexToken("d", match1to2);
  addRegexToken("e", match1to2);
  addRegexToken("E", match1to2);
  addRegexToken("dd", function(isStrict, locale2) {
    return locale2.weekdaysMinRegex(isStrict);
  });
  addRegexToken("ddd", function(isStrict, locale2) {
    return locale2.weekdaysShortRegex(isStrict);
  });
  addRegexToken("dddd", function(isStrict, locale2) {
    return locale2.weekdaysRegex(isStrict);
  });
  addWeekParseToken(["dd", "ddd", "dddd"], function(input, week, config2, token3) {
    var weekday = config2._locale.weekdaysParse(input, token3, config2._strict);
    if (weekday != null) {
      week.d = weekday;
    } else {
      getParsingFlags(config2).invalidWeekday = input;
    }
  });
  addWeekParseToken(["d", "e", "E"], function(input, week, config2, token3) {
    week[token3] = toInt(input);
  });
  function parseWeekday(input, locale2) {
    if (typeof input !== "string") {
      return input;
    }
    if (!isNaN(input)) {
      return parseInt(input, 10);
    }
    input = locale2.weekdaysParse(input);
    if (typeof input === "number") {
      return input;
    }
    return null;
  }
  function parseIsoWeekday(input, locale2) {
    if (typeof input === "string") {
      return locale2.weekdaysParse(input) % 7 || 7;
    }
    return isNaN(input) ? null : input;
  }
  function shiftWeekdays(ws, n3) {
    return ws.slice(n3, 7).concat(ws.slice(0, n3));
  }
  var defaultLocaleWeekdays = "Sunday_Monday_Tuesday_Wednesday_Thursday_Friday_Saturday".split("_");
  var defaultLocaleWeekdaysShort = "Sun_Mon_Tue_Wed_Thu_Fri_Sat".split("_");
  var defaultLocaleWeekdaysMin = "Su_Mo_Tu_We_Th_Fr_Sa".split("_");
  var defaultWeekdaysRegex = matchWord;
  var defaultWeekdaysShortRegex = matchWord;
  var defaultWeekdaysMinRegex = matchWord;
  function localeWeekdays(m2, format3) {
    var weekdays = isArray3(this._weekdays) ? this._weekdays : this._weekdays[m2 && m2 !== true && this._weekdays.isFormat.test(format3) ? "format" : "standalone"];
    return m2 === true ? shiftWeekdays(weekdays, this._week.dow) : m2 ? weekdays[m2.day()] : weekdays;
  }
  function localeWeekdaysShort(m2) {
    return m2 === true ? shiftWeekdays(this._weekdaysShort, this._week.dow) : m2 ? this._weekdaysShort[m2.day()] : this._weekdaysShort;
  }
  function localeWeekdaysMin(m2) {
    return m2 === true ? shiftWeekdays(this._weekdaysMin, this._week.dow) : m2 ? this._weekdaysMin[m2.day()] : this._weekdaysMin;
  }
  function handleStrictParse$1(weekdayName, format3, strict) {
    var i3, ii2, mom, llc = weekdayName.toLocaleLowerCase();
    if (!this._weekdaysParse) {
      this._weekdaysParse = [];
      this._shortWeekdaysParse = [];
      this._minWeekdaysParse = [];
      for (i3 = 0; i3 < 7; ++i3) {
        mom = createUTC([2e3, 1]).day(i3);
        this._minWeekdaysParse[i3] = this.weekdaysMin(mom, "").toLocaleLowerCase();
        this._shortWeekdaysParse[i3] = this.weekdaysShort(mom, "").toLocaleLowerCase();
        this._weekdaysParse[i3] = this.weekdays(mom, "").toLocaleLowerCase();
      }
    }
    if (strict) {
      if (format3 === "dddd") {
        ii2 = indexOf.call(this._weekdaysParse, llc);
        return ii2 !== -1 ? ii2 : null;
      } else if (format3 === "ddd") {
        ii2 = indexOf.call(this._shortWeekdaysParse, llc);
        return ii2 !== -1 ? ii2 : null;
      } else {
        ii2 = indexOf.call(this._minWeekdaysParse, llc);
        return ii2 !== -1 ? ii2 : null;
      }
    } else {
      if (format3 === "dddd") {
        ii2 = indexOf.call(this._weekdaysParse, llc);
        if (ii2 !== -1) {
          return ii2;
        }
        ii2 = indexOf.call(this._shortWeekdaysParse, llc);
        if (ii2 !== -1) {
          return ii2;
        }
        ii2 = indexOf.call(this._minWeekdaysParse, llc);
        return ii2 !== -1 ? ii2 : null;
      } else if (format3 === "ddd") {
        ii2 = indexOf.call(this._shortWeekdaysParse, llc);
        if (ii2 !== -1) {
          return ii2;
        }
        ii2 = indexOf.call(this._weekdaysParse, llc);
        if (ii2 !== -1) {
          return ii2;
        }
        ii2 = indexOf.call(this._minWeekdaysParse, llc);
        return ii2 !== -1 ? ii2 : null;
      } else {
        ii2 = indexOf.call(this._minWeekdaysParse, llc);
        if (ii2 !== -1) {
          return ii2;
        }
        ii2 = indexOf.call(this._weekdaysParse, llc);
        if (ii2 !== -1) {
          return ii2;
        }
        ii2 = indexOf.call(this._shortWeekdaysParse, llc);
        return ii2 !== -1 ? ii2 : null;
      }
    }
  }
  function localeWeekdaysParse(weekdayName, format3, strict) {
    var i3, mom, regex;
    if (this._weekdaysParseExact) {
      return handleStrictParse$1.call(this, weekdayName, format3, strict);
    }
    if (!this._weekdaysParse) {
      this._weekdaysParse = [];
      this._minWeekdaysParse = [];
      this._shortWeekdaysParse = [];
      this._fullWeekdaysParse = [];
    }
    for (i3 = 0; i3 < 7; i3++) {
      mom = createUTC([2e3, 1]).day(i3);
      if (strict && !this._fullWeekdaysParse[i3]) {
        this._fullWeekdaysParse[i3] = new RegExp("^" + this.weekdays(mom, "").replace(".", "\\.?") + "$", "i");
        this._shortWeekdaysParse[i3] = new RegExp("^" + this.weekdaysShort(mom, "").replace(".", "\\.?") + "$", "i");
        this._minWeekdaysParse[i3] = new RegExp("^" + this.weekdaysMin(mom, "").replace(".", "\\.?") + "$", "i");
      }
      if (!this._weekdaysParse[i3]) {
        regex = "^" + this.weekdays(mom, "") + "|^" + this.weekdaysShort(mom, "") + "|^" + this.weekdaysMin(mom, "");
        this._weekdaysParse[i3] = new RegExp(regex.replace(".", ""), "i");
      }
      if (strict && format3 === "dddd" && this._fullWeekdaysParse[i3].test(weekdayName)) {
        return i3;
      } else if (strict && format3 === "ddd" && this._shortWeekdaysParse[i3].test(weekdayName)) {
        return i3;
      } else if (strict && format3 === "dd" && this._minWeekdaysParse[i3].test(weekdayName)) {
        return i3;
      } else if (!strict && this._weekdaysParse[i3].test(weekdayName)) {
        return i3;
      }
    }
  }
  function getSetDayOfWeek(input) {
    if (!this.isValid()) {
      return input != null ? this : NaN;
    }
    var day = this._isUTC ? this._d.getUTCDay() : this._d.getDay();
    if (input != null) {
      input = parseWeekday(input, this.localeData());
      return this.add(input - day, "d");
    } else {
      return day;
    }
  }
  function getSetLocaleDayOfWeek(input) {
    if (!this.isValid()) {
      return input != null ? this : NaN;
    }
    var weekday = (this.day() + 7 - this.localeData()._week.dow) % 7;
    return input == null ? weekday : this.add(input - weekday, "d");
  }
  function getSetISODayOfWeek(input) {
    if (!this.isValid()) {
      return input != null ? this : NaN;
    }
    if (input != null) {
      var weekday = parseIsoWeekday(input, this.localeData());
      return this.day(this.day() % 7 ? weekday : weekday - 7);
    } else {
      return this.day() || 7;
    }
  }
  function weekdaysRegex(isStrict) {
    if (this._weekdaysParseExact) {
      if (!hasOwnProp(this, "_weekdaysRegex")) {
        computeWeekdaysParse.call(this);
      }
      if (isStrict) {
        return this._weekdaysStrictRegex;
      } else {
        return this._weekdaysRegex;
      }
    } else {
      if (!hasOwnProp(this, "_weekdaysRegex")) {
        this._weekdaysRegex = defaultWeekdaysRegex;
      }
      return this._weekdaysStrictRegex && isStrict ? this._weekdaysStrictRegex : this._weekdaysRegex;
    }
  }
  function weekdaysShortRegex(isStrict) {
    if (this._weekdaysParseExact) {
      if (!hasOwnProp(this, "_weekdaysRegex")) {
        computeWeekdaysParse.call(this);
      }
      if (isStrict) {
        return this._weekdaysShortStrictRegex;
      } else {
        return this._weekdaysShortRegex;
      }
    } else {
      if (!hasOwnProp(this, "_weekdaysShortRegex")) {
        this._weekdaysShortRegex = defaultWeekdaysShortRegex;
      }
      return this._weekdaysShortStrictRegex && isStrict ? this._weekdaysShortStrictRegex : this._weekdaysShortRegex;
    }
  }
  function weekdaysMinRegex(isStrict) {
    if (this._weekdaysParseExact) {
      if (!hasOwnProp(this, "_weekdaysRegex")) {
        computeWeekdaysParse.call(this);
      }
      if (isStrict) {
        return this._weekdaysMinStrictRegex;
      } else {
        return this._weekdaysMinRegex;
      }
    } else {
      if (!hasOwnProp(this, "_weekdaysMinRegex")) {
        this._weekdaysMinRegex = defaultWeekdaysMinRegex;
      }
      return this._weekdaysMinStrictRegex && isStrict ? this._weekdaysMinStrictRegex : this._weekdaysMinRegex;
    }
  }
  function computeWeekdaysParse() {
    function cmpLenRev(a2, b2) {
      return b2.length - a2.length;
    }
    var minPieces = [], shortPieces = [], longPieces = [], mixedPieces = [], i3, mom, minp, shortp, longp;
    for (i3 = 0; i3 < 7; i3++) {
      mom = createUTC([2e3, 1]).day(i3);
      minp = regexEscape2(this.weekdaysMin(mom, ""));
      shortp = regexEscape2(this.weekdaysShort(mom, ""));
      longp = regexEscape2(this.weekdays(mom, ""));
      minPieces.push(minp);
      shortPieces.push(shortp);
      longPieces.push(longp);
      mixedPieces.push(minp);
      mixedPieces.push(shortp);
      mixedPieces.push(longp);
    }
    minPieces.sort(cmpLenRev);
    shortPieces.sort(cmpLenRev);
    longPieces.sort(cmpLenRev);
    mixedPieces.sort(cmpLenRev);
    this._weekdaysRegex = new RegExp("^(" + mixedPieces.join("|") + ")", "i");
    this._weekdaysShortRegex = this._weekdaysRegex;
    this._weekdaysMinRegex = this._weekdaysRegex;
    this._weekdaysStrictRegex = new RegExp("^(" + longPieces.join("|") + ")", "i");
    this._weekdaysShortStrictRegex = new RegExp("^(" + shortPieces.join("|") + ")", "i");
    this._weekdaysMinStrictRegex = new RegExp("^(" + minPieces.join("|") + ")", "i");
  }
  function hFormat() {
    return this.hours() % 12 || 12;
  }
  function kFormat() {
    return this.hours() || 24;
  }
  addFormatToken("H", ["HH", 2], 0, "hour");
  addFormatToken("h", ["hh", 2], 0, hFormat);
  addFormatToken("k", ["kk", 2], 0, kFormat);
  addFormatToken("hmm", 0, 0, function() {
    return "" + hFormat.apply(this) + zeroFill(this.minutes(), 2);
  });
  addFormatToken("hmmss", 0, 0, function() {
    return "" + hFormat.apply(this) + zeroFill(this.minutes(), 2) + zeroFill(this.seconds(), 2);
  });
  addFormatToken("Hmm", 0, 0, function() {
    return "" + this.hours() + zeroFill(this.minutes(), 2);
  });
  addFormatToken("Hmmss", 0, 0, function() {
    return "" + this.hours() + zeroFill(this.minutes(), 2) + zeroFill(this.seconds(), 2);
  });
  function meridiem(token3, lowercase) {
    addFormatToken(token3, 0, 0, function() {
      return this.localeData().meridiem(this.hours(), this.minutes(), lowercase);
    });
  }
  meridiem("a", true);
  meridiem("A", false);
  addUnitAlias("hour", "h");
  addUnitPriority("hour", 13);
  function matchMeridiem(isStrict, locale2) {
    return locale2._meridiemParse;
  }
  addRegexToken("a", matchMeridiem);
  addRegexToken("A", matchMeridiem);
  addRegexToken("H", match1to2);
  addRegexToken("h", match1to2);
  addRegexToken("k", match1to2);
  addRegexToken("HH", match1to2, match2);
  addRegexToken("hh", match1to2, match2);
  addRegexToken("kk", match1to2, match2);
  addRegexToken("hmm", match3to4);
  addRegexToken("hmmss", match5to6);
  addRegexToken("Hmm", match3to4);
  addRegexToken("Hmmss", match5to6);
  addParseToken(["H", "HH"], HOUR);
  addParseToken(["k", "kk"], function(input, array2, config2) {
    var kInput = toInt(input);
    array2[HOUR] = kInput === 24 ? 0 : kInput;
  });
  addParseToken(["a", "A"], function(input, array2, config2) {
    config2._isPm = config2._locale.isPM(input);
    config2._meridiem = input;
  });
  addParseToken(["h", "hh"], function(input, array2, config2) {
    array2[HOUR] = toInt(input);
    getParsingFlags(config2).bigHour = true;
  });
  addParseToken("hmm", function(input, array2, config2) {
    var pos = input.length - 2;
    array2[HOUR] = toInt(input.substr(0, pos));
    array2[MINUTE] = toInt(input.substr(pos));
    getParsingFlags(config2).bigHour = true;
  });
  addParseToken("hmmss", function(input, array2, config2) {
    var pos1 = input.length - 4, pos2 = input.length - 2;
    array2[HOUR] = toInt(input.substr(0, pos1));
    array2[MINUTE] = toInt(input.substr(pos1, 2));
    array2[SECOND] = toInt(input.substr(pos2));
    getParsingFlags(config2).bigHour = true;
  });
  addParseToken("Hmm", function(input, array2, config2) {
    var pos = input.length - 2;
    array2[HOUR] = toInt(input.substr(0, pos));
    array2[MINUTE] = toInt(input.substr(pos));
  });
  addParseToken("Hmmss", function(input, array2, config2) {
    var pos1 = input.length - 4, pos2 = input.length - 2;
    array2[HOUR] = toInt(input.substr(0, pos1));
    array2[MINUTE] = toInt(input.substr(pos1, 2));
    array2[SECOND] = toInt(input.substr(pos2));
  });
  function localeIsPM(input) {
    return (input + "").toLowerCase().charAt(0) === "p";
  }
  var defaultLocaleMeridiemParse = /[ap]\.?m?\.?/i;
  var getSetHour = makeGetSet("Hours", true);
  function localeMeridiem(hours2, minutes2, isLower2) {
    if (hours2 > 11) {
      return isLower2 ? "pm" : "PM";
    } else {
      return isLower2 ? "am" : "AM";
    }
  }
  var baseConfig = {
    calendar: defaultCalendar,
    longDateFormat: defaultLongDateFormat,
    invalidDate: defaultInvalidDate,
    ordinal: defaultOrdinal,
    dayOfMonthOrdinalParse: defaultDayOfMonthOrdinalParse,
    relativeTime: defaultRelativeTime,
    months: defaultLocaleMonths,
    monthsShort: defaultLocaleMonthsShort,
    week: defaultLocaleWeek,
    weekdays: defaultLocaleWeekdays,
    weekdaysMin: defaultLocaleWeekdaysMin,
    weekdaysShort: defaultLocaleWeekdaysShort,
    meridiemParse: defaultLocaleMeridiemParse
  };
  var locales = {};
  var localeFamilies = {};
  var globalLocale;
  function commonPrefix(arr1, arr2) {
    var i3, minl = Math.min(arr1.length, arr2.length);
    for (i3 = 0; i3 < minl; i3 += 1) {
      if (arr1[i3] !== arr2[i3]) {
        return i3;
      }
    }
    return minl;
  }
  function normalizeLocale(key) {
    return key ? key.toLowerCase().replace("_", "-") : key;
  }
  function chooseLocale(names) {
    var i3 = 0, j, next, locale2, split2;
    while (i3 < names.length) {
      split2 = normalizeLocale(names[i3]).split("-");
      j = split2.length;
      next = normalizeLocale(names[i3 + 1]);
      next = next ? next.split("-") : null;
      while (j > 0) {
        locale2 = loadLocale(split2.slice(0, j).join("-"));
        if (locale2) {
          return locale2;
        }
        if (next && next.length >= j && commonPrefix(split2, next) >= j - 1) {
          break;
        }
        j--;
      }
      i3++;
    }
    return globalLocale;
  }
  function loadLocale(name) {
    var oldLocale = null, aliasedRequire;
    if (locales[name] === void 0 && typeof module2 !== "undefined" && module2 && module2.exports) {
      try {
        oldLocale = globalLocale._abbr;
        aliasedRequire = require;
        aliasedRequire("./locale/" + name);
        getSetGlobalLocale(oldLocale);
      } catch (e2) {
        locales[name] = null;
      }
    }
    return locales[name];
  }
  function getSetGlobalLocale(key, values2) {
    var data2;
    if (key) {
      if (isUndefined5(values2)) {
        data2 = getLocale(key);
      } else {
        data2 = defineLocale(key, values2);
      }
      if (data2) {
        globalLocale = data2;
      } else {
        if (typeof console !== "undefined" && console.warn) {
          console.warn("Locale " + key + " not found. Did you forget to load it?");
        }
      }
    }
    return globalLocale._abbr;
  }
  function defineLocale(name, config2) {
    if (config2 !== null) {
      var locale2, parentConfig = baseConfig;
      config2.abbr = name;
      if (locales[name] != null) {
        deprecateSimple("defineLocaleOverride", "use moment.updateLocale(localeName, config) to change an existing locale. moment.defineLocale(localeName, config) should only be used for creating a new locale See http://momentjs.com/guides/#/warnings/define-locale/ for more info.");
        parentConfig = locales[name]._config;
      } else if (config2.parentLocale != null) {
        if (locales[config2.parentLocale] != null) {
          parentConfig = locales[config2.parentLocale]._config;
        } else {
          locale2 = loadLocale(config2.parentLocale);
          if (locale2 != null) {
            parentConfig = locale2._config;
          } else {
            if (!localeFamilies[config2.parentLocale]) {
              localeFamilies[config2.parentLocale] = [];
            }
            localeFamilies[config2.parentLocale].push({
              name,
              config: config2
            });
            return null;
          }
        }
      }
      locales[name] = new Locale(mergeConfigs(parentConfig, config2));
      if (localeFamilies[name]) {
        localeFamilies[name].forEach(function(x2) {
          defineLocale(x2.name, x2.config);
        });
      }
      getSetGlobalLocale(name);
      return locales[name];
    } else {
      delete locales[name];
      return null;
    }
  }
  function updateLocale(name, config2) {
    if (config2 != null) {
      var locale2, tmpLocale, parentConfig = baseConfig;
      if (locales[name] != null && locales[name].parentLocale != null) {
        locales[name].set(mergeConfigs(locales[name]._config, config2));
      } else {
        tmpLocale = loadLocale(name);
        if (tmpLocale != null) {
          parentConfig = tmpLocale._config;
        }
        config2 = mergeConfigs(parentConfig, config2);
        if (tmpLocale == null) {
          config2.abbr = name;
        }
        locale2 = new Locale(config2);
        locale2.parentLocale = locales[name];
        locales[name] = locale2;
      }
      getSetGlobalLocale(name);
    } else {
      if (locales[name] != null) {
        if (locales[name].parentLocale != null) {
          locales[name] = locales[name].parentLocale;
          if (name === getSetGlobalLocale()) {
            getSetGlobalLocale(name);
          }
        } else if (locales[name] != null) {
          delete locales[name];
        }
      }
    }
    return locales[name];
  }
  function getLocale(key) {
    var locale2;
    if (key && key._locale && key._locale._abbr) {
      key = key._locale._abbr;
    }
    if (!key) {
      return globalLocale;
    }
    if (!isArray3(key)) {
      locale2 = loadLocale(key);
      if (locale2) {
        return locale2;
      }
      key = [key];
    }
    return chooseLocale(key);
  }
  function listLocales() {
    return keys2(locales);
  }
  function checkOverflow(m2) {
    var overflow, a2 = m2._a;
    if (a2 && getParsingFlags(m2).overflow === -2) {
      overflow = a2[MONTH] < 0 || a2[MONTH] > 11 ? MONTH : a2[DATE] < 1 || a2[DATE] > daysInMonth(a2[YEAR], a2[MONTH]) ? DATE : a2[HOUR] < 0 || a2[HOUR] > 24 || a2[HOUR] === 24 && (a2[MINUTE] !== 0 || a2[SECOND] !== 0 || a2[MILLISECOND] !== 0) ? HOUR : a2[MINUTE] < 0 || a2[MINUTE] > 59 ? MINUTE : a2[SECOND] < 0 || a2[SECOND] > 59 ? SECOND : a2[MILLISECOND] < 0 || a2[MILLISECOND] > 999 ? MILLISECOND : -1;
      if (getParsingFlags(m2)._overflowDayOfYear && (overflow < YEAR || overflow > DATE)) {
        overflow = DATE;
      }
      if (getParsingFlags(m2)._overflowWeeks && overflow === -1) {
        overflow = WEEK;
      }
      if (getParsingFlags(m2)._overflowWeekday && overflow === -1) {
        overflow = WEEKDAY;
      }
      getParsingFlags(m2).overflow = overflow;
    }
    return m2;
  }
  var extendedIsoRegex = /^\s*((?:[+-]\d{6}|\d{4})-(?:\d\d-\d\d|W\d\d-\d|W\d\d|\d\d\d|\d\d))(?:(T| )(\d\d(?::\d\d(?::\d\d(?:[.,]\d+)?)?)?)([+-]\d\d(?::?\d\d)?|\s*Z)?)?$/;
  var basicIsoRegex = /^\s*((?:[+-]\d{6}|\d{4})(?:\d\d\d\d|W\d\d\d|W\d\d|\d\d\d|\d\d|))(?:(T| )(\d\d(?:\d\d(?:\d\d(?:[.,]\d+)?)?)?)([+-]\d\d(?::?\d\d)?|\s*Z)?)?$/;
  var tzRegex = /Z|[+-]\d\d(?::?\d\d)?/;
  var isoDates = [
    ["YYYYYY-MM-DD", /[+-]\d{6}-\d\d-\d\d/],
    ["YYYY-MM-DD", /\d{4}-\d\d-\d\d/],
    ["GGGG-[W]WW-E", /\d{4}-W\d\d-\d/],
    ["GGGG-[W]WW", /\d{4}-W\d\d/, false],
    ["YYYY-DDD", /\d{4}-\d{3}/],
    ["YYYY-MM", /\d{4}-\d\d/, false],
    ["YYYYYYMMDD", /[+-]\d{10}/],
    ["YYYYMMDD", /\d{8}/],
    ["GGGG[W]WWE", /\d{4}W\d{3}/],
    ["GGGG[W]WW", /\d{4}W\d{2}/, false],
    ["YYYYDDD", /\d{7}/],
    ["YYYYMM", /\d{6}/, false],
    ["YYYY", /\d{4}/, false]
  ];
  var isoTimes = [
    ["HH:mm:ss.SSSS", /\d\d:\d\d:\d\d\.\d+/],
    ["HH:mm:ss,SSSS", /\d\d:\d\d:\d\d,\d+/],
    ["HH:mm:ss", /\d\d:\d\d:\d\d/],
    ["HH:mm", /\d\d:\d\d/],
    ["HHmmss.SSSS", /\d\d\d\d\d\d\.\d+/],
    ["HHmmss,SSSS", /\d\d\d\d\d\d,\d+/],
    ["HHmmss", /\d\d\d\d\d\d/],
    ["HHmm", /\d\d\d\d/],
    ["HH", /\d\d/]
  ];
  var aspNetJsonRegex = /^\/?Date\((-?\d+)/i;
  var rfc2822 = /^(?:(Mon|Tue|Wed|Thu|Fri|Sat|Sun),?\s)?(\d{1,2})\s(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec)\s(\d{2,4})\s(\d\d):(\d\d)(?::(\d\d))?\s(?:(UT|GMT|[ECMP][SD]T)|([Zz])|([+-]\d{4}))$/;
  var obsOffsets = {
    UT: 0,
    GMT: 0,
    EDT: -4 * 60,
    EST: -5 * 60,
    CDT: -5 * 60,
    CST: -6 * 60,
    MDT: -6 * 60,
    MST: -7 * 60,
    PDT: -7 * 60,
    PST: -8 * 60
  };
  function configFromISO(config2) {
    var i3, l2, string2 = config2._i, match5 = extendedIsoRegex.exec(string2) || basicIsoRegex.exec(string2), allowTime, dateFormat, timeFormat, tzFormat;
    if (match5) {
      getParsingFlags(config2).iso = true;
      for (i3 = 0, l2 = isoDates.length; i3 < l2; i3++) {
        if (isoDates[i3][1].exec(match5[1])) {
          dateFormat = isoDates[i3][0];
          allowTime = isoDates[i3][2] !== false;
          break;
        }
      }
      if (dateFormat == null) {
        config2._isValid = false;
        return;
      }
      if (match5[3]) {
        for (i3 = 0, l2 = isoTimes.length; i3 < l2; i3++) {
          if (isoTimes[i3][1].exec(match5[3])) {
            timeFormat = (match5[2] || " ") + isoTimes[i3][0];
            break;
          }
        }
        if (timeFormat == null) {
          config2._isValid = false;
          return;
        }
      }
      if (!allowTime && timeFormat != null) {
        config2._isValid = false;
        return;
      }
      if (match5[4]) {
        if (tzRegex.exec(match5[4])) {
          tzFormat = "Z";
        } else {
          config2._isValid = false;
          return;
        }
      }
      config2._f = dateFormat + (timeFormat || "") + (tzFormat || "");
      configFromStringAndFormat(config2);
    } else {
      config2._isValid = false;
    }
  }
  function extractFromRFC2822Strings(yearStr, monthStr, dayStr, hourStr, minuteStr, secondStr) {
    var result = [
      untruncateYear(yearStr),
      defaultLocaleMonthsShort.indexOf(monthStr),
      parseInt(dayStr, 10),
      parseInt(hourStr, 10),
      parseInt(minuteStr, 10)
    ];
    if (secondStr) {
      result.push(parseInt(secondStr, 10));
    }
    return result;
  }
  function untruncateYear(yearStr) {
    var year = parseInt(yearStr, 10);
    if (year <= 49) {
      return 2e3 + year;
    } else if (year <= 999) {
      return 1900 + year;
    }
    return year;
  }
  function preprocessRFC2822(s2) {
    return s2.replace(/\([^)]*\)|[\n\t]/g, " ").replace(/(\s\s+)/g, " ").replace(/^\s\s*/, "").replace(/\s\s*$/, "");
  }
  function checkWeekday(weekdayStr, parsedInput, config2) {
    if (weekdayStr) {
      var weekdayProvided = defaultLocaleWeekdaysShort.indexOf(weekdayStr), weekdayActual = new Date(parsedInput[0], parsedInput[1], parsedInput[2]).getDay();
      if (weekdayProvided !== weekdayActual) {
        getParsingFlags(config2).weekdayMismatch = true;
        config2._isValid = false;
        return false;
      }
    }
    return true;
  }
  function calculateOffset(obsOffset, militaryOffset, numOffset) {
    if (obsOffset) {
      return obsOffsets[obsOffset];
    } else if (militaryOffset) {
      return 0;
    } else {
      var hm = parseInt(numOffset, 10), m2 = hm % 100, h2 = (hm - m2) / 100;
      return h2 * 60 + m2;
    }
  }
  function configFromRFC2822(config2) {
    var match5 = rfc2822.exec(preprocessRFC2822(config2._i)), parsedArray;
    if (match5) {
      parsedArray = extractFromRFC2822Strings(match5[4], match5[3], match5[2], match5[5], match5[6], match5[7]);
      if (!checkWeekday(match5[1], parsedArray, config2)) {
        return;
      }
      config2._a = parsedArray;
      config2._tzm = calculateOffset(match5[8], match5[9], match5[10]);
      config2._d = createUTCDate.apply(null, config2._a);
      config2._d.setUTCMinutes(config2._d.getUTCMinutes() - config2._tzm);
      getParsingFlags(config2).rfc2822 = true;
    } else {
      config2._isValid = false;
    }
  }
  function configFromString(config2) {
    var matched = aspNetJsonRegex.exec(config2._i);
    if (matched !== null) {
      config2._d = new Date(+matched[1]);
      return;
    }
    configFromISO(config2);
    if (config2._isValid === false) {
      delete config2._isValid;
    } else {
      return;
    }
    configFromRFC2822(config2);
    if (config2._isValid === false) {
      delete config2._isValid;
    } else {
      return;
    }
    if (config2._strict) {
      config2._isValid = false;
    } else {
      hooks.createFromInputFallback(config2);
    }
  }
  hooks.createFromInputFallback = deprecate("value provided is not in a recognized RFC2822 or ISO format. moment construction falls back to js Date(), which is not reliable across all browsers and versions. Non RFC2822/ISO date formats are discouraged. Please refer to http://momentjs.com/guides/#/warnings/js-date/ for more info.", function(config2) {
    config2._d = new Date(config2._i + (config2._useUTC ? " UTC" : ""));
  });
  function defaults3(a2, b2, c3) {
    if (a2 != null) {
      return a2;
    }
    if (b2 != null) {
      return b2;
    }
    return c3;
  }
  function currentDateArray(config2) {
    var nowValue = new Date(hooks.now());
    if (config2._useUTC) {
      return [
        nowValue.getUTCFullYear(),
        nowValue.getUTCMonth(),
        nowValue.getUTCDate()
      ];
    }
    return [nowValue.getFullYear(), nowValue.getMonth(), nowValue.getDate()];
  }
  function configFromArray(config2) {
    var i3, date, input = [], currentDate, expectedWeekday, yearToUse;
    if (config2._d) {
      return;
    }
    currentDate = currentDateArray(config2);
    if (config2._w && config2._a[DATE] == null && config2._a[MONTH] == null) {
      dayOfYearFromWeekInfo(config2);
    }
    if (config2._dayOfYear != null) {
      yearToUse = defaults3(config2._a[YEAR], currentDate[YEAR]);
      if (config2._dayOfYear > daysInYear(yearToUse) || config2._dayOfYear === 0) {
        getParsingFlags(config2)._overflowDayOfYear = true;
      }
      date = createUTCDate(yearToUse, 0, config2._dayOfYear);
      config2._a[MONTH] = date.getUTCMonth();
      config2._a[DATE] = date.getUTCDate();
    }
    for (i3 = 0; i3 < 3 && config2._a[i3] == null; ++i3) {
      config2._a[i3] = input[i3] = currentDate[i3];
    }
    for (; i3 < 7; i3++) {
      config2._a[i3] = input[i3] = config2._a[i3] == null ? i3 === 2 ? 1 : 0 : config2._a[i3];
    }
    if (config2._a[HOUR] === 24 && config2._a[MINUTE] === 0 && config2._a[SECOND] === 0 && config2._a[MILLISECOND] === 0) {
      config2._nextDay = true;
      config2._a[HOUR] = 0;
    }
    config2._d = (config2._useUTC ? createUTCDate : createDate).apply(null, input);
    expectedWeekday = config2._useUTC ? config2._d.getUTCDay() : config2._d.getDay();
    if (config2._tzm != null) {
      config2._d.setUTCMinutes(config2._d.getUTCMinutes() - config2._tzm);
    }
    if (config2._nextDay) {
      config2._a[HOUR] = 24;
    }
    if (config2._w && typeof config2._w.d !== "undefined" && config2._w.d !== expectedWeekday) {
      getParsingFlags(config2).weekdayMismatch = true;
    }
  }
  function dayOfYearFromWeekInfo(config2) {
    var w2, weekYear, week, weekday, dow, doy, temp, weekdayOverflow, curWeek;
    w2 = config2._w;
    if (w2.GG != null || w2.W != null || w2.E != null) {
      dow = 1;
      doy = 4;
      weekYear = defaults3(w2.GG, config2._a[YEAR], weekOfYear(createLocal(), 1, 4).year);
      week = defaults3(w2.W, 1);
      weekday = defaults3(w2.E, 1);
      if (weekday < 1 || weekday > 7) {
        weekdayOverflow = true;
      }
    } else {
      dow = config2._locale._week.dow;
      doy = config2._locale._week.doy;
      curWeek = weekOfYear(createLocal(), dow, doy);
      weekYear = defaults3(w2.gg, config2._a[YEAR], curWeek.year);
      week = defaults3(w2.w, curWeek.week);
      if (w2.d != null) {
        weekday = w2.d;
        if (weekday < 0 || weekday > 6) {
          weekdayOverflow = true;
        }
      } else if (w2.e != null) {
        weekday = w2.e + dow;
        if (w2.e < 0 || w2.e > 6) {
          weekdayOverflow = true;
        }
      } else {
        weekday = dow;
      }
    }
    if (week < 1 || week > weeksInYear(weekYear, dow, doy)) {
      getParsingFlags(config2)._overflowWeeks = true;
    } else if (weekdayOverflow != null) {
      getParsingFlags(config2)._overflowWeekday = true;
    } else {
      temp = dayOfYearFromWeeks(weekYear, week, weekday, dow, doy);
      config2._a[YEAR] = temp.year;
      config2._dayOfYear = temp.dayOfYear;
    }
  }
  hooks.ISO_8601 = function() {
  };
  hooks.RFC_2822 = function() {
  };
  function configFromStringAndFormat(config2) {
    if (config2._f === hooks.ISO_8601) {
      configFromISO(config2);
      return;
    }
    if (config2._f === hooks.RFC_2822) {
      configFromRFC2822(config2);
      return;
    }
    config2._a = [];
    getParsingFlags(config2).empty = true;
    var string2 = "" + config2._i, i3, parsedInput, tokens2, token3, skipped, stringLength = string2.length, totalParsedInputLength = 0, era;
    tokens2 = expandFormat(config2._f, config2._locale).match(formattingTokens) || [];
    for (i3 = 0; i3 < tokens2.length; i3++) {
      token3 = tokens2[i3];
      parsedInput = (string2.match(getParseRegexForToken(token3, config2)) || [])[0];
      if (parsedInput) {
        skipped = string2.substr(0, string2.indexOf(parsedInput));
        if (skipped.length > 0) {
          getParsingFlags(config2).unusedInput.push(skipped);
        }
        string2 = string2.slice(string2.indexOf(parsedInput) + parsedInput.length);
        totalParsedInputLength += parsedInput.length;
      }
      if (formatTokenFunctions[token3]) {
        if (parsedInput) {
          getParsingFlags(config2).empty = false;
        } else {
          getParsingFlags(config2).unusedTokens.push(token3);
        }
        addTimeToArrayFromToken(token3, parsedInput, config2);
      } else if (config2._strict && !parsedInput) {
        getParsingFlags(config2).unusedTokens.push(token3);
      }
    }
    getParsingFlags(config2).charsLeftOver = stringLength - totalParsedInputLength;
    if (string2.length > 0) {
      getParsingFlags(config2).unusedInput.push(string2);
    }
    if (config2._a[HOUR] <= 12 && getParsingFlags(config2).bigHour === true && config2._a[HOUR] > 0) {
      getParsingFlags(config2).bigHour = void 0;
    }
    getParsingFlags(config2).parsedDateParts = config2._a.slice(0);
    getParsingFlags(config2).meridiem = config2._meridiem;
    config2._a[HOUR] = meridiemFixWrap(config2._locale, config2._a[HOUR], config2._meridiem);
    era = getParsingFlags(config2).era;
    if (era !== null) {
      config2._a[YEAR] = config2._locale.erasConvertYear(era, config2._a[YEAR]);
    }
    configFromArray(config2);
    checkOverflow(config2);
  }
  function meridiemFixWrap(locale2, hour, meridiem2) {
    var isPm;
    if (meridiem2 == null) {
      return hour;
    }
    if (locale2.meridiemHour != null) {
      return locale2.meridiemHour(hour, meridiem2);
    } else if (locale2.isPM != null) {
      isPm = locale2.isPM(meridiem2);
      if (isPm && hour < 12) {
        hour += 12;
      }
      if (!isPm && hour === 12) {
        hour = 0;
      }
      return hour;
    } else {
      return hour;
    }
  }
  function configFromStringAndArray(config2) {
    var tempConfig, bestMoment, scoreToBeat, i3, currentScore, validFormatFound, bestFormatIsValid = false;
    if (config2._f.length === 0) {
      getParsingFlags(config2).invalidFormat = true;
      config2._d = new Date(NaN);
      return;
    }
    for (i3 = 0; i3 < config2._f.length; i3++) {
      currentScore = 0;
      validFormatFound = false;
      tempConfig = copyConfig({}, config2);
      if (config2._useUTC != null) {
        tempConfig._useUTC = config2._useUTC;
      }
      tempConfig._f = config2._f[i3];
      configFromStringAndFormat(tempConfig);
      if (isValid(tempConfig)) {
        validFormatFound = true;
      }
      currentScore += getParsingFlags(tempConfig).charsLeftOver;
      currentScore += getParsingFlags(tempConfig).unusedTokens.length * 10;
      getParsingFlags(tempConfig).score = currentScore;
      if (!bestFormatIsValid) {
        if (scoreToBeat == null || currentScore < scoreToBeat || validFormatFound) {
          scoreToBeat = currentScore;
          bestMoment = tempConfig;
          if (validFormatFound) {
            bestFormatIsValid = true;
          }
        }
      } else {
        if (currentScore < scoreToBeat) {
          scoreToBeat = currentScore;
          bestMoment = tempConfig;
        }
      }
    }
    extend3(config2, bestMoment || tempConfig);
  }
  function configFromObject(config2) {
    if (config2._d) {
      return;
    }
    var i3 = normalizeObjectUnits(config2._i), dayOrDate = i3.day === void 0 ? i3.date : i3.day;
    config2._a = map2([i3.year, i3.month, dayOrDate, i3.hour, i3.minute, i3.second, i3.millisecond], function(obj) {
      return obj && parseInt(obj, 10);
    });
    configFromArray(config2);
  }
  function createFromConfig(config2) {
    var res = new Moment(checkOverflow(prepareConfig(config2)));
    if (res._nextDay) {
      res.add(1, "d");
      res._nextDay = void 0;
    }
    return res;
  }
  function prepareConfig(config2) {
    var input = config2._i, format3 = config2._f;
    config2._locale = config2._locale || getLocale(config2._l);
    if (input === null || format3 === void 0 && input === "") {
      return createInvalid({nullInput: true});
    }
    if (typeof input === "string") {
      config2._i = input = config2._locale.preparse(input);
    }
    if (isMoment(input)) {
      return new Moment(checkOverflow(input));
    } else if (isDate2(input)) {
      config2._d = input;
    } else if (isArray3(format3)) {
      configFromStringAndArray(config2);
    } else if (format3) {
      configFromStringAndFormat(config2);
    } else {
      configFromInput(config2);
    }
    if (!isValid(config2)) {
      config2._d = null;
    }
    return config2;
  }
  function configFromInput(config2) {
    var input = config2._i;
    if (isUndefined5(input)) {
      config2._d = new Date(hooks.now());
    } else if (isDate2(input)) {
      config2._d = new Date(input.valueOf());
    } else if (typeof input === "string") {
      configFromString(config2);
    } else if (isArray3(input)) {
      config2._a = map2(input.slice(0), function(obj) {
        return parseInt(obj, 10);
      });
      configFromArray(config2);
    } else if (isObject5(input)) {
      configFromObject(config2);
    } else if (isNumber3(input)) {
      config2._d = new Date(input);
    } else {
      hooks.createFromInputFallback(config2);
    }
  }
  function createLocalOrUTC(input, format3, locale2, strict, isUTC) {
    var c3 = {};
    if (format3 === true || format3 === false) {
      strict = format3;
      format3 = void 0;
    }
    if (locale2 === true || locale2 === false) {
      strict = locale2;
      locale2 = void 0;
    }
    if (isObject5(input) && isObjectEmpty(input) || isArray3(input) && input.length === 0) {
      input = void 0;
    }
    c3._isAMomentObject = true;
    c3._useUTC = c3._isUTC = isUTC;
    c3._l = locale2;
    c3._i = input;
    c3._f = format3;
    c3._strict = strict;
    return createFromConfig(c3);
  }
  function createLocal(input, format3, locale2, strict) {
    return createLocalOrUTC(input, format3, locale2, strict, false);
  }
  var prototypeMin = deprecate("moment().min is deprecated, use moment.max instead. http://momentjs.com/guides/#/warnings/min-max/", function() {
    var other = createLocal.apply(null, arguments);
    if (this.isValid() && other.isValid()) {
      return other < this ? this : other;
    } else {
      return createInvalid();
    }
  });
  var prototypeMax = deprecate("moment().max is deprecated, use moment.min instead. http://momentjs.com/guides/#/warnings/min-max/", function() {
    var other = createLocal.apply(null, arguments);
    if (this.isValid() && other.isValid()) {
      return other > this ? this : other;
    } else {
      return createInvalid();
    }
  });
  function pickBy2(fn, moments) {
    var res, i3;
    if (moments.length === 1 && isArray3(moments[0])) {
      moments = moments[0];
    }
    if (!moments.length) {
      return createLocal();
    }
    res = moments[0];
    for (i3 = 1; i3 < moments.length; ++i3) {
      if (!moments[i3].isValid() || moments[i3][fn](res)) {
        res = moments[i3];
      }
    }
    return res;
  }
  function min2() {
    var args = [].slice.call(arguments, 0);
    return pickBy2("isBefore", args);
  }
  function max2() {
    var args = [].slice.call(arguments, 0);
    return pickBy2("isAfter", args);
  }
  var now3 = function() {
    return Date.now ? Date.now() : +new Date();
  };
  var ordering = [
    "year",
    "quarter",
    "month",
    "week",
    "day",
    "hour",
    "minute",
    "second",
    "millisecond"
  ];
  function isDurationValid(m2) {
    var key, unitHasDecimal = false, i3;
    for (key in m2) {
      if (hasOwnProp(m2, key) && !(indexOf.call(ordering, key) !== -1 && (m2[key] == null || !isNaN(m2[key])))) {
        return false;
      }
    }
    for (i3 = 0; i3 < ordering.length; ++i3) {
      if (m2[ordering[i3]]) {
        if (unitHasDecimal) {
          return false;
        }
        if (parseFloat(m2[ordering[i3]]) !== toInt(m2[ordering[i3]])) {
          unitHasDecimal = true;
        }
      }
    }
    return true;
  }
  function isValid$1() {
    return this._isValid;
  }
  function createInvalid$1() {
    return createDuration(NaN);
  }
  function Duration(duration) {
    var normalizedInput = normalizeObjectUnits(duration), years2 = normalizedInput.year || 0, quarters = normalizedInput.quarter || 0, months2 = normalizedInput.month || 0, weeks2 = normalizedInput.week || normalizedInput.isoWeek || 0, days2 = normalizedInput.day || 0, hours2 = normalizedInput.hour || 0, minutes2 = normalizedInput.minute || 0, seconds2 = normalizedInput.second || 0, milliseconds2 = normalizedInput.millisecond || 0;
    this._isValid = isDurationValid(normalizedInput);
    this._milliseconds = +milliseconds2 + seconds2 * 1e3 + minutes2 * 6e4 + hours2 * 1e3 * 60 * 60;
    this._days = +days2 + weeks2 * 7;
    this._months = +months2 + quarters * 3 + years2 * 12;
    this._data = {};
    this._locale = getLocale();
    this._bubble();
  }
  function isDuration(obj) {
    return obj instanceof Duration;
  }
  function absRound(number) {
    if (number < 0) {
      return Math.round(-1 * number) * -1;
    } else {
      return Math.round(number);
    }
  }
  function compareArrays(array1, array2, dontConvert) {
    var len2 = Math.min(array1.length, array2.length), lengthDiff = Math.abs(array1.length - array2.length), diffs = 0, i3;
    for (i3 = 0; i3 < len2; i3++) {
      if (dontConvert && array1[i3] !== array2[i3] || !dontConvert && toInt(array1[i3]) !== toInt(array2[i3])) {
        diffs++;
      }
    }
    return diffs + lengthDiff;
  }
  function offset2(token3, separator) {
    addFormatToken(token3, 0, 0, function() {
      var offset3 = this.utcOffset(), sign2 = "+";
      if (offset3 < 0) {
        offset3 = -offset3;
        sign2 = "-";
      }
      return sign2 + zeroFill(~~(offset3 / 60), 2) + separator + zeroFill(~~offset3 % 60, 2);
    });
  }
  offset2("Z", ":");
  offset2("ZZ", "");
  addRegexToken("Z", matchShortOffset);
  addRegexToken("ZZ", matchShortOffset);
  addParseToken(["Z", "ZZ"], function(input, array2, config2) {
    config2._useUTC = true;
    config2._tzm = offsetFromString(matchShortOffset, input);
  });
  var chunkOffset = /([\+\-]|\d\d)/gi;
  function offsetFromString(matcher2, string2) {
    var matches2 = (string2 || "").match(matcher2), chunk, parts, minutes2;
    if (matches2 === null) {
      return null;
    }
    chunk = matches2[matches2.length - 1] || [];
    parts = (chunk + "").match(chunkOffset) || ["-", 0, 0];
    minutes2 = +(parts[1] * 60) + toInt(parts[2]);
    return minutes2 === 0 ? 0 : parts[0] === "+" ? minutes2 : -minutes2;
  }
  function cloneWithOffset(input, model) {
    var res, diff2;
    if (model._isUTC) {
      res = model.clone();
      diff2 = (isMoment(input) || isDate2(input) ? input.valueOf() : createLocal(input).valueOf()) - res.valueOf();
      res._d.setTime(res._d.valueOf() + diff2);
      hooks.updateOffset(res, false);
      return res;
    } else {
      return createLocal(input).local();
    }
  }
  function getDateOffset(m2) {
    return -Math.round(m2._d.getTimezoneOffset());
  }
  hooks.updateOffset = function() {
  };
  function getSetOffset(input, keepLocalTime, keepMinutes) {
    var offset3 = this._offset || 0, localAdjust;
    if (!this.isValid()) {
      return input != null ? this : NaN;
    }
    if (input != null) {
      if (typeof input === "string") {
        input = offsetFromString(matchShortOffset, input);
        if (input === null) {
          return this;
        }
      } else if (Math.abs(input) < 16 && !keepMinutes) {
        input = input * 60;
      }
      if (!this._isUTC && keepLocalTime) {
        localAdjust = getDateOffset(this);
      }
      this._offset = input;
      this._isUTC = true;
      if (localAdjust != null) {
        this.add(localAdjust, "m");
      }
      if (offset3 !== input) {
        if (!keepLocalTime || this._changeInProgress) {
          addSubtract(this, createDuration(input - offset3, "m"), 1, false);
        } else if (!this._changeInProgress) {
          this._changeInProgress = true;
          hooks.updateOffset(this, true);
          this._changeInProgress = null;
        }
      }
      return this;
    } else {
      return this._isUTC ? offset3 : getDateOffset(this);
    }
  }
  function getSetZone(input, keepLocalTime) {
    if (input != null) {
      if (typeof input !== "string") {
        input = -input;
      }
      this.utcOffset(input, keepLocalTime);
      return this;
    } else {
      return -this.utcOffset();
    }
  }
  function setOffsetToUTC(keepLocalTime) {
    return this.utcOffset(0, keepLocalTime);
  }
  function setOffsetToLocal(keepLocalTime) {
    if (this._isUTC) {
      this.utcOffset(0, keepLocalTime);
      this._isUTC = false;
      if (keepLocalTime) {
        this.subtract(getDateOffset(this), "m");
      }
    }
    return this;
  }
  function setOffsetToParsedOffset() {
    if (this._tzm != null) {
      this.utcOffset(this._tzm, false, true);
    } else if (typeof this._i === "string") {
      var tZone = offsetFromString(matchOffset, this._i);
      if (tZone != null) {
        this.utcOffset(tZone);
      } else {
        this.utcOffset(0, true);
      }
    }
    return this;
  }
  function hasAlignedHourOffset(input) {
    if (!this.isValid()) {
      return false;
    }
    input = input ? createLocal(input).utcOffset() : 0;
    return (this.utcOffset() - input) % 60 === 0;
  }
  function isDaylightSavingTime() {
    return this.utcOffset() > this.clone().month(0).utcOffset() || this.utcOffset() > this.clone().month(5).utcOffset();
  }
  function isDaylightSavingTimeShifted() {
    if (!isUndefined5(this._isDSTShifted)) {
      return this._isDSTShifted;
    }
    var c3 = {}, other;
    copyConfig(c3, this);
    c3 = prepareConfig(c3);
    if (c3._a) {
      other = c3._isUTC ? createUTC(c3._a) : createLocal(c3._a);
      this._isDSTShifted = this.isValid() && compareArrays(c3._a, other.toArray()) > 0;
    } else {
      this._isDSTShifted = false;
    }
    return this._isDSTShifted;
  }
  function isLocal() {
    return this.isValid() ? !this._isUTC : false;
  }
  function isUtcOffset() {
    return this.isValid() ? this._isUTC : false;
  }
  function isUtc() {
    return this.isValid() ? this._isUTC && this._offset === 0 : false;
  }
  var aspNetRegex = /^(-|\+)?(?:(\d*)[. ])?(\d+):(\d+)(?::(\d+)(\.\d*)?)?$/;
  var isoRegex = /^(-|\+)?P(?:([-+]?[0-9,.]*)Y)?(?:([-+]?[0-9,.]*)M)?(?:([-+]?[0-9,.]*)W)?(?:([-+]?[0-9,.]*)D)?(?:T(?:([-+]?[0-9,.]*)H)?(?:([-+]?[0-9,.]*)M)?(?:([-+]?[0-9,.]*)S)?)?$/;
  function createDuration(input, key) {
    var duration = input, match5 = null, sign2, ret, diffRes;
    if (isDuration(input)) {
      duration = {
        ms: input._milliseconds,
        d: input._days,
        M: input._months
      };
    } else if (isNumber3(input) || !isNaN(+input)) {
      duration = {};
      if (key) {
        duration[key] = +input;
      } else {
        duration.milliseconds = +input;
      }
    } else if (match5 = aspNetRegex.exec(input)) {
      sign2 = match5[1] === "-" ? -1 : 1;
      duration = {
        y: 0,
        d: toInt(match5[DATE]) * sign2,
        h: toInt(match5[HOUR]) * sign2,
        m: toInt(match5[MINUTE]) * sign2,
        s: toInt(match5[SECOND]) * sign2,
        ms: toInt(absRound(match5[MILLISECOND] * 1e3)) * sign2
      };
    } else if (match5 = isoRegex.exec(input)) {
      sign2 = match5[1] === "-" ? -1 : 1;
      duration = {
        y: parseIso(match5[2], sign2),
        M: parseIso(match5[3], sign2),
        w: parseIso(match5[4], sign2),
        d: parseIso(match5[5], sign2),
        h: parseIso(match5[6], sign2),
        m: parseIso(match5[7], sign2),
        s: parseIso(match5[8], sign2)
      };
    } else if (duration == null) {
      duration = {};
    } else if (typeof duration === "object" && ("from" in duration || "to" in duration)) {
      diffRes = momentsDifference(createLocal(duration.from), createLocal(duration.to));
      duration = {};
      duration.ms = diffRes.milliseconds;
      duration.M = diffRes.months;
    }
    ret = new Duration(duration);
    if (isDuration(input) && hasOwnProp(input, "_locale")) {
      ret._locale = input._locale;
    }
    if (isDuration(input) && hasOwnProp(input, "_isValid")) {
      ret._isValid = input._isValid;
    }
    return ret;
  }
  createDuration.fn = Duration.prototype;
  createDuration.invalid = createInvalid$1;
  function parseIso(inp, sign2) {
    var res = inp && parseFloat(inp.replace(",", "."));
    return (isNaN(res) ? 0 : res) * sign2;
  }
  function positiveMomentsDifference(base, other) {
    var res = {};
    res.months = other.month() - base.month() + (other.year() - base.year()) * 12;
    if (base.clone().add(res.months, "M").isAfter(other)) {
      --res.months;
    }
    res.milliseconds = +other - +base.clone().add(res.months, "M");
    return res;
  }
  function momentsDifference(base, other) {
    var res;
    if (!(base.isValid() && other.isValid())) {
      return {milliseconds: 0, months: 0};
    }
    other = cloneWithOffset(other, base);
    if (base.isBefore(other)) {
      res = positiveMomentsDifference(base, other);
    } else {
      res = positiveMomentsDifference(other, base);
      res.milliseconds = -res.milliseconds;
      res.months = -res.months;
    }
    return res;
  }
  function createAdder(direction, name) {
    return function(val, period) {
      var dur, tmp;
      if (period !== null && !isNaN(+period)) {
        deprecateSimple(name, "moment()." + name + "(period, number) is deprecated. Please use moment()." + name + "(number, period). See http://momentjs.com/guides/#/warnings/add-inverted-param/ for more info.");
        tmp = val;
        val = period;
        period = tmp;
      }
      dur = createDuration(val, period);
      addSubtract(this, dur, direction);
      return this;
    };
  }
  function addSubtract(mom, duration, isAdding, updateOffset) {
    var milliseconds2 = duration._milliseconds, days2 = absRound(duration._days), months2 = absRound(duration._months);
    if (!mom.isValid()) {
      return;
    }
    updateOffset = updateOffset == null ? true : updateOffset;
    if (months2) {
      setMonth(mom, get7(mom, "Month") + months2 * isAdding);
    }
    if (days2) {
      set$12(mom, "Date", get7(mom, "Date") + days2 * isAdding);
    }
    if (milliseconds2) {
      mom._d.setTime(mom._d.valueOf() + milliseconds2 * isAdding);
    }
    if (updateOffset) {
      hooks.updateOffset(mom, days2 || months2);
    }
  }
  var add = createAdder(1, "add");
  var subtract = createAdder(-1, "subtract");
  function isString5(input) {
    return typeof input === "string" || input instanceof String;
  }
  function isMomentInput(input) {
    return isMoment(input) || isDate2(input) || isString5(input) || isNumber3(input) || isNumberOrStringArray(input) || isMomentInputObject(input) || input === null || input === void 0;
  }
  function isMomentInputObject(input) {
    var objectTest = isObject5(input) && !isObjectEmpty(input), propertyTest = false, properties = [
      "years",
      "year",
      "y",
      "months",
      "month",
      "M",
      "days",
      "day",
      "d",
      "dates",
      "date",
      "D",
      "hours",
      "hour",
      "h",
      "minutes",
      "minute",
      "m",
      "seconds",
      "second",
      "s",
      "milliseconds",
      "millisecond",
      "ms"
    ], i3, property2;
    for (i3 = 0; i3 < properties.length; i3 += 1) {
      property2 = properties[i3];
      propertyTest = propertyTest || hasOwnProp(input, property2);
    }
    return objectTest && propertyTest;
  }
  function isNumberOrStringArray(input) {
    var arrayTest = isArray3(input), dataTypeTest = false;
    if (arrayTest) {
      dataTypeTest = input.filter(function(item) {
        return !isNumber3(item) && isString5(input);
      }).length === 0;
    }
    return arrayTest && dataTypeTest;
  }
  function isCalendarSpec(input) {
    var objectTest = isObject5(input) && !isObjectEmpty(input), propertyTest = false, properties = [
      "sameDay",
      "nextDay",
      "lastDay",
      "nextWeek",
      "lastWeek",
      "sameElse"
    ], i3, property2;
    for (i3 = 0; i3 < properties.length; i3 += 1) {
      property2 = properties[i3];
      propertyTest = propertyTest || hasOwnProp(input, property2);
    }
    return objectTest && propertyTest;
  }
  function getCalendarFormat(myMoment, now4) {
    var diff2 = myMoment.diff(now4, "days", true);
    return diff2 < -6 ? "sameElse" : diff2 < -1 ? "lastWeek" : diff2 < 0 ? "lastDay" : diff2 < 1 ? "sameDay" : diff2 < 2 ? "nextDay" : diff2 < 7 ? "nextWeek" : "sameElse";
  }
  function calendar$1(time2, formats2) {
    if (arguments.length === 1) {
      if (!arguments[0]) {
        time2 = void 0;
        formats2 = void 0;
      } else if (isMomentInput(arguments[0])) {
        time2 = arguments[0];
        formats2 = void 0;
      } else if (isCalendarSpec(arguments[0])) {
        formats2 = arguments[0];
        time2 = void 0;
      }
    }
    var now4 = time2 || createLocal(), sod = cloneWithOffset(now4, this).startOf("day"), format3 = hooks.calendarFormat(this, sod) || "sameElse", output2 = formats2 && (isFunction6(formats2[format3]) ? formats2[format3].call(this, now4) : formats2[format3]);
    return this.format(output2 || this.localeData().calendar(format3, this, createLocal(now4)));
  }
  function clone2() {
    return new Moment(this);
  }
  function isAfter(input, units) {
    var localInput = isMoment(input) ? input : createLocal(input);
    if (!(this.isValid() && localInput.isValid())) {
      return false;
    }
    units = normalizeUnits(units) || "millisecond";
    if (units === "millisecond") {
      return this.valueOf() > localInput.valueOf();
    } else {
      return localInput.valueOf() < this.clone().startOf(units).valueOf();
    }
  }
  function isBefore(input, units) {
    var localInput = isMoment(input) ? input : createLocal(input);
    if (!(this.isValid() && localInput.isValid())) {
      return false;
    }
    units = normalizeUnits(units) || "millisecond";
    if (units === "millisecond") {
      return this.valueOf() < localInput.valueOf();
    } else {
      return this.clone().endOf(units).valueOf() < localInput.valueOf();
    }
  }
  function isBetween(from2, to2, units, inclusivity) {
    var localFrom = isMoment(from2) ? from2 : createLocal(from2), localTo = isMoment(to2) ? to2 : createLocal(to2);
    if (!(this.isValid() && localFrom.isValid() && localTo.isValid())) {
      return false;
    }
    inclusivity = inclusivity || "()";
    return (inclusivity[0] === "(" ? this.isAfter(localFrom, units) : !this.isBefore(localFrom, units)) && (inclusivity[1] === ")" ? this.isBefore(localTo, units) : !this.isAfter(localTo, units));
  }
  function isSame(input, units) {
    var localInput = isMoment(input) ? input : createLocal(input), inputMs;
    if (!(this.isValid() && localInput.isValid())) {
      return false;
    }
    units = normalizeUnits(units) || "millisecond";
    if (units === "millisecond") {
      return this.valueOf() === localInput.valueOf();
    } else {
      inputMs = localInput.valueOf();
      return this.clone().startOf(units).valueOf() <= inputMs && inputMs <= this.clone().endOf(units).valueOf();
    }
  }
  function isSameOrAfter(input, units) {
    return this.isSame(input, units) || this.isAfter(input, units);
  }
  function isSameOrBefore(input, units) {
    return this.isSame(input, units) || this.isBefore(input, units);
  }
  function diff(input, units, asFloat) {
    var that, zoneDelta, output2;
    if (!this.isValid()) {
      return NaN;
    }
    that = cloneWithOffset(input, this);
    if (!that.isValid()) {
      return NaN;
    }
    zoneDelta = (that.utcOffset() - this.utcOffset()) * 6e4;
    units = normalizeUnits(units);
    switch (units) {
      case "year":
        output2 = monthDiff(this, that) / 12;
        break;
      case "month":
        output2 = monthDiff(this, that);
        break;
      case "quarter":
        output2 = monthDiff(this, that) / 3;
        break;
      case "second":
        output2 = (this - that) / 1e3;
        break;
      case "minute":
        output2 = (this - that) / 6e4;
        break;
      case "hour":
        output2 = (this - that) / 36e5;
        break;
      case "day":
        output2 = (this - that - zoneDelta) / 864e5;
        break;
      case "week":
        output2 = (this - that - zoneDelta) / 6048e5;
        break;
      default:
        output2 = this - that;
    }
    return asFloat ? output2 : absFloor(output2);
  }
  function monthDiff(a2, b2) {
    if (a2.date() < b2.date()) {
      return -monthDiff(b2, a2);
    }
    var wholeMonthDiff = (b2.year() - a2.year()) * 12 + (b2.month() - a2.month()), anchor = a2.clone().add(wholeMonthDiff, "months"), anchor2, adjust2;
    if (b2 - anchor < 0) {
      anchor2 = a2.clone().add(wholeMonthDiff - 1, "months");
      adjust2 = (b2 - anchor) / (anchor - anchor2);
    } else {
      anchor2 = a2.clone().add(wholeMonthDiff + 1, "months");
      adjust2 = (b2 - anchor) / (anchor2 - anchor);
    }
    return -(wholeMonthDiff + adjust2) || 0;
  }
  hooks.defaultFormat = "YYYY-MM-DDTHH:mm:ssZ";
  hooks.defaultFormatUtc = "YYYY-MM-DDTHH:mm:ss[Z]";
  function toString5() {
    return this.clone().locale("en").format("ddd MMM DD YYYY HH:mm:ss [GMT]ZZ");
  }
  function toISOString(keepOffset) {
    if (!this.isValid()) {
      return null;
    }
    var utc = keepOffset !== true, m2 = utc ? this.clone().utc() : this;
    if (m2.year() < 0 || m2.year() > 9999) {
      return formatMoment(m2, utc ? "YYYYYY-MM-DD[T]HH:mm:ss.SSS[Z]" : "YYYYYY-MM-DD[T]HH:mm:ss.SSSZ");
    }
    if (isFunction6(Date.prototype.toISOString)) {
      if (utc) {
        return this.toDate().toISOString();
      } else {
        return new Date(this.valueOf() + this.utcOffset() * 60 * 1e3).toISOString().replace("Z", formatMoment(m2, "Z"));
      }
    }
    return formatMoment(m2, utc ? "YYYY-MM-DD[T]HH:mm:ss.SSS[Z]" : "YYYY-MM-DD[T]HH:mm:ss.SSSZ");
  }
  function inspect() {
    if (!this.isValid()) {
      return "moment.invalid(/* " + this._i + " */)";
    }
    var func = "moment", zone = "", prefix2, year, datetime, suffix;
    if (!this.isLocal()) {
      func = this.utcOffset() === 0 ? "moment.utc" : "moment.parseZone";
      zone = "Z";
    }
    prefix2 = "[" + func + '("]';
    year = 0 <= this.year() && this.year() <= 9999 ? "YYYY" : "YYYYYY";
    datetime = "-MM-DD[T]HH:mm:ss.SSS";
    suffix = zone + '[")]';
    return this.format(prefix2 + year + datetime + suffix);
  }
  function format2(inputString) {
    if (!inputString) {
      inputString = this.isUtc() ? hooks.defaultFormatUtc : hooks.defaultFormat;
    }
    var output2 = formatMoment(this, inputString);
    return this.localeData().postformat(output2);
  }
  function from(time2, withoutSuffix) {
    if (this.isValid() && (isMoment(time2) && time2.isValid() || createLocal(time2).isValid())) {
      return createDuration({to: this, from: time2}).locale(this.locale()).humanize(!withoutSuffix);
    } else {
      return this.localeData().invalidDate();
    }
  }
  function fromNow(withoutSuffix) {
    return this.from(createLocal(), withoutSuffix);
  }
  function to(time2, withoutSuffix) {
    if (this.isValid() && (isMoment(time2) && time2.isValid() || createLocal(time2).isValid())) {
      return createDuration({from: this, to: time2}).locale(this.locale()).humanize(!withoutSuffix);
    } else {
      return this.localeData().invalidDate();
    }
  }
  function toNow(withoutSuffix) {
    return this.to(createLocal(), withoutSuffix);
  }
  function locale(key) {
    var newLocaleData;
    if (key === void 0) {
      return this._locale._abbr;
    } else {
      newLocaleData = getLocale(key);
      if (newLocaleData != null) {
        this._locale = newLocaleData;
      }
      return this;
    }
  }
  var lang = deprecate("moment().lang() is deprecated. Instead, use moment().localeData() to get the language configuration. Use moment().locale() to change languages.", function(key) {
    if (key === void 0) {
      return this.localeData();
    } else {
      return this.locale(key);
    }
  });
  function localeData() {
    return this._locale;
  }
  var MS_PER_SECOND = 1e3;
  var MS_PER_MINUTE = 60 * MS_PER_SECOND;
  var MS_PER_HOUR = 60 * MS_PER_MINUTE;
  var MS_PER_400_YEARS = (365 * 400 + 97) * 24 * MS_PER_HOUR;
  function mod$1(dividend, divisor) {
    return (dividend % divisor + divisor) % divisor;
  }
  function localStartOfDate(y3, m2, d2) {
    if (y3 < 100 && y3 >= 0) {
      return new Date(y3 + 400, m2, d2) - MS_PER_400_YEARS;
    } else {
      return new Date(y3, m2, d2).valueOf();
    }
  }
  function utcStartOfDate(y3, m2, d2) {
    if (y3 < 100 && y3 >= 0) {
      return Date.UTC(y3 + 400, m2, d2) - MS_PER_400_YEARS;
    } else {
      return Date.UTC(y3, m2, d2);
    }
  }
  function startOf(units) {
    var time2, startOfDate;
    units = normalizeUnits(units);
    if (units === void 0 || units === "millisecond" || !this.isValid()) {
      return this;
    }
    startOfDate = this._isUTC ? utcStartOfDate : localStartOfDate;
    switch (units) {
      case "year":
        time2 = startOfDate(this.year(), 0, 1);
        break;
      case "quarter":
        time2 = startOfDate(this.year(), this.month() - this.month() % 3, 1);
        break;
      case "month":
        time2 = startOfDate(this.year(), this.month(), 1);
        break;
      case "week":
        time2 = startOfDate(this.year(), this.month(), this.date() - this.weekday());
        break;
      case "isoWeek":
        time2 = startOfDate(this.year(), this.month(), this.date() - (this.isoWeekday() - 1));
        break;
      case "day":
      case "date":
        time2 = startOfDate(this.year(), this.month(), this.date());
        break;
      case "hour":
        time2 = this._d.valueOf();
        time2 -= mod$1(time2 + (this._isUTC ? 0 : this.utcOffset() * MS_PER_MINUTE), MS_PER_HOUR);
        break;
      case "minute":
        time2 = this._d.valueOf();
        time2 -= mod$1(time2, MS_PER_MINUTE);
        break;
      case "second":
        time2 = this._d.valueOf();
        time2 -= mod$1(time2, MS_PER_SECOND);
        break;
    }
    this._d.setTime(time2);
    hooks.updateOffset(this, true);
    return this;
  }
  function endOf(units) {
    var time2, startOfDate;
    units = normalizeUnits(units);
    if (units === void 0 || units === "millisecond" || !this.isValid()) {
      return this;
    }
    startOfDate = this._isUTC ? utcStartOfDate : localStartOfDate;
    switch (units) {
      case "year":
        time2 = startOfDate(this.year() + 1, 0, 1) - 1;
        break;
      case "quarter":
        time2 = startOfDate(this.year(), this.month() - this.month() % 3 + 3, 1) - 1;
        break;
      case "month":
        time2 = startOfDate(this.year(), this.month() + 1, 1) - 1;
        break;
      case "week":
        time2 = startOfDate(this.year(), this.month(), this.date() - this.weekday() + 7) - 1;
        break;
      case "isoWeek":
        time2 = startOfDate(this.year(), this.month(), this.date() - (this.isoWeekday() - 1) + 7) - 1;
        break;
      case "day":
      case "date":
        time2 = startOfDate(this.year(), this.month(), this.date() + 1) - 1;
        break;
      case "hour":
        time2 = this._d.valueOf();
        time2 += MS_PER_HOUR - mod$1(time2 + (this._isUTC ? 0 : this.utcOffset() * MS_PER_MINUTE), MS_PER_HOUR) - 1;
        break;
      case "minute":
        time2 = this._d.valueOf();
        time2 += MS_PER_MINUTE - mod$1(time2, MS_PER_MINUTE) - 1;
        break;
      case "second":
        time2 = this._d.valueOf();
        time2 += MS_PER_SECOND - mod$1(time2, MS_PER_SECOND) - 1;
        break;
    }
    this._d.setTime(time2);
    hooks.updateOffset(this, true);
    return this;
  }
  function valueOf() {
    return this._d.valueOf() - (this._offset || 0) * 6e4;
  }
  function unix() {
    return Math.floor(this.valueOf() / 1e3);
  }
  function toDate() {
    return new Date(this.valueOf());
  }
  function toArray() {
    var m2 = this;
    return [
      m2.year(),
      m2.month(),
      m2.date(),
      m2.hour(),
      m2.minute(),
      m2.second(),
      m2.millisecond()
    ];
  }
  function toObject3() {
    var m2 = this;
    return {
      years: m2.year(),
      months: m2.month(),
      date: m2.date(),
      hours: m2.hours(),
      minutes: m2.minutes(),
      seconds: m2.seconds(),
      milliseconds: m2.milliseconds()
    };
  }
  function toJSON() {
    return this.isValid() ? this.toISOString() : null;
  }
  function isValid$2() {
    return isValid(this);
  }
  function parsingFlags() {
    return extend3({}, getParsingFlags(this));
  }
  function invalidAt() {
    return getParsingFlags(this).overflow;
  }
  function creationData() {
    return {
      input: this._i,
      format: this._f,
      locale: this._locale,
      isUTC: this._isUTC,
      strict: this._strict
    };
  }
  addFormatToken("N", 0, 0, "eraAbbr");
  addFormatToken("NN", 0, 0, "eraAbbr");
  addFormatToken("NNN", 0, 0, "eraAbbr");
  addFormatToken("NNNN", 0, 0, "eraName");
  addFormatToken("NNNNN", 0, 0, "eraNarrow");
  addFormatToken("y", ["y", 1], "yo", "eraYear");
  addFormatToken("y", ["yy", 2], 0, "eraYear");
  addFormatToken("y", ["yyy", 3], 0, "eraYear");
  addFormatToken("y", ["yyyy", 4], 0, "eraYear");
  addRegexToken("N", matchEraAbbr);
  addRegexToken("NN", matchEraAbbr);
  addRegexToken("NNN", matchEraAbbr);
  addRegexToken("NNNN", matchEraName);
  addRegexToken("NNNNN", matchEraNarrow);
  addParseToken(["N", "NN", "NNN", "NNNN", "NNNNN"], function(input, array2, config2, token3) {
    var era = config2._locale.erasParse(input, token3, config2._strict);
    if (era) {
      getParsingFlags(config2).era = era;
    } else {
      getParsingFlags(config2).invalidEra = input;
    }
  });
  addRegexToken("y", matchUnsigned);
  addRegexToken("yy", matchUnsigned);
  addRegexToken("yyy", matchUnsigned);
  addRegexToken("yyyy", matchUnsigned);
  addRegexToken("yo", matchEraYearOrdinal);
  addParseToken(["y", "yy", "yyy", "yyyy"], YEAR);
  addParseToken(["yo"], function(input, array2, config2, token3) {
    var match5;
    if (config2._locale._eraYearOrdinalRegex) {
      match5 = input.match(config2._locale._eraYearOrdinalRegex);
    }
    if (config2._locale.eraYearOrdinalParse) {
      array2[YEAR] = config2._locale.eraYearOrdinalParse(input, match5);
    } else {
      array2[YEAR] = parseInt(input, 10);
    }
  });
  function localeEras(m2, format3) {
    var i3, l2, date, eras = this._eras || getLocale("en")._eras;
    for (i3 = 0, l2 = eras.length; i3 < l2; ++i3) {
      switch (typeof eras[i3].since) {
        case "string":
          date = hooks(eras[i3].since).startOf("day");
          eras[i3].since = date.valueOf();
          break;
      }
      switch (typeof eras[i3].until) {
        case "undefined":
          eras[i3].until = Infinity;
          break;
        case "string":
          date = hooks(eras[i3].until).startOf("day").valueOf();
          eras[i3].until = date.valueOf();
          break;
      }
    }
    return eras;
  }
  function localeErasParse(eraName, format3, strict) {
    var i3, l2, eras = this.eras(), name, abbr, narrow;
    eraName = eraName.toUpperCase();
    for (i3 = 0, l2 = eras.length; i3 < l2; ++i3) {
      name = eras[i3].name.toUpperCase();
      abbr = eras[i3].abbr.toUpperCase();
      narrow = eras[i3].narrow.toUpperCase();
      if (strict) {
        switch (format3) {
          case "N":
          case "NN":
          case "NNN":
            if (abbr === eraName) {
              return eras[i3];
            }
            break;
          case "NNNN":
            if (name === eraName) {
              return eras[i3];
            }
            break;
          case "NNNNN":
            if (narrow === eraName) {
              return eras[i3];
            }
            break;
        }
      } else if ([name, abbr, narrow].indexOf(eraName) >= 0) {
        return eras[i3];
      }
    }
  }
  function localeErasConvertYear(era, year) {
    var dir = era.since <= era.until ? 1 : -1;
    if (year === void 0) {
      return hooks(era.since).year();
    } else {
      return hooks(era.since).year() + (year - era.offset) * dir;
    }
  }
  function getEraName() {
    var i3, l2, val, eras = this.localeData().eras();
    for (i3 = 0, l2 = eras.length; i3 < l2; ++i3) {
      val = this.clone().startOf("day").valueOf();
      if (eras[i3].since <= val && val <= eras[i3].until) {
        return eras[i3].name;
      }
      if (eras[i3].until <= val && val <= eras[i3].since) {
        return eras[i3].name;
      }
    }
    return "";
  }
  function getEraNarrow() {
    var i3, l2, val, eras = this.localeData().eras();
    for (i3 = 0, l2 = eras.length; i3 < l2; ++i3) {
      val = this.clone().startOf("day").valueOf();
      if (eras[i3].since <= val && val <= eras[i3].until) {
        return eras[i3].narrow;
      }
      if (eras[i3].until <= val && val <= eras[i3].since) {
        return eras[i3].narrow;
      }
    }
    return "";
  }
  function getEraAbbr() {
    var i3, l2, val, eras = this.localeData().eras();
    for (i3 = 0, l2 = eras.length; i3 < l2; ++i3) {
      val = this.clone().startOf("day").valueOf();
      if (eras[i3].since <= val && val <= eras[i3].until) {
        return eras[i3].abbr;
      }
      if (eras[i3].until <= val && val <= eras[i3].since) {
        return eras[i3].abbr;
      }
    }
    return "";
  }
  function getEraYear() {
    var i3, l2, dir, val, eras = this.localeData().eras();
    for (i3 = 0, l2 = eras.length; i3 < l2; ++i3) {
      dir = eras[i3].since <= eras[i3].until ? 1 : -1;
      val = this.clone().startOf("day").valueOf();
      if (eras[i3].since <= val && val <= eras[i3].until || eras[i3].until <= val && val <= eras[i3].since) {
        return (this.year() - hooks(eras[i3].since).year()) * dir + eras[i3].offset;
      }
    }
    return this.year();
  }
  function erasNameRegex(isStrict) {
    if (!hasOwnProp(this, "_erasNameRegex")) {
      computeErasParse.call(this);
    }
    return isStrict ? this._erasNameRegex : this._erasRegex;
  }
  function erasAbbrRegex(isStrict) {
    if (!hasOwnProp(this, "_erasAbbrRegex")) {
      computeErasParse.call(this);
    }
    return isStrict ? this._erasAbbrRegex : this._erasRegex;
  }
  function erasNarrowRegex(isStrict) {
    if (!hasOwnProp(this, "_erasNarrowRegex")) {
      computeErasParse.call(this);
    }
    return isStrict ? this._erasNarrowRegex : this._erasRegex;
  }
  function matchEraAbbr(isStrict, locale2) {
    return locale2.erasAbbrRegex(isStrict);
  }
  function matchEraName(isStrict, locale2) {
    return locale2.erasNameRegex(isStrict);
  }
  function matchEraNarrow(isStrict, locale2) {
    return locale2.erasNarrowRegex(isStrict);
  }
  function matchEraYearOrdinal(isStrict, locale2) {
    return locale2._eraYearOrdinalRegex || matchUnsigned;
  }
  function computeErasParse() {
    var abbrPieces = [], namePieces = [], narrowPieces = [], mixedPieces = [], i3, l2, eras = this.eras();
    for (i3 = 0, l2 = eras.length; i3 < l2; ++i3) {
      namePieces.push(regexEscape2(eras[i3].name));
      abbrPieces.push(regexEscape2(eras[i3].abbr));
      narrowPieces.push(regexEscape2(eras[i3].narrow));
      mixedPieces.push(regexEscape2(eras[i3].name));
      mixedPieces.push(regexEscape2(eras[i3].abbr));
      mixedPieces.push(regexEscape2(eras[i3].narrow));
    }
    this._erasRegex = new RegExp("^(" + mixedPieces.join("|") + ")", "i");
    this._erasNameRegex = new RegExp("^(" + namePieces.join("|") + ")", "i");
    this._erasAbbrRegex = new RegExp("^(" + abbrPieces.join("|") + ")", "i");
    this._erasNarrowRegex = new RegExp("^(" + narrowPieces.join("|") + ")", "i");
  }
  addFormatToken(0, ["gg", 2], 0, function() {
    return this.weekYear() % 100;
  });
  addFormatToken(0, ["GG", 2], 0, function() {
    return this.isoWeekYear() % 100;
  });
  function addWeekYearFormatToken(token3, getter) {
    addFormatToken(0, [token3, token3.length], 0, getter);
  }
  addWeekYearFormatToken("gggg", "weekYear");
  addWeekYearFormatToken("ggggg", "weekYear");
  addWeekYearFormatToken("GGGG", "isoWeekYear");
  addWeekYearFormatToken("GGGGG", "isoWeekYear");
  addUnitAlias("weekYear", "gg");
  addUnitAlias("isoWeekYear", "GG");
  addUnitPriority("weekYear", 1);
  addUnitPriority("isoWeekYear", 1);
  addRegexToken("G", matchSigned);
  addRegexToken("g", matchSigned);
  addRegexToken("GG", match1to2, match2);
  addRegexToken("gg", match1to2, match2);
  addRegexToken("GGGG", match1to4, match4);
  addRegexToken("gggg", match1to4, match4);
  addRegexToken("GGGGG", match1to6, match6);
  addRegexToken("ggggg", match1to6, match6);
  addWeekParseToken(["gggg", "ggggg", "GGGG", "GGGGG"], function(input, week, config2, token3) {
    week[token3.substr(0, 2)] = toInt(input);
  });
  addWeekParseToken(["gg", "GG"], function(input, week, config2, token3) {
    week[token3] = hooks.parseTwoDigitYear(input);
  });
  function getSetWeekYear(input) {
    return getSetWeekYearHelper.call(this, input, this.week(), this.weekday(), this.localeData()._week.dow, this.localeData()._week.doy);
  }
  function getSetISOWeekYear(input) {
    return getSetWeekYearHelper.call(this, input, this.isoWeek(), this.isoWeekday(), 1, 4);
  }
  function getISOWeeksInYear() {
    return weeksInYear(this.year(), 1, 4);
  }
  function getISOWeeksInISOWeekYear() {
    return weeksInYear(this.isoWeekYear(), 1, 4);
  }
  function getWeeksInYear() {
    var weekInfo = this.localeData()._week;
    return weeksInYear(this.year(), weekInfo.dow, weekInfo.doy);
  }
  function getWeeksInWeekYear() {
    var weekInfo = this.localeData()._week;
    return weeksInYear(this.weekYear(), weekInfo.dow, weekInfo.doy);
  }
  function getSetWeekYearHelper(input, week, weekday, dow, doy) {
    var weeksTarget;
    if (input == null) {
      return weekOfYear(this, dow, doy).year;
    } else {
      weeksTarget = weeksInYear(input, dow, doy);
      if (week > weeksTarget) {
        week = weeksTarget;
      }
      return setWeekAll.call(this, input, week, weekday, dow, doy);
    }
  }
  function setWeekAll(weekYear, week, weekday, dow, doy) {
    var dayOfYearData = dayOfYearFromWeeks(weekYear, week, weekday, dow, doy), date = createUTCDate(dayOfYearData.year, 0, dayOfYearData.dayOfYear);
    this.year(date.getUTCFullYear());
    this.month(date.getUTCMonth());
    this.date(date.getUTCDate());
    return this;
  }
  addFormatToken("Q", 0, "Qo", "quarter");
  addUnitAlias("quarter", "Q");
  addUnitPriority("quarter", 7);
  addRegexToken("Q", match1);
  addParseToken("Q", function(input, array2) {
    array2[MONTH] = (toInt(input) - 1) * 3;
  });
  function getSetQuarter(input) {
    return input == null ? Math.ceil((this.month() + 1) / 3) : this.month((input - 1) * 3 + this.month() % 3);
  }
  addFormatToken("D", ["DD", 2], "Do", "date");
  addUnitAlias("date", "D");
  addUnitPriority("date", 9);
  addRegexToken("D", match1to2);
  addRegexToken("DD", match1to2, match2);
  addRegexToken("Do", function(isStrict, locale2) {
    return isStrict ? locale2._dayOfMonthOrdinalParse || locale2._ordinalParse : locale2._dayOfMonthOrdinalParseLenient;
  });
  addParseToken(["D", "DD"], DATE);
  addParseToken("Do", function(input, array2) {
    array2[DATE] = toInt(input.match(match1to2)[0]);
  });
  var getSetDayOfMonth = makeGetSet("Date", true);
  addFormatToken("DDD", ["DDDD", 3], "DDDo", "dayOfYear");
  addUnitAlias("dayOfYear", "DDD");
  addUnitPriority("dayOfYear", 4);
  addRegexToken("DDD", match1to3);
  addRegexToken("DDDD", match3);
  addParseToken(["DDD", "DDDD"], function(input, array2, config2) {
    config2._dayOfYear = toInt(input);
  });
  function getSetDayOfYear(input) {
    var dayOfYear = Math.round((this.clone().startOf("day") - this.clone().startOf("year")) / 864e5) + 1;
    return input == null ? dayOfYear : this.add(input - dayOfYear, "d");
  }
  addFormatToken("m", ["mm", 2], 0, "minute");
  addUnitAlias("minute", "m");
  addUnitPriority("minute", 14);
  addRegexToken("m", match1to2);
  addRegexToken("mm", match1to2, match2);
  addParseToken(["m", "mm"], MINUTE);
  var getSetMinute = makeGetSet("Minutes", false);
  addFormatToken("s", ["ss", 2], 0, "second");
  addUnitAlias("second", "s");
  addUnitPriority("second", 15);
  addRegexToken("s", match1to2);
  addRegexToken("ss", match1to2, match2);
  addParseToken(["s", "ss"], SECOND);
  var getSetSecond = makeGetSet("Seconds", false);
  addFormatToken("S", 0, 0, function() {
    return ~~(this.millisecond() / 100);
  });
  addFormatToken(0, ["SS", 2], 0, function() {
    return ~~(this.millisecond() / 10);
  });
  addFormatToken(0, ["SSS", 3], 0, "millisecond");
  addFormatToken(0, ["SSSS", 4], 0, function() {
    return this.millisecond() * 10;
  });
  addFormatToken(0, ["SSSSS", 5], 0, function() {
    return this.millisecond() * 100;
  });
  addFormatToken(0, ["SSSSSS", 6], 0, function() {
    return this.millisecond() * 1e3;
  });
  addFormatToken(0, ["SSSSSSS", 7], 0, function() {
    return this.millisecond() * 1e4;
  });
  addFormatToken(0, ["SSSSSSSS", 8], 0, function() {
    return this.millisecond() * 1e5;
  });
  addFormatToken(0, ["SSSSSSSSS", 9], 0, function() {
    return this.millisecond() * 1e6;
  });
  addUnitAlias("millisecond", "ms");
  addUnitPriority("millisecond", 16);
  addRegexToken("S", match1to3, match1);
  addRegexToken("SS", match1to3, match2);
  addRegexToken("SSS", match1to3, match3);
  var token2;
  var getSetMillisecond;
  for (token2 = "SSSS"; token2.length <= 9; token2 += "S") {
    addRegexToken(token2, matchUnsigned);
  }
  function parseMs(input, array2) {
    array2[MILLISECOND] = toInt(("0." + input) * 1e3);
  }
  for (token2 = "S"; token2.length <= 9; token2 += "S") {
    addParseToken(token2, parseMs);
  }
  getSetMillisecond = makeGetSet("Milliseconds", false);
  addFormatToken("z", 0, 0, "zoneAbbr");
  addFormatToken("zz", 0, 0, "zoneName");
  function getZoneAbbr() {
    return this._isUTC ? "UTC" : "";
  }
  function getZoneName() {
    return this._isUTC ? "Coordinated Universal Time" : "";
  }
  var proto = Moment.prototype;
  proto.add = add;
  proto.calendar = calendar$1;
  proto.clone = clone2;
  proto.diff = diff;
  proto.endOf = endOf;
  proto.format = format2;
  proto.from = from;
  proto.fromNow = fromNow;
  proto.to = to;
  proto.toNow = toNow;
  proto.get = stringGet;
  proto.invalidAt = invalidAt;
  proto.isAfter = isAfter;
  proto.isBefore = isBefore;
  proto.isBetween = isBetween;
  proto.isSame = isSame;
  proto.isSameOrAfter = isSameOrAfter;
  proto.isSameOrBefore = isSameOrBefore;
  proto.isValid = isValid$2;
  proto.lang = lang;
  proto.locale = locale;
  proto.localeData = localeData;
  proto.max = prototypeMax;
  proto.min = prototypeMin;
  proto.parsingFlags = parsingFlags;
  proto.set = stringSet;
  proto.startOf = startOf;
  proto.subtract = subtract;
  proto.toArray = toArray;
  proto.toObject = toObject3;
  proto.toDate = toDate;
  proto.toISOString = toISOString;
  proto.inspect = inspect;
  if (typeof Symbol !== "undefined" && Symbol.for != null) {
    proto[Symbol.for("nodejs.util.inspect.custom")] = function() {
      return "Moment<" + this.format() + ">";
    };
  }
  proto.toJSON = toJSON;
  proto.toString = toString5;
  proto.unix = unix;
  proto.valueOf = valueOf;
  proto.creationData = creationData;
  proto.eraName = getEraName;
  proto.eraNarrow = getEraNarrow;
  proto.eraAbbr = getEraAbbr;
  proto.eraYear = getEraYear;
  proto.year = getSetYear;
  proto.isLeapYear = getIsLeapYear;
  proto.weekYear = getSetWeekYear;
  proto.isoWeekYear = getSetISOWeekYear;
  proto.quarter = proto.quarters = getSetQuarter;
  proto.month = getSetMonth;
  proto.daysInMonth = getDaysInMonth;
  proto.week = proto.weeks = getSetWeek;
  proto.isoWeek = proto.isoWeeks = getSetISOWeek;
  proto.weeksInYear = getWeeksInYear;
  proto.weeksInWeekYear = getWeeksInWeekYear;
  proto.isoWeeksInYear = getISOWeeksInYear;
  proto.isoWeeksInISOWeekYear = getISOWeeksInISOWeekYear;
  proto.date = getSetDayOfMonth;
  proto.day = proto.days = getSetDayOfWeek;
  proto.weekday = getSetLocaleDayOfWeek;
  proto.isoWeekday = getSetISODayOfWeek;
  proto.dayOfYear = getSetDayOfYear;
  proto.hour = proto.hours = getSetHour;
  proto.minute = proto.minutes = getSetMinute;
  proto.second = proto.seconds = getSetSecond;
  proto.millisecond = proto.milliseconds = getSetMillisecond;
  proto.utcOffset = getSetOffset;
  proto.utc = setOffsetToUTC;
  proto.local = setOffsetToLocal;
  proto.parseZone = setOffsetToParsedOffset;
  proto.hasAlignedHourOffset = hasAlignedHourOffset;
  proto.isDST = isDaylightSavingTime;
  proto.isLocal = isLocal;
  proto.isUtcOffset = isUtcOffset;
  proto.isUtc = isUtc;
  proto.isUTC = isUtc;
  proto.zoneAbbr = getZoneAbbr;
  proto.zoneName = getZoneName;
  proto.dates = deprecate("dates accessor is deprecated. Use date instead.", getSetDayOfMonth);
  proto.months = deprecate("months accessor is deprecated. Use month instead", getSetMonth);
  proto.years = deprecate("years accessor is deprecated. Use year instead", getSetYear);
  proto.zone = deprecate("moment().zone is deprecated, use moment().utcOffset instead. http://momentjs.com/guides/#/warnings/zone/", getSetZone);
  proto.isDSTShifted = deprecate("isDSTShifted is deprecated. See http://momentjs.com/guides/#/warnings/dst-shifted/ for more information", isDaylightSavingTimeShifted);
  function createUnix(input) {
    return createLocal(input * 1e3);
  }
  function createInZone() {
    return createLocal.apply(null, arguments).parseZone();
  }
  function preParsePostFormat(string2) {
    return string2;
  }
  var proto$1 = Locale.prototype;
  proto$1.calendar = calendar;
  proto$1.longDateFormat = longDateFormat;
  proto$1.invalidDate = invalidDate;
  proto$1.ordinal = ordinal;
  proto$1.preparse = preParsePostFormat;
  proto$1.postformat = preParsePostFormat;
  proto$1.relativeTime = relativeTime;
  proto$1.pastFuture = pastFuture;
  proto$1.set = set3;
  proto$1.eras = localeEras;
  proto$1.erasParse = localeErasParse;
  proto$1.erasConvertYear = localeErasConvertYear;
  proto$1.erasAbbrRegex = erasAbbrRegex;
  proto$1.erasNameRegex = erasNameRegex;
  proto$1.erasNarrowRegex = erasNarrowRegex;
  proto$1.months = localeMonths;
  proto$1.monthsShort = localeMonthsShort;
  proto$1.monthsParse = localeMonthsParse;
  proto$1.monthsRegex = monthsRegex;
  proto$1.monthsShortRegex = monthsShortRegex;
  proto$1.week = localeWeek;
  proto$1.firstDayOfYear = localeFirstDayOfYear;
  proto$1.firstDayOfWeek = localeFirstDayOfWeek;
  proto$1.weekdays = localeWeekdays;
  proto$1.weekdaysMin = localeWeekdaysMin;
  proto$1.weekdaysShort = localeWeekdaysShort;
  proto$1.weekdaysParse = localeWeekdaysParse;
  proto$1.weekdaysRegex = weekdaysRegex;
  proto$1.weekdaysShortRegex = weekdaysShortRegex;
  proto$1.weekdaysMinRegex = weekdaysMinRegex;
  proto$1.isPM = localeIsPM;
  proto$1.meridiem = localeMeridiem;
  function get$12(format3, index3, field, setter) {
    var locale2 = getLocale(), utc = createUTC().set(setter, index3);
    return locale2[field](utc, format3);
  }
  function listMonthsImpl(format3, index3, field) {
    if (isNumber3(format3)) {
      index3 = format3;
      format3 = void 0;
    }
    format3 = format3 || "";
    if (index3 != null) {
      return get$12(format3, index3, field, "month");
    }
    var i3, out = [];
    for (i3 = 0; i3 < 12; i3++) {
      out[i3] = get$12(format3, i3, field, "month");
    }
    return out;
  }
  function listWeekdaysImpl(localeSorted, format3, index3, field) {
    if (typeof localeSorted === "boolean") {
      if (isNumber3(format3)) {
        index3 = format3;
        format3 = void 0;
      }
      format3 = format3 || "";
    } else {
      format3 = localeSorted;
      index3 = format3;
      localeSorted = false;
      if (isNumber3(format3)) {
        index3 = format3;
        format3 = void 0;
      }
      format3 = format3 || "";
    }
    var locale2 = getLocale(), shift2 = localeSorted ? locale2._week.dow : 0, i3, out = [];
    if (index3 != null) {
      return get$12(format3, (index3 + shift2) % 7, field, "day");
    }
    for (i3 = 0; i3 < 7; i3++) {
      out[i3] = get$12(format3, (i3 + shift2) % 7, field, "day");
    }
    return out;
  }
  function listMonths(format3, index3) {
    return listMonthsImpl(format3, index3, "months");
  }
  function listMonthsShort(format3, index3) {
    return listMonthsImpl(format3, index3, "monthsShort");
  }
  function listWeekdays(localeSorted, format3, index3) {
    return listWeekdaysImpl(localeSorted, format3, index3, "weekdays");
  }
  function listWeekdaysShort(localeSorted, format3, index3) {
    return listWeekdaysImpl(localeSorted, format3, index3, "weekdaysShort");
  }
  function listWeekdaysMin(localeSorted, format3, index3) {
    return listWeekdaysImpl(localeSorted, format3, index3, "weekdaysMin");
  }
  getSetGlobalLocale("en", {
    eras: [
      {
        since: "0001-01-01",
        until: Infinity,
        offset: 1,
        name: "Anno Domini",
        narrow: "AD",
        abbr: "AD"
      },
      {
        since: "0000-12-31",
        until: -Infinity,
        offset: 1,
        name: "Before Christ",
        narrow: "BC",
        abbr: "BC"
      }
    ],
    dayOfMonthOrdinalParse: /\d{1,2}(th|st|nd|rd)/,
    ordinal: function(number) {
      var b2 = number % 10, output2 = toInt(number % 100 / 10) === 1 ? "th" : b2 === 1 ? "st" : b2 === 2 ? "nd" : b2 === 3 ? "rd" : "th";
      return number + output2;
    }
  });
  hooks.lang = deprecate("moment.lang is deprecated. Use moment.locale instead.", getSetGlobalLocale);
  hooks.langData = deprecate("moment.langData is deprecated. Use moment.localeData instead.", getLocale);
  var mathAbs = Math.abs;
  function abs2() {
    var data2 = this._data;
    this._milliseconds = mathAbs(this._milliseconds);
    this._days = mathAbs(this._days);
    this._months = mathAbs(this._months);
    data2.milliseconds = mathAbs(data2.milliseconds);
    data2.seconds = mathAbs(data2.seconds);
    data2.minutes = mathAbs(data2.minutes);
    data2.hours = mathAbs(data2.hours);
    data2.months = mathAbs(data2.months);
    data2.years = mathAbs(data2.years);
    return this;
  }
  function addSubtract$1(duration, input, value, direction) {
    var other = createDuration(input, value);
    duration._milliseconds += direction * other._milliseconds;
    duration._days += direction * other._days;
    duration._months += direction * other._months;
    return duration._bubble();
  }
  function add$1(input, value) {
    return addSubtract$1(this, input, value, 1);
  }
  function subtract$1(input, value) {
    return addSubtract$1(this, input, value, -1);
  }
  function absCeil(number) {
    if (number < 0) {
      return Math.floor(number);
    } else {
      return Math.ceil(number);
    }
  }
  function bubble() {
    var milliseconds2 = this._milliseconds, days2 = this._days, months2 = this._months, data2 = this._data, seconds2, minutes2, hours2, years2, monthsFromDays;
    if (!(milliseconds2 >= 0 && days2 >= 0 && months2 >= 0 || milliseconds2 <= 0 && days2 <= 0 && months2 <= 0)) {
      milliseconds2 += absCeil(monthsToDays(months2) + days2) * 864e5;
      days2 = 0;
      months2 = 0;
    }
    data2.milliseconds = milliseconds2 % 1e3;
    seconds2 = absFloor(milliseconds2 / 1e3);
    data2.seconds = seconds2 % 60;
    minutes2 = absFloor(seconds2 / 60);
    data2.minutes = minutes2 % 60;
    hours2 = absFloor(minutes2 / 60);
    data2.hours = hours2 % 24;
    days2 += absFloor(hours2 / 24);
    monthsFromDays = absFloor(daysToMonths(days2));
    months2 += monthsFromDays;
    days2 -= absCeil(monthsToDays(monthsFromDays));
    years2 = absFloor(months2 / 12);
    months2 %= 12;
    data2.days = days2;
    data2.months = months2;
    data2.years = years2;
    return this;
  }
  function daysToMonths(days2) {
    return days2 * 4800 / 146097;
  }
  function monthsToDays(months2) {
    return months2 * 146097 / 4800;
  }
  function as(units) {
    if (!this.isValid()) {
      return NaN;
    }
    var days2, months2, milliseconds2 = this._milliseconds;
    units = normalizeUnits(units);
    if (units === "month" || units === "quarter" || units === "year") {
      days2 = this._days + milliseconds2 / 864e5;
      months2 = this._months + daysToMonths(days2);
      switch (units) {
        case "month":
          return months2;
        case "quarter":
          return months2 / 3;
        case "year":
          return months2 / 12;
      }
    } else {
      days2 = this._days + Math.round(monthsToDays(this._months));
      switch (units) {
        case "week":
          return days2 / 7 + milliseconds2 / 6048e5;
        case "day":
          return days2 + milliseconds2 / 864e5;
        case "hour":
          return days2 * 24 + milliseconds2 / 36e5;
        case "minute":
          return days2 * 1440 + milliseconds2 / 6e4;
        case "second":
          return days2 * 86400 + milliseconds2 / 1e3;
        case "millisecond":
          return Math.floor(days2 * 864e5) + milliseconds2;
        default:
          throw new Error("Unknown unit " + units);
      }
    }
  }
  function valueOf$1() {
    if (!this.isValid()) {
      return NaN;
    }
    return this._milliseconds + this._days * 864e5 + this._months % 12 * 2592e6 + toInt(this._months / 12) * 31536e6;
  }
  function makeAs(alias) {
    return function() {
      return this.as(alias);
    };
  }
  var asMilliseconds = makeAs("ms");
  var asSeconds = makeAs("s");
  var asMinutes = makeAs("m");
  var asHours = makeAs("h");
  var asDays = makeAs("d");
  var asWeeks = makeAs("w");
  var asMonths = makeAs("M");
  var asQuarters = makeAs("Q");
  var asYears = makeAs("y");
  function clone$1() {
    return createDuration(this);
  }
  function get$2(units) {
    units = normalizeUnits(units);
    return this.isValid() ? this[units + "s"]() : NaN;
  }
  function makeGetter(name) {
    return function() {
      return this.isValid() ? this._data[name] : NaN;
    };
  }
  var milliseconds = makeGetter("milliseconds");
  var seconds = makeGetter("seconds");
  var minutes = makeGetter("minutes");
  var hours = makeGetter("hours");
  var days = makeGetter("days");
  var months = makeGetter("months");
  var years = makeGetter("years");
  function weeks() {
    return absFloor(this.days() / 7);
  }
  var round = Math.round;
  var thresholds = {
    ss: 44,
    s: 45,
    m: 45,
    h: 22,
    d: 26,
    w: null,
    M: 11
  };
  function substituteTimeAgo(string2, number, withoutSuffix, isFuture, locale2) {
    return locale2.relativeTime(number || 1, !!withoutSuffix, string2, isFuture);
  }
  function relativeTime$1(posNegDuration, withoutSuffix, thresholds2, locale2) {
    var duration = createDuration(posNegDuration).abs(), seconds2 = round(duration.as("s")), minutes2 = round(duration.as("m")), hours2 = round(duration.as("h")), days2 = round(duration.as("d")), months2 = round(duration.as("M")), weeks2 = round(duration.as("w")), years2 = round(duration.as("y")), a2 = seconds2 <= thresholds2.ss && ["s", seconds2] || seconds2 < thresholds2.s && ["ss", seconds2] || minutes2 <= 1 && ["m"] || minutes2 < thresholds2.m && ["mm", minutes2] || hours2 <= 1 && ["h"] || hours2 < thresholds2.h && ["hh", hours2] || days2 <= 1 && ["d"] || days2 < thresholds2.d && ["dd", days2];
    if (thresholds2.w != null) {
      a2 = a2 || weeks2 <= 1 && ["w"] || weeks2 < thresholds2.w && ["ww", weeks2];
    }
    a2 = a2 || months2 <= 1 && ["M"] || months2 < thresholds2.M && ["MM", months2] || years2 <= 1 && ["y"] || ["yy", years2];
    a2[2] = withoutSuffix;
    a2[3] = +posNegDuration > 0;
    a2[4] = locale2;
    return substituteTimeAgo.apply(null, a2);
  }
  function getSetRelativeTimeRounding(roundingFunction) {
    if (roundingFunction === void 0) {
      return round;
    }
    if (typeof roundingFunction === "function") {
      round = roundingFunction;
      return true;
    }
    return false;
  }
  function getSetRelativeTimeThreshold(threshold, limit) {
    if (thresholds[threshold] === void 0) {
      return false;
    }
    if (limit === void 0) {
      return thresholds[threshold];
    }
    thresholds[threshold] = limit;
    if (threshold === "s") {
      thresholds.ss = limit - 1;
    }
    return true;
  }
  function humanize3(argWithSuffix, argThresholds) {
    if (!this.isValid()) {
      return this.localeData().invalidDate();
    }
    var withSuffix = false, th2 = thresholds, locale2, output2;
    if (typeof argWithSuffix === "object") {
      argThresholds = argWithSuffix;
      argWithSuffix = false;
    }
    if (typeof argWithSuffix === "boolean") {
      withSuffix = argWithSuffix;
    }
    if (typeof argThresholds === "object") {
      th2 = Object.assign({}, thresholds, argThresholds);
      if (argThresholds.s != null && argThresholds.ss == null) {
        th2.ss = argThresholds.s - 1;
      }
    }
    locale2 = this.localeData();
    output2 = relativeTime$1(this, !withSuffix, th2, locale2);
    if (withSuffix) {
      output2 = locale2.pastFuture(+this, output2);
    }
    return locale2.postformat(output2);
  }
  var abs$1 = Math.abs;
  function sign(x2) {
    return (x2 > 0) - (x2 < 0) || +x2;
  }
  function toISOString$1() {
    if (!this.isValid()) {
      return this.localeData().invalidDate();
    }
    var seconds2 = abs$1(this._milliseconds) / 1e3, days2 = abs$1(this._days), months2 = abs$1(this._months), minutes2, hours2, years2, s2, total = this.asSeconds(), totalSign, ymSign, daysSign, hmsSign;
    if (!total) {
      return "P0D";
    }
    minutes2 = absFloor(seconds2 / 60);
    hours2 = absFloor(minutes2 / 60);
    seconds2 %= 60;
    minutes2 %= 60;
    years2 = absFloor(months2 / 12);
    months2 %= 12;
    s2 = seconds2 ? seconds2.toFixed(3).replace(/\.?0+$/, "") : "";
    totalSign = total < 0 ? "-" : "";
    ymSign = sign(this._months) !== sign(total) ? "-" : "";
    daysSign = sign(this._days) !== sign(total) ? "-" : "";
    hmsSign = sign(this._milliseconds) !== sign(total) ? "-" : "";
    return totalSign + "P" + (years2 ? ymSign + years2 + "Y" : "") + (months2 ? ymSign + months2 + "M" : "") + (days2 ? daysSign + days2 + "D" : "") + (hours2 || minutes2 || seconds2 ? "T" : "") + (hours2 ? hmsSign + hours2 + "H" : "") + (minutes2 ? hmsSign + minutes2 + "M" : "") + (seconds2 ? hmsSign + s2 + "S" : "");
  }
  var proto$2 = Duration.prototype;
  proto$2.isValid = isValid$1;
  proto$2.abs = abs2;
  proto$2.add = add$1;
  proto$2.subtract = subtract$1;
  proto$2.as = as;
  proto$2.asMilliseconds = asMilliseconds;
  proto$2.asSeconds = asSeconds;
  proto$2.asMinutes = asMinutes;
  proto$2.asHours = asHours;
  proto$2.asDays = asDays;
  proto$2.asWeeks = asWeeks;
  proto$2.asMonths = asMonths;
  proto$2.asQuarters = asQuarters;
  proto$2.asYears = asYears;
  proto$2.valueOf = valueOf$1;
  proto$2._bubble = bubble;
  proto$2.clone = clone$1;
  proto$2.get = get$2;
  proto$2.milliseconds = milliseconds;
  proto$2.seconds = seconds;
  proto$2.minutes = minutes;
  proto$2.hours = hours;
  proto$2.days = days;
  proto$2.weeks = weeks;
  proto$2.months = months;
  proto$2.years = years;
  proto$2.humanize = humanize3;
  proto$2.toISOString = toISOString$1;
  proto$2.toString = toISOString$1;
  proto$2.toJSON = toISOString$1;
  proto$2.locale = locale;
  proto$2.localeData = localeData;
  proto$2.toIsoString = deprecate("toIsoString() is deprecated. Please use toISOString() instead (notice the capitals)", toISOString$1);
  proto$2.lang = lang;
  addFormatToken("X", 0, 0, "unix");
  addFormatToken("x", 0, 0, "valueOf");
  addRegexToken("x", matchSigned);
  addRegexToken("X", matchTimestamp);
  addParseToken("X", function(input, array2, config2) {
    config2._d = new Date(parseFloat(input) * 1e3);
  });
  addParseToken("x", function(input, array2, config2) {
    config2._d = new Date(toInt(input));
  });
  //! moment.js
  hooks.version = "2.29.1";
  setHookCallback(createLocal);
  hooks.fn = proto;
  hooks.min = min2;
  hooks.max = max2;
  hooks.now = now3;
  hooks.utc = createUTC;
  hooks.unix = createUnix;
  hooks.months = listMonths;
  hooks.isDate = isDate2;
  hooks.locale = getSetGlobalLocale;
  hooks.invalid = createInvalid;
  hooks.duration = createDuration;
  hooks.isMoment = isMoment;
  hooks.weekdays = listWeekdays;
  hooks.parseZone = createInZone;
  hooks.localeData = getLocale;
  hooks.isDuration = isDuration;
  hooks.monthsShort = listMonthsShort;
  hooks.weekdaysMin = listWeekdaysMin;
  hooks.defineLocale = defineLocale;
  hooks.updateLocale = updateLocale;
  hooks.locales = listLocales;
  hooks.weekdaysShort = listWeekdaysShort;
  hooks.normalizeUnits = normalizeUnits;
  hooks.relativeTimeRounding = getSetRelativeTimeRounding;
  hooks.relativeTimeThreshold = getSetRelativeTimeThreshold;
  hooks.calendarFormat = getCalendarFormat;
  hooks.prototype = proto;
  hooks.HTML5_FMT = {
    DATETIME_LOCAL: "YYYY-MM-DDTHH:mm",
    DATETIME_LOCAL_SECONDS: "YYYY-MM-DDTHH:mm:ss",
    DATETIME_LOCAL_MS: "YYYY-MM-DDTHH:mm:ss.SSS",
    DATE: "YYYY-MM-DD",
    TIME: "HH:mm",
    TIME_SECONDS: "HH:mm:ss",
    TIME_MS: "HH:mm:ss.SSS",
    WEEK: "GGGG-[W]WW",
    MONTH: "YYYY-MM"
  };
  var moment_default = hooks;
});

// build/clients/initial-access/CreateInitialAccessToken.js
var require_CreateInitialAccessToken = __commonJS((exports2) => {
  __markAsModule(exports2);
  __export(exports2, {
    default: () => CreateInitialAccessToken
  });
  function CreateInitialAccessToken() {
    const {t: t5} = useTranslation("clients");
    const {handleSubmit, control} = useForm();
    const adminClient = useAdminClient();
    const {realm: realm2} = useRealm();
    const {addAlert, addError} = useAlerts();
    const history = useHistory();
    const [token2, setToken] = useState("");
    const save = async (clientToken) => {
      try {
        const access = await adminClient.realms.createClientsInitialAccess({realm: realm2}, clientToken);
        setToken(access.token);
      } catch (error2) {
        addError("clients:tokenSaveError", error2);
      }
    };
    return /* @__PURE__ */ react.createElement(react.Fragment, null, token2 && /* @__PURE__ */ react.createElement(AccessTokenDialog, {
      token: token2,
      toggleDialog: () => {
        setToken("");
        addAlert(t5("tokenSaveSuccess"), AlertVariant.success);
        history.push(toClients({realm: realm2, tab: "initialAccessToken"}));
      }
    }), /* @__PURE__ */ react.createElement(ViewHeader, {
      titleKey: "clients:createToken",
      subKey: "clients-help:createToken"
    }), /* @__PURE__ */ react.createElement(PageSection, {
      variant: "light"
    }, /* @__PURE__ */ react.createElement(FormAccess, {
      isHorizontal: true,
      role: "create-client",
      onSubmit: handleSubmit(save)
    }, /* @__PURE__ */ react.createElement(FormGroup, {
      label: t5("expiration"),
      fieldId: "expiration",
      labelIcon: /* @__PURE__ */ react.createElement(HelpItem, {
        helpText: "clients-help:expiration",
        forLabel: t5("expiration"),
        forID: "expiration"
      })
    }, /* @__PURE__ */ react.createElement(Controller, {
      name: "expiration",
      defaultValue: 86400,
      control,
      render: ({onChange, value}) => /* @__PURE__ */ react.createElement(TimeSelector, {
        "data-testid": "expiration",
        value,
        onChange,
        units: ["days", "hours", "minutes", "seconds"]
      })
    })), /* @__PURE__ */ react.createElement(FormGroup, {
      label: t5("count"),
      fieldId: "count",
      labelIcon: /* @__PURE__ */ react.createElement(HelpItem, {
        helpText: "clients-help:count",
        forLabel: t5("count"),
        forID: "count"
      })
    }, /* @__PURE__ */ react.createElement(Controller, {
      name: "count",
      defaultValue: 1,
      control,
      render: ({onChange, value}) => /* @__PURE__ */ react.createElement(NumberInput, {
        "data-testid": "count",
        inputName: "count",
        inputAriaLabel: t5("count"),
        min: 1,
        value,
        onPlus: () => onChange(value + 1),
        onMinus: () => onChange(value - 1),
        onChange: (event) => onChange(Number(event.target.value))
      })
    })), /* @__PURE__ */ react.createElement(ActionGroup, null, /* @__PURE__ */ react.createElement(Button, {
      variant: "primary",
      type: "submit",
      "data-testid": "save"
    }, t5("common:save")), /* @__PURE__ */ react.createElement(Button, {
      "data-testid": "cancel",
      variant: "link",
      component: (props) => /* @__PURE__ */ react.createElement(Link, {
        ...props,
        to: toClients({realm: realm2, tab: "initialAccessToken"})
      })
    }, t5("common:cancel"))))));
  }
});

// build/clients/import/ImportForm.js
var require_ImportForm = __commonJS((exports2) => {
  __markAsModule(exports2);
  __export(exports2, {
    default: () => ImportForm
  });
  function ImportForm() {
    const {t: t5} = useTranslation("clients");
    const history = useHistory();
    const adminClient = useAdminClient();
    const {realm: realm2} = useRealm();
    const form2 = useForm();
    const {register: register2, handleSubmit, setValue} = form2;
    const [imported, setImported] = useState({});
    const {addAlert, addError} = useAlerts();
    const handleFileChange = (obj) => {
      const defaultClient = {
        protocol: "",
        clientId: "",
        name: "",
        description: ""
      };
      convertToFormValues(obj || defaultClient, setValue);
      setImported(obj || defaultClient);
    };
    const save = async (client2) => {
      try {
        const newClient = await adminClient.clients.create({
          ...imported,
          ...convertFormValuesToObject(client2)
        });
        addAlert(t5("clientImportSuccess"), AlertVariant.success);
        history.push(toClient({realm: realm2, clientId: newClient.id, tab: "settings"}));
      } catch (error2) {
        addError("clients:clientImportError", error2);
      }
    };
    return /* @__PURE__ */ react.createElement(react.Fragment, null, /* @__PURE__ */ react.createElement(ViewHeader, {
      titleKey: "clients:importClient",
      subKey: "clients:clientsExplain"
    }), /* @__PURE__ */ react.createElement(PageSection, {
      variant: "light"
    }, /* @__PURE__ */ react.createElement(FormAccess, {
      isHorizontal: true,
      onSubmit: handleSubmit(save),
      role: "manage-clients"
    }, /* @__PURE__ */ react.createElement(FormProvider, {
      ...form2
    }, /* @__PURE__ */ react.createElement(JsonFileUpload, {
      id: "realm-file",
      onChange: handleFileChange
    }), /* @__PURE__ */ react.createElement(ClientDescription, null), /* @__PURE__ */ react.createElement(FormGroup, {
      label: t5("common:type"),
      fieldId: "kc-type"
    }, /* @__PURE__ */ react.createElement(TextInput, {
      type: "text",
      id: "kc-type",
      name: "protocol",
      isReadOnly: true,
      ref: register2()
    })), /* @__PURE__ */ react.createElement(CapabilityConfig, {
      unWrap: true
    }), /* @__PURE__ */ react.createElement(ActionGroup, null, /* @__PURE__ */ react.createElement(Button, {
      variant: "primary",
      type: "submit"
    }, t5("common:save")), /* @__PURE__ */ react.createElement(Button, {
      variant: "link",
      component: (props) => /* @__PURE__ */ react.createElement(Link, {
        ...props,
        to: toClients({realm: realm2})
      })
    }, t5("common:cancel")))))));
  }
});

// build/clients/ClientsSection.js
var require_ClientsSection = __commonJS((exports2) => {
  __markAsModule(exports2);
  __export(exports2, {
    default: () => ClientsSection
  });
  function ClientsSection() {
    const {t: t5} = useTranslation("clients");
    const {addAlert, addError} = useAlerts();
    const adminClient = useAdminClient();
    const {realm: realm2} = useRealm();
    const baseUrl = getBaseUrl(adminClient);
    const [key, setKey] = useState(0);
    const refresh = () => setKey(new Date().getTime());
    const [selectedClient, setSelectedClient] = useState();
    const loader = async (first2, max2, search2) => {
      const params = {
        first: first2,
        max: max2
      };
      if (search2) {
        params.clientId = search2;
        params.search = true;
      }
      return await adminClient.clients.find({...params});
    };
    const [toggleDeleteDialog, DeleteConfirm] = useConfirmDialog({
      titleKey: t5("clientDelete", {clientId: selectedClient?.clientId}),
      messageKey: "clients:clientDeleteConfirm",
      continueButtonLabel: "common:delete",
      continueButtonVariant: ButtonVariant.danger,
      onConfirm: async () => {
        try {
          await adminClient.clients.del({
            id: selectedClient.id
          });
          addAlert(t5("clientDeletedSuccess"), AlertVariant.success);
          refresh();
        } catch (error2) {
          addError("clients:clientDeleteError", error2);
        }
      }
    });
    const ClientDetailLink = (client2) => /* @__PURE__ */ react.createElement(Link, {
      key: client2.id,
      to: toClient({realm: realm2, clientId: client2.id, tab: "settings"})
    }, client2.clientId, !client2.enabled && /* @__PURE__ */ react.createElement(Badge, {
      key: `${client2.id}-disabled`,
      isRead: true,
      className: "pf-u-ml-sm"
    }, t5("common:disabled")));
    const ClientDescription2 = (client2) => /* @__PURE__ */ react.createElement(TableText, {
      wrapModifier: "truncate"
    }, emptyFormatter()(client2.description));
    return /* @__PURE__ */ react.createElement(react.Fragment, null, /* @__PURE__ */ react.createElement(ViewHeader, {
      titleKey: "clients:clientList",
      subKey: "clients:clientsExplain",
      divider: false
    }), /* @__PURE__ */ react.createElement(PageSection, {
      variant: "light",
      className: "pf-u-p-0"
    }, /* @__PURE__ */ react.createElement(KeycloakTabs, {
      isBox: true
    }, /* @__PURE__ */ react.createElement(Tab, {
      "data-testid": "list",
      eventKey: "list",
      title: /* @__PURE__ */ react.createElement(TabTitleText, null, t5("clientsList"))
    }, /* @__PURE__ */ react.createElement(DeleteConfirm, null), /* @__PURE__ */ react.createElement(KeycloakDataTable, {
      key,
      loader,
      isPaginated: true,
      ariaLabelKey: "clients:clientList",
      searchPlaceholderKey: "clients:searchForClient",
      toolbarItem: /* @__PURE__ */ react.createElement(react.Fragment, null, /* @__PURE__ */ react.createElement(ToolbarItem, null, /* @__PURE__ */ react.createElement(Button, {
        component: (props) => /* @__PURE__ */ react.createElement(Link, {
          ...props,
          to: toAddClient({realm: realm2})
        })
      }, t5("createClient"))), /* @__PURE__ */ react.createElement(ToolbarItem, null, /* @__PURE__ */ react.createElement(Button, {
        component: (props) => /* @__PURE__ */ react.createElement(Link, {
          ...props,
          to: toImportClient({realm: realm2})
        }),
        variant: "link"
      }, t5("importClient")))),
      actionResolver: (rowData) => {
        const client2 = rowData.data;
        const actions2 = [
          {
            title: t5("common:export"),
            onClick() {
              exportClient(client2);
            }
          }
        ];
        if (!isRealmClient(client2)) {
          actions2.push({
            title: t5("common:delete"),
            onClick() {
              setSelectedClient(client2);
              toggleDeleteDialog();
            }
          });
        }
        return actions2;
      },
      columns: [
        {
          name: "clientId",
          displayKey: "common:clientId",
          cellRenderer: ClientDetailLink
        },
        {
          name: "protocol",
          displayKey: "common:type",
          cellRenderer: (client2) => getProtocolName(t5, client2.protocol ?? "openid-connect")
        },
        {
          name: "description",
          displayKey: "common:description",
          transforms: [cellWidth(20)],
          cellRenderer: ClientDescription2
        },
        {
          name: "baseUrl",
          displayKey: "clients:homeURL",
          cellFormatters: [formattedLinkTableCell(), emptyFormatter()],
          cellRenderer: (client2) => {
            if (client2.rootUrl) {
              if (!client2.rootUrl.startsWith("http") || client2.rootUrl.includes("$")) {
                client2.rootUrl = client2.rootUrl.replace("${authBaseUrl}", baseUrl).replace("${authAdminUrl}", baseUrl) + (client2.baseUrl ? client2.baseUrl.substr(1) : "");
              }
            }
            return client2.rootUrl;
          }
        }
      ]
    })), /* @__PURE__ */ react.createElement(Tab, {
      "data-testid": "initialAccessToken",
      eventKey: "initialAccessToken",
      title: /* @__PURE__ */ react.createElement(TabTitleText, null, t5("initialAccessToken"))
    }, /* @__PURE__ */ react.createElement(InitialAccessTokenList, null)))));
  }
});

// build/clients/authorization/ResourceDetails.js
var require_ResourceDetails = __commonJS((exports2) => {
  __markAsModule(exports2);
  __export(exports2, {
    default: () => ResourceDetails
  });
  function ResourceDetails() {
    const {t: t5} = useTranslation("clients");
    const [client2, setClient] = useState();
    const [resource2, setResource] = useState();
    const [permissions, setPermission] = useState();
    const adminClient = useAdminClient();
    const {addAlert, addError} = useAlerts();
    const form2 = useForm({
      shouldUnregister: false,
      mode: "onChange"
    });
    const {register: register2, errors, control, setValue, handleSubmit} = form2;
    const {id: id3, resourceId, realm: realm2} = useParams();
    const history = useHistory();
    const setupForm = (resource22 = {}) => {
      convertToFormValues(resource22, setValue, ["uris"]);
    };
    useFetch(async () => {
      const [client22, resource22, permissions2] = await Promise.all([
        adminClient.clients.findOne({id: id3}),
        resourceId ? adminClient.clients.getResource({id: id3, resourceId}) : Promise.resolve(void 0),
        resourceId ? adminClient.clients.listPermissionsByResource({id: id3, resourceId}) : Promise.resolve(void 0)
      ]);
      return {client: client22, resource: resource22, permissions: permissions2};
    }, ({client: client22, resource: resource22, permissions: permissions2}) => {
      if (!client22) {
        throw new Error(t5("common:notFound"));
      }
      setClient(client22);
      setPermission(permissions2);
      setResource(resource22);
      setupForm(resource22);
    }, []);
    const save = async (submitted) => {
      const resource22 = convertFormValuesToObject(submitted, ["uris"]);
      try {
        if (resourceId) {
          await adminClient.clients.updateResource({id: id3, resourceId}, resource22);
        } else {
          const result = await adminClient.clients.createResource({id: id3}, resource22);
          history.push(toResourceDetails({realm: realm2, id: id3, resourceId: result._id}));
        }
        addAlert(t5((resourceId ? "update" : "create") + "ResourceSuccess"), AlertVariant.success);
      } catch (error2) {
        addError("client:resourceSaveError", error2);
      }
    };
    const [toggleDeleteDialog, DeleteConfirm] = useConfirmDialog({
      titleKey: "clients:deleteResource",
      children: /* @__PURE__ */ react.createElement(react.Fragment, null, t5("deleteResourceConfirm"), permissions?.length !== 0 && /* @__PURE__ */ react.createElement(Alert, {
        variant: "warning",
        isInline: true,
        isPlain: true,
        title: t5("deleteResourceWarning"),
        className: "pf-u-pt-lg"
      }, /* @__PURE__ */ react.createElement("p", {
        className: "pf-u-pt-xs"
      }, permissions?.map((permission) => /* @__PURE__ */ react.createElement("strong", {
        key: permission.id,
        className: "pf-u-pr-md"
      }, permission.name))))),
      continueButtonLabel: "clients:confirm",
      onConfirm: async () => {
        try {
          await adminClient.clients.delResource({
            id: id3,
            resourceId
          });
          addAlert(t5("resourceDeletedSuccess"), AlertVariant.success);
          history.push(toClient({realm: realm2, clientId: id3, tab: "authorization"}));
        } catch (error2) {
          addError("clients:resourceDeletedError", error2);
        }
      }
    });
    if (!client2) {
      return /* @__PURE__ */ react.createElement(KeycloakSpinner, null);
    }
    return /* @__PURE__ */ react.createElement(react.Fragment, null, /* @__PURE__ */ react.createElement(DeleteConfirm, null), /* @__PURE__ */ react.createElement(ViewHeader, {
      titleKey: resourceId ? resource2?.name : "clients:createResource",
      dropdownItems: resourceId ? [
        /* @__PURE__ */ react.createElement(DropdownItem, {
          key: "delete",
          "data-testid": "delete-resource",
          onClick: () => toggleDeleteDialog()
        }, t5("common:delete"))
      ] : void 0
    }), /* @__PURE__ */ react.createElement(PageSection, {
      variant: "light"
    }, /* @__PURE__ */ react.createElement(FormProvider, {
      ...form2
    }, /* @__PURE__ */ react.createElement(FormAccess, {
      isHorizontal: true,
      role: "manage-clients",
      className: "keycloak__resource-details__form",
      onSubmit: handleSubmit(save)
    }, /* @__PURE__ */ react.createElement(FormGroup, {
      label: t5("owner"),
      fieldId: "owner",
      labelIcon: /* @__PURE__ */ react.createElement(HelpItem, {
        helpText: "clients-help:owner",
        forLabel: t5("owner"),
        forID: t5(`common:helpLabel`, {label: t5("owner")})
      })
    }, /* @__PURE__ */ react.createElement(TextInput, {
      id: "owner",
      value: client2.clientId,
      isReadOnly: true
    })), /* @__PURE__ */ react.createElement(FormGroup, {
      label: t5("common:name"),
      fieldId: "name",
      labelIcon: /* @__PURE__ */ react.createElement(HelpItem, {
        helpText: "clients-help:resourceName",
        forLabel: t5("name"),
        forID: t5(`common:helpLabel`, {label: t5("name")})
      }),
      helperTextInvalid: t5("common:required"),
      validated: errors.name ? ValidatedOptions.error : ValidatedOptions.default,
      isRequired: true
    }, /* @__PURE__ */ react.createElement(TextInput, {
      id: "name",
      name: "name",
      ref: register2({required: true}),
      validated: errors.name ? ValidatedOptions.error : ValidatedOptions.default
    })), /* @__PURE__ */ react.createElement(FormGroup, {
      label: t5("displayName"),
      fieldId: "displayName",
      labelIcon: /* @__PURE__ */ react.createElement(HelpItem, {
        helpText: "clients-help:displayName",
        forLabel: t5("name"),
        forID: t5(`common:helpLabel`, {label: t5("name")})
      })
    }, /* @__PURE__ */ react.createElement(TextInput, {
      id: "displayName",
      name: "name",
      ref: register2
    })), /* @__PURE__ */ react.createElement(FormGroup, {
      label: t5("type"),
      fieldId: "type",
      labelIcon: /* @__PURE__ */ react.createElement(HelpItem, {
        helpText: "clients-help:type",
        forLabel: t5("type"),
        forID: t5(`common:helpLabel`, {label: t5("type")})
      })
    }, /* @__PURE__ */ react.createElement(TextInput, {
      id: "type",
      name: "type",
      ref: register2
    })), /* @__PURE__ */ react.createElement(FormGroup, {
      label: t5("uris"),
      fieldId: "uris",
      labelIcon: /* @__PURE__ */ react.createElement(HelpItem, {
        helpText: "clients-help:uris",
        forLabel: t5("uris"),
        forID: t5(`common:helpLabel`, {label: t5("uris")})
      })
    }, /* @__PURE__ */ react.createElement(MultiLineInput, {
      name: "uris",
      "aria-label": t5("uri"),
      addButtonLabel: "clients:addUri"
    })), /* @__PURE__ */ react.createElement(ScopePicker, {
      clientId: id3
    }), /* @__PURE__ */ react.createElement(FormGroup, {
      label: t5("iconUri"),
      fieldId: "iconUri",
      labelIcon: /* @__PURE__ */ react.createElement(HelpItem, {
        helpText: "clients-help:iconUri",
        forLabel: t5("iconUri"),
        forID: t5(`common:helpLabel`, {label: t5("iconUri")})
      })
    }, /* @__PURE__ */ react.createElement(TextInput, {
      id: "iconUri",
      name: "icon_uri",
      ref: register2
    })), /* @__PURE__ */ react.createElement(FormGroup, {
      hasNoPaddingTop: true,
      label: t5("ownerManagedAccess"),
      labelIcon: /* @__PURE__ */ react.createElement(HelpItem, {
        helpText: "clients-help:ownerManagedAccess",
        forLabel: t5("ownerManagedAccess"),
        forID: t5(`common:helpLabel`, {
          label: t5("ownerManagedAccess")
        })
      }),
      fieldId: "ownerManagedAccess"
    }, /* @__PURE__ */ react.createElement(Controller, {
      name: "ownerManagedAccess",
      control,
      defaultValue: false,
      render: ({onChange, value}) => /* @__PURE__ */ react.createElement(Switch, {
        id: "ownerManagedAccess",
        label: t5("common:on"),
        labelOff: t5("common:off"),
        isChecked: value,
        onChange
      })
    })), /* @__PURE__ */ react.createElement(FormGroup, {
      hasNoPaddingTop: true,
      label: t5("resourceAttribute"),
      labelIcon: /* @__PURE__ */ react.createElement(HelpItem, {
        helpText: "clients-help:resourceAttribute",
        forLabel: t5("resourceAttribute"),
        forID: t5(`common:helpLabel`, {
          label: t5("resourceAttribute")
        })
      }),
      fieldId: "resourceAttribute"
    }, /* @__PURE__ */ react.createElement(AttributeInput, {
      name: "attributes"
    })), /* @__PURE__ */ react.createElement(ActionGroup, null, /* @__PURE__ */ react.createElement("div", {
      className: "pf-u-mt-md"
    }, /* @__PURE__ */ react.createElement(Button, {
      variant: ButtonVariant.primary,
      type: "submit",
      "data-testid": "save"
    }, t5("common:save")), /* @__PURE__ */ react.createElement(Button, {
      variant: "link",
      "data-testid": "cancel",
      component: (props) => /* @__PURE__ */ react.createElement(Link, {
        ...props,
        to: toClient({
          realm: realm2,
          clientId: id3,
          tab: "authorization"
        })
      })
    }, t5("common:cancel"))))))));
  }
});

// build/clients/ClientDetails.js
var require_ClientDetails = __commonJS((exports2) => {
  __markAsModule(exports2);
  __export(exports2, {
    default: () => ClientDetails
  });
  var ClientDetailHeader = ({
    onChange,
    value,
    save,
    client: client2,
    toggleDownloadDialog,
    toggleDeleteDialog
  }) => {
    const {t: t5} = useTranslation("clients");
    const [toggleDisableDialog, DisableConfirm] = useConfirmDialog({
      titleKey: "clients:disableConfirmTitle",
      messageKey: "clients:disableConfirm",
      continueButtonLabel: "common:disable",
      onConfirm: () => {
        onChange(!value);
        save();
      }
    });
    const badges = useMemo(() => {
      const protocolName = getProtocolName(t5, client2.protocol ?? "openid-connect");
      const text = client2.bearerOnly ? /* @__PURE__ */ react.createElement(Tooltip, {
        "data-testid": "bearer-only-explainer-tooltip",
        content: t5("explainBearerOnly")
      }, /* @__PURE__ */ react.createElement(Label, {
        "data-testid": "bearer-only-explainer-label",
        icon: /* @__PURE__ */ react.createElement(InfoCircleIcon, null)
      }, protocolName)) : /* @__PURE__ */ react.createElement(Label, null, protocolName);
      return [{text}];
    }, [client2, t5]);
    const dropdownItems = [
      /* @__PURE__ */ react.createElement(DropdownItem, {
        key: "download",
        onClick: toggleDownloadDialog
      }, t5("downloadAdapterConfig")),
      /* @__PURE__ */ react.createElement(DropdownItem, {
        key: "export",
        onClick: () => exportClient(client2)
      }, t5("common:export")),
      ...!isRealmClient(client2) ? [
        /* @__PURE__ */ react.createElement(Divider, {
          key: "divider"
        }),
        /* @__PURE__ */ react.createElement(DropdownItem, {
          "data-testid": "delete-client",
          key: "delete",
          onClick: toggleDeleteDialog
        }, t5("common:delete"))
      ] : []
    ];
    return /* @__PURE__ */ react.createElement(react.Fragment, null, /* @__PURE__ */ react.createElement(DisableConfirm, null), /* @__PURE__ */ react.createElement(ViewHeader, {
      titleKey: client2 ? client2.clientId : "",
      subKey: "clients:clientsExplain",
      badges,
      divider: false,
      helpTextKey: "clients-help:enableDisable",
      dropdownItems,
      isEnabled: value,
      onToggle: (value2) => {
        if (!value2) {
          toggleDisableDialog();
        } else {
          onChange(value2);
          save();
        }
      }
    }));
  };
  function ClientDetails() {
    const {t: t5} = useTranslation("clients");
    const adminClient = useAdminClient();
    const {addAlert, addError} = useAlerts();
    const {realm: realm2} = useRealm();
    const history = useHistory();
    const [downloadDialogOpen, toggleDownloadDialogOpen] = useToggle();
    const [changeAuthenticatorOpen, toggleChangeAuthenticatorOpen] = useToggle();
    const [clientScopeSubTab, setClientScopeSubTab] = useState(30);
    const [authorizationSubTab, setAuthorizationSubTab] = useState(40);
    const form2 = useForm({shouldUnregister: false});
    const {clientId} = useParams();
    const clientAuthenticatorType = useWatch({
      control: form2.control,
      name: "clientAuthenticatorType",
      defaultValue: "client-secret"
    });
    const [client2, setClient] = useState();
    const loader = async () => {
      const roles2 = await adminClient.clients.listRoles({id: clientId});
      return lodash.sortBy(roles2, (role) => role.name?.toUpperCase());
    };
    const [toggleDeleteDialog, DeleteConfirm] = useConfirmDialog({
      titleKey: "clients:clientDeleteConfirmTitle",
      messageKey: "clients:clientDeleteConfirm",
      continueButtonLabel: "common:delete",
      continueButtonVariant: ButtonVariant.danger,
      onConfirm: async () => {
        try {
          await adminClient.clients.del({id: clientId});
          addAlert(t5("clientDeletedSuccess"), AlertVariant.success);
          history.push(toClients({realm: realm2}));
        } catch (error2) {
          addError("clients:clientDeleteError", error2);
        }
      }
    });
    const setupForm = (client22) => {
      convertToFormValues(client22, form2.setValue, ["redirectUris", "webOrigins"]);
    };
    useFetch(() => adminClient.clients.findOne({id: clientId}), (fetchedClient) => {
      if (!fetchedClient) {
        throw new Error(t5("common:notFound"));
      }
      setClient(cloneDeep(fetchedClient));
      setupForm(fetchedClient);
    }, [clientId]);
    const save = async ({confirmed = false, messageKey = "clientSaveSuccess"} = {
      confirmed: false,
      messageKey: "clientSaveSuccess"
    }) => {
      if (await form2.trigger()) {
        if (!client2?.publicClient && client2?.clientAuthenticatorType !== clientAuthenticatorType && !confirmed) {
          toggleChangeAuthenticatorOpen();
          return;
        }
        const submittedClient = convertFormValuesToObject(form2.getValues(), [
          "redirectUris",
          "webOrigins"
        ]);
        try {
          const newClient = {
            ...client2,
            ...submittedClient
          };
          newClient.clientId = newClient.clientId?.trim();
          await adminClient.clients.update({id: clientId}, newClient);
          setupForm(newClient);
          setClient(newClient);
          addAlert(t5(messageKey), AlertVariant.success);
        } catch (error2) {
          addError("clients:clientSaveError", error2);
        }
      }
    };
    const addMappers = async (mappers) => {
      if (!Array.isArray(mappers)) {
        const mapper = mappers;
        history.push(toMapper2({
          realm: realm2,
          id: client2.id,
          mapperId: mapper.id
        }));
      } else {
        try {
          await adminClient.clients.addMultipleProtocolMappers({id: client2.id}, mappers);
          setClient(await adminClient.clients.findOne({id: client2.id}));
          addAlert(t5("common:mappingCreatedSuccess"), AlertVariant.success);
        } catch (error2) {
          addError("common:mappingCreatedError", error2);
        }
      }
    };
    const onDeleteMapper = async (mapper) => {
      try {
        await adminClient.clients.delProtocolMapper({
          id: client2.id,
          mapperId: mapper.id
        });
        setClient({
          ...client2,
          protocolMappers: client2?.protocolMappers?.filter((m2) => m2.id !== mapper.id)
        });
        addAlert(t5("common:mappingDeletedSuccess"), AlertVariant.success);
      } catch (error2) {
        addError("common:mappingDeletedError", error2);
      }
      return true;
    };
    if (!client2) {
      return /* @__PURE__ */ react.createElement(KeycloakSpinner, null);
    }
    return /* @__PURE__ */ react.createElement(react.Fragment, null, /* @__PURE__ */ react.createElement(ConfirmDialogModal, {
      continueButtonLabel: "common:yes",
      titleKey: t5("changeAuthenticatorConfirmTitle", {
        clientAuthenticatorType
      }),
      open: changeAuthenticatorOpen,
      toggleDialog: toggleChangeAuthenticatorOpen,
      onConfirm: () => save({confirmed: true})
    }, /* @__PURE__ */ react.createElement(react.Fragment, null, t5("changeAuthenticatorConfirm", {
      clientAuthenticatorType
    }), clientAuthenticatorType === "client-jwt" && /* @__PURE__ */ react.createElement(Alert, {
      variant: "info",
      isInline: true,
      title: t5("signedJWTConfirm")
    }))), /* @__PURE__ */ react.createElement(DeleteConfirm, null), /* @__PURE__ */ react.createElement(DownloadDialog, {
      id: client2.id,
      protocol: client2.protocol,
      open: downloadDialogOpen,
      toggleDialog: toggleDownloadDialogOpen
    }), /* @__PURE__ */ react.createElement(Controller, {
      name: "enabled",
      control: form2.control,
      defaultValue: true,
      render: ({onChange, value}) => /* @__PURE__ */ react.createElement(ClientDetailHeader, {
        value,
        onChange,
        client: client2,
        save,
        toggleDeleteDialog,
        toggleDownloadDialog: toggleDownloadDialogOpen
      })
    }), /* @__PURE__ */ react.createElement(PageSection, {
      variant: "light",
      className: "pf-u-p-0"
    }, /* @__PURE__ */ react.createElement(FormProvider, {
      ...form2
    }, /* @__PURE__ */ react.createElement(KeycloakTabs, {
      "data-testid": "client-tabs",
      isBox: true
    }, /* @__PURE__ */ react.createElement(Tab, {
      id: "settings",
      eventKey: "settings",
      title: /* @__PURE__ */ react.createElement(TabTitleText, null, t5("common:settings"))
    }, /* @__PURE__ */ react.createElement(ClientSettings, {
      client: client2,
      save: () => save(),
      reset: () => setupForm(client2)
    })), (!client2.publicClient && !isRealmClient(client2) || client2.protocol === "saml") && /* @__PURE__ */ react.createElement(Tab, {
      id: "keys",
      eventKey: "keys",
      title: /* @__PURE__ */ react.createElement(TabTitleText, null, t5("keys"))
    }, client2.protocol === "openid-connect" && /* @__PURE__ */ react.createElement(Keys, {
      clientId,
      save
    }), client2.protocol === "saml" && /* @__PURE__ */ react.createElement(SamlKeys, {
      clientId,
      save
    })), !client2.publicClient && !isRealmClient(client2) && /* @__PURE__ */ react.createElement(Tab, {
      id: "credentials",
      eventKey: "credentials",
      title: /* @__PURE__ */ react.createElement(TabTitleText, null, t5("credentials"))
    }, /* @__PURE__ */ react.createElement(Credentials, {
      clientId,
      save: () => save()
    })), !isRealmClient(client2) && /* @__PURE__ */ react.createElement(Tab, {
      id: "mappers",
      eventKey: "mappers",
      title: /* @__PURE__ */ react.createElement(TabTitleText, null, t5("mappers"))
    }, /* @__PURE__ */ react.createElement(MapperList, {
      model: client2,
      onAdd: addMappers,
      onDelete: onDeleteMapper,
      detailLink: (mapperId) => toMapper2({realm: realm2, id: client2.id, mapperId})
    })), /* @__PURE__ */ react.createElement(Tab, {
      id: "roles",
      eventKey: "roles",
      title: /* @__PURE__ */ react.createElement(TabTitleText, null, t5("roles"))
    }, /* @__PURE__ */ react.createElement(RolesList, {
      loader,
      paginated: false,
      messageBundle: "clients"
    })), !isRealmClient(client2) && /* @__PURE__ */ react.createElement(Tab, {
      id: "clientScopes",
      eventKey: "clientScopes",
      title: /* @__PURE__ */ react.createElement(TabTitleText, null, t5("clientScopes"))
    }, /* @__PURE__ */ react.createElement(Tabs, {
      activeKey: clientScopeSubTab,
      onSelect: (_23, key) => setClientScopeSubTab(key)
    }, /* @__PURE__ */ react.createElement(Tab, {
      id: "setup",
      eventKey: 30,
      title: /* @__PURE__ */ react.createElement(TabTitleText, null, t5("setup"))
    }, /* @__PURE__ */ react.createElement(ClientScopes, {
      clientName: client2.clientId,
      clientId,
      protocol: client2.protocol
    })), /* @__PURE__ */ react.createElement(Tab, {
      id: "evaluate",
      eventKey: 31,
      title: /* @__PURE__ */ react.createElement(TabTitleText, null, t5("evaluate"))
    }, /* @__PURE__ */ react.createElement(EvaluateScopes, {
      clientId,
      protocol: client2.protocol
    })))), client2.serviceAccountsEnabled && /* @__PURE__ */ react.createElement(Tab, {
      id: "authorization",
      eventKey: "authorization",
      title: /* @__PURE__ */ react.createElement(TabTitleText, null, t5("authorization"))
    }, /* @__PURE__ */ react.createElement(Tabs, {
      activeKey: authorizationSubTab,
      onSelect: (_23, key) => setAuthorizationSubTab(key)
    }, /* @__PURE__ */ react.createElement(Tab, {
      id: "settings",
      eventKey: 40,
      title: /* @__PURE__ */ react.createElement(TabTitleText, null, t5("settings"))
    }, /* @__PURE__ */ react.createElement(AuthorizationSettings, {
      clientId
    })), /* @__PURE__ */ react.createElement(Tab, {
      id: "resources",
      eventKey: 41,
      title: /* @__PURE__ */ react.createElement(TabTitleText, null, t5("resources"))
    }, /* @__PURE__ */ react.createElement(AuthorizationResources, {
      clientId
    })))), client2.serviceAccountsEnabled && /* @__PURE__ */ react.createElement(Tab, {
      id: "serviceAccount",
      eventKey: "serviceAccount",
      title: /* @__PURE__ */ react.createElement(TabTitleText, null, t5("serviceAccount"))
    }, /* @__PURE__ */ react.createElement(ServiceAccount, {
      client: client2
    })), /* @__PURE__ */ react.createElement(Tab, {
      id: "advanced",
      eventKey: "advanced",
      title: /* @__PURE__ */ react.createElement(TabTitleText, null, t5("advanced"))
    }, /* @__PURE__ */ react.createElement(AdvancedTab, {
      save,
      client: client2
    }))))));
  }
});

// build/clients/add/NewClientForm.js
var require_NewClientForm = __commonJS((exports2) => {
  __markAsModule(exports2);
  __export(exports2, {
    default: () => NewClientForm
  });
  function NewClientForm() {
    const {t: t5} = useTranslation("clients");
    const {realm: realm2} = useRealm();
    const adminClient = useAdminClient();
    const history = useHistory();
    const [showCapabilityConfig, setShowCapabilityConfig] = useState(false);
    const [client2, setClient] = useState({
      protocol: "openid-connect",
      clientId: "",
      name: "",
      description: "",
      publicClient: true,
      authorizationServicesEnabled: false,
      serviceAccountsEnabled: false,
      implicitFlowEnabled: false,
      directAccessGrantsEnabled: true,
      standardFlowEnabled: true
    });
    const {addAlert, addError} = useAlerts();
    const methods = useForm({defaultValues: client2});
    const save = async () => {
      try {
        const newClient = await adminClient.clients.create({
          ...convertFormValuesToObject(client2),
          clientId: client2.clientId?.trim()
        });
        addAlert(t5("createSuccess"), AlertVariant.success);
        history.push(toClient({realm: realm2, clientId: newClient.id, tab: "settings"}));
      } catch (error2) {
        addError("clients:createError", error2);
      }
    };
    const forward = async (onNext) => {
      if (await methods.trigger()) {
        setClient({
          ...client2,
          ...convertFormValuesToObject(methods.getValues())
        });
        setShowCapabilityConfig(true);
        onNext?.();
      }
    };
    const back = () => {
      setClient({...client2, ...convertFormValuesToObject(methods.getValues())});
      methods.reset({
        ...client2,
        ...convertFormValuesToObject(methods.getValues())
      });
    };
    const onGoToStep = (newStep) => {
      if (newStep.id === "generalSettings") {
        back();
      } else {
        forward();
      }
    };
    const Footer = () => /* @__PURE__ */ react.createElement(WizardFooter, null, /* @__PURE__ */ react.createElement(WizardContextConsumer, null, ({activeStep, onNext, onBack, onClose}) => {
      return /* @__PURE__ */ react.createElement(react.Fragment, null, /* @__PURE__ */ react.createElement(Button, {
        variant: "primary",
        type: "submit",
        onClick: () => {
          forward(onNext);
        }
      }, activeStep.name === t5("capabilityConfig") ? t5("common:save") : t5("common:next")), /* @__PURE__ */ react.createElement(Button, {
        variant: "secondary",
        onClick: () => {
          back();
          onBack();
        },
        isDisabled: activeStep.name === t5("generalSettings")
      }, t5("common:back")), /* @__PURE__ */ react.createElement(Button, {
        variant: "link",
        onClick: onClose
      }, t5("common:cancel")));
    }));
    const title3 = t5("createClient");
    return /* @__PURE__ */ react.createElement(react.Fragment, null, /* @__PURE__ */ react.createElement(ViewHeader, {
      titleKey: "clients:createClient",
      subKey: "clients:clientsExplain"
    }), /* @__PURE__ */ react.createElement(PageSection, {
      variant: "light"
    }, /* @__PURE__ */ react.createElement(FormProvider, {
      ...methods
    }, /* @__PURE__ */ react.createElement(Wizard, {
      onClose: () => history.push(toClients({realm: realm2})),
      navAriaLabel: `${title3} steps`,
      mainAriaLabel: `${title3} content`,
      steps: [
        {
          id: "generalSettings",
          name: t5("generalSettings"),
          component: /* @__PURE__ */ react.createElement(GeneralSettings, null)
        },
        ...showCapabilityConfig ? [
          {
            id: "capabilityConfig",
            name: t5("capabilityConfig"),
            component: /* @__PURE__ */ react.createElement(CapabilityConfig, {
              protocol: client2.protocol
            })
          }
        ] : []
      ],
      footer: /* @__PURE__ */ react.createElement(Footer, null),
      onSave: save,
      onGoToStep
    }))));
  }
});

// build/identity-providers/add/AddMapper.js
var require_AddMapper = __commonJS((exports2) => {
  __markAsModule(exports2);
  __export(exports2, {
    default: () => AddMapper
  });
  function AddMapper() {
    const {t: t5} = useTranslation("identity-providers");
    const form2 = useForm();
    const {handleSubmit, control, register: register2, errors} = form2;
    const {addAlert, addError} = useAlerts();
    const history = useHistory();
    const {realm: realm2} = useRealm();
    const adminClient = useAdminClient();
    const {providerId, alias} = useParams();
    const {id: id3} = useParams();
    const serverInfo2 = useServerInfo();
    const identityProviders2 = useMemo(() => groupBy(serverInfo2.identityProviders, "groupName"), [serverInfo2]);
    const isSocialIdP = useMemo(() => identityProviders2["Social"].map((item) => item.id).includes(providerId.toLowerCase()), [identityProviders2, providerId]);
    const [mapperTypes, setMapperTypes] = useState();
    const [mapperType, setMapperType] = useState(isSocialIdP ? "attributeImporter" : providerId === "saml" ? "advancedAttributeToRole" : "hardcodedUserSessionAttribute");
    const [currentMapper, setCurrentMapper] = useState();
    const [rolesModalOpen, setRolesModalOpen] = useState(false);
    const save = async (idpMapper) => {
      const attributes = JSON.stringify(idpMapper.config?.attributes ?? []);
      const mapper = convertFormValuesToObject(idpMapper);
      if (id3) {
        const updatedMapper = {
          ...mapper,
          config: {
            attributes
          },
          identityProviderAlias: alias,
          id: id3,
          name: currentMapper?.name
        };
        try {
          await adminClient.identityProviders.updateMapper({
            id: id3,
            alias
          }, updatedMapper);
          addAlert(t5("mapperSaveSuccess"), AlertVariant.success);
        } catch (error2) {
          addError(t5("mapperSaveError"), error2);
        }
      } else {
        try {
          const createdMapper = await adminClient.identityProviders.createMapper({
            identityProviderMapper: {
              ...mapper,
              identityProviderAlias: alias,
              config: {
                attributes
              }
            },
            alias
          });
          addAlert(t5("mapperCreateSuccess"), AlertVariant.success);
          history.push(toIdentityProviderEditMapper({
            realm: realm2,
            alias,
            providerId,
            id: createdMapper.id
          }));
        } catch (error2) {
          addError(t5("mapperCreateError"), error2);
        }
      }
    };
    useFetch(() => Promise.all([
      id3 ? adminClient.identityProviders.findOneMapper({alias, id: id3}) : null,
      adminClient.identityProviders.findMapperTypes({alias})
    ]), ([mapper, mapperTypes2]) => {
      if (mapper) {
        setCurrentMapper(mapper);
        setupForm(mapper);
      }
      setMapperTypes(mapperTypes2);
    }, []);
    const setupForm = (mapper) => {
      form2.reset();
      convertToFormValues(mapper, form2.setValue);
      form2.setValue("config.attributes", JSON.parse(mapper.config.attributes));
    };
    const targetOptions = ["local", "brokerId", "brokerUsername"];
    const [targetOptionsOpen, setTargetOptionsOpen] = useState(false);
    const [selectedRole, setSelectedRole] = useState([]);
    const formValues = form2.getValues();
    const isSAMLAdvancedAttrToRole = formValues.identityProviderMapper === "saml-advanced-role-idp-mapper";
    const isOIDCclaimToRole = formValues.identityProviderMapper === "oidc-role-idp-mapper";
    const isOIDCAdvancedClaimToRole = formValues.identityProviderMapper === "oidc-advanced-role-idp-mapper";
    const isSAMLAttributeImporter = formValues.identityProviderMapper === "saml-user-attribute-idp-mapper";
    const isOIDCAttributeImporter = formValues.identityProviderMapper === "oidc-user-attribute-idp-mapper";
    const isHardcodedAttribute = formValues.identityProviderMapper === "hardcoded-attribute-idp-mapper";
    const isHardcodedRole = formValues.identityProviderMapper === "oidc-hardcoded-role-idp-mapper";
    const isHardcodedUserSessionAttribute = formValues.identityProviderMapper === "hardcoded-user-session-attribute-idp-mapper";
    const isSAMLAttributeToRole = formValues.identityProviderMapper === "saml-role-idp-mapper";
    const isSAMLUsernameTemplateImporter = formValues.identityProviderMapper === "saml-username-idp-mapper";
    const isOIDCUsernameTemplateImporter = formValues.identityProviderMapper === "oidc-username-idp-mapper";
    const isSocialAttributeImporter = useMemo(() => formValues.identityProviderMapper?.includes("user-attribute-mapper"), [formValues.identityProviderMapper]);
    const toggleModal = () => {
      setRolesModalOpen(!rolesModalOpen);
    };
    return /* @__PURE__ */ react.createElement(PageSection, {
      variant: "light"
    }, /* @__PURE__ */ react.createElement(ViewHeader, {
      className: "kc-add-mapper-title",
      titleKey: id3 ? t5("editIdPMapper", {
        providerId: providerId[0].toUpperCase() + providerId.substring(1)
      }) : t5("addIdPMapper", {
        providerId: providerId[0].toUpperCase() + providerId.substring(1)
      }),
      divider: true
    }), rolesModalOpen && /* @__PURE__ */ react.createElement(AssociatedRolesModal, {
      id: id3,
      onConfirm: (role) => setSelectedRole(role),
      omitComposites: true,
      isRadio: true,
      isMapperId: true,
      toggleDialog: toggleModal
    }), /* @__PURE__ */ react.createElement(FormAccess, {
      role: "manage-identity-providers",
      isHorizontal: true,
      onSubmit: handleSubmit(save),
      className: "pf-u-mt-lg"
    }, id3 && /* @__PURE__ */ react.createElement(FormGroup, {
      label: t5("common:id"),
      fieldId: "kc-mapper-id",
      validated: errors.name ? ValidatedOptions.error : ValidatedOptions.default,
      helperTextInvalid: t5("common:required")
    }, /* @__PURE__ */ react.createElement(TextInput, {
      ref: register2(),
      type: "text",
      value: currentMapper?.id,
      "datatest-id": "name-input",
      id: "kc-name",
      name: "name",
      isDisabled: !!id3,
      validated: errors.name ? ValidatedOptions.error : ValidatedOptions.default
    })), /* @__PURE__ */ react.createElement(AddMapperForm, {
      form: form2,
      id: id3,
      mapperTypes,
      updateMapperType: setMapperType,
      formValues,
      mapperType,
      isSocialIdP
    }), /* @__PURE__ */ react.createElement(react.Fragment, null, (isSAMLAdvancedAttrToRole || isOIDCAdvancedClaimToRole) && /* @__PURE__ */ react.createElement(react.Fragment, null, /* @__PURE__ */ react.createElement(FormGroup, {
      label: isSAMLAdvancedAttrToRole ? t5("common:attributes") : t5("claims"),
      labelIcon: /* @__PURE__ */ react.createElement(HelpItem, {
        helpText: isSAMLAdvancedAttrToRole ? "identity-providers-help:attributes" : "identity-providers-help:claims",
        forLabel: isSAMLAdvancedAttrToRole ? t5("common:attributes") : t5("common:claims"),
        forID: isSAMLAdvancedAttrToRole ? t5(`common:helpLabel`, {
          label: t5("attributes")
        }) : t5(`common:helpLabel`, {
          label: t5("claim")
        })
      }),
      fieldId: "kc-gui-order"
    }, /* @__PURE__ */ react.createElement(FormProvider, {
      ...form2
    }, /* @__PURE__ */ react.createElement(AttributeInput, {
      name: "config.attributes"
    }))), /* @__PURE__ */ react.createElement(FormGroup, {
      label: isSAMLAdvancedAttrToRole ? t5("regexAttributeValues") : t5("regexClaimValues"),
      labelIcon: /* @__PURE__ */ react.createElement(HelpItem, {
        helpText: "identity-providers-help:regexAttributeValues",
        forLabel: t5("regexAttributeValues"),
        forID: t5(`common:helpLabel`, {
          label: t5("regexAttributeValues")
        })
      }),
      fieldId: "regexAttributeValues"
    }, /* @__PURE__ */ react.createElement(Controller, {
      name: isOIDCAdvancedClaimToRole ? "config.are.claim.values.regex" : "config.are.attribute.values.regex",
      control,
      defaultValue: "false",
      render: ({onChange, value}) => /* @__PURE__ */ react.createElement(Switch, {
        id: "regexValues",
        "data-testid": "regex-values-switch",
        label: t5("common:on"),
        labelOff: t5("common:off"),
        isChecked: value === "true",
        onChange: (value2) => onChange("" + value2)
      })
    }))), (isSAMLUsernameTemplateImporter || isOIDCUsernameTemplateImporter) && /* @__PURE__ */ react.createElement(react.Fragment, null, /* @__PURE__ */ react.createElement(FormGroup, {
      label: t5("template"),
      labelIcon: /* @__PURE__ */ react.createElement(HelpItem, {
        id: "target-help-icon",
        helpText: "identity-providers-help:template",
        forLabel: t5("template"),
        forID: t5(`common:helpLabel`, {
          label: t5("template")
        })
      }),
      fieldId: "kc-user-session-attribute",
      validated: errors.name ? ValidatedOptions.error : ValidatedOptions.default,
      helperTextInvalid: t5("common:required")
    }, /* @__PURE__ */ react.createElement(TextInput, {
      ref: register2(),
      type: "text",
      id: "kc-template",
      "data-testid": "template",
      name: "config.template",
      defaultValue: currentMapper?.config.template,
      validated: errors.name ? ValidatedOptions.error : ValidatedOptions.default
    })), /* @__PURE__ */ react.createElement(FormGroup, {
      label: t5("target"),
      labelIcon: /* @__PURE__ */ react.createElement(HelpItem, {
        id: "user-session-attribute-help-icon",
        helpText: "identity-providers-help:target",
        forLabel: t5("target"),
        forID: t5(`common:helpLabel`, {
          label: t5("target")
        })
      }),
      fieldId: "kc-target",
      validated: errors.name ? ValidatedOptions.error : ValidatedOptions.default,
      helperTextInvalid: t5("common:required")
    }, /* @__PURE__ */ react.createElement(Controller, {
      name: "config.target",
      defaultValue: currentMapper?.config.target,
      control,
      render: ({onChange, value}) => /* @__PURE__ */ react.createElement(Select, {
        toggleId: "target",
        "datatest-id": "target-select",
        id: "target-dropdown",
        placeholderText: t5("realm-settings:placeholderText"),
        direction: "down",
        onToggle: () => setTargetOptionsOpen(!targetOptionsOpen),
        onSelect: (_23, value2) => {
          onChange(t5(`targetOptions.${value2}`));
          setTargetOptionsOpen(false);
        },
        selections: value,
        variant: SelectVariant.single,
        "aria-label": t5("target"),
        isOpen: targetOptionsOpen
      }, targetOptions.map((option) => /* @__PURE__ */ react.createElement(SelectOption, {
        selected: option === value,
        key: option,
        "data-testid": option,
        value: option
      }, t5(`targetOptions.${option}`))))
    }))), (isHardcodedAttribute || isHardcodedUserSessionAttribute) && /* @__PURE__ */ react.createElement(react.Fragment, null, /* @__PURE__ */ react.createElement(FormGroup, {
      label: isHardcodedUserSessionAttribute ? t5("userSessionAttribute") : t5("userAttribute"),
      labelIcon: /* @__PURE__ */ react.createElement(HelpItem, {
        id: "user-session-attribute-help-icon",
        helpText: "identity-providers-help:userSessionAttribute",
        forLabel: t5("userSessionAttribute"),
        forID: t5(`common:helpLabel`, {
          label: t5("userSessionAttribute")
        })
      }),
      fieldId: "kc-user-session-attribute",
      validated: errors.name ? ValidatedOptions.error : ValidatedOptions.default,
      helperTextInvalid: t5("common:required")
    }, /* @__PURE__ */ react.createElement(TextInput, {
      ref: register2(),
      type: "text",
      defaultValue: currentMapper?.config.attribute,
      id: "kc-attribute",
      "data-testid": isHardcodedUserSessionAttribute ? "user-session-attribute" : "user-attribute",
      name: "config.attribute",
      validated: errors.name ? ValidatedOptions.error : ValidatedOptions.default
    })), /* @__PURE__ */ react.createElement(FormGroup, {
      label: isHardcodedUserSessionAttribute ? t5("userSessionAttributeValue") : t5("userAttributeValue"),
      labelIcon: /* @__PURE__ */ react.createElement(HelpItem, {
        id: "user-session-attribute-value-help-icon",
        helpText: "identity-providers-help:userAttributeValue",
        forLabel: isHardcodedUserSessionAttribute ? t5("userSessionAttributeValue") : t5("userAttributeValue"),
        forID: t5(`common:helpLabel`, {
          label: isHardcodedUserSessionAttribute ? t5("userSessionAttributeValue") : t5("userAttributeValue")
        })
      }),
      fieldId: "kc-user-session-attribute-value",
      validated: errors.name ? ValidatedOptions.error : ValidatedOptions.default,
      helperTextInvalid: t5("common:required")
    }, /* @__PURE__ */ react.createElement(TextInput, {
      ref: register2(),
      type: "text",
      defaultValue: currentMapper?.config["attribute.value"],
      "data-testid": isHardcodedUserSessionAttribute ? "user-session-attribute-value" : "user-attribute-value",
      id: "kc-user-session-attribute-value",
      name: "config.attribute.value",
      validated: errors.name ? ValidatedOptions.error : ValidatedOptions.default
    }))), (isSAMLAttributeImporter || isOIDCAttributeImporter || isOIDCclaimToRole) && /* @__PURE__ */ react.createElement(react.Fragment, null, isSAMLAttributeImporter ? /* @__PURE__ */ react.createElement(react.Fragment, null, /* @__PURE__ */ react.createElement(FormGroup, {
      label: t5("mapperAttributeName"),
      labelIcon: /* @__PURE__ */ react.createElement(HelpItem, {
        id: "user-session-attribute-help-icon",
        helpText: "identity-providers-help:attributeName",
        forLabel: t5("mapperAttributeName"),
        forID: t5(`common:helpLabel`, {
          label: t5("mapperAttributeName")
        })
      }),
      fieldId: "kc-attribute-name",
      validated: errors.name ? ValidatedOptions.error : ValidatedOptions.default,
      helperTextInvalid: t5("common:required")
    }, /* @__PURE__ */ react.createElement(TextInput, {
      ref: register2(),
      type: "text",
      defaultValue: currentMapper?.config["attribute.name"],
      id: "kc-attribute-name",
      "data-testid": "attribute-name",
      name: "config.attribute.name",
      validated: errors.name ? ValidatedOptions.error : ValidatedOptions.default
    })), /* @__PURE__ */ react.createElement(FormGroup, {
      label: t5("mapperAttributeFriendlyName"),
      labelIcon: /* @__PURE__ */ react.createElement(HelpItem, {
        id: "mapper-attribute-friendly-name",
        helpText: "identity-providers-help:friendlyName",
        forLabel: t5("mapperAttributeFriendlyName"),
        forID: t5(`common:helpLabel`, {
          label: t5("mapperAttributeFriendlyName")
        })
      }),
      fieldId: "kc-friendly-name",
      validated: errors.name ? ValidatedOptions.error : ValidatedOptions.default,
      helperTextInvalid: t5("common:required")
    }, /* @__PURE__ */ react.createElement(TextInput, {
      ref: register2(),
      type: "text",
      defaultValue: currentMapper?.config["attribute.friendly.name"],
      "data-testid": "attribute-friendly-name",
      id: "kc-attribute-friendly-name",
      name: "config.attribute.friendly.name",
      validated: errors.name ? ValidatedOptions.error : ValidatedOptions.default
    }))) : /* @__PURE__ */ react.createElement(FormGroup, {
      label: t5("claim"),
      labelIcon: /* @__PURE__ */ react.createElement(HelpItem, {
        id: "claim",
        helpText: "identity-providers-help:claim",
        forLabel: t5("claim"),
        forID: t5(`common:helpLabel`, {
          label: t5("claim")
        })
      }),
      fieldId: "kc-friendly-name",
      validated: errors.name ? ValidatedOptions.error : ValidatedOptions.default,
      helperTextInvalid: t5("common:required")
    }, /* @__PURE__ */ react.createElement(TextInput, {
      ref: register2(),
      type: "text",
      defaultValue: currentMapper?.config["claim"],
      "data-testid": "claim",
      id: "kc-claim",
      name: "config.claim",
      validated: errors.name ? ValidatedOptions.error : ValidatedOptions.default
    })), /* @__PURE__ */ react.createElement(FormGroup, {
      label: isOIDCclaimToRole ? t5("claimValue") : t5("mapperUserAttributeName"),
      labelIcon: /* @__PURE__ */ react.createElement(HelpItem, {
        id: isOIDCclaimToRole ? "claim-value-help-icon" : "user-attribute-name-help-icon",
        helpText: isOIDCclaimToRole ? "identity-providers-help:claimValue" : "identity-providers-help:userAttributeName",
        forLabel: t5("mapperUserAttributeName"),
        forID: t5(`common:helpLabel`, {
          label: t5("mapperUserAttributeName")
        })
      }),
      fieldId: "kc-user-attribute-name",
      validated: errors.name ? ValidatedOptions.error : ValidatedOptions.default,
      helperTextInvalid: t5("common:required")
    }, /* @__PURE__ */ react.createElement(TextInput, {
      ref: register2(),
      type: "text",
      defaultValue: isOIDCclaimToRole ? currentMapper?.config["claim.value"] : currentMapper?.config["attribute.value"],
      "data-testid": isOIDCclaimToRole ? "claim.value" : "user-attribute-name",
      id: isOIDCclaimToRole ? "kc-claim-value" : "kc-user-attribute-name",
      name: isOIDCclaimToRole ? "config.claim" : "config.user.attribute",
      validated: errors.name ? ValidatedOptions.error : ValidatedOptions.default
    }))), isSocialAttributeImporter && /* @__PURE__ */ react.createElement(react.Fragment, null, /* @__PURE__ */ react.createElement(FormGroup, {
      label: t5("socialProfileJSONFieldPath"),
      labelIcon: /* @__PURE__ */ react.createElement(HelpItem, {
        id: "social-profile-JSON-field-path-help-icon",
        helpText: "identity-providers-help:socialProfileJSONFieldPath",
        forLabel: t5("socialProfileJSONFieldPath"),
        forID: t5(`common:helpLabel`, {
          label: t5("socialProfileJSONFieldPath")
        })
      }),
      fieldId: "kc-social-profile-JSON-field-path",
      validated: errors.name ? ValidatedOptions.error : ValidatedOptions.default,
      helperTextInvalid: t5("common:required")
    }, /* @__PURE__ */ react.createElement(TextInput, {
      ref: register2(),
      type: "text",
      defaultValue: currentMapper?.config.attribute,
      id: "kc-social-profile-JSON-field-path",
      "data-testid": "social-profile-JSON-field-path",
      name: "config.jsonField",
      validated: errors.config?.role ? ValidatedOptions.error : ValidatedOptions.default
    })), /* @__PURE__ */ react.createElement(FormGroup, {
      label: t5("mapperUserAttributeName"),
      labelIcon: /* @__PURE__ */ react.createElement(HelpItem, {
        id: "user-attribute-name-help-icon",
        helpText: "identity-providers-help:socialUserAttributeName",
        forLabel: t5("mapperUserAttributeName"),
        forID: t5(`common:helpLabel`, {
          label: t5("mapperUserAttributeName")
        })
      }),
      fieldId: "kc-user-session-attribute-value",
      validated: errors.name ? ValidatedOptions.error : ValidatedOptions.default,
      helperTextInvalid: t5("common:required")
    }, /* @__PURE__ */ react.createElement(TextInput, {
      ref: register2(),
      type: "text",
      defaultValue: currentMapper?.config.userAttribute,
      "data-testid": "user-attribute-name",
      id: "kc-user-session-attribute-name",
      name: "config.userAttribute",
      validated: errors.name ? ValidatedOptions.error : ValidatedOptions.default
    }))), (isSAMLAdvancedAttrToRole || isHardcodedRole || isSAMLAttributeToRole || isOIDCAdvancedClaimToRole || isOIDCclaimToRole) && /* @__PURE__ */ react.createElement(FormGroup, {
      label: t5("common:role"),
      labelIcon: /* @__PURE__ */ react.createElement(HelpItem, {
        id: "name-help-icon",
        helpText: "identity-providers-help:role",
        forLabel: t5("identity-providers-help:role"),
        forID: t5(`identity-providers:helpLabel`, {
          label: t5("role")
        })
      }),
      fieldId: "kc-role",
      validated: errors.config?.role ? ValidatedOptions.error : ValidatedOptions.default,
      helperTextInvalid: t5("common:required")
    }, /* @__PURE__ */ react.createElement(TextInput, {
      ref: register2(),
      type: "text",
      id: "kc-role",
      "data-testid": "mapper-role-input",
      name: "config.role",
      isDisabled: !!id3,
      value: selectedRole[0]?.clientRole ? `${selectedRole[0].clientId}.${selectedRole[0]?.name}` : selectedRole[0]?.name,
      validated: errors.config?.role ? ValidatedOptions.error : ValidatedOptions.default
    }), /* @__PURE__ */ react.createElement(Button, {
      "data-testid": "select-role-button",
      onClick: () => toggleModal(),
      isDisabled: !!id3
    }, t5("selectRole")))), /* @__PURE__ */ react.createElement(ActionGroup, null, /* @__PURE__ */ react.createElement(Button, {
      "data-testid": "new-mapper-save-button",
      variant: "primary",
      type: "submit"
    }, t5("common:save")), /* @__PURE__ */ react.createElement(Button, {
      variant: "link",
      component: (props) => /* @__PURE__ */ react.createElement(Link, {
        ...props,
        to: toIdentityProvider({
          realm: realm2,
          providerId,
          alias,
          tab: "settings"
        })
      })
    }, t5("common:cancel")))));
  }
});

// build/identity-providers/add/AddIdentityProvider.js
var require_AddIdentityProvider = __commonJS((exports2) => {
  __markAsModule(exports2);
  __export(exports2, {
    default: () => AddIdentityProvider
  });
  function AddIdentityProvider() {
    const {t: t5} = useTranslation("identity-providers");
    const {providerId} = useParams();
    const form2 = useForm();
    const {
      handleSubmit,
      formState: {isDirty}
    } = form2;
    const adminClient = useAdminClient();
    const {addAlert, addError} = useAlerts();
    const history = useHistory();
    const {realm: realm2} = useRealm();
    const save = async (provider) => {
      try {
        await adminClient.identityProviders.create({
          ...provider,
          providerId,
          alias: providerId
        });
        addAlert(t5("createSuccess"), AlertVariant.success);
        history.push(toIdentityProvider({
          realm: realm2,
          providerId,
          alias: providerId,
          tab: "settings"
        }));
      } catch (error2) {
        addError("identity-providers:createError", error2);
      }
    };
    return /* @__PURE__ */ react.createElement(react.Fragment, null, /* @__PURE__ */ react.createElement(ViewHeader, {
      titleKey: t5("addIdentityProvider", {
        provider: toUpperCase(providerId)
      })
    }), /* @__PURE__ */ react.createElement(PageSection, {
      variant: "light"
    }, /* @__PURE__ */ react.createElement(FormAccess, {
      role: "manage-identity-providers",
      isHorizontal: true,
      onSubmit: handleSubmit(save)
    }, /* @__PURE__ */ react.createElement(FormProvider, {
      ...form2
    }, /* @__PURE__ */ react.createElement(GeneralSettings2, {
      id: providerId
    })), /* @__PURE__ */ react.createElement(ActionGroup, null, /* @__PURE__ */ react.createElement(Button, {
      isDisabled: !isDirty,
      variant: "primary",
      type: "submit",
      "data-testid": "createProvider"
    }, t5("common:add")), /* @__PURE__ */ react.createElement(Button, {
      variant: "link",
      "data-testid": "cancel",
      component: (props) => /* @__PURE__ */ react.createElement(Link, {
        ...props,
        to: toIdentityProviders({realm: realm2})
      })
    }, t5("common:cancel"))))));
  }
});

// build/identity-providers/IdentityProvidersSection.js
var require_IdentityProvidersSection = __commonJS((exports2) => {
  __markAsModule(exports2);
  __export(exports2, {
    default: () => IdentityProvidersSection
  });
  function IdentityProvidersSection() {
    const {t: t5} = useTranslation("identity-providers");
    const identityProviders2 = lodash.groupBy(useServerInfo().identityProviders, "groupName");
    const {realm: realm2} = useRealm();
    const history = useHistory();
    const [key, setKey] = useState(0);
    const refresh = () => setKey(new Date().getTime());
    const [addProviderOpen, setAddProviderOpen] = useState(false);
    const [manageDisplayDialog, setManageDisplayDialog] = useState(false);
    const [providers, setProviders] = useState();
    const [selectedProvider, setSelectedProvider] = useState();
    const adminClient = useAdminClient();
    const {addAlert, addError} = useAlerts();
    useFetch(async () => {
      const provider = await adminClient.realms.findOne({realm: realm2});
      if (!provider) {
        throw new Error(t5("common:notFound"));
      }
      return provider.identityProviders;
    }, (providers2) => {
      setProviders(providers2);
    }, []);
    const loader = () => Promise.resolve(lodash.sortBy(providers, "alias"));
    const DetailLink = (identityProvider) => /* @__PURE__ */ react.createElement(Link, {
      key: identityProvider.providerId,
      to: toIdentityProvider({
        realm: realm2,
        providerId: identityProvider.providerId,
        alias: identityProvider.alias,
        tab: "settings"
      })
    }, identityProvider.displayName ? identityProvider.displayName : identityProvider.alias, !identityProvider.enabled && /* @__PURE__ */ react.createElement(Badge, {
      key: `${identityProvider.providerId}-disabled`,
      isRead: true,
      className: "pf-u-ml-sm"
    }, t5("common:disabled")));
    const navigateToCreate = (providerId) => history.push(toIdentityProviderCreate({
      realm: realm2,
      providerId
    }));
    const identityProviderOptions = () => Object.keys(identityProviders2).map((group) => /* @__PURE__ */ react.createElement(DropdownGroup, {
      key: group,
      label: group
    }, lodash.sortBy(identityProviders2[group], "name").map((provider) => /* @__PURE__ */ react.createElement(DropdownItem, {
      key: provider.id,
      value: provider.id,
      component: /* @__PURE__ */ react.createElement(Link, {
        to: toIdentityProviderCreate({
          realm: realm2,
          providerId: provider.id
        }),
        "data-testid": provider.id
      }, provider.name)
    }))));
    const [toggleDeleteDialog, DeleteConfirm] = useConfirmDialog({
      titleKey: "identity-providers:deleteProvider",
      messageKey: t5("deleteConfirm", {provider: selectedProvider?.alias}),
      continueButtonLabel: "common:delete",
      continueButtonVariant: ButtonVariant.danger,
      onConfirm: async () => {
        try {
          await adminClient.identityProviders.del({
            alias: selectedProvider.alias
          });
          setProviders([
            ...providers.filter((p2) => p2.alias !== selectedProvider?.alias)
          ]);
          refresh();
          addAlert(t5("deletedSuccess"), AlertVariant.success);
        } catch (error2) {
          addError("identity-providers:deleteError", error2);
        }
      }
    });
    if (!providers) {
      return /* @__PURE__ */ react.createElement(Spinner, null);
    }
    return /* @__PURE__ */ react.createElement(react.Fragment, null, /* @__PURE__ */ react.createElement(DeleteConfirm, null), manageDisplayDialog && /* @__PURE__ */ react.createElement(ManageOderDialog, {
      onClose: () => setManageDisplayDialog(false),
      providers: providers.filter((p2) => p2.enabled)
    }), /* @__PURE__ */ react.createElement(ViewHeader, {
      titleKey: "common:identityProviders",
      subKey: "identity-providers:listExplain"
    }), /* @__PURE__ */ react.createElement(PageSection, {
      variant: providers.length === 0 ? "default" : "light",
      className: providers.length === 0 ? "" : "pf-u-p-0"
    }, providers.length === 0 && /* @__PURE__ */ react.createElement(react.Fragment, null, /* @__PURE__ */ react.createElement(TextContent, null, /* @__PURE__ */ react.createElement(Text, {
      component: TextVariants.p
    }, t5("getStarted"))), Object.keys(identityProviders2).map((group) => /* @__PURE__ */ react.createElement(Fragment, {
      key: group
    }, /* @__PURE__ */ react.createElement(TextContent, null, /* @__PURE__ */ react.createElement(Text, {
      className: "pf-u-mt-lg",
      component: TextVariants.h2
    }, group, ":")), /* @__PURE__ */ react.createElement("hr", {
      className: "pf-u-mb-lg"
    }), /* @__PURE__ */ react.createElement(Gallery, {
      hasGutter: true
    }, lodash.sortBy(identityProviders2[group], "name").map((provider) => /* @__PURE__ */ react.createElement(Card, {
      className: "keycloak-empty-state-card",
      key: provider.id,
      isHoverable: true,
      "data-testid": `${provider.id}-card`,
      onClick: () => navigateToCreate(provider.id)
    }, /* @__PURE__ */ react.createElement(CardTitle, null, /* @__PURE__ */ react.createElement(Split, {
      hasGutter: true
    }, /* @__PURE__ */ react.createElement(SplitItem, null, /* @__PURE__ */ react.createElement(ProviderIconMapper, {
      provider
    })), /* @__PURE__ */ react.createElement(SplitItem, {
      isFilled: true
    }, provider.name))))))))), providers.length !== 0 && /* @__PURE__ */ react.createElement(KeycloakDataTable, {
      key,
      loader,
      ariaLabelKey: "common:identityProviders",
      searchPlaceholderKey: "identity-providers:searchForProvider",
      toolbarItem: /* @__PURE__ */ react.createElement(react.Fragment, null, /* @__PURE__ */ react.createElement(ToolbarItem, null, /* @__PURE__ */ react.createElement(Dropdown, {
        "data-testid": "addProviderDropdown",
        toggle: /* @__PURE__ */ react.createElement(DropdownToggle, {
          onToggle: () => setAddProviderOpen(!addProviderOpen),
          isPrimary: true
        }, t5("addProvider")),
        isOpen: addProviderOpen,
        dropdownItems: identityProviderOptions()
      })), /* @__PURE__ */ react.createElement(ToolbarItem, null, /* @__PURE__ */ react.createElement(Button, {
        "data-testid": "manageDisplayOrder",
        variant: "link",
        onClick: () => setManageDisplayDialog(true)
      }, t5("manageDisplayOrder")))),
      actions: [
        {
          title: t5("common:delete"),
          onRowClick: (provider) => {
            setSelectedProvider(provider);
            toggleDeleteDialog();
          }
        }
      ],
      columns: [
        {
          name: "alias",
          displayKey: "common:name",
          cellRenderer: DetailLink
        },
        {
          name: "providerId",
          displayKey: "identity-providers:providerDetails",
          cellFormatters: [upperCaseFormatter()]
        }
      ]
    })));
  }
});

// build/identity-providers/add/DetailSettings.js
var require_DetailSettings = __commonJS((exports2) => {
  __markAsModule(exports2);
  __export(exports2, {
    default: () => DetailSettings
  });
  var Header3 = ({onChange, value, save, toggleDeleteDialog}) => {
    const {t: t5} = useTranslation("identity-providers");
    const {alias} = useParams();
    const [toggleDisableDialog, DisableConfirm] = useConfirmDialog({
      titleKey: "identity-providers:disableProvider",
      messageKey: t5("disableConfirm", {provider: alias}),
      continueButtonLabel: "common:disable",
      onConfirm: () => {
        onChange(!value);
        save();
      }
    });
    return /* @__PURE__ */ react.createElement(react.Fragment, null, /* @__PURE__ */ react.createElement(DisableConfirm, null), /* @__PURE__ */ react.createElement(ViewHeader, {
      titleKey: toUpperCase(alias),
      divider: false,
      dropdownItems: [
        /* @__PURE__ */ react.createElement(DropdownItem, {
          key: "delete",
          onClick: () => toggleDeleteDialog()
        }, t5("common:delete"))
      ],
      isEnabled: value,
      onToggle: (value2) => {
        if (!value2) {
          toggleDisableDialog();
        } else {
          onChange(value2);
          save();
        }
      }
    }));
  };
  function DetailSettings() {
    const {t: t5} = useTranslation("identity-providers");
    const {alias, providerId} = useParams();
    const form2 = useForm();
    const {handleSubmit, getValues, reset: reset2} = form2;
    const [provider, setProvider] = useState();
    const [selectedMapper, setSelectedMapper] = useState();
    const adminClient = useAdminClient();
    const {addAlert, addError} = useAlerts();
    const history = useHistory();
    const {realm: realm2} = useRealm();
    const [key, setKey] = useState(0);
    const refresh = () => setKey(key + 1);
    const MapperLink = ({name, mapperId}) => /* @__PURE__ */ react.createElement(Link, {
      to: toIdentityProviderEditMapper({
        realm: realm2,
        alias,
        providerId: provider?.providerId,
        id: mapperId
      })
    }, name);
    useFetch(() => adminClient.identityProviders.findOne({alias}), (fetchedProvider) => {
      if (!fetchedProvider) {
        throw new Error(t5("common:notFound"));
      }
      reset2(fetchedProvider);
      setProvider(fetchedProvider);
    }, []);
    const save = async (provider2) => {
      const p2 = provider2 || getValues();
      try {
        await adminClient.identityProviders.update({alias}, {...p2, alias, providerId});
        addAlert(t5("updateSuccess"), AlertVariant.success);
      } catch (error2) {
        addError("identity-providers:updateError", error2);
      }
    };
    const [toggleDeleteDialog, DeleteConfirm] = useConfirmDialog({
      titleKey: "identity-providers:deleteProvider",
      messageKey: t5("identity-providers:deleteConfirm", {provider: alias}),
      continueButtonLabel: "common:delete",
      continueButtonVariant: ButtonVariant.danger,
      onConfirm: async () => {
        try {
          await adminClient.identityProviders.del({alias});
          addAlert(t5("deletedSuccess"), AlertVariant.success);
          history.push(toIdentityProviders({realm: realm2}));
        } catch (error2) {
          addError("identity-providers:deleteErrorError", error2);
        }
      }
    });
    const [toggleDeleteMapperDialog, DeleteMapperConfirm] = useConfirmDialog({
      titleKey: "identity-providers:deleteProviderMapper",
      messageKey: t5("identity-providers:deleteMapperConfirm", {
        mapper: selectedMapper?.name
      }),
      continueButtonLabel: "common:delete",
      continueButtonVariant: ButtonVariant.danger,
      onConfirm: async () => {
        try {
          await adminClient.identityProviders.delMapper({
            alias,
            id: selectedMapper?.mapperId
          });
          addAlert(t5("deleteMapperSuccess"), AlertVariant.success);
          refresh();
          history.push(toIdentityProvider({providerId, alias, tab: "mappers", realm: realm2}));
        } catch (error2) {
          addError("identity-providers:deleteErrorError", error2);
        }
      }
    });
    if (!provider) {
      return /* @__PURE__ */ react.createElement(KeycloakSpinner, null);
    }
    const sections = [t5("generalSettings"), t5("advancedSettings")];
    const isOIDC = provider.providerId.includes("oidc");
    const isSAML = provider.providerId.includes("saml");
    const loader = async () => {
      const [loaderMappers, loaderMapperTypes] = await Promise.all([
        adminClient.identityProviders.findMappers({alias}),
        adminClient.identityProviders.findMapperTypes({alias})
      ]);
      const components3 = loaderMappers.map((loaderMapper) => {
        const mapperType = Object.values(loaderMapperTypes).find((loaderMapperType) => loaderMapper.identityProviderMapper === loaderMapperType.id);
        const result = {
          ...mapperType,
          name: loaderMapper.name,
          type: mapperType?.name,
          mapperId: loaderMapper.id
        };
        return result;
      });
      return components3;
    };
    if (isOIDC) {
      sections.splice(1, 0, t5("oidcSettings"));
    }
    if (isSAML) {
      sections.splice(1, 0, t5("samlSettings"));
      sections.splice(2, 0, t5("reqAuthnConstraints"));
    }
    return /* @__PURE__ */ react.createElement(react.Fragment, null, /* @__PURE__ */ react.createElement(DeleteConfirm, null), /* @__PURE__ */ react.createElement(DeleteMapperConfirm, null), /* @__PURE__ */ react.createElement(Controller, {
      name: "enabled",
      control: form2.control,
      defaultValue: true,
      render: ({onChange, value}) => /* @__PURE__ */ react.createElement(Header3, {
        value,
        onChange,
        save,
        toggleDeleteDialog
      })
    }), /* @__PURE__ */ react.createElement(PageSection, {
      variant: "light",
      className: "pf-u-p-0"
    }, /* @__PURE__ */ react.createElement(FormProvider, {
      ...form2
    }, /* @__PURE__ */ react.createElement(KeycloakTabs, {
      isBox: true
    }, /* @__PURE__ */ react.createElement(Tab, {
      id: "settings",
      eventKey: "settings",
      title: /* @__PURE__ */ react.createElement(TabTitleText, null, t5("common:settings"))
    }, /* @__PURE__ */ react.createElement(ScrollForm, {
      className: "pf-u-px-lg",
      sections
    }, /* @__PURE__ */ react.createElement(FormAccess, {
      role: "manage-identity-providers",
      isHorizontal: true,
      onSubmit: handleSubmit(save)
    }, !isOIDC && !isSAML && /* @__PURE__ */ react.createElement(GeneralSettings2, {
      create: false,
      id: alias
    }), isOIDC && /* @__PURE__ */ react.createElement(OIDCGeneralSettings, {
      id: alias
    }), isSAML && /* @__PURE__ */ react.createElement(SamlGeneralSettings, {
      id: alias
    })), isOIDC && /* @__PURE__ */ react.createElement(react.Fragment, null, /* @__PURE__ */ react.createElement(DiscoverySettings, {
      readOnly: false
    }), /* @__PURE__ */ react.createElement(Form, {
      isHorizontal: true,
      className: "pf-u-py-lg"
    }, /* @__PURE__ */ react.createElement(Divider, null), /* @__PURE__ */ react.createElement(OIDCAuthentication, {
      create: false
    })), /* @__PURE__ */ react.createElement(ExtendedNonDiscoverySettings, null)), isSAML && /* @__PURE__ */ react.createElement(DescriptorSettings, {
      readOnly: false
    }), isSAML && /* @__PURE__ */ react.createElement(FormAccess, {
      role: "manage-identity-providers",
      isHorizontal: true,
      onSubmit: handleSubmit(save)
    }, /* @__PURE__ */ react.createElement(ReqAuthnConstraints, null)), /* @__PURE__ */ react.createElement(FormAccess, {
      role: "manage-identity-providers",
      isHorizontal: true,
      onSubmit: handleSubmit(save)
    }, /* @__PURE__ */ react.createElement(AdvancedSettings2, {
      isOIDC,
      isSAML
    }), /* @__PURE__ */ react.createElement(ActionGroup, {
      className: "keycloak__form_actions"
    }, /* @__PURE__ */ react.createElement(Button, {
      "data-testid": "save",
      type: "submit"
    }, t5("common:save")), /* @__PURE__ */ react.createElement(Button, {
      "data-testid": "revert",
      variant: "link",
      onClick: () => {
        reset2();
      }
    }, t5("common:revert")))))), /* @__PURE__ */ react.createElement(Tab, {
      id: "mappers",
      "data-testid": "mappers-tab",
      eventKey: "mappers",
      title: /* @__PURE__ */ react.createElement(TabTitleText, null, t5("common:mappers"))
    }, /* @__PURE__ */ react.createElement(KeycloakDataTable, {
      emptyState: /* @__PURE__ */ react.createElement(ListEmptyState, {
        message: t5("identity-providers:noMappers"),
        instructions: t5("identity-providers:noMappersInstructions"),
        primaryActionText: t5("identity-providers:addMapper"),
        onPrimaryAction: () => history.push(toIdentityProviderAddMapper({
          realm: realm2,
          alias,
          providerId: provider.providerId,
          tab: "mappers"
        }))
      }),
      loader,
      key,
      isPaginated: true,
      ariaLabelKey: "identity-providers:mappersList",
      searchPlaceholderKey: "identity-providers:searchForMapper",
      toolbarItem: /* @__PURE__ */ react.createElement(ToolbarItem, null, /* @__PURE__ */ react.createElement(Link, {
        to: toIdentityProviderAddMapper({
          realm: realm2,
          alias,
          providerId: provider.providerId,
          tab: "mappers"
        }),
        id: "add-mapper-button"
      }, t5("addMapper"))),
      columns: [
        {
          name: "name",
          displayKey: "common:name",
          cellRenderer: MapperLink
        },
        {
          name: "category",
          displayKey: "common:category"
        },
        {
          name: "type",
          displayKey: "common:type"
        }
      ],
      actions: [
        {
          title: t5("common:delete"),
          onRowClick: (mapper) => {
            setSelectedMapper(mapper);
            toggleDeleteMapperDialog();
          }
        }
      ]
    }))))));
  }
});

// build/user/UsersSection.js
var require_UsersSection = __commonJS((exports2) => {
  __markAsModule(exports2);
  __export(exports2, {
    default: () => UsersSection
  });
  function UsersSection() {
    const {t: t5} = useTranslation("users");
    const adminClient = useAdminClient();
    const {addAlert, addError} = useAlerts();
    const {realm: realmName} = useRealm();
    const history = useHistory();
    const [listUsers, setListUsers] = useState(false);
    const [searchUser, setSearchUser] = useState();
    const [realm2, setRealm] = useState();
    const [kebabOpen, setKebabOpen] = useState(false);
    const [selectedRows, setSelectedRows] = useState([]);
    const [key, setKey] = useState("");
    const refresh = () => setKey(`${new Date().getTime()}`);
    useFetch(() => {
      const testParams = {
        type: "org.keycloak.storage.UserStorageProvider"
      };
      return Promise.all([
        adminClient.components.find(testParams),
        adminClient.realms.findOne({realm: realmName})
      ]).catch(() => [[], void 0]);
    }, ([storageProviders, realm22]) => {
      setListUsers(!(storageProviders.length > 0));
      setRealm(realm22);
      refresh();
    }, []);
    const UserDetailLink = (user) => /* @__PURE__ */ react.createElement(Link, {
      key: user.username,
      to: toUser({realm: realmName, id: user.id, tab: "settings"})
    }, user.username);
    const loader = async (first2, max2, search2) => {
      const params = {
        first: first2,
        max: max2
      };
      const searchParam = search2 || searchUser || "";
      if (searchParam) {
        params.search = searchParam;
      }
      if (!listUsers && !searchParam) {
        return [];
      }
      try {
        const users2 = await adminClient.users.find({...params});
        if (realm2?.bruteForceProtected) {
          const brutes = await Promise.all(users2.map((user) => adminClient.attackDetection.findOne({
            id: user.id
          })));
          for (let index3 = 0; index3 < users2.length; index3++) {
            const user = users2[index3];
            user.brute = brutes[index3];
          }
        }
        return users2;
      } catch (error2) {
        addError("users:noUsersFoundError", error2);
        return [];
      }
    };
    const [toggleUnlockUsersDialog, UnlockUsersConfirm] = useConfirmDialog({
      titleKey: "users:unlockAllUsers",
      messageKey: "users:unlockUsersConfirm",
      continueButtonLabel: "users:unlock",
      onConfirm: async () => {
        try {
          await adminClient.attackDetection.delAll();
          refresh();
          addAlert(t5("unlockUsersSuccess"), AlertVariant.success);
        } catch (error2) {
          addError("users:unlockUsersError", error2);
        }
      }
    });
    const [toggleDeleteDialog, DeleteConfirm] = useConfirmDialog({
      titleKey: "users:deleteConfirm",
      messageKey: t5("deleteConfirmDialog", {count: selectedRows.length}),
      continueButtonLabel: "delete",
      continueButtonVariant: ButtonVariant.danger,
      onConfirm: async () => {
        try {
          for (const user of selectedRows) {
            await adminClient.users.del({id: user.id});
          }
          setSelectedRows([]);
          refresh();
          addAlert(t5("userDeletedSuccess"), AlertVariant.success);
        } catch (error2) {
          addError("users:userDeletedError", error2);
        }
      }
    });
    const StatusRow = (user) => {
      return /* @__PURE__ */ react.createElement(react.Fragment, null, !user.enabled && /* @__PURE__ */ react.createElement(Label, {
        key: user.id,
        color: "red",
        icon: /* @__PURE__ */ react.createElement(InfoCircleIcon, null)
      }, t5("disabled")), user.brute?.disabled && /* @__PURE__ */ react.createElement(Label, {
        key: user.id,
        color: "orange",
        icon: /* @__PURE__ */ react.createElement(WarningTriangleIcon, null)
      }, t5("temporaryDisabled")), user.enabled && !user.brute?.disabled && "—");
    };
    const ValidatedEmail = (user) => {
      return /* @__PURE__ */ react.createElement(react.Fragment, null, !user.emailVerified && /* @__PURE__ */ react.createElement(Tooltip, {
        key: `email-verified-${user.id}`,
        content: /* @__PURE__ */ react.createElement(react.Fragment, null, t5("notVerified"))
      }, /* @__PURE__ */ react.createElement(ExclamationCircleIcon, {
        className: "keycloak__user-section__email-verified"
      })), " ", emptyFormatter()(user.email));
    };
    const goToCreate = () => history.push(toAddUser({realm: realmName}));
    const toolbar2 = /* @__PURE__ */ react.createElement(react.Fragment, null, /* @__PURE__ */ react.createElement(ToolbarItem, null, /* @__PURE__ */ react.createElement(Button, {
      "data-testid": "add-user",
      onClick: goToCreate
    }, t5("addUser"))), !realm2?.bruteForceProtected ? /* @__PURE__ */ react.createElement(ToolbarItem, null, /* @__PURE__ */ react.createElement(Button, {
      variant: ButtonVariant.plain,
      onClick: toggleDeleteDialog,
      isDisabled: selectedRows.length === 0
    }, t5("deleteUser"))) : /* @__PURE__ */ react.createElement(ToolbarItem, null, /* @__PURE__ */ react.createElement(Dropdown, {
      toggle: /* @__PURE__ */ react.createElement(KebabToggle, {
        onToggle: (open2) => setKebabOpen(open2)
      }),
      isOpen: kebabOpen,
      isPlain: true,
      dropdownItems: [
        /* @__PURE__ */ react.createElement(DropdownItem, {
          key: "deleteUser",
          component: "button",
          isDisabled: selectedRows.length === 0,
          onClick: () => {
            toggleDeleteDialog();
            setKebabOpen(false);
          }
        }, t5("deleteUser")),
        /* @__PURE__ */ react.createElement(DropdownItem, {
          key: "unlock",
          component: "button",
          onClick: () => {
            toggleUnlockUsersDialog();
            setKebabOpen(false);
          }
        }, t5("unlockAllUsers"))
      ]
    })));
    return /* @__PURE__ */ react.createElement(react.Fragment, null, /* @__PURE__ */ react.createElement(DeleteConfirm, null), /* @__PURE__ */ react.createElement(UnlockUsersConfirm, null), /* @__PURE__ */ react.createElement(ViewHeader, {
      titleKey: "users:title"
    }), /* @__PURE__ */ react.createElement(PageSection, {
      "data-testid": "users-page",
      variant: "light",
      className: "pf-u-p-0"
    }, /* @__PURE__ */ react.createElement(KeycloakDataTable, {
      key,
      loader,
      isPaginated: true,
      ariaLabelKey: "users:title",
      searchPlaceholderKey: "users:searchForUser",
      canSelectAll: true,
      onSelect: (rows) => setSelectedRows([...rows]),
      emptyState: !listUsers ? /* @__PURE__ */ react.createElement(react.Fragment, null, /* @__PURE__ */ react.createElement(Toolbar, null, /* @__PURE__ */ react.createElement(ToolbarContent, null, /* @__PURE__ */ react.createElement(ToolbarItem, null, /* @__PURE__ */ react.createElement(InputGroup, null, /* @__PURE__ */ react.createElement(TextInput, {
        name: "search-input",
        type: "search",
        "aria-label": t5("search"),
        placeholder: t5("users:searchForUser"),
        onChange: (value) => {
          setSearchUser(value);
        },
        onKeyDown: (e2) => {
          if (e2.key === "Enter") {
            refresh();
          }
        }
      }), /* @__PURE__ */ react.createElement(Button, {
        variant: ButtonVariant.control,
        "aria-label": t5("common:search"),
        onClick: refresh
      }, /* @__PURE__ */ react.createElement(SearchIcon, null)))), toolbar2)), /* @__PURE__ */ react.createElement(EmptyState, {
        "data-testid": "empty-state",
        variant: "large"
      }, /* @__PURE__ */ react.createElement(TextContent, {
        className: "kc-search-users-text"
      }, /* @__PURE__ */ react.createElement(Text, null, t5("searchForUserDescription"))))) : /* @__PURE__ */ react.createElement(ListEmptyState, {
        message: t5("noUsersFound"),
        instructions: t5("emptyInstructions"),
        primaryActionText: t5("createNewUser"),
        onPrimaryAction: goToCreate
      }),
      toolbarItem: toolbar2,
      actions: [
        {
          title: t5("common:delete"),
          onRowClick: (user) => {
            setSelectedRows([user]);
            toggleDeleteDialog();
          }
        }
      ],
      columns: [
        {
          name: "username",
          displayKey: "users:username",
          cellRenderer: UserDetailLink
        },
        {
          name: "email",
          displayKey: "users:email",
          cellRenderer: ValidatedEmail
        },
        {
          name: "lastName",
          displayKey: "users:lastName",
          cellFormatters: [emptyFormatter()]
        },
        {
          name: "firstName",
          displayKey: "users:firstName",
          cellFormatters: [emptyFormatter()]
        },
        {
          name: "status",
          displayKey: "users:status",
          cellRenderer: StatusRow
        }
      ]
    })));
  }
});

// build/user/UsersTabs.js
var require_UsersTabs = __commonJS((exports2) => {
  __markAsModule(exports2);
  __export(exports2, {
    default: () => UsersTabs_default
  });
  var UsersTabs = () => {
    const {t: t5} = useTranslation("users");
    const {addAlert, addError} = useAlerts();
    const history = useHistory();
    const {realm: realm2} = useRealm();
    const {hasAccess} = useAccess();
    const adminClient = useAdminClient();
    const userForm = useForm({mode: "onChange"});
    const {id: id3} = useParams();
    const [user, setUser] = useState();
    const [bruteForced, setBruteForced] = useState();
    const [addedGroups, setAddedGroups] = useState([]);
    useFetch(async () => {
      if (id3) {
        const user2 = await adminClient.users.findOne({id: id3});
        if (!user2) {
          throw new Error(t5("common:notFound"));
        }
        const isBruteForceProtected = (await adminClient.realms.findOne({
          realm: realm2
        })).bruteForceProtected;
        const bruteForce = await adminClient.attackDetection.findOne({
          id: user2.id
        });
        const isLocked = isBruteForceProtected && bruteForce && bruteForce.disabled;
        return {user: user2, bruteForced: {isBruteForceProtected, isLocked}};
      }
      return {user: void 0};
    }, ({user: user2, bruteForced: bruteForced2}) => {
      setUser(user2);
      setBruteForced(bruteForced2);
      user2 && setupForm(user2);
    }, []);
    const setupForm = (user2) => {
      userForm.reset(user2);
    };
    const updateGroups = (groups2) => {
      setAddedGroups(groups2);
    };
    const save = async (user2) => {
      user2.username = user2.username?.trim();
      try {
        if (id3) {
          await adminClient.users.update({id: id3}, user2);
          addAlert(t5("userSaved"), AlertVariant.success);
        } else {
          const createdUser = await adminClient.users.create(user2);
          addedGroups.forEach(async (group) => {
            await adminClient.users.addToGroup({
              id: createdUser.id,
              groupId: group.id
            });
          });
          addAlert(t5("userCreated"), AlertVariant.success);
          history.push(toUser({id: createdUser.id, realm: realm2, tab: "settings"}));
        }
      } catch (error2) {
        addError("users:userCreateError", error2);
      }
    };
    const [toggleDeleteDialog, DeleteConfirm] = useConfirmDialog({
      titleKey: "users:deleteConfirm",
      messageKey: "users:deleteConfirmCurrentUser",
      continueButtonLabel: "common:delete",
      continueButtonVariant: ButtonVariant.danger,
      onConfirm: async () => {
        try {
          await adminClient.users.del({id: id3});
          addAlert(t5("userDeletedSuccess"), AlertVariant.success);
          history.push(toUsers({realm: realm2}));
        } catch (error2) {
          addError("users:userDeletedError", error2);
        }
      }
    });
    const [toggleImpersonateDialog, ImpersonateConfirm] = useConfirmDialog({
      titleKey: "users:impersonateConfirm",
      messageKey: "users:impersonateConfirmDialog",
      continueButtonLabel: "users:impersonate",
      onConfirm: async () => {
        try {
          const data2 = await adminClient.users.impersonation({id: id3}, {user: id3, realm: realm2});
          if (data2.sameRealm) {
            window.location = data2.redirect;
          } else {
            window.open(data2.redirect, "_blank");
          }
        } catch (error2) {
          addError("users:impersonateError", error2);
        }
      }
    });
    return /* @__PURE__ */ react.createElement(react.Fragment, null, /* @__PURE__ */ react.createElement(ImpersonateConfirm, null), /* @__PURE__ */ react.createElement(DeleteConfirm, null), /* @__PURE__ */ react.createElement(ViewHeader, {
      titleKey: user?.username || t5("createUser"),
      divider: !id3,
      dropdownItems: [
        /* @__PURE__ */ react.createElement(DropdownItem, {
          key: "impersonate",
          onClick: () => toggleImpersonateDialog()
        }, t5("impersonate")),
        /* @__PURE__ */ react.createElement(DropdownItem, {
          key: "delete",
          onClick: () => toggleDeleteDialog()
        }, t5("common:delete"))
      ]
    }), /* @__PURE__ */ react.createElement(PageSection, {
      variant: "light",
      className: "pf-u-p-0"
    }, /* @__PURE__ */ react.createElement(FormProvider, {
      ...userForm
    }, id3 && user && /* @__PURE__ */ react.createElement(KeycloakTabs, {
      isBox: true,
      mountOnEnter: true
    }, /* @__PURE__ */ react.createElement(Tab, {
      eventKey: "settings",
      "data-testid": "user-details-tab",
      title: /* @__PURE__ */ react.createElement(TabTitleText, null, t5("common:details"))
    }, /* @__PURE__ */ react.createElement(PageSection, {
      variant: "light"
    }, bruteForced && /* @__PURE__ */ react.createElement(UserForm, {
      onGroupsUpdate: updateGroups,
      save,
      user,
      bruteForce: bruteForced
    }))), /* @__PURE__ */ react.createElement(Tab, {
      eventKey: "attributes",
      "data-testid": "attributes",
      title: /* @__PURE__ */ react.createElement(TabTitleText, null, t5("common:attributes"))
    }, /* @__PURE__ */ react.createElement(UserAttributes, {
      user
    })), /* @__PURE__ */ react.createElement(Tab, {
      eventKey: "credentials",
      "data-testid": "credentials",
      title: /* @__PURE__ */ react.createElement(TabTitleText, null, t5("common:credentials"))
    }, /* @__PURE__ */ react.createElement(UserCredentials, {
      user
    })), /* @__PURE__ */ react.createElement(Tab, {
      eventKey: "groups",
      "data-testid": "user-groups-tab",
      title: /* @__PURE__ */ react.createElement(TabTitleText, null, t5("common:groups"))
    }, /* @__PURE__ */ react.createElement(UserGroups, {
      user
    })), /* @__PURE__ */ react.createElement(Tab, {
      eventKey: "consents",
      "data-testid": "user-consents-tab",
      title: /* @__PURE__ */ react.createElement(TabTitleText, null, t5("consents"))
    }, /* @__PURE__ */ react.createElement(UserConsents, null)), /* @__PURE__ */ react.createElement(Tab, {
      eventKey: "role-mapping",
      "data-testid": "role-mapping-tab",
      title: /* @__PURE__ */ react.createElement(TabTitleText, null, t5("roleMapping"))
    }, /* @__PURE__ */ react.createElement(UserRoleMapping, {
      id: id3,
      name: user.username
    })), hasAccess("view-identity-providers") && /* @__PURE__ */ react.createElement(Tab, {
      eventKey: "identity-provider-links",
      "data-testid": "identity-provider-links-tab",
      title: /* @__PURE__ */ react.createElement(TabTitleText, null, t5("identityProviderLinks"))
    }, /* @__PURE__ */ react.createElement(UserIdentityProviderLinks, null))), !id3 && /* @__PURE__ */ react.createElement(PageSection, {
      variant: "light"
    }, /* @__PURE__ */ react.createElement(UserForm, {
      onGroupsUpdate: updateGroups,
      save
    })))));
  };
  var UsersTabs_default = UsersTabs;
});

// build/events/EventsSection.js
var require_EventsSection = __commonJS((exports2) => {
  __markAsModule(exports2);
  __export(exports2, {
    default: () => EventsSection
  });
  var import_moment6 = __toModule(require_moment());
  var defaultValues2 = {
    client: "",
    dateFrom: "",
    dateTo: "",
    user: "",
    type: []
  };
  var StatusRow = (event) => !event.error ? /* @__PURE__ */ react.createElement("span", null, /* @__PURE__ */ react.createElement(CheckCircleIcon, {
    color: "green"
  }), " ", event.type) : /* @__PURE__ */ react.createElement(Tooltip, {
    content: event.error
  }, /* @__PURE__ */ react.createElement("span", null, /* @__PURE__ */ react.createElement(WarningTriangleIcon, {
    color: "orange"
  }), " ", event.type));
  var DetailCell2 = (event) => /* @__PURE__ */ react.createElement(DescriptionList, {
    isHorizontal: true,
    className: "keycloak_eventsection_details"
  }, Object.entries(event.details).map(([key, value]) => /* @__PURE__ */ react.createElement(DescriptionListGroup, {
    key
  }, /* @__PURE__ */ react.createElement(DescriptionListTerm, null, key), /* @__PURE__ */ react.createElement(DescriptionListDescription, null, value))));
  function EventsSection() {
    const {t: t5} = useTranslation("events");
    const adminClient = useAdminClient();
    const {realm: realm2} = useRealm();
    const [key, setKey] = useState(0);
    const [searchDropdownOpen, setSearchDropdownOpen] = useState(false);
    const [selectOpen, setSelectOpen] = useState(false);
    const [events, setEvents] = useState();
    const [activeFilters, setActiveFilters] = useState({});
    const filterLabels = {
      client: t5("client"),
      dateFrom: t5("dateFrom"),
      dateTo: t5("dateTo"),
      user: t5("userId"),
      type: t5("eventType")
    };
    const {
      getValues,
      register: register2,
      reset: reset2,
      formState: {isDirty},
      control
    } = useForm({
      shouldUnregister: false,
      mode: "onChange",
      defaultValues: defaultValues2
    });
    useFetch(() => adminClient.realms.getConfigEvents({realm: realm2}), (events2) => setEvents(events2), []);
    function loader(first2, max2) {
      return adminClient.realms.findEvents({
        ...activeFilters,
        realm: realm2,
        first: first2,
        max: max2
      });
    }
    function submitSearch() {
      setSearchDropdownOpen(false);
      commitFilters();
    }
    function removeFilter(key2) {
      const formValues = {...getValues()};
      delete formValues[key2];
      reset2({...defaultValues2, ...formValues});
      commitFilters();
    }
    function removeFilterValue(key2, valueToRemove) {
      const formValues = getValues();
      const fieldValue = formValues[key2];
      const newFieldValue = Array.isArray(fieldValue) ? fieldValue.filter((val) => val !== valueToRemove) : fieldValue;
      reset2({...formValues, [key2]: newFieldValue});
      commitFilters();
    }
    function commitFilters() {
      const newFilters = pickBy(getValues(), (value) => value !== "" || Array.isArray(value) && value.length > 0);
      setActiveFilters(newFilters);
      setKey(key + 1);
    }
    function refresh() {
      commitFilters();
    }
    const UserDetailLink = (event) => /* @__PURE__ */ react.createElement(react.Fragment, null, event.userId && /* @__PURE__ */ react.createElement(Link, {
      key: `link-${event.time}-${event.type}`,
      to: toUser({
        realm: realm2,
        id: event.userId,
        tab: "settings"
      })
    }, event.userId), !event.userId && t5("noUserDetails"));
    const userEventSearchFormDisplay = () => {
      return /* @__PURE__ */ react.createElement(Flex, {
        direction: {default: "column"},
        spaceItems: {default: "spaceItemsNone"}
      }, /* @__PURE__ */ react.createElement(FlexItem, null, /* @__PURE__ */ react.createElement(Dropdown, {
        id: "user-events-search-select",
        "data-testid": "UserEventsSearchSelector",
        className: "pf-u-ml-md",
        toggle: /* @__PURE__ */ react.createElement(DropdownToggle, {
          "data-testid": "userEventsSearchSelectorToggle",
          onToggle: (isOpen) => setSearchDropdownOpen(isOpen),
          className: "keycloak__events_search_selector_dropdown__toggle"
        }, t5("searchForUserEvent")),
        isOpen: searchDropdownOpen
      }, /* @__PURE__ */ react.createElement(Form, {
        isHorizontal: true,
        className: "keycloak__events_search__form",
        "data-testid": "searchForm"
      }, /* @__PURE__ */ react.createElement(FormGroup, {
        label: t5("userId"),
        fieldId: "kc-userId",
        className: "keycloak__events_search__form_label"
      }, /* @__PURE__ */ react.createElement(TextInput, {
        ref: register2(),
        type: "text",
        id: "kc-userId",
        name: "user",
        "data-testid": "userId-searchField"
      })), /* @__PURE__ */ react.createElement(FormGroup, {
        label: t5("eventType"),
        fieldId: "kc-eventType",
        className: "keycloak__events_search__form_label"
      }, /* @__PURE__ */ react.createElement(Controller, {
        name: "type",
        control,
        render: ({
          onChange,
          value
        }) => /* @__PURE__ */ react.createElement(Select, {
          className: "keycloak__events_search__type_select",
          name: "eventType",
          "data-testid": "event-type-searchField",
          chipGroupProps: {
            numChips: 1,
            expandedText: t5("common:hide"),
            collapsedText: t5("common:showRemaining")
          },
          variant: SelectVariant.typeaheadMulti,
          typeAheadAriaLabel: "Select",
          onToggle: (isOpen) => setSelectOpen(isOpen),
          selections: value,
          onSelect: (_23, selectedValue) => {
            const option = selectedValue.toString();
            const changedValue = value.includes(option) ? value.filter((item) => item !== option) : [...value, option];
            onChange(changedValue);
          },
          onClear: (event) => {
            event.stopPropagation();
            onChange([]);
          },
          isOpen: selectOpen,
          "aria-labelledby": "eventType",
          chipGroupComponent: /* @__PURE__ */ react.createElement(ChipGroup, null, value.map((chip2) => /* @__PURE__ */ react.createElement(Chip, {
            key: chip2,
            onClick: (event) => {
              event.stopPropagation();
              onChange(value.filter((val) => val !== chip2));
            }
          }, chip2)))
        }, events?.enabledEventTypes?.map((option) => /* @__PURE__ */ react.createElement(SelectOption, {
          key: option,
          value: option
        })))
      })), /* @__PURE__ */ react.createElement(FormGroup, {
        label: t5("client"),
        fieldId: "kc-client",
        className: "keycloak__events_search__form_label"
      }, /* @__PURE__ */ react.createElement(TextInput, {
        ref: register2(),
        type: "text",
        id: "kc-client",
        name: "client",
        "data-testid": "client-searchField"
      })), /* @__PURE__ */ react.createElement(FormGroup, {
        label: t5("dateFrom"),
        fieldId: "kc-dateFrom",
        className: "keycloak__events_search__form_label"
      }, /* @__PURE__ */ react.createElement(TextInput, {
        ref: register2(),
        type: "text",
        id: "kc-dateFrom",
        name: "dateFrom",
        className: "pf-c-form-control pf-m-icon pf-m-calendar",
        placeholder: "yyyy-MM-dd",
        "data-testid": "dateFrom-searchField"
      })), /* @__PURE__ */ react.createElement(FormGroup, {
        label: t5("dateTo"),
        fieldId: "kc-dateTo",
        className: "keycloak__events_search__form_label"
      }, /* @__PURE__ */ react.createElement(TextInput, {
        ref: register2(),
        type: "text",
        id: "kc-dateTo",
        name: "dateTo",
        className: "pf-c-form-control pf-m-icon pf-m-calendar",
        placeholder: "yyyy-MM-dd",
        "data-testid": "dateTo-searchField"
      })), /* @__PURE__ */ react.createElement(ActionGroup, null, /* @__PURE__ */ react.createElement(Button, {
        className: "keycloak__user_events_search__form_btn",
        variant: "primary",
        onClick: submitSearch,
        "data-testid": "search-events-btn",
        isDisabled: !isDirty
      }, t5("searchUserEventsBtn"))))), /* @__PURE__ */ react.createElement(Button, {
        className: "pf-u-ml-md",
        onClick: refresh,
        "data-testid": "refresh-btn"
      }, t5("refresh"))), /* @__PURE__ */ react.createElement(FlexItem, null, Object.entries(activeFilters).length > 0 && /* @__PURE__ */ react.createElement("div", {
        className: "keycloak__searchChips pf-u-ml-md"
      }, Object.entries(activeFilters).map((filter3) => {
        const [key2, value] = filter3;
        return /* @__PURE__ */ react.createElement(ChipGroup, {
          className: "pf-u-mt-md pf-u-mr-md",
          key: key2,
          categoryName: filterLabels[key2],
          isClosable: true,
          onClick: () => removeFilter(key2)
        }, typeof value === "string" ? /* @__PURE__ */ react.createElement(Chip, {
          isReadOnly: true
        }, value) : value.map((entry) => /* @__PURE__ */ react.createElement(Chip, {
          key: entry,
          onClick: () => removeFilterValue(key2, entry)
        }, entry)));
      }))));
    };
    return /* @__PURE__ */ react.createElement(react.Fragment, null, /* @__PURE__ */ react.createElement(ViewHeader, {
      titleKey: "events:title",
      subKey: /* @__PURE__ */ react.createElement(Trans, {
        i18nKey: "events:eventExplain"
      }, "If you want to configure user events, Admin events or Event listeners, please enter", /* @__PURE__ */ react.createElement(Link, {
        to: toRealmSettings({realm: realm2, tab: "events"})
      }, t5("eventConfig")), "page realm settings to configure."),
      divider: false
    }), /* @__PURE__ */ react.createElement(PageSection, {
      variant: "light",
      className: "pf-u-p-0"
    }, /* @__PURE__ */ react.createElement(KeycloakTabs, {
      isBox: true
    }, /* @__PURE__ */ react.createElement(Tab, {
      eventKey: "userEvents",
      title: /* @__PURE__ */ react.createElement(TabTitleText, null, t5("userEvents"))
    }, /* @__PURE__ */ react.createElement("div", {
      className: "keycloak__events_table"
    }, /* @__PURE__ */ react.createElement(KeycloakDataTable, {
      key,
      loader,
      detailColumns: [
        {
          name: "details",
          enabled: (event) => event.details !== void 0,
          cellRenderer: DetailCell2
        }
      ],
      isPaginated: true,
      ariaLabelKey: "events:title",
      toolbarItem: userEventSearchFormDisplay(),
      columns: [
        {
          name: "time",
          displayKey: "events:time",
          cellRenderer: (row) => (0, import_moment6.default)(row.time).format("LLL"),
          cellFormatters: [expandable]
        },
        {
          name: "userId",
          displayKey: "events:user",
          cellRenderer: UserDetailLink
        },
        {
          name: "type",
          displayKey: "events:eventType",
          cellRenderer: StatusRow
        },
        {
          name: "ipAddress",
          displayKey: "events:ipAddress",
          transforms: [cellWidth(10)]
        },
        {
          name: "clientId",
          displayKey: "events:client"
        }
      ],
      emptyState: /* @__PURE__ */ react.createElement(ListEmptyState, {
        message: t5("emptyEvents"),
        instructions: t5("emptyEventsInstructions")
      }),
      isSearching: Object.keys(activeFilters).length > 0
    }))), /* @__PURE__ */ react.createElement(Tab, {
      eventKey: "adminEvents",
      title: /* @__PURE__ */ react.createElement(TabTitleText, null, t5("adminEvents")),
      "data-testid": "admin-events-tab"
    }, /* @__PURE__ */ react.createElement(AdminEvents, null)))));
  }
});

// build/groups/SearchGroups.js
var require_SearchGroups = __commonJS((exports2) => {
  __markAsModule(exports2);
  __export(exports2, {
    default: () => SearchGroups
  });
  function SearchGroups() {
    const {t: t5} = useTranslation("groups");
    const adminClient = useAdminClient();
    const {realm: realm2} = useRealm();
    const [searchTerm, setSearchTerm] = useState("");
    const [searchTerms, setSearchTerms] = useState([]);
    const [key, setKey] = useState(0);
    const refresh = () => setKey(new Date().getTime());
    const {setSubGroups} = useSubGroups();
    useEffect(() => setSubGroups([{name: t5("searchGroups"), id: "search"}]), []);
    const deleteTerm = (id3) => {
      const index3 = searchTerms.indexOf(id3);
      searchTerms.splice(index3, 1);
      setSearchTerms([...searchTerms]);
      refresh();
    };
    const addTerm = () => {
      if (searchTerm !== "") {
        setSearchTerms([...searchTerms, searchTerm]);
        setSearchTerm("");
        refresh();
      }
    };
    const GroupNameCell = (group) => /* @__PURE__ */ react.createElement(Link, {
      key: group.id,
      to: `/${realm2}/groups/search/${group.link}`,
      onClick: () => setSubGroups([{name: t5("searchGroups"), id: "search"}, group])
    }, group.name);
    const flatten4 = (groups2, id3) => {
      let result = [];
      for (const group of groups2) {
        const link = `${id3 || ""}${id3 ? "/" : ""}${group.id}`;
        result.push({...group, link});
        if (group.subGroups) {
          result = [...result, ...flatten4(group.subGroups, link)];
        }
      }
      return result;
    };
    const loader = async (first2, max2) => {
      const params = {
        first: first2,
        max: max2
      };
      let result = [];
      if (searchTerms[0]) {
        result = await adminClient.groups.find({
          ...params,
          search: searchTerms[0]
        });
        result = flatten4(result);
        for (const searchTerm2 of searchTerms) {
          result = result.filter((group) => group.name?.includes(searchTerm2));
        }
      }
      return result;
    };
    const Path = (group) => /* @__PURE__ */ react.createElement(GroupPath, {
      group
    });
    return /* @__PURE__ */ react.createElement(react.Fragment, null, /* @__PURE__ */ react.createElement(ViewHeader, {
      titleKey: "groups:searchGroups"
    }), /* @__PURE__ */ react.createElement(PageSection, {
      variant: PageSectionVariants.light,
      className: "pf-u-p-0"
    }, /* @__PURE__ */ react.createElement(KeycloakDataTable, {
      key,
      isSearching: true,
      toolbarItem: /* @__PURE__ */ react.createElement(ToolbarItem, null, /* @__PURE__ */ react.createElement(Stack, null, /* @__PURE__ */ react.createElement(StackItem, {
        className: "pf-u-mb-sm"
      }, /* @__PURE__ */ react.createElement(InputGroup, null, /* @__PURE__ */ react.createElement(TextInput, {
        name: "search",
        "data-testid": "group-search",
        type: "search",
        "aria-label": t5("search"),
        placeholder: t5("searchGroups"),
        value: searchTerm,
        onChange: (value) => setSearchTerm(value),
        onKeyDown: (event) => {
          if (event.key === "Enter") {
            addTerm();
          }
        }
      }), /* @__PURE__ */ react.createElement(Button, {
        "data-testid": "search-button",
        variant: ButtonVariant.control,
        "aria-label": t5("search"),
        onClick: addTerm
      }, /* @__PURE__ */ react.createElement(SearchIcon, null)))), /* @__PURE__ */ react.createElement(StackItem, null, /* @__PURE__ */ react.createElement(ChipGroup, null, searchTerms.map((term) => /* @__PURE__ */ react.createElement(Chip, {
        key: term,
        onClick: () => deleteTerm(term)
      }, term)))))),
      ariaLabelKey: "groups:groups",
      isPaginated: true,
      loader,
      columns: [
        {
          name: "name",
          displayKey: "groups:groupName",
          cellRenderer: GroupNameCell
        },
        {
          name: "path",
          displayKey: "groups:path",
          cellRenderer: Path
        }
      ],
      emptyState: /* @__PURE__ */ react.createElement(ListEmptyState, {
        message: t5("noSearchResults"),
        instructions: t5("noSearchResultsInstructions"),
        hasIcon: false
      })
    })));
  }
});

// build/groups/GroupsSection.js
var require_GroupsSection = __commonJS((exports2) => {
  __markAsModule(exports2);
  __export(exports2, {
    default: () => GroupsSection
  });
  function GroupsSection() {
    const {t: t5} = useTranslation("groups");
    const [activeTab, setActiveTab] = useState(0);
    const adminClient = useAdminClient();
    const {subGroups, setSubGroups, currentGroup} = useSubGroups();
    const {addAlert, addError} = useAlerts();
    const {realm: realm2} = useRealm();
    const [rename, setRename] = useState();
    const history = useHistory();
    const location2 = useLocation();
    const id3 = getLastId(location2.pathname);
    const deleteGroup = async (group) => {
      try {
        await adminClient.groups.del({
          id: group.id
        });
        addAlert(t5("groupDeleted", {count: 1}), AlertVariant.success);
      } catch (error2) {
        addError("groups:groupDeleteError", error2);
      }
      return true;
    };
    useFetch(async () => {
      const ids = getId(location2.pathname);
      const isNavigationStateInValid = ids && ids.length > subGroups.length;
      if (isNavigationStateInValid) {
        const groups2 = [];
        for (const i3 of ids) {
          const group = await adminClient.groups.findOne({id: i3});
          if (group) {
            groups2.push(group);
          } else {
            throw new Error(t5("common:notFound"));
          }
        }
        return groups2;
      }
      return [];
    }, (groups2) => {
      if (groups2.length)
        setSubGroups(groups2);
    }, [id3]);
    const SearchDropdown2 = /* @__PURE__ */ react.createElement(DropdownItem, {
      key: "searchGroup",
      component: /* @__PURE__ */ react.createElement(Link, {
        "data-testid": "searchGroup",
        to: toGroupsSearch({realm: realm2})
      }, t5("searchGroup"))
    });
    return /* @__PURE__ */ react.createElement(react.Fragment, null, rename && /* @__PURE__ */ react.createElement(GroupsModal, {
      id: id3,
      rename,
      refresh: (group) => setSubGroups([...subGroups.slice(0, subGroups.length - 1), group]),
      handleModalToggle: () => setRename(void 0)
    }), /* @__PURE__ */ react.createElement(ViewHeader, {
      titleKey: !id3 ? "groups:groups" : currentGroup().name,
      subKey: !id3 ? "groups:groupsDescription" : "",
      divider: !id3,
      dropdownItems: id3 ? [
        SearchDropdown2,
        /* @__PURE__ */ react.createElement(DropdownItem, {
          "data-testid": "renameGroupAction",
          key: "renameGroup",
          onClick: () => setRename(currentGroup().name)
        }, t5("renameGroup")),
        /* @__PURE__ */ react.createElement(DropdownItem, {
          "data-testid": "deleteGroup",
          key: "deleteGroup",
          onClick: async () => {
            await deleteGroup({id: id3});
            history.push(toGroups({realm: realm2}));
          }
        }, t5("deleteGroup"))
      ] : [SearchDropdown2]
    }), /* @__PURE__ */ react.createElement(PageSection, {
      variant: PageSectionVariants.light,
      className: "pf-u-p-0"
    }, subGroups.length > 0 && /* @__PURE__ */ react.createElement(Tabs, {
      inset: {
        default: "insetNone",
        md: "insetSm",
        xl: "inset2xl",
        "2xl": "insetLg"
      },
      activeKey: activeTab,
      onSelect: (_23, key) => setActiveTab(key),
      isBox: true
    }, /* @__PURE__ */ react.createElement(Tab, {
      "data-testid": "groups",
      eventKey: 0,
      title: /* @__PURE__ */ react.createElement(TabTitleText, null, t5("childGroups"))
    }, /* @__PURE__ */ react.createElement(GroupTable, null)), /* @__PURE__ */ react.createElement(Tab, {
      "data-testid": "members",
      eventKey: 1,
      title: /* @__PURE__ */ react.createElement(TabTitleText, null, t5("members"))
    }, /* @__PURE__ */ react.createElement(Members, null)), /* @__PURE__ */ react.createElement(Tab, {
      "data-testid": "attributes",
      eventKey: 2,
      title: /* @__PURE__ */ react.createElement(TabTitleText, null, t5("common:attributes"))
    }, /* @__PURE__ */ react.createElement(GroupAttributes, null)), /* @__PURE__ */ react.createElement(Tab, {
      eventKey: 3,
      "data-testid": "role-mapping-tab",
      title: /* @__PURE__ */ react.createElement(TabTitleText, null, t5("roleMapping"))
    }, /* @__PURE__ */ react.createElement(GroupRoleMapping, {
      id: id3,
      name: currentGroup().name
    }))), subGroups.length === 0 && /* @__PURE__ */ react.createElement(GroupTable, null)));
  }
});

// build/identity-providers/add/AddOpenIdConnect.js
var require_AddOpenIdConnect = __commonJS((exports2) => {
  __markAsModule(exports2);
  __export(exports2, {
    default: () => AddOpenIdConnect
  });
  function AddOpenIdConnect() {
    const {t: t5} = useTranslation("identity-providers");
    const history = useHistory();
    const {url} = useRouteMatch();
    const isKeycloak = url.endsWith("keycloak-oidc");
    const id3 = `${isKeycloak ? "keycloak-" : ""}oidc`;
    const form2 = useForm({
      defaultValues: {alias: id3}
    });
    const {
      handleSubmit,
      formState: {isDirty}
    } = form2;
    const adminClient = useAdminClient();
    const {addAlert, addError} = useAlerts();
    const {realm: realm2} = useRealm();
    const save = async (provider) => {
      delete provider.discoveryEndpoint;
      try {
        await adminClient.identityProviders.create({
          ...provider,
          providerId: id3
        });
        addAlert(t5("createSuccess"), AlertVariant.success);
        history.push(toIdentityProvider({
          realm: realm2,
          providerId: id3,
          alias: provider.alias,
          tab: "settings"
        }));
      } catch (error2) {
        addError("identity-providers:createError", error2);
      }
    };
    return /* @__PURE__ */ react.createElement(react.Fragment, null, /* @__PURE__ */ react.createElement(ViewHeader, {
      titleKey: t5(isKeycloak ? "addKeycloakOpenIdProvider" : "addOpenIdProvider")
    }), /* @__PURE__ */ react.createElement(PageSection, {
      variant: "light"
    }, /* @__PURE__ */ react.createElement(FormProvider, {
      ...form2
    }, /* @__PURE__ */ react.createElement(FormAccess, {
      role: "manage-identity-providers",
      isHorizontal: true,
      onSubmit: handleSubmit(save)
    }, /* @__PURE__ */ react.createElement(OIDCGeneralSettings, {
      id: id3
    }), /* @__PURE__ */ react.createElement(OpenIdConnectSettings, null), /* @__PURE__ */ react.createElement(OIDCAuthentication, null), /* @__PURE__ */ react.createElement(ActionGroup, null, /* @__PURE__ */ react.createElement(Button, {
      isDisabled: !isDirty,
      variant: "primary",
      type: "submit",
      "data-testid": "createProvider"
    }, t5("common:add")), /* @__PURE__ */ react.createElement(Button, {
      variant: "link",
      "data-testid": "cancel",
      component: (props) => /* @__PURE__ */ react.createElement(Link, {
        ...props,
        to: toIdentityProviders({realm: realm2})
      })
    }, t5("common:cancel")))))));
  }
});

// build/identity-providers/add/AddSamlConnect.js
var require_AddSamlConnect = __commonJS((exports2) => {
  __markAsModule(exports2);
  __export(exports2, {
    default: () => AddSamlConnect
  });
  function AddSamlConnect() {
    const {t: t5} = useTranslation("identity-providers");
    const history = useHistory();
    const id3 = "saml";
    const form2 = useForm({
      defaultValues: {alias: id3}
    });
    const {
      handleSubmit,
      formState: {isDirty}
    } = form2;
    const adminClient = useAdminClient();
    const {addAlert} = useAlerts();
    const {realm: realm2} = useRealm();
    const save = async (provider) => {
      delete provider.discoveryEndpoint;
      try {
        await adminClient.identityProviders.create({
          ...provider,
          providerId: id3
        });
        addAlert(t5("createSuccess"), AlertVariant.success);
        history.push(toIdentityProvider({
          realm: realm2,
          providerId: id3,
          alias: provider.alias,
          tab: "settings"
        }));
      } catch (error2) {
        addAlert(t5("createError", {
          error: error2.response?.data?.errorMessage || error2
        }), AlertVariant.danger);
      }
    };
    return /* @__PURE__ */ react.createElement(react.Fragment, null, /* @__PURE__ */ react.createElement(ViewHeader, {
      titleKey: t5("addSamlProvider")
    }), /* @__PURE__ */ react.createElement(PageSection, {
      variant: "light"
    }, /* @__PURE__ */ react.createElement(FormProvider, {
      ...form2
    }, /* @__PURE__ */ react.createElement(FormAccess, {
      role: "manage-identity-providers",
      isHorizontal: true,
      onSubmit: handleSubmit(save)
    }, /* @__PURE__ */ react.createElement(SamlGeneralSettings, {
      id: id3
    }), /* @__PURE__ */ react.createElement(SamlConnectSettings, null), /* @__PURE__ */ react.createElement(ActionGroup, null, /* @__PURE__ */ react.createElement(Button, {
      isDisabled: !isDirty,
      variant: "primary",
      type: "submit",
      "data-testid": "createProvider"
    }, t5("common:add")), /* @__PURE__ */ react.createElement(Button, {
      variant: "link",
      "data-testid": "cancel",
      component: (props) => /* @__PURE__ */ react.createElement(Link, {
        ...props,
        to: toIdentityProviders({realm: realm2})
      })
    }, t5("common:cancel")))))));
  }
});

// build/realm-roles/RealmRolesSection.js
var require_RealmRolesSection = __commonJS((exports2) => {
  __markAsModule(exports2);
  __export(exports2, {
    default: () => RealmRolesSection
  });
  function RealmRolesSection() {
    const adminClient = useAdminClient();
    const loader = (first2, max2, search2) => {
      const params = {
        first: first2,
        max: max2
      };
      const searchParam = search2 || "";
      if (searchParam) {
        params.search = searchParam;
      }
      return adminClient.roles.find(params);
    };
    return /* @__PURE__ */ react.createElement(react.Fragment, null, /* @__PURE__ */ react.createElement(ViewHeader, {
      titleKey: "roles:title",
      subKey: "roles:roleExplain"
    }), /* @__PURE__ */ react.createElement(PageSection, {
      variant: "light",
      padding: {default: "noPadding"}
    }, /* @__PURE__ */ react.createElement(RolesList, {
      loader
    })));
  }
});

// build/realm-settings/key-providers/rsa/RSAForm.js
var require_RSAForm = __commonJS((exports2) => {
  __markAsModule(exports2);
  __export(exports2, {
    RSAForm: () => RSAForm,
    default: () => RSASettings
  });
  var RSAForm = ({
    editMode,
    providerType,
    handleModalToggle,
    refresh
  }) => {
    const {t: t5} = useTranslation("realm-settings");
    const serverInfo2 = useServerInfo();
    const [component, setComponent] = useState();
    const [isRSAalgDropdownOpen, setIsRSAalgDropdownOpen] = useState(false);
    const [keyFileName, setKeyFileName] = useState("");
    const [certificateFileName, setCertificateFileName] = useState("");
    const adminClient = useAdminClient();
    const {addAlert, addError} = useAlerts();
    const {id: id3} = useParams();
    const providerId = useRouteMatch("/:providerType?")?.params.providerType;
    const save = async (component2) => {
      try {
        if (id3) {
          await adminClient.components.update({id: id3}, {
            ...component2,
            parentId: component2.parentId,
            providerId: providerType,
            providerType: KEY_PROVIDER_TYPE
          });
          addAlert(t5("saveProviderSuccess"), AlertVariant.success);
        } else {
          await adminClient.components.create({
            ...component2,
            parentId: component2.parentId,
            providerId: providerType,
            providerType: KEY_PROVIDER_TYPE,
            config: {priority: ["0"]}
          });
          handleModalToggle?.();
          addAlert(t5("saveProviderSuccess"), AlertVariant.success);
          refresh?.();
        }
      } catch (error2) {
        addError("realm-settings:saveProviderError", error2);
      }
    };
    const form2 = useForm({mode: "onChange"});
    const setupForm = (component2) => {
      form2.reset();
      convertToFormValues(component2, form2.setValue);
    };
    useFetch(async () => {
      if (editMode)
        return await adminClient.components.findOne({id: id3});
    }, (result) => {
      if (result) {
        setupForm(result);
        setComponent(result);
      }
    }, []);
    const allComponentTypes = serverInfo2.componentTypes?.[KEY_PROVIDER_TYPE] ?? [];
    const rsaAlgOptions = allComponentTypes[4].properties[3].options;
    return /* @__PURE__ */ react.createElement(FormAccess, {
      isHorizontal: true,
      id: "add-provider",
      className: "pf-u-mt-lg",
      role: "manage-realm",
      onSubmit: form2.handleSubmit(save)
    }, editMode && /* @__PURE__ */ react.createElement(FormGroup, {
      label: t5("providerId"),
      labelIcon: /* @__PURE__ */ react.createElement(HelpItem, {
        helpText: "client-scopes-help:mapperName",
        forLabel: t5("common:name"),
        forID: t5("common:helpLabel", {label: t5("common:name")})
      }),
      fieldId: "id",
      isRequired: true,
      validated: form2.errors.name ? ValidatedOptions.error : ValidatedOptions.default,
      helperTextInvalid: t5("common:required")
    }, /* @__PURE__ */ react.createElement(TextInput, {
      ref: form2.register(),
      id: "id",
      type: "text",
      name: "id",
      isReadOnly: editMode,
      "aria-label": t5("consoleDisplayName"),
      defaultValue: id3,
      "data-testid": "display-name-input"
    })), /* @__PURE__ */ react.createElement(FormGroup, {
      label: t5("common:name"),
      labelIcon: /* @__PURE__ */ react.createElement(HelpItem, {
        helpText: "client-scopes-help:mapperName",
        forLabel: t5("common:name"),
        forID: t5("common:helpLabel", {label: t5("common:name")})
      }),
      fieldId: "name",
      isRequired: true,
      validated: form2.errors.name ? ValidatedOptions.error : ValidatedOptions.default,
      helperTextInvalid: t5("common:required")
    }, !editMode && /* @__PURE__ */ react.createElement(Controller, {
      name: "name",
      control: form2.control,
      defaultValue: providerType,
      render: ({onChange, value}) => {
        return /* @__PURE__ */ react.createElement(TextInput, {
          id: "name",
          type: "text",
          "aria-label": t5("consoleDisplayName"),
          defaultValue: providerType,
          value,
          onChange: (value2) => onChange(value2),
          "data-testid": "display-name-input"
        });
      }
    }), editMode && /* @__PURE__ */ react.createElement(TextInput, {
      ref: form2.register(),
      type: "text",
      id: "name",
      name: "name",
      defaultValue: providerId,
      validated: form2.errors.name ? ValidatedOptions.error : ValidatedOptions.default
    })), /* @__PURE__ */ react.createElement(FormGroup, {
      label: t5("common:enabled"),
      fieldId: "kc-enabled",
      labelIcon: /* @__PURE__ */ react.createElement(HelpItem, {
        helpText: t5("realm-settings-help:enabled"),
        forLabel: t5("enabled"),
        forID: t5("common:helpLabel", {label: t5("enabled")})
      })
    }, /* @__PURE__ */ react.createElement(Controller, {
      name: "config.enabled",
      control: form2.control,
      defaultValue: ["true"],
      render: ({onChange, value}) => /* @__PURE__ */ react.createElement(Switch, {
        id: "kc-enabled-switch",
        label: t5("common:on"),
        labelOff: t5("common:off"),
        isChecked: value[0] === "true",
        "data-testid": value[0] === "true" ? "enabled" : "disabled",
        onChange: (value2) => {
          onChange([value2.toString()]);
        }
      })
    })), /* @__PURE__ */ react.createElement(FormGroup, {
      label: t5("active"),
      fieldId: "kc-active",
      labelIcon: /* @__PURE__ */ react.createElement(HelpItem, {
        helpText: "realm-settings-help:active",
        forLabel: t5("active"),
        forID: t5("common:helpLabel", {label: t5("active")})
      })
    }, /* @__PURE__ */ react.createElement(Controller, {
      name: "config.active",
      control: form2.control,
      defaultValue: ["true"],
      render: ({onChange, value}) => {
        return /* @__PURE__ */ react.createElement(Switch, {
          id: "kc-active-switch",
          label: t5("common:on"),
          labelOff: t5("common:off"),
          isChecked: value[0] === "true",
          "data-testid": value[0] === "true" ? "active" : "passive",
          onChange: (value2) => {
            onChange([value2.toString()]);
          }
        });
      }
    })), /* @__PURE__ */ react.createElement(FormGroup, {
      label: t5("algorithm"),
      fieldId: "kc-algorithm",
      labelIcon: /* @__PURE__ */ react.createElement(HelpItem, {
        helpText: "realm-settings-help:algorithm",
        forLabel: t5("algorithm"),
        forID: t5("common:helpLabel", {label: t5("algorithm")})
      })
    }, /* @__PURE__ */ react.createElement(Controller, {
      name: "config.algorithm",
      defaultValue: ["RS256"],
      control: form2.control,
      render: ({onChange, value}) => /* @__PURE__ */ react.createElement(Select, {
        toggleId: "kc-rsa-algorithm",
        onToggle: () => setIsRSAalgDropdownOpen(!isRSAalgDropdownOpen),
        onSelect: (_23, value2) => {
          onChange([value2.toString()]);
          setIsRSAalgDropdownOpen(false);
        },
        selections: [value.toString()],
        variant: SelectVariant.single,
        "aria-label": t5("algorithm"),
        isOpen: isRSAalgDropdownOpen,
        "data-testid": "select-rsa-algorithm"
      }, rsaAlgOptions.map((p2, idx) => /* @__PURE__ */ react.createElement(SelectOption, {
        selected: p2 === value,
        key: `rsa-algorithm-${idx}`,
        value: p2
      })))
    })), /* @__PURE__ */ react.createElement(FormGroup, {
      label: t5("privateRSAKey"),
      fieldId: "kc-private-rsa-key",
      labelIcon: /* @__PURE__ */ react.createElement(HelpItem, {
        helpText: "realm-settings-help:privateRSAKey",
        forLabel: t5("privateRSAKey"),
        forID: t5("common:helpLabel", {label: t5("privateRSAKey")})
      })
    }, /* @__PURE__ */ react.createElement(Controller, {
      name: "config.privateKey",
      control: form2.control,
      defaultValue: [],
      render: ({onChange}) => /* @__PURE__ */ react.createElement(FileUpload, {
        id: "importPrivateKey",
        type: "text",
        value: component?.config?.privateKey[0],
        filenamePlaceholder: "Upload a PEM file or paste key below",
        filename: keyFileName,
        onChange: (value, fileName) => {
          setKeyFileName(fileName);
          onChange([value]);
        }
      })
    })), /* @__PURE__ */ react.createElement(FormGroup, {
      label: t5("x509Certificate"),
      fieldId: "kc-aes-keysize",
      labelIcon: /* @__PURE__ */ react.createElement(HelpItem, {
        helpText: "realm-settings-help:x509Certificate",
        forLabel: t5("x509Certificate"),
        forID: t5("common:helpLabel", {label: t5("x509Certificate")})
      })
    }, /* @__PURE__ */ react.createElement(Controller, {
      name: "config.certificate",
      control: form2.control,
      defaultValue: [],
      render: ({onChange}) => /* @__PURE__ */ react.createElement(FileUpload, {
        id: "importCertificate",
        type: "text",
        value: component?.config?.certificate[0],
        filenamePlaceholder: "Upload a PEM file or paste key below",
        filename: certificateFileName,
        onChange: (value, fileName) => {
          setCertificateFileName(fileName);
          onChange([value]);
        }
      })
    })), /* @__PURE__ */ react.createElement(ActionGroup, {
      className: "kc-hmac-form-buttons"
    }, /* @__PURE__ */ react.createElement(Button, {
      className: "kc-hmac-form-save-button",
      "data-testid": "add-provider-button",
      variant: "primary",
      type: "submit"
    }, t5("common:save")), /* @__PURE__ */ react.createElement(Button, {
      className: "kc-hmac-form-cancel-button",
      onClick: !editMode && handleModalToggle || void 0,
      variant: "link"
    }, t5("common:cancel"))));
  };
  function RSASettings() {
    const {t: t5} = useTranslation("realm-settings");
    const providerId = useRouteMatch("/:realm/realm-settings/keys/:id?/:providerType?/settings")?.params.providerType;
    return /* @__PURE__ */ react.createElement(react.Fragment, null, /* @__PURE__ */ react.createElement(ViewHeader, {
      titleKey: t5("editProvider"),
      subKey: providerId
    }), /* @__PURE__ */ react.createElement(PageSection, {
      variant: "light"
    }, /* @__PURE__ */ react.createElement(RSAForm, {
      providerType: providerId,
      editMode: true
    })));
  }
});

// build/sessions/SessionsSection.js
var require_SessionsSection = __commonJS((exports2) => {
  __markAsModule(exports2);
  __export(exports2, {
    default: () => SessionsSection
  });
  var import_moment6 = __toModule(require_moment());
  var Clients = (row) => {
    return /* @__PURE__ */ react.createElement(react.Fragment, null, Object.values(row.clients).map((client2) => /* @__PURE__ */ react.createElement(Link, {
      key: client2,
      to: "",
      className: "pf-u-mx-sm"
    }, client2)));
  };
  function SessionsSection() {
    const {t: t5} = useTranslation("sessions");
    const adminClient = useAdminClient();
    const [filterDropdownOpen, setFilterDropdownOpen] = useState(false);
    const [revocationModalOpen, setRevocationModalOpen] = useState(false);
    const [logoutAllSessionsModalOpen, setLogoutAllSessionsModalOpen] = useState(false);
    const [activeClientDetails, setActiveClientDetails] = useState([]);
    const [filterType, setFilterType] = useState(t5("sessionsType.allSessions").toString());
    const [key, setKey] = useState(0);
    const [noSessions, setNoSessions] = useState(false);
    const refresh = () => {
      setKey(new Date().getTime());
    };
    const handleRevocationModalToggle = () => {
      setRevocationModalOpen(!revocationModalOpen);
    };
    const handleLogoutAllSessionsModalToggle = () => {
      setLogoutAllSessionsModalOpen(!logoutAllSessionsModalOpen);
    };
    const loader = async () => {
      const activeClients = await adminClient.sessions.find();
      const clientSessions = (await Promise.all(activeClients.map((client2) => adminClient.clients.listSessions({id: client2.id})))).flat();
      setNoSessions(clientSessions.length === 0);
      const allClients = await adminClient.clients.find();
      const getActiveClientDetails = allClients.filter((x2) => activeClients.map((y3) => y3.id).includes(x2.id));
      setActiveClientDetails(getActiveClientDetails);
      const userIds = Array.from(new Set(clientSessions.map((session) => session.userId)));
      const userSessions = (await Promise.all(userIds.map((userId) => adminClient.users.listSessions({id: userId})))).flat();
      return userSessions;
    };
    const dropdownItems = [
      /* @__PURE__ */ react.createElement(DropdownItem, {
        key: "toggle-modal",
        "data-testid": "revocation",
        component: "button",
        onClick: () => handleRevocationModalToggle()
      }, t5("revocation")),
      /* @__PURE__ */ react.createElement(DropdownItem, {
        key: "delete-role",
        "data-testid": "logout-all",
        component: "button",
        isDisabled: noSessions,
        onClick: () => handleLogoutAllSessionsModalToggle()
      }, t5("signOutAllActiveSessions"))
    ];
    return /* @__PURE__ */ react.createElement(react.Fragment, null, /* @__PURE__ */ react.createElement(ViewHeader, {
      dropdownItems,
      titleKey: "sessions:title",
      subKey: "sessions:sessionExplain"
    }), /* @__PURE__ */ react.createElement(PageSection, {
      variant: "light",
      className: "pf-u-p-0"
    }, revocationModalOpen && /* @__PURE__ */ react.createElement(RevocationModal, {
      handleModalToggle: handleRevocationModalToggle,
      activeClients: activeClientDetails,
      save: () => {
        handleRevocationModalToggle();
      }
    }), logoutAllSessionsModalOpen && /* @__PURE__ */ react.createElement(LogoutAllSessionsModal, {
      handleModalToggle: handleLogoutAllSessionsModalToggle
    }), /* @__PURE__ */ react.createElement(KeycloakDataTable, {
      key,
      loader,
      ariaLabelKey: "session:title",
      searchPlaceholderKey: "sessions:searchForSession",
      searchTypeComponent: /* @__PURE__ */ react.createElement(Select, {
        "data-testid": "filter-session-type-select",
        isOpen: filterDropdownOpen,
        className: "kc-filter-session-type-select",
        variant: SelectVariant.single,
        onToggle: (isExpanded) => setFilterDropdownOpen(isExpanded),
        toggleIcon: /* @__PURE__ */ react.createElement(FilterIcon, null),
        onSelect: (_23, value) => {
          setFilterType(value.toString());
          refresh();
          setFilterDropdownOpen(false);
        },
        selections: filterType
      }, /* @__PURE__ */ react.createElement(SelectOption, {
        "data-testid": "all-sessions-option",
        value: t5("sessionsType.allSessions"),
        isPlaceholder: true
      }), /* @__PURE__ */ react.createElement(SelectOption, {
        "data-testid": "regular-sso-option",
        value: t5("sessionsType.regularSSO")
      }), /* @__PURE__ */ react.createElement(SelectOption, {
        "data-testid": "offline-option",
        value: t5("sessionsType.offline")
      }), /* @__PURE__ */ react.createElement(SelectOption, {
        "data-testid": "direct-grant-option",
        value: t5("sessionsType.directGrant")
      }), /* @__PURE__ */ react.createElement(SelectOption, {
        "data-testid": "service-account-option",
        value: t5("sessionsType.serviceAccount")
      })),
      columns: [
        {
          name: "username",
          displayKey: "sessions:subject"
        },
        {
          name: "lastAccess",
          displayKey: "sessions:lastAccess",
          cellRenderer: (row) => (0, import_moment6.default)(row.lastAccess).fromNow()
        },
        {
          name: "start",
          displayKey: "sessions:startDate",
          cellRenderer: (row) => (0, import_moment6.default)(row.lastAccess).format("LLL")
        },
        {
          name: "clients",
          displayKey: "sessions:accessedClients",
          cellRenderer: Clients
        }
      ],
      emptyState: /* @__PURE__ */ react.createElement(ListEmptyState, {
        hasIcon: true,
        icon: CubesIcon,
        message: t5("noSessions"),
        instructions: t5("noSessionsDescription")
      })
    })));
  }
});

// build/user-federation/UserFederationKerberosSettings.js
var require_UserFederationKerberosSettings = __commonJS((exports2) => {
  __markAsModule(exports2);
  __export(exports2, {
    default: () => UserFederationKerberosSettings
  });
  var KerberosSettingsHeader = ({
    onChange,
    value,
    save,
    toggleDeleteDialog
  }) => {
    const {t: t5} = useTranslation("user-federation");
    const {id: id3} = useParams();
    const [toggleDisableDialog, DisableConfirm] = useConfirmDialog({
      titleKey: "user-federation:userFedDisableConfirmTitle",
      messageKey: "user-federation:userFedDisableConfirm",
      continueButtonLabel: "common:disable",
      onConfirm: () => {
        onChange("false");
        save();
      }
    });
    return /* @__PURE__ */ react.createElement(react.Fragment, null, /* @__PURE__ */ react.createElement(DisableConfirm, null), !id3 ? /* @__PURE__ */ react.createElement(ViewHeader, {
      titleKey: "Kerberos"
    }) : /* @__PURE__ */ react.createElement(ViewHeader, {
      titleKey: "Kerberos",
      dropdownItems: [
        /* @__PURE__ */ react.createElement(DropdownItem, {
          key: "delete",
          onClick: () => toggleDeleteDialog(),
          "data-testid": "delete-kerberos-cmd"
        }, t5("deleteProvider"))
      ],
      isEnabled: value === "true",
      onToggle: (value2) => {
        if (!value2) {
          toggleDisableDialog();
        } else {
          onChange(value2.toString());
          save();
        }
      }
    }));
  };
  function UserFederationKerberosSettings() {
    const {t: t5} = useTranslation("user-federation");
    const form2 = useForm({mode: "onChange"});
    const history = useHistory();
    const adminClient = useAdminClient();
    const {realm: realm2} = useRealm();
    const {id: id3} = useParams();
    const {addAlert, addError} = useAlerts();
    useFetch(async () => {
      if (id3) {
        return adminClient.components.findOne({id: id3});
      }
    }, (fetchedComponent) => {
      if (fetchedComponent) {
        setupForm(fetchedComponent);
      } else if (id3) {
        throw new Error(t5("common:notFound"));
      }
    }, []);
    const setupForm = (component) => {
      form2.reset({...component});
    };
    const save = async (component) => {
      try {
        if (!id3) {
          await adminClient.components.create(component);
          history.push(`/${realm2}/user-federation`);
        } else {
          await adminClient.components.update({id: id3}, component);
        }
        setupForm(component);
        addAlert(t5(!id3 ? "createSuccess" : "saveSuccess"), AlertVariant.success);
      } catch (error2) {
        addError(`user-federation:${!id3 ? "createError" : "saveError"}`, error2);
      }
    };
    const [toggleDeleteDialog, DeleteConfirm] = useConfirmDialog({
      titleKey: "user-federation:userFedDeleteConfirmTitle",
      messageKey: "user-federation:userFedDeleteConfirm",
      continueButtonLabel: "common:delete",
      continueButtonVariant: ButtonVariant.danger,
      onConfirm: async () => {
        try {
          await adminClient.components.del({id: id3});
          addAlert(t5("userFedDeletedSuccess"), AlertVariant.success);
          history.replace(`/${realm2}/user-federation`);
        } catch (error2) {
          addAlert("user-federation:userFedDeleteError", error2);
        }
      }
    });
    return /* @__PURE__ */ react.createElement(react.Fragment, null, /* @__PURE__ */ react.createElement(DeleteConfirm, null), /* @__PURE__ */ react.createElement(Controller, {
      name: "config.enabled[0]",
      defaultValue: ["true"][0],
      control: form2.control,
      render: ({onChange, value}) => /* @__PURE__ */ react.createElement(KerberosSettingsHeader, {
        value,
        onChange,
        save: () => save(form2.getValues()),
        toggleDeleteDialog
      })
    }), /* @__PURE__ */ react.createElement(PageSection, {
      variant: "light"
    }, /* @__PURE__ */ react.createElement(KerberosSettingsRequired, {
      form: form2,
      showSectionHeading: true
    })), /* @__PURE__ */ react.createElement(PageSection, {
      variant: "light",
      isFilled: true
    }, /* @__PURE__ */ react.createElement(SettingsCache, {
      form: form2,
      showSectionHeading: true
    }), /* @__PURE__ */ react.createElement(Form, {
      onSubmit: form2.handleSubmit(save)
    }, /* @__PURE__ */ react.createElement(ActionGroup, null, /* @__PURE__ */ react.createElement(Button, {
      isDisabled: !form2.formState.isDirty,
      variant: "primary",
      type: "submit",
      "data-testid": "kerberos-save"
    }, t5("common:save")), /* @__PURE__ */ react.createElement(Button, {
      variant: "link",
      onClick: () => history.push(`/${realm2}/user-federation`),
      "data-testid": "kerberos-cancel"
    }, t5("common:cancel"))))));
  }
});

// build/user-federation/UserFederationLdapSettings.js
var require_UserFederationLdapSettings = __commonJS((exports2) => {
  __markAsModule(exports2);
  __export(exports2, {
    default: () => UserFederationLdapSettings
  });
  var LdapSettingsHeader = ({
    onChange,
    value,
    editMode,
    save,
    toggleDeleteDialog,
    toggleRemoveUsersDialog
  }) => {
    const {t: t5} = useTranslation("user-federation");
    const {id: id3} = useParams();
    const adminClient = useAdminClient();
    const {addAlert, addError} = useAlerts();
    const [toggleDisableDialog, DisableConfirm] = useConfirmDialog({
      titleKey: "user-federation:userFedDisableConfirmTitle",
      messageKey: "user-federation:userFedDisableConfirm",
      continueButtonLabel: "common:disable",
      onConfirm: () => {
        onChange("false");
        save();
      }
    });
    const [toggleUnlinkUsersDialog, UnlinkUsersDialog] = useConfirmDialog({
      titleKey: "user-federation:userFedUnlinkUsersConfirmTitle",
      messageKey: "user-federation:userFedUnlinkUsersConfirm",
      continueButtonLabel: "user-federation:unlinkUsers",
      onConfirm: () => unlinkUsers()
    });
    const syncChangedUsers = async () => {
      try {
        if (id3) {
          const response = await adminClient.userStorageProvider.sync({
            id: id3,
            action: "triggerChangedUsersSync"
          });
          if (response.ignored) {
            addAlert(`${response.status}.`, AlertVariant.warning);
          } else {
            addAlert(t5("syncUsersSuccess") + `${response.added} users added, ${response.updated} users updated, ${response.removed} users removed, ${response.failed} users failed.`, AlertVariant.success);
          }
        }
      } catch (error2) {
        addError("user-federation:syncUsersError", error2);
      }
    };
    const syncAllUsers = async () => {
      try {
        if (id3) {
          const response = await adminClient.userStorageProvider.sync({
            id: id3,
            action: "triggerFullSync"
          });
          if (response.ignored) {
            addAlert(`${response.status}.`, AlertVariant.warning);
          } else {
            addAlert(t5("syncUsersSuccess") + `${response.added} users added, ${response.updated} users updated, ${response.removed} users removed, ${response.failed} users failed.`, AlertVariant.success);
          }
        }
      } catch (error2) {
        addError("user-federation:syncUsersError", error2);
      }
    };
    const unlinkUsers = async () => {
      try {
        if (id3) {
          await adminClient.userStorageProvider.unlinkUsers({id: id3});
        }
        addAlert(t5("unlinkUsersSuccess"), AlertVariant.success);
      } catch (error2) {
        addError("user-federation:unlinkUsersError", error2);
      }
    };
    return /* @__PURE__ */ react.createElement(react.Fragment, null, /* @__PURE__ */ react.createElement(DisableConfirm, null), /* @__PURE__ */ react.createElement(UnlinkUsersDialog, null), !id3 ? /* @__PURE__ */ react.createElement(ViewHeader, {
      titleKey: t5("addOneLdap")
    }) : /* @__PURE__ */ react.createElement(ViewHeader, {
      titleKey: "LDAP",
      dropdownItems: [
        /* @__PURE__ */ react.createElement(DropdownItem, {
          key: "sync",
          onClick: syncChangedUsers
        }, t5("syncChangedUsers")),
        /* @__PURE__ */ react.createElement(DropdownItem, {
          key: "syncall",
          onClick: syncAllUsers
        }, t5("syncAllUsers")),
        /* @__PURE__ */ react.createElement(DropdownItem, {
          key: "unlink",
          isDisabled: editMode ? !editMode.includes("UNSYNCED") : false,
          onClick: toggleUnlinkUsersDialog
        }, t5("unlinkUsers")),
        /* @__PURE__ */ react.createElement(DropdownItem, {
          key: "remove",
          onClick: toggleRemoveUsersDialog
        }, t5("removeImported")),
        /* @__PURE__ */ react.createElement(DropdownSeparator, {
          key: "separator"
        }),
        /* @__PURE__ */ react.createElement(DropdownItem, {
          key: "delete",
          onClick: toggleDeleteDialog,
          "data-testid": "delete-ldap-cmd"
        }, t5("deleteProvider"))
      ],
      isEnabled: value === "true",
      onToggle: (value2) => {
        if (!value2) {
          toggleDisableDialog();
        } else {
          onChange("" + value2);
          save();
        }
      }
    }));
  };
  function UserFederationLdapSettings() {
    const {t: t5} = useTranslation("user-federation");
    const form2 = useForm({mode: "onChange"});
    const history = useHistory();
    const adminClient = useAdminClient();
    const {realm: realm2} = useRealm();
    const {id: id3} = useParams();
    const {addAlert, addError} = useAlerts();
    const [component, setComponent] = useState();
    const [refreshCount, setRefreshCount] = useState(0);
    const editMode = component?.config?.editMode;
    const refresh = () => setRefreshCount((count) => count + 1);
    useFetch(async () => {
      if (id3) {
        return await adminClient.components.findOne({id: id3});
      }
      return void 0;
    }, (fetchedComponent) => {
      if (fetchedComponent) {
        setupForm(fetchedComponent);
        setComponent(fetchedComponent);
      } else if (id3) {
        throw new Error(t5("common:notFound"));
      }
    }, [refreshCount]);
    const setupForm = (component2) => {
      form2.reset({...component2});
      form2.setValue("config.periodicChangedUsersSync", component2.config?.["changedSyncPeriod"][0] !== "-1");
      form2.setValue("config.periodicFullSync", component2.config?.["fullSyncPeriod"][0] !== "-1");
    };
    const removeImportedUsers = async () => {
      try {
        if (id3) {
          await adminClient.userStorageProvider.removeImportedUsers({id: id3});
        }
        addAlert(t5("removeImportedUsersSuccess"), AlertVariant.success);
      } catch (error2) {
        addError("user-federation:removeImportedUsersError", error2);
      }
    };
    const save = async (component2) => {
      if (component2.config?.periodicChangedUsersSync !== null) {
        if (component2.config?.periodicChangedUsersSync === false) {
          component2.config.changedSyncPeriod = ["-1"];
        }
        delete component2.config?.periodicChangedUsersSync;
      }
      if (component2.config?.periodicFullSync !== null) {
        if (component2.config?.periodicFullSync === false) {
          component2.config.fullSyncPeriod = ["-1"];
        }
        delete component2.config?.periodicFullSync;
      }
      try {
        if (!id3) {
          await adminClient.components.create(component2);
          history.push(`/${realm2}/user-federation`);
        } else {
          await adminClient.components.update({id: id3}, component2);
        }
        addAlert(t5(id3 ? "saveSuccess" : "createSuccess"), AlertVariant.success);
        refresh();
      } catch (error2) {
        addError(`user-federation:${id3 ? "saveError" : "createError"}`, error2);
      }
    };
    const [toggleRemoveUsersDialog, RemoveUsersConfirm] = useConfirmDialog({
      titleKey: t5("removeImportedUsers"),
      messageKey: t5("removeImportedUsersMessage"),
      continueButtonLabel: "common:remove",
      onConfirm: async () => {
        try {
          removeImportedUsers();
          addAlert(t5("removeImportedUsersSuccess"), AlertVariant.success);
        } catch (error2) {
          addError("user-federation:removeImportedUsersError", error2);
        }
      }
    });
    const [toggleDeleteDialog, DeleteConfirm] = useConfirmDialog({
      titleKey: "user-federation:userFedDeleteConfirmTitle",
      messageKey: "user-federation:userFedDeleteConfirm",
      continueButtonLabel: "common:delete",
      continueButtonVariant: ButtonVariant.danger,
      onConfirm: async () => {
        try {
          await adminClient.components.del({id: id3});
          addAlert(t5("userFedDeletedSuccess"), AlertVariant.success);
          history.replace(`/${realm2}/user-federation`);
        } catch (error2) {
          addError("user-federation:userFedDeleteError", error2);
        }
      }
    });
    const addLdapFormContent = () => {
      return /* @__PURE__ */ react.createElement(react.Fragment, null, /* @__PURE__ */ react.createElement(ScrollForm, {
        sections: [
          t5("generalOptions"),
          t5("connectionAndAuthenticationSettings"),
          t5("ldapSearchingAndUpdatingSettings"),
          t5("synchronizationSettings"),
          t5("kerberosIntegration"),
          t5("cacheSettings"),
          t5("advancedSettings")
        ]
      }, /* @__PURE__ */ react.createElement(LdapSettingsGeneral, {
        form: form2,
        vendorEdit: !!id3
      }), /* @__PURE__ */ react.createElement(LdapSettingsConnection, {
        form: form2,
        edit: !!id3
      }), /* @__PURE__ */ react.createElement(LdapSettingsSearching, {
        form: form2
      }), /* @__PURE__ */ react.createElement(LdapSettingsSynchronization, {
        form: form2
      }), /* @__PURE__ */ react.createElement(LdapSettingsKerberosIntegration, {
        form: form2
      }), /* @__PURE__ */ react.createElement(SettingsCache, {
        form: form2
      }), /* @__PURE__ */ react.createElement(LdapSettingsAdvanced, {
        form: form2
      })), /* @__PURE__ */ react.createElement(Form, {
        onSubmit: form2.handleSubmit(save)
      }, /* @__PURE__ */ react.createElement(ActionGroup, {
        className: "keycloak__form_actions"
      }, /* @__PURE__ */ react.createElement(Button, {
        isDisabled: !form2.formState.isDirty,
        variant: "primary",
        type: "submit",
        "data-testid": "ldap-save"
      }, t5("common:save")), /* @__PURE__ */ react.createElement(Button, {
        variant: "link",
        onClick: () => history.push(`/${realm2}/user-federation`),
        "data-testid": "ldap-cancel"
      }, t5("common:cancel")))));
    };
    return /* @__PURE__ */ react.createElement(react.Fragment, null, /* @__PURE__ */ react.createElement(DeleteConfirm, null), /* @__PURE__ */ react.createElement(RemoveUsersConfirm, null), /* @__PURE__ */ react.createElement(Controller, {
      name: "config.enabled[0]",
      defaultValue: ["true"][0],
      control: form2.control,
      render: ({onChange, value}) => /* @__PURE__ */ react.createElement(LdapSettingsHeader, {
        editMode,
        value,
        save: () => save(form2.getValues()),
        onChange,
        toggleDeleteDialog,
        toggleRemoveUsersDialog
      })
    }), /* @__PURE__ */ react.createElement(PageSection, {
      variant: "light",
      isFilled: true
    }, id3 ? /* @__PURE__ */ react.createElement(KeycloakTabs, {
      isBox: true
    }, /* @__PURE__ */ react.createElement(Tab, {
      id: "settings",
      eventKey: "settings",
      title: /* @__PURE__ */ react.createElement(TabTitleText, null, t5("common:settings"))
    }, addLdapFormContent()), /* @__PURE__ */ react.createElement(Tab, {
      id: "mappers",
      eventKey: "mappers",
      title: /* @__PURE__ */ react.createElement(TabTitleText, null, t5("common:mappers")),
      "data-testid": "ldap-mappers-tab"
    }, /* @__PURE__ */ react.createElement(LdapMapperList, null))) : addLdapFormContent()));
  }
});

// build/user-federation/UserFederationSection.js
var require_UserFederationSection = __commonJS((exports2) => {
  __markAsModule(exports2);
  __export(exports2, {
    default: () => UserFederationSection
  });
  function UserFederationSection() {
    const [userFederations, setUserFederations] = useState();
    const {addAlert, addError} = useAlerts();
    const {t: t5} = useTranslation("user-federation");
    const {realm: realm2} = useRealm();
    const adminClient = useAdminClient();
    const [key, setKey] = useState(0);
    const refresh = () => setKey(new Date().getTime());
    const {url} = useRouteMatch();
    const history = useHistory();
    useFetch(async () => {
      const realmModel = await adminClient.realms.findOne({realm: realm2});
      const testParams = {
        parentId: realmModel.id,
        type: "org.keycloak.storage.UserStorageProvider"
      };
      return adminClient.components.find(testParams);
    }, (userFederations2) => {
      setUserFederations(userFederations2);
    }, [key]);
    const ufAddProviderDropdownItems = [
      /* @__PURE__ */ react.createElement(DropdownItem, {
        key: "itemLDAP",
        onClick: () => history.push(`${url}/ldap/new`)
      }, "LDAP"),
      /* @__PURE__ */ react.createElement(DropdownItem, {
        key: "itemKerberos",
        onClick: () => history.push(`${url}/kerberos/new`)
      }, "Kerberos")
    ];
    const learnMoreLinkProps = {
      title: t5("common:learnMore"),
      href: "https://www.keycloak.org/docs/latest/server_admin/index.html#_user-storage-federation"
    };
    let cards;
    const [currentCard, setCurrentCard] = useState("");
    const [toggleDeleteDialog, DeleteConfirm] = useConfirmDialog({
      titleKey: t5("userFedDeleteConfirmTitle"),
      messageKey: t5("userFedDeleteConfirm"),
      continueButtonLabel: "common:delete",
      continueButtonVariant: ButtonVariant.danger,
      onConfirm: async () => {
        try {
          await adminClient.components.del({id: currentCard});
          refresh();
          addAlert(t5("userFedDeletedSuccess"), AlertVariant.success);
        } catch (error2) {
          addError("user-federation:userFedDeleteError", error2);
        }
      }
    });
    const toggleDeleteForCard = (id3) => {
      setCurrentCard(id3);
      toggleDeleteDialog();
    };
    if (userFederations) {
      cards = userFederations.map((userFederation, index3) => {
        const ufCardDropdownItems = [
          /* @__PURE__ */ react.createElement(DropdownItem, {
            key: `${index3}-cardDelete`,
            onClick: () => {
              toggleDeleteForCard(userFederation.id);
            },
            "data-testid": "card-delete"
          }, t5("common:delete"))
        ];
        return /* @__PURE__ */ react.createElement(GalleryItem, {
          key: index3,
          className: "keycloak-admin--user-federation__gallery-item"
        }, /* @__PURE__ */ react.createElement(KeycloakCard, {
          id: userFederation.id,
          dropdownItems: ufCardDropdownItems,
          providerId: userFederation.providerId,
          title: userFederation.name,
          footerText: userFederation.providerId === "ldap" ? "LDAP" : "Kerberos",
          labelText: userFederation.config["enabled"][0] !== "false" ? `${t5("common:enabled")}` : `${t5("common:disabled")}`,
          labelColor: userFederation.config["enabled"][0] !== "false" ? "blue" : "gray"
        }));
      });
    }
    return /* @__PURE__ */ react.createElement(react.Fragment, null, /* @__PURE__ */ react.createElement(ViewHeader, {
      titleKey: "userFederation",
      subKey: "user-federation:userFederationExplanation",
      subKeyLinkProps: learnMoreLinkProps,
      ...userFederations && userFederations.length > 0 ? {
        lowerDropdownItems: ufAddProviderDropdownItems,
        lowerDropdownMenuTitle: "user-federation:addNewProvider"
      } : {}
    }), /* @__PURE__ */ react.createElement(PageSection, null, userFederations && userFederations.length > 0 ? /* @__PURE__ */ react.createElement(react.Fragment, null, /* @__PURE__ */ react.createElement(DeleteConfirm, null), /* @__PURE__ */ react.createElement(Gallery, {
      hasGutter: true
    }, cards)) : /* @__PURE__ */ react.createElement(react.Fragment, null, /* @__PURE__ */ react.createElement(TextContent, null, /* @__PURE__ */ react.createElement(Text, {
      component: TextVariants.p
    }, t5("getStarted"))), /* @__PURE__ */ react.createElement(TextContent, null, /* @__PURE__ */ react.createElement(Text, {
      className: "pf-u-mt-lg",
      component: TextVariants.h2
    }, t5("providers"))), /* @__PURE__ */ react.createElement("hr", {
      className: "pf-u-mb-lg"
    }), /* @__PURE__ */ react.createElement(Gallery, {
      hasGutter: true
    }, /* @__PURE__ */ react.createElement(Card, {
      className: "keycloak-empty-state-card",
      isHoverable: true,
      onClick: () => history.push(`${url}/kerberos/new`),
      "data-testid": "kerberos-card"
    }, /* @__PURE__ */ react.createElement(CardTitle, null, /* @__PURE__ */ react.createElement(Split, {
      hasGutter: true
    }, /* @__PURE__ */ react.createElement(SplitItem, null, /* @__PURE__ */ react.createElement(DatabaseIcon, {
      size: "lg"
    })), /* @__PURE__ */ react.createElement(SplitItem, {
      isFilled: true
    }, t5("addKerberos"))))), /* @__PURE__ */ react.createElement(Card, {
      className: "keycloak-empty-state-card",
      isHoverable: true,
      onClick: () => history.push(`${url}/ldap/new`),
      "data-testid": "ldap-card"
    }, /* @__PURE__ */ react.createElement(CardTitle, null, /* @__PURE__ */ react.createElement(Split, {
      hasGutter: true
    }, /* @__PURE__ */ react.createElement(SplitItem, null, /* @__PURE__ */ react.createElement(DatabaseIcon, {
      size: "lg"
    })), /* @__PURE__ */ react.createElement(SplitItem, {
      isFilled: true
    }, t5("addLdap")))))))));
  }
});

// build/user-federation/ldap/mappers/LdapMapperDetails.js
var require_LdapMapperDetails = __commonJS((exports2) => {
  __markAsModule(exports2);
  __export(exports2, {
    default: () => LdapMapperDetails
  });
  function LdapMapperDetails() {
    const form2 = useForm();
    const [mapping, setMapping] = useState();
    const adminClient = useAdminClient();
    const {id: id3, mapperId} = useParams();
    const history = useHistory();
    const {realm: realm2} = useRealm();
    const {t: t5} = useTranslation("user-federation");
    const helpText = useTranslation("user-federation-help").t;
    const {addAlert, addError} = useAlerts();
    const [isMapperDropdownOpen, setIsMapperDropdownOpen] = useState(false);
    useFetch(async () => {
      if (mapperId && mapperId !== "new") {
        const fetchedMapper = await adminClient.components.findOne({
          id: mapperId
        });
        if (!fetchedMapper) {
          throw new Error(t5("common:notFound"));
        }
        return fetchedMapper;
      }
    }, (fetchedMapper) => {
      setMapping(fetchedMapper);
      if (fetchedMapper) {
        setupForm(fetchedMapper);
      }
    }, []);
    const setupForm = (mapper) => {
      convertToFormValues(mapper, form2.setValue);
    };
    const save = async (mapper) => {
      const map2 = convertFormValuesToObject(mapper);
      try {
        if (mapperId) {
          if (mapperId === "new") {
            await adminClient.components.create(map2);
            history.push(`/${realm2}/user-federation/ldap/${mapper.parentId}/mappers`);
          } else {
            await adminClient.components.update({id: mapperId}, map2);
          }
        }
        setupForm(map2);
        addAlert(t5(mapperId === "new" ? "common:mappingCreatedSuccess" : "common:mappingUpdatedSuccess"), AlertVariant.success);
      } catch (error2) {
        addError(mapperId === "new" ? "common:mappingCreatedError" : "common:mappingUpdatedError", error2);
      }
    };
    const mapperType = useWatch({
      control: form2.control,
      name: "providerId"
    });
    const isNew = mapperId === "new";
    return /* @__PURE__ */ react.createElement(react.Fragment, null, /* @__PURE__ */ react.createElement(ViewHeader, {
      titleKey: mapping ? mapping.name : t5("common:createNewMapper")
    }), /* @__PURE__ */ react.createElement(PageSection, {
      variant: "light",
      isFilled: true
    }, /* @__PURE__ */ react.createElement(FormAccess, {
      role: "manage-realm",
      isHorizontal: true
    }, !isNew && /* @__PURE__ */ react.createElement(FormGroup, {
      label: t5("common:id"),
      fieldId: "kc-ldap-mapper-id"
    }, /* @__PURE__ */ react.createElement(TextInput, {
      isDisabled: true,
      type: "text",
      id: "kc-ldap-mapper-id",
      "data-testid": "ldap-mapper-id",
      name: "id",
      ref: form2.register
    })), /* @__PURE__ */ react.createElement(FormGroup, {
      label: t5("common:name"),
      labelIcon: /* @__PURE__ */ react.createElement(HelpItem, {
        helpText: helpText("nameHelp"),
        forLabel: t5("common:name"),
        forID: "kc-ldap-mapper-name"
      }),
      fieldId: "kc-ldap-mapper-name",
      isRequired: true
    }, /* @__PURE__ */ react.createElement(TextInput, {
      isDisabled: !isNew,
      isRequired: true,
      type: "text",
      id: "kc-ldap-mapper-name",
      "data-testid": "ldap-mapper-name",
      name: "name",
      ref: form2.register({required: true}),
      validated: form2.errors.name ? ValidatedOptions.error : ValidatedOptions.default
    }), /* @__PURE__ */ react.createElement(TextInput, {
      hidden: true,
      defaultValue: isNew ? id3 : mapping ? mapping.parentId : "",
      type: "text",
      id: "kc-ldap-parentId",
      "data-testid": "ldap-mapper-parentId",
      name: "parentId",
      ref: form2.register
    }), /* @__PURE__ */ react.createElement(TextInput, {
      hidden: true,
      defaultValue: "org.keycloak.storage.ldap.mappers.LDAPStorageMapper",
      type: "text",
      id: "kc-ldap-provider-type",
      "data-testid": "ldap-mapper-provider-type",
      name: "providerType",
      ref: form2.register
    })), !isNew ? /* @__PURE__ */ react.createElement(FormGroup, {
      label: t5("common:mapperType"),
      labelIcon: /* @__PURE__ */ react.createElement(HelpItem, {
        helpText: helpText("mapperTypeHelp"),
        forLabel: t5("common:mapperType"),
        forID: "kc-ldap-mapper-type"
      }),
      fieldId: "kc-ldap-mapper-type",
      isRequired: true
    }, /* @__PURE__ */ react.createElement(TextInput, {
      isDisabled: !isNew,
      isRequired: true,
      type: "text",
      id: "kc-ldap-mapper-type",
      "data-testid": "ldap-mapper-type-fld",
      name: "providerId",
      ref: form2.register
    })) : /* @__PURE__ */ react.createElement(FormGroup, {
      label: t5("common:mapperType"),
      labelIcon: /* @__PURE__ */ react.createElement(HelpItem, {
        helpText: helpText("mapperTypeHelp"),
        forLabel: t5("common:mapperType"),
        forID: "kc-providerId"
      }),
      fieldId: "kc-providerId",
      isRequired: true
    }, /* @__PURE__ */ react.createElement(Controller, {
      name: "providerId",
      defaultValue: "",
      control: form2.control,
      "data-testid": "ldap-mapper-type-select",
      render: ({onChange, value}) => /* @__PURE__ */ react.createElement(Select, {
        toggleId: "kc-providerId",
        required: true,
        onToggle: () => setIsMapperDropdownOpen(!isMapperDropdownOpen),
        isOpen: isMapperDropdownOpen,
        onSelect: (_23, value2) => {
          onChange(value2);
          setIsMapperDropdownOpen(false);
        },
        selections: value,
        variant: SelectVariant.typeahead
      }, /* @__PURE__ */ react.createElement(SelectOption, {
        key: 0,
        value: "msad-user-account-control-mapper"
      }), /* @__PURE__ */ react.createElement(SelectOption, {
        key: 1,
        value: "msad-lds-user-account-control-mapper"
      }), /* @__PURE__ */ react.createElement(SelectOption, {
        key: 2,
        value: "group-ldap-mapper"
      }), /* @__PURE__ */ react.createElement(SelectOption, {
        key: 3,
        value: "user-attribute-ldap-mapper"
      }), /* @__PURE__ */ react.createElement(SelectOption, {
        key: 4,
        value: "role-ldap-mapper"
      }), /* @__PURE__ */ react.createElement(SelectOption, {
        key: 5,
        value: "hardcoded-attribute-mapper"
      }), /* @__PURE__ */ react.createElement(SelectOption, {
        key: 6,
        value: "hardcoded-ldap-role-mapper"
      }), /* @__PURE__ */ react.createElement(SelectOption, {
        key: 7,
        value: "certificate-ldap-mapper"
      }), /* @__PURE__ */ react.createElement(SelectOption, {
        key: 8,
        value: "full-name-ldap-mapper"
      }), /* @__PURE__ */ react.createElement(SelectOption, {
        key: 9,
        value: "hardcoded-ldap-group-mapper"
      }), /* @__PURE__ */ react.createElement(SelectOption, {
        key: 10,
        value: "hardcoded-ldap-attribute-mapper"
      }))
    })), mapping ? (mapping.providerId === "certificate-ldap-mapper" || mapping.providerId === "user-attribute-ldap-mapper") && /* @__PURE__ */ react.createElement(LdapMapperUserAttribute, {
      form: form2,
      mapperType: mapping.providerId
    }) : "", mapping ? mapping.providerId === "msad-user-account-control-mapper" && /* @__PURE__ */ react.createElement(LdapMapperMsadUserAccount, {
      form: form2
    }) : "", mapping ? mapping.providerId === "full-name-ldap-mapper" && /* @__PURE__ */ react.createElement(LdapMapperFullNameAttribute, {
      form: form2
    }) : "", mapping ? mapping.providerId === "hardcoded-ldap-role-mapper" && /* @__PURE__ */ react.createElement(LdapMapperHardcodedLdapRole, {
      form: form2
    }) : "", mapping ? mapping.providerId === "hardcoded-ldap-group-mapper" && /* @__PURE__ */ react.createElement(LdapMapperHardcodedLdapGroup, {
      form: form2
    }) : "", mapping ? mapping.providerId === "hardcoded-ldap-attribute-mapper" && /* @__PURE__ */ react.createElement(LdapMapperHardcodedLdapAttribute, {
      form: form2
    }) : "", mapping ? mapping.providerId === "hardcoded-attribute-mapper" && /* @__PURE__ */ react.createElement(LdapMapperHardcodedAttribute, {
      form: form2
    }) : "", mapping ? (mapping.providerId === "role-ldap-mapper" || mapping.providerId === "group-ldap-mapper") && /* @__PURE__ */ react.createElement(LdapMapperRoleGroup, {
      form: form2,
      type: mapping.providerId
    }) : "", isNew && mapperType ? mapperType === "certificate-ldap-mapper" && /* @__PURE__ */ react.createElement(LdapMapperUserAttribute, {
      form: form2,
      mapperType
    }) : "", isNew && mapperType ? mapperType === "user-attribute-ldap-mapper" && /* @__PURE__ */ react.createElement(LdapMapperUserAttribute, {
      form: form2,
      mapperType
    }) : "", isNew && mapperType ? mapperType === "msad-user-account-control-mapper" && /* @__PURE__ */ react.createElement(LdapMapperMsadUserAccount, {
      form: form2
    }) : "", isNew && mapperType ? mapperType === "full-name-ldap-mapper" && /* @__PURE__ */ react.createElement(LdapMapperFullNameAttribute, {
      form: form2
    }) : "", isNew && mapperType ? mapperType === "hardcoded-ldap-role-mapper" && /* @__PURE__ */ react.createElement(LdapMapperHardcodedLdapRole, {
      form: form2
    }) : "", isNew && mapperType ? mapperType === "hardcoded-ldap-group-mapper" && /* @__PURE__ */ react.createElement(LdapMapperHardcodedLdapGroup, {
      form: form2
    }) : "", isNew && mapperType ? mapperType === "hardcoded-ldap-attribute-mapper" && /* @__PURE__ */ react.createElement(LdapMapperHardcodedLdapAttribute, {
      form: form2
    }) : "", isNew && mapperType ? mapperType === "hardcoded-attribute-mapper" && /* @__PURE__ */ react.createElement(LdapMapperHardcodedAttribute, {
      form: form2
    }) : "", isNew && mapperType ? mapperType === "role-ldap-mapper" && /* @__PURE__ */ react.createElement(LdapMapperRoleGroup, {
      form: form2,
      type: mapperType
    }) : "", isNew && mapperType ? mapperType === "group-ldap-mapper" && /* @__PURE__ */ react.createElement(LdapMapperRoleGroup, {
      form: form2,
      type: mapperType
    }) : ""), /* @__PURE__ */ react.createElement(Form, {
      onSubmit: form2.handleSubmit(() => save(form2.getValues()))
    }, /* @__PURE__ */ react.createElement(ActionGroup, null, /* @__PURE__ */ react.createElement(Button, {
      isDisabled: !form2.formState.isDirty,
      variant: "primary",
      type: "submit",
      "data-testid": "ldap-mapper-save"
    }, t5("common:save")), /* @__PURE__ */ react.createElement(Button, {
      variant: "link",
      onClick: () => isNew ? history.goBack() : history.push(`/${realm2}/user-federation/ldap/${mapping.parentId}/mappers`),
      "data-testid": "ldap-mapper-cancel"
    }, t5("common:cancel"))))));
  }
});

// build/_snowpack/pkg/@keycloak/keycloak-admin-client.js
var require_keycloak_admin_client = __commonJS((exports) => {
  __markAsModule(exports);
  __export(exports, {
    default: () => keycloak_admin_client_default
  });
  var requiredActionProviderRepresentation = createCommonjsModule(function(module2, exports2) {
    exports2.__esModule = true;
    exports2.RequiredActionAlias = void 0;
    (function(RequiredActionAlias) {
      RequiredActionAlias["VERIFY_EMAIL"] = "VERIFY_EMAIL";
      RequiredActionAlias["UPDATE_PROFILE"] = "UPDATE_PROFILE";
      RequiredActionAlias["CONFIGURE_TOTP"] = "CONFIGURE_TOTP";
      RequiredActionAlias["UPDATE_PASSWORD"] = "UPDATE_PASSWORD";
      RequiredActionAlias["terms_and_conditions"] = "terms_and_conditions";
    })(exports2.RequiredActionAlias || (exports2.RequiredActionAlias = {}));
  });
  var INFINITY = 1 / 0;
  var symbolTag = "[object Symbol]";
  var reAsciiWord = /[^\x00-\x2f\x3a-\x40\x5b-\x60\x7b-\x7f]+/g;
  var reLatin = /[\xc0-\xd6\xd8-\xf6\xf8-\xff\u0100-\u017f]/g;
  var rsAstralRange = "\\ud800-\\udfff";
  var rsComboMarksRange = "\\u0300-\\u036f\\ufe20-\\ufe23";
  var rsComboSymbolsRange = "\\u20d0-\\u20f0";
  var rsDingbatRange = "\\u2700-\\u27bf";
  var rsLowerRange = "a-z\\xdf-\\xf6\\xf8-\\xff";
  var rsMathOpRange = "\\xac\\xb1\\xd7\\xf7";
  var rsNonCharRange = "\\x00-\\x2f\\x3a-\\x40\\x5b-\\x60\\x7b-\\xbf";
  var rsPunctuationRange = "\\u2000-\\u206f";
  var rsSpaceRange = " \\t\\x0b\\f\\xa0\\ufeff\\n\\r\\u2028\\u2029\\u1680\\u180e\\u2000\\u2001\\u2002\\u2003\\u2004\\u2005\\u2006\\u2007\\u2008\\u2009\\u200a\\u202f\\u205f\\u3000";
  var rsUpperRange = "A-Z\\xc0-\\xd6\\xd8-\\xde";
  var rsVarRange = "\\ufe0e\\ufe0f";
  var rsBreakRange = rsMathOpRange + rsNonCharRange + rsPunctuationRange + rsSpaceRange;
  var rsApos = "['’]";
  var rsAstral = "[" + rsAstralRange + "]";
  var rsBreak = "[" + rsBreakRange + "]";
  var rsCombo = "[" + rsComboMarksRange + rsComboSymbolsRange + "]";
  var rsDigits = "\\d+";
  var rsDingbat = "[" + rsDingbatRange + "]";
  var rsLower = "[" + rsLowerRange + "]";
  var rsMisc = "[^" + rsAstralRange + rsBreakRange + rsDigits + rsDingbatRange + rsLowerRange + rsUpperRange + "]";
  var rsFitz = "\\ud83c[\\udffb-\\udfff]";
  var rsModifier = "(?:" + rsCombo + "|" + rsFitz + ")";
  var rsNonAstral = "[^" + rsAstralRange + "]";
  var rsRegional = "(?:\\ud83c[\\udde6-\\uddff]){2}";
  var rsSurrPair = "[\\ud800-\\udbff][\\udc00-\\udfff]";
  var rsUpper = "[" + rsUpperRange + "]";
  var rsZWJ = "\\u200d";
  var rsLowerMisc = "(?:" + rsLower + "|" + rsMisc + ")";
  var rsUpperMisc = "(?:" + rsUpper + "|" + rsMisc + ")";
  var rsOptLowerContr = "(?:" + rsApos + "(?:d|ll|m|re|s|t|ve))?";
  var rsOptUpperContr = "(?:" + rsApos + "(?:D|LL|M|RE|S|T|VE))?";
  var reOptMod = rsModifier + "?";
  var rsOptVar = "[" + rsVarRange + "]?";
  var rsOptJoin = "(?:" + rsZWJ + "(?:" + [rsNonAstral, rsRegional, rsSurrPair].join("|") + ")" + rsOptVar + reOptMod + ")*";
  var rsSeq = rsOptVar + reOptMod + rsOptJoin;
  var rsEmoji = "(?:" + [rsDingbat, rsRegional, rsSurrPair].join("|") + ")" + rsSeq;
  var rsSymbol = "(?:" + [rsNonAstral + rsCombo + "?", rsCombo, rsRegional, rsSurrPair, rsAstral].join("|") + ")";
  var reApos = RegExp(rsApos, "g");
  var reComboMark = RegExp(rsCombo, "g");
  var reUnicode = RegExp(rsFitz + "(?=" + rsFitz + ")|" + rsSymbol + rsSeq, "g");
  var reUnicodeWord = RegExp([
    rsUpper + "?" + rsLower + "+" + rsOptLowerContr + "(?=" + [rsBreak, rsUpper, "$"].join("|") + ")",
    rsUpperMisc + "+" + rsOptUpperContr + "(?=" + [rsBreak, rsUpper + rsLowerMisc, "$"].join("|") + ")",
    rsUpper + "?" + rsLowerMisc + "+" + rsOptLowerContr,
    rsUpper + "+" + rsOptUpperContr,
    rsDigits,
    rsEmoji
  ].join("|"), "g");
  var reHasUnicode = RegExp("[" + rsZWJ + rsAstralRange + rsComboMarksRange + rsComboSymbolsRange + rsVarRange + "]");
  var reHasUnicodeWord = /[a-z][A-Z]|[A-Z]{2,}[a-z]|[0-9][a-zA-Z]|[a-zA-Z][0-9]|[^a-zA-Z0-9 ]/;
  var deburredLetters = {
    À: "A",
    Á: "A",
    Â: "A",
    Ã: "A",
    Ä: "A",
    Å: "A",
    à: "a",
    á: "a",
    â: "a",
    ã: "a",
    ä: "a",
    å: "a",
    Ç: "C",
    ç: "c",
    Ð: "D",
    ð: "d",
    È: "E",
    É: "E",
    Ê: "E",
    Ë: "E",
    è: "e",
    é: "e",
    ê: "e",
    ë: "e",
    Ì: "I",
    Í: "I",
    Î: "I",
    Ï: "I",
    ì: "i",
    í: "i",
    î: "i",
    ï: "i",
    Ñ: "N",
    ñ: "n",
    Ò: "O",
    Ó: "O",
    Ô: "O",
    Õ: "O",
    Ö: "O",
    Ø: "O",
    ò: "o",
    ó: "o",
    ô: "o",
    õ: "o",
    ö: "o",
    ø: "o",
    Ù: "U",
    Ú: "U",
    Û: "U",
    Ü: "U",
    ù: "u",
    ú: "u",
    û: "u",
    ü: "u",
    Ý: "Y",
    ý: "y",
    ÿ: "y",
    Æ: "Ae",
    æ: "ae",
    Þ: "Th",
    þ: "th",
    ß: "ss",
    Ā: "A",
    Ă: "A",
    Ą: "A",
    ā: "a",
    ă: "a",
    ą: "a",
    Ć: "C",
    Ĉ: "C",
    Ċ: "C",
    Č: "C",
    ć: "c",
    ĉ: "c",
    ċ: "c",
    č: "c",
    Ď: "D",
    Đ: "D",
    ď: "d",
    đ: "d",
    Ē: "E",
    Ĕ: "E",
    Ė: "E",
    Ę: "E",
    Ě: "E",
    ē: "e",
    ĕ: "e",
    ė: "e",
    ę: "e",
    ě: "e",
    Ĝ: "G",
    Ğ: "G",
    Ġ: "G",
    Ģ: "G",
    ĝ: "g",
    ğ: "g",
    ġ: "g",
    ģ: "g",
    Ĥ: "H",
    Ħ: "H",
    ĥ: "h",
    ħ: "h",
    Ĩ: "I",
    Ī: "I",
    Ĭ: "I",
    Į: "I",
    İ: "I",
    ĩ: "i",
    ī: "i",
    ĭ: "i",
    į: "i",
    ı: "i",
    Ĵ: "J",
    ĵ: "j",
    Ķ: "K",
    ķ: "k",
    ĸ: "k",
    Ĺ: "L",
    Ļ: "L",
    Ľ: "L",
    Ŀ: "L",
    Ł: "L",
    ĺ: "l",
    ļ: "l",
    ľ: "l",
    ŀ: "l",
    ł: "l",
    Ń: "N",
    Ņ: "N",
    Ň: "N",
    Ŋ: "N",
    ń: "n",
    ņ: "n",
    ň: "n",
    ŋ: "n",
    Ō: "O",
    Ŏ: "O",
    Ő: "O",
    ō: "o",
    ŏ: "o",
    ő: "o",
    Ŕ: "R",
    Ŗ: "R",
    Ř: "R",
    ŕ: "r",
    ŗ: "r",
    ř: "r",
    Ś: "S",
    Ŝ: "S",
    Ş: "S",
    Š: "S",
    ś: "s",
    ŝ: "s",
    ş: "s",
    š: "s",
    Ţ: "T",
    Ť: "T",
    Ŧ: "T",
    ţ: "t",
    ť: "t",
    ŧ: "t",
    Ũ: "U",
    Ū: "U",
    Ŭ: "U",
    Ů: "U",
    Ű: "U",
    Ų: "U",
    ũ: "u",
    ū: "u",
    ŭ: "u",
    ů: "u",
    ű: "u",
    ų: "u",
    Ŵ: "W",
    ŵ: "w",
    Ŷ: "Y",
    ŷ: "y",
    Ÿ: "Y",
    Ź: "Z",
    Ż: "Z",
    Ž: "Z",
    ź: "z",
    ż: "z",
    ž: "z",
    Ĳ: "IJ",
    ĳ: "ij",
    Œ: "Oe",
    œ: "oe",
    ŉ: "'n",
    ſ: "ss"
  };
  var freeGlobal = typeof commonjsGlobal == "object" && commonjsGlobal && commonjsGlobal.Object === Object && commonjsGlobal;
  var freeSelf = typeof self == "object" && self && self.Object === Object && self;
  var root = freeGlobal || freeSelf || Function("return this")();
  function arrayReduce(array2, iteratee, accumulator, initAccum) {
    var index3 = -1, length = array2 ? array2.length : 0;
    if (initAccum && length) {
      accumulator = array2[++index3];
    }
    while (++index3 < length) {
      accumulator = iteratee(accumulator, array2[index3], index3, array2);
    }
    return accumulator;
  }
  function asciiToArray(string2) {
    return string2.split("");
  }
  function asciiWords(string2) {
    return string2.match(reAsciiWord) || [];
  }
  function basePropertyOf(object) {
    return function(key) {
      return object == null ? void 0 : object[key];
    };
  }
  var deburrLetter = basePropertyOf(deburredLetters);
  function hasUnicode(string2) {
    return reHasUnicode.test(string2);
  }
  function hasUnicodeWord(string2) {
    return reHasUnicodeWord.test(string2);
  }
  function stringToArray(string2) {
    return hasUnicode(string2) ? unicodeToArray(string2) : asciiToArray(string2);
  }
  function unicodeToArray(string2) {
    return string2.match(reUnicode) || [];
  }
  function unicodeWords(string2) {
    return string2.match(reUnicodeWord) || [];
  }
  var objectProto = Object.prototype;
  var objectToString = objectProto.toString;
  var Symbol$1 = root.Symbol;
  var symbolProto = Symbol$1 ? Symbol$1.prototype : void 0;
  var symbolToString = symbolProto ? symbolProto.toString : void 0;
  function baseSlice(array2, start3, end2) {
    var index3 = -1, length = array2.length;
    if (start3 < 0) {
      start3 = -start3 > length ? 0 : length + start3;
    }
    end2 = end2 > length ? length : end2;
    if (end2 < 0) {
      end2 += length;
    }
    length = start3 > end2 ? 0 : end2 - start3 >>> 0;
    start3 >>>= 0;
    var result = Array(length);
    while (++index3 < length) {
      result[index3] = array2[index3 + start3];
    }
    return result;
  }
  function baseToString(value) {
    if (typeof value == "string") {
      return value;
    }
    if (isSymbol(value)) {
      return symbolToString ? symbolToString.call(value) : "";
    }
    var result = value + "";
    return result == "0" && 1 / value == -INFINITY ? "-0" : result;
  }
  function castSlice(array2, start3, end2) {
    var length = array2.length;
    end2 = end2 === void 0 ? length : end2;
    return !start3 && end2 >= length ? array2 : baseSlice(array2, start3, end2);
  }
  function createCaseFirst(methodName) {
    return function(string2) {
      string2 = toString(string2);
      var strSymbols = hasUnicode(string2) ? stringToArray(string2) : void 0;
      var chr = strSymbols ? strSymbols[0] : string2.charAt(0);
      var trailing = strSymbols ? castSlice(strSymbols, 1).join("") : string2.slice(1);
      return chr[methodName]() + trailing;
    };
  }
  function createCompounder(callback) {
    return function(string2) {
      return arrayReduce(words(deburr(string2).replace(reApos, "")), callback, "");
    };
  }
  function isObjectLike(value) {
    return !!value && typeof value == "object";
  }
  function isSymbol(value) {
    return typeof value == "symbol" || isObjectLike(value) && objectToString.call(value) == symbolTag;
  }
  function toString(value) {
    return value == null ? "" : baseToString(value);
  }
  var camelCase = createCompounder(function(result, word, index3) {
    word = word.toLowerCase();
    return result + (index3 ? capitalize(word) : word);
  });
  function capitalize(string2) {
    return upperFirst(toString(string2).toLowerCase());
  }
  function deburr(string2) {
    string2 = toString(string2);
    return string2 && string2.replace(reLatin, deburrLetter).replace(reComboMark, "");
  }
  var upperFirst = createCaseFirst("toUpperCase");
  function words(string2, pattern, guard) {
    string2 = toString(string2);
    pattern = guard ? void 0 : pattern;
    if (pattern === void 0) {
      return hasUnicodeWord(string2) ? unicodeWords(string2) : asciiWords(string2);
    }
    return string2.match(pattern) || [];
  }
  var lodash_camelcase = camelCase;
  var lodash_isdate = createCommonjsModule(function(module2, exports2) {
    var dateTag3 = "[object Date]";
    var freeGlobal3 = typeof commonjsGlobal == "object" && commonjsGlobal && commonjsGlobal.Object === Object && commonjsGlobal;
    var freeExports = exports2 && !exports2.nodeType && exports2;
    var freeModule = freeExports && true && module2 && !module2.nodeType && module2;
    var moduleExports = freeModule && freeModule.exports === freeExports;
    var freeProcess = moduleExports && freeGlobal3.process;
    var nodeUtil = function() {
      try {
        return freeProcess && freeProcess.binding("util");
      } catch (e2) {
      }
    }();
    var nodeIsDate = nodeUtil && nodeUtil.isDate;
    function baseUnary2(func) {
      return function(value) {
        return func(value);
      };
    }
    var objectProto4 = Object.prototype;
    var objectToString3 = objectProto4.toString;
    function baseIsDate(value) {
      return isObjectLike3(value) && objectToString3.call(value) == dateTag3;
    }
    var isDate2 = nodeIsDate ? baseUnary2(nodeIsDate) : baseIsDate;
    function isObjectLike3(value) {
      return !!value && typeof value == "object";
    }
    module2.exports = isDate2;
  });
  var lodash_isregexp = createCommonjsModule(function(module2, exports2) {
    var regexpTag3 = "[object RegExp]";
    var freeGlobal3 = typeof commonjsGlobal == "object" && commonjsGlobal && commonjsGlobal.Object === Object && commonjsGlobal;
    var freeExports = exports2 && !exports2.nodeType && exports2;
    var freeModule = freeExports && true && module2 && !module2.nodeType && module2;
    var moduleExports = freeModule && freeModule.exports === freeExports;
    var freeProcess = moduleExports && freeGlobal3.process;
    var nodeUtil = function() {
      try {
        return freeProcess && freeProcess.binding("util");
      } catch (e2) {
      }
    }();
    var nodeIsRegExp = nodeUtil && nodeUtil.isRegExp;
    function baseUnary2(func) {
      return function(value) {
        return func(value);
      };
    }
    var objectProto4 = Object.prototype;
    var objectToString3 = objectProto4.toString;
    function baseIsRegExp(value) {
      return isObject5(value) && objectToString3.call(value) == regexpTag3;
    }
    function isObject5(value) {
      var type = typeof value;
      return !!value && (type == "object" || type == "function");
    }
    var isRegExp = nodeIsRegExp ? baseUnary2(nodeIsRegExp) : baseIsRegExp;
    module2.exports = isRegExp;
  });
  var dist = createCommonjsModule(function(module2, exports2) {
    var __importDefault = commonjsGlobal && commonjsGlobal.__importDefault || function(mod) {
      return mod && mod.__esModule ? mod : {default: mod};
    };
    Object.defineProperty(exports2, "__esModule", {value: true});
    const lodash_camelcase_1 = __importDefault(lodash_camelcase);
    const lodash_isdate_1 = __importDefault(lodash_isdate);
    const lodash_isregexp_1 = __importDefault(lodash_isregexp);
    function walk(obj) {
      if (!obj || typeof obj !== "object")
        return obj;
      if (lodash_isdate_1.default(obj) || lodash_isregexp_1.default(obj))
        return obj;
      if (Array.isArray(obj))
        return obj.map(walk);
      return Object.keys(obj).reduce((res, key) => {
        const camel = lodash_camelcase_1.default(key);
        res[camel] = walk(obj[key]);
        return res;
      }, {});
    }
    function camelize3(obj) {
      return typeof obj === "string" ? lodash_camelcase_1.default(obj) : walk(obj);
    }
    exports2.default = camelize3;
  });
  var strictUriEncode = (str) => encodeURIComponent(str).replace(/[!'()*]/g, (x2) => `%${x2.charCodeAt(0).toString(16).toUpperCase()}`);
  var token = "%[a-f0-9]{2}";
  var singleMatcher = new RegExp(token, "gi");
  var multiMatcher = new RegExp("(" + token + ")+", "gi");
  function decodeComponents(components3, split2) {
    try {
      return decodeURIComponent(components3.join(""));
    } catch (err) {
    }
    if (components3.length === 1) {
      return components3;
    }
    split2 = split2 || 1;
    var left2 = components3.slice(0, split2);
    var right2 = components3.slice(split2);
    return Array.prototype.concat.call([], decodeComponents(left2), decodeComponents(right2));
  }
  function decode(input) {
    try {
      return decodeURIComponent(input);
    } catch (err) {
      var tokens = input.match(singleMatcher);
      for (var i3 = 1; i3 < tokens.length; i3++) {
        input = decodeComponents(tokens, i3).join("");
        tokens = input.match(singleMatcher);
      }
      return input;
    }
  }
  function customDecodeURIComponent(input) {
    var replaceMap = {
      "%FE%FF": "��",
      "%FF%FE": "��"
    };
    var match2 = multiMatcher.exec(input);
    while (match2) {
      try {
        replaceMap[match2[0]] = decodeURIComponent(match2[0]);
      } catch (err) {
        var result = decode(match2[0]);
        if (result !== match2[0]) {
          replaceMap[match2[0]] = result;
        }
      }
      match2 = multiMatcher.exec(input);
    }
    replaceMap["%C2"] = "�";
    var entries = Object.keys(replaceMap);
    for (var i3 = 0; i3 < entries.length; i3++) {
      var key = entries[i3];
      input = input.replace(new RegExp(key, "g"), replaceMap[key]);
    }
    return input;
  }
  var decodeUriComponent = function(encodedURI) {
    if (typeof encodedURI !== "string") {
      throw new TypeError("Expected `encodedURI` to be of type `string`, got `" + typeof encodedURI + "`");
    }
    try {
      encodedURI = encodedURI.replace(/\+/g, " ");
      return decodeURIComponent(encodedURI);
    } catch (err) {
      return customDecodeURIComponent(encodedURI);
    }
  };
  var splitOnFirst = (string2, separator) => {
    if (!(typeof string2 === "string" && typeof separator === "string")) {
      throw new TypeError("Expected the arguments to be of type `string`");
    }
    if (separator === "") {
      return [string2];
    }
    const separatorIndex = string2.indexOf(separator);
    if (separatorIndex === -1) {
      return [string2];
    }
    return [
      string2.slice(0, separatorIndex),
      string2.slice(separatorIndex + separator.length)
    ];
  };
  var filterObj = function(obj, predicate) {
    var ret = {};
    var keys2 = Object.keys(obj);
    var isArr = Array.isArray(predicate);
    for (var i3 = 0; i3 < keys2.length; i3++) {
      var key = keys2[i3];
      var val = obj[key];
      if (isArr ? predicate.indexOf(key) !== -1 : predicate(key, val, obj)) {
        ret[key] = val;
      }
    }
    return ret;
  };
  var queryString = createCommonjsModule(function(module2, exports2) {
    const isNullOrUndefined2 = (value) => value === null || value === void 0;
    const encodeFragmentIdentifier = Symbol("encodeFragmentIdentifier");
    function encoderForArrayFormat(options) {
      switch (options.arrayFormat) {
        case "index":
          return (key) => (result, value) => {
            const index3 = result.length;
            if (value === void 0 || options.skipNull && value === null || options.skipEmptyString && value === "") {
              return result;
            }
            if (value === null) {
              return [...result, [encode2(key, options), "[", index3, "]"].join("")];
            }
            return [
              ...result,
              [encode2(key, options), "[", encode2(index3, options), "]=", encode2(value, options)].join("")
            ];
          };
        case "bracket":
          return (key) => (result, value) => {
            if (value === void 0 || options.skipNull && value === null || options.skipEmptyString && value === "") {
              return result;
            }
            if (value === null) {
              return [...result, [encode2(key, options), "[]"].join("")];
            }
            return [...result, [encode2(key, options), "[]=", encode2(value, options)].join("")];
          };
        case "comma":
        case "separator":
        case "bracket-separator": {
          const keyValueSep = options.arrayFormat === "bracket-separator" ? "[]=" : "=";
          return (key) => (result, value) => {
            if (value === void 0 || options.skipNull && value === null || options.skipEmptyString && value === "") {
              return result;
            }
            value = value === null ? "" : value;
            if (result.length === 0) {
              return [[encode2(key, options), keyValueSep, encode2(value, options)].join("")];
            }
            return [[result, encode2(value, options)].join(options.arrayFormatSeparator)];
          };
        }
        default:
          return (key) => (result, value) => {
            if (value === void 0 || options.skipNull && value === null || options.skipEmptyString && value === "") {
              return result;
            }
            if (value === null) {
              return [...result, encode2(key, options)];
            }
            return [...result, [encode2(key, options), "=", encode2(value, options)].join("")];
          };
      }
    }
    function parserForArrayFormat(options) {
      let result;
      switch (options.arrayFormat) {
        case "index":
          return (key, value, accumulator) => {
            result = /\[(\d*)\]$/.exec(key);
            key = key.replace(/\[\d*\]$/, "");
            if (!result) {
              accumulator[key] = value;
              return;
            }
            if (accumulator[key] === void 0) {
              accumulator[key] = {};
            }
            accumulator[key][result[1]] = value;
          };
        case "bracket":
          return (key, value, accumulator) => {
            result = /(\[\])$/.exec(key);
            key = key.replace(/\[\]$/, "");
            if (!result) {
              accumulator[key] = value;
              return;
            }
            if (accumulator[key] === void 0) {
              accumulator[key] = [value];
              return;
            }
            accumulator[key] = [].concat(accumulator[key], value);
          };
        case "comma":
        case "separator":
          return (key, value, accumulator) => {
            const isArray3 = typeof value === "string" && value.includes(options.arrayFormatSeparator);
            const isEncodedArray = typeof value === "string" && !isArray3 && decode2(value, options).includes(options.arrayFormatSeparator);
            value = isEncodedArray ? decode2(value, options) : value;
            const newValue = isArray3 || isEncodedArray ? value.split(options.arrayFormatSeparator).map((item) => decode2(item, options)) : value === null ? value : decode2(value, options);
            accumulator[key] = newValue;
          };
        case "bracket-separator":
          return (key, value, accumulator) => {
            const isArray3 = /(\[\])$/.test(key);
            key = key.replace(/\[\]$/, "");
            if (!isArray3) {
              accumulator[key] = value ? decode2(value, options) : value;
              return;
            }
            const arrayValue = value === null ? [] : value.split(options.arrayFormatSeparator).map((item) => decode2(item, options));
            if (accumulator[key] === void 0) {
              accumulator[key] = arrayValue;
              return;
            }
            accumulator[key] = [].concat(accumulator[key], arrayValue);
          };
        default:
          return (key, value, accumulator) => {
            if (accumulator[key] === void 0) {
              accumulator[key] = value;
              return;
            }
            accumulator[key] = [].concat(accumulator[key], value);
          };
      }
    }
    function validateArrayFormatSeparator(value) {
      if (typeof value !== "string" || value.length !== 1) {
        throw new TypeError("arrayFormatSeparator must be single character string");
      }
    }
    function encode2(value, options) {
      if (options.encode) {
        return options.strict ? strictUriEncode(value) : encodeURIComponent(value);
      }
      return value;
    }
    function decode2(value, options) {
      if (options.decode) {
        return decodeUriComponent(value);
      }
      return value;
    }
    function keysSorter(input) {
      if (Array.isArray(input)) {
        return input.sort();
      }
      if (typeof input === "object") {
        return keysSorter(Object.keys(input)).sort((a2, b2) => Number(a2) - Number(b2)).map((key) => input[key]);
      }
      return input;
    }
    function removeHash(input) {
      const hashStart = input.indexOf("#");
      if (hashStart !== -1) {
        input = input.slice(0, hashStart);
      }
      return input;
    }
    function getHash(url) {
      let hash2 = "";
      const hashStart = url.indexOf("#");
      if (hashStart !== -1) {
        hash2 = url.slice(hashStart);
      }
      return hash2;
    }
    function extract(input) {
      input = removeHash(input);
      const queryStart = input.indexOf("?");
      if (queryStart === -1) {
        return "";
      }
      return input.slice(queryStart + 1);
    }
    function parseValue(value, options) {
      if (options.parseNumbers && !Number.isNaN(Number(value)) && (typeof value === "string" && value.trim() !== "")) {
        value = Number(value);
      } else if (options.parseBooleans && value !== null && (value.toLowerCase() === "true" || value.toLowerCase() === "false")) {
        value = value.toLowerCase() === "true";
      }
      return value;
    }
    function parse3(query, options) {
      options = Object.assign({
        decode: true,
        sort: true,
        arrayFormat: "none",
        arrayFormatSeparator: ",",
        parseNumbers: false,
        parseBooleans: false
      }, options);
      validateArrayFormatSeparator(options.arrayFormatSeparator);
      const formatter = parserForArrayFormat(options);
      const ret = Object.create(null);
      if (typeof query !== "string") {
        return ret;
      }
      query = query.trim().replace(/^[?#&]/, "");
      if (!query) {
        return ret;
      }
      for (const param of query.split("&")) {
        if (param === "") {
          continue;
        }
        let [key, value] = splitOnFirst(options.decode ? param.replace(/\+/g, " ") : param, "=");
        value = value === void 0 ? null : ["comma", "separator", "bracket-separator"].includes(options.arrayFormat) ? value : decode2(value, options);
        formatter(decode2(key, options), value, ret);
      }
      for (const key of Object.keys(ret)) {
        const value = ret[key];
        if (typeof value === "object" && value !== null) {
          for (const k2 of Object.keys(value)) {
            value[k2] = parseValue(value[k2], options);
          }
        } else {
          ret[key] = parseValue(value, options);
        }
      }
      if (options.sort === false) {
        return ret;
      }
      return (options.sort === true ? Object.keys(ret).sort() : Object.keys(ret).sort(options.sort)).reduce((result, key) => {
        const value = ret[key];
        if (Boolean(value) && typeof value === "object" && !Array.isArray(value)) {
          result[key] = keysSorter(value);
        } else {
          result[key] = value;
        }
        return result;
      }, Object.create(null));
    }
    exports2.extract = extract;
    exports2.parse = parse3;
    exports2.stringify = (object, options) => {
      if (!object) {
        return "";
      }
      options = Object.assign({
        encode: true,
        strict: true,
        arrayFormat: "none",
        arrayFormatSeparator: ","
      }, options);
      validateArrayFormatSeparator(options.arrayFormatSeparator);
      const shouldFilter = (key) => options.skipNull && isNullOrUndefined2(object[key]) || options.skipEmptyString && object[key] === "";
      const formatter = encoderForArrayFormat(options);
      const objectCopy = {};
      for (const key of Object.keys(object)) {
        if (!shouldFilter(key)) {
          objectCopy[key] = object[key];
        }
      }
      const keys2 = Object.keys(objectCopy);
      if (options.sort !== false) {
        keys2.sort(options.sort);
      }
      return keys2.map((key) => {
        const value = object[key];
        if (value === void 0) {
          return "";
        }
        if (value === null) {
          return encode2(key, options);
        }
        if (Array.isArray(value)) {
          if (value.length === 0 && options.arrayFormat === "bracket-separator") {
            return encode2(key, options) + "[]";
          }
          return value.reduce(formatter(key), []).join("&");
        }
        return encode2(key, options) + "=" + encode2(value, options);
      }).filter((x2) => x2.length > 0).join("&");
    };
    exports2.parseUrl = (url, options) => {
      options = Object.assign({
        decode: true
      }, options);
      const [url_, hash2] = splitOnFirst(url, "#");
      return Object.assign({
        url: url_.split("?")[0] || "",
        query: parse3(extract(url), options)
      }, options && options.parseFragmentIdentifier && hash2 ? {fragmentIdentifier: decode2(hash2, options)} : {});
    };
    exports2.stringifyUrl = (object, options) => {
      options = Object.assign({
        encode: true,
        strict: true,
        [encodeFragmentIdentifier]: true
      }, options);
      const url = removeHash(object.url).split("?")[0] || "";
      const queryFromUrl = exports2.extract(object.url);
      const parsedQueryFromUrl = exports2.parse(queryFromUrl, {sort: false});
      const query = Object.assign(parsedQueryFromUrl, object.query);
      let queryString2 = exports2.stringify(query, options);
      if (queryString2) {
        queryString2 = `?${queryString2}`;
      }
      let hash2 = getHash(object.url);
      if (object.fragmentIdentifier) {
        hash2 = `#${options[encodeFragmentIdentifier] ? encode2(object.fragmentIdentifier, options) : object.fragmentIdentifier}`;
      }
      return `${url}${queryString2}${hash2}`;
    };
    exports2.pick = (input, filter3, options) => {
      options = Object.assign({
        parseFragmentIdentifier: true,
        [encodeFragmentIdentifier]: false
      }, options);
      const {url, query, fragmentIdentifier} = exports2.parseUrl(input, options);
      return exports2.stringifyUrl({
        url,
        query: filterObj(query, filter3),
        fragmentIdentifier
      }, options);
    };
    exports2.exclude = (input, filter3, options) => {
      const exclusionFilter = Array.isArray(filter3) ? (key) => !filter3.includes(key) : (key, value) => !filter3(key, value);
      return exports2.pick(input, exclusionFilter, options);
    };
  });
  var constants = createCommonjsModule(function(module2, exports2) {
    exports2.__esModule = true;
    exports2.defaultRealm = exports2.defaultBaseUrl = void 0;
    exports2.defaultBaseUrl = "http://127.0.0.1:8080/auth";
    exports2.defaultRealm = "master";
  });
  var auth = createCommonjsModule(function(module2, exports2) {
    var __assign2 = commonjsGlobal && commonjsGlobal.__assign || function() {
      __assign2 = Object.assign || function(t5) {
        for (var s2, i3 = 1, n3 = arguments.length; i3 < n3; i3++) {
          s2 = arguments[i3];
          for (var p2 in s2)
            if (Object.prototype.hasOwnProperty.call(s2, p2))
              t5[p2] = s2[p2];
        }
        return t5;
      };
      return __assign2.apply(this, arguments);
    };
    var __awaiter3 = commonjsGlobal && commonjsGlobal.__awaiter || function(thisArg, _arguments, P2, generator) {
      function adopt(value) {
        return value instanceof P2 ? value : new P2(function(resolve2) {
          resolve2(value);
        });
      }
      return new (P2 || (P2 = Promise))(function(resolve2, reject) {
        function fulfilled(value) {
          try {
            step(generator.next(value));
          } catch (e2) {
            reject(e2);
          }
        }
        function rejected(value) {
          try {
            step(generator["throw"](value));
          } catch (e2) {
            reject(e2);
          }
        }
        function step(result) {
          result.done ? resolve2(result.value) : adopt(result.value).then(fulfilled, rejected);
        }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
      });
    };
    var __generator2 = commonjsGlobal && commonjsGlobal.__generator || function(thisArg, body) {
      var _23 = {label: 0, sent: function() {
        if (t5[0] & 1)
          throw t5[1];
        return t5[1];
      }, trys: [], ops: []}, f2, y3, t5, g2;
      return g2 = {next: verb(0), throw: verb(1), return: verb(2)}, typeof Symbol === "function" && (g2[Symbol.iterator] = function() {
        return this;
      }), g2;
      function verb(n3) {
        return function(v2) {
          return step([n3, v2]);
        };
      }
      function step(op) {
        if (f2)
          throw new TypeError("Generator is already executing.");
        while (_23)
          try {
            if (f2 = 1, y3 && (t5 = op[0] & 2 ? y3["return"] : op[0] ? y3["throw"] || ((t5 = y3["return"]) && t5.call(y3), 0) : y3.next) && !(t5 = t5.call(y3, op[1])).done)
              return t5;
            if (y3 = 0, t5)
              op = [op[0] & 2, t5.value];
            switch (op[0]) {
              case 0:
              case 1:
                t5 = op;
                break;
              case 4:
                _23.label++;
                return {value: op[1], done: false};
              case 5:
                _23.label++;
                y3 = op[1];
                op = [0];
                continue;
              case 7:
                op = _23.ops.pop();
                _23.trys.pop();
                continue;
              default:
                if (!(t5 = _23.trys, t5 = t5.length > 0 && t5[t5.length - 1]) && (op[0] === 6 || op[0] === 2)) {
                  _23 = 0;
                  continue;
                }
                if (op[0] === 3 && (!t5 || op[1] > t5[0] && op[1] < t5[3])) {
                  _23.label = op[1];
                  break;
                }
                if (op[0] === 6 && _23.label < t5[1]) {
                  _23.label = t5[1];
                  t5 = op;
                  break;
                }
                if (t5 && _23.label < t5[2]) {
                  _23.label = t5[2];
                  _23.ops.push(op);
                  break;
                }
                if (t5[2])
                  _23.ops.pop();
                _23.trys.pop();
                continue;
            }
            op = body.call(thisArg, _23);
          } catch (e2) {
            op = [6, e2];
            y3 = 0;
          } finally {
            f2 = t5 = 0;
          }
        if (op[0] & 5)
          throw op[1];
        return {value: op[0] ? op[1] : void 0, done: true};
      }
    };
    var __importDefault = commonjsGlobal && commonjsGlobal.__importDefault || function(mod) {
      return mod && mod.__esModule ? mod : {default: mod};
    };
    exports2.__esModule = true;
    exports2.getToken = void 0;
    var axios_12 = __importDefault(axios$1);
    var camelize_ts_1 = __importDefault(dist);
    var query_string_1 = __importDefault(queryString);
    var getToken = function(settings) {
      return __awaiter3(void 0, void 0, void 0, function() {
        var baseUrl, realmName, url, credentials, payload, config2, data2;
        return __generator2(this, function(_a) {
          switch (_a.label) {
            case 0:
              baseUrl = settings.baseUrl || constants.defaultBaseUrl;
              realmName = settings.realmName || constants.defaultRealm;
              url = "".concat(baseUrl, "/realms/").concat(realmName, "/protocol/openid-connect/token");
              credentials = settings.credentials || {};
              payload = query_string_1["default"].stringify(__assign2(__assign2({username: credentials.username, password: credentials.password, grant_type: credentials.grantType, client_id: credentials.clientId, totp: credentials.totp}, credentials.offlineToken ? {scope: "offline_access"} : {}), credentials.refreshToken ? {
                refresh_token: credentials.refreshToken,
                client_secret: credentials.clientSecret
              } : {}));
              config2 = __assign2({}, settings.requestConfig);
              if (credentials.clientSecret) {
                config2.auth = {
                  username: credentials.clientId,
                  password: credentials.clientSecret
                };
              }
              return [4, axios_12["default"].post(url, payload, config2)];
            case 1:
              data2 = _a.sent().data;
              return [2, (0, camelize_ts_1["default"])(data2)];
          }
        });
      });
    };
    exports2.getToken = getToken;
  });
  var urlJoin = createCommonjsModule(function(module2) {
    (function(name, context2, definition) {
      if (module2.exports)
        module2.exports = definition();
      else
        context2[name] = definition();
    })("urljoin", commonjsGlobal, function() {
      function normalize3(strArray) {
        var resultArray = [];
        if (strArray.length === 0) {
          return "";
        }
        if (typeof strArray[0] !== "string") {
          throw new TypeError("Url must be a string. Received " + strArray[0]);
        }
        if (strArray[0].match(/^[^/:]+:\/*$/) && strArray.length > 1) {
          var first2 = strArray.shift();
          strArray[0] = first2 + strArray[0];
        }
        if (strArray[0].match(/^file:\/\/\//)) {
          strArray[0] = strArray[0].replace(/^([^/:]+):\/*/, "$1:///");
        } else {
          strArray[0] = strArray[0].replace(/^([^/:]+):\/*/, "$1://");
        }
        for (var i3 = 0; i3 < strArray.length; i3++) {
          var component = strArray[i3];
          if (typeof component !== "string") {
            throw new TypeError("Url must be a string. Received " + component);
          }
          if (component === "") {
            continue;
          }
          if (i3 > 0) {
            component = component.replace(/^[\/]+/, "");
          }
          if (i3 < strArray.length - 1) {
            component = component.replace(/[\/]+$/, "");
          } else {
            component = component.replace(/[\/]+$/, "/");
          }
          resultArray.push(component);
        }
        var str = resultArray.join("/");
        str = str.replace(/\/(\?|&|#[^!])/g, "$1");
        var parts = str.split("?");
        str = parts.shift() + (parts.length > 0 ? "?" : "") + parts.join("&");
        return str;
      }
      return function() {
        var input;
        if (typeof arguments[0] === "object") {
          input = arguments[0];
        } else {
          input = [].slice.call(arguments);
        }
        return normalize3(input);
      };
    });
  });
  var urlTemplate = createCommonjsModule(function(module2, exports2) {
    (function(root4, factory) {
      {
        module2.exports = factory();
      }
    })(commonjsGlobal, function() {
      function UrlTemplate() {
      }
      UrlTemplate.prototype.encodeReserved = function(str) {
        return str.split(/(%[0-9A-Fa-f]{2})/g).map(function(part) {
          if (!/%[0-9A-Fa-f]/.test(part)) {
            part = encodeURI(part).replace(/%5B/g, "[").replace(/%5D/g, "]");
          }
          return part;
        }).join("");
      };
      UrlTemplate.prototype.encodeUnreserved = function(str) {
        return encodeURIComponent(str).replace(/[!'()*]/g, function(c3) {
          return "%" + c3.charCodeAt(0).toString(16).toUpperCase();
        });
      };
      UrlTemplate.prototype.encodeValue = function(operator, value, key) {
        value = operator === "+" || operator === "#" ? this.encodeReserved(value) : this.encodeUnreserved(value);
        if (key) {
          return this.encodeUnreserved(key) + "=" + value;
        } else {
          return value;
        }
      };
      UrlTemplate.prototype.isDefined = function(value) {
        return value !== void 0 && value !== null;
      };
      UrlTemplate.prototype.isKeyOperator = function(operator) {
        return operator === ";" || operator === "&" || operator === "?";
      };
      UrlTemplate.prototype.getValues = function(context2, operator, key, modifier) {
        var value = context2[key], result = [];
        if (this.isDefined(value) && value !== "") {
          if (typeof value === "string" || typeof value === "number" || typeof value === "boolean") {
            value = value.toString();
            if (modifier && modifier !== "*") {
              value = value.substring(0, parseInt(modifier, 10));
            }
            result.push(this.encodeValue(operator, value, this.isKeyOperator(operator) ? key : null));
          } else {
            if (modifier === "*") {
              if (Array.isArray(value)) {
                value.filter(this.isDefined).forEach(function(value2) {
                  result.push(this.encodeValue(operator, value2, this.isKeyOperator(operator) ? key : null));
                }, this);
              } else {
                Object.keys(value).forEach(function(k2) {
                  if (this.isDefined(value[k2])) {
                    result.push(this.encodeValue(operator, value[k2], k2));
                  }
                }, this);
              }
            } else {
              var tmp = [];
              if (Array.isArray(value)) {
                value.filter(this.isDefined).forEach(function(value2) {
                  tmp.push(this.encodeValue(operator, value2));
                }, this);
              } else {
                Object.keys(value).forEach(function(k2) {
                  if (this.isDefined(value[k2])) {
                    tmp.push(this.encodeUnreserved(k2));
                    tmp.push(this.encodeValue(operator, value[k2].toString()));
                  }
                }, this);
              }
              if (this.isKeyOperator(operator)) {
                result.push(this.encodeUnreserved(key) + "=" + tmp.join(","));
              } else if (tmp.length !== 0) {
                result.push(tmp.join(","));
              }
            }
          }
        } else {
          if (operator === ";") {
            if (this.isDefined(value)) {
              result.push(this.encodeUnreserved(key));
            }
          } else if (value === "" && (operator === "&" || operator === "?")) {
            result.push(this.encodeUnreserved(key) + "=");
          } else if (value === "") {
            result.push("");
          }
        }
        return result;
      };
      UrlTemplate.prototype.parse = function(template) {
        var that = this;
        var operators = ["+", "#", ".", "/", ";", "?", "&"];
        return {
          expand: function(context2) {
            return template.replace(/\{([^\{\}]+)\}|([^\{\}]+)/g, function(_23, expression, literal) {
              if (expression) {
                var operator = null, values2 = [];
                if (operators.indexOf(expression.charAt(0)) !== -1) {
                  operator = expression.charAt(0);
                  expression = expression.substr(1);
                }
                expression.split(/,/g).forEach(function(variable) {
                  var tmp = /([^:\*]*)(?::(\d+)|(\*))?/.exec(variable);
                  values2.push.apply(values2, that.getValues(context2, operator, tmp[1], tmp[2] || tmp[3]));
                });
                if (operator && operator !== "+") {
                  var separator = ",";
                  if (operator === "?") {
                    separator = "&";
                  } else if (operator !== "#") {
                    separator = operator;
                  }
                  return (values2.length !== 0 ? operator : "") + values2.join(separator);
                } else {
                  return values2.join(",");
                }
              } else {
                return that.encodeReserved(literal);
              }
            });
          }
        };
      };
      return new UrlTemplate();
    });
  });
  var agent = createCommonjsModule(function(module2, exports2) {
    var __assign2 = commonjsGlobal && commonjsGlobal.__assign || function() {
      __assign2 = Object.assign || function(t5) {
        for (var s2, i3 = 1, n3 = arguments.length; i3 < n3; i3++) {
          s2 = arguments[i3];
          for (var p2 in s2)
            if (Object.prototype.hasOwnProperty.call(s2, p2))
              t5[p2] = s2[p2];
        }
        return t5;
      };
      return __assign2.apply(this, arguments);
    };
    var __awaiter3 = commonjsGlobal && commonjsGlobal.__awaiter || function(thisArg, _arguments, P2, generator) {
      function adopt(value) {
        return value instanceof P2 ? value : new P2(function(resolve2) {
          resolve2(value);
        });
      }
      return new (P2 || (P2 = Promise))(function(resolve2, reject) {
        function fulfilled(value) {
          try {
            step(generator.next(value));
          } catch (e2) {
            reject(e2);
          }
        }
        function rejected(value) {
          try {
            step(generator["throw"](value));
          } catch (e2) {
            reject(e2);
          }
        }
        function step(result) {
          result.done ? resolve2(result.value) : adopt(result.value).then(fulfilled, rejected);
        }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
      });
    };
    var __generator2 = commonjsGlobal && commonjsGlobal.__generator || function(thisArg, body) {
      var _23 = {label: 0, sent: function() {
        if (t5[0] & 1)
          throw t5[1];
        return t5[1];
      }, trys: [], ops: []}, f2, y3, t5, g2;
      return g2 = {next: verb(0), throw: verb(1), return: verb(2)}, typeof Symbol === "function" && (g2[Symbol.iterator] = function() {
        return this;
      }), g2;
      function verb(n3) {
        return function(v2) {
          return step([n3, v2]);
        };
      }
      function step(op) {
        if (f2)
          throw new TypeError("Generator is already executing.");
        while (_23)
          try {
            if (f2 = 1, y3 && (t5 = op[0] & 2 ? y3["return"] : op[0] ? y3["throw"] || ((t5 = y3["return"]) && t5.call(y3), 0) : y3.next) && !(t5 = t5.call(y3, op[1])).done)
              return t5;
            if (y3 = 0, t5)
              op = [op[0] & 2, t5.value];
            switch (op[0]) {
              case 0:
              case 1:
                t5 = op;
                break;
              case 4:
                _23.label++;
                return {value: op[1], done: false};
              case 5:
                _23.label++;
                y3 = op[1];
                op = [0];
                continue;
              case 7:
                op = _23.ops.pop();
                _23.trys.pop();
                continue;
              default:
                if (!(t5 = _23.trys, t5 = t5.length > 0 && t5[t5.length - 1]) && (op[0] === 6 || op[0] === 2)) {
                  _23 = 0;
                  continue;
                }
                if (op[0] === 3 && (!t5 || op[1] > t5[0] && op[1] < t5[3])) {
                  _23.label = op[1];
                  break;
                }
                if (op[0] === 6 && _23.label < t5[1]) {
                  _23.label = t5[1];
                  t5 = op;
                  break;
                }
                if (t5 && _23.label < t5[2]) {
                  _23.label = t5[2];
                  _23.ops.push(op);
                  break;
                }
                if (t5[2])
                  _23.ops.pop();
                _23.trys.pop();
                continue;
            }
            op = body.call(thisArg, _23);
          } catch (e2) {
            op = [6, e2];
            y3 = 0;
          } finally {
            f2 = t5 = 0;
          }
        if (op[0] & 5)
          throw op[1];
        return {value: op[0] ? op[1] : void 0, done: true};
      }
    };
    var __spreadArray = commonjsGlobal && commonjsGlobal.__spreadArray || function(to, from, pack) {
      if (pack || arguments.length === 2)
        for (var i3 = 0, l2 = from.length, ar; i3 < l2; i3++) {
          if (ar || !(i3 in from)) {
            if (!ar)
              ar = Array.prototype.slice.call(from, 0, i3);
            ar[i3] = from[i3];
          }
        }
      return to.concat(ar || Array.prototype.slice.call(from));
    };
    var __importDefault = commonjsGlobal && commonjsGlobal.__importDefault || function(mod) {
      return mod && mod.__esModule ? mod : {default: mod};
    };
    exports2.__esModule = true;
    exports2.Agent = void 0;
    var url_join_1 = __importDefault(urlJoin);
    var url_template_1 = __importDefault(urlTemplate);
    var axios_12 = __importDefault(axios$1);
    var query_string_1 = __importDefault(queryString);
    var SLASH = "/";
    var Agent = function() {
      function Agent2(_a) {
        var client2 = _a.client, _b = _a.path, path = _b === void 0 ? "/" : _b, _c = _a.getUrlParams, getUrlParams = _c === void 0 ? function() {
          return {};
        } : _c, _d = _a.getBaseUrl, getBaseUrl2 = _d === void 0 ? function() {
          return client2.baseUrl;
        } : _d;
        this.client = client2;
        this.getBaseParams = getUrlParams;
        this.getBaseUrl = getBaseUrl2;
        this.basePath = path;
      }
      Agent2.prototype.request = function(_a) {
        var _this = this;
        var method = _a.method, _b = _a.path, path = _b === void 0 ? "" : _b, _c = _a.urlParamKeys, urlParamKeys = _c === void 0 ? [] : _c, _d = _a.queryParamKeys, queryParamKeys = _d === void 0 ? [] : _d, _e = _a.catchNotFound, catchNotFound = _e === void 0 ? false : _e, keyTransform = _a.keyTransform, payloadKey = _a.payloadKey, returnResourceIdInLocationHeader = _a.returnResourceIdInLocationHeader, ignoredKeys = _a.ignoredKeys, headers = _a.headers;
        return function(payload) {
          if (payload === void 0) {
            payload = {};
          }
          return __awaiter3(_this, void 0, void 0, function() {
            var baseParams, queryParams, allUrlParamKeys, urlParams, omittedKeys;
            var _a2, _b2;
            return __generator2(this, function(_c2) {
              baseParams = (_b2 = (_a2 = this.getBaseParams) === null || _a2 === void 0 ? void 0 : _a2.call(this)) !== null && _b2 !== void 0 ? _b2 : {};
              queryParams = queryParamKeys ? (0, lodash.pick)(payload, queryParamKeys) : null;
              allUrlParamKeys = __spreadArray(__spreadArray([], Object.keys(baseParams), true), urlParamKeys, true);
              urlParams = __assign2(__assign2({}, baseParams), (0, lodash.pick)(payload, allUrlParamKeys));
              omittedKeys = ignoredKeys ? __spreadArray(__spreadArray([], allUrlParamKeys, true), queryParamKeys, true).filter(function(key) {
                return !ignoredKeys.includes(key);
              }) : __spreadArray(__spreadArray([], allUrlParamKeys, true), queryParamKeys, true);
              payload = (0, lodash.omit)(payload, omittedKeys);
              if (keyTransform) {
                this.transformKey(payload, keyTransform);
                this.transformKey(queryParams, keyTransform);
              }
              return [2, this.requestWithParams({
                method,
                path,
                payload,
                urlParams,
                queryParams,
                catchNotFound,
                payloadKey,
                returnResourceIdInLocationHeader,
                headers
              })];
            });
          });
        };
      };
      Agent2.prototype.updateRequest = function(_a) {
        var _this = this;
        var method = _a.method, _b = _a.path, path = _b === void 0 ? "" : _b, _c = _a.urlParamKeys, urlParamKeys = _c === void 0 ? [] : _c, _d = _a.queryParamKeys, queryParamKeys = _d === void 0 ? [] : _d, _e = _a.catchNotFound, catchNotFound = _e === void 0 ? false : _e, keyTransform = _a.keyTransform, payloadKey = _a.payloadKey, returnResourceIdInLocationHeader = _a.returnResourceIdInLocationHeader, headers = _a.headers;
        return function(query, payload) {
          if (query === void 0) {
            query = {};
          }
          if (payload === void 0) {
            payload = {};
          }
          return __awaiter3(_this, void 0, void 0, function() {
            var baseParams, queryParams, allUrlParamKeys, urlParams;
            var _a2, _b2;
            return __generator2(this, function(_c2) {
              baseParams = (_b2 = (_a2 = this.getBaseParams) === null || _a2 === void 0 ? void 0 : _a2.call(this)) !== null && _b2 !== void 0 ? _b2 : {};
              queryParams = queryParamKeys ? (0, lodash.pick)(query, queryParamKeys) : null;
              allUrlParamKeys = __spreadArray(__spreadArray([], Object.keys(baseParams), true), urlParamKeys, true);
              urlParams = __assign2(__assign2({}, baseParams), (0, lodash.pick)(query, allUrlParamKeys));
              if (keyTransform) {
                this.transformKey(queryParams, keyTransform);
              }
              return [2, this.requestWithParams({
                method,
                path,
                payload,
                urlParams,
                queryParams,
                catchNotFound,
                payloadKey,
                returnResourceIdInLocationHeader,
                headers
              })];
            });
          });
        };
      };
      Agent2.prototype.requestWithParams = function(_a) {
        var _b, _c, _d;
        var method = _a.method, path = _a.path, payload = _a.payload, urlParams = _a.urlParams, queryParams = _a.queryParams, catchNotFound = _a.catchNotFound, payloadKey = _a.payloadKey, returnResourceIdInLocationHeader = _a.returnResourceIdInLocationHeader, headers = _a.headers;
        return __awaiter3(this, void 0, void 0, function() {
          var newPath, pathTemplate, parsedPath, url, requestConfig, _e, _f, _g, res, locationHeader, resourceId, field, err_1;
          var _h, _j;
          return __generator2(this, function(_k) {
            switch (_k.label) {
              case 0:
                newPath = (0, url_join_1["default"])(this.basePath, path);
                pathTemplate = url_template_1["default"].parse(newPath);
                parsedPath = pathTemplate.expand(urlParams);
                url = "".concat((_c = (_b = this.getBaseUrl) === null || _b === void 0 ? void 0 : _b.call(this)) !== null && _c !== void 0 ? _c : "").concat(parsedPath);
                requestConfig = __assign2(__assign2({paramsSerializer: function(params) {
                  return query_string_1["default"].stringify(params);
                }}, this.client.getRequestConfig() || {}), {method, url});
                _e = requestConfig;
                _f = [__assign2({}, requestConfig.headers)];
                _h = {};
                _g = "bearer ".concat;
                return [4, this.client.getAccessToken()];
              case 1:
                _e.headers = __assign2.apply(void 0, [__assign2.apply(void 0, _f.concat([(_h.Authorization = _g.apply("bearer ", [_k.sent()]), _h)])), headers]);
                if (method === "GET") {
                  requestConfig.params = payload;
                } else {
                  requestConfig.data = payloadKey ? payload[payloadKey] : payload;
                }
                if (queryParams) {
                  requestConfig.params = requestConfig.params ? __assign2(__assign2({}, requestConfig.params), queryParams) : queryParams;
                }
                _k.label = 2;
              case 2:
                _k.trys.push([2, 4, , 5]);
                return [4, (0, axios_12["default"])(requestConfig)];
              case 3:
                res = _k.sent();
                if (returnResourceIdInLocationHeader) {
                  locationHeader = res.headers.location;
                  if (typeof locationHeader !== "string") {
                    throw new Error("location header is not found in request: ".concat(res.config.url));
                  }
                  resourceId = (0, lodash.last)(locationHeader.split(SLASH));
                  if (!resourceId) {
                    throw new Error("resourceId is not found in Location header from request: ".concat(res.config.url));
                  }
                  field = returnResourceIdInLocationHeader.field;
                  return [2, (_j = {}, _j[field] = resourceId, _j)];
                }
                return [2, res.data];
              case 4:
                err_1 = _k.sent();
                if (axios_12["default"].isAxiosError(err_1) && ((_d = err_1.response) === null || _d === void 0 ? void 0 : _d.status) === 404 && catchNotFound) {
                  return [2, null];
                }
                throw err_1;
              case 5:
                return [2];
            }
          });
        });
      };
      Agent2.prototype.transformKey = function(payload, keyMapping) {
        if (!payload) {
          return;
        }
        Object.keys(keyMapping).some(function(key) {
          if ((0, lodash.isUndefined)(payload[key])) {
            return false;
          }
          var newKey = keyMapping[key];
          payload[newKey] = payload[key];
          delete payload[key];
        });
      };
      return Agent2;
    }();
    exports2.Agent = Agent;
  });
  var resource = createCommonjsModule(function(module2, exports2) {
    var __assign2 = commonjsGlobal && commonjsGlobal.__assign || function() {
      __assign2 = Object.assign || function(t5) {
        for (var s2, i3 = 1, n3 = arguments.length; i3 < n3; i3++) {
          s2 = arguments[i3];
          for (var p2 in s2)
            if (Object.prototype.hasOwnProperty.call(s2, p2))
              t5[p2] = s2[p2];
        }
        return t5;
      };
      return __assign2.apply(this, arguments);
    };
    exports2.__esModule = true;
    var Resource = function() {
      function Resource2(client2, settings) {
        var _this = this;
        if (settings === void 0) {
          settings = {};
        }
        this.makeRequest = function(args) {
          return _this.agent.request(args);
        };
        this.makeUpdateRequest = function(args) {
          return _this.agent.updateRequest(args);
        };
        this.agent = new agent.Agent(__assign2({client: client2}, settings));
      }
      return Resource2;
    }();
    exports2["default"] = Resource;
  });
  var cache = createCommonjsModule(function(module2, exports2) {
    var __extends2 = commonjsGlobal && commonjsGlobal.__extends || function() {
      var extendStatics = function(d2, b2) {
        extendStatics = Object.setPrototypeOf || {__proto__: []} instanceof Array && function(d3, b3) {
          d3.__proto__ = b3;
        } || function(d3, b3) {
          for (var p2 in b3)
            if (Object.prototype.hasOwnProperty.call(b3, p2))
              d3[p2] = b3[p2];
        };
        return extendStatics(d2, b2);
      };
      return function(d2, b2) {
        if (typeof b2 !== "function" && b2 !== null)
          throw new TypeError("Class extends value " + String(b2) + " is not a constructor or null");
        extendStatics(d2, b2);
        function __() {
          this.constructor = d2;
        }
        d2.prototype = b2 === null ? Object.create(b2) : (__.prototype = b2.prototype, new __());
      };
    }();
    var __importDefault = commonjsGlobal && commonjsGlobal.__importDefault || function(mod) {
      return mod && mod.__esModule ? mod : {default: mod};
    };
    exports2.__esModule = true;
    exports2.Cache = void 0;
    var resource_1 = __importDefault(resource);
    var Cache = function(_super) {
      __extends2(Cache2, _super);
      function Cache2(client2) {
        var _this = _super.call(this, client2, {
          path: "/admin/realms/{realm}",
          getUrlParams: function() {
            return {
              realm: client2.realmName
            };
          },
          getBaseUrl: function() {
            return client2.baseUrl;
          }
        }) || this;
        _this.clearUserCache = _this.makeRequest({
          method: "POST",
          path: "/clear-user-cache"
        });
        return _this;
      }
      return Cache2;
    }(resource_1["default"]);
    exports2.Cache = Cache;
  });
  var users = createCommonjsModule(function(module2, exports2) {
    var __extends2 = commonjsGlobal && commonjsGlobal.__extends || function() {
      var extendStatics = function(d2, b2) {
        extendStatics = Object.setPrototypeOf || {__proto__: []} instanceof Array && function(d3, b3) {
          d3.__proto__ = b3;
        } || function(d3, b3) {
          for (var p2 in b3)
            if (Object.prototype.hasOwnProperty.call(b3, p2))
              d3[p2] = b3[p2];
        };
        return extendStatics(d2, b2);
      };
      return function(d2, b2) {
        if (typeof b2 !== "function" && b2 !== null)
          throw new TypeError("Class extends value " + String(b2) + " is not a constructor or null");
        extendStatics(d2, b2);
        function __() {
          this.constructor = d2;
        }
        d2.prototype = b2 === null ? Object.create(b2) : (__.prototype = b2.prototype, new __());
      };
    }();
    var __importDefault = commonjsGlobal && commonjsGlobal.__importDefault || function(mod) {
      return mod && mod.__esModule ? mod : {default: mod};
    };
    exports2.__esModule = true;
    exports2.Users = void 0;
    var resource_1 = __importDefault(resource);
    var Users = function(_super) {
      __extends2(Users2, _super);
      function Users2(client2) {
        var _this = _super.call(this, client2, {
          path: "/admin/realms/{realm}/users",
          getUrlParams: function() {
            return {
              realm: client2.realmName
            };
          },
          getBaseUrl: function() {
            return client2.baseUrl;
          }
        }) || this;
        _this.find = _this.makeRequest({
          method: "GET"
        });
        _this.create = _this.makeRequest({
          method: "POST",
          returnResourceIdInLocationHeader: {field: "id"}
        });
        _this.findOne = _this.makeRequest({
          method: "GET",
          path: "/{id}",
          urlParamKeys: ["id"],
          catchNotFound: true
        });
        _this.update = _this.makeUpdateRequest({
          method: "PUT",
          path: "/{id}",
          urlParamKeys: ["id"]
        });
        _this.del = _this.makeRequest({
          method: "DELETE",
          path: "/{id}",
          urlParamKeys: ["id"]
        });
        _this.count = _this.makeRequest({
          method: "GET",
          path: "/count"
        });
        _this.listRoleMappings = _this.makeRequest({
          method: "GET",
          path: "/{id}/role-mappings",
          urlParamKeys: ["id"]
        });
        _this.addRealmRoleMappings = _this.makeRequest({
          method: "POST",
          path: "/{id}/role-mappings/realm",
          urlParamKeys: ["id"],
          payloadKey: "roles"
        });
        _this.listRealmRoleMappings = _this.makeRequest({
          method: "GET",
          path: "/{id}/role-mappings/realm",
          urlParamKeys: ["id"]
        });
        _this.delRealmRoleMappings = _this.makeRequest({
          method: "DELETE",
          path: "/{id}/role-mappings/realm",
          urlParamKeys: ["id"],
          payloadKey: "roles"
        });
        _this.listAvailableRealmRoleMappings = _this.makeRequest({
          method: "GET",
          path: "/{id}/role-mappings/realm/available",
          urlParamKeys: ["id"]
        });
        _this.listCompositeRealmRoleMappings = _this.makeRequest({
          method: "GET",
          path: "/{id}/role-mappings/realm/composite",
          urlParamKeys: ["id"]
        });
        _this.listClientRoleMappings = _this.makeRequest({
          method: "GET",
          path: "/{id}/role-mappings/clients/{clientUniqueId}",
          urlParamKeys: ["id", "clientUniqueId"]
        });
        _this.addClientRoleMappings = _this.makeRequest({
          method: "POST",
          path: "/{id}/role-mappings/clients/{clientUniqueId}",
          urlParamKeys: ["id", "clientUniqueId"],
          payloadKey: "roles"
        });
        _this.delClientRoleMappings = _this.makeRequest({
          method: "DELETE",
          path: "/{id}/role-mappings/clients/{clientUniqueId}",
          urlParamKeys: ["id", "clientUniqueId"],
          payloadKey: "roles"
        });
        _this.listAvailableClientRoleMappings = _this.makeRequest({
          method: "GET",
          path: "/{id}/role-mappings/clients/{clientUniqueId}/available",
          urlParamKeys: ["id", "clientUniqueId"]
        });
        _this.listCompositeClientRoleMappings = _this.makeRequest({
          method: "GET",
          path: "/{id}/role-mappings/clients/{clientUniqueId}/composite",
          urlParamKeys: ["id", "clientUniqueId"]
        });
        _this.executeActionsEmail = _this.makeRequest({
          method: "PUT",
          path: "/{id}/execute-actions-email",
          urlParamKeys: ["id"],
          payloadKey: "actions",
          queryParamKeys: ["lifespan", "redirectUri", "clientId"],
          keyTransform: {
            clientId: "client_id",
            redirectUri: "redirect_uri"
          }
        });
        _this.listGroups = _this.makeRequest({
          method: "GET",
          path: "/{id}/groups",
          urlParamKeys: ["id"]
        });
        _this.addToGroup = _this.makeRequest({
          method: "PUT",
          path: "/{id}/groups/{groupId}",
          urlParamKeys: ["id", "groupId"]
        });
        _this.delFromGroup = _this.makeRequest({
          method: "DELETE",
          path: "/{id}/groups/{groupId}",
          urlParamKeys: ["id", "groupId"]
        });
        _this.countGroups = _this.makeRequest({
          method: "GET",
          path: "/{id}/groups/count",
          urlParamKeys: ["id"]
        });
        _this.listFederatedIdentities = _this.makeRequest({
          method: "GET",
          path: "/{id}/federated-identity",
          urlParamKeys: ["id"]
        });
        _this.addToFederatedIdentity = _this.makeRequest({
          method: "POST",
          path: "/{id}/federated-identity/{federatedIdentityId}",
          urlParamKeys: ["id", "federatedIdentityId"],
          payloadKey: "federatedIdentity"
        });
        _this.delFromFederatedIdentity = _this.makeRequest({
          method: "DELETE",
          path: "/{id}/federated-identity/{federatedIdentityId}",
          urlParamKeys: ["id", "federatedIdentityId"]
        });
        _this.removeTotp = _this.makeRequest({
          method: "PUT",
          path: "/{id}/remove-totp",
          urlParamKeys: ["id"]
        });
        _this.resetPassword = _this.makeRequest({
          method: "PUT",
          path: "/{id}/reset-password",
          urlParamKeys: ["id"],
          payloadKey: "credential"
        });
        _this.getCredentials = _this.makeRequest({
          method: "GET",
          path: "/{id}/credentials",
          urlParamKeys: ["id"]
        });
        _this.deleteCredential = _this.makeRequest({
          method: "DELETE",
          path: "/{id}/credentials/{credentialId}",
          urlParamKeys: ["id", "credentialId"]
        });
        _this.updateCredentialLabel = _this.makeUpdateRequest({
          method: "PUT",
          path: "/{id}/credentials/{credentialId}/userLabel",
          urlParamKeys: ["id", "credentialId"],
          headers: {"content-type": "text/plain"}
        });
        _this.sendVerifyEmail = _this.makeRequest({
          method: "PUT",
          path: "/{id}/send-verify-email",
          urlParamKeys: ["id"],
          queryParamKeys: ["clientId", "redirectUri"],
          keyTransform: {
            clientId: "client_id",
            redirectUri: "redirect_uri"
          }
        });
        _this.listSessions = _this.makeRequest({
          method: "GET",
          path: "/{id}/sessions",
          urlParamKeys: ["id"]
        });
        _this.listOfflineSessions = _this.makeRequest({
          method: "GET",
          path: "/{id}/offline-sessions/{clientId}",
          urlParamKeys: ["id", "clientId"]
        });
        _this.logout = _this.makeRequest({
          method: "POST",
          path: "/{id}/logout",
          urlParamKeys: ["id"]
        });
        _this.listConsents = _this.makeRequest({
          method: "GET",
          path: "/{id}/consents",
          urlParamKeys: ["id"]
        });
        _this.impersonation = _this.makeUpdateRequest({
          method: "POST",
          path: "/{id}/impersonation",
          urlParamKeys: ["id"]
        });
        _this.revokeConsent = _this.makeRequest({
          method: "DELETE",
          path: "/{id}/consents/{clientId}",
          urlParamKeys: ["id", "clientId"]
        });
        return _this;
      }
      return Users2;
    }(resource_1["default"]);
    exports2.Users = Users;
  });
  var groups = createCommonjsModule(function(module2, exports2) {
    var __extends2 = commonjsGlobal && commonjsGlobal.__extends || function() {
      var extendStatics = function(d2, b2) {
        extendStatics = Object.setPrototypeOf || {__proto__: []} instanceof Array && function(d3, b3) {
          d3.__proto__ = b3;
        } || function(d3, b3) {
          for (var p2 in b3)
            if (Object.prototype.hasOwnProperty.call(b3, p2))
              d3[p2] = b3[p2];
        };
        return extendStatics(d2, b2);
      };
      return function(d2, b2) {
        if (typeof b2 !== "function" && b2 !== null)
          throw new TypeError("Class extends value " + String(b2) + " is not a constructor or null");
        extendStatics(d2, b2);
        function __() {
          this.constructor = d2;
        }
        d2.prototype = b2 === null ? Object.create(b2) : (__.prototype = b2.prototype, new __());
      };
    }();
    var __importDefault = commonjsGlobal && commonjsGlobal.__importDefault || function(mod) {
      return mod && mod.__esModule ? mod : {default: mod};
    };
    exports2.__esModule = true;
    exports2.Groups = void 0;
    var resource_1 = __importDefault(resource);
    var Groups = function(_super) {
      __extends2(Groups2, _super);
      function Groups2(client2) {
        var _this = _super.call(this, client2, {
          path: "/admin/realms/{realm}/groups",
          getUrlParams: function() {
            return {
              realm: client2.realmName
            };
          },
          getBaseUrl: function() {
            return client2.baseUrl;
          }
        }) || this;
        _this.find = _this.makeRequest({
          method: "GET"
        });
        _this.create = _this.makeRequest({
          method: "POST",
          returnResourceIdInLocationHeader: {field: "id"}
        });
        _this.findOne = _this.makeRequest({
          method: "GET",
          path: "/{id}",
          urlParamKeys: ["id"],
          catchNotFound: true
        });
        _this.update = _this.makeUpdateRequest({
          method: "PUT",
          path: "/{id}",
          urlParamKeys: ["id"]
        });
        _this.del = _this.makeRequest({
          method: "DELETE",
          path: "/{id}",
          urlParamKeys: ["id"]
        });
        _this.count = _this.makeRequest({
          method: "GET",
          path: "/count"
        });
        _this.setOrCreateChild = _this.makeUpdateRequest({
          method: "POST",
          path: "/{id}/children",
          urlParamKeys: ["id"],
          returnResourceIdInLocationHeader: {field: "id"}
        });
        _this.listMembers = _this.makeRequest({
          method: "GET",
          path: "/{id}/members",
          urlParamKeys: ["id"],
          catchNotFound: true
        });
        _this.listRoleMappings = _this.makeRequest({
          method: "GET",
          path: "/{id}/role-mappings",
          urlParamKeys: ["id"]
        });
        _this.addRealmRoleMappings = _this.makeRequest({
          method: "POST",
          path: "/{id}/role-mappings/realm",
          urlParamKeys: ["id"],
          payloadKey: "roles"
        });
        _this.listRealmRoleMappings = _this.makeRequest({
          method: "GET",
          path: "/{id}/role-mappings/realm",
          urlParamKeys: ["id"]
        });
        _this.delRealmRoleMappings = _this.makeRequest({
          method: "DELETE",
          path: "/{id}/role-mappings/realm",
          urlParamKeys: ["id"],
          payloadKey: "roles"
        });
        _this.listAvailableRealmRoleMappings = _this.makeRequest({
          method: "GET",
          path: "/{id}/role-mappings/realm/available",
          urlParamKeys: ["id"]
        });
        _this.listCompositeRealmRoleMappings = _this.makeRequest({
          method: "GET",
          path: "/{id}/role-mappings/realm/composite",
          urlParamKeys: ["id"]
        });
        _this.listClientRoleMappings = _this.makeRequest({
          method: "GET",
          path: "/{id}/role-mappings/clients/{clientUniqueId}",
          urlParamKeys: ["id", "clientUniqueId"]
        });
        _this.addClientRoleMappings = _this.makeRequest({
          method: "POST",
          path: "/{id}/role-mappings/clients/{clientUniqueId}",
          urlParamKeys: ["id", "clientUniqueId"],
          payloadKey: "roles"
        });
        _this.delClientRoleMappings = _this.makeRequest({
          method: "DELETE",
          path: "/{id}/role-mappings/clients/{clientUniqueId}",
          urlParamKeys: ["id", "clientUniqueId"],
          payloadKey: "roles"
        });
        _this.listAvailableClientRoleMappings = _this.makeRequest({
          method: "GET",
          path: "/{id}/role-mappings/clients/{clientUniqueId}/available",
          urlParamKeys: ["id", "clientUniqueId"]
        });
        _this.listCompositeClientRoleMappings = _this.makeRequest({
          method: "GET",
          path: "/{id}/role-mappings/clients/{clientUniqueId}/composite",
          urlParamKeys: ["id", "clientUniqueId"]
        });
        _this.updatePermission = _this.makeUpdateRequest({
          method: "PUT",
          path: "/{id}/management/permissions",
          urlParamKeys: ["id"]
        });
        _this.listPermissions = _this.makeRequest({
          method: "GET",
          path: "/{id}/management/permissions",
          urlParamKeys: ["id"]
        });
        return _this;
      }
      return Groups2;
    }(resource_1["default"]);
    exports2.Groups = Groups;
  });
  var roles = createCommonjsModule(function(module2, exports2) {
    var __extends2 = commonjsGlobal && commonjsGlobal.__extends || function() {
      var extendStatics = function(d2, b2) {
        extendStatics = Object.setPrototypeOf || {__proto__: []} instanceof Array && function(d3, b3) {
          d3.__proto__ = b3;
        } || function(d3, b3) {
          for (var p2 in b3)
            if (Object.prototype.hasOwnProperty.call(b3, p2))
              d3[p2] = b3[p2];
        };
        return extendStatics(d2, b2);
      };
      return function(d2, b2) {
        if (typeof b2 !== "function" && b2 !== null)
          throw new TypeError("Class extends value " + String(b2) + " is not a constructor or null");
        extendStatics(d2, b2);
        function __() {
          this.constructor = d2;
        }
        d2.prototype = b2 === null ? Object.create(b2) : (__.prototype = b2.prototype, new __());
      };
    }();
    var __importDefault = commonjsGlobal && commonjsGlobal.__importDefault || function(mod) {
      return mod && mod.__esModule ? mod : {default: mod};
    };
    exports2.__esModule = true;
    exports2.Roles = void 0;
    var resource_1 = __importDefault(resource);
    var Roles = function(_super) {
      __extends2(Roles2, _super);
      function Roles2(client2) {
        var _this = _super.call(this, client2, {
          path: "/admin/realms/{realm}",
          getUrlParams: function() {
            return {
              realm: client2.realmName
            };
          },
          getBaseUrl: function() {
            return client2.baseUrl;
          }
        }) || this;
        _this.find = _this.makeRequest({
          method: "GET",
          path: "/roles"
        });
        _this.create = _this.makeRequest({
          method: "POST",
          path: "/roles",
          returnResourceIdInLocationHeader: {field: "roleName"}
        });
        _this.findOneByName = _this.makeRequest({
          method: "GET",
          path: "/roles/{name}",
          urlParamKeys: ["name"],
          catchNotFound: true
        });
        _this.updateByName = _this.makeUpdateRequest({
          method: "PUT",
          path: "/roles/{name}",
          urlParamKeys: ["name"]
        });
        _this.delByName = _this.makeRequest({
          method: "DELETE",
          path: "/roles/{name}",
          urlParamKeys: ["name"]
        });
        _this.findUsersWithRole = _this.makeRequest({
          method: "GET",
          path: "/roles/{name}/users",
          urlParamKeys: ["name"],
          catchNotFound: true
        });
        _this.findOneById = _this.makeRequest({
          method: "GET",
          path: "/roles-by-id/{id}",
          urlParamKeys: ["id"],
          catchNotFound: true
        });
        _this.createComposite = _this.makeUpdateRequest({
          method: "POST",
          path: "/roles-by-id/{roleId}/composites",
          urlParamKeys: ["roleId"]
        });
        _this.getCompositeRoles = _this.makeRequest({
          method: "GET",
          path: "/roles-by-id/{id}/composites",
          urlParamKeys: ["id"]
        });
        _this.getCompositeRolesForRealm = _this.makeRequest({
          method: "GET",
          path: "/roles-by-id/{id}/composites/realm",
          urlParamKeys: ["id"]
        });
        _this.getCompositeRolesForClient = _this.makeRequest({
          method: "GET",
          path: "/roles-by-id/{id}/composites/clients/{clientId}",
          urlParamKeys: ["id", "clientId"]
        });
        _this.delCompositeRoles = _this.makeUpdateRequest({
          method: "DELETE",
          path: "/roles-by-id/{id}/composites",
          urlParamKeys: ["id"]
        });
        _this.updateById = _this.makeUpdateRequest({
          method: "PUT",
          path: "/roles-by-id/{id}",
          urlParamKeys: ["id"]
        });
        _this.delById = _this.makeRequest({
          method: "DELETE",
          path: "/roles-by-id/{id}",
          urlParamKeys: ["id"]
        });
        return _this;
      }
      return Roles2;
    }(resource_1["default"]);
    exports2.Roles = Roles;
  });
  var clients = createCommonjsModule(function(module2, exports2) {
    var __extends2 = commonjsGlobal && commonjsGlobal.__extends || function() {
      var extendStatics = function(d2, b2) {
        extendStatics = Object.setPrototypeOf || {__proto__: []} instanceof Array && function(d3, b3) {
          d3.__proto__ = b3;
        } || function(d3, b3) {
          for (var p2 in b3)
            if (Object.prototype.hasOwnProperty.call(b3, p2))
              d3[p2] = b3[p2];
        };
        return extendStatics(d2, b2);
      };
      return function(d2, b2) {
        if (typeof b2 !== "function" && b2 !== null)
          throw new TypeError("Class extends value " + String(b2) + " is not a constructor or null");
        extendStatics(d2, b2);
        function __() {
          this.constructor = d2;
        }
        d2.prototype = b2 === null ? Object.create(b2) : (__.prototype = b2.prototype, new __());
      };
    }();
    var __assign2 = commonjsGlobal && commonjsGlobal.__assign || function() {
      __assign2 = Object.assign || function(t5) {
        for (var s2, i3 = 1, n3 = arguments.length; i3 < n3; i3++) {
          s2 = arguments[i3];
          for (var p2 in s2)
            if (Object.prototype.hasOwnProperty.call(s2, p2))
              t5[p2] = s2[p2];
        }
        return t5;
      };
      return __assign2.apply(this, arguments);
    };
    var __awaiter3 = commonjsGlobal && commonjsGlobal.__awaiter || function(thisArg, _arguments, P2, generator) {
      function adopt(value) {
        return value instanceof P2 ? value : new P2(function(resolve2) {
          resolve2(value);
        });
      }
      return new (P2 || (P2 = Promise))(function(resolve2, reject) {
        function fulfilled(value) {
          try {
            step(generator.next(value));
          } catch (e2) {
            reject(e2);
          }
        }
        function rejected(value) {
          try {
            step(generator["throw"](value));
          } catch (e2) {
            reject(e2);
          }
        }
        function step(result) {
          result.done ? resolve2(result.value) : adopt(result.value).then(fulfilled, rejected);
        }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
      });
    };
    var __generator2 = commonjsGlobal && commonjsGlobal.__generator || function(thisArg, body) {
      var _23 = {label: 0, sent: function() {
        if (t5[0] & 1)
          throw t5[1];
        return t5[1];
      }, trys: [], ops: []}, f2, y3, t5, g2;
      return g2 = {next: verb(0), throw: verb(1), return: verb(2)}, typeof Symbol === "function" && (g2[Symbol.iterator] = function() {
        return this;
      }), g2;
      function verb(n3) {
        return function(v2) {
          return step([n3, v2]);
        };
      }
      function step(op) {
        if (f2)
          throw new TypeError("Generator is already executing.");
        while (_23)
          try {
            if (f2 = 1, y3 && (t5 = op[0] & 2 ? y3["return"] : op[0] ? y3["throw"] || ((t5 = y3["return"]) && t5.call(y3), 0) : y3.next) && !(t5 = t5.call(y3, op[1])).done)
              return t5;
            if (y3 = 0, t5)
              op = [op[0] & 2, t5.value];
            switch (op[0]) {
              case 0:
              case 1:
                t5 = op;
                break;
              case 4:
                _23.label++;
                return {value: op[1], done: false};
              case 5:
                _23.label++;
                y3 = op[1];
                op = [0];
                continue;
              case 7:
                op = _23.ops.pop();
                _23.trys.pop();
                continue;
              default:
                if (!(t5 = _23.trys, t5 = t5.length > 0 && t5[t5.length - 1]) && (op[0] === 6 || op[0] === 2)) {
                  _23 = 0;
                  continue;
                }
                if (op[0] === 3 && (!t5 || op[1] > t5[0] && op[1] < t5[3])) {
                  _23.label = op[1];
                  break;
                }
                if (op[0] === 6 && _23.label < t5[1]) {
                  _23.label = t5[1];
                  t5 = op;
                  break;
                }
                if (t5 && _23.label < t5[2]) {
                  _23.label = t5[2];
                  _23.ops.push(op);
                  break;
                }
                if (t5[2])
                  _23.ops.pop();
                _23.trys.pop();
                continue;
            }
            op = body.call(thisArg, _23);
          } catch (e2) {
            op = [6, e2];
            y3 = 0;
          } finally {
            f2 = t5 = 0;
          }
        if (op[0] & 5)
          throw op[1];
        return {value: op[0] ? op[1] : void 0, done: true};
      }
    };
    var __importDefault = commonjsGlobal && commonjsGlobal.__importDefault || function(mod) {
      return mod && mod.__esModule ? mod : {default: mod};
    };
    exports2.__esModule = true;
    exports2.Clients = void 0;
    var resource_1 = __importDefault(resource);
    var Clients = function(_super) {
      __extends2(Clients2, _super);
      function Clients2(client2) {
        var _this = _super.call(this, client2, {
          path: "/admin/realms/{realm}/clients",
          getUrlParams: function() {
            return {
              realm: client2.realmName
            };
          },
          getBaseUrl: function() {
            return client2.baseUrl;
          }
        }) || this;
        _this.find = _this.makeRequest({
          method: "GET"
        });
        _this.create = _this.makeRequest({
          method: "POST",
          returnResourceIdInLocationHeader: {field: "id"}
        });
        _this.findOne = _this.makeRequest({
          method: "GET",
          path: "/{id}",
          urlParamKeys: ["id"],
          catchNotFound: true
        });
        _this.update = _this.makeUpdateRequest({
          method: "PUT",
          path: "/{id}",
          urlParamKeys: ["id"]
        });
        _this.del = _this.makeRequest({
          method: "DELETE",
          path: "/{id}",
          urlParamKeys: ["id"]
        });
        _this.createRole = _this.makeRequest({
          method: "POST",
          path: "/{id}/roles",
          urlParamKeys: ["id"],
          returnResourceIdInLocationHeader: {field: "roleName"}
        });
        _this.listRoles = _this.makeRequest({
          method: "GET",
          path: "/{id}/roles",
          urlParamKeys: ["id"]
        });
        _this.findRole = _this.makeRequest({
          method: "GET",
          path: "/{id}/roles/{roleName}",
          urlParamKeys: ["id", "roleName"],
          catchNotFound: true
        });
        _this.updateRole = _this.makeUpdateRequest({
          method: "PUT",
          path: "/{id}/roles/{roleName}",
          urlParamKeys: ["id", "roleName"]
        });
        _this.delRole = _this.makeRequest({
          method: "DELETE",
          path: "/{id}/roles/{roleName}",
          urlParamKeys: ["id", "roleName"]
        });
        _this.findUsersWithRole = _this.makeRequest({
          method: "GET",
          path: "/{id}/roles/{roleName}/users",
          urlParamKeys: ["id", "roleName"]
        });
        _this.getServiceAccountUser = _this.makeRequest({
          method: "GET",
          path: "/{id}/service-account-user",
          urlParamKeys: ["id"]
        });
        _this.generateNewClientSecret = _this.makeRequest({
          method: "POST",
          path: "/{id}/client-secret",
          urlParamKeys: ["id"]
        });
        _this.generateRegistrationAccessToken = _this.makeRequest({
          method: "POST",
          path: "/{id}/registration-access-token",
          urlParamKeys: ["id"]
        });
        _this.getClientSecret = _this.makeRequest({
          method: "GET",
          path: "/{id}/client-secret",
          urlParamKeys: ["id"]
        });
        _this.listDefaultClientScopes = _this.makeRequest({
          method: "GET",
          path: "/{id}/default-client-scopes",
          urlParamKeys: ["id"]
        });
        _this.addDefaultClientScope = _this.makeRequest({
          method: "PUT",
          path: "/{id}/default-client-scopes/{clientScopeId}",
          urlParamKeys: ["id", "clientScopeId"]
        });
        _this.delDefaultClientScope = _this.makeRequest({
          method: "DELETE",
          path: "/{id}/default-client-scopes/{clientScopeId}",
          urlParamKeys: ["id", "clientScopeId"]
        });
        _this.listOptionalClientScopes = _this.makeRequest({
          method: "GET",
          path: "/{id}/optional-client-scopes",
          urlParamKeys: ["id"]
        });
        _this.addOptionalClientScope = _this.makeRequest({
          method: "PUT",
          path: "/{id}/optional-client-scopes/{clientScopeId}",
          urlParamKeys: ["id", "clientScopeId"]
        });
        _this.delOptionalClientScope = _this.makeRequest({
          method: "DELETE",
          path: "/{id}/optional-client-scopes/{clientScopeId}",
          urlParamKeys: ["id", "clientScopeId"]
        });
        _this.addMultipleProtocolMappers = _this.makeUpdateRequest({
          method: "POST",
          path: "/{id}/protocol-mappers/add-models",
          urlParamKeys: ["id"]
        });
        _this.addProtocolMapper = _this.makeUpdateRequest({
          method: "POST",
          path: "/{id}/protocol-mappers/models",
          urlParamKeys: ["id"]
        });
        _this.listProtocolMappers = _this.makeRequest({
          method: "GET",
          path: "/{id}/protocol-mappers/models",
          urlParamKeys: ["id"]
        });
        _this.findProtocolMapperById = _this.makeRequest({
          method: "GET",
          path: "/{id}/protocol-mappers/models/{mapperId}",
          urlParamKeys: ["id", "mapperId"],
          catchNotFound: true
        });
        _this.findProtocolMappersByProtocol = _this.makeRequest({
          method: "GET",
          path: "/{id}/protocol-mappers/protocol/{protocol}",
          urlParamKeys: ["id", "protocol"],
          catchNotFound: true
        });
        _this.updateProtocolMapper = _this.makeUpdateRequest({
          method: "PUT",
          path: "/{id}/protocol-mappers/models/{mapperId}",
          urlParamKeys: ["id", "mapperId"]
        });
        _this.delProtocolMapper = _this.makeRequest({
          method: "DELETE",
          path: "/{id}/protocol-mappers/models/{mapperId}",
          urlParamKeys: ["id", "mapperId"]
        });
        _this.listScopeMappings = _this.makeRequest({
          method: "GET",
          path: "/{id}/scope-mappings",
          urlParamKeys: ["id"]
        });
        _this.addClientScopeMappings = _this.makeUpdateRequest({
          method: "POST",
          path: "/{id}/scope-mappings/clients/{client}",
          urlParamKeys: ["id", "client"]
        });
        _this.listClientScopeMappings = _this.makeRequest({
          method: "GET",
          path: "/{id}/scope-mappings/clients/{client}",
          urlParamKeys: ["id", "client"]
        });
        _this.listAvailableClientScopeMappings = _this.makeRequest({
          method: "GET",
          path: "/{id}/scope-mappings/clients/{client}/available",
          urlParamKeys: ["id", "client"]
        });
        _this.listCompositeClientScopeMappings = _this.makeRequest({
          method: "GET",
          path: "/{id}/scope-mappings/clients/{client}/available",
          urlParamKeys: ["id", "client"]
        });
        _this.delClientScopeMappings = _this.makeUpdateRequest({
          method: "DELETE",
          path: "/{id}/scope-mappings/clients/{client}",
          urlParamKeys: ["id", "client"]
        });
        _this.evaluatePermission = _this.makeRequest({
          method: "GET",
          path: "/{id}/evaluate-scopes/scope-mappings/{roleContainer}/{type}",
          urlParamKeys: ["id", "roleContainer", "type"],
          queryParamKeys: ["scope"]
        });
        _this.evaluateListProtocolMapper = _this.makeRequest({
          method: "GET",
          path: "/{id}/evaluate-scopes/protocol-mappers",
          urlParamKeys: ["id"],
          queryParamKeys: ["scope"]
        });
        _this.evaluateGenerateAccessToken = _this.makeRequest({
          method: "GET",
          path: "/{id}/evaluate-scopes/generate-example-access-token",
          urlParamKeys: ["id"],
          queryParamKeys: ["scope", "userId"]
        });
        _this.addRealmScopeMappings = _this.makeUpdateRequest({
          method: "POST",
          path: "/{id}/scope-mappings/realm",
          urlParamKeys: ["id", "client"]
        });
        _this.listRealmScopeMappings = _this.makeRequest({
          method: "GET",
          path: "/{id}/scope-mappings/realm",
          urlParamKeys: ["id"]
        });
        _this.listAvailableRealmScopeMappings = _this.makeRequest({
          method: "GET",
          path: "/{id}/scope-mappings/realm/available",
          urlParamKeys: ["id"]
        });
        _this.listCompositeRealmScopeMappings = _this.makeRequest({
          method: "GET",
          path: "/{id}/scope-mappings/realm/available",
          urlParamKeys: ["id"]
        });
        _this.delRealmScopeMappings = _this.makeUpdateRequest({
          method: "DELETE",
          path: "/{id}/scope-mappings/realm",
          urlParamKeys: ["id"]
        });
        _this.listSessions = _this.makeRequest({
          method: "GET",
          path: "/{id}/user-sessions",
          urlParamKeys: ["id"]
        });
        _this.listOfflineSessions = _this.makeRequest({
          method: "GET",
          path: "/{id}/offline-sessions",
          urlParamKeys: ["id"]
        });
        _this.getSessionCount = _this.makeRequest({
          method: "GET",
          path: "/{id}/session-count",
          urlParamKeys: ["id"]
        });
        _this.getResourceServer = _this.makeRequest({
          method: "GET",
          path: "{id}/authz/resource-server",
          urlParamKeys: ["id"]
        });
        _this.updateResourceServer = _this.makeUpdateRequest({
          method: "PUT",
          path: "{id}/authz/resource-server",
          urlParamKeys: ["id"]
        });
        _this.listResources = _this.makeRequest({
          method: "GET",
          path: "{id}/authz/resource-server/resource",
          urlParamKeys: ["id"]
        });
        _this.createResource = _this.makeUpdateRequest({
          method: "POST",
          path: "{id}/authz/resource-server/resource",
          urlParamKeys: ["id"]
        });
        _this.getResource = _this.makeRequest({
          method: "GET",
          path: "{id}/authz/resource-server/resource/{resourceId}",
          urlParamKeys: ["id", "resourceId"]
        });
        _this.updateResource = _this.makeUpdateRequest({
          method: "PUT",
          path: "/{id}/authz/resource-server/resource/{resourceId}",
          urlParamKeys: ["id", "resourceId"]
        });
        _this.delResource = _this.makeRequest({
          method: "DELETE",
          path: "/{id}/authz/resource-server/resource/{resourceId}",
          urlParamKeys: ["id", "resourceId"]
        });
        _this.importResource = _this.makeUpdateRequest({
          method: "POST",
          path: "/{id}/authz/resource-server/import",
          urlParamKeys: ["id"]
        });
        _this.exportResource = _this.makeRequest({
          method: "GET",
          path: "/{id}/authz/resource-server/settings",
          urlParamKeys: ["id"]
        });
        _this.evaluateResource = _this.makeUpdateRequest({
          method: "POST",
          path: "{id}/authz/resource-server/policy/evaluate",
          urlParamKeys: ["id"]
        });
        _this.listPolicies = _this.makeRequest({
          method: "GET",
          path: "{id}/authz/resource-server/policy",
          urlParamKeys: ["id"]
        });
        _this.findPolicyByName = _this.makeRequest({
          method: "GET",
          path: "{id}/authz/resource-server/policy/search",
          urlParamKeys: ["id"]
        });
        _this.updatePolicy = _this.makeUpdateRequest({
          method: "PUT",
          path: "/{id}/authz/resource-server/policy/{type}/{policyId}",
          urlParamKeys: ["id", "type", "policyId"]
        });
        _this.createPolicy = _this.makeUpdateRequest({
          method: "POST",
          path: "/{id}/authz/resource-server/policy/{type}",
          urlParamKeys: ["id", "type"]
        });
        _this.findOnePolicy = _this.makeRequest({
          method: "GET",
          path: "/{id}/authz/resource-server/policy/{type}/{policyId}",
          urlParamKeys: ["id", "type", "policyId"],
          catchNotFound: true
        });
        _this.delPolicy = _this.makeRequest({
          method: "DELETE",
          path: "{id}/authz/resource-server/policy/{policyId}",
          urlParamKeys: ["id", "policyId"]
        });
        _this.listAllScopes = _this.makeRequest({
          method: "GET",
          path: "/{id}/authz/resource-server/scope",
          urlParamKeys: ["id"]
        });
        _this.listPermissionsByResource = _this.makeRequest({
          method: "GET",
          path: "/{id}/authz/resource-server/resource/{resourceId}/permissions",
          urlParamKeys: ["id", "resourceId"]
        });
        _this.listScopesByResource = _this.makeRequest({
          method: "GET",
          path: "/{id}/authz/resource-server/resource/{resourceName}/scopes",
          urlParamKeys: ["id", "resourceName"]
        });
        _this.createAuthorizationScope = _this.makeUpdateRequest({
          method: "POST",
          path: "{id}/authz/resource-server/scope",
          urlParamKeys: ["id"]
        });
        _this.findPermissions = _this.makeRequest({
          method: "GET",
          path: "{id}/authz/resource-server/permission",
          urlParamKeys: ["id"]
        });
        _this.createPermission = _this.makeUpdateRequest({
          method: "POST",
          path: "/{id}/authz/resource-server/permission/{type}",
          urlParamKeys: ["id", "type"]
        });
        _this.updatePermission = _this.makeUpdateRequest({
          method: "PUT",
          path: "/{id}/authz/resource-server/permission/{type}/{permissionId}",
          urlParamKeys: ["id", "type", "permissionId"]
        });
        _this.delPermission = _this.makeRequest({
          method: "DELETE",
          path: "/{id}/authz/resource-server/permission/{type}/{permissionId}",
          urlParamKeys: ["id", "type", "permissionId"]
        });
        _this.findOnePermission = _this.makeRequest({
          method: "GET",
          path: "/{id}/authz/resource-server/permission/{type}/{permissionId}",
          urlParamKeys: ["id", "type", "permissionId"]
        });
        _this.getAssociatedScopes = _this.makeRequest({
          method: "GET",
          path: "/{id}/authz/resource-server/policy/{permissionId}/scopes",
          urlParamKeys: ["id", "permissionId"]
        });
        _this.getAssociatedResources = _this.makeRequest({
          method: "GET",
          path: "/{id}/authz/resource-server/policy/{permissionId}/resources",
          urlParamKeys: ["id", "permissionId"]
        });
        _this.getOfflineSessionCount = _this.makeRequest({
          method: "GET",
          path: "/{id}/offline-session-count",
          urlParamKeys: ["id"]
        });
        _this.getInstallationProviders = _this.makeRequest({
          method: "GET",
          path: "/{id}/installation/providers/{providerId}",
          urlParamKeys: ["id", "providerId"]
        });
        _this.pushRevocation = _this.makeRequest({
          method: "POST",
          path: "/{id}/push-revocation",
          urlParamKeys: ["id"]
        });
        _this.addClusterNode = _this.makeRequest({
          method: "POST",
          path: "/{id}/nodes",
          urlParamKeys: ["id"]
        });
        _this.deleteClusterNode = _this.makeRequest({
          method: "DELETE",
          path: "/{id}/nodes/{node}",
          urlParamKeys: ["id", "node"]
        });
        _this.testNodesAvailable = _this.makeRequest({
          method: "GET",
          path: "/{id}/test-nodes-available",
          urlParamKeys: ["id"]
        });
        _this.getKeyInfo = _this.makeRequest({
          method: "GET",
          path: "/{id}/certificates/{attr}",
          urlParamKeys: ["id", "attr"]
        });
        _this.generateKey = _this.makeRequest({
          method: "POST",
          path: "/{id}/certificates/{attr}/generate",
          urlParamKeys: ["id", "attr"]
        });
        _this.downloadKey = _this.makeUpdateRequest({
          method: "POST",
          path: "/{id}/certificates/{attr}/download",
          urlParamKeys: ["id", "attr"]
        });
        _this.generateAndDownloadKey = _this.makeUpdateRequest({
          method: "POST",
          path: "/{id}/certificates/{attr}/generate-and-download",
          urlParamKeys: ["id", "attr"]
        });
        _this.uploadKey = _this.makeUpdateRequest({
          method: "POST",
          path: "/{id}/certificates/{attr}/upload",
          urlParamKeys: ["id", "attr"]
        });
        _this.uploadCertificate = _this.makeUpdateRequest({
          method: "POST",
          path: "/{id}/certificates/{attr}/upload-certificate",
          urlParamKeys: ["id", "attr"]
        });
        return _this;
      }
      Clients2.prototype.createOrUpdatePolicy = function(payload) {
        return __awaiter3(this, void 0, void 0, function() {
          var policyFound;
          return __generator2(this, function(_a) {
            switch (_a.label) {
              case 0:
                return [4, this.findPolicyByName({
                  id: payload.id,
                  name: payload.policyName
                })];
              case 1:
                policyFound = _a.sent();
                if (!policyFound)
                  return [3, 3];
                return [4, this.updatePolicy({id: payload.id, policyId: policyFound.id, type: payload.policy.type}, payload.policy)];
              case 2:
                _a.sent();
                return [2, this.findPolicyByName({id: payload.id, name: payload.policyName})];
              case 3:
                return [2, this.createPolicy({id: payload.id, type: payload.policy.type}, payload.policy)];
            }
          });
        });
      };
      Clients2.prototype.findProtocolMapperByName = function(payload) {
        return __awaiter3(this, void 0, void 0, function() {
          var allProtocolMappers;
          return __generator2(this, function(_a) {
            switch (_a.label) {
              case 0:
                return [4, this.listProtocolMappers(__assign2({id: payload.id}, payload.realm ? {realm: payload.realm} : {}))];
              case 1:
                allProtocolMappers = _a.sent();
                return [2, allProtocolMappers.find(function(mapper) {
                  return mapper.name === payload.name;
                })];
            }
          });
        });
      };
      return Clients2;
    }(resource_1["default"]);
    exports2.Clients = Clients;
  });
  var realms = createCommonjsModule(function(module2, exports2) {
    var __extends2 = commonjsGlobal && commonjsGlobal.__extends || function() {
      var extendStatics = function(d2, b2) {
        extendStatics = Object.setPrototypeOf || {__proto__: []} instanceof Array && function(d3, b3) {
          d3.__proto__ = b3;
        } || function(d3, b3) {
          for (var p2 in b3)
            if (Object.prototype.hasOwnProperty.call(b3, p2))
              d3[p2] = b3[p2];
        };
        return extendStatics(d2, b2);
      };
      return function(d2, b2) {
        if (typeof b2 !== "function" && b2 !== null)
          throw new TypeError("Class extends value " + String(b2) + " is not a constructor or null");
        extendStatics(d2, b2);
        function __() {
          this.constructor = d2;
        }
        d2.prototype = b2 === null ? Object.create(b2) : (__.prototype = b2.prototype, new __());
      };
    }();
    var __importDefault = commonjsGlobal && commonjsGlobal.__importDefault || function(mod) {
      return mod && mod.__esModule ? mod : {default: mod};
    };
    exports2.__esModule = true;
    exports2.Realms = void 0;
    var resource_1 = __importDefault(resource);
    var Realms = function(_super) {
      __extends2(Realms2, _super);
      function Realms2(client2) {
        var _this = _super.call(this, client2, {
          path: "/admin/realms",
          getBaseUrl: function() {
            return client2.baseUrl;
          }
        }) || this;
        _this.find = _this.makeRequest({
          method: "GET"
        });
        _this.create = _this.makeRequest({
          method: "POST",
          returnResourceIdInLocationHeader: {field: "realmName"}
        });
        _this.findOne = _this.makeRequest({
          method: "GET",
          path: "/{realm}",
          urlParamKeys: ["realm"],
          catchNotFound: true
        });
        _this.update = _this.makeUpdateRequest({
          method: "PUT",
          path: "/{realm}",
          urlParamKeys: ["realm"]
        });
        _this.del = _this.makeRequest({
          method: "DELETE",
          path: "/{realm}",
          urlParamKeys: ["realm"]
        });
        _this.partialImport = _this.makeRequest({
          method: "POST",
          path: "/{realm}/partialImport",
          urlParamKeys: ["realm"],
          payloadKey: "rep"
        });
        _this["export"] = _this.makeRequest({
          method: "POST",
          path: "/{realm}/partial-export",
          urlParamKeys: ["realm"],
          queryParamKeys: ["exportClients", "exportGroupsAndRoles"]
        });
        _this.findEvents = _this.makeRequest({
          method: "GET",
          path: "/{realm}/events",
          urlParamKeys: ["realm"],
          queryParamKeys: [
            "client",
            "dateFrom",
            "dateTo",
            "first",
            "ipAddress",
            "max",
            "type",
            "user"
          ]
        });
        _this.getConfigEvents = _this.makeRequest({
          method: "GET",
          path: "/{realm}/events/config",
          urlParamKeys: ["realm"]
        });
        _this.updateConfigEvents = _this.makeUpdateRequest({
          method: "PUT",
          path: "/{realm}/events/config",
          urlParamKeys: ["realm"]
        });
        _this.clearEvents = _this.makeRequest({
          method: "DELETE",
          path: "/{realm}/events",
          urlParamKeys: ["realm"]
        });
        _this.clearAdminEvents = _this.makeRequest({
          method: "DELETE",
          path: "/{realm}/admin-events",
          urlParamKeys: ["realm"]
        });
        _this.getClientsInitialAccess = _this.makeRequest({
          method: "GET",
          path: "/{realm}/clients-initial-access",
          urlParamKeys: ["realm"]
        });
        _this.createClientsInitialAccess = _this.makeUpdateRequest({
          method: "POST",
          path: "/{realm}/clients-initial-access",
          urlParamKeys: ["realm"]
        });
        _this.delClientsInitialAccess = _this.makeRequest({
          method: "DELETE",
          path: "/{realm}/clients-initial-access/{id}",
          urlParamKeys: ["realm", "id"]
        });
        _this.removeSession = _this.makeRequest({
          method: "DELETE",
          path: "/{realm}/sessions/{session}",
          urlParamKeys: ["realm", "session"],
          catchNotFound: true
        });
        _this.findAdminEvents = _this.makeRequest({
          method: "GET",
          path: "/{realm}/admin-events",
          urlParamKeys: ["realm"],
          queryParamKeys: [
            "authClient",
            "authIpAddress",
            "authRealm",
            "authUser",
            "dateFrom",
            "dateTo",
            "max",
            "first",
            "operationTypes",
            "resourcePath",
            "resourceTypes"
          ]
        });
        _this.getUsersManagementPermissions = _this.makeRequest({
          method: "GET",
          path: "/{realm}/users-management-permissions",
          urlParamKeys: ["realm"]
        });
        _this.updateUsersManagementPermissions = _this.makeRequest({
          method: "PUT",
          path: "/{realm}/users-management-permissions",
          urlParamKeys: ["realm"]
        });
        _this.logoutAll = _this.makeRequest({
          method: "POST",
          path: "/{realm}/logout-all",
          urlParamKeys: ["realm"]
        });
        _this.deleteSession = _this.makeRequest({
          method: "DELETE",
          path: "/{realm}/sessions/{session}",
          urlParamKeys: ["realm", "session"]
        });
        _this.pushRevocation = _this.makeRequest({
          method: "POST",
          path: "/{realm}/push-revocation",
          urlParamKeys: ["realm"],
          ignoredKeys: ["realm"]
        });
        _this.getKeys = _this.makeRequest({
          method: "GET",
          path: "/{realm}/keys",
          urlParamKeys: ["realm"]
        });
        _this.testLDAPConnection = _this.makeUpdateRequest({
          method: "POST",
          path: "/{realm}/testLDAPConnection",
          urlParamKeys: ["realm"]
        });
        _this.testSMTPConnection = _this.makeUpdateRequest({
          method: "POST",
          path: "/{realm}/testSMTPConnection",
          urlParamKeys: ["realm"]
        });
        _this.getRealmSpecificLocales = _this.makeRequest({
          method: "GET",
          path: "/{realm}/localization",
          urlParamKeys: ["realm"]
        });
        _this.getRealmLocalizationTexts = _this.makeRequest({
          method: "GET",
          path: "/{realm}/localization/{selectedLocale}",
          urlParamKeys: ["realm", "selectedLocale"]
        });
        _this.addLocalization = _this.makeUpdateRequest({
          method: "PUT",
          path: "/{realm}/localization/{selectedLocale}/{key}",
          urlParamKeys: ["realm", "selectedLocale", "key"],
          headers: {"content-type": "text/plain"}
        });
        _this.deleteRealmLocalizationTexts = _this.makeRequest({
          method: "DELETE",
          path: "/{realm}/localization/{selectedLocale}/{key}",
          urlParamKeys: ["realm", "selectedLocale", "key"]
        });
        return _this;
      }
      return Realms2;
    }(resource_1["default"]);
    exports2.Realms = Realms;
  });
  var clientScopes = createCommonjsModule(function(module2, exports2) {
    var __extends2 = commonjsGlobal && commonjsGlobal.__extends || function() {
      var extendStatics = function(d2, b2) {
        extendStatics = Object.setPrototypeOf || {__proto__: []} instanceof Array && function(d3, b3) {
          d3.__proto__ = b3;
        } || function(d3, b3) {
          for (var p2 in b3)
            if (Object.prototype.hasOwnProperty.call(b3, p2))
              d3[p2] = b3[p2];
        };
        return extendStatics(d2, b2);
      };
      return function(d2, b2) {
        if (typeof b2 !== "function" && b2 !== null)
          throw new TypeError("Class extends value " + String(b2) + " is not a constructor or null");
        extendStatics(d2, b2);
        function __() {
          this.constructor = d2;
        }
        d2.prototype = b2 === null ? Object.create(b2) : (__.prototype = b2.prototype, new __());
      };
    }();
    var __assign2 = commonjsGlobal && commonjsGlobal.__assign || function() {
      __assign2 = Object.assign || function(t5) {
        for (var s2, i3 = 1, n3 = arguments.length; i3 < n3; i3++) {
          s2 = arguments[i3];
          for (var p2 in s2)
            if (Object.prototype.hasOwnProperty.call(s2, p2))
              t5[p2] = s2[p2];
        }
        return t5;
      };
      return __assign2.apply(this, arguments);
    };
    var __awaiter3 = commonjsGlobal && commonjsGlobal.__awaiter || function(thisArg, _arguments, P2, generator) {
      function adopt(value) {
        return value instanceof P2 ? value : new P2(function(resolve2) {
          resolve2(value);
        });
      }
      return new (P2 || (P2 = Promise))(function(resolve2, reject) {
        function fulfilled(value) {
          try {
            step(generator.next(value));
          } catch (e2) {
            reject(e2);
          }
        }
        function rejected(value) {
          try {
            step(generator["throw"](value));
          } catch (e2) {
            reject(e2);
          }
        }
        function step(result) {
          result.done ? resolve2(result.value) : adopt(result.value).then(fulfilled, rejected);
        }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
      });
    };
    var __generator2 = commonjsGlobal && commonjsGlobal.__generator || function(thisArg, body) {
      var _23 = {label: 0, sent: function() {
        if (t5[0] & 1)
          throw t5[1];
        return t5[1];
      }, trys: [], ops: []}, f2, y3, t5, g2;
      return g2 = {next: verb(0), throw: verb(1), return: verb(2)}, typeof Symbol === "function" && (g2[Symbol.iterator] = function() {
        return this;
      }), g2;
      function verb(n3) {
        return function(v2) {
          return step([n3, v2]);
        };
      }
      function step(op) {
        if (f2)
          throw new TypeError("Generator is already executing.");
        while (_23)
          try {
            if (f2 = 1, y3 && (t5 = op[0] & 2 ? y3["return"] : op[0] ? y3["throw"] || ((t5 = y3["return"]) && t5.call(y3), 0) : y3.next) && !(t5 = t5.call(y3, op[1])).done)
              return t5;
            if (y3 = 0, t5)
              op = [op[0] & 2, t5.value];
            switch (op[0]) {
              case 0:
              case 1:
                t5 = op;
                break;
              case 4:
                _23.label++;
                return {value: op[1], done: false};
              case 5:
                _23.label++;
                y3 = op[1];
                op = [0];
                continue;
              case 7:
                op = _23.ops.pop();
                _23.trys.pop();
                continue;
              default:
                if (!(t5 = _23.trys, t5 = t5.length > 0 && t5[t5.length - 1]) && (op[0] === 6 || op[0] === 2)) {
                  _23 = 0;
                  continue;
                }
                if (op[0] === 3 && (!t5 || op[1] > t5[0] && op[1] < t5[3])) {
                  _23.label = op[1];
                  break;
                }
                if (op[0] === 6 && _23.label < t5[1]) {
                  _23.label = t5[1];
                  t5 = op;
                  break;
                }
                if (t5 && _23.label < t5[2]) {
                  _23.label = t5[2];
                  _23.ops.push(op);
                  break;
                }
                if (t5[2])
                  _23.ops.pop();
                _23.trys.pop();
                continue;
            }
            op = body.call(thisArg, _23);
          } catch (e2) {
            op = [6, e2];
            y3 = 0;
          } finally {
            f2 = t5 = 0;
          }
        if (op[0] & 5)
          throw op[1];
        return {value: op[0] ? op[1] : void 0, done: true};
      }
    };
    var __importDefault = commonjsGlobal && commonjsGlobal.__importDefault || function(mod) {
      return mod && mod.__esModule ? mod : {default: mod};
    };
    exports2.__esModule = true;
    exports2.ClientScopes = void 0;
    var resource_1 = __importDefault(resource);
    var ClientScopes2 = function(_super) {
      __extends2(ClientScopes3, _super);
      function ClientScopes3(client2) {
        var _this = _super.call(this, client2, {
          path: "/admin/realms/{realm}",
          getUrlParams: function() {
            return {
              realm: client2.realmName
            };
          },
          getBaseUrl: function() {
            return client2.baseUrl;
          }
        }) || this;
        _this.find = _this.makeRequest({
          method: "GET",
          path: "/client-scopes"
        });
        _this.create = _this.makeRequest({
          method: "POST",
          path: "/client-scopes"
        });
        _this.findOne = _this.makeRequest({
          method: "GET",
          path: "/client-scopes/{id}",
          urlParamKeys: ["id"],
          catchNotFound: true
        });
        _this.update = _this.makeUpdateRequest({
          method: "PUT",
          path: "/client-scopes/{id}",
          urlParamKeys: ["id"]
        });
        _this.del = _this.makeRequest({
          method: "DELETE",
          path: "/client-scopes/{id}",
          urlParamKeys: ["id"]
        });
        _this.listDefaultClientScopes = _this.makeRequest({
          method: "GET",
          path: "/default-default-client-scopes"
        });
        _this.addDefaultClientScope = _this.makeRequest({
          method: "PUT",
          path: "/default-default-client-scopes/{id}",
          urlParamKeys: ["id"]
        });
        _this.delDefaultClientScope = _this.makeRequest({
          method: "DELETE",
          path: "/default-default-client-scopes/{id}",
          urlParamKeys: ["id"]
        });
        _this.listDefaultOptionalClientScopes = _this.makeRequest({
          method: "GET",
          path: "/default-optional-client-scopes"
        });
        _this.addDefaultOptionalClientScope = _this.makeRequest({
          method: "PUT",
          path: "/default-optional-client-scopes/{id}",
          urlParamKeys: ["id"]
        });
        _this.delDefaultOptionalClientScope = _this.makeRequest({
          method: "DELETE",
          path: "/default-optional-client-scopes/{id}",
          urlParamKeys: ["id"]
        });
        _this.addMultipleProtocolMappers = _this.makeUpdateRequest({
          method: "POST",
          path: "/client-scopes/{id}/protocol-mappers/add-models",
          urlParamKeys: ["id"]
        });
        _this.addProtocolMapper = _this.makeUpdateRequest({
          method: "POST",
          path: "/client-scopes/{id}/protocol-mappers/models",
          urlParamKeys: ["id"]
        });
        _this.listProtocolMappers = _this.makeRequest({
          method: "GET",
          path: "/client-scopes/{id}/protocol-mappers/models",
          urlParamKeys: ["id"]
        });
        _this.findProtocolMapper = _this.makeRequest({
          method: "GET",
          path: "/client-scopes/{id}/protocol-mappers/models/{mapperId}",
          urlParamKeys: ["id", "mapperId"],
          catchNotFound: true
        });
        _this.findProtocolMappersByProtocol = _this.makeRequest({
          method: "GET",
          path: "/client-scopes/{id}/protocol-mappers/protocol/{protocol}",
          urlParamKeys: ["id", "protocol"],
          catchNotFound: true
        });
        _this.updateProtocolMapper = _this.makeUpdateRequest({
          method: "PUT",
          path: "/client-scopes/{id}/protocol-mappers/models/{mapperId}",
          urlParamKeys: ["id", "mapperId"]
        });
        _this.delProtocolMapper = _this.makeRequest({
          method: "DELETE",
          path: "/client-scopes/{id}/protocol-mappers/models/{mapperId}",
          urlParamKeys: ["id", "mapperId"]
        });
        _this.listScopeMappings = _this.makeRequest({
          method: "GET",
          path: "/client-scopes/{id}/scope-mappings",
          urlParamKeys: ["id"]
        });
        _this.addClientScopeMappings = _this.makeUpdateRequest({
          method: "POST",
          path: "/client-scopes/{id}/scope-mappings/clients/{client}",
          urlParamKeys: ["id", "client"]
        });
        _this.listClientScopeMappings = _this.makeRequest({
          method: "GET",
          path: "/client-scopes/{id}/scope-mappings/clients/{client}",
          urlParamKeys: ["id", "client"]
        });
        _this.listAvailableClientScopeMappings = _this.makeRequest({
          method: "GET",
          path: "/client-scopes/{id}/scope-mappings/clients/{client}/available",
          urlParamKeys: ["id", "client"]
        });
        _this.listCompositeClientScopeMappings = _this.makeRequest({
          method: "GET",
          path: "/client-scopes/{id}/scope-mappings/clients/{client}/composite",
          urlParamKeys: ["id", "client"]
        });
        _this.delClientScopeMappings = _this.makeUpdateRequest({
          method: "DELETE",
          path: "/client-scopes/{id}/scope-mappings/clients/{client}",
          urlParamKeys: ["id", "client"]
        });
        _this.addRealmScopeMappings = _this.makeUpdateRequest({
          method: "POST",
          path: "/client-scopes/{id}/scope-mappings/realm",
          urlParamKeys: ["id"]
        });
        _this.listRealmScopeMappings = _this.makeRequest({
          method: "GET",
          path: "/client-scopes/{id}/scope-mappings/realm",
          urlParamKeys: ["id"]
        });
        _this.listAvailableRealmScopeMappings = _this.makeRequest({
          method: "GET",
          path: "/client-scopes/{id}/scope-mappings/realm/available",
          urlParamKeys: ["id"]
        });
        _this.listCompositeRealmScopeMappings = _this.makeRequest({
          method: "GET",
          path: "/client-scopes/{id}/scope-mappings/realm/composite",
          urlParamKeys: ["id"]
        });
        _this.delRealmScopeMappings = _this.makeUpdateRequest({
          method: "DELETE",
          path: "/client-scopes/{id}/scope-mappings/realm",
          urlParamKeys: ["id"]
        });
        return _this;
      }
      ClientScopes3.prototype.findOneByName = function(payload) {
        return __awaiter3(this, void 0, void 0, function() {
          var allScopes;
          return __generator2(this, function(_a) {
            switch (_a.label) {
              case 0:
                return [4, this.find(__assign2({}, payload.realm ? {realm: payload.realm} : {}))];
              case 1:
                allScopes = _a.sent();
                return [2, allScopes.find(function(item) {
                  return item.name === payload.name;
                })];
            }
          });
        });
      };
      ClientScopes3.prototype.delByName = function(payload) {
        return __awaiter3(this, void 0, void 0, function() {
          var scope;
          return __generator2(this, function(_a) {
            switch (_a.label) {
              case 0:
                return [4, this.findOneByName(payload)];
              case 1:
                scope = _a.sent();
                if (!scope) {
                  throw new Error("Scope not found.");
                }
                return [4, this.del(__assign2(__assign2({}, payload.realm ? {realm: payload.realm} : {}), {id: scope.id}))];
              case 2:
                _a.sent();
                return [2];
            }
          });
        });
      };
      ClientScopes3.prototype.findProtocolMapperByName = function(payload) {
        return __awaiter3(this, void 0, void 0, function() {
          var allProtocolMappers;
          return __generator2(this, function(_a) {
            switch (_a.label) {
              case 0:
                return [4, this.listProtocolMappers(__assign2({id: payload.id}, payload.realm ? {realm: payload.realm} : {}))];
              case 1:
                allProtocolMappers = _a.sent();
                return [2, allProtocolMappers.find(function(mapper) {
                  return mapper.name === payload.name;
                })];
            }
          });
        });
      };
      return ClientScopes3;
    }(resource_1["default"]);
    exports2.ClientScopes = ClientScopes2;
  });
  var clientPolicies = createCommonjsModule(function(module2, exports2) {
    var __extends2 = commonjsGlobal && commonjsGlobal.__extends || function() {
      var extendStatics = function(d2, b2) {
        extendStatics = Object.setPrototypeOf || {__proto__: []} instanceof Array && function(d3, b3) {
          d3.__proto__ = b3;
        } || function(d3, b3) {
          for (var p2 in b3)
            if (Object.prototype.hasOwnProperty.call(b3, p2))
              d3[p2] = b3[p2];
        };
        return extendStatics(d2, b2);
      };
      return function(d2, b2) {
        if (typeof b2 !== "function" && b2 !== null)
          throw new TypeError("Class extends value " + String(b2) + " is not a constructor or null");
        extendStatics(d2, b2);
        function __() {
          this.constructor = d2;
        }
        d2.prototype = b2 === null ? Object.create(b2) : (__.prototype = b2.prototype, new __());
      };
    }();
    var __importDefault = commonjsGlobal && commonjsGlobal.__importDefault || function(mod) {
      return mod && mod.__esModule ? mod : {default: mod};
    };
    exports2.__esModule = true;
    exports2.ClientPolicies = void 0;
    var resource_1 = __importDefault(resource);
    var ClientPolicies = function(_super) {
      __extends2(ClientPolicies2, _super);
      function ClientPolicies2(client2) {
        var _this = _super.call(this, client2, {
          path: "/admin/realms/{realm}/client-policies",
          getUrlParams: function() {
            return {
              realm: client2.realmName
            };
          },
          getBaseUrl: function() {
            return client2.baseUrl;
          }
        }) || this;
        _this.listProfiles = _this.makeRequest({
          method: "GET",
          path: "/profiles",
          queryParamKeys: ["include-global-profiles"],
          keyTransform: {
            includeGlobalProfiles: "include-global-profiles"
          }
        });
        _this.createProfiles = _this.makeRequest({
          method: "PUT",
          path: "/profiles"
        });
        _this.listPolicies = _this.makeRequest({
          method: "GET",
          path: "/policies"
        });
        _this.updatePolicy = _this.makeRequest({
          method: "PUT",
          path: "/policies"
        });
        return _this;
      }
      return ClientPolicies2;
    }(resource_1["default"]);
    exports2.ClientPolicies = ClientPolicies;
  });
  var identityProviders = createCommonjsModule(function(module2, exports2) {
    var __extends2 = commonjsGlobal && commonjsGlobal.__extends || function() {
      var extendStatics = function(d2, b2) {
        extendStatics = Object.setPrototypeOf || {__proto__: []} instanceof Array && function(d3, b3) {
          d3.__proto__ = b3;
        } || function(d3, b3) {
          for (var p2 in b3)
            if (Object.prototype.hasOwnProperty.call(b3, p2))
              d3[p2] = b3[p2];
        };
        return extendStatics(d2, b2);
      };
      return function(d2, b2) {
        if (typeof b2 !== "function" && b2 !== null)
          throw new TypeError("Class extends value " + String(b2) + " is not a constructor or null");
        extendStatics(d2, b2);
        function __() {
          this.constructor = d2;
        }
        d2.prototype = b2 === null ? Object.create(b2) : (__.prototype = b2.prototype, new __());
      };
    }();
    var __importDefault = commonjsGlobal && commonjsGlobal.__importDefault || function(mod) {
      return mod && mod.__esModule ? mod : {default: mod};
    };
    exports2.__esModule = true;
    exports2.IdentityProviders = void 0;
    var resource_1 = __importDefault(resource);
    var IdentityProviders = function(_super) {
      __extends2(IdentityProviders2, _super);
      function IdentityProviders2(client2) {
        var _this = _super.call(this, client2, {
          path: "/admin/realms/{realm}/identity-provider",
          getUrlParams: function() {
            return {
              realm: client2.realmName
            };
          },
          getBaseUrl: function() {
            return client2.baseUrl;
          }
        }) || this;
        _this.find = _this.makeRequest({
          method: "GET",
          path: "/instances"
        });
        _this.create = _this.makeRequest({
          method: "POST",
          path: "/instances",
          returnResourceIdInLocationHeader: {field: "id"}
        });
        _this.findOne = _this.makeRequest({
          method: "GET",
          path: "/instances/{alias}",
          urlParamKeys: ["alias"],
          catchNotFound: true
        });
        _this.update = _this.makeUpdateRequest({
          method: "PUT",
          path: "/instances/{alias}",
          urlParamKeys: ["alias"]
        });
        _this.del = _this.makeRequest({
          method: "DELETE",
          path: "/instances/{alias}",
          urlParamKeys: ["alias"]
        });
        _this.findFactory = _this.makeRequest({
          method: "GET",
          path: "/providers/{providerId}",
          urlParamKeys: ["providerId"]
        });
        _this.findMappers = _this.makeRequest({
          method: "GET",
          path: "/instances/{alias}/mappers",
          urlParamKeys: ["alias"]
        });
        _this.findOneMapper = _this.makeRequest({
          method: "GET",
          path: "/instances/{alias}/mappers/{id}",
          urlParamKeys: ["alias", "id"],
          catchNotFound: true
        });
        _this.createMapper = _this.makeRequest({
          method: "POST",
          path: "/instances/{alias}/mappers",
          urlParamKeys: ["alias"],
          payloadKey: "identityProviderMapper",
          returnResourceIdInLocationHeader: {field: "id"}
        });
        _this.updateMapper = _this.makeUpdateRequest({
          method: "PUT",
          path: "/instances/{alias}/mappers/{id}",
          urlParamKeys: ["alias", "id"]
        });
        _this.delMapper = _this.makeRequest({
          method: "DELETE",
          path: "/instances/{alias}/mappers/{id}",
          urlParamKeys: ["alias", "id"]
        });
        _this.findMapperTypes = _this.makeRequest({
          method: "GET",
          path: "/instances/{alias}/mapper-types",
          urlParamKeys: ["alias"]
        });
        _this.importFromUrl = _this.makeRequest({
          method: "POST",
          path: "/import-config"
        });
        return _this;
      }
      return IdentityProviders2;
    }(resource_1["default"]);
    exports2.IdentityProviders = IdentityProviders;
  });
  var components = createCommonjsModule(function(module2, exports2) {
    var __extends2 = commonjsGlobal && commonjsGlobal.__extends || function() {
      var extendStatics = function(d2, b2) {
        extendStatics = Object.setPrototypeOf || {__proto__: []} instanceof Array && function(d3, b3) {
          d3.__proto__ = b3;
        } || function(d3, b3) {
          for (var p2 in b3)
            if (Object.prototype.hasOwnProperty.call(b3, p2))
              d3[p2] = b3[p2];
        };
        return extendStatics(d2, b2);
      };
      return function(d2, b2) {
        if (typeof b2 !== "function" && b2 !== null)
          throw new TypeError("Class extends value " + String(b2) + " is not a constructor or null");
        extendStatics(d2, b2);
        function __() {
          this.constructor = d2;
        }
        d2.prototype = b2 === null ? Object.create(b2) : (__.prototype = b2.prototype, new __());
      };
    }();
    var __importDefault = commonjsGlobal && commonjsGlobal.__importDefault || function(mod) {
      return mod && mod.__esModule ? mod : {default: mod};
    };
    exports2.__esModule = true;
    exports2.Components = void 0;
    var resource_1 = __importDefault(resource);
    var Components = function(_super) {
      __extends2(Components2, _super);
      function Components2(client2) {
        var _this = _super.call(this, client2, {
          path: "/admin/realms/{realm}/components",
          getUrlParams: function() {
            return {
              realm: client2.realmName
            };
          },
          getBaseUrl: function() {
            return client2.baseUrl;
          }
        }) || this;
        _this.find = _this.makeRequest({
          method: "GET"
        });
        _this.create = _this.makeRequest({
          method: "POST",
          returnResourceIdInLocationHeader: {field: "id"}
        });
        _this.findOne = _this.makeRequest({
          method: "GET",
          path: "/{id}",
          urlParamKeys: ["id"],
          catchNotFound: true
        });
        _this.update = _this.makeUpdateRequest({
          method: "PUT",
          path: "/{id}",
          urlParamKeys: ["id"]
        });
        _this.del = _this.makeRequest({
          method: "DELETE",
          path: "/{id}",
          urlParamKeys: ["id"]
        });
        _this.listSubComponents = _this.makeRequest({
          method: "GET",
          path: "/{id}/sub-component-types",
          urlParamKeys: ["id"],
          queryParamKeys: ["type"]
        });
        return _this;
      }
      return Components2;
    }(resource_1["default"]);
    exports2.Components = Components;
  });
  var authenticationManagement = createCommonjsModule(function(module2, exports2) {
    var __extends2 = commonjsGlobal && commonjsGlobal.__extends || function() {
      var extendStatics = function(d2, b2) {
        extendStatics = Object.setPrototypeOf || {__proto__: []} instanceof Array && function(d3, b3) {
          d3.__proto__ = b3;
        } || function(d3, b3) {
          for (var p2 in b3)
            if (Object.prototype.hasOwnProperty.call(b3, p2))
              d3[p2] = b3[p2];
        };
        return extendStatics(d2, b2);
      };
      return function(d2, b2) {
        if (typeof b2 !== "function" && b2 !== null)
          throw new TypeError("Class extends value " + String(b2) + " is not a constructor or null");
        extendStatics(d2, b2);
        function __() {
          this.constructor = d2;
        }
        d2.prototype = b2 === null ? Object.create(b2) : (__.prototype = b2.prototype, new __());
      };
    }();
    var __importDefault = commonjsGlobal && commonjsGlobal.__importDefault || function(mod) {
      return mod && mod.__esModule ? mod : {default: mod};
    };
    exports2.__esModule = true;
    exports2.AuthenticationManagement = void 0;
    var resource_1 = __importDefault(resource);
    var AuthenticationManagement = function(_super) {
      __extends2(AuthenticationManagement2, _super);
      function AuthenticationManagement2(client2) {
        var _this = _super.call(this, client2, {
          path: "/admin/realms/{realm}/authentication",
          getUrlParams: function() {
            return {
              realm: client2.realmName
            };
          },
          getBaseUrl: function() {
            return client2.baseUrl;
          }
        }) || this;
        _this.registerRequiredAction = _this.makeRequest({
          method: "POST",
          path: "/register-required-action"
        });
        _this.getRequiredActions = _this.makeRequest({
          method: "GET",
          path: "/required-actions"
        });
        _this.getRequiredActionForAlias = _this.makeRequest({
          method: "GET",
          path: "/required-actions/{alias}",
          urlParamKeys: ["alias"],
          catchNotFound: true
        });
        _this.getClientAuthenticatorProviders = _this.makeRequest({
          method: "GET",
          path: "/client-authenticator-providers"
        });
        _this.getAuthenticatorProviders = _this.makeRequest({
          method: "GET",
          path: "/authenticator-providers"
        });
        _this.getFormActionProviders = _this.makeRequest({
          method: "GET",
          path: "/form-action-providers"
        });
        _this.updateRequiredAction = _this.makeUpdateRequest({
          method: "PUT",
          path: "/required-actions/{alias}",
          urlParamKeys: ["alias"]
        });
        _this.deleteRequiredAction = _this.makeRequest({
          method: "DELETE",
          path: "/required-actions/{alias}",
          urlParamKeys: ["alias"]
        });
        _this.lowerRequiredActionPriority = _this.makeRequest({
          method: "POST",
          path: "/required-actions/{alias}/lower-priority",
          urlParamKeys: ["alias"]
        });
        _this.raiseRequiredActionPriority = _this.makeRequest({
          method: "POST",
          path: "/required-actions/{alias}/raise-priority",
          urlParamKeys: ["alias"]
        });
        _this.getUnregisteredRequiredActions = _this.makeRequest({
          method: "GET",
          path: "/unregistered-required-actions"
        });
        _this.getFlows = _this.makeRequest({
          method: "GET",
          path: "/flows"
        });
        _this.getFlow = _this.makeRequest({
          method: "GET",
          path: "/flows/{flowId}",
          urlParamKeys: ["flowId"]
        });
        _this.getFormProviders = _this.makeRequest({
          method: "GET",
          path: "/form-providers"
        });
        _this.createFlow = _this.makeRequest({
          method: "POST",
          path: "/flows",
          returnResourceIdInLocationHeader: {field: "id"}
        });
        _this.copyFlow = _this.makeRequest({
          method: "POST",
          path: "/flows/{flow}/copy",
          urlParamKeys: ["flow"]
        });
        _this.deleteFlow = _this.makeRequest({
          method: "DELETE",
          path: "/flows/{flowId}",
          urlParamKeys: ["flowId"]
        });
        _this.updateFlow = _this.makeUpdateRequest({
          method: "PUT",
          path: "/flows/{flowId}",
          urlParamKeys: ["flowId"]
        });
        _this.getExecutions = _this.makeRequest({
          method: "GET",
          path: "/flows/{flow}/executions",
          urlParamKeys: ["flow"]
        });
        _this.addExecution = _this.makeUpdateRequest({
          method: "POST",
          path: "/flows/{flow}/executions",
          urlParamKeys: ["flow"]
        });
        _this.addExecutionToFlow = _this.makeRequest({
          method: "POST",
          path: "/flows/{flow}/executions/execution",
          urlParamKeys: ["flow"],
          returnResourceIdInLocationHeader: {field: "id"}
        });
        _this.addFlowToFlow = _this.makeRequest({
          method: "POST",
          path: "/flows/{flow}/executions/flow",
          urlParamKeys: ["flow"],
          returnResourceIdInLocationHeader: {field: "id"}
        });
        _this.updateExecution = _this.makeUpdateRequest({
          method: "PUT",
          path: "/flows/{flow}/executions",
          urlParamKeys: ["flow"]
        });
        _this.delExecution = _this.makeRequest({
          method: "DELETE",
          path: "/executions/{id}",
          urlParamKeys: ["id"]
        });
        _this.lowerPriorityExecution = _this.makeRequest({
          method: "POST",
          path: "/executions/{id}/lower-priority",
          urlParamKeys: ["id"]
        });
        _this.raisePriorityExecution = _this.makeRequest({
          method: "POST",
          path: "/executions/{id}/raise-priority",
          urlParamKeys: ["id"]
        });
        _this.getConfigDescription = _this.makeRequest({
          method: "GET",
          path: "config-description/{providerId}",
          urlParamKeys: ["providerId"]
        });
        _this.createConfig = _this.makeRequest({
          method: "POST",
          path: "/executions/{id}/config",
          urlParamKeys: ["id"],
          returnResourceIdInLocationHeader: {field: "id"}
        });
        _this.updateConfig = _this.makeRequest({
          method: "PUT",
          path: "/config/{id}",
          urlParamKeys: ["id"]
        });
        _this.getConfig = _this.makeRequest({
          method: "GET",
          path: "/config/{id}",
          urlParamKeys: ["id"]
        });
        _this.delConfig = _this.makeRequest({
          method: "DELETE",
          path: "/config/{id}",
          urlParamKeys: ["id"]
        });
        return _this;
      }
      return AuthenticationManagement2;
    }(resource_1["default"]);
    exports2.AuthenticationManagement = AuthenticationManagement;
  });
  var serverInfo = createCommonjsModule(function(module2, exports2) {
    var __extends2 = commonjsGlobal && commonjsGlobal.__extends || function() {
      var extendStatics = function(d2, b2) {
        extendStatics = Object.setPrototypeOf || {__proto__: []} instanceof Array && function(d3, b3) {
          d3.__proto__ = b3;
        } || function(d3, b3) {
          for (var p2 in b3)
            if (Object.prototype.hasOwnProperty.call(b3, p2))
              d3[p2] = b3[p2];
        };
        return extendStatics(d2, b2);
      };
      return function(d2, b2) {
        if (typeof b2 !== "function" && b2 !== null)
          throw new TypeError("Class extends value " + String(b2) + " is not a constructor or null");
        extendStatics(d2, b2);
        function __() {
          this.constructor = d2;
        }
        d2.prototype = b2 === null ? Object.create(b2) : (__.prototype = b2.prototype, new __());
      };
    }();
    var __importDefault = commonjsGlobal && commonjsGlobal.__importDefault || function(mod) {
      return mod && mod.__esModule ? mod : {default: mod};
    };
    exports2.__esModule = true;
    exports2.ServerInfo = void 0;
    var resource_1 = __importDefault(resource);
    var ServerInfo = function(_super) {
      __extends2(ServerInfo2, _super);
      function ServerInfo2(client2) {
        var _this = _super.call(this, client2, {
          path: "/admin/serverinfo",
          getBaseUrl: function() {
            return client2.baseUrl;
          }
        }) || this;
        _this.find = _this.makeRequest({
          method: "GET",
          path: "/"
        });
        return _this;
      }
      return ServerInfo2;
    }(resource_1["default"]);
    exports2.ServerInfo = ServerInfo;
  });
  var whoAmI = createCommonjsModule(function(module2, exports2) {
    var __extends2 = commonjsGlobal && commonjsGlobal.__extends || function() {
      var extendStatics = function(d2, b2) {
        extendStatics = Object.setPrototypeOf || {__proto__: []} instanceof Array && function(d3, b3) {
          d3.__proto__ = b3;
        } || function(d3, b3) {
          for (var p2 in b3)
            if (Object.prototype.hasOwnProperty.call(b3, p2))
              d3[p2] = b3[p2];
        };
        return extendStatics(d2, b2);
      };
      return function(d2, b2) {
        if (typeof b2 !== "function" && b2 !== null)
          throw new TypeError("Class extends value " + String(b2) + " is not a constructor or null");
        extendStatics(d2, b2);
        function __() {
          this.constructor = d2;
        }
        d2.prototype = b2 === null ? Object.create(b2) : (__.prototype = b2.prototype, new __());
      };
    }();
    var __importDefault = commonjsGlobal && commonjsGlobal.__importDefault || function(mod) {
      return mod && mod.__esModule ? mod : {default: mod};
    };
    exports2.__esModule = true;
    exports2.WhoAmI = void 0;
    var resource_1 = __importDefault(resource);
    var WhoAmI2 = function(_super) {
      __extends2(WhoAmI3, _super);
      function WhoAmI3(client2) {
        var _this = _super.call(this, client2, {
          path: "/admin/{realm}/console",
          getUrlParams: function() {
            return {
              realm: client2.realmName
            };
          },
          getBaseUrl: function() {
            return client2.baseUrl;
          }
        }) || this;
        _this.find = _this.makeRequest({
          method: "GET",
          path: "/whoami"
        });
        return _this;
      }
      return WhoAmI3;
    }(resource_1["default"]);
    exports2.WhoAmI = WhoAmI2;
  });
  var attackDetection = createCommonjsModule(function(module2, exports2) {
    var __extends2 = commonjsGlobal && commonjsGlobal.__extends || function() {
      var extendStatics = function(d2, b2) {
        extendStatics = Object.setPrototypeOf || {__proto__: []} instanceof Array && function(d3, b3) {
          d3.__proto__ = b3;
        } || function(d3, b3) {
          for (var p2 in b3)
            if (Object.prototype.hasOwnProperty.call(b3, p2))
              d3[p2] = b3[p2];
        };
        return extendStatics(d2, b2);
      };
      return function(d2, b2) {
        if (typeof b2 !== "function" && b2 !== null)
          throw new TypeError("Class extends value " + String(b2) + " is not a constructor or null");
        extendStatics(d2, b2);
        function __() {
          this.constructor = d2;
        }
        d2.prototype = b2 === null ? Object.create(b2) : (__.prototype = b2.prototype, new __());
      };
    }();
    var __importDefault = commonjsGlobal && commonjsGlobal.__importDefault || function(mod) {
      return mod && mod.__esModule ? mod : {default: mod};
    };
    exports2.__esModule = true;
    exports2.AttackDetection = void 0;
    var resource_1 = __importDefault(resource);
    var AttackDetection = function(_super) {
      __extends2(AttackDetection2, _super);
      function AttackDetection2(client2) {
        var _this = _super.call(this, client2, {
          path: "/admin/realms/{realm}/attack-detection/brute-force",
          getUrlParams: function() {
            return {
              realm: client2.realmName
            };
          },
          getBaseUrl: function() {
            return client2.baseUrl;
          }
        }) || this;
        _this.findOne = _this.makeRequest({
          method: "GET",
          path: "/users/{id}",
          urlParamKeys: ["id"],
          catchNotFound: true
        });
        _this.del = _this.makeRequest({
          method: "DELETE",
          path: "/users/{id}",
          urlParamKeys: ["id"]
        });
        _this.delAll = _this.makeRequest({
          method: "DELETE",
          path: "/users"
        });
        return _this;
      }
      return AttackDetection2;
    }(resource_1["default"]);
    exports2.AttackDetection = AttackDetection;
  });
  var sessions = createCommonjsModule(function(module2, exports2) {
    var __extends2 = commonjsGlobal && commonjsGlobal.__extends || function() {
      var extendStatics = function(d2, b2) {
        extendStatics = Object.setPrototypeOf || {__proto__: []} instanceof Array && function(d3, b3) {
          d3.__proto__ = b3;
        } || function(d3, b3) {
          for (var p2 in b3)
            if (Object.prototype.hasOwnProperty.call(b3, p2))
              d3[p2] = b3[p2];
        };
        return extendStatics(d2, b2);
      };
      return function(d2, b2) {
        if (typeof b2 !== "function" && b2 !== null)
          throw new TypeError("Class extends value " + String(b2) + " is not a constructor or null");
        extendStatics(d2, b2);
        function __() {
          this.constructor = d2;
        }
        d2.prototype = b2 === null ? Object.create(b2) : (__.prototype = b2.prototype, new __());
      };
    }();
    var __importDefault = commonjsGlobal && commonjsGlobal.__importDefault || function(mod) {
      return mod && mod.__esModule ? mod : {default: mod};
    };
    exports2.__esModule = true;
    exports2.Sessions = void 0;
    var resource_1 = __importDefault(resource);
    var Sessions = function(_super) {
      __extends2(Sessions2, _super);
      function Sessions2(client2) {
        var _this = _super.call(this, client2, {
          path: "/admin/realms/{realm}/client-session-stats",
          getUrlParams: function() {
            return {
              realm: client2.realmName
            };
          },
          getBaseUrl: function() {
            return client2.baseUrl;
          }
        }) || this;
        _this.find = _this.makeRequest({
          method: "GET"
        });
        return _this;
      }
      return Sessions2;
    }(resource_1["default"]);
    exports2.Sessions = Sessions;
  });
  var userStorageProvider = createCommonjsModule(function(module2, exports2) {
    var __extends2 = commonjsGlobal && commonjsGlobal.__extends || function() {
      var extendStatics = function(d2, b2) {
        extendStatics = Object.setPrototypeOf || {__proto__: []} instanceof Array && function(d3, b3) {
          d3.__proto__ = b3;
        } || function(d3, b3) {
          for (var p2 in b3)
            if (Object.prototype.hasOwnProperty.call(b3, p2))
              d3[p2] = b3[p2];
        };
        return extendStatics(d2, b2);
      };
      return function(d2, b2) {
        if (typeof b2 !== "function" && b2 !== null)
          throw new TypeError("Class extends value " + String(b2) + " is not a constructor or null");
        extendStatics(d2, b2);
        function __() {
          this.constructor = d2;
        }
        d2.prototype = b2 === null ? Object.create(b2) : (__.prototype = b2.prototype, new __());
      };
    }();
    var __importDefault = commonjsGlobal && commonjsGlobal.__importDefault || function(mod) {
      return mod && mod.__esModule ? mod : {default: mod};
    };
    exports2.__esModule = true;
    exports2.UserStorageProvider = void 0;
    var resource_1 = __importDefault(resource);
    var UserStorageProvider = function(_super) {
      __extends2(UserStorageProvider2, _super);
      function UserStorageProvider2(client2) {
        var _this = _super.call(this, client2, {
          path: "/admin/realms/{realm}/user-storage",
          getUrlParams: function() {
            return {
              realm: client2.realmName
            };
          },
          getBaseUrl: function() {
            return client2.baseUrl;
          }
        }) || this;
        _this.name = _this.makeRequest({
          method: "GET",
          path: "/{id}/name",
          urlParamKeys: ["id"]
        });
        _this.removeImportedUsers = _this.makeRequest({
          method: "POST",
          path: "/{id}/remove-imported-users",
          urlParamKeys: ["id"]
        });
        _this.sync = _this.makeRequest({
          method: "POST",
          path: "/{id}/sync",
          urlParamKeys: ["id"],
          queryParamKeys: ["action"]
        });
        _this.unlinkUsers = _this.makeRequest({
          method: "POST",
          path: "/{id}/unlink-users",
          urlParamKeys: ["id"]
        });
        _this.mappersSync = _this.makeRequest({
          method: "POST",
          path: "/{parentId}/mappers/{id}/sync",
          urlParamKeys: ["id", "parentId"],
          queryParamKeys: ["direction"]
        });
        return _this;
      }
      return UserStorageProvider2;
    }(resource_1["default"]);
    exports2.UserStorageProvider = UserStorageProvider;
  });
  var sha256 = createCommonjsModule(function(module) {
    /**
     * [js-sha256]{@link https://github.com/emn178/js-sha256}
     *
     * @version 0.9.0
     * @author Chen, Yi-Cyuan [emn178@gmail.com]
     * @copyright Chen, Yi-Cyuan 2014-2017
     * @license MIT
     */
    (function() {
      var ERROR = "input is invalid type";
      var WINDOW = typeof window === "object";
      var root = WINDOW ? window : {};
      if (root.JS_SHA256_NO_WINDOW) {
        WINDOW = false;
      }
      var WEB_WORKER = !WINDOW && typeof self === "object";
      var NODE_JS = !root.JS_SHA256_NO_NODE_JS && typeof process === "object" && process.versions && process.versions.node;
      if (NODE_JS) {
        root = commonjsGlobal;
      } else if (WEB_WORKER) {
        root = self;
      }
      var COMMON_JS = !root.JS_SHA256_NO_COMMON_JS && true && module.exports;
      var ARRAY_BUFFER = !root.JS_SHA256_NO_ARRAY_BUFFER && typeof ArrayBuffer !== "undefined";
      var HEX_CHARS = "0123456789abcdef".split("");
      var EXTRA = [-2147483648, 8388608, 32768, 128];
      var SHIFT = [24, 16, 8, 0];
      var K = [
        1116352408,
        1899447441,
        3049323471,
        3921009573,
        961987163,
        1508970993,
        2453635748,
        2870763221,
        3624381080,
        310598401,
        607225278,
        1426881987,
        1925078388,
        2162078206,
        2614888103,
        3248222580,
        3835390401,
        4022224774,
        264347078,
        604807628,
        770255983,
        1249150122,
        1555081692,
        1996064986,
        2554220882,
        2821834349,
        2952996808,
        3210313671,
        3336571891,
        3584528711,
        113926993,
        338241895,
        666307205,
        773529912,
        1294757372,
        1396182291,
        1695183700,
        1986661051,
        2177026350,
        2456956037,
        2730485921,
        2820302411,
        3259730800,
        3345764771,
        3516065817,
        3600352804,
        4094571909,
        275423344,
        430227734,
        506948616,
        659060556,
        883997877,
        958139571,
        1322822218,
        1537002063,
        1747873779,
        1955562222,
        2024104815,
        2227730452,
        2361852424,
        2428436474,
        2756734187,
        3204031479,
        3329325298
      ];
      var OUTPUT_TYPES = ["hex", "array", "digest", "arrayBuffer"];
      var blocks = [];
      if (root.JS_SHA256_NO_NODE_JS || !Array.isArray) {
        Array.isArray = function(obj) {
          return Object.prototype.toString.call(obj) === "[object Array]";
        };
      }
      if (ARRAY_BUFFER && (root.JS_SHA256_NO_ARRAY_BUFFER_IS_VIEW || !ArrayBuffer.isView)) {
        ArrayBuffer.isView = function(obj) {
          return typeof obj === "object" && obj.buffer && obj.buffer.constructor === ArrayBuffer;
        };
      }
      var createOutputMethod = function(outputType, is224) {
        return function(message) {
          return new Sha256(is224, true).update(message)[outputType]();
        };
      };
      var createMethod = function(is224) {
        var method = createOutputMethod("hex", is224);
        if (NODE_JS) {
          method = nodeWrap(method, is224);
        }
        method.create = function() {
          return new Sha256(is224);
        };
        method.update = function(message) {
          return method.create().update(message);
        };
        for (var i3 = 0; i3 < OUTPUT_TYPES.length; ++i3) {
          var type = OUTPUT_TYPES[i3];
          method[type] = createOutputMethod(type, is224);
        }
        return method;
      };
      var nodeWrap = function(method, is224) {
        var crypto = eval("require('crypto')");
        var Buffer = eval("require('buffer').Buffer");
        var algorithm = is224 ? "sha224" : "sha256";
        var nodeMethod = function(message) {
          if (typeof message === "string") {
            return crypto.createHash(algorithm).update(message, "utf8").digest("hex");
          } else {
            if (message === null || message === void 0) {
              throw new Error(ERROR);
            } else if (message.constructor === ArrayBuffer) {
              message = new Uint8Array(message);
            }
          }
          if (Array.isArray(message) || ArrayBuffer.isView(message) || message.constructor === Buffer) {
            return crypto.createHash(algorithm).update(new Buffer(message)).digest("hex");
          } else {
            return method(message);
          }
        };
        return nodeMethod;
      };
      var createHmacOutputMethod = function(outputType, is224) {
        return function(key, message) {
          return new HmacSha256(key, is224, true).update(message)[outputType]();
        };
      };
      var createHmacMethod = function(is224) {
        var method = createHmacOutputMethod("hex", is224);
        method.create = function(key) {
          return new HmacSha256(key, is224);
        };
        method.update = function(key, message) {
          return method.create(key).update(message);
        };
        for (var i3 = 0; i3 < OUTPUT_TYPES.length; ++i3) {
          var type = OUTPUT_TYPES[i3];
          method[type] = createHmacOutputMethod(type, is224);
        }
        return method;
      };
      function Sha256(is224, sharedMemory) {
        if (sharedMemory) {
          blocks[0] = blocks[16] = blocks[1] = blocks[2] = blocks[3] = blocks[4] = blocks[5] = blocks[6] = blocks[7] = blocks[8] = blocks[9] = blocks[10] = blocks[11] = blocks[12] = blocks[13] = blocks[14] = blocks[15] = 0;
          this.blocks = blocks;
        } else {
          this.blocks = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0];
        }
        if (is224) {
          this.h0 = 3238371032;
          this.h1 = 914150663;
          this.h2 = 812702999;
          this.h3 = 4144912697;
          this.h4 = 4290775857;
          this.h5 = 1750603025;
          this.h6 = 1694076839;
          this.h7 = 3204075428;
        } else {
          this.h0 = 1779033703;
          this.h1 = 3144134277;
          this.h2 = 1013904242;
          this.h3 = 2773480762;
          this.h4 = 1359893119;
          this.h5 = 2600822924;
          this.h6 = 528734635;
          this.h7 = 1541459225;
        }
        this.block = this.start = this.bytes = this.hBytes = 0;
        this.finalized = this.hashed = false;
        this.first = true;
        this.is224 = is224;
      }
      Sha256.prototype.update = function(message) {
        if (this.finalized) {
          return;
        }
        var notString, type = typeof message;
        if (type !== "string") {
          if (type === "object") {
            if (message === null) {
              throw new Error(ERROR);
            } else if (ARRAY_BUFFER && message.constructor === ArrayBuffer) {
              message = new Uint8Array(message);
            } else if (!Array.isArray(message)) {
              if (!ARRAY_BUFFER || !ArrayBuffer.isView(message)) {
                throw new Error(ERROR);
              }
            }
          } else {
            throw new Error(ERROR);
          }
          notString = true;
        }
        var code2, index3 = 0, i3, length = message.length, blocks = this.blocks;
        while (index3 < length) {
          if (this.hashed) {
            this.hashed = false;
            blocks[0] = this.block;
            blocks[16] = blocks[1] = blocks[2] = blocks[3] = blocks[4] = blocks[5] = blocks[6] = blocks[7] = blocks[8] = blocks[9] = blocks[10] = blocks[11] = blocks[12] = blocks[13] = blocks[14] = blocks[15] = 0;
          }
          if (notString) {
            for (i3 = this.start; index3 < length && i3 < 64; ++index3) {
              blocks[i3 >> 2] |= message[index3] << SHIFT[i3++ & 3];
            }
          } else {
            for (i3 = this.start; index3 < length && i3 < 64; ++index3) {
              code2 = message.charCodeAt(index3);
              if (code2 < 128) {
                blocks[i3 >> 2] |= code2 << SHIFT[i3++ & 3];
              } else if (code2 < 2048) {
                blocks[i3 >> 2] |= (192 | code2 >> 6) << SHIFT[i3++ & 3];
                blocks[i3 >> 2] |= (128 | code2 & 63) << SHIFT[i3++ & 3];
              } else if (code2 < 55296 || code2 >= 57344) {
                blocks[i3 >> 2] |= (224 | code2 >> 12) << SHIFT[i3++ & 3];
                blocks[i3 >> 2] |= (128 | code2 >> 6 & 63) << SHIFT[i3++ & 3];
                blocks[i3 >> 2] |= (128 | code2 & 63) << SHIFT[i3++ & 3];
              } else {
                code2 = 65536 + ((code2 & 1023) << 10 | message.charCodeAt(++index3) & 1023);
                blocks[i3 >> 2] |= (240 | code2 >> 18) << SHIFT[i3++ & 3];
                blocks[i3 >> 2] |= (128 | code2 >> 12 & 63) << SHIFT[i3++ & 3];
                blocks[i3 >> 2] |= (128 | code2 >> 6 & 63) << SHIFT[i3++ & 3];
                blocks[i3 >> 2] |= (128 | code2 & 63) << SHIFT[i3++ & 3];
              }
            }
          }
          this.lastByteIndex = i3;
          this.bytes += i3 - this.start;
          if (i3 >= 64) {
            this.block = blocks[16];
            this.start = i3 - 64;
            this.hash();
            this.hashed = true;
          } else {
            this.start = i3;
          }
        }
        if (this.bytes > 4294967295) {
          this.hBytes += this.bytes / 4294967296 << 0;
          this.bytes = this.bytes % 4294967296;
        }
        return this;
      };
      Sha256.prototype.finalize = function() {
        if (this.finalized) {
          return;
        }
        this.finalized = true;
        var blocks = this.blocks, i3 = this.lastByteIndex;
        blocks[16] = this.block;
        blocks[i3 >> 2] |= EXTRA[i3 & 3];
        this.block = blocks[16];
        if (i3 >= 56) {
          if (!this.hashed) {
            this.hash();
          }
          blocks[0] = this.block;
          blocks[16] = blocks[1] = blocks[2] = blocks[3] = blocks[4] = blocks[5] = blocks[6] = blocks[7] = blocks[8] = blocks[9] = blocks[10] = blocks[11] = blocks[12] = blocks[13] = blocks[14] = blocks[15] = 0;
        }
        blocks[14] = this.hBytes << 3 | this.bytes >>> 29;
        blocks[15] = this.bytes << 3;
        this.hash();
      };
      Sha256.prototype.hash = function() {
        var a2 = this.h0, b2 = this.h1, c3 = this.h2, d2 = this.h3, e2 = this.h4, f2 = this.h5, g2 = this.h6, h2 = this.h7, blocks = this.blocks, j, s0, s1, maj, t1, t22, ch2, ab2, da2, cd2, bc2;
        for (j = 16; j < 64; ++j) {
          t1 = blocks[j - 15];
          s0 = (t1 >>> 7 | t1 << 25) ^ (t1 >>> 18 | t1 << 14) ^ t1 >>> 3;
          t1 = blocks[j - 2];
          s1 = (t1 >>> 17 | t1 << 15) ^ (t1 >>> 19 | t1 << 13) ^ t1 >>> 10;
          blocks[j] = blocks[j - 16] + s0 + blocks[j - 7] + s1 << 0;
        }
        bc2 = b2 & c3;
        for (j = 0; j < 64; j += 4) {
          if (this.first) {
            if (this.is224) {
              ab2 = 300032;
              t1 = blocks[0] - 1413257819;
              h2 = t1 - 150054599 << 0;
              d2 = t1 + 24177077 << 0;
            } else {
              ab2 = 704751109;
              t1 = blocks[0] - 210244248;
              h2 = t1 - 1521486534 << 0;
              d2 = t1 + 143694565 << 0;
            }
            this.first = false;
          } else {
            s0 = (a2 >>> 2 | a2 << 30) ^ (a2 >>> 13 | a2 << 19) ^ (a2 >>> 22 | a2 << 10);
            s1 = (e2 >>> 6 | e2 << 26) ^ (e2 >>> 11 | e2 << 21) ^ (e2 >>> 25 | e2 << 7);
            ab2 = a2 & b2;
            maj = ab2 ^ a2 & c3 ^ bc2;
            ch2 = e2 & f2 ^ ~e2 & g2;
            t1 = h2 + s1 + ch2 + K[j] + blocks[j];
            t22 = s0 + maj;
            h2 = d2 + t1 << 0;
            d2 = t1 + t22 << 0;
          }
          s0 = (d2 >>> 2 | d2 << 30) ^ (d2 >>> 13 | d2 << 19) ^ (d2 >>> 22 | d2 << 10);
          s1 = (h2 >>> 6 | h2 << 26) ^ (h2 >>> 11 | h2 << 21) ^ (h2 >>> 25 | h2 << 7);
          da2 = d2 & a2;
          maj = da2 ^ d2 & b2 ^ ab2;
          ch2 = h2 & e2 ^ ~h2 & f2;
          t1 = g2 + s1 + ch2 + K[j + 1] + blocks[j + 1];
          t22 = s0 + maj;
          g2 = c3 + t1 << 0;
          c3 = t1 + t22 << 0;
          s0 = (c3 >>> 2 | c3 << 30) ^ (c3 >>> 13 | c3 << 19) ^ (c3 >>> 22 | c3 << 10);
          s1 = (g2 >>> 6 | g2 << 26) ^ (g2 >>> 11 | g2 << 21) ^ (g2 >>> 25 | g2 << 7);
          cd2 = c3 & d2;
          maj = cd2 ^ c3 & a2 ^ da2;
          ch2 = g2 & h2 ^ ~g2 & e2;
          t1 = f2 + s1 + ch2 + K[j + 2] + blocks[j + 2];
          t22 = s0 + maj;
          f2 = b2 + t1 << 0;
          b2 = t1 + t22 << 0;
          s0 = (b2 >>> 2 | b2 << 30) ^ (b2 >>> 13 | b2 << 19) ^ (b2 >>> 22 | b2 << 10);
          s1 = (f2 >>> 6 | f2 << 26) ^ (f2 >>> 11 | f2 << 21) ^ (f2 >>> 25 | f2 << 7);
          bc2 = b2 & c3;
          maj = bc2 ^ b2 & d2 ^ cd2;
          ch2 = f2 & g2 ^ ~f2 & h2;
          t1 = e2 + s1 + ch2 + K[j + 3] + blocks[j + 3];
          t22 = s0 + maj;
          e2 = a2 + t1 << 0;
          a2 = t1 + t22 << 0;
        }
        this.h0 = this.h0 + a2 << 0;
        this.h1 = this.h1 + b2 << 0;
        this.h2 = this.h2 + c3 << 0;
        this.h3 = this.h3 + d2 << 0;
        this.h4 = this.h4 + e2 << 0;
        this.h5 = this.h5 + f2 << 0;
        this.h6 = this.h6 + g2 << 0;
        this.h7 = this.h7 + h2 << 0;
      };
      Sha256.prototype.hex = function() {
        this.finalize();
        var h0 = this.h0, h1 = this.h1, h2 = this.h2, h3 = this.h3, h4 = this.h4, h5 = this.h5, h6 = this.h6, h7 = this.h7;
        var hex2 = HEX_CHARS[h0 >> 28 & 15] + HEX_CHARS[h0 >> 24 & 15] + HEX_CHARS[h0 >> 20 & 15] + HEX_CHARS[h0 >> 16 & 15] + HEX_CHARS[h0 >> 12 & 15] + HEX_CHARS[h0 >> 8 & 15] + HEX_CHARS[h0 >> 4 & 15] + HEX_CHARS[h0 & 15] + HEX_CHARS[h1 >> 28 & 15] + HEX_CHARS[h1 >> 24 & 15] + HEX_CHARS[h1 >> 20 & 15] + HEX_CHARS[h1 >> 16 & 15] + HEX_CHARS[h1 >> 12 & 15] + HEX_CHARS[h1 >> 8 & 15] + HEX_CHARS[h1 >> 4 & 15] + HEX_CHARS[h1 & 15] + HEX_CHARS[h2 >> 28 & 15] + HEX_CHARS[h2 >> 24 & 15] + HEX_CHARS[h2 >> 20 & 15] + HEX_CHARS[h2 >> 16 & 15] + HEX_CHARS[h2 >> 12 & 15] + HEX_CHARS[h2 >> 8 & 15] + HEX_CHARS[h2 >> 4 & 15] + HEX_CHARS[h2 & 15] + HEX_CHARS[h3 >> 28 & 15] + HEX_CHARS[h3 >> 24 & 15] + HEX_CHARS[h3 >> 20 & 15] + HEX_CHARS[h3 >> 16 & 15] + HEX_CHARS[h3 >> 12 & 15] + HEX_CHARS[h3 >> 8 & 15] + HEX_CHARS[h3 >> 4 & 15] + HEX_CHARS[h3 & 15] + HEX_CHARS[h4 >> 28 & 15] + HEX_CHARS[h4 >> 24 & 15] + HEX_CHARS[h4 >> 20 & 15] + HEX_CHARS[h4 >> 16 & 15] + HEX_CHARS[h4 >> 12 & 15] + HEX_CHARS[h4 >> 8 & 15] + HEX_CHARS[h4 >> 4 & 15] + HEX_CHARS[h4 & 15] + HEX_CHARS[h5 >> 28 & 15] + HEX_CHARS[h5 >> 24 & 15] + HEX_CHARS[h5 >> 20 & 15] + HEX_CHARS[h5 >> 16 & 15] + HEX_CHARS[h5 >> 12 & 15] + HEX_CHARS[h5 >> 8 & 15] + HEX_CHARS[h5 >> 4 & 15] + HEX_CHARS[h5 & 15] + HEX_CHARS[h6 >> 28 & 15] + HEX_CHARS[h6 >> 24 & 15] + HEX_CHARS[h6 >> 20 & 15] + HEX_CHARS[h6 >> 16 & 15] + HEX_CHARS[h6 >> 12 & 15] + HEX_CHARS[h6 >> 8 & 15] + HEX_CHARS[h6 >> 4 & 15] + HEX_CHARS[h6 & 15];
        if (!this.is224) {
          hex2 += HEX_CHARS[h7 >> 28 & 15] + HEX_CHARS[h7 >> 24 & 15] + HEX_CHARS[h7 >> 20 & 15] + HEX_CHARS[h7 >> 16 & 15] + HEX_CHARS[h7 >> 12 & 15] + HEX_CHARS[h7 >> 8 & 15] + HEX_CHARS[h7 >> 4 & 15] + HEX_CHARS[h7 & 15];
        }
        return hex2;
      };
      Sha256.prototype.toString = Sha256.prototype.hex;
      Sha256.prototype.digest = function() {
        this.finalize();
        var h0 = this.h0, h1 = this.h1, h2 = this.h2, h3 = this.h3, h4 = this.h4, h5 = this.h5, h6 = this.h6, h7 = this.h7;
        var arr = [
          h0 >> 24 & 255,
          h0 >> 16 & 255,
          h0 >> 8 & 255,
          h0 & 255,
          h1 >> 24 & 255,
          h1 >> 16 & 255,
          h1 >> 8 & 255,
          h1 & 255,
          h2 >> 24 & 255,
          h2 >> 16 & 255,
          h2 >> 8 & 255,
          h2 & 255,
          h3 >> 24 & 255,
          h3 >> 16 & 255,
          h3 >> 8 & 255,
          h3 & 255,
          h4 >> 24 & 255,
          h4 >> 16 & 255,
          h4 >> 8 & 255,
          h4 & 255,
          h5 >> 24 & 255,
          h5 >> 16 & 255,
          h5 >> 8 & 255,
          h5 & 255,
          h6 >> 24 & 255,
          h6 >> 16 & 255,
          h6 >> 8 & 255,
          h6 & 255
        ];
        if (!this.is224) {
          arr.push(h7 >> 24 & 255, h7 >> 16 & 255, h7 >> 8 & 255, h7 & 255);
        }
        return arr;
      };
      Sha256.prototype.array = Sha256.prototype.digest;
      Sha256.prototype.arrayBuffer = function() {
        this.finalize();
        var buffer = new ArrayBuffer(this.is224 ? 28 : 32);
        var dataView = new DataView(buffer);
        dataView.setUint32(0, this.h0);
        dataView.setUint32(4, this.h1);
        dataView.setUint32(8, this.h2);
        dataView.setUint32(12, this.h3);
        dataView.setUint32(16, this.h4);
        dataView.setUint32(20, this.h5);
        dataView.setUint32(24, this.h6);
        if (!this.is224) {
          dataView.setUint32(28, this.h7);
        }
        return buffer;
      };
      function HmacSha256(key, is224, sharedMemory) {
        var i3, type = typeof key;
        if (type === "string") {
          var bytes = [], length = key.length, index3 = 0, code2;
          for (i3 = 0; i3 < length; ++i3) {
            code2 = key.charCodeAt(i3);
            if (code2 < 128) {
              bytes[index3++] = code2;
            } else if (code2 < 2048) {
              bytes[index3++] = 192 | code2 >> 6;
              bytes[index3++] = 128 | code2 & 63;
            } else if (code2 < 55296 || code2 >= 57344) {
              bytes[index3++] = 224 | code2 >> 12;
              bytes[index3++] = 128 | code2 >> 6 & 63;
              bytes[index3++] = 128 | code2 & 63;
            } else {
              code2 = 65536 + ((code2 & 1023) << 10 | key.charCodeAt(++i3) & 1023);
              bytes[index3++] = 240 | code2 >> 18;
              bytes[index3++] = 128 | code2 >> 12 & 63;
              bytes[index3++] = 128 | code2 >> 6 & 63;
              bytes[index3++] = 128 | code2 & 63;
            }
          }
          key = bytes;
        } else {
          if (type === "object") {
            if (key === null) {
              throw new Error(ERROR);
            } else if (ARRAY_BUFFER && key.constructor === ArrayBuffer) {
              key = new Uint8Array(key);
            } else if (!Array.isArray(key)) {
              if (!ARRAY_BUFFER || !ArrayBuffer.isView(key)) {
                throw new Error(ERROR);
              }
            }
          } else {
            throw new Error(ERROR);
          }
        }
        if (key.length > 64) {
          key = new Sha256(is224, true).update(key).array();
        }
        var oKeyPad = [], iKeyPad = [];
        for (i3 = 0; i3 < 64; ++i3) {
          var b2 = key[i3] || 0;
          oKeyPad[i3] = 92 ^ b2;
          iKeyPad[i3] = 54 ^ b2;
        }
        Sha256.call(this, is224, sharedMemory);
        this.update(iKeyPad);
        this.oKeyPad = oKeyPad;
        this.inner = true;
        this.sharedMemory = sharedMemory;
      }
      HmacSha256.prototype = new Sha256();
      HmacSha256.prototype.finalize = function() {
        Sha256.prototype.finalize.call(this);
        if (this.inner) {
          this.inner = false;
          var innerHash = this.array();
          Sha256.call(this, this.is224, this.sharedMemory);
          this.update(this.oKeyPad);
          this.update(innerHash);
          Sha256.prototype.finalize.call(this);
        }
      };
      var exports = createMethod();
      exports.sha256 = exports;
      exports.sha224 = createMethod(true);
      exports.sha256.hmac = createHmacMethod();
      exports.sha224.hmac = createHmacMethod(true);
      if (COMMON_JS) {
        module.exports = exports;
      } else {
        root.sha256 = exports.sha256;
        root.sha224 = exports.sha224;
      }
    })();
  });
  var byteLength_1 = byteLength;
  var toByteArray_1 = toByteArray;
  var fromByteArray_1 = fromByteArray;
  var lookup = [];
  var revLookup = [];
  var Arr = typeof Uint8Array !== "undefined" ? Uint8Array : Array;
  var code = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
  for (var i = 0, len = code.length; i < len; ++i) {
    lookup[i] = code[i];
    revLookup[code.charCodeAt(i)] = i;
  }
  revLookup["-".charCodeAt(0)] = 62;
  revLookup["_".charCodeAt(0)] = 63;
  function getLens(b64) {
    var len2 = b64.length;
    if (len2 % 4 > 0) {
      throw new Error("Invalid string. Length must be a multiple of 4");
    }
    var validLen = b64.indexOf("=");
    if (validLen === -1)
      validLen = len2;
    var placeHoldersLen = validLen === len2 ? 0 : 4 - validLen % 4;
    return [validLen, placeHoldersLen];
  }
  function byteLength(b64) {
    var lens = getLens(b64);
    var validLen = lens[0];
    var placeHoldersLen = lens[1];
    return (validLen + placeHoldersLen) * 3 / 4 - placeHoldersLen;
  }
  function _byteLength(b64, validLen, placeHoldersLen) {
    return (validLen + placeHoldersLen) * 3 / 4 - placeHoldersLen;
  }
  function toByteArray(b64) {
    var tmp;
    var lens = getLens(b64);
    var validLen = lens[0];
    var placeHoldersLen = lens[1];
    var arr = new Arr(_byteLength(b64, validLen, placeHoldersLen));
    var curByte = 0;
    var len2 = placeHoldersLen > 0 ? validLen - 4 : validLen;
    var i3;
    for (i3 = 0; i3 < len2; i3 += 4) {
      tmp = revLookup[b64.charCodeAt(i3)] << 18 | revLookup[b64.charCodeAt(i3 + 1)] << 12 | revLookup[b64.charCodeAt(i3 + 2)] << 6 | revLookup[b64.charCodeAt(i3 + 3)];
      arr[curByte++] = tmp >> 16 & 255;
      arr[curByte++] = tmp >> 8 & 255;
      arr[curByte++] = tmp & 255;
    }
    if (placeHoldersLen === 2) {
      tmp = revLookup[b64.charCodeAt(i3)] << 2 | revLookup[b64.charCodeAt(i3 + 1)] >> 4;
      arr[curByte++] = tmp & 255;
    }
    if (placeHoldersLen === 1) {
      tmp = revLookup[b64.charCodeAt(i3)] << 10 | revLookup[b64.charCodeAt(i3 + 1)] << 4 | revLookup[b64.charCodeAt(i3 + 2)] >> 2;
      arr[curByte++] = tmp >> 8 & 255;
      arr[curByte++] = tmp & 255;
    }
    return arr;
  }
  function tripletToBase64(num) {
    return lookup[num >> 18 & 63] + lookup[num >> 12 & 63] + lookup[num >> 6 & 63] + lookup[num & 63];
  }
  function encodeChunk(uint8, start3, end2) {
    var tmp;
    var output2 = [];
    for (var i3 = start3; i3 < end2; i3 += 3) {
      tmp = (uint8[i3] << 16 & 16711680) + (uint8[i3 + 1] << 8 & 65280) + (uint8[i3 + 2] & 255);
      output2.push(tripletToBase64(tmp));
    }
    return output2.join("");
  }
  function fromByteArray(uint8) {
    var tmp;
    var len2 = uint8.length;
    var extraBytes = len2 % 3;
    var parts = [];
    var maxChunkLength = 16383;
    for (var i3 = 0, len22 = len2 - extraBytes; i3 < len22; i3 += maxChunkLength) {
      parts.push(encodeChunk(uint8, i3, i3 + maxChunkLength > len22 ? len22 : i3 + maxChunkLength));
    }
    if (extraBytes === 1) {
      tmp = uint8[len2 - 1];
      parts.push(lookup[tmp >> 2] + lookup[tmp << 4 & 63] + "==");
    } else if (extraBytes === 2) {
      tmp = (uint8[len2 - 2] << 8) + uint8[len2 - 1];
      parts.push(lookup[tmp >> 10] + lookup[tmp >> 4 & 63] + lookup[tmp << 2 & 63] + "=");
    }
    return parts.join("");
  }
  var base64Js = {
    byteLength: byteLength_1,
    toByteArray: toByteArray_1,
    fromByteArray: fromByteArray_1
  };
  var keycloak = createCommonjsModule(function(module2, exports2) {
    (function(root4, factory) {
      {
        {
          module2.exports = factory(sha256, base64Js);
        }
      }
    })(window, function(sha256_imported, base64js_imported) {
      if (typeof Promise === "undefined") {
        throw Error("Keycloak requires an environment that supports Promises. Make sure that you include the appropriate polyfill.");
      }
      var loggedPromiseDeprecation = false;
      function logPromiseDeprecation() {
        if (!loggedPromiseDeprecation) {
          loggedPromiseDeprecation = true;
          console.warn("[KEYCLOAK] Usage of legacy style promise methods such as `.error()` and `.success()` has been deprecated and support will be removed in future versions. Use standard style promise methods such as `.then() and `.catch()` instead.");
        }
      }
      function Keycloak(config2) {
        if (!(this instanceof Keycloak)) {
          return new Keycloak(config2);
        }
        var kc2 = this;
        var adapter;
        var refreshQueue = [];
        var callbackStorage;
        var loginIframe = {
          enable: true,
          callbackList: [],
          interval: 5
        };
        var scripts = document.getElementsByTagName("script");
        for (var i3 = 0; i3 < scripts.length; i3++) {
          if ((scripts[i3].src.indexOf("keycloak.js") !== -1 || scripts[i3].src.indexOf("keycloak.min.js") !== -1) && scripts[i3].src.indexOf("version=") !== -1) {
            kc2.iframeVersion = scripts[i3].src.substring(scripts[i3].src.indexOf("version=") + 8).split("&")[0];
          }
        }
        var useNonce = true;
        var logInfo = createLogger(console.info);
        var logWarn = createLogger(console.warn);
        kc2.init = function(initOptions2) {
          kc2.authenticated = false;
          callbackStorage = createCallbackStorage();
          var adapters = ["default", "cordova", "cordova-native"];
          if (initOptions2 && adapters.indexOf(initOptions2.adapter) > -1) {
            adapter = loadAdapter(initOptions2.adapter);
          } else if (initOptions2 && typeof initOptions2.adapter === "object") {
            adapter = initOptions2.adapter;
          } else {
            if (window.Cordova || window.cordova) {
              adapter = loadAdapter("cordova");
            } else {
              adapter = loadAdapter();
            }
          }
          if (initOptions2) {
            if (typeof initOptions2.useNonce !== "undefined") {
              useNonce = initOptions2.useNonce;
            }
            if (typeof initOptions2.checkLoginIframe !== "undefined") {
              loginIframe.enable = initOptions2.checkLoginIframe;
            }
            if (initOptions2.checkLoginIframeInterval) {
              loginIframe.interval = initOptions2.checkLoginIframeInterval;
            }
            if (initOptions2.onLoad === "login-required") {
              kc2.loginRequired = true;
            }
            if (initOptions2.responseMode) {
              if (initOptions2.responseMode === "query" || initOptions2.responseMode === "fragment") {
                kc2.responseMode = initOptions2.responseMode;
              } else {
                throw "Invalid value for responseMode";
              }
            }
            if (initOptions2.flow) {
              switch (initOptions2.flow) {
                case "standard":
                  kc2.responseType = "code";
                  break;
                case "implicit":
                  kc2.responseType = "id_token token";
                  break;
                case "hybrid":
                  kc2.responseType = "code id_token token";
                  break;
                default:
                  throw "Invalid value for flow";
              }
              kc2.flow = initOptions2.flow;
            }
            if (initOptions2.timeSkew != null) {
              kc2.timeSkew = initOptions2.timeSkew;
            }
            if (initOptions2.redirectUri) {
              kc2.redirectUri = initOptions2.redirectUri;
            }
            if (initOptions2.silentCheckSsoRedirectUri) {
              kc2.silentCheckSsoRedirectUri = initOptions2.silentCheckSsoRedirectUri;
            }
            if (typeof initOptions2.silentCheckSsoFallback === "boolean") {
              kc2.silentCheckSsoFallback = initOptions2.silentCheckSsoFallback;
            } else {
              kc2.silentCheckSsoFallback = true;
            }
            if (initOptions2.pkceMethod) {
              if (initOptions2.pkceMethod !== "S256") {
                throw "Invalid value for pkceMethod";
              }
              kc2.pkceMethod = initOptions2.pkceMethod;
            }
            if (typeof initOptions2.enableLogging === "boolean") {
              kc2.enableLogging = initOptions2.enableLogging;
            } else {
              kc2.enableLogging = false;
            }
            if (typeof initOptions2.scope === "string") {
              kc2.scope = initOptions2.scope;
            }
            if (typeof initOptions2.messageReceiveTimeout === "number" && initOptions2.messageReceiveTimeout > 0) {
              kc2.messageReceiveTimeout = initOptions2.messageReceiveTimeout;
            } else {
              kc2.messageReceiveTimeout = 1e4;
            }
          }
          if (!kc2.responseMode) {
            kc2.responseMode = "fragment";
          }
          if (!kc2.responseType) {
            kc2.responseType = "code";
            kc2.flow = "standard";
          }
          var promise = createPromise();
          var initPromise = createPromise();
          initPromise.promise.then(function() {
            kc2.onReady && kc2.onReady(kc2.authenticated);
            promise.setSuccess(kc2.authenticated);
          }).catch(function(error2) {
            promise.setError(error2);
          });
          var configPromise = loadConfig();
          function onLoad() {
            var doLogin = function(prompt) {
              if (!prompt) {
                options.prompt = "none";
              }
              kc2.login(options).then(function() {
                initPromise.setSuccess();
              }).catch(function(error2) {
                initPromise.setError(error2);
              });
            };
            var checkSsoSilently = function() {
              var ifrm = document.createElement("iframe");
              var src = kc2.createLoginUrl({prompt: "none", redirectUri: kc2.silentCheckSsoRedirectUri});
              ifrm.setAttribute("src", src);
              ifrm.setAttribute("title", "keycloak-silent-check-sso");
              ifrm.style.display = "none";
              document.body.appendChild(ifrm);
              var messageCallback = function(event) {
                if (event.origin !== window.location.origin || ifrm.contentWindow !== event.source) {
                  return;
                }
                var oauth = parseCallback(event.data);
                processCallback(oauth, initPromise);
                document.body.removeChild(ifrm);
                window.removeEventListener("message", messageCallback);
              };
              window.addEventListener("message", messageCallback);
            };
            var options = {};
            switch (initOptions2.onLoad) {
              case "check-sso":
                if (loginIframe.enable) {
                  setupCheckLoginIframe().then(function() {
                    checkLoginIframe().then(function(unchanged) {
                      if (!unchanged) {
                        kc2.silentCheckSsoRedirectUri ? checkSsoSilently() : doLogin(false);
                      } else {
                        initPromise.setSuccess();
                      }
                    }).catch(function(error2) {
                      initPromise.setError(error2);
                    });
                  });
                } else {
                  kc2.silentCheckSsoRedirectUri ? checkSsoSilently() : doLogin(false);
                }
                break;
              case "login-required":
                doLogin(true);
                break;
              default:
                throw "Invalid value for onLoad";
            }
          }
          function processInit() {
            var callback = parseCallback(window.location.href);
            if (callback) {
              window.history.replaceState(window.history.state, null, callback.newUrl);
            }
            if (callback && callback.valid) {
              return setupCheckLoginIframe().then(function() {
                processCallback(callback, initPromise);
              }).catch(function(error2) {
                initPromise.setError(error2);
              });
            } else if (initOptions2) {
              if (initOptions2.token && initOptions2.refreshToken) {
                setToken(initOptions2.token, initOptions2.refreshToken, initOptions2.idToken);
                if (loginIframe.enable) {
                  setupCheckLoginIframe().then(function() {
                    checkLoginIframe().then(function(unchanged) {
                      if (unchanged) {
                        kc2.onAuthSuccess && kc2.onAuthSuccess();
                        initPromise.setSuccess();
                        scheduleCheckIframe();
                      } else {
                        initPromise.setSuccess();
                      }
                    }).catch(function(error2) {
                      initPromise.setError(error2);
                    });
                  });
                } else {
                  kc2.updateToken(-1).then(function() {
                    kc2.onAuthSuccess && kc2.onAuthSuccess();
                    initPromise.setSuccess();
                  }).catch(function(error2) {
                    kc2.onAuthError && kc2.onAuthError();
                    if (initOptions2.onLoad) {
                      onLoad();
                    } else {
                      initPromise.setError(error2);
                    }
                  });
                }
              } else if (initOptions2.onLoad) {
                onLoad();
              } else {
                initPromise.setSuccess();
              }
            } else {
              initPromise.setSuccess();
            }
          }
          function domReady() {
            var promise2 = createPromise();
            var checkReadyState = function() {
              if (document.readyState === "interactive" || document.readyState === "complete") {
                document.removeEventListener("readystatechange", checkReadyState);
                promise2.setSuccess();
              }
            };
            document.addEventListener("readystatechange", checkReadyState);
            checkReadyState();
            return promise2.promise;
          }
          configPromise.then(function() {
            domReady().then(check3pCookiesSupported).then(processInit).catch(function(error2) {
              promise.setError(error2);
            });
          });
          configPromise.catch(function(error2) {
            promise.setError(error2);
          });
          return promise.promise;
        };
        kc2.login = function(options) {
          return adapter.login(options);
        };
        function generateRandomData(len2) {
          var array2 = null;
          var crypto = window.crypto || window.msCrypto;
          if (crypto && crypto.getRandomValues && window.Uint8Array) {
            array2 = new Uint8Array(len2);
            crypto.getRandomValues(array2);
            return array2;
          }
          array2 = new Array(len2);
          for (var j = 0; j < array2.length; j++) {
            array2[j] = Math.floor(256 * Math.random());
          }
          return array2;
        }
        function generateCodeVerifier(len2) {
          return generateRandomString(len2, "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789");
        }
        function generateRandomString(len2, alphabet) {
          var randomData = generateRandomData(len2);
          var chars2 = new Array(len2);
          for (var i4 = 0; i4 < len2; i4++) {
            chars2[i4] = alphabet.charCodeAt(randomData[i4] % alphabet.length);
          }
          return String.fromCharCode.apply(null, chars2);
        }
        function generatePkceChallenge(pkceMethod, codeVerifier) {
          switch (pkceMethod) {
            case "S256":
              var hashBytes = new Uint8Array(sha256_imported.arrayBuffer(codeVerifier));
              var encodedHash = base64js_imported.fromByteArray(hashBytes).replace(/\+/g, "-").replace(/\//g, "_").replace(/\=/g, "");
              return encodedHash;
            default:
              throw "Invalid value for pkceMethod";
          }
        }
        kc2.createLoginUrl = function(options) {
          var state = createUUID();
          var nonce = createUUID();
          var redirectUri = adapter.redirectUri(options);
          var callbackState = {
            state,
            nonce,
            redirectUri: encodeURIComponent(redirectUri)
          };
          if (options && options.prompt) {
            callbackState.prompt = options.prompt;
          }
          var baseUrl;
          if (options && options.action == "register") {
            baseUrl = kc2.endpoints.register();
          } else {
            baseUrl = kc2.endpoints.authorize();
          }
          var scope = options && options.scope || kc2.scope;
          if (!scope) {
            scope = "openid";
          } else if (scope.indexOf("openid") === -1) {
            scope = "openid " + scope;
          }
          var url = baseUrl + "?client_id=" + encodeURIComponent(kc2.clientId) + "&redirect_uri=" + encodeURIComponent(redirectUri) + "&state=" + encodeURIComponent(state) + "&response_mode=" + encodeURIComponent(kc2.responseMode) + "&response_type=" + encodeURIComponent(kc2.responseType) + "&scope=" + encodeURIComponent(scope);
          if (useNonce) {
            url = url + "&nonce=" + encodeURIComponent(nonce);
          }
          if (options && options.prompt) {
            url += "&prompt=" + encodeURIComponent(options.prompt);
          }
          if (options && options.maxAge) {
            url += "&max_age=" + encodeURIComponent(options.maxAge);
          }
          if (options && options.loginHint) {
            url += "&login_hint=" + encodeURIComponent(options.loginHint);
          }
          if (options && options.idpHint) {
            url += "&kc_idp_hint=" + encodeURIComponent(options.idpHint);
          }
          if (options && options.action && options.action != "register") {
            url += "&kc_action=" + encodeURIComponent(options.action);
          }
          if (options && options.locale) {
            url += "&ui_locales=" + encodeURIComponent(options.locale);
          }
          if (kc2.pkceMethod) {
            var codeVerifier = generateCodeVerifier(96);
            callbackState.pkceCodeVerifier = codeVerifier;
            var pkceChallenge = generatePkceChallenge(kc2.pkceMethod, codeVerifier);
            url += "&code_challenge=" + pkceChallenge;
            url += "&code_challenge_method=" + kc2.pkceMethod;
          }
          callbackStorage.add(callbackState);
          return url;
        };
        kc2.logout = function(options) {
          return adapter.logout(options);
        };
        kc2.createLogoutUrl = function(options) {
          var url = kc2.endpoints.logout() + "?redirect_uri=" + encodeURIComponent(adapter.redirectUri(options, false));
          return url;
        };
        kc2.register = function(options) {
          return adapter.register(options);
        };
        kc2.createRegisterUrl = function(options) {
          if (!options) {
            options = {};
          }
          options.action = "register";
          return kc2.createLoginUrl(options);
        };
        kc2.createAccountUrl = function(options) {
          var realm2 = getRealmUrl();
          var url = void 0;
          if (typeof realm2 !== "undefined") {
            url = realm2 + "/account?referrer=" + encodeURIComponent(kc2.clientId) + "&referrer_uri=" + encodeURIComponent(adapter.redirectUri(options));
          }
          return url;
        };
        kc2.accountManagement = function() {
          return adapter.accountManagement();
        };
        kc2.hasRealmRole = function(role) {
          var access = kc2.realmAccess;
          return !!access && access.roles.indexOf(role) >= 0;
        };
        kc2.hasResourceRole = function(role, resource2) {
          if (!kc2.resourceAccess) {
            return false;
          }
          var access = kc2.resourceAccess[resource2 || kc2.clientId];
          return !!access && access.roles.indexOf(role) >= 0;
        };
        kc2.loadUserProfile = function() {
          var url = getRealmUrl() + "/account";
          var req = new XMLHttpRequest();
          req.open("GET", url, true);
          req.setRequestHeader("Accept", "application/json");
          req.setRequestHeader("Authorization", "bearer " + kc2.token);
          var promise = createPromise();
          req.onreadystatechange = function() {
            if (req.readyState == 4) {
              if (req.status == 200) {
                kc2.profile = JSON.parse(req.responseText);
                promise.setSuccess(kc2.profile);
              } else {
                promise.setError();
              }
            }
          };
          req.send();
          return promise.promise;
        };
        kc2.loadUserInfo = function() {
          var url = kc2.endpoints.userinfo();
          var req = new XMLHttpRequest();
          req.open("GET", url, true);
          req.setRequestHeader("Accept", "application/json");
          req.setRequestHeader("Authorization", "bearer " + kc2.token);
          var promise = createPromise();
          req.onreadystatechange = function() {
            if (req.readyState == 4) {
              if (req.status == 200) {
                kc2.userInfo = JSON.parse(req.responseText);
                promise.setSuccess(kc2.userInfo);
              } else {
                promise.setError();
              }
            }
          };
          req.send();
          return promise.promise;
        };
        kc2.isTokenExpired = function(minValidity) {
          if (!kc2.tokenParsed || !kc2.refreshToken && kc2.flow != "implicit") {
            throw "Not authenticated";
          }
          if (kc2.timeSkew == null) {
            logInfo("[KEYCLOAK] Unable to determine if token is expired as timeskew is not set");
            return true;
          }
          var expiresIn = kc2.tokenParsed["exp"] - Math.ceil(new Date().getTime() / 1e3) + kc2.timeSkew;
          if (minValidity) {
            if (isNaN(minValidity)) {
              throw "Invalid minValidity";
            }
            expiresIn -= minValidity;
          }
          return expiresIn < 0;
        };
        kc2.updateToken = function(minValidity) {
          var promise = createPromise();
          if (!kc2.refreshToken) {
            promise.setError();
            return promise.promise;
          }
          minValidity = minValidity || 5;
          var exec = function() {
            var refreshToken = false;
            if (minValidity == -1) {
              refreshToken = true;
              logInfo("[KEYCLOAK] Refreshing token: forced refresh");
            } else if (!kc2.tokenParsed || kc2.isTokenExpired(minValidity)) {
              refreshToken = true;
              logInfo("[KEYCLOAK] Refreshing token: token expired");
            }
            if (!refreshToken) {
              promise.setSuccess(false);
            } else {
              var params = "grant_type=refresh_token&refresh_token=" + kc2.refreshToken;
              var url = kc2.endpoints.token();
              refreshQueue.push(promise);
              if (refreshQueue.length == 1) {
                var req = new XMLHttpRequest();
                req.open("POST", url, true);
                req.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
                req.withCredentials = true;
                params += "&client_id=" + encodeURIComponent(kc2.clientId);
                var timeLocal = new Date().getTime();
                req.onreadystatechange = function() {
                  if (req.readyState == 4) {
                    if (req.status == 200) {
                      logInfo("[KEYCLOAK] Token refreshed");
                      timeLocal = (timeLocal + new Date().getTime()) / 2;
                      var tokenResponse = JSON.parse(req.responseText);
                      setToken(tokenResponse["access_token"], tokenResponse["refresh_token"], tokenResponse["id_token"], timeLocal);
                      kc2.onAuthRefreshSuccess && kc2.onAuthRefreshSuccess();
                      for (var p2 = refreshQueue.pop(); p2 != null; p2 = refreshQueue.pop()) {
                        p2.setSuccess(true);
                      }
                    } else {
                      logWarn("[KEYCLOAK] Failed to refresh token");
                      if (req.status == 400) {
                        kc2.clearToken();
                      }
                      kc2.onAuthRefreshError && kc2.onAuthRefreshError();
                      for (var p2 = refreshQueue.pop(); p2 != null; p2 = refreshQueue.pop()) {
                        p2.setError(true);
                      }
                    }
                  }
                };
                req.send(params);
              }
            }
          };
          if (loginIframe.enable) {
            var iframePromise = checkLoginIframe();
            iframePromise.then(function() {
              exec();
            }).catch(function(error2) {
              promise.setError(error2);
            });
          } else {
            exec();
          }
          return promise.promise;
        };
        kc2.clearToken = function() {
          if (kc2.token) {
            setToken(null, null, null);
            kc2.onAuthLogout && kc2.onAuthLogout();
            if (kc2.loginRequired) {
              kc2.login();
            }
          }
        };
        function getRealmUrl() {
          if (typeof kc2.authServerUrl !== "undefined") {
            if (kc2.authServerUrl.charAt(kc2.authServerUrl.length - 1) == "/") {
              return kc2.authServerUrl + "realms/" + encodeURIComponent(kc2.realm);
            } else {
              return kc2.authServerUrl + "/realms/" + encodeURIComponent(kc2.realm);
            }
          } else {
            return void 0;
          }
        }
        function getOrigin() {
          if (!window.location.origin) {
            return window.location.protocol + "//" + window.location.hostname + (window.location.port ? ":" + window.location.port : "");
          } else {
            return window.location.origin;
          }
        }
        function processCallback(oauth, promise) {
          var code2 = oauth.code;
          var error2 = oauth.error;
          var prompt = oauth.prompt;
          var timeLocal = new Date().getTime();
          if (oauth["kc_action_status"]) {
            kc2.onActionUpdate && kc2.onActionUpdate(oauth["kc_action_status"]);
          }
          if (error2) {
            if (prompt != "none") {
              var errorData = {error: error2, error_description: oauth.error_description};
              kc2.onAuthError && kc2.onAuthError(errorData);
              promise && promise.setError(errorData);
            } else {
              promise && promise.setSuccess();
            }
            return;
          } else if (kc2.flow != "standard" && (oauth.access_token || oauth.id_token)) {
            authSuccess(oauth.access_token, null, oauth.id_token, true);
          }
          if (kc2.flow != "implicit" && code2) {
            var params = "code=" + code2 + "&grant_type=authorization_code";
            var url = kc2.endpoints.token();
            var req = new XMLHttpRequest();
            req.open("POST", url, true);
            req.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
            params += "&client_id=" + encodeURIComponent(kc2.clientId);
            params += "&redirect_uri=" + oauth.redirectUri;
            if (oauth.pkceCodeVerifier) {
              params += "&code_verifier=" + oauth.pkceCodeVerifier;
            }
            req.withCredentials = true;
            req.onreadystatechange = function() {
              if (req.readyState == 4) {
                if (req.status == 200) {
                  var tokenResponse = JSON.parse(req.responseText);
                  authSuccess(tokenResponse["access_token"], tokenResponse["refresh_token"], tokenResponse["id_token"], kc2.flow === "standard");
                  scheduleCheckIframe();
                } else {
                  kc2.onAuthError && kc2.onAuthError();
                  promise && promise.setError();
                }
              }
            };
            req.send(params);
          }
          function authSuccess(accessToken, refreshToken, idToken, fulfillPromise) {
            timeLocal = (timeLocal + new Date().getTime()) / 2;
            setToken(accessToken, refreshToken, idToken, timeLocal);
            if (useNonce && (kc2.tokenParsed && kc2.tokenParsed.nonce != oauth.storedNonce || kc2.refreshTokenParsed && kc2.refreshTokenParsed.nonce != oauth.storedNonce || kc2.idTokenParsed && kc2.idTokenParsed.nonce != oauth.storedNonce)) {
              logInfo("[KEYCLOAK] Invalid nonce, clearing token");
              kc2.clearToken();
              promise && promise.setError();
            } else {
              if (fulfillPromise) {
                kc2.onAuthSuccess && kc2.onAuthSuccess();
                promise && promise.setSuccess();
              }
            }
          }
        }
        function loadConfig(url) {
          var promise = createPromise();
          var configUrl;
          if (!config2) {
            configUrl = "keycloak.json";
          } else if (typeof config2 === "string") {
            configUrl = config2;
          }
          function setupOidcEndoints(oidcConfiguration) {
            if (!oidcConfiguration) {
              kc2.endpoints = {
                authorize: function() {
                  return getRealmUrl() + "/protocol/openid-connect/auth";
                },
                token: function() {
                  return getRealmUrl() + "/protocol/openid-connect/token";
                },
                logout: function() {
                  return getRealmUrl() + "/protocol/openid-connect/logout";
                },
                checkSessionIframe: function() {
                  var src = getRealmUrl() + "/protocol/openid-connect/login-status-iframe.html";
                  if (kc2.iframeVersion) {
                    src = src + "?version=" + kc2.iframeVersion;
                  }
                  return src;
                },
                thirdPartyCookiesIframe: function() {
                  var src = getRealmUrl() + "/protocol/openid-connect/3p-cookies/step1.html";
                  if (kc2.iframeVersion) {
                    src = src + "?version=" + kc2.iframeVersion;
                  }
                  return src;
                },
                register: function() {
                  return getRealmUrl() + "/protocol/openid-connect/registrations";
                },
                userinfo: function() {
                  return getRealmUrl() + "/protocol/openid-connect/userinfo";
                }
              };
            } else {
              kc2.endpoints = {
                authorize: function() {
                  return oidcConfiguration.authorization_endpoint;
                },
                token: function() {
                  return oidcConfiguration.token_endpoint;
                },
                logout: function() {
                  if (!oidcConfiguration.end_session_endpoint) {
                    throw "Not supported by the OIDC server";
                  }
                  return oidcConfiguration.end_session_endpoint;
                },
                checkSessionIframe: function() {
                  if (!oidcConfiguration.check_session_iframe) {
                    throw "Not supported by the OIDC server";
                  }
                  return oidcConfiguration.check_session_iframe;
                },
                register: function() {
                  throw 'Redirection to "Register user" page not supported in standard OIDC mode';
                },
                userinfo: function() {
                  if (!oidcConfiguration.userinfo_endpoint) {
                    throw "Not supported by the OIDC server";
                  }
                  return oidcConfiguration.userinfo_endpoint;
                }
              };
            }
          }
          if (configUrl) {
            var req = new XMLHttpRequest();
            req.open("GET", configUrl, true);
            req.setRequestHeader("Accept", "application/json");
            req.onreadystatechange = function() {
              if (req.readyState == 4) {
                if (req.status == 200 || fileLoaded(req)) {
                  var config3 = JSON.parse(req.responseText);
                  kc2.authServerUrl = config3["auth-server-url"];
                  kc2.realm = config3["realm"];
                  kc2.clientId = config3["resource"];
                  setupOidcEndoints(null);
                  promise.setSuccess();
                } else {
                  promise.setError();
                }
              }
            };
            req.send();
          } else {
            if (!config2.clientId) {
              throw "clientId missing";
            }
            kc2.clientId = config2.clientId;
            var oidcProvider = config2["oidcProvider"];
            if (!oidcProvider) {
              if (!config2["url"]) {
                var scripts2 = document.getElementsByTagName("script");
                for (var i4 = 0; i4 < scripts2.length; i4++) {
                  if (scripts2[i4].src.match(/.*keycloak\.js/)) {
                    config2.url = scripts2[i4].src.substr(0, scripts2[i4].src.indexOf("/js/keycloak.js"));
                    break;
                  }
                }
              }
              if (!config2.realm) {
                throw "realm missing";
              }
              kc2.authServerUrl = config2.url;
              kc2.realm = config2.realm;
              setupOidcEndoints(null);
              promise.setSuccess();
            } else {
              if (typeof oidcProvider === "string") {
                var oidcProviderConfigUrl;
                if (oidcProvider.charAt(oidcProvider.length - 1) == "/") {
                  oidcProviderConfigUrl = oidcProvider + ".well-known/openid-configuration";
                } else {
                  oidcProviderConfigUrl = oidcProvider + "/.well-known/openid-configuration";
                }
                var req = new XMLHttpRequest();
                req.open("GET", oidcProviderConfigUrl, true);
                req.setRequestHeader("Accept", "application/json");
                req.onreadystatechange = function() {
                  if (req.readyState == 4) {
                    if (req.status == 200 || fileLoaded(req)) {
                      var oidcProviderConfig = JSON.parse(req.responseText);
                      setupOidcEndoints(oidcProviderConfig);
                      promise.setSuccess();
                    } else {
                      promise.setError();
                    }
                  }
                };
                req.send();
              } else {
                setupOidcEndoints(oidcProvider);
                promise.setSuccess();
              }
            }
          }
          return promise.promise;
        }
        function fileLoaded(xhr2) {
          return xhr2.status == 0 && xhr2.responseText && xhr2.responseURL.startsWith("file:");
        }
        function setToken(token2, refreshToken, idToken, timeLocal) {
          if (kc2.tokenTimeoutHandle) {
            clearTimeout(kc2.tokenTimeoutHandle);
            kc2.tokenTimeoutHandle = null;
          }
          if (refreshToken) {
            kc2.refreshToken = refreshToken;
            kc2.refreshTokenParsed = decodeToken(refreshToken);
          } else {
            delete kc2.refreshToken;
            delete kc2.refreshTokenParsed;
          }
          if (idToken) {
            kc2.idToken = idToken;
            kc2.idTokenParsed = decodeToken(idToken);
          } else {
            delete kc2.idToken;
            delete kc2.idTokenParsed;
          }
          if (token2) {
            kc2.token = token2;
            kc2.tokenParsed = decodeToken(token2);
            kc2.sessionId = kc2.tokenParsed.session_state;
            kc2.authenticated = true;
            kc2.subject = kc2.tokenParsed.sub;
            kc2.realmAccess = kc2.tokenParsed.realm_access;
            kc2.resourceAccess = kc2.tokenParsed.resource_access;
            if (timeLocal) {
              kc2.timeSkew = Math.floor(timeLocal / 1e3) - kc2.tokenParsed.iat;
            }
            if (kc2.timeSkew != null) {
              logInfo("[KEYCLOAK] Estimated time difference between browser and server is " + kc2.timeSkew + " seconds");
              if (kc2.onTokenExpired) {
                var expiresIn = (kc2.tokenParsed["exp"] - new Date().getTime() / 1e3 + kc2.timeSkew) * 1e3;
                logInfo("[KEYCLOAK] Token expires in " + Math.round(expiresIn / 1e3) + " s");
                if (expiresIn <= 0) {
                  kc2.onTokenExpired();
                } else {
                  kc2.tokenTimeoutHandle = setTimeout(kc2.onTokenExpired, expiresIn);
                }
              }
            }
          } else {
            delete kc2.token;
            delete kc2.tokenParsed;
            delete kc2.subject;
            delete kc2.realmAccess;
            delete kc2.resourceAccess;
            kc2.authenticated = false;
          }
        }
        function decodeToken(str) {
          str = str.split(".")[1];
          str = str.replace(/-/g, "+");
          str = str.replace(/_/g, "/");
          switch (str.length % 4) {
            case 0:
              break;
            case 2:
              str += "==";
              break;
            case 3:
              str += "=";
              break;
            default:
              throw "Invalid token";
          }
          str = decodeURIComponent(escape(atob(str)));
          str = JSON.parse(str);
          return str;
        }
        function createUUID() {
          var hexDigits = "0123456789abcdef";
          var s2 = generateRandomString(36, hexDigits).split("");
          s2[14] = "4";
          s2[19] = hexDigits.substr(s2[19] & 3 | 8, 1);
          s2[8] = s2[13] = s2[18] = s2[23] = "-";
          var uuid = s2.join("");
          return uuid;
        }
        function parseCallback(url) {
          var oauth = parseCallbackUrl(url);
          if (!oauth) {
            return;
          }
          var oauthState = callbackStorage.get(oauth.state);
          if (oauthState) {
            oauth.valid = true;
            oauth.redirectUri = oauthState.redirectUri;
            oauth.storedNonce = oauthState.nonce;
            oauth.prompt = oauthState.prompt;
            oauth.pkceCodeVerifier = oauthState.pkceCodeVerifier;
          }
          return oauth;
        }
        function parseCallbackUrl(url) {
          var supportedParams;
          switch (kc2.flow) {
            case "standard":
              supportedParams = ["code", "state", "session_state", "kc_action_status"];
              break;
            case "implicit":
              supportedParams = ["access_token", "token_type", "id_token", "state", "session_state", "expires_in", "kc_action_status"];
              break;
            case "hybrid":
              supportedParams = ["access_token", "token_type", "id_token", "code", "state", "session_state", "expires_in", "kc_action_status"];
              break;
          }
          supportedParams.push("error");
          supportedParams.push("error_description");
          supportedParams.push("error_uri");
          var queryIndex = url.indexOf("?");
          var fragmentIndex = url.indexOf("#");
          var newUrl;
          var parsed;
          if (kc2.responseMode === "query" && queryIndex !== -1) {
            newUrl = url.substring(0, queryIndex);
            parsed = parseCallbackParams(url.substring(queryIndex + 1, fragmentIndex !== -1 ? fragmentIndex : url.length), supportedParams);
            if (parsed.paramsString !== "") {
              newUrl += "?" + parsed.paramsString;
            }
            if (fragmentIndex !== -1) {
              newUrl += url.substring(fragmentIndex);
            }
          } else if (kc2.responseMode === "fragment" && fragmentIndex !== -1) {
            newUrl = url.substring(0, fragmentIndex);
            parsed = parseCallbackParams(url.substring(fragmentIndex + 1), supportedParams);
            if (parsed.paramsString !== "") {
              newUrl += "#" + parsed.paramsString;
            }
          }
          if (parsed && parsed.oauthParams) {
            if (kc2.flow === "standard" || kc2.flow === "hybrid") {
              if ((parsed.oauthParams.code || parsed.oauthParams.error) && parsed.oauthParams.state) {
                parsed.oauthParams.newUrl = newUrl;
                return parsed.oauthParams;
              }
            } else if (kc2.flow === "implicit") {
              if ((parsed.oauthParams.access_token || parsed.oauthParams.error) && parsed.oauthParams.state) {
                parsed.oauthParams.newUrl = newUrl;
                return parsed.oauthParams;
              }
            }
          }
        }
        function parseCallbackParams(paramsString, supportedParams) {
          var p2 = paramsString.split("&");
          var result = {
            paramsString: "",
            oauthParams: {}
          };
          for (var i4 = 0; i4 < p2.length; i4++) {
            var split2 = p2[i4].indexOf("=");
            var key = p2[i4].slice(0, split2);
            if (supportedParams.indexOf(key) !== -1) {
              result.oauthParams[key] = p2[i4].slice(split2 + 1);
            } else {
              if (result.paramsString !== "") {
                result.paramsString += "&";
              }
              result.paramsString += p2[i4];
            }
          }
          return result;
        }
        function createPromise() {
          var p2 = {
            setSuccess: function(result) {
              p2.resolve(result);
            },
            setError: function(result) {
              p2.reject(result);
            }
          };
          p2.promise = new Promise(function(resolve2, reject) {
            p2.resolve = resolve2;
            p2.reject = reject;
          });
          p2.promise.success = function(callback) {
            logPromiseDeprecation();
            this.then(function handleSuccess(value) {
              callback(value);
            });
            return this;
          };
          p2.promise.error = function(callback) {
            logPromiseDeprecation();
            this.catch(function handleError(error2) {
              callback(error2);
            });
            return this;
          };
          return p2;
        }
        function applyTimeoutToPromise(promise, timeout3, errorMessage) {
          var timeoutHandle = null;
          var timeoutPromise = new Promise(function(resolve2, reject) {
            timeoutHandle = setTimeout(function() {
              reject({error: errorMessage || "Promise is not settled within timeout of " + timeout3 + "ms"});
            }, timeout3);
          });
          return Promise.race([promise, timeoutPromise]).finally(function() {
            clearTimeout(timeoutHandle);
          });
        }
        function setupCheckLoginIframe() {
          var promise = createPromise();
          if (!loginIframe.enable) {
            promise.setSuccess();
            return promise.promise;
          }
          if (loginIframe.iframe) {
            promise.setSuccess();
            return promise.promise;
          }
          var iframe = document.createElement("iframe");
          loginIframe.iframe = iframe;
          iframe.onload = function() {
            var authUrl = kc2.endpoints.authorize();
            if (authUrl.charAt(0) === "/") {
              loginIframe.iframeOrigin = getOrigin();
            } else {
              loginIframe.iframeOrigin = authUrl.substring(0, authUrl.indexOf("/", 8));
            }
            promise.setSuccess();
          };
          var src = kc2.endpoints.checkSessionIframe();
          iframe.setAttribute("src", src);
          iframe.setAttribute("title", "keycloak-session-iframe");
          iframe.style.display = "none";
          document.body.appendChild(iframe);
          var messageCallback = function(event) {
            if (event.origin !== loginIframe.iframeOrigin || loginIframe.iframe.contentWindow !== event.source) {
              return;
            }
            if (!(event.data == "unchanged" || event.data == "changed" || event.data == "error")) {
              return;
            }
            if (event.data != "unchanged") {
              kc2.clearToken();
            }
            var callbacks = loginIframe.callbackList.splice(0, loginIframe.callbackList.length);
            for (var i4 = callbacks.length - 1; i4 >= 0; --i4) {
              var promise2 = callbacks[i4];
              if (event.data == "error") {
                promise2.setError();
              } else {
                promise2.setSuccess(event.data == "unchanged");
              }
            }
          };
          window.addEventListener("message", messageCallback, false);
          return promise.promise;
        }
        function scheduleCheckIframe() {
          if (loginIframe.enable) {
            if (kc2.token) {
              setTimeout(function() {
                checkLoginIframe().then(function(unchanged) {
                  if (unchanged) {
                    scheduleCheckIframe();
                  }
                });
              }, loginIframe.interval * 1e3);
            }
          }
        }
        function checkLoginIframe() {
          var promise = createPromise();
          if (loginIframe.iframe && loginIframe.iframeOrigin) {
            var msg = kc2.clientId + " " + (kc2.sessionId ? kc2.sessionId : "");
            loginIframe.callbackList.push(promise);
            var origin = loginIframe.iframeOrigin;
            if (loginIframe.callbackList.length == 1) {
              loginIframe.iframe.contentWindow.postMessage(msg, origin);
            }
          } else {
            promise.setSuccess();
          }
          return promise.promise;
        }
        function check3pCookiesSupported() {
          var promise = createPromise();
          if (loginIframe.enable || kc2.silentCheckSsoRedirectUri) {
            var iframe = document.createElement("iframe");
            iframe.setAttribute("src", kc2.endpoints.thirdPartyCookiesIframe());
            iframe.setAttribute("title", "keycloak-3p-check-iframe");
            iframe.style.display = "none";
            document.body.appendChild(iframe);
            var messageCallback = function(event) {
              if (iframe.contentWindow !== event.source) {
                return;
              }
              if (event.data !== "supported" && event.data !== "unsupported") {
                return;
              } else if (event.data === "unsupported") {
                loginIframe.enable = false;
                if (kc2.silentCheckSsoFallback) {
                  kc2.silentCheckSsoRedirectUri = false;
                }
                logWarn("[KEYCLOAK] 3rd party cookies aren't supported by this browser. checkLoginIframe and silent check-sso are not available.");
              }
              document.body.removeChild(iframe);
              window.removeEventListener("message", messageCallback);
              promise.setSuccess();
            };
            window.addEventListener("message", messageCallback, false);
          } else {
            promise.setSuccess();
          }
          return applyTimeoutToPromise(promise.promise, kc2.messageReceiveTimeout, "Timeout when waiting for 3rd party check iframe message.");
        }
        function loadAdapter(type) {
          if (!type || type == "default") {
            return {
              login: function(options) {
                window.location.replace(kc2.createLoginUrl(options));
                return createPromise().promise;
              },
              logout: function(options) {
                window.location.replace(kc2.createLogoutUrl(options));
                return createPromise().promise;
              },
              register: function(options) {
                window.location.replace(kc2.createRegisterUrl(options));
                return createPromise().promise;
              },
              accountManagement: function() {
                var accountUrl = kc2.createAccountUrl();
                if (typeof accountUrl !== "undefined") {
                  window.location.href = accountUrl;
                } else {
                  throw "Not supported by the OIDC server";
                }
                return createPromise().promise;
              },
              redirectUri: function(options, encodeHash) {
                if (options && options.redirectUri) {
                  return options.redirectUri;
                } else if (kc2.redirectUri) {
                  return kc2.redirectUri;
                } else {
                  return location.href;
                }
              }
            };
          }
          if (type == "cordova") {
            loginIframe.enable = false;
            var cordovaOpenWindowWrapper = function(loginUrl, target, options) {
              if (window.cordova && window.cordova.InAppBrowser) {
                return window.cordova.InAppBrowser.open(loginUrl, target, options);
              } else {
                return window.open(loginUrl, target, options);
              }
            };
            var shallowCloneCordovaOptions = function(userOptions) {
              if (userOptions && userOptions.cordovaOptions) {
                return Object.keys(userOptions.cordovaOptions).reduce(function(options, optionName) {
                  options[optionName] = userOptions.cordovaOptions[optionName];
                  return options;
                }, {});
              } else {
                return {};
              }
            };
            var formatCordovaOptions = function(cordovaOptions) {
              return Object.keys(cordovaOptions).reduce(function(options, optionName) {
                options.push(optionName + "=" + cordovaOptions[optionName]);
                return options;
              }, []).join(",");
            };
            var createCordovaOptions = function(userOptions) {
              var cordovaOptions = shallowCloneCordovaOptions(userOptions);
              cordovaOptions.location = "no";
              if (userOptions && userOptions.prompt == "none") {
                cordovaOptions.hidden = "yes";
              }
              return formatCordovaOptions(cordovaOptions);
            };
            return {
              login: function(options) {
                var promise = createPromise();
                var cordovaOptions = createCordovaOptions(options);
                var loginUrl = kc2.createLoginUrl(options);
                var ref = cordovaOpenWindowWrapper(loginUrl, "_blank", cordovaOptions);
                var completed = false;
                var closed = false;
                var closeBrowser = function() {
                  closed = true;
                  ref.close();
                };
                ref.addEventListener("loadstart", function(event) {
                  if (event.url.indexOf("http://localhost") == 0) {
                    var callback = parseCallback(event.url);
                    processCallback(callback, promise);
                    closeBrowser();
                    completed = true;
                  }
                });
                ref.addEventListener("loaderror", function(event) {
                  if (!completed) {
                    if (event.url.indexOf("http://localhost") == 0) {
                      var callback = parseCallback(event.url);
                      processCallback(callback, promise);
                      closeBrowser();
                      completed = true;
                    } else {
                      promise.setError();
                      closeBrowser();
                    }
                  }
                });
                ref.addEventListener("exit", function(event) {
                  if (!closed) {
                    promise.setError({
                      reason: "closed_by_user"
                    });
                  }
                });
                return promise.promise;
              },
              logout: function(options) {
                var promise = createPromise();
                var logoutUrl = kc2.createLogoutUrl(options);
                var ref = cordovaOpenWindowWrapper(logoutUrl, "_blank", "location=no,hidden=yes");
                var error2;
                ref.addEventListener("loadstart", function(event) {
                  if (event.url.indexOf("http://localhost") == 0) {
                    ref.close();
                  }
                });
                ref.addEventListener("loaderror", function(event) {
                  if (event.url.indexOf("http://localhost") == 0) {
                    ref.close();
                  } else {
                    error2 = true;
                    ref.close();
                  }
                });
                ref.addEventListener("exit", function(event) {
                  if (error2) {
                    promise.setError();
                  } else {
                    kc2.clearToken();
                    promise.setSuccess();
                  }
                });
                return promise.promise;
              },
              register: function(options) {
                var promise = createPromise();
                var registerUrl = kc2.createRegisterUrl();
                var cordovaOptions = createCordovaOptions(options);
                var ref = cordovaOpenWindowWrapper(registerUrl, "_blank", cordovaOptions);
                ref.addEventListener("loadstart", function(event) {
                  if (event.url.indexOf("http://localhost") == 0) {
                    ref.close();
                    var oauth = parseCallback(event.url);
                    processCallback(oauth, promise);
                  }
                });
                return promise.promise;
              },
              accountManagement: function() {
                var accountUrl = kc2.createAccountUrl();
                if (typeof accountUrl !== "undefined") {
                  var ref = cordovaOpenWindowWrapper(accountUrl, "_blank", "location=no");
                  ref.addEventListener("loadstart", function(event) {
                    if (event.url.indexOf("http://localhost") == 0) {
                      ref.close();
                    }
                  });
                } else {
                  throw "Not supported by the OIDC server";
                }
              },
              redirectUri: function(options) {
                return "http://localhost";
              }
            };
          }
          if (type == "cordova-native") {
            loginIframe.enable = false;
            return {
              login: function(options) {
                var promise = createPromise();
                var loginUrl = kc2.createLoginUrl(options);
                universalLinks.subscribe("keycloak", function(event) {
                  universalLinks.unsubscribe("keycloak");
                  window.cordova.plugins.browsertab.close();
                  var oauth = parseCallback(event.url);
                  processCallback(oauth, promise);
                });
                window.cordova.plugins.browsertab.openUrl(loginUrl);
                return promise.promise;
              },
              logout: function(options) {
                var promise = createPromise();
                var logoutUrl = kc2.createLogoutUrl(options);
                universalLinks.subscribe("keycloak", function(event) {
                  universalLinks.unsubscribe("keycloak");
                  window.cordova.plugins.browsertab.close();
                  kc2.clearToken();
                  promise.setSuccess();
                });
                window.cordova.plugins.browsertab.openUrl(logoutUrl);
                return promise.promise;
              },
              register: function(options) {
                var promise = createPromise();
                var registerUrl = kc2.createRegisterUrl(options);
                universalLinks.subscribe("keycloak", function(event) {
                  universalLinks.unsubscribe("keycloak");
                  window.cordova.plugins.browsertab.close();
                  var oauth = parseCallback(event.url);
                  processCallback(oauth, promise);
                });
                window.cordova.plugins.browsertab.openUrl(registerUrl);
                return promise.promise;
              },
              accountManagement: function() {
                var accountUrl = kc2.createAccountUrl();
                if (typeof accountUrl !== "undefined") {
                  window.cordova.plugins.browsertab.openUrl(accountUrl);
                } else {
                  throw "Not supported by the OIDC server";
                }
              },
              redirectUri: function(options) {
                if (options && options.redirectUri) {
                  return options.redirectUri;
                } else if (kc2.redirectUri) {
                  return kc2.redirectUri;
                } else {
                  return "http://localhost";
                }
              }
            };
          }
          throw "invalid adapter type: " + type;
        }
        var LocalStorage = function() {
          if (!(this instanceof LocalStorage)) {
            return new LocalStorage();
          }
          localStorage.setItem("kc-test", "test");
          localStorage.removeItem("kc-test");
          var cs = this;
          function clearExpired() {
            var time2 = new Date().getTime();
            for (var i4 = 0; i4 < localStorage.length; i4++) {
              var key = localStorage.key(i4);
              if (key && key.indexOf("kc-callback-") == 0) {
                var value = localStorage.getItem(key);
                if (value) {
                  try {
                    var expires2 = JSON.parse(value).expires;
                    if (!expires2 || expires2 < time2) {
                      localStorage.removeItem(key);
                    }
                  } catch (err) {
                    localStorage.removeItem(key);
                  }
                }
              }
            }
          }
          cs.get = function(state) {
            if (!state) {
              return;
            }
            var key = "kc-callback-" + state;
            var value = localStorage.getItem(key);
            if (value) {
              localStorage.removeItem(key);
              value = JSON.parse(value);
            }
            clearExpired();
            return value;
          };
          cs.add = function(state) {
            clearExpired();
            var key = "kc-callback-" + state.state;
            state.expires = new Date().getTime() + 60 * 60 * 1e3;
            localStorage.setItem(key, JSON.stringify(state));
          };
        };
        var CookieStorage = function() {
          if (!(this instanceof CookieStorage)) {
            return new CookieStorage();
          }
          var cs = this;
          cs.get = function(state) {
            if (!state) {
              return;
            }
            var value = getCookie("kc-callback-" + state);
            setCookie("kc-callback-" + state, "", cookieExpiration(-100));
            if (value) {
              return JSON.parse(value);
            }
          };
          cs.add = function(state) {
            setCookie("kc-callback-" + state.state, JSON.stringify(state), cookieExpiration(60));
          };
          cs.removeItem = function(key) {
            setCookie(key, "", cookieExpiration(-100));
          };
          var cookieExpiration = function(minutes) {
            var exp = new Date();
            exp.setTime(exp.getTime() + minutes * 60 * 1e3);
            return exp;
          };
          var getCookie = function(key) {
            var name = key + "=";
            var ca2 = document.cookie.split(";");
            for (var i4 = 0; i4 < ca2.length; i4++) {
              var c3 = ca2[i4];
              while (c3.charAt(0) == " ") {
                c3 = c3.substring(1);
              }
              if (c3.indexOf(name) == 0) {
                return c3.substring(name.length, c3.length);
              }
            }
            return "";
          };
          var setCookie = function(key, value, expirationDate) {
            var cookie = key + "=" + value + "; expires=" + expirationDate.toUTCString() + "; ";
            document.cookie = cookie;
          };
        };
        function createCallbackStorage() {
          try {
            return new LocalStorage();
          } catch (err) {
          }
          return new CookieStorage();
        }
        function createLogger(fn) {
          return function() {
            if (kc2.enableLogging) {
              fn.apply(console, Array.prototype.slice.call(arguments));
            }
          };
        }
      }
      return Keycloak;
    });
  });
  var client = createCommonjsModule(function(module2, exports2) {
    var __createBinding = commonjsGlobal && commonjsGlobal.__createBinding || (Object.create ? function(o, m2, k2, k22) {
      if (k22 === void 0)
        k22 = k2;
      Object.defineProperty(o, k22, {enumerable: true, get: function() {
        return m2[k2];
      }});
    } : function(o, m2, k2, k22) {
      if (k22 === void 0)
        k22 = k2;
      o[k22] = m2[k2];
    });
    var __setModuleDefault = commonjsGlobal && commonjsGlobal.__setModuleDefault || (Object.create ? function(o, v2) {
      Object.defineProperty(o, "default", {enumerable: true, value: v2});
    } : function(o, v2) {
      o["default"] = v2;
    });
    var __importStar = commonjsGlobal && commonjsGlobal.__importStar || function(mod) {
      if (mod && mod.__esModule)
        return mod;
      var result = {};
      if (mod != null) {
        for (var k2 in mod)
          if (k2 !== "default" && Object.prototype.hasOwnProperty.call(mod, k2))
            __createBinding(result, mod, k2);
      }
      __setModuleDefault(result, mod);
      return result;
    };
    var __awaiter3 = commonjsGlobal && commonjsGlobal.__awaiter || function(thisArg, _arguments, P2, generator) {
      function adopt(value) {
        return value instanceof P2 ? value : new P2(function(resolve2) {
          resolve2(value);
        });
      }
      return new (P2 || (P2 = Promise))(function(resolve2, reject) {
        function fulfilled(value) {
          try {
            step(generator.next(value));
          } catch (e2) {
            reject(e2);
          }
        }
        function rejected(value) {
          try {
            step(generator["throw"](value));
          } catch (e2) {
            reject(e2);
          }
        }
        function step(result) {
          result.done ? resolve2(result.value) : adopt(result.value).then(fulfilled, rejected);
        }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
      });
    };
    var __generator2 = commonjsGlobal && commonjsGlobal.__generator || function(thisArg, body) {
      var _23 = {label: 0, sent: function() {
        if (t5[0] & 1)
          throw t5[1];
        return t5[1];
      }, trys: [], ops: []}, f2, y3, t5, g2;
      return g2 = {next: verb(0), throw: verb(1), return: verb(2)}, typeof Symbol === "function" && (g2[Symbol.iterator] = function() {
        return this;
      }), g2;
      function verb(n3) {
        return function(v2) {
          return step([n3, v2]);
        };
      }
      function step(op) {
        if (f2)
          throw new TypeError("Generator is already executing.");
        while (_23)
          try {
            if (f2 = 1, y3 && (t5 = op[0] & 2 ? y3["return"] : op[0] ? y3["throw"] || ((t5 = y3["return"]) && t5.call(y3), 0) : y3.next) && !(t5 = t5.call(y3, op[1])).done)
              return t5;
            if (y3 = 0, t5)
              op = [op[0] & 2, t5.value];
            switch (op[0]) {
              case 0:
              case 1:
                t5 = op;
                break;
              case 4:
                _23.label++;
                return {value: op[1], done: false};
              case 5:
                _23.label++;
                y3 = op[1];
                op = [0];
                continue;
              case 7:
                op = _23.ops.pop();
                _23.trys.pop();
                continue;
              default:
                if (!(t5 = _23.trys, t5 = t5.length > 0 && t5[t5.length - 1]) && (op[0] === 6 || op[0] === 2)) {
                  _23 = 0;
                  continue;
                }
                if (op[0] === 3 && (!t5 || op[1] > t5[0] && op[1] < t5[3])) {
                  _23.label = op[1];
                  break;
                }
                if (op[0] === 6 && _23.label < t5[1]) {
                  _23.label = t5[1];
                  t5 = op;
                  break;
                }
                if (t5 && _23.label < t5[2]) {
                  _23.label = t5[2];
                  _23.ops.push(op);
                  break;
                }
                if (t5[2])
                  _23.ops.pop();
                _23.trys.pop();
                continue;
            }
            op = body.call(thisArg, _23);
          } catch (e2) {
            op = [6, e2];
            y3 = 0;
          } finally {
            f2 = t5 = 0;
          }
        if (op[0] & 5)
          throw op[1];
        return {value: op[0] ? op[1] : void 0, done: true};
      }
    };
    exports2.__esModule = true;
    exports2.KeycloakAdminClient = void 0;
    var KeycloakAdminClient = function() {
      function KeycloakAdminClient2(connectionConfig) {
        this.baseUrl = connectionConfig && connectionConfig.baseUrl || constants.defaultBaseUrl;
        this.realmName = connectionConfig && connectionConfig.realmName || constants.defaultRealm;
        this.requestConfig = connectionConfig && connectionConfig.requestConfig;
        this.users = new users.Users(this);
        this.userStorageProvider = new userStorageProvider.UserStorageProvider(this);
        this.groups = new groups.Groups(this);
        this.roles = new roles.Roles(this);
        this.clients = new clients.Clients(this);
        this.realms = new realms.Realms(this);
        this.clientScopes = new clientScopes.ClientScopes(this);
        this.clientPolicies = new clientPolicies.ClientPolicies(this);
        this.identityProviders = new identityProviders.IdentityProviders(this);
        this.components = new components.Components(this);
        this.authenticationManagement = new authenticationManagement.AuthenticationManagement(this);
        this.serverInfo = new serverInfo.ServerInfo(this);
        this.whoAmI = new whoAmI.WhoAmI(this);
        this.sessions = new sessions.Sessions(this);
        this.attackDetection = new attackDetection.AttackDetection(this);
        this.cache = new cache.Cache(this);
      }
      KeycloakAdminClient2.prototype.auth = function(credentials) {
        return __awaiter3(this, void 0, void 0, function() {
          var _a, accessToken, refreshToken;
          return __generator2(this, function(_b) {
            switch (_b.label) {
              case 0:
                return [4, (0, auth.getToken)({
                  baseUrl: this.baseUrl,
                  realmName: this.realmName,
                  credentials,
                  requestConfig: this.requestConfig
                })];
              case 1:
                _a = _b.sent(), accessToken = _a.accessToken, refreshToken = _a.refreshToken;
                this.accessToken = accessToken;
                this.refreshToken = refreshToken;
                return [2];
            }
          });
        });
      };
      KeycloakAdminClient2.prototype.init = function(init4, config2) {
        return __awaiter3(this, void 0, void 0, function() {
          var Keycloak;
          return __generator2(this, function(_a) {
            switch (_a.label) {
              case 0:
                if (typeof window === "undefined") {
                  return [2];
                }
                return [4, Promise.resolve().then(function() {
                  return __importStar(keycloak);
                })];
              case 1:
                Keycloak = _a.sent()["default"];
                this.keycloak = Keycloak(config2);
                if (!init4)
                  return [3, 3];
                return [4, this.keycloak.init(init4)];
              case 2:
                _a.sent();
                _a.label = 3;
              case 3:
                if (this.keycloak.authServerUrl) {
                  this.baseUrl = this.keycloak.authServerUrl;
                }
                return [2];
            }
          });
        });
      };
      KeycloakAdminClient2.prototype.setAccessToken = function(token2) {
        this.accessToken = token2;
      };
      KeycloakAdminClient2.prototype.getAccessToken = function() {
        return __awaiter3(this, void 0, void 0, function() {
          return __generator2(this, function(_a) {
            switch (_a.label) {
              case 0:
                if (!this.keycloak)
                  return [3, 5];
                _a.label = 1;
              case 1:
                _a.trys.push([1, 3, , 4]);
                return [4, this.keycloak.updateToken(5)];
              case 2:
                _a.sent();
                return [3, 4];
              case 3:
                _a.sent();
                this.keycloak.login();
                return [3, 4];
              case 4:
                return [2, this.keycloak.token];
              case 5:
                return [2, this.accessToken];
            }
          });
        });
      };
      KeycloakAdminClient2.prototype.getRequestConfig = function() {
        return this.requestConfig;
      };
      KeycloakAdminClient2.prototype.setConfig = function(connectionConfig) {
        if (typeof connectionConfig.baseUrl === "string" && connectionConfig.baseUrl) {
          this.baseUrl = connectionConfig.baseUrl;
        }
        if (typeof connectionConfig.realmName === "string" && connectionConfig.realmName) {
          this.realmName = connectionConfig.realmName;
        }
        this.requestConfig = connectionConfig.requestConfig;
      };
      return KeycloakAdminClient2;
    }();
    exports2.KeycloakAdminClient = KeycloakAdminClient;
  });
  var lib = createCommonjsModule(function(module2, exports2) {
    exports2.__esModule = true;
    exports2.requiredAction = void 0;
    exports2.requiredAction = requiredActionProviderRepresentation.RequiredActionAlias;
    exports2["default"] = client.KeycloakAdminClient;
  });
  var __pika_web_default_export_for_treeshaking__ = /* @__PURE__ */ getDefaultExportFromCjs(lib);
  var keycloak_admin_client_default = __pika_web_default_export_for_treeshaking__;
});

// build/_snowpack/env.js
var env_exports = {};
__export(env_exports, {
  MODE: () => MODE,
  NODE_ENV: () => NODE_ENV,
  SSR: () => SSR
});
var MODE = "production";
var NODE_ENV = "production";
var SSR = false;

// build/_snowpack/pkg/common/_commonjsHelpers-4f955397.js
var commonjsGlobal = typeof globalThis !== "undefined" ? globalThis : typeof window !== "undefined" ? window : typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : {};
function getDefaultExportFromCjs(x2) {
  return x2 && x2.__esModule && Object.prototype.hasOwnProperty.call(x2, "default") ? x2["default"] : x2;
}
function createCommonjsModule(fn, basedir, module2) {
  return module2 = {
    path: basedir,
    exports: {},
    require: function(path, base) {
      return commonjsRequire(path, base === void 0 || base === null ? module2.path : base);
    }
  }, fn(module2, module2.exports), module2.exports;
}
function commonjsRequire() {
  throw new Error("Dynamic requires are not currently supported by @rollup/plugin-commonjs");
}

// build/_snowpack/pkg/common/index-7cda8b13.js
/*
object-assign
(c) Sindre Sorhus
@license MIT
*/
var getOwnPropertySymbols = Object.getOwnPropertySymbols;
var hasOwnProperty = Object.prototype.hasOwnProperty;
var propIsEnumerable = Object.prototype.propertyIsEnumerable;
function toObject(val) {
  if (val === null || val === void 0) {
    throw new TypeError("Object.assign cannot be called with null or undefined");
  }
  return Object(val);
}
function shouldUseNative() {
  try {
    if (!Object.assign) {
      return false;
    }
    var test1 = new String("abc");
    test1[5] = "de";
    if (Object.getOwnPropertyNames(test1)[0] === "5") {
      return false;
    }
    var test2 = {};
    for (var i3 = 0; i3 < 10; i3++) {
      test2["_" + String.fromCharCode(i3)] = i3;
    }
    var order22 = Object.getOwnPropertyNames(test2).map(function(n3) {
      return test2[n3];
    });
    if (order22.join("") !== "0123456789") {
      return false;
    }
    var test3 = {};
    "abcdefghijklmnopqrst".split("").forEach(function(letter) {
      test3[letter] = letter;
    });
    if (Object.keys(Object.assign({}, test3)).join("") !== "abcdefghijklmnopqrst") {
      return false;
    }
    return true;
  } catch (err) {
    return false;
  }
}
var objectAssign = shouldUseNative() ? Object.assign : function(target, source2) {
  var from;
  var to = toObject(target);
  var symbols;
  for (var s2 = 1; s2 < arguments.length; s2++) {
    from = Object(arguments[s2]);
    for (var key in from) {
      if (hasOwnProperty.call(from, key)) {
        to[key] = from[key];
      }
    }
    if (getOwnPropertySymbols) {
      symbols = getOwnPropertySymbols(from);
      for (var i3 = 0; i3 < symbols.length; i3++) {
        if (propIsEnumerable.call(from, symbols[i3])) {
          to[symbols[i3]] = from[symbols[i3]];
        }
      }
    }
  }
  return to;
};
var react_production_min = createCommonjsModule(function(module2, exports2) {
  var n3 = 60103, p2 = 60106;
  exports2.Fragment = 60107;
  exports2.StrictMode = 60108;
  exports2.Profiler = 60114;
  var q2 = 60109, r3 = 60110, t5 = 60112;
  exports2.Suspense = 60113;
  var u = 60115, v2 = 60116;
  if (typeof Symbol === "function" && Symbol.for) {
    var w2 = Symbol.for;
    n3 = w2("react.element");
    p2 = w2("react.portal");
    exports2.Fragment = w2("react.fragment");
    exports2.StrictMode = w2("react.strict_mode");
    exports2.Profiler = w2("react.profiler");
    q2 = w2("react.provider");
    r3 = w2("react.context");
    t5 = w2("react.forward_ref");
    exports2.Suspense = w2("react.suspense");
    u = w2("react.memo");
    v2 = w2("react.lazy");
  }
  var x2 = typeof Symbol === "function" && Symbol.iterator;
  function y3(a2) {
    if (a2 === null || typeof a2 !== "object")
      return null;
    a2 = x2 && a2[x2] || a2["@@iterator"];
    return typeof a2 === "function" ? a2 : null;
  }
  function z2(a2) {
    for (var b2 = "https://reactjs.org/docs/error-decoder.html?invariant=" + a2, c3 = 1; c3 < arguments.length; c3++)
      b2 += "&args[]=" + encodeURIComponent(arguments[c3]);
    return "Minified React error #" + a2 + "; visit " + b2 + " for the full message or use the non-minified dev environment for full errors and additional helpful warnings.";
  }
  var A2 = {isMounted: function() {
    return false;
  }, enqueueForceUpdate: function() {
  }, enqueueReplaceState: function() {
  }, enqueueSetState: function() {
  }}, B2 = {};
  function C(a2, b2, c3) {
    this.props = a2;
    this.context = b2;
    this.refs = B2;
    this.updater = c3 || A2;
  }
  C.prototype.isReactComponent = {};
  C.prototype.setState = function(a2, b2) {
    if (typeof a2 !== "object" && typeof a2 !== "function" && a2 != null)
      throw Error(z2(85));
    this.updater.enqueueSetState(this, a2, b2, "setState");
  };
  C.prototype.forceUpdate = function(a2) {
    this.updater.enqueueForceUpdate(this, a2, "forceUpdate");
  };
  function D2() {
  }
  D2.prototype = C.prototype;
  function E(a2, b2, c3) {
    this.props = a2;
    this.context = b2;
    this.refs = B2;
    this.updater = c3 || A2;
  }
  var F2 = E.prototype = new D2();
  F2.constructor = E;
  objectAssign(F2, C.prototype);
  F2.isPureReactComponent = true;
  var G2 = {current: null}, H2 = Object.prototype.hasOwnProperty, I2 = {key: true, ref: true, __self: true, __source: true};
  function J(a2, b2, c3) {
    var e2, d2 = {}, k2 = null, h2 = null;
    if (b2 != null)
      for (e2 in b2.ref !== void 0 && (h2 = b2.ref), b2.key !== void 0 && (k2 = "" + b2.key), b2)
        H2.call(b2, e2) && !I2.hasOwnProperty(e2) && (d2[e2] = b2[e2]);
    var g2 = arguments.length - 2;
    if (g2 === 1)
      d2.children = c3;
    else if (1 < g2) {
      for (var f2 = Array(g2), m2 = 0; m2 < g2; m2++)
        f2[m2] = arguments[m2 + 2];
      d2.children = f2;
    }
    if (a2 && a2.defaultProps)
      for (e2 in g2 = a2.defaultProps, g2)
        d2[e2] === void 0 && (d2[e2] = g2[e2]);
    return {$$typeof: n3, type: a2, key: k2, ref: h2, props: d2, _owner: G2.current};
  }
  function K(a2, b2) {
    return {$$typeof: n3, type: a2.type, key: b2, ref: a2.ref, props: a2.props, _owner: a2._owner};
  }
  function L(a2) {
    return typeof a2 === "object" && a2 !== null && a2.$$typeof === n3;
  }
  function escape4(a2) {
    var b2 = {"=": "=0", ":": "=2"};
    return "$" + a2.replace(/[=:]/g, function(a3) {
      return b2[a3];
    });
  }
  var M2 = /\/+/g;
  function N2(a2, b2) {
    return typeof a2 === "object" && a2 !== null && a2.key != null ? escape4("" + a2.key) : b2.toString(36);
  }
  function O2(a2, b2, c3, e2, d2) {
    var k2 = typeof a2;
    if (k2 === "undefined" || k2 === "boolean")
      a2 = null;
    var h2 = false;
    if (a2 === null)
      h2 = true;
    else
      switch (k2) {
        case "string":
        case "number":
          h2 = true;
          break;
        case "object":
          switch (a2.$$typeof) {
            case n3:
            case p2:
              h2 = true;
          }
      }
    if (h2)
      return h2 = a2, d2 = d2(h2), a2 = e2 === "" ? "." + N2(h2, 0) : e2, Array.isArray(d2) ? (c3 = "", a2 != null && (c3 = a2.replace(M2, "$&/") + "/"), O2(d2, b2, c3, "", function(a3) {
        return a3;
      })) : d2 != null && (L(d2) && (d2 = K(d2, c3 + (!d2.key || h2 && h2.key === d2.key ? "" : ("" + d2.key).replace(M2, "$&/") + "/") + a2)), b2.push(d2)), 1;
    h2 = 0;
    e2 = e2 === "" ? "." : e2 + ":";
    if (Array.isArray(a2))
      for (var g2 = 0; g2 < a2.length; g2++) {
        k2 = a2[g2];
        var f2 = e2 + N2(k2, g2);
        h2 += O2(k2, b2, c3, f2, d2);
      }
    else if (f2 = y3(a2), typeof f2 === "function")
      for (a2 = f2.call(a2), g2 = 0; !(k2 = a2.next()).done; )
        k2 = k2.value, f2 = e2 + N2(k2, g2++), h2 += O2(k2, b2, c3, f2, d2);
    else if (k2 === "object")
      throw b2 = "" + a2, Error(z2(31, b2 === "[object Object]" ? "object with keys {" + Object.keys(a2).join(", ") + "}" : b2));
    return h2;
  }
  function P2(a2, b2, c3) {
    if (a2 == null)
      return a2;
    var e2 = [], d2 = 0;
    O2(a2, e2, "", "", function(a3) {
      return b2.call(c3, a3, d2++);
    });
    return e2;
  }
  function Q(a2) {
    if (a2._status === -1) {
      var b2 = a2._result;
      b2 = b2();
      a2._status = 0;
      a2._result = b2;
      b2.then(function(b3) {
        a2._status === 0 && (b3 = b3.default, a2._status = 1, a2._result = b3);
      }, function(b3) {
        a2._status === 0 && (a2._status = 2, a2._result = b3);
      });
    }
    if (a2._status === 1)
      return a2._result;
    throw a2._result;
  }
  var R2 = {current: null};
  function S2() {
    var a2 = R2.current;
    if (a2 === null)
      throw Error(z2(321));
    return a2;
  }
  var T6 = {ReactCurrentDispatcher: R2, ReactCurrentBatchConfig: {transition: 0}, ReactCurrentOwner: G2, IsSomeRendererActing: {current: false}, assign: objectAssign};
  exports2.Children = {map: P2, forEach: function(a2, b2, c3) {
    P2(a2, function() {
      b2.apply(this, arguments);
    }, c3);
  }, count: function(a2) {
    var b2 = 0;
    P2(a2, function() {
      b2++;
    });
    return b2;
  }, toArray: function(a2) {
    return P2(a2, function(a3) {
      return a3;
    }) || [];
  }, only: function(a2) {
    if (!L(a2))
      throw Error(z2(143));
    return a2;
  }};
  exports2.Component = C;
  exports2.PureComponent = E;
  exports2.__SECRET_INTERNALS_DO_NOT_USE_OR_YOU_WILL_BE_FIRED = T6;
  exports2.cloneElement = function(a2, b2, c3) {
    if (a2 === null || a2 === void 0)
      throw Error(z2(267, a2));
    var e2 = objectAssign({}, a2.props), d2 = a2.key, k2 = a2.ref, h2 = a2._owner;
    if (b2 != null) {
      b2.ref !== void 0 && (k2 = b2.ref, h2 = G2.current);
      b2.key !== void 0 && (d2 = "" + b2.key);
      if (a2.type && a2.type.defaultProps)
        var g2 = a2.type.defaultProps;
      for (f2 in b2)
        H2.call(b2, f2) && !I2.hasOwnProperty(f2) && (e2[f2] = b2[f2] === void 0 && g2 !== void 0 ? g2[f2] : b2[f2]);
    }
    var f2 = arguments.length - 2;
    if (f2 === 1)
      e2.children = c3;
    else if (1 < f2) {
      g2 = Array(f2);
      for (var m2 = 0; m2 < f2; m2++)
        g2[m2] = arguments[m2 + 2];
      e2.children = g2;
    }
    return {
      $$typeof: n3,
      type: a2.type,
      key: d2,
      ref: k2,
      props: e2,
      _owner: h2
    };
  };
  exports2.createContext = function(a2, b2) {
    b2 === void 0 && (b2 = null);
    a2 = {$$typeof: r3, _calculateChangedBits: b2, _currentValue: a2, _currentValue2: a2, _threadCount: 0, Provider: null, Consumer: null};
    a2.Provider = {$$typeof: q2, _context: a2};
    return a2.Consumer = a2;
  };
  exports2.createElement = J;
  exports2.createFactory = function(a2) {
    var b2 = J.bind(null, a2);
    b2.type = a2;
    return b2;
  };
  exports2.createRef = function() {
    return {current: null};
  };
  exports2.forwardRef = function(a2) {
    return {$$typeof: t5, render: a2};
  };
  exports2.isValidElement = L;
  exports2.lazy = function(a2) {
    return {$$typeof: v2, _payload: {_status: -1, _result: a2}, _init: Q};
  };
  exports2.memo = function(a2, b2) {
    return {$$typeof: u, type: a2, compare: b2 === void 0 ? null : b2};
  };
  exports2.useCallback = function(a2, b2) {
    return S2().useCallback(a2, b2);
  };
  exports2.useContext = function(a2, b2) {
    return S2().useContext(a2, b2);
  };
  exports2.useDebugValue = function() {
  };
  exports2.useEffect = function(a2, b2) {
    return S2().useEffect(a2, b2);
  };
  exports2.useImperativeHandle = function(a2, b2, c3) {
    return S2().useImperativeHandle(a2, b2, c3);
  };
  exports2.useLayoutEffect = function(a2, b2) {
    return S2().useLayoutEffect(a2, b2);
  };
  exports2.useMemo = function(a2, b2) {
    return S2().useMemo(a2, b2);
  };
  exports2.useReducer = function(a2, b2, c3) {
    return S2().useReducer(a2, b2, c3);
  };
  exports2.useRef = function(a2) {
    return S2().useRef(a2);
  };
  exports2.useState = function(a2) {
    return S2().useState(a2);
  };
  exports2.version = "17.0.2";
});
var react = createCommonjsModule(function(module2) {
  {
    module2.exports = react_production_min;
  }
});

// build/_snowpack/pkg/react.js
var Children = react.Children;
var Fragment = react.Fragment;
var StrictMode = react.StrictMode;
var Suspense = react.Suspense;
var cloneElement = react.cloneElement;
var createContext = react.createContext;
var isValidElement = react.isValidElement;
var lazy = react.lazy;
var memo = react.memo;
var useCallback = react.useCallback;
var useContext = react.useContext;
var useEffect = react.useEffect;
var useMemo = react.useMemo;
var useRef = react.useRef;
var useState = react.useState;

// build/_snowpack/pkg/common/index-916de6ed.js
var scheduler_production_min = createCommonjsModule(function(module2, exports2) {
  var f2, g2, h2, k2;
  if (typeof performance === "object" && typeof performance.now === "function") {
    var l2 = performance;
    exports2.unstable_now = function() {
      return l2.now();
    };
  } else {
    var p2 = Date, q2 = p2.now();
    exports2.unstable_now = function() {
      return p2.now() - q2;
    };
  }
  if (typeof window === "undefined" || typeof MessageChannel !== "function") {
    var t5 = null, u = null, w2 = function() {
      if (t5 !== null)
        try {
          var a2 = exports2.unstable_now();
          t5(true, a2);
          t5 = null;
        } catch (b2) {
          throw setTimeout(w2, 0), b2;
        }
    };
    f2 = function(a2) {
      t5 !== null ? setTimeout(f2, 0, a2) : (t5 = a2, setTimeout(w2, 0));
    };
    g2 = function(a2, b2) {
      u = setTimeout(a2, b2);
    };
    h2 = function() {
      clearTimeout(u);
    };
    exports2.unstable_shouldYield = function() {
      return false;
    };
    k2 = exports2.unstable_forceFrameRate = function() {
    };
  } else {
    var x2 = window.setTimeout, y3 = window.clearTimeout;
    if (typeof console !== "undefined") {
      var z2 = window.cancelAnimationFrame;
      typeof window.requestAnimationFrame !== "function" && console.error("This browser doesn't support requestAnimationFrame. Make sure that you load a polyfill in older browsers. https://reactjs.org/link/react-polyfills");
      typeof z2 !== "function" && console.error("This browser doesn't support cancelAnimationFrame. Make sure that you load a polyfill in older browsers. https://reactjs.org/link/react-polyfills");
    }
    var A2 = false, B2 = null, C = -1, D2 = 5, E = 0;
    exports2.unstable_shouldYield = function() {
      return exports2.unstable_now() >= E;
    };
    k2 = function() {
    };
    exports2.unstable_forceFrameRate = function(a2) {
      0 > a2 || 125 < a2 ? console.error("forceFrameRate takes a positive int between 0 and 125, forcing frame rates higher than 125 fps is not supported") : D2 = 0 < a2 ? Math.floor(1e3 / a2) : 5;
    };
    var F2 = new MessageChannel(), G2 = F2.port2;
    F2.port1.onmessage = function() {
      if (B2 !== null) {
        var a2 = exports2.unstable_now();
        E = a2 + D2;
        try {
          B2(true, a2) ? G2.postMessage(null) : (A2 = false, B2 = null);
        } catch (b2) {
          throw G2.postMessage(null), b2;
        }
      } else
        A2 = false;
    };
    f2 = function(a2) {
      B2 = a2;
      A2 || (A2 = true, G2.postMessage(null));
    };
    g2 = function(a2, b2) {
      C = x2(function() {
        a2(exports2.unstable_now());
      }, b2);
    };
    h2 = function() {
      y3(C);
      C = -1;
    };
  }
  function H2(a2, b2) {
    var c3 = a2.length;
    a2.push(b2);
    a:
      for (; ; ) {
        var d2 = c3 - 1 >>> 1, e2 = a2[d2];
        if (e2 !== void 0 && 0 < I2(e2, b2))
          a2[d2] = b2, a2[c3] = e2, c3 = d2;
        else
          break a;
      }
  }
  function J(a2) {
    a2 = a2[0];
    return a2 === void 0 ? null : a2;
  }
  function K(a2) {
    var b2 = a2[0];
    if (b2 !== void 0) {
      var c3 = a2.pop();
      if (c3 !== b2) {
        a2[0] = c3;
        a:
          for (var d2 = 0, e2 = a2.length; d2 < e2; ) {
            var m2 = 2 * (d2 + 1) - 1, n3 = a2[m2], v2 = m2 + 1, r3 = a2[v2];
            if (n3 !== void 0 && 0 > I2(n3, c3))
              r3 !== void 0 && 0 > I2(r3, n3) ? (a2[d2] = r3, a2[v2] = c3, d2 = v2) : (a2[d2] = n3, a2[m2] = c3, d2 = m2);
            else if (r3 !== void 0 && 0 > I2(r3, c3))
              a2[d2] = r3, a2[v2] = c3, d2 = v2;
            else
              break a;
          }
      }
      return b2;
    }
    return null;
  }
  function I2(a2, b2) {
    var c3 = a2.sortIndex - b2.sortIndex;
    return c3 !== 0 ? c3 : a2.id - b2.id;
  }
  var L = [], M2 = [], N2 = 1, O2 = null, P2 = 3, Q = false, R2 = false, S2 = false;
  function T6(a2) {
    for (var b2 = J(M2); b2 !== null; ) {
      if (b2.callback === null)
        K(M2);
      else if (b2.startTime <= a2)
        K(M2), b2.sortIndex = b2.expirationTime, H2(L, b2);
      else
        break;
      b2 = J(M2);
    }
  }
  function U2(a2) {
    S2 = false;
    T6(a2);
    if (!R2)
      if (J(L) !== null)
        R2 = true, f2(V2);
      else {
        var b2 = J(M2);
        b2 !== null && g2(U2, b2.startTime - a2);
      }
  }
  function V2(a2, b2) {
    R2 = false;
    S2 && (S2 = false, h2());
    Q = true;
    var c3 = P2;
    try {
      T6(b2);
      for (O2 = J(L); O2 !== null && (!(O2.expirationTime > b2) || a2 && !exports2.unstable_shouldYield()); ) {
        var d2 = O2.callback;
        if (typeof d2 === "function") {
          O2.callback = null;
          P2 = O2.priorityLevel;
          var e2 = d2(O2.expirationTime <= b2);
          b2 = exports2.unstable_now();
          typeof e2 === "function" ? O2.callback = e2 : O2 === J(L) && K(L);
          T6(b2);
        } else
          K(L);
        O2 = J(L);
      }
      if (O2 !== null)
        var m2 = true;
      else {
        var n3 = J(M2);
        n3 !== null && g2(U2, n3.startTime - b2);
        m2 = false;
      }
      return m2;
    } finally {
      O2 = null, P2 = c3, Q = false;
    }
  }
  var W2 = k2;
  exports2.unstable_IdlePriority = 5;
  exports2.unstable_ImmediatePriority = 1;
  exports2.unstable_LowPriority = 4;
  exports2.unstable_NormalPriority = 3;
  exports2.unstable_Profiling = null;
  exports2.unstable_UserBlockingPriority = 2;
  exports2.unstable_cancelCallback = function(a2) {
    a2.callback = null;
  };
  exports2.unstable_continueExecution = function() {
    R2 || Q || (R2 = true, f2(V2));
  };
  exports2.unstable_getCurrentPriorityLevel = function() {
    return P2;
  };
  exports2.unstable_getFirstCallbackNode = function() {
    return J(L);
  };
  exports2.unstable_next = function(a2) {
    switch (P2) {
      case 1:
      case 2:
      case 3:
        var b2 = 3;
        break;
      default:
        b2 = P2;
    }
    var c3 = P2;
    P2 = b2;
    try {
      return a2();
    } finally {
      P2 = c3;
    }
  };
  exports2.unstable_pauseExecution = function() {
  };
  exports2.unstable_requestPaint = W2;
  exports2.unstable_runWithPriority = function(a2, b2) {
    switch (a2) {
      case 1:
      case 2:
      case 3:
      case 4:
      case 5:
        break;
      default:
        a2 = 3;
    }
    var c3 = P2;
    P2 = a2;
    try {
      return b2();
    } finally {
      P2 = c3;
    }
  };
  exports2.unstable_scheduleCallback = function(a2, b2, c3) {
    var d2 = exports2.unstable_now();
    typeof c3 === "object" && c3 !== null ? (c3 = c3.delay, c3 = typeof c3 === "number" && 0 < c3 ? d2 + c3 : d2) : c3 = d2;
    switch (a2) {
      case 1:
        var e2 = -1;
        break;
      case 2:
        e2 = 250;
        break;
      case 5:
        e2 = 1073741823;
        break;
      case 4:
        e2 = 1e4;
        break;
      default:
        e2 = 5e3;
    }
    e2 = c3 + e2;
    a2 = {id: N2++, callback: b2, priorityLevel: a2, startTime: c3, expirationTime: e2, sortIndex: -1};
    c3 > d2 ? (a2.sortIndex = c3, H2(M2, a2), J(L) === null && a2 === J(M2) && (S2 ? h2() : S2 = true, g2(U2, c3 - d2))) : (a2.sortIndex = e2, H2(L, a2), R2 || Q || (R2 = true, f2(V2)));
    return a2;
  };
  exports2.unstable_wrapCallback = function(a2) {
    var b2 = P2;
    return function() {
      var c3 = P2;
      P2 = b2;
      try {
        return a2.apply(this, arguments);
      } finally {
        P2 = c3;
      }
    };
  };
});
var scheduler = createCommonjsModule(function(module2) {
  {
    module2.exports = scheduler_production_min;
  }
});
function y(a2) {
  for (var b2 = "https://reactjs.org/docs/error-decoder.html?invariant=" + a2, c3 = 1; c3 < arguments.length; c3++)
    b2 += "&args[]=" + encodeURIComponent(arguments[c3]);
  return "Minified React error #" + a2 + "; visit " + b2 + " for the full message or use the non-minified dev environment for full errors and additional helpful warnings.";
}
if (!react)
  throw Error(y(227));
var ba = new Set();
var ca = {};
function da(a2, b2) {
  ea(a2, b2);
  ea(a2 + "Capture", b2);
}
function ea(a2, b2) {
  ca[a2] = b2;
  for (a2 = 0; a2 < b2.length; a2++)
    ba.add(b2[a2]);
}
var fa = !(typeof window === "undefined" || typeof window.document === "undefined" || typeof window.document.createElement === "undefined");
var ha = /^[:A-Z_a-z\u00C0-\u00D6\u00D8-\u00F6\u00F8-\u02FF\u0370-\u037D\u037F-\u1FFF\u200C-\u200D\u2070-\u218F\u2C00-\u2FEF\u3001-\uD7FF\uF900-\uFDCF\uFDF0-\uFFFD][:A-Z_a-z\u00C0-\u00D6\u00D8-\u00F6\u00F8-\u02FF\u0370-\u037D\u037F-\u1FFF\u200C-\u200D\u2070-\u218F\u2C00-\u2FEF\u3001-\uD7FF\uF900-\uFDCF\uFDF0-\uFFFD\-.0-9\u00B7\u0300-\u036F\u203F-\u2040]*$/;
var ia = Object.prototype.hasOwnProperty;
var ja = {};
var ka = {};
function la(a2) {
  if (ia.call(ka, a2))
    return true;
  if (ia.call(ja, a2))
    return false;
  if (ha.test(a2))
    return ka[a2] = true;
  ja[a2] = true;
  return false;
}
function ma(a2, b2, c3, d2) {
  if (c3 !== null && c3.type === 0)
    return false;
  switch (typeof b2) {
    case "function":
    case "symbol":
      return true;
    case "boolean":
      if (d2)
        return false;
      if (c3 !== null)
        return !c3.acceptsBooleans;
      a2 = a2.toLowerCase().slice(0, 5);
      return a2 !== "data-" && a2 !== "aria-";
    default:
      return false;
  }
}
function na(a2, b2, c3, d2) {
  if (b2 === null || typeof b2 === "undefined" || ma(a2, b2, c3, d2))
    return true;
  if (d2)
    return false;
  if (c3 !== null)
    switch (c3.type) {
      case 3:
        return !b2;
      case 4:
        return b2 === false;
      case 5:
        return isNaN(b2);
      case 6:
        return isNaN(b2) || 1 > b2;
    }
  return false;
}
function B(a2, b2, c3, d2, e2, f2, g2) {
  this.acceptsBooleans = b2 === 2 || b2 === 3 || b2 === 4;
  this.attributeName = d2;
  this.attributeNamespace = e2;
  this.mustUseProperty = c3;
  this.propertyName = a2;
  this.type = b2;
  this.sanitizeURL = f2;
  this.removeEmptyString = g2;
}
var D = {};
"children dangerouslySetInnerHTML defaultValue defaultChecked innerHTML suppressContentEditableWarning suppressHydrationWarning style".split(" ").forEach(function(a2) {
  D[a2] = new B(a2, 0, false, a2, null, false, false);
});
[["acceptCharset", "accept-charset"], ["className", "class"], ["htmlFor", "for"], ["httpEquiv", "http-equiv"]].forEach(function(a2) {
  var b2 = a2[0];
  D[b2] = new B(b2, 1, false, a2[1], null, false, false);
});
["contentEditable", "draggable", "spellCheck", "value"].forEach(function(a2) {
  D[a2] = new B(a2, 2, false, a2.toLowerCase(), null, false, false);
});
["autoReverse", "externalResourcesRequired", "focusable", "preserveAlpha"].forEach(function(a2) {
  D[a2] = new B(a2, 2, false, a2, null, false, false);
});
"allowFullScreen async autoFocus autoPlay controls default defer disabled disablePictureInPicture disableRemotePlayback formNoValidate hidden loop noModule noValidate open playsInline readOnly required reversed scoped seamless itemScope".split(" ").forEach(function(a2) {
  D[a2] = new B(a2, 3, false, a2.toLowerCase(), null, false, false);
});
["checked", "multiple", "muted", "selected"].forEach(function(a2) {
  D[a2] = new B(a2, 3, true, a2, null, false, false);
});
["capture", "download"].forEach(function(a2) {
  D[a2] = new B(a2, 4, false, a2, null, false, false);
});
["cols", "rows", "size", "span"].forEach(function(a2) {
  D[a2] = new B(a2, 6, false, a2, null, false, false);
});
["rowSpan", "start"].forEach(function(a2) {
  D[a2] = new B(a2, 5, false, a2.toLowerCase(), null, false, false);
});
var oa = /[\-:]([a-z])/g;
function pa(a2) {
  return a2[1].toUpperCase();
}
"accent-height alignment-baseline arabic-form baseline-shift cap-height clip-path clip-rule color-interpolation color-interpolation-filters color-profile color-rendering dominant-baseline enable-background fill-opacity fill-rule flood-color flood-opacity font-family font-size font-size-adjust font-stretch font-style font-variant font-weight glyph-name glyph-orientation-horizontal glyph-orientation-vertical horiz-adv-x horiz-origin-x image-rendering letter-spacing lighting-color marker-end marker-mid marker-start overline-position overline-thickness paint-order panose-1 pointer-events rendering-intent shape-rendering stop-color stop-opacity strikethrough-position strikethrough-thickness stroke-dasharray stroke-dashoffset stroke-linecap stroke-linejoin stroke-miterlimit stroke-opacity stroke-width text-anchor text-decoration text-rendering underline-position underline-thickness unicode-bidi unicode-range units-per-em v-alphabetic v-hanging v-ideographic v-mathematical vector-effect vert-adv-y vert-origin-x vert-origin-y word-spacing writing-mode xmlns:xlink x-height".split(" ").forEach(function(a2) {
  var b2 = a2.replace(oa, pa);
  D[b2] = new B(b2, 1, false, a2, null, false, false);
});
"xlink:actuate xlink:arcrole xlink:role xlink:show xlink:title xlink:type".split(" ").forEach(function(a2) {
  var b2 = a2.replace(oa, pa);
  D[b2] = new B(b2, 1, false, a2, "http://www.w3.org/1999/xlink", false, false);
});
["xml:base", "xml:lang", "xml:space"].forEach(function(a2) {
  var b2 = a2.replace(oa, pa);
  D[b2] = new B(b2, 1, false, a2, "http://www.w3.org/XML/1998/namespace", false, false);
});
["tabIndex", "crossOrigin"].forEach(function(a2) {
  D[a2] = new B(a2, 1, false, a2.toLowerCase(), null, false, false);
});
D.xlinkHref = new B("xlinkHref", 1, false, "xlink:href", "http://www.w3.org/1999/xlink", true, false);
["src", "href", "action", "formAction"].forEach(function(a2) {
  D[a2] = new B(a2, 1, false, a2.toLowerCase(), null, true, true);
});
function qa(a2, b2, c3, d2) {
  var e2 = D.hasOwnProperty(b2) ? D[b2] : null;
  var f2 = e2 !== null ? e2.type === 0 : d2 ? false : !(2 < b2.length) || b2[0] !== "o" && b2[0] !== "O" || b2[1] !== "n" && b2[1] !== "N" ? false : true;
  f2 || (na(b2, c3, e2, d2) && (c3 = null), d2 || e2 === null ? la(b2) && (c3 === null ? a2.removeAttribute(b2) : a2.setAttribute(b2, "" + c3)) : e2.mustUseProperty ? a2[e2.propertyName] = c3 === null ? e2.type === 3 ? false : "" : c3 : (b2 = e2.attributeName, d2 = e2.attributeNamespace, c3 === null ? a2.removeAttribute(b2) : (e2 = e2.type, c3 = e2 === 3 || e2 === 4 && c3 === true ? "" : "" + c3, d2 ? a2.setAttributeNS(d2, b2, c3) : a2.setAttribute(b2, c3))));
}
var ra = react.__SECRET_INTERNALS_DO_NOT_USE_OR_YOU_WILL_BE_FIRED;
var sa = 60103;
var ta = 60106;
var ua = 60107;
var wa = 60108;
var xa = 60114;
var ya = 60109;
var za = 60110;
var Aa = 60112;
var Ba = 60113;
var Ca = 60120;
var Da = 60115;
var Ea = 60116;
var Fa = 60121;
var Ga = 60128;
var Ha = 60129;
var Ia = 60130;
var Ja = 60131;
if (typeof Symbol === "function" && Symbol.for) {
  E = Symbol.for;
  sa = E("react.element");
  ta = E("react.portal");
  ua = E("react.fragment");
  wa = E("react.strict_mode");
  xa = E("react.profiler");
  ya = E("react.provider");
  za = E("react.context");
  Aa = E("react.forward_ref");
  Ba = E("react.suspense");
  Ca = E("react.suspense_list");
  Da = E("react.memo");
  Ea = E("react.lazy");
  Fa = E("react.block");
  E("react.scope");
  Ga = E("react.opaque.id");
  Ha = E("react.debug_trace_mode");
  Ia = E("react.offscreen");
  Ja = E("react.legacy_hidden");
}
var E;
var Ka = typeof Symbol === "function" && Symbol.iterator;
function La(a2) {
  if (a2 === null || typeof a2 !== "object")
    return null;
  a2 = Ka && a2[Ka] || a2["@@iterator"];
  return typeof a2 === "function" ? a2 : null;
}
var Ma;
function Na(a2) {
  if (Ma === void 0)
    try {
      throw Error();
    } catch (c3) {
      var b2 = c3.stack.trim().match(/\n( *(at )?)/);
      Ma = b2 && b2[1] || "";
    }
  return "\n" + Ma + a2;
}
var Oa = false;
function Pa(a2, b2) {
  if (!a2 || Oa)
    return "";
  Oa = true;
  var c3 = Error.prepareStackTrace;
  Error.prepareStackTrace = void 0;
  try {
    if (b2)
      if (b2 = function() {
        throw Error();
      }, Object.defineProperty(b2.prototype, "props", {set: function() {
        throw Error();
      }}), typeof Reflect === "object" && Reflect.construct) {
        try {
          Reflect.construct(b2, []);
        } catch (k2) {
          var d2 = k2;
        }
        Reflect.construct(a2, [], b2);
      } else {
        try {
          b2.call();
        } catch (k2) {
          d2 = k2;
        }
        a2.call(b2.prototype);
      }
    else {
      try {
        throw Error();
      } catch (k2) {
        d2 = k2;
      }
      a2();
    }
  } catch (k2) {
    if (k2 && d2 && typeof k2.stack === "string") {
      for (var e2 = k2.stack.split("\n"), f2 = d2.stack.split("\n"), g2 = e2.length - 1, h2 = f2.length - 1; 1 <= g2 && 0 <= h2 && e2[g2] !== f2[h2]; )
        h2--;
      for (; 1 <= g2 && 0 <= h2; g2--, h2--)
        if (e2[g2] !== f2[h2]) {
          if (g2 !== 1 || h2 !== 1) {
            do
              if (g2--, h2--, 0 > h2 || e2[g2] !== f2[h2])
                return "\n" + e2[g2].replace(" at new ", " at ");
            while (1 <= g2 && 0 <= h2);
          }
          break;
        }
    }
  } finally {
    Oa = false, Error.prepareStackTrace = c3;
  }
  return (a2 = a2 ? a2.displayName || a2.name : "") ? Na(a2) : "";
}
function Qa(a2) {
  switch (a2.tag) {
    case 5:
      return Na(a2.type);
    case 16:
      return Na("Lazy");
    case 13:
      return Na("Suspense");
    case 19:
      return Na("SuspenseList");
    case 0:
    case 2:
    case 15:
      return a2 = Pa(a2.type, false), a2;
    case 11:
      return a2 = Pa(a2.type.render, false), a2;
    case 22:
      return a2 = Pa(a2.type._render, false), a2;
    case 1:
      return a2 = Pa(a2.type, true), a2;
    default:
      return "";
  }
}
function Ra(a2) {
  if (a2 == null)
    return null;
  if (typeof a2 === "function")
    return a2.displayName || a2.name || null;
  if (typeof a2 === "string")
    return a2;
  switch (a2) {
    case ua:
      return "Fragment";
    case ta:
      return "Portal";
    case xa:
      return "Profiler";
    case wa:
      return "StrictMode";
    case Ba:
      return "Suspense";
    case Ca:
      return "SuspenseList";
  }
  if (typeof a2 === "object")
    switch (a2.$$typeof) {
      case za:
        return (a2.displayName || "Context") + ".Consumer";
      case ya:
        return (a2._context.displayName || "Context") + ".Provider";
      case Aa:
        var b2 = a2.render;
        b2 = b2.displayName || b2.name || "";
        return a2.displayName || (b2 !== "" ? "ForwardRef(" + b2 + ")" : "ForwardRef");
      case Da:
        return Ra(a2.type);
      case Fa:
        return Ra(a2._render);
      case Ea:
        b2 = a2._payload;
        a2 = a2._init;
        try {
          return Ra(a2(b2));
        } catch (c3) {
        }
    }
  return null;
}
function Sa(a2) {
  switch (typeof a2) {
    case "boolean":
    case "number":
    case "object":
    case "string":
    case "undefined":
      return a2;
    default:
      return "";
  }
}
function Ta(a2) {
  var b2 = a2.type;
  return (a2 = a2.nodeName) && a2.toLowerCase() === "input" && (b2 === "checkbox" || b2 === "radio");
}
function Ua(a2) {
  var b2 = Ta(a2) ? "checked" : "value", c3 = Object.getOwnPropertyDescriptor(a2.constructor.prototype, b2), d2 = "" + a2[b2];
  if (!a2.hasOwnProperty(b2) && typeof c3 !== "undefined" && typeof c3.get === "function" && typeof c3.set === "function") {
    var e2 = c3.get, f2 = c3.set;
    Object.defineProperty(a2, b2, {configurable: true, get: function() {
      return e2.call(this);
    }, set: function(a3) {
      d2 = "" + a3;
      f2.call(this, a3);
    }});
    Object.defineProperty(a2, b2, {enumerable: c3.enumerable});
    return {getValue: function() {
      return d2;
    }, setValue: function(a3) {
      d2 = "" + a3;
    }, stopTracking: function() {
      a2._valueTracker = null;
      delete a2[b2];
    }};
  }
}
function Va(a2) {
  a2._valueTracker || (a2._valueTracker = Ua(a2));
}
function Wa(a2) {
  if (!a2)
    return false;
  var b2 = a2._valueTracker;
  if (!b2)
    return true;
  var c3 = b2.getValue();
  var d2 = "";
  a2 && (d2 = Ta(a2) ? a2.checked ? "true" : "false" : a2.value);
  a2 = d2;
  return a2 !== c3 ? (b2.setValue(a2), true) : false;
}
function Xa(a2) {
  a2 = a2 || (typeof document !== "undefined" ? document : void 0);
  if (typeof a2 === "undefined")
    return null;
  try {
    return a2.activeElement || a2.body;
  } catch (b2) {
    return a2.body;
  }
}
function Ya(a2, b2) {
  var c3 = b2.checked;
  return objectAssign({}, b2, {defaultChecked: void 0, defaultValue: void 0, value: void 0, checked: c3 != null ? c3 : a2._wrapperState.initialChecked});
}
function Za(a2, b2) {
  var c3 = b2.defaultValue == null ? "" : b2.defaultValue, d2 = b2.checked != null ? b2.checked : b2.defaultChecked;
  c3 = Sa(b2.value != null ? b2.value : c3);
  a2._wrapperState = {initialChecked: d2, initialValue: c3, controlled: b2.type === "checkbox" || b2.type === "radio" ? b2.checked != null : b2.value != null};
}
function $a(a2, b2) {
  b2 = b2.checked;
  b2 != null && qa(a2, "checked", b2, false);
}
function ab(a2, b2) {
  $a(a2, b2);
  var c3 = Sa(b2.value), d2 = b2.type;
  if (c3 != null)
    if (d2 === "number") {
      if (c3 === 0 && a2.value === "" || a2.value != c3)
        a2.value = "" + c3;
    } else
      a2.value !== "" + c3 && (a2.value = "" + c3);
  else if (d2 === "submit" || d2 === "reset") {
    a2.removeAttribute("value");
    return;
  }
  b2.hasOwnProperty("value") ? bb(a2, b2.type, c3) : b2.hasOwnProperty("defaultValue") && bb(a2, b2.type, Sa(b2.defaultValue));
  b2.checked == null && b2.defaultChecked != null && (a2.defaultChecked = !!b2.defaultChecked);
}
function cb(a2, b2, c3) {
  if (b2.hasOwnProperty("value") || b2.hasOwnProperty("defaultValue")) {
    var d2 = b2.type;
    if (!(d2 !== "submit" && d2 !== "reset" || b2.value !== void 0 && b2.value !== null))
      return;
    b2 = "" + a2._wrapperState.initialValue;
    c3 || b2 === a2.value || (a2.value = b2);
    a2.defaultValue = b2;
  }
  c3 = a2.name;
  c3 !== "" && (a2.name = "");
  a2.defaultChecked = !!a2._wrapperState.initialChecked;
  c3 !== "" && (a2.name = c3);
}
function bb(a2, b2, c3) {
  if (b2 !== "number" || Xa(a2.ownerDocument) !== a2)
    c3 == null ? a2.defaultValue = "" + a2._wrapperState.initialValue : a2.defaultValue !== "" + c3 && (a2.defaultValue = "" + c3);
}
function db(a2) {
  var b2 = "";
  react.Children.forEach(a2, function(a3) {
    a3 != null && (b2 += a3);
  });
  return b2;
}
function eb(a2, b2) {
  a2 = objectAssign({children: void 0}, b2);
  if (b2 = db(b2.children))
    a2.children = b2;
  return a2;
}
function fb(a2, b2, c3, d2) {
  a2 = a2.options;
  if (b2) {
    b2 = {};
    for (var e2 = 0; e2 < c3.length; e2++)
      b2["$" + c3[e2]] = true;
    for (c3 = 0; c3 < a2.length; c3++)
      e2 = b2.hasOwnProperty("$" + a2[c3].value), a2[c3].selected !== e2 && (a2[c3].selected = e2), e2 && d2 && (a2[c3].defaultSelected = true);
  } else {
    c3 = "" + Sa(c3);
    b2 = null;
    for (e2 = 0; e2 < a2.length; e2++) {
      if (a2[e2].value === c3) {
        a2[e2].selected = true;
        d2 && (a2[e2].defaultSelected = true);
        return;
      }
      b2 !== null || a2[e2].disabled || (b2 = a2[e2]);
    }
    b2 !== null && (b2.selected = true);
  }
}
function gb(a2, b2) {
  if (b2.dangerouslySetInnerHTML != null)
    throw Error(y(91));
  return objectAssign({}, b2, {value: void 0, defaultValue: void 0, children: "" + a2._wrapperState.initialValue});
}
function hb(a2, b2) {
  var c3 = b2.value;
  if (c3 == null) {
    c3 = b2.children;
    b2 = b2.defaultValue;
    if (c3 != null) {
      if (b2 != null)
        throw Error(y(92));
      if (Array.isArray(c3)) {
        if (!(1 >= c3.length))
          throw Error(y(93));
        c3 = c3[0];
      }
      b2 = c3;
    }
    b2 == null && (b2 = "");
    c3 = b2;
  }
  a2._wrapperState = {initialValue: Sa(c3)};
}
function ib(a2, b2) {
  var c3 = Sa(b2.value), d2 = Sa(b2.defaultValue);
  c3 != null && (c3 = "" + c3, c3 !== a2.value && (a2.value = c3), b2.defaultValue == null && a2.defaultValue !== c3 && (a2.defaultValue = c3));
  d2 != null && (a2.defaultValue = "" + d2);
}
function jb(a2) {
  var b2 = a2.textContent;
  b2 === a2._wrapperState.initialValue && b2 !== "" && b2 !== null && (a2.value = b2);
}
var kb = {html: "http://www.w3.org/1999/xhtml", mathml: "http://www.w3.org/1998/Math/MathML", svg: "http://www.w3.org/2000/svg"};
function lb(a2) {
  switch (a2) {
    case "svg":
      return "http://www.w3.org/2000/svg";
    case "math":
      return "http://www.w3.org/1998/Math/MathML";
    default:
      return "http://www.w3.org/1999/xhtml";
  }
}
function mb(a2, b2) {
  return a2 == null || a2 === "http://www.w3.org/1999/xhtml" ? lb(b2) : a2 === "http://www.w3.org/2000/svg" && b2 === "foreignObject" ? "http://www.w3.org/1999/xhtml" : a2;
}
var nb;
var ob = function(a2) {
  return typeof MSApp !== "undefined" && MSApp.execUnsafeLocalFunction ? function(b2, c3, d2, e2) {
    MSApp.execUnsafeLocalFunction(function() {
      return a2(b2, c3, d2, e2);
    });
  } : a2;
}(function(a2, b2) {
  if (a2.namespaceURI !== kb.svg || "innerHTML" in a2)
    a2.innerHTML = b2;
  else {
    nb = nb || document.createElement("div");
    nb.innerHTML = "<svg>" + b2.valueOf().toString() + "</svg>";
    for (b2 = nb.firstChild; a2.firstChild; )
      a2.removeChild(a2.firstChild);
    for (; b2.firstChild; )
      a2.appendChild(b2.firstChild);
  }
});
function pb(a2, b2) {
  if (b2) {
    var c3 = a2.firstChild;
    if (c3 && c3 === a2.lastChild && c3.nodeType === 3) {
      c3.nodeValue = b2;
      return;
    }
  }
  a2.textContent = b2;
}
var qb = {
  animationIterationCount: true,
  borderImageOutset: true,
  borderImageSlice: true,
  borderImageWidth: true,
  boxFlex: true,
  boxFlexGroup: true,
  boxOrdinalGroup: true,
  columnCount: true,
  columns: true,
  flex: true,
  flexGrow: true,
  flexPositive: true,
  flexShrink: true,
  flexNegative: true,
  flexOrder: true,
  gridArea: true,
  gridRow: true,
  gridRowEnd: true,
  gridRowSpan: true,
  gridRowStart: true,
  gridColumn: true,
  gridColumnEnd: true,
  gridColumnSpan: true,
  gridColumnStart: true,
  fontWeight: true,
  lineClamp: true,
  lineHeight: true,
  opacity: true,
  order: true,
  orphans: true,
  tabSize: true,
  widows: true,
  zIndex: true,
  zoom: true,
  fillOpacity: true,
  floodOpacity: true,
  stopOpacity: true,
  strokeDasharray: true,
  strokeDashoffset: true,
  strokeMiterlimit: true,
  strokeOpacity: true,
  strokeWidth: true
};
var rb = ["Webkit", "ms", "Moz", "O"];
Object.keys(qb).forEach(function(a2) {
  rb.forEach(function(b2) {
    b2 = b2 + a2.charAt(0).toUpperCase() + a2.substring(1);
    qb[b2] = qb[a2];
  });
});
function sb(a2, b2, c3) {
  return b2 == null || typeof b2 === "boolean" || b2 === "" ? "" : c3 || typeof b2 !== "number" || b2 === 0 || qb.hasOwnProperty(a2) && qb[a2] ? ("" + b2).trim() : b2 + "px";
}
function tb(a2, b2) {
  a2 = a2.style;
  for (var c3 in b2)
    if (b2.hasOwnProperty(c3)) {
      var d2 = c3.indexOf("--") === 0, e2 = sb(c3, b2[c3], d2);
      c3 === "float" && (c3 = "cssFloat");
      d2 ? a2.setProperty(c3, e2) : a2[c3] = e2;
    }
}
var ub = objectAssign({menuitem: true}, {area: true, base: true, br: true, col: true, embed: true, hr: true, img: true, input: true, keygen: true, link: true, meta: true, param: true, source: true, track: true, wbr: true});
function vb(a2, b2) {
  if (b2) {
    if (ub[a2] && (b2.children != null || b2.dangerouslySetInnerHTML != null))
      throw Error(y(137, a2));
    if (b2.dangerouslySetInnerHTML != null) {
      if (b2.children != null)
        throw Error(y(60));
      if (!(typeof b2.dangerouslySetInnerHTML === "object" && "__html" in b2.dangerouslySetInnerHTML))
        throw Error(y(61));
    }
    if (b2.style != null && typeof b2.style !== "object")
      throw Error(y(62));
  }
}
function wb(a2, b2) {
  if (a2.indexOf("-") === -1)
    return typeof b2.is === "string";
  switch (a2) {
    case "annotation-xml":
    case "color-profile":
    case "font-face":
    case "font-face-src":
    case "font-face-uri":
    case "font-face-format":
    case "font-face-name":
    case "missing-glyph":
      return false;
    default:
      return true;
  }
}
function xb(a2) {
  a2 = a2.target || a2.srcElement || window;
  a2.correspondingUseElement && (a2 = a2.correspondingUseElement);
  return a2.nodeType === 3 ? a2.parentNode : a2;
}
var yb = null;
var zb = null;
var Ab = null;
function Bb(a2) {
  if (a2 = Cb(a2)) {
    if (typeof yb !== "function")
      throw Error(y(280));
    var b2 = a2.stateNode;
    b2 && (b2 = Db(b2), yb(a2.stateNode, a2.type, b2));
  }
}
function Eb(a2) {
  zb ? Ab ? Ab.push(a2) : Ab = [a2] : zb = a2;
}
function Fb() {
  if (zb) {
    var a2 = zb, b2 = Ab;
    Ab = zb = null;
    Bb(a2);
    if (b2)
      for (a2 = 0; a2 < b2.length; a2++)
        Bb(b2[a2]);
  }
}
function Gb(a2, b2) {
  return a2(b2);
}
function Hb(a2, b2, c3, d2, e2) {
  return a2(b2, c3, d2, e2);
}
function Ib() {
}
var Jb = Gb;
var Kb = false;
var Lb = false;
function Mb() {
  if (zb !== null || Ab !== null)
    Ib(), Fb();
}
function Nb(a2, b2, c3) {
  if (Lb)
    return a2(b2, c3);
  Lb = true;
  try {
    return Jb(a2, b2, c3);
  } finally {
    Lb = false, Mb();
  }
}
function Ob(a2, b2) {
  var c3 = a2.stateNode;
  if (c3 === null)
    return null;
  var d2 = Db(c3);
  if (d2 === null)
    return null;
  c3 = d2[b2];
  a:
    switch (b2) {
      case "onClick":
      case "onClickCapture":
      case "onDoubleClick":
      case "onDoubleClickCapture":
      case "onMouseDown":
      case "onMouseDownCapture":
      case "onMouseMove":
      case "onMouseMoveCapture":
      case "onMouseUp":
      case "onMouseUpCapture":
      case "onMouseEnter":
        (d2 = !d2.disabled) || (a2 = a2.type, d2 = !(a2 === "button" || a2 === "input" || a2 === "select" || a2 === "textarea"));
        a2 = !d2;
        break a;
      default:
        a2 = false;
    }
  if (a2)
    return null;
  if (c3 && typeof c3 !== "function")
    throw Error(y(231, b2, typeof c3));
  return c3;
}
var Pb = false;
if (fa)
  try {
    Qb = {};
    Object.defineProperty(Qb, "passive", {get: function() {
      Pb = true;
    }});
    window.addEventListener("test", Qb, Qb);
    window.removeEventListener("test", Qb, Qb);
  } catch (a2) {
    Pb = false;
  }
var Qb;
function Rb(a2, b2, c3, d2, e2, f2, g2, h2, k2) {
  var l2 = Array.prototype.slice.call(arguments, 3);
  try {
    b2.apply(c3, l2);
  } catch (n3) {
    this.onError(n3);
  }
}
var Sb = false;
var Tb = null;
var Ub = false;
var Vb = null;
var Wb = {onError: function(a2) {
  Sb = true;
  Tb = a2;
}};
function Xb(a2, b2, c3, d2, e2, f2, g2, h2, k2) {
  Sb = false;
  Tb = null;
  Rb.apply(Wb, arguments);
}
function Yb(a2, b2, c3, d2, e2, f2, g2, h2, k2) {
  Xb.apply(this, arguments);
  if (Sb) {
    if (Sb) {
      var l2 = Tb;
      Sb = false;
      Tb = null;
    } else
      throw Error(y(198));
    Ub || (Ub = true, Vb = l2);
  }
}
function Zb(a2) {
  var b2 = a2, c3 = a2;
  if (a2.alternate)
    for (; b2.return; )
      b2 = b2.return;
  else {
    a2 = b2;
    do
      b2 = a2, (b2.flags & 1026) !== 0 && (c3 = b2.return), a2 = b2.return;
    while (a2);
  }
  return b2.tag === 3 ? c3 : null;
}
function $b(a2) {
  if (a2.tag === 13) {
    var b2 = a2.memoizedState;
    b2 === null && (a2 = a2.alternate, a2 !== null && (b2 = a2.memoizedState));
    if (b2 !== null)
      return b2.dehydrated;
  }
  return null;
}
function ac(a2) {
  if (Zb(a2) !== a2)
    throw Error(y(188));
}
function bc(a2) {
  var b2 = a2.alternate;
  if (!b2) {
    b2 = Zb(a2);
    if (b2 === null)
      throw Error(y(188));
    return b2 !== a2 ? null : a2;
  }
  for (var c3 = a2, d2 = b2; ; ) {
    var e2 = c3.return;
    if (e2 === null)
      break;
    var f2 = e2.alternate;
    if (f2 === null) {
      d2 = e2.return;
      if (d2 !== null) {
        c3 = d2;
        continue;
      }
      break;
    }
    if (e2.child === f2.child) {
      for (f2 = e2.child; f2; ) {
        if (f2 === c3)
          return ac(e2), a2;
        if (f2 === d2)
          return ac(e2), b2;
        f2 = f2.sibling;
      }
      throw Error(y(188));
    }
    if (c3.return !== d2.return)
      c3 = e2, d2 = f2;
    else {
      for (var g2 = false, h2 = e2.child; h2; ) {
        if (h2 === c3) {
          g2 = true;
          c3 = e2;
          d2 = f2;
          break;
        }
        if (h2 === d2) {
          g2 = true;
          d2 = e2;
          c3 = f2;
          break;
        }
        h2 = h2.sibling;
      }
      if (!g2) {
        for (h2 = f2.child; h2; ) {
          if (h2 === c3) {
            g2 = true;
            c3 = f2;
            d2 = e2;
            break;
          }
          if (h2 === d2) {
            g2 = true;
            d2 = f2;
            c3 = e2;
            break;
          }
          h2 = h2.sibling;
        }
        if (!g2)
          throw Error(y(189));
      }
    }
    if (c3.alternate !== d2)
      throw Error(y(190));
  }
  if (c3.tag !== 3)
    throw Error(y(188));
  return c3.stateNode.current === c3 ? a2 : b2;
}
function cc(a2) {
  a2 = bc(a2);
  if (!a2)
    return null;
  for (var b2 = a2; ; ) {
    if (b2.tag === 5 || b2.tag === 6)
      return b2;
    if (b2.child)
      b2.child.return = b2, b2 = b2.child;
    else {
      if (b2 === a2)
        break;
      for (; !b2.sibling; ) {
        if (!b2.return || b2.return === a2)
          return null;
        b2 = b2.return;
      }
      b2.sibling.return = b2.return;
      b2 = b2.sibling;
    }
  }
  return null;
}
function dc(a2, b2) {
  for (var c3 = a2.alternate; b2 !== null; ) {
    if (b2 === a2 || b2 === c3)
      return true;
    b2 = b2.return;
  }
  return false;
}
var ec;
var fc;
var gc;
var hc;
var ic = false;
var jc = [];
var kc = null;
var lc = null;
var mc = null;
var nc = new Map();
var oc = new Map();
var pc = [];
var qc = "mousedown mouseup touchcancel touchend touchstart auxclick dblclick pointercancel pointerdown pointerup dragend dragstart drop compositionend compositionstart keydown keypress keyup input textInput copy cut paste click change contextmenu reset submit".split(" ");
function rc(a2, b2, c3, d2, e2) {
  return {blockedOn: a2, domEventName: b2, eventSystemFlags: c3 | 16, nativeEvent: e2, targetContainers: [d2]};
}
function sc(a2, b2) {
  switch (a2) {
    case "focusin":
    case "focusout":
      kc = null;
      break;
    case "dragenter":
    case "dragleave":
      lc = null;
      break;
    case "mouseover":
    case "mouseout":
      mc = null;
      break;
    case "pointerover":
    case "pointerout":
      nc.delete(b2.pointerId);
      break;
    case "gotpointercapture":
    case "lostpointercapture":
      oc.delete(b2.pointerId);
  }
}
function tc(a2, b2, c3, d2, e2, f2) {
  if (a2 === null || a2.nativeEvent !== f2)
    return a2 = rc(b2, c3, d2, e2, f2), b2 !== null && (b2 = Cb(b2), b2 !== null && fc(b2)), a2;
  a2.eventSystemFlags |= d2;
  b2 = a2.targetContainers;
  e2 !== null && b2.indexOf(e2) === -1 && b2.push(e2);
  return a2;
}
function uc(a2, b2, c3, d2, e2) {
  switch (b2) {
    case "focusin":
      return kc = tc(kc, a2, b2, c3, d2, e2), true;
    case "dragenter":
      return lc = tc(lc, a2, b2, c3, d2, e2), true;
    case "mouseover":
      return mc = tc(mc, a2, b2, c3, d2, e2), true;
    case "pointerover":
      var f2 = e2.pointerId;
      nc.set(f2, tc(nc.get(f2) || null, a2, b2, c3, d2, e2));
      return true;
    case "gotpointercapture":
      return f2 = e2.pointerId, oc.set(f2, tc(oc.get(f2) || null, a2, b2, c3, d2, e2)), true;
  }
  return false;
}
function vc(a2) {
  var b2 = wc(a2.target);
  if (b2 !== null) {
    var c3 = Zb(b2);
    if (c3 !== null) {
      if (b2 = c3.tag, b2 === 13) {
        if (b2 = $b(c3), b2 !== null) {
          a2.blockedOn = b2;
          hc(a2.lanePriority, function() {
            scheduler.unstable_runWithPriority(a2.priority, function() {
              gc(c3);
            });
          });
          return;
        }
      } else if (b2 === 3 && c3.stateNode.hydrate) {
        a2.blockedOn = c3.tag === 3 ? c3.stateNode.containerInfo : null;
        return;
      }
    }
  }
  a2.blockedOn = null;
}
function xc(a2) {
  if (a2.blockedOn !== null)
    return false;
  for (var b2 = a2.targetContainers; 0 < b2.length; ) {
    var c3 = yc(a2.domEventName, a2.eventSystemFlags, b2[0], a2.nativeEvent);
    if (c3 !== null)
      return b2 = Cb(c3), b2 !== null && fc(b2), a2.blockedOn = c3, false;
    b2.shift();
  }
  return true;
}
function zc(a2, b2, c3) {
  xc(a2) && c3.delete(b2);
}
function Ac() {
  for (ic = false; 0 < jc.length; ) {
    var a2 = jc[0];
    if (a2.blockedOn !== null) {
      a2 = Cb(a2.blockedOn);
      a2 !== null && ec(a2);
      break;
    }
    for (var b2 = a2.targetContainers; 0 < b2.length; ) {
      var c3 = yc(a2.domEventName, a2.eventSystemFlags, b2[0], a2.nativeEvent);
      if (c3 !== null) {
        a2.blockedOn = c3;
        break;
      }
      b2.shift();
    }
    a2.blockedOn === null && jc.shift();
  }
  kc !== null && xc(kc) && (kc = null);
  lc !== null && xc(lc) && (lc = null);
  mc !== null && xc(mc) && (mc = null);
  nc.forEach(zc);
  oc.forEach(zc);
}
function Bc(a2, b2) {
  a2.blockedOn === b2 && (a2.blockedOn = null, ic || (ic = true, scheduler.unstable_scheduleCallback(scheduler.unstable_NormalPriority, Ac)));
}
function Cc(a2) {
  function b2(b3) {
    return Bc(b3, a2);
  }
  if (0 < jc.length) {
    Bc(jc[0], a2);
    for (var c3 = 1; c3 < jc.length; c3++) {
      var d2 = jc[c3];
      d2.blockedOn === a2 && (d2.blockedOn = null);
    }
  }
  kc !== null && Bc(kc, a2);
  lc !== null && Bc(lc, a2);
  mc !== null && Bc(mc, a2);
  nc.forEach(b2);
  oc.forEach(b2);
  for (c3 = 0; c3 < pc.length; c3++)
    d2 = pc[c3], d2.blockedOn === a2 && (d2.blockedOn = null);
  for (; 0 < pc.length && (c3 = pc[0], c3.blockedOn === null); )
    vc(c3), c3.blockedOn === null && pc.shift();
}
function Dc(a2, b2) {
  var c3 = {};
  c3[a2.toLowerCase()] = b2.toLowerCase();
  c3["Webkit" + a2] = "webkit" + b2;
  c3["Moz" + a2] = "moz" + b2;
  return c3;
}
var Ec = {animationend: Dc("Animation", "AnimationEnd"), animationiteration: Dc("Animation", "AnimationIteration"), animationstart: Dc("Animation", "AnimationStart"), transitionend: Dc("Transition", "TransitionEnd")};
var Fc = {};
var Gc = {};
fa && (Gc = document.createElement("div").style, "AnimationEvent" in window || (delete Ec.animationend.animation, delete Ec.animationiteration.animation, delete Ec.animationstart.animation), "TransitionEvent" in window || delete Ec.transitionend.transition);
function Hc(a2) {
  if (Fc[a2])
    return Fc[a2];
  if (!Ec[a2])
    return a2;
  var b2 = Ec[a2], c3;
  for (c3 in b2)
    if (b2.hasOwnProperty(c3) && c3 in Gc)
      return Fc[a2] = b2[c3];
  return a2;
}
var Ic = Hc("animationend");
var Jc = Hc("animationiteration");
var Kc = Hc("animationstart");
var Lc = Hc("transitionend");
var Mc = new Map();
var Nc = new Map();
var Oc = [
  "abort",
  "abort",
  Ic,
  "animationEnd",
  Jc,
  "animationIteration",
  Kc,
  "animationStart",
  "canplay",
  "canPlay",
  "canplaythrough",
  "canPlayThrough",
  "durationchange",
  "durationChange",
  "emptied",
  "emptied",
  "encrypted",
  "encrypted",
  "ended",
  "ended",
  "error",
  "error",
  "gotpointercapture",
  "gotPointerCapture",
  "load",
  "load",
  "loadeddata",
  "loadedData",
  "loadedmetadata",
  "loadedMetadata",
  "loadstart",
  "loadStart",
  "lostpointercapture",
  "lostPointerCapture",
  "playing",
  "playing",
  "progress",
  "progress",
  "seeking",
  "seeking",
  "stalled",
  "stalled",
  "suspend",
  "suspend",
  "timeupdate",
  "timeUpdate",
  Lc,
  "transitionEnd",
  "waiting",
  "waiting"
];
function Pc(a2, b2) {
  for (var c3 = 0; c3 < a2.length; c3 += 2) {
    var d2 = a2[c3], e2 = a2[c3 + 1];
    e2 = "on" + (e2[0].toUpperCase() + e2.slice(1));
    Nc.set(d2, b2);
    Mc.set(d2, e2);
    da(e2, [d2]);
  }
}
var Qc = scheduler.unstable_now;
Qc();
var F = 8;
function Rc(a2) {
  if ((1 & a2) !== 0)
    return F = 15, 1;
  if ((2 & a2) !== 0)
    return F = 14, 2;
  if ((4 & a2) !== 0)
    return F = 13, 4;
  var b2 = 24 & a2;
  if (b2 !== 0)
    return F = 12, b2;
  if ((a2 & 32) !== 0)
    return F = 11, 32;
  b2 = 192 & a2;
  if (b2 !== 0)
    return F = 10, b2;
  if ((a2 & 256) !== 0)
    return F = 9, 256;
  b2 = 3584 & a2;
  if (b2 !== 0)
    return F = 8, b2;
  if ((a2 & 4096) !== 0)
    return F = 7, 4096;
  b2 = 4186112 & a2;
  if (b2 !== 0)
    return F = 6, b2;
  b2 = 62914560 & a2;
  if (b2 !== 0)
    return F = 5, b2;
  if (a2 & 67108864)
    return F = 4, 67108864;
  if ((a2 & 134217728) !== 0)
    return F = 3, 134217728;
  b2 = 805306368 & a2;
  if (b2 !== 0)
    return F = 2, b2;
  if ((1073741824 & a2) !== 0)
    return F = 1, 1073741824;
  F = 8;
  return a2;
}
function Sc(a2) {
  switch (a2) {
    case 99:
      return 15;
    case 98:
      return 10;
    case 97:
    case 96:
      return 8;
    case 95:
      return 2;
    default:
      return 0;
  }
}
function Tc(a2) {
  switch (a2) {
    case 15:
    case 14:
      return 99;
    case 13:
    case 12:
    case 11:
    case 10:
      return 98;
    case 9:
    case 8:
    case 7:
    case 6:
    case 4:
    case 5:
      return 97;
    case 3:
    case 2:
    case 1:
      return 95;
    case 0:
      return 90;
    default:
      throw Error(y(358, a2));
  }
}
function Uc(a2, b2) {
  var c3 = a2.pendingLanes;
  if (c3 === 0)
    return F = 0;
  var d2 = 0, e2 = 0, f2 = a2.expiredLanes, g2 = a2.suspendedLanes, h2 = a2.pingedLanes;
  if (f2 !== 0)
    d2 = f2, e2 = F = 15;
  else if (f2 = c3 & 134217727, f2 !== 0) {
    var k2 = f2 & ~g2;
    k2 !== 0 ? (d2 = Rc(k2), e2 = F) : (h2 &= f2, h2 !== 0 && (d2 = Rc(h2), e2 = F));
  } else
    f2 = c3 & ~g2, f2 !== 0 ? (d2 = Rc(f2), e2 = F) : h2 !== 0 && (d2 = Rc(h2), e2 = F);
  if (d2 === 0)
    return 0;
  d2 = 31 - Vc(d2);
  d2 = c3 & ((0 > d2 ? 0 : 1 << d2) << 1) - 1;
  if (b2 !== 0 && b2 !== d2 && (b2 & g2) === 0) {
    Rc(b2);
    if (e2 <= F)
      return b2;
    F = e2;
  }
  b2 = a2.entangledLanes;
  if (b2 !== 0)
    for (a2 = a2.entanglements, b2 &= d2; 0 < b2; )
      c3 = 31 - Vc(b2), e2 = 1 << c3, d2 |= a2[c3], b2 &= ~e2;
  return d2;
}
function Wc(a2) {
  a2 = a2.pendingLanes & -1073741825;
  return a2 !== 0 ? a2 : a2 & 1073741824 ? 1073741824 : 0;
}
function Xc(a2, b2) {
  switch (a2) {
    case 15:
      return 1;
    case 14:
      return 2;
    case 12:
      return a2 = Yc(24 & ~b2), a2 === 0 ? Xc(10, b2) : a2;
    case 10:
      return a2 = Yc(192 & ~b2), a2 === 0 ? Xc(8, b2) : a2;
    case 8:
      return a2 = Yc(3584 & ~b2), a2 === 0 && (a2 = Yc(4186112 & ~b2), a2 === 0 && (a2 = 512)), a2;
    case 2:
      return b2 = Yc(805306368 & ~b2), b2 === 0 && (b2 = 268435456), b2;
  }
  throw Error(y(358, a2));
}
function Yc(a2) {
  return a2 & -a2;
}
function Zc(a2) {
  for (var b2 = [], c3 = 0; 31 > c3; c3++)
    b2.push(a2);
  return b2;
}
function $c(a2, b2, c3) {
  a2.pendingLanes |= b2;
  var d2 = b2 - 1;
  a2.suspendedLanes &= d2;
  a2.pingedLanes &= d2;
  a2 = a2.eventTimes;
  b2 = 31 - Vc(b2);
  a2[b2] = c3;
}
var Vc = Math.clz32 ? Math.clz32 : ad;
var bd = Math.log;
var cd = Math.LN2;
function ad(a2) {
  return a2 === 0 ? 32 : 31 - (bd(a2) / cd | 0) | 0;
}
var dd = scheduler.unstable_UserBlockingPriority;
var ed = scheduler.unstable_runWithPriority;
var fd = true;
function gd(a2, b2, c3, d2) {
  Kb || Ib();
  var e2 = hd, f2 = Kb;
  Kb = true;
  try {
    Hb(e2, a2, b2, c3, d2);
  } finally {
    (Kb = f2) || Mb();
  }
}
function id(a2, b2, c3, d2) {
  ed(dd, hd.bind(null, a2, b2, c3, d2));
}
function hd(a2, b2, c3, d2) {
  if (fd) {
    var e2;
    if ((e2 = (b2 & 4) === 0) && 0 < jc.length && -1 < qc.indexOf(a2))
      a2 = rc(null, a2, b2, c3, d2), jc.push(a2);
    else {
      var f2 = yc(a2, b2, c3, d2);
      if (f2 === null)
        e2 && sc(a2, d2);
      else {
        if (e2) {
          if (-1 < qc.indexOf(a2)) {
            a2 = rc(f2, a2, b2, c3, d2);
            jc.push(a2);
            return;
          }
          if (uc(f2, a2, b2, c3, d2))
            return;
          sc(a2, d2);
        }
        jd(a2, b2, d2, null, c3);
      }
    }
  }
}
function yc(a2, b2, c3, d2) {
  var e2 = xb(d2);
  e2 = wc(e2);
  if (e2 !== null) {
    var f2 = Zb(e2);
    if (f2 === null)
      e2 = null;
    else {
      var g2 = f2.tag;
      if (g2 === 13) {
        e2 = $b(f2);
        if (e2 !== null)
          return e2;
        e2 = null;
      } else if (g2 === 3) {
        if (f2.stateNode.hydrate)
          return f2.tag === 3 ? f2.stateNode.containerInfo : null;
        e2 = null;
      } else
        f2 !== e2 && (e2 = null);
    }
  }
  jd(a2, b2, d2, e2, c3);
  return null;
}
var kd = null;
var ld = null;
var md = null;
function nd() {
  if (md)
    return md;
  var a2, b2 = ld, c3 = b2.length, d2, e2 = "value" in kd ? kd.value : kd.textContent, f2 = e2.length;
  for (a2 = 0; a2 < c3 && b2[a2] === e2[a2]; a2++)
    ;
  var g2 = c3 - a2;
  for (d2 = 1; d2 <= g2 && b2[c3 - d2] === e2[f2 - d2]; d2++)
    ;
  return md = e2.slice(a2, 1 < d2 ? 1 - d2 : void 0);
}
function od(a2) {
  var b2 = a2.keyCode;
  "charCode" in a2 ? (a2 = a2.charCode, a2 === 0 && b2 === 13 && (a2 = 13)) : a2 = b2;
  a2 === 10 && (a2 = 13);
  return 32 <= a2 || a2 === 13 ? a2 : 0;
}
function pd() {
  return true;
}
function qd() {
  return false;
}
function rd(a2) {
  function b2(b3, d2, e2, f2, g2) {
    this._reactName = b3;
    this._targetInst = e2;
    this.type = d2;
    this.nativeEvent = f2;
    this.target = g2;
    this.currentTarget = null;
    for (var c3 in a2)
      a2.hasOwnProperty(c3) && (b3 = a2[c3], this[c3] = b3 ? b3(f2) : f2[c3]);
    this.isDefaultPrevented = (f2.defaultPrevented != null ? f2.defaultPrevented : f2.returnValue === false) ? pd : qd;
    this.isPropagationStopped = qd;
    return this;
  }
  objectAssign(b2.prototype, {preventDefault: function() {
    this.defaultPrevented = true;
    var a3 = this.nativeEvent;
    a3 && (a3.preventDefault ? a3.preventDefault() : typeof a3.returnValue !== "unknown" && (a3.returnValue = false), this.isDefaultPrevented = pd);
  }, stopPropagation: function() {
    var a3 = this.nativeEvent;
    a3 && (a3.stopPropagation ? a3.stopPropagation() : typeof a3.cancelBubble !== "unknown" && (a3.cancelBubble = true), this.isPropagationStopped = pd);
  }, persist: function() {
  }, isPersistent: pd});
  return b2;
}
var sd = {eventPhase: 0, bubbles: 0, cancelable: 0, timeStamp: function(a2) {
  return a2.timeStamp || Date.now();
}, defaultPrevented: 0, isTrusted: 0};
var td = rd(sd);
var ud = objectAssign({}, sd, {view: 0, detail: 0});
var vd = rd(ud);
var wd;
var xd;
var yd;
var Ad = objectAssign({}, ud, {screenX: 0, screenY: 0, clientX: 0, clientY: 0, pageX: 0, pageY: 0, ctrlKey: 0, shiftKey: 0, altKey: 0, metaKey: 0, getModifierState: zd, button: 0, buttons: 0, relatedTarget: function(a2) {
  return a2.relatedTarget === void 0 ? a2.fromElement === a2.srcElement ? a2.toElement : a2.fromElement : a2.relatedTarget;
}, movementX: function(a2) {
  if ("movementX" in a2)
    return a2.movementX;
  a2 !== yd && (yd && a2.type === "mousemove" ? (wd = a2.screenX - yd.screenX, xd = a2.screenY - yd.screenY) : xd = wd = 0, yd = a2);
  return wd;
}, movementY: function(a2) {
  return "movementY" in a2 ? a2.movementY : xd;
}});
var Bd = rd(Ad);
var Cd = objectAssign({}, Ad, {dataTransfer: 0});
var Dd = rd(Cd);
var Ed = objectAssign({}, ud, {relatedTarget: 0});
var Fd = rd(Ed);
var Gd = objectAssign({}, sd, {animationName: 0, elapsedTime: 0, pseudoElement: 0});
var Hd = rd(Gd);
var Id = objectAssign({}, sd, {clipboardData: function(a2) {
  return "clipboardData" in a2 ? a2.clipboardData : window.clipboardData;
}});
var Jd = rd(Id);
var Kd = objectAssign({}, sd, {data: 0});
var Ld = rd(Kd);
var Md = {
  Esc: "Escape",
  Spacebar: " ",
  Left: "ArrowLeft",
  Up: "ArrowUp",
  Right: "ArrowRight",
  Down: "ArrowDown",
  Del: "Delete",
  Win: "OS",
  Menu: "ContextMenu",
  Apps: "ContextMenu",
  Scroll: "ScrollLock",
  MozPrintableKey: "Unidentified"
};
var Nd = {
  8: "Backspace",
  9: "Tab",
  12: "Clear",
  13: "Enter",
  16: "Shift",
  17: "Control",
  18: "Alt",
  19: "Pause",
  20: "CapsLock",
  27: "Escape",
  32: " ",
  33: "PageUp",
  34: "PageDown",
  35: "End",
  36: "Home",
  37: "ArrowLeft",
  38: "ArrowUp",
  39: "ArrowRight",
  40: "ArrowDown",
  45: "Insert",
  46: "Delete",
  112: "F1",
  113: "F2",
  114: "F3",
  115: "F4",
  116: "F5",
  117: "F6",
  118: "F7",
  119: "F8",
  120: "F9",
  121: "F10",
  122: "F11",
  123: "F12",
  144: "NumLock",
  145: "ScrollLock",
  224: "Meta"
};
var Od = {Alt: "altKey", Control: "ctrlKey", Meta: "metaKey", Shift: "shiftKey"};
function Pd(a2) {
  var b2 = this.nativeEvent;
  return b2.getModifierState ? b2.getModifierState(a2) : (a2 = Od[a2]) ? !!b2[a2] : false;
}
function zd() {
  return Pd;
}
var Qd = objectAssign({}, ud, {key: function(a2) {
  if (a2.key) {
    var b2 = Md[a2.key] || a2.key;
    if (b2 !== "Unidentified")
      return b2;
  }
  return a2.type === "keypress" ? (a2 = od(a2), a2 === 13 ? "Enter" : String.fromCharCode(a2)) : a2.type === "keydown" || a2.type === "keyup" ? Nd[a2.keyCode] || "Unidentified" : "";
}, code: 0, location: 0, ctrlKey: 0, shiftKey: 0, altKey: 0, metaKey: 0, repeat: 0, locale: 0, getModifierState: zd, charCode: function(a2) {
  return a2.type === "keypress" ? od(a2) : 0;
}, keyCode: function(a2) {
  return a2.type === "keydown" || a2.type === "keyup" ? a2.keyCode : 0;
}, which: function(a2) {
  return a2.type === "keypress" ? od(a2) : a2.type === "keydown" || a2.type === "keyup" ? a2.keyCode : 0;
}});
var Rd = rd(Qd);
var Sd = objectAssign({}, Ad, {pointerId: 0, width: 0, height: 0, pressure: 0, tangentialPressure: 0, tiltX: 0, tiltY: 0, twist: 0, pointerType: 0, isPrimary: 0});
var Td = rd(Sd);
var Ud = objectAssign({}, ud, {touches: 0, targetTouches: 0, changedTouches: 0, altKey: 0, metaKey: 0, ctrlKey: 0, shiftKey: 0, getModifierState: zd});
var Vd = rd(Ud);
var Wd = objectAssign({}, sd, {propertyName: 0, elapsedTime: 0, pseudoElement: 0});
var Xd = rd(Wd);
var Yd = objectAssign({}, Ad, {
  deltaX: function(a2) {
    return "deltaX" in a2 ? a2.deltaX : "wheelDeltaX" in a2 ? -a2.wheelDeltaX : 0;
  },
  deltaY: function(a2) {
    return "deltaY" in a2 ? a2.deltaY : "wheelDeltaY" in a2 ? -a2.wheelDeltaY : "wheelDelta" in a2 ? -a2.wheelDelta : 0;
  },
  deltaZ: 0,
  deltaMode: 0
});
var Zd = rd(Yd);
var $d = [9, 13, 27, 32];
var ae = fa && "CompositionEvent" in window;
var be = null;
fa && "documentMode" in document && (be = document.documentMode);
var ce = fa && "TextEvent" in window && !be;
var de = fa && (!ae || be && 8 < be && 11 >= be);
var ee = String.fromCharCode(32);
var fe = false;
function ge(a2, b2) {
  switch (a2) {
    case "keyup":
      return $d.indexOf(b2.keyCode) !== -1;
    case "keydown":
      return b2.keyCode !== 229;
    case "keypress":
    case "mousedown":
    case "focusout":
      return true;
    default:
      return false;
  }
}
function he(a2) {
  a2 = a2.detail;
  return typeof a2 === "object" && "data" in a2 ? a2.data : null;
}
var ie = false;
function je(a2, b2) {
  switch (a2) {
    case "compositionend":
      return he(b2);
    case "keypress":
      if (b2.which !== 32)
        return null;
      fe = true;
      return ee;
    case "textInput":
      return a2 = b2.data, a2 === ee && fe ? null : a2;
    default:
      return null;
  }
}
function ke(a2, b2) {
  if (ie)
    return a2 === "compositionend" || !ae && ge(a2, b2) ? (a2 = nd(), md = ld = kd = null, ie = false, a2) : null;
  switch (a2) {
    case "paste":
      return null;
    case "keypress":
      if (!(b2.ctrlKey || b2.altKey || b2.metaKey) || b2.ctrlKey && b2.altKey) {
        if (b2.char && 1 < b2.char.length)
          return b2.char;
        if (b2.which)
          return String.fromCharCode(b2.which);
      }
      return null;
    case "compositionend":
      return de && b2.locale !== "ko" ? null : b2.data;
    default:
      return null;
  }
}
var le = {color: true, date: true, datetime: true, "datetime-local": true, email: true, month: true, number: true, password: true, range: true, search: true, tel: true, text: true, time: true, url: true, week: true};
function me(a2) {
  var b2 = a2 && a2.nodeName && a2.nodeName.toLowerCase();
  return b2 === "input" ? !!le[a2.type] : b2 === "textarea" ? true : false;
}
function ne(a2, b2, c3, d2) {
  Eb(d2);
  b2 = oe(b2, "onChange");
  0 < b2.length && (c3 = new td("onChange", "change", null, c3, d2), a2.push({event: c3, listeners: b2}));
}
var pe = null;
var qe = null;
function re(a2) {
  se(a2, 0);
}
function te(a2) {
  var b2 = ue(a2);
  if (Wa(b2))
    return a2;
}
function ve(a2, b2) {
  if (a2 === "change")
    return b2;
}
var we = false;
if (fa) {
  if (fa) {
    ye = "oninput" in document;
    if (!ye) {
      ze = document.createElement("div");
      ze.setAttribute("oninput", "return;");
      ye = typeof ze.oninput === "function";
    }
    xe = ye;
  } else
    xe = false;
  we = xe && (!document.documentMode || 9 < document.documentMode);
}
var xe;
var ye;
var ze;
function Ae() {
  pe && (pe.detachEvent("onpropertychange", Be), qe = pe = null);
}
function Be(a2) {
  if (a2.propertyName === "value" && te(qe)) {
    var b2 = [];
    ne(b2, qe, a2, xb(a2));
    a2 = re;
    if (Kb)
      a2(b2);
    else {
      Kb = true;
      try {
        Gb(a2, b2);
      } finally {
        Kb = false, Mb();
      }
    }
  }
}
function Ce(a2, b2, c3) {
  a2 === "focusin" ? (Ae(), pe = b2, qe = c3, pe.attachEvent("onpropertychange", Be)) : a2 === "focusout" && Ae();
}
function De(a2) {
  if (a2 === "selectionchange" || a2 === "keyup" || a2 === "keydown")
    return te(qe);
}
function Ee(a2, b2) {
  if (a2 === "click")
    return te(b2);
}
function Fe(a2, b2) {
  if (a2 === "input" || a2 === "change")
    return te(b2);
}
function Ge(a2, b2) {
  return a2 === b2 && (a2 !== 0 || 1 / a2 === 1 / b2) || a2 !== a2 && b2 !== b2;
}
var He = typeof Object.is === "function" ? Object.is : Ge;
var Ie = Object.prototype.hasOwnProperty;
function Je(a2, b2) {
  if (He(a2, b2))
    return true;
  if (typeof a2 !== "object" || a2 === null || typeof b2 !== "object" || b2 === null)
    return false;
  var c3 = Object.keys(a2), d2 = Object.keys(b2);
  if (c3.length !== d2.length)
    return false;
  for (d2 = 0; d2 < c3.length; d2++)
    if (!Ie.call(b2, c3[d2]) || !He(a2[c3[d2]], b2[c3[d2]]))
      return false;
  return true;
}
function Ke(a2) {
  for (; a2 && a2.firstChild; )
    a2 = a2.firstChild;
  return a2;
}
function Le(a2, b2) {
  var c3 = Ke(a2);
  a2 = 0;
  for (var d2; c3; ) {
    if (c3.nodeType === 3) {
      d2 = a2 + c3.textContent.length;
      if (a2 <= b2 && d2 >= b2)
        return {node: c3, offset: b2 - a2};
      a2 = d2;
    }
    a: {
      for (; c3; ) {
        if (c3.nextSibling) {
          c3 = c3.nextSibling;
          break a;
        }
        c3 = c3.parentNode;
      }
      c3 = void 0;
    }
    c3 = Ke(c3);
  }
}
function Me(a2, b2) {
  return a2 && b2 ? a2 === b2 ? true : a2 && a2.nodeType === 3 ? false : b2 && b2.nodeType === 3 ? Me(a2, b2.parentNode) : "contains" in a2 ? a2.contains(b2) : a2.compareDocumentPosition ? !!(a2.compareDocumentPosition(b2) & 16) : false : false;
}
function Ne() {
  for (var a2 = window, b2 = Xa(); b2 instanceof a2.HTMLIFrameElement; ) {
    try {
      var c3 = typeof b2.contentWindow.location.href === "string";
    } catch (d2) {
      c3 = false;
    }
    if (c3)
      a2 = b2.contentWindow;
    else
      break;
    b2 = Xa(a2.document);
  }
  return b2;
}
function Oe(a2) {
  var b2 = a2 && a2.nodeName && a2.nodeName.toLowerCase();
  return b2 && (b2 === "input" && (a2.type === "text" || a2.type === "search" || a2.type === "tel" || a2.type === "url" || a2.type === "password") || b2 === "textarea" || a2.contentEditable === "true");
}
var Pe = fa && "documentMode" in document && 11 >= document.documentMode;
var Qe = null;
var Re = null;
var Se = null;
var Te = false;
function Ue(a2, b2, c3) {
  var d2 = c3.window === c3 ? c3.document : c3.nodeType === 9 ? c3 : c3.ownerDocument;
  Te || Qe == null || Qe !== Xa(d2) || (d2 = Qe, "selectionStart" in d2 && Oe(d2) ? d2 = {start: d2.selectionStart, end: d2.selectionEnd} : (d2 = (d2.ownerDocument && d2.ownerDocument.defaultView || window).getSelection(), d2 = {anchorNode: d2.anchorNode, anchorOffset: d2.anchorOffset, focusNode: d2.focusNode, focusOffset: d2.focusOffset}), Se && Je(Se, d2) || (Se = d2, d2 = oe(Re, "onSelect"), 0 < d2.length && (b2 = new td("onSelect", "select", null, b2, c3), a2.push({event: b2, listeners: d2}), b2.target = Qe)));
}
Pc("cancel cancel click click close close contextmenu contextMenu copy copy cut cut auxclick auxClick dblclick doubleClick dragend dragEnd dragstart dragStart drop drop focusin focus focusout blur input input invalid invalid keydown keyDown keypress keyPress keyup keyUp mousedown mouseDown mouseup mouseUp paste paste pause pause play play pointercancel pointerCancel pointerdown pointerDown pointerup pointerUp ratechange rateChange reset reset seeked seeked submit submit touchcancel touchCancel touchend touchEnd touchstart touchStart volumechange volumeChange".split(" "), 0);
Pc("drag drag dragenter dragEnter dragexit dragExit dragleave dragLeave dragover dragOver mousemove mouseMove mouseout mouseOut mouseover mouseOver pointermove pointerMove pointerout pointerOut pointerover pointerOver scroll scroll toggle toggle touchmove touchMove wheel wheel".split(" "), 1);
Pc(Oc, 2);
for (var Ve = "change selectionchange textInput compositionstart compositionend compositionupdate".split(" "), We = 0; We < Ve.length; We++)
  Nc.set(Ve[We], 0);
ea("onMouseEnter", ["mouseout", "mouseover"]);
ea("onMouseLeave", ["mouseout", "mouseover"]);
ea("onPointerEnter", ["pointerout", "pointerover"]);
ea("onPointerLeave", ["pointerout", "pointerover"]);
da("onChange", "change click focusin focusout input keydown keyup selectionchange".split(" "));
da("onSelect", "focusout contextmenu dragend focusin keydown keyup mousedown mouseup selectionchange".split(" "));
da("onBeforeInput", ["compositionend", "keypress", "textInput", "paste"]);
da("onCompositionEnd", "compositionend focusout keydown keypress keyup mousedown".split(" "));
da("onCompositionStart", "compositionstart focusout keydown keypress keyup mousedown".split(" "));
da("onCompositionUpdate", "compositionupdate focusout keydown keypress keyup mousedown".split(" "));
var Xe = "abort canplay canplaythrough durationchange emptied encrypted ended error loadeddata loadedmetadata loadstart pause play playing progress ratechange seeked seeking stalled suspend timeupdate volumechange waiting".split(" ");
var Ye = new Set("cancel close invalid load scroll toggle".split(" ").concat(Xe));
function Ze(a2, b2, c3) {
  var d2 = a2.type || "unknown-event";
  a2.currentTarget = c3;
  Yb(d2, b2, void 0, a2);
  a2.currentTarget = null;
}
function se(a2, b2) {
  b2 = (b2 & 4) !== 0;
  for (var c3 = 0; c3 < a2.length; c3++) {
    var d2 = a2[c3], e2 = d2.event;
    d2 = d2.listeners;
    a: {
      var f2 = void 0;
      if (b2)
        for (var g2 = d2.length - 1; 0 <= g2; g2--) {
          var h2 = d2[g2], k2 = h2.instance, l2 = h2.currentTarget;
          h2 = h2.listener;
          if (k2 !== f2 && e2.isPropagationStopped())
            break a;
          Ze(e2, h2, l2);
          f2 = k2;
        }
      else
        for (g2 = 0; g2 < d2.length; g2++) {
          h2 = d2[g2];
          k2 = h2.instance;
          l2 = h2.currentTarget;
          h2 = h2.listener;
          if (k2 !== f2 && e2.isPropagationStopped())
            break a;
          Ze(e2, h2, l2);
          f2 = k2;
        }
    }
  }
  if (Ub)
    throw a2 = Vb, Ub = false, Vb = null, a2;
}
function G(a2, b2) {
  var c3 = $e(b2), d2 = a2 + "__bubble";
  c3.has(d2) || (af(b2, a2, 2, false), c3.add(d2));
}
var bf = "_reactListening" + Math.random().toString(36).slice(2);
function cf(a2) {
  a2[bf] || (a2[bf] = true, ba.forEach(function(b2) {
    Ye.has(b2) || df(b2, false, a2, null);
    df(b2, true, a2, null);
  }));
}
function df(a2, b2, c3, d2) {
  var e2 = 4 < arguments.length && arguments[4] !== void 0 ? arguments[4] : 0, f2 = c3;
  a2 === "selectionchange" && c3.nodeType !== 9 && (f2 = c3.ownerDocument);
  if (d2 !== null && !b2 && Ye.has(a2)) {
    if (a2 !== "scroll")
      return;
    e2 |= 2;
    f2 = d2;
  }
  var g2 = $e(f2), h2 = a2 + "__" + (b2 ? "capture" : "bubble");
  g2.has(h2) || (b2 && (e2 |= 4), af(f2, a2, e2, b2), g2.add(h2));
}
function af(a2, b2, c3, d2) {
  var e2 = Nc.get(b2);
  switch (e2 === void 0 ? 2 : e2) {
    case 0:
      e2 = gd;
      break;
    case 1:
      e2 = id;
      break;
    default:
      e2 = hd;
  }
  c3 = e2.bind(null, b2, c3, a2);
  e2 = void 0;
  !Pb || b2 !== "touchstart" && b2 !== "touchmove" && b2 !== "wheel" || (e2 = true);
  d2 ? e2 !== void 0 ? a2.addEventListener(b2, c3, {capture: true, passive: e2}) : a2.addEventListener(b2, c3, true) : e2 !== void 0 ? a2.addEventListener(b2, c3, {passive: e2}) : a2.addEventListener(b2, c3, false);
}
function jd(a2, b2, c3, d2, e2) {
  var f2 = d2;
  if ((b2 & 1) === 0 && (b2 & 2) === 0 && d2 !== null)
    a:
      for (; ; ) {
        if (d2 === null)
          return;
        var g2 = d2.tag;
        if (g2 === 3 || g2 === 4) {
          var h2 = d2.stateNode.containerInfo;
          if (h2 === e2 || h2.nodeType === 8 && h2.parentNode === e2)
            break;
          if (g2 === 4)
            for (g2 = d2.return; g2 !== null; ) {
              var k2 = g2.tag;
              if (k2 === 3 || k2 === 4) {
                if (k2 = g2.stateNode.containerInfo, k2 === e2 || k2.nodeType === 8 && k2.parentNode === e2)
                  return;
              }
              g2 = g2.return;
            }
          for (; h2 !== null; ) {
            g2 = wc(h2);
            if (g2 === null)
              return;
            k2 = g2.tag;
            if (k2 === 5 || k2 === 6) {
              d2 = f2 = g2;
              continue a;
            }
            h2 = h2.parentNode;
          }
        }
        d2 = d2.return;
      }
  Nb(function() {
    var d3 = f2, e3 = xb(c3), g3 = [];
    a: {
      var h3 = Mc.get(a2);
      if (h3 !== void 0) {
        var k3 = td, x2 = a2;
        switch (a2) {
          case "keypress":
            if (od(c3) === 0)
              break a;
          case "keydown":
          case "keyup":
            k3 = Rd;
            break;
          case "focusin":
            x2 = "focus";
            k3 = Fd;
            break;
          case "focusout":
            x2 = "blur";
            k3 = Fd;
            break;
          case "beforeblur":
          case "afterblur":
            k3 = Fd;
            break;
          case "click":
            if (c3.button === 2)
              break a;
          case "auxclick":
          case "dblclick":
          case "mousedown":
          case "mousemove":
          case "mouseup":
          case "mouseout":
          case "mouseover":
          case "contextmenu":
            k3 = Bd;
            break;
          case "drag":
          case "dragend":
          case "dragenter":
          case "dragexit":
          case "dragleave":
          case "dragover":
          case "dragstart":
          case "drop":
            k3 = Dd;
            break;
          case "touchcancel":
          case "touchend":
          case "touchmove":
          case "touchstart":
            k3 = Vd;
            break;
          case Ic:
          case Jc:
          case Kc:
            k3 = Hd;
            break;
          case Lc:
            k3 = Xd;
            break;
          case "scroll":
            k3 = vd;
            break;
          case "wheel":
            k3 = Zd;
            break;
          case "copy":
          case "cut":
          case "paste":
            k3 = Jd;
            break;
          case "gotpointercapture":
          case "lostpointercapture":
          case "pointercancel":
          case "pointerdown":
          case "pointermove":
          case "pointerout":
          case "pointerover":
          case "pointerup":
            k3 = Td;
        }
        var w2 = (b2 & 4) !== 0, z2 = !w2 && a2 === "scroll", u = w2 ? h3 !== null ? h3 + "Capture" : null : h3;
        w2 = [];
        for (var t5 = d3, q2; t5 !== null; ) {
          q2 = t5;
          var v2 = q2.stateNode;
          q2.tag === 5 && v2 !== null && (q2 = v2, u !== null && (v2 = Ob(t5, u), v2 != null && w2.push(ef(t5, v2, q2))));
          if (z2)
            break;
          t5 = t5.return;
        }
        0 < w2.length && (h3 = new k3(h3, x2, null, c3, e3), g3.push({event: h3, listeners: w2}));
      }
    }
    if ((b2 & 7) === 0) {
      a: {
        h3 = a2 === "mouseover" || a2 === "pointerover";
        k3 = a2 === "mouseout" || a2 === "pointerout";
        if (h3 && (b2 & 16) === 0 && (x2 = c3.relatedTarget || c3.fromElement) && (wc(x2) || x2[ff]))
          break a;
        if (k3 || h3) {
          h3 = e3.window === e3 ? e3 : (h3 = e3.ownerDocument) ? h3.defaultView || h3.parentWindow : window;
          if (k3) {
            if (x2 = c3.relatedTarget || c3.toElement, k3 = d3, x2 = x2 ? wc(x2) : null, x2 !== null && (z2 = Zb(x2), x2 !== z2 || x2.tag !== 5 && x2.tag !== 6))
              x2 = null;
          } else
            k3 = null, x2 = d3;
          if (k3 !== x2) {
            w2 = Bd;
            v2 = "onMouseLeave";
            u = "onMouseEnter";
            t5 = "mouse";
            if (a2 === "pointerout" || a2 === "pointerover")
              w2 = Td, v2 = "onPointerLeave", u = "onPointerEnter", t5 = "pointer";
            z2 = k3 == null ? h3 : ue(k3);
            q2 = x2 == null ? h3 : ue(x2);
            h3 = new w2(v2, t5 + "leave", k3, c3, e3);
            h3.target = z2;
            h3.relatedTarget = q2;
            v2 = null;
            wc(e3) === d3 && (w2 = new w2(u, t5 + "enter", x2, c3, e3), w2.target = q2, w2.relatedTarget = z2, v2 = w2);
            z2 = v2;
            if (k3 && x2)
              b: {
                w2 = k3;
                u = x2;
                t5 = 0;
                for (q2 = w2; q2; q2 = gf(q2))
                  t5++;
                q2 = 0;
                for (v2 = u; v2; v2 = gf(v2))
                  q2++;
                for (; 0 < t5 - q2; )
                  w2 = gf(w2), t5--;
                for (; 0 < q2 - t5; )
                  u = gf(u), q2--;
                for (; t5--; ) {
                  if (w2 === u || u !== null && w2 === u.alternate)
                    break b;
                  w2 = gf(w2);
                  u = gf(u);
                }
                w2 = null;
              }
            else
              w2 = null;
            k3 !== null && hf(g3, h3, k3, w2, false);
            x2 !== null && z2 !== null && hf(g3, z2, x2, w2, true);
          }
        }
      }
      a: {
        h3 = d3 ? ue(d3) : window;
        k3 = h3.nodeName && h3.nodeName.toLowerCase();
        if (k3 === "select" || k3 === "input" && h3.type === "file")
          var J = ve;
        else if (me(h3))
          if (we)
            J = Fe;
          else {
            J = De;
            var K = Ce;
          }
        else
          (k3 = h3.nodeName) && k3.toLowerCase() === "input" && (h3.type === "checkbox" || h3.type === "radio") && (J = Ee);
        if (J && (J = J(a2, d3))) {
          ne(g3, J, c3, e3);
          break a;
        }
        K && K(a2, h3, d3);
        a2 === "focusout" && (K = h3._wrapperState) && K.controlled && h3.type === "number" && bb(h3, "number", h3.value);
      }
      K = d3 ? ue(d3) : window;
      switch (a2) {
        case "focusin":
          if (me(K) || K.contentEditable === "true")
            Qe = K, Re = d3, Se = null;
          break;
        case "focusout":
          Se = Re = Qe = null;
          break;
        case "mousedown":
          Te = true;
          break;
        case "contextmenu":
        case "mouseup":
        case "dragend":
          Te = false;
          Ue(g3, c3, e3);
          break;
        case "selectionchange":
          if (Pe)
            break;
        case "keydown":
        case "keyup":
          Ue(g3, c3, e3);
      }
      var Q;
      if (ae)
        b: {
          switch (a2) {
            case "compositionstart":
              var L = "onCompositionStart";
              break b;
            case "compositionend":
              L = "onCompositionEnd";
              break b;
            case "compositionupdate":
              L = "onCompositionUpdate";
              break b;
          }
          L = void 0;
        }
      else
        ie ? ge(a2, c3) && (L = "onCompositionEnd") : a2 === "keydown" && c3.keyCode === 229 && (L = "onCompositionStart");
      L && (de && c3.locale !== "ko" && (ie || L !== "onCompositionStart" ? L === "onCompositionEnd" && ie && (Q = nd()) : (kd = e3, ld = "value" in kd ? kd.value : kd.textContent, ie = true)), K = oe(d3, L), 0 < K.length && (L = new Ld(L, a2, null, c3, e3), g3.push({event: L, listeners: K}), Q ? L.data = Q : (Q = he(c3), Q !== null && (L.data = Q))));
      if (Q = ce ? je(a2, c3) : ke(a2, c3))
        d3 = oe(d3, "onBeforeInput"), 0 < d3.length && (e3 = new Ld("onBeforeInput", "beforeinput", null, c3, e3), g3.push({event: e3, listeners: d3}), e3.data = Q);
    }
    se(g3, b2);
  });
}
function ef(a2, b2, c3) {
  return {instance: a2, listener: b2, currentTarget: c3};
}
function oe(a2, b2) {
  for (var c3 = b2 + "Capture", d2 = []; a2 !== null; ) {
    var e2 = a2, f2 = e2.stateNode;
    e2.tag === 5 && f2 !== null && (e2 = f2, f2 = Ob(a2, c3), f2 != null && d2.unshift(ef(a2, f2, e2)), f2 = Ob(a2, b2), f2 != null && d2.push(ef(a2, f2, e2)));
    a2 = a2.return;
  }
  return d2;
}
function gf(a2) {
  if (a2 === null)
    return null;
  do
    a2 = a2.return;
  while (a2 && a2.tag !== 5);
  return a2 ? a2 : null;
}
function hf(a2, b2, c3, d2, e2) {
  for (var f2 = b2._reactName, g2 = []; c3 !== null && c3 !== d2; ) {
    var h2 = c3, k2 = h2.alternate, l2 = h2.stateNode;
    if (k2 !== null && k2 === d2)
      break;
    h2.tag === 5 && l2 !== null && (h2 = l2, e2 ? (k2 = Ob(c3, f2), k2 != null && g2.unshift(ef(c3, k2, h2))) : e2 || (k2 = Ob(c3, f2), k2 != null && g2.push(ef(c3, k2, h2))));
    c3 = c3.return;
  }
  g2.length !== 0 && a2.push({event: b2, listeners: g2});
}
function jf() {
}
var kf = null;
var lf = null;
function mf(a2, b2) {
  switch (a2) {
    case "button":
    case "input":
    case "select":
    case "textarea":
      return !!b2.autoFocus;
  }
  return false;
}
function nf(a2, b2) {
  return a2 === "textarea" || a2 === "option" || a2 === "noscript" || typeof b2.children === "string" || typeof b2.children === "number" || typeof b2.dangerouslySetInnerHTML === "object" && b2.dangerouslySetInnerHTML !== null && b2.dangerouslySetInnerHTML.__html != null;
}
var of = typeof setTimeout === "function" ? setTimeout : void 0;
var pf = typeof clearTimeout === "function" ? clearTimeout : void 0;
function qf(a2) {
  a2.nodeType === 1 ? a2.textContent = "" : a2.nodeType === 9 && (a2 = a2.body, a2 != null && (a2.textContent = ""));
}
function rf(a2) {
  for (; a2 != null; a2 = a2.nextSibling) {
    var b2 = a2.nodeType;
    if (b2 === 1 || b2 === 3)
      break;
  }
  return a2;
}
function sf(a2) {
  a2 = a2.previousSibling;
  for (var b2 = 0; a2; ) {
    if (a2.nodeType === 8) {
      var c3 = a2.data;
      if (c3 === "$" || c3 === "$!" || c3 === "$?") {
        if (b2 === 0)
          return a2;
        b2--;
      } else
        c3 === "/$" && b2++;
    }
    a2 = a2.previousSibling;
  }
  return null;
}
var tf = 0;
function uf(a2) {
  return {$$typeof: Ga, toString: a2, valueOf: a2};
}
var vf = Math.random().toString(36).slice(2);
var wf = "__reactFiber$" + vf;
var xf = "__reactProps$" + vf;
var ff = "__reactContainer$" + vf;
var yf = "__reactEvents$" + vf;
function wc(a2) {
  var b2 = a2[wf];
  if (b2)
    return b2;
  for (var c3 = a2.parentNode; c3; ) {
    if (b2 = c3[ff] || c3[wf]) {
      c3 = b2.alternate;
      if (b2.child !== null || c3 !== null && c3.child !== null)
        for (a2 = sf(a2); a2 !== null; ) {
          if (c3 = a2[wf])
            return c3;
          a2 = sf(a2);
        }
      return b2;
    }
    a2 = c3;
    c3 = a2.parentNode;
  }
  return null;
}
function Cb(a2) {
  a2 = a2[wf] || a2[ff];
  return !a2 || a2.tag !== 5 && a2.tag !== 6 && a2.tag !== 13 && a2.tag !== 3 ? null : a2;
}
function ue(a2) {
  if (a2.tag === 5 || a2.tag === 6)
    return a2.stateNode;
  throw Error(y(33));
}
function Db(a2) {
  return a2[xf] || null;
}
function $e(a2) {
  var b2 = a2[yf];
  b2 === void 0 && (b2 = a2[yf] = new Set());
  return b2;
}
var zf = [];
var Af = -1;
function Bf(a2) {
  return {current: a2};
}
function H(a2) {
  0 > Af || (a2.current = zf[Af], zf[Af] = null, Af--);
}
function I(a2, b2) {
  Af++;
  zf[Af] = a2.current;
  a2.current = b2;
}
var Cf = {};
var M = Bf(Cf);
var N = Bf(false);
var Df = Cf;
function Ef(a2, b2) {
  var c3 = a2.type.contextTypes;
  if (!c3)
    return Cf;
  var d2 = a2.stateNode;
  if (d2 && d2.__reactInternalMemoizedUnmaskedChildContext === b2)
    return d2.__reactInternalMemoizedMaskedChildContext;
  var e2 = {}, f2;
  for (f2 in c3)
    e2[f2] = b2[f2];
  d2 && (a2 = a2.stateNode, a2.__reactInternalMemoizedUnmaskedChildContext = b2, a2.__reactInternalMemoizedMaskedChildContext = e2);
  return e2;
}
function Ff(a2) {
  a2 = a2.childContextTypes;
  return a2 !== null && a2 !== void 0;
}
function Gf() {
  H(N);
  H(M);
}
function Hf(a2, b2, c3) {
  if (M.current !== Cf)
    throw Error(y(168));
  I(M, b2);
  I(N, c3);
}
function If(a2, b2, c3) {
  var d2 = a2.stateNode;
  a2 = b2.childContextTypes;
  if (typeof d2.getChildContext !== "function")
    return c3;
  d2 = d2.getChildContext();
  for (var e2 in d2)
    if (!(e2 in a2))
      throw Error(y(108, Ra(b2) || "Unknown", e2));
  return objectAssign({}, c3, d2);
}
function Jf(a2) {
  a2 = (a2 = a2.stateNode) && a2.__reactInternalMemoizedMergedChildContext || Cf;
  Df = M.current;
  I(M, a2);
  I(N, N.current);
  return true;
}
function Kf(a2, b2, c3) {
  var d2 = a2.stateNode;
  if (!d2)
    throw Error(y(169));
  c3 ? (a2 = If(a2, b2, Df), d2.__reactInternalMemoizedMergedChildContext = a2, H(N), H(M), I(M, a2)) : H(N);
  I(N, c3);
}
var Lf = null;
var Mf = null;
var Nf = scheduler.unstable_runWithPriority;
var Of = scheduler.unstable_scheduleCallback;
var Pf = scheduler.unstable_cancelCallback;
var Qf = scheduler.unstable_shouldYield;
var Rf = scheduler.unstable_requestPaint;
var Sf = scheduler.unstable_now;
var Tf = scheduler.unstable_getCurrentPriorityLevel;
var Uf = scheduler.unstable_ImmediatePriority;
var Vf = scheduler.unstable_UserBlockingPriority;
var Wf = scheduler.unstable_NormalPriority;
var Xf = scheduler.unstable_LowPriority;
var Yf = scheduler.unstable_IdlePriority;
var Zf = {};
var $f = Rf !== void 0 ? Rf : function() {
};
var ag = null;
var bg = null;
var cg = false;
var dg = Sf();
var O = 1e4 > dg ? Sf : function() {
  return Sf() - dg;
};
function eg() {
  switch (Tf()) {
    case Uf:
      return 99;
    case Vf:
      return 98;
    case Wf:
      return 97;
    case Xf:
      return 96;
    case Yf:
      return 95;
    default:
      throw Error(y(332));
  }
}
function fg(a2) {
  switch (a2) {
    case 99:
      return Uf;
    case 98:
      return Vf;
    case 97:
      return Wf;
    case 96:
      return Xf;
    case 95:
      return Yf;
    default:
      throw Error(y(332));
  }
}
function gg(a2, b2) {
  a2 = fg(a2);
  return Nf(a2, b2);
}
function hg(a2, b2, c3) {
  a2 = fg(a2);
  return Of(a2, b2, c3);
}
function ig() {
  if (bg !== null) {
    var a2 = bg;
    bg = null;
    Pf(a2);
  }
  jg();
}
function jg() {
  if (!cg && ag !== null) {
    cg = true;
    var a2 = 0;
    try {
      var b2 = ag;
      gg(99, function() {
        for (; a2 < b2.length; a2++) {
          var c3 = b2[a2];
          do
            c3 = c3(true);
          while (c3 !== null);
        }
      });
      ag = null;
    } catch (c3) {
      throw ag !== null && (ag = ag.slice(a2 + 1)), Of(Uf, ig), c3;
    } finally {
      cg = false;
    }
  }
}
var kg = ra.ReactCurrentBatchConfig;
function lg(a2, b2) {
  if (a2 && a2.defaultProps) {
    b2 = objectAssign({}, b2);
    a2 = a2.defaultProps;
    for (var c3 in a2)
      b2[c3] === void 0 && (b2[c3] = a2[c3]);
    return b2;
  }
  return b2;
}
var mg = Bf(null);
var ng = null;
var og = null;
var pg = null;
function qg() {
  pg = og = ng = null;
}
function rg(a2) {
  var b2 = mg.current;
  H(mg);
  a2.type._context._currentValue = b2;
}
function sg(a2, b2) {
  for (; a2 !== null; ) {
    var c3 = a2.alternate;
    if ((a2.childLanes & b2) === b2)
      if (c3 === null || (c3.childLanes & b2) === b2)
        break;
      else
        c3.childLanes |= b2;
    else
      a2.childLanes |= b2, c3 !== null && (c3.childLanes |= b2);
    a2 = a2.return;
  }
}
function tg(a2, b2) {
  ng = a2;
  pg = og = null;
  a2 = a2.dependencies;
  a2 !== null && a2.firstContext !== null && ((a2.lanes & b2) !== 0 && (ug = true), a2.firstContext = null);
}
function vg(a2, b2) {
  if (pg !== a2 && b2 !== false && b2 !== 0) {
    if (typeof b2 !== "number" || b2 === 1073741823)
      pg = a2, b2 = 1073741823;
    b2 = {context: a2, observedBits: b2, next: null};
    if (og === null) {
      if (ng === null)
        throw Error(y(308));
      og = b2;
      ng.dependencies = {lanes: 0, firstContext: b2, responders: null};
    } else
      og = og.next = b2;
  }
  return a2._currentValue;
}
var wg = false;
function xg(a2) {
  a2.updateQueue = {baseState: a2.memoizedState, firstBaseUpdate: null, lastBaseUpdate: null, shared: {pending: null}, effects: null};
}
function yg(a2, b2) {
  a2 = a2.updateQueue;
  b2.updateQueue === a2 && (b2.updateQueue = {baseState: a2.baseState, firstBaseUpdate: a2.firstBaseUpdate, lastBaseUpdate: a2.lastBaseUpdate, shared: a2.shared, effects: a2.effects});
}
function zg(a2, b2) {
  return {eventTime: a2, lane: b2, tag: 0, payload: null, callback: null, next: null};
}
function Ag(a2, b2) {
  a2 = a2.updateQueue;
  if (a2 !== null) {
    a2 = a2.shared;
    var c3 = a2.pending;
    c3 === null ? b2.next = b2 : (b2.next = c3.next, c3.next = b2);
    a2.pending = b2;
  }
}
function Bg(a2, b2) {
  var c3 = a2.updateQueue, d2 = a2.alternate;
  if (d2 !== null && (d2 = d2.updateQueue, c3 === d2)) {
    var e2 = null, f2 = null;
    c3 = c3.firstBaseUpdate;
    if (c3 !== null) {
      do {
        var g2 = {eventTime: c3.eventTime, lane: c3.lane, tag: c3.tag, payload: c3.payload, callback: c3.callback, next: null};
        f2 === null ? e2 = f2 = g2 : f2 = f2.next = g2;
        c3 = c3.next;
      } while (c3 !== null);
      f2 === null ? e2 = f2 = b2 : f2 = f2.next = b2;
    } else
      e2 = f2 = b2;
    c3 = {baseState: d2.baseState, firstBaseUpdate: e2, lastBaseUpdate: f2, shared: d2.shared, effects: d2.effects};
    a2.updateQueue = c3;
    return;
  }
  a2 = c3.lastBaseUpdate;
  a2 === null ? c3.firstBaseUpdate = b2 : a2.next = b2;
  c3.lastBaseUpdate = b2;
}
function Cg(a2, b2, c3, d2) {
  var e2 = a2.updateQueue;
  wg = false;
  var f2 = e2.firstBaseUpdate, g2 = e2.lastBaseUpdate, h2 = e2.shared.pending;
  if (h2 !== null) {
    e2.shared.pending = null;
    var k2 = h2, l2 = k2.next;
    k2.next = null;
    g2 === null ? f2 = l2 : g2.next = l2;
    g2 = k2;
    var n3 = a2.alternate;
    if (n3 !== null) {
      n3 = n3.updateQueue;
      var A2 = n3.lastBaseUpdate;
      A2 !== g2 && (A2 === null ? n3.firstBaseUpdate = l2 : A2.next = l2, n3.lastBaseUpdate = k2);
    }
  }
  if (f2 !== null) {
    A2 = e2.baseState;
    g2 = 0;
    n3 = l2 = k2 = null;
    do {
      h2 = f2.lane;
      var p2 = f2.eventTime;
      if ((d2 & h2) === h2) {
        n3 !== null && (n3 = n3.next = {
          eventTime: p2,
          lane: 0,
          tag: f2.tag,
          payload: f2.payload,
          callback: f2.callback,
          next: null
        });
        a: {
          var C = a2, x2 = f2;
          h2 = b2;
          p2 = c3;
          switch (x2.tag) {
            case 1:
              C = x2.payload;
              if (typeof C === "function") {
                A2 = C.call(p2, A2, h2);
                break a;
              }
              A2 = C;
              break a;
            case 3:
              C.flags = C.flags & -4097 | 64;
            case 0:
              C = x2.payload;
              h2 = typeof C === "function" ? C.call(p2, A2, h2) : C;
              if (h2 === null || h2 === void 0)
                break a;
              A2 = objectAssign({}, A2, h2);
              break a;
            case 2:
              wg = true;
          }
        }
        f2.callback !== null && (a2.flags |= 32, h2 = e2.effects, h2 === null ? e2.effects = [f2] : h2.push(f2));
      } else
        p2 = {eventTime: p2, lane: h2, tag: f2.tag, payload: f2.payload, callback: f2.callback, next: null}, n3 === null ? (l2 = n3 = p2, k2 = A2) : n3 = n3.next = p2, g2 |= h2;
      f2 = f2.next;
      if (f2 === null)
        if (h2 = e2.shared.pending, h2 === null)
          break;
        else
          f2 = h2.next, h2.next = null, e2.lastBaseUpdate = h2, e2.shared.pending = null;
    } while (1);
    n3 === null && (k2 = A2);
    e2.baseState = k2;
    e2.firstBaseUpdate = l2;
    e2.lastBaseUpdate = n3;
    Dg |= g2;
    a2.lanes = g2;
    a2.memoizedState = A2;
  }
}
function Eg(a2, b2, c3) {
  a2 = b2.effects;
  b2.effects = null;
  if (a2 !== null)
    for (b2 = 0; b2 < a2.length; b2++) {
      var d2 = a2[b2], e2 = d2.callback;
      if (e2 !== null) {
        d2.callback = null;
        d2 = c3;
        if (typeof e2 !== "function")
          throw Error(y(191, e2));
        e2.call(d2);
      }
    }
}
var Fg = new react.Component().refs;
function Gg(a2, b2, c3, d2) {
  b2 = a2.memoizedState;
  c3 = c3(d2, b2);
  c3 = c3 === null || c3 === void 0 ? b2 : objectAssign({}, b2, c3);
  a2.memoizedState = c3;
  a2.lanes === 0 && (a2.updateQueue.baseState = c3);
}
var Kg = {isMounted: function(a2) {
  return (a2 = a2._reactInternals) ? Zb(a2) === a2 : false;
}, enqueueSetState: function(a2, b2, c3) {
  a2 = a2._reactInternals;
  var d2 = Hg(), e2 = Ig(a2), f2 = zg(d2, e2);
  f2.payload = b2;
  c3 !== void 0 && c3 !== null && (f2.callback = c3);
  Ag(a2, f2);
  Jg(a2, e2, d2);
}, enqueueReplaceState: function(a2, b2, c3) {
  a2 = a2._reactInternals;
  var d2 = Hg(), e2 = Ig(a2), f2 = zg(d2, e2);
  f2.tag = 1;
  f2.payload = b2;
  c3 !== void 0 && c3 !== null && (f2.callback = c3);
  Ag(a2, f2);
  Jg(a2, e2, d2);
}, enqueueForceUpdate: function(a2, b2) {
  a2 = a2._reactInternals;
  var c3 = Hg(), d2 = Ig(a2), e2 = zg(c3, d2);
  e2.tag = 2;
  b2 !== void 0 && b2 !== null && (e2.callback = b2);
  Ag(a2, e2);
  Jg(a2, d2, c3);
}};
function Lg(a2, b2, c3, d2, e2, f2, g2) {
  a2 = a2.stateNode;
  return typeof a2.shouldComponentUpdate === "function" ? a2.shouldComponentUpdate(d2, f2, g2) : b2.prototype && b2.prototype.isPureReactComponent ? !Je(c3, d2) || !Je(e2, f2) : true;
}
function Mg(a2, b2, c3) {
  var d2 = false, e2 = Cf;
  var f2 = b2.contextType;
  typeof f2 === "object" && f2 !== null ? f2 = vg(f2) : (e2 = Ff(b2) ? Df : M.current, d2 = b2.contextTypes, f2 = (d2 = d2 !== null && d2 !== void 0) ? Ef(a2, e2) : Cf);
  b2 = new b2(c3, f2);
  a2.memoizedState = b2.state !== null && b2.state !== void 0 ? b2.state : null;
  b2.updater = Kg;
  a2.stateNode = b2;
  b2._reactInternals = a2;
  d2 && (a2 = a2.stateNode, a2.__reactInternalMemoizedUnmaskedChildContext = e2, a2.__reactInternalMemoizedMaskedChildContext = f2);
  return b2;
}
function Ng(a2, b2, c3, d2) {
  a2 = b2.state;
  typeof b2.componentWillReceiveProps === "function" && b2.componentWillReceiveProps(c3, d2);
  typeof b2.UNSAFE_componentWillReceiveProps === "function" && b2.UNSAFE_componentWillReceiveProps(c3, d2);
  b2.state !== a2 && Kg.enqueueReplaceState(b2, b2.state, null);
}
function Og(a2, b2, c3, d2) {
  var e2 = a2.stateNode;
  e2.props = c3;
  e2.state = a2.memoizedState;
  e2.refs = Fg;
  xg(a2);
  var f2 = b2.contextType;
  typeof f2 === "object" && f2 !== null ? e2.context = vg(f2) : (f2 = Ff(b2) ? Df : M.current, e2.context = Ef(a2, f2));
  Cg(a2, c3, e2, d2);
  e2.state = a2.memoizedState;
  f2 = b2.getDerivedStateFromProps;
  typeof f2 === "function" && (Gg(a2, b2, f2, c3), e2.state = a2.memoizedState);
  typeof b2.getDerivedStateFromProps === "function" || typeof e2.getSnapshotBeforeUpdate === "function" || typeof e2.UNSAFE_componentWillMount !== "function" && typeof e2.componentWillMount !== "function" || (b2 = e2.state, typeof e2.componentWillMount === "function" && e2.componentWillMount(), typeof e2.UNSAFE_componentWillMount === "function" && e2.UNSAFE_componentWillMount(), b2 !== e2.state && Kg.enqueueReplaceState(e2, e2.state, null), Cg(a2, c3, e2, d2), e2.state = a2.memoizedState);
  typeof e2.componentDidMount === "function" && (a2.flags |= 4);
}
var Pg = Array.isArray;
function Qg(a2, b2, c3) {
  a2 = c3.ref;
  if (a2 !== null && typeof a2 !== "function" && typeof a2 !== "object") {
    if (c3._owner) {
      c3 = c3._owner;
      if (c3) {
        if (c3.tag !== 1)
          throw Error(y(309));
        var d2 = c3.stateNode;
      }
      if (!d2)
        throw Error(y(147, a2));
      var e2 = "" + a2;
      if (b2 !== null && b2.ref !== null && typeof b2.ref === "function" && b2.ref._stringRef === e2)
        return b2.ref;
      b2 = function(a3) {
        var b3 = d2.refs;
        b3 === Fg && (b3 = d2.refs = {});
        a3 === null ? delete b3[e2] : b3[e2] = a3;
      };
      b2._stringRef = e2;
      return b2;
    }
    if (typeof a2 !== "string")
      throw Error(y(284));
    if (!c3._owner)
      throw Error(y(290, a2));
  }
  return a2;
}
function Rg(a2, b2) {
  if (a2.type !== "textarea")
    throw Error(y(31, Object.prototype.toString.call(b2) === "[object Object]" ? "object with keys {" + Object.keys(b2).join(", ") + "}" : b2));
}
function Sg(a2) {
  function b2(b3, c4) {
    if (a2) {
      var d3 = b3.lastEffect;
      d3 !== null ? (d3.nextEffect = c4, b3.lastEffect = c4) : b3.firstEffect = b3.lastEffect = c4;
      c4.nextEffect = null;
      c4.flags = 8;
    }
  }
  function c3(c4, d3) {
    if (!a2)
      return null;
    for (; d3 !== null; )
      b2(c4, d3), d3 = d3.sibling;
    return null;
  }
  function d2(a3, b3) {
    for (a3 = new Map(); b3 !== null; )
      b3.key !== null ? a3.set(b3.key, b3) : a3.set(b3.index, b3), b3 = b3.sibling;
    return a3;
  }
  function e2(a3, b3) {
    a3 = Tg(a3, b3);
    a3.index = 0;
    a3.sibling = null;
    return a3;
  }
  function f2(b3, c4, d3) {
    b3.index = d3;
    if (!a2)
      return c4;
    d3 = b3.alternate;
    if (d3 !== null)
      return d3 = d3.index, d3 < c4 ? (b3.flags = 2, c4) : d3;
    b3.flags = 2;
    return c4;
  }
  function g2(b3) {
    a2 && b3.alternate === null && (b3.flags = 2);
    return b3;
  }
  function h2(a3, b3, c4, d3) {
    if (b3 === null || b3.tag !== 6)
      return b3 = Ug(c4, a3.mode, d3), b3.return = a3, b3;
    b3 = e2(b3, c4);
    b3.return = a3;
    return b3;
  }
  function k2(a3, b3, c4, d3) {
    if (b3 !== null && b3.elementType === c4.type)
      return d3 = e2(b3, c4.props), d3.ref = Qg(a3, b3, c4), d3.return = a3, d3;
    d3 = Vg(c4.type, c4.key, c4.props, null, a3.mode, d3);
    d3.ref = Qg(a3, b3, c4);
    d3.return = a3;
    return d3;
  }
  function l2(a3, b3, c4, d3) {
    if (b3 === null || b3.tag !== 4 || b3.stateNode.containerInfo !== c4.containerInfo || b3.stateNode.implementation !== c4.implementation)
      return b3 = Wg(c4, a3.mode, d3), b3.return = a3, b3;
    b3 = e2(b3, c4.children || []);
    b3.return = a3;
    return b3;
  }
  function n3(a3, b3, c4, d3, f3) {
    if (b3 === null || b3.tag !== 7)
      return b3 = Xg(c4, a3.mode, d3, f3), b3.return = a3, b3;
    b3 = e2(b3, c4);
    b3.return = a3;
    return b3;
  }
  function A2(a3, b3, c4) {
    if (typeof b3 === "string" || typeof b3 === "number")
      return b3 = Ug("" + b3, a3.mode, c4), b3.return = a3, b3;
    if (typeof b3 === "object" && b3 !== null) {
      switch (b3.$$typeof) {
        case sa:
          return c4 = Vg(b3.type, b3.key, b3.props, null, a3.mode, c4), c4.ref = Qg(a3, null, b3), c4.return = a3, c4;
        case ta:
          return b3 = Wg(b3, a3.mode, c4), b3.return = a3, b3;
      }
      if (Pg(b3) || La(b3))
        return b3 = Xg(b3, a3.mode, c4, null), b3.return = a3, b3;
      Rg(a3, b3);
    }
    return null;
  }
  function p2(a3, b3, c4, d3) {
    var e3 = b3 !== null ? b3.key : null;
    if (typeof c4 === "string" || typeof c4 === "number")
      return e3 !== null ? null : h2(a3, b3, "" + c4, d3);
    if (typeof c4 === "object" && c4 !== null) {
      switch (c4.$$typeof) {
        case sa:
          return c4.key === e3 ? c4.type === ua ? n3(a3, b3, c4.props.children, d3, e3) : k2(a3, b3, c4, d3) : null;
        case ta:
          return c4.key === e3 ? l2(a3, b3, c4, d3) : null;
      }
      if (Pg(c4) || La(c4))
        return e3 !== null ? null : n3(a3, b3, c4, d3, null);
      Rg(a3, c4);
    }
    return null;
  }
  function C(a3, b3, c4, d3, e3) {
    if (typeof d3 === "string" || typeof d3 === "number")
      return a3 = a3.get(c4) || null, h2(b3, a3, "" + d3, e3);
    if (typeof d3 === "object" && d3 !== null) {
      switch (d3.$$typeof) {
        case sa:
          return a3 = a3.get(d3.key === null ? c4 : d3.key) || null, d3.type === ua ? n3(b3, a3, d3.props.children, e3, d3.key) : k2(b3, a3, d3, e3);
        case ta:
          return a3 = a3.get(d3.key === null ? c4 : d3.key) || null, l2(b3, a3, d3, e3);
      }
      if (Pg(d3) || La(d3))
        return a3 = a3.get(c4) || null, n3(b3, a3, d3, e3, null);
      Rg(b3, d3);
    }
    return null;
  }
  function x2(e3, g3, h3, k3) {
    for (var l3 = null, t5 = null, u = g3, z2 = g3 = 0, q2 = null; u !== null && z2 < h3.length; z2++) {
      u.index > z2 ? (q2 = u, u = null) : q2 = u.sibling;
      var n4 = p2(e3, u, h3[z2], k3);
      if (n4 === null) {
        u === null && (u = q2);
        break;
      }
      a2 && u && n4.alternate === null && b2(e3, u);
      g3 = f2(n4, g3, z2);
      t5 === null ? l3 = n4 : t5.sibling = n4;
      t5 = n4;
      u = q2;
    }
    if (z2 === h3.length)
      return c3(e3, u), l3;
    if (u === null) {
      for (; z2 < h3.length; z2++)
        u = A2(e3, h3[z2], k3), u !== null && (g3 = f2(u, g3, z2), t5 === null ? l3 = u : t5.sibling = u, t5 = u);
      return l3;
    }
    for (u = d2(e3, u); z2 < h3.length; z2++)
      q2 = C(u, e3, z2, h3[z2], k3), q2 !== null && (a2 && q2.alternate !== null && u.delete(q2.key === null ? z2 : q2.key), g3 = f2(q2, g3, z2), t5 === null ? l3 = q2 : t5.sibling = q2, t5 = q2);
    a2 && u.forEach(function(a3) {
      return b2(e3, a3);
    });
    return l3;
  }
  function w2(e3, g3, h3, k3) {
    var l3 = La(h3);
    if (typeof l3 !== "function")
      throw Error(y(150));
    h3 = l3.call(h3);
    if (h3 == null)
      throw Error(y(151));
    for (var t5 = l3 = null, u = g3, z2 = g3 = 0, q2 = null, n4 = h3.next(); u !== null && !n4.done; z2++, n4 = h3.next()) {
      u.index > z2 ? (q2 = u, u = null) : q2 = u.sibling;
      var w3 = p2(e3, u, n4.value, k3);
      if (w3 === null) {
        u === null && (u = q2);
        break;
      }
      a2 && u && w3.alternate === null && b2(e3, u);
      g3 = f2(w3, g3, z2);
      t5 === null ? l3 = w3 : t5.sibling = w3;
      t5 = w3;
      u = q2;
    }
    if (n4.done)
      return c3(e3, u), l3;
    if (u === null) {
      for (; !n4.done; z2++, n4 = h3.next())
        n4 = A2(e3, n4.value, k3), n4 !== null && (g3 = f2(n4, g3, z2), t5 === null ? l3 = n4 : t5.sibling = n4, t5 = n4);
      return l3;
    }
    for (u = d2(e3, u); !n4.done; z2++, n4 = h3.next())
      n4 = C(u, e3, z2, n4.value, k3), n4 !== null && (a2 && n4.alternate !== null && u.delete(n4.key === null ? z2 : n4.key), g3 = f2(n4, g3, z2), t5 === null ? l3 = n4 : t5.sibling = n4, t5 = n4);
    a2 && u.forEach(function(a3) {
      return b2(e3, a3);
    });
    return l3;
  }
  return function(a3, d3, f3, h3) {
    var k3 = typeof f3 === "object" && f3 !== null && f3.type === ua && f3.key === null;
    k3 && (f3 = f3.props.children);
    var l3 = typeof f3 === "object" && f3 !== null;
    if (l3)
      switch (f3.$$typeof) {
        case sa:
          a: {
            l3 = f3.key;
            for (k3 = d3; k3 !== null; ) {
              if (k3.key === l3) {
                switch (k3.tag) {
                  case 7:
                    if (f3.type === ua) {
                      c3(a3, k3.sibling);
                      d3 = e2(k3, f3.props.children);
                      d3.return = a3;
                      a3 = d3;
                      break a;
                    }
                    break;
                  default:
                    if (k3.elementType === f3.type) {
                      c3(a3, k3.sibling);
                      d3 = e2(k3, f3.props);
                      d3.ref = Qg(a3, k3, f3);
                      d3.return = a3;
                      a3 = d3;
                      break a;
                    }
                }
                c3(a3, k3);
                break;
              } else
                b2(a3, k3);
              k3 = k3.sibling;
            }
            f3.type === ua ? (d3 = Xg(f3.props.children, a3.mode, h3, f3.key), d3.return = a3, a3 = d3) : (h3 = Vg(f3.type, f3.key, f3.props, null, a3.mode, h3), h3.ref = Qg(a3, d3, f3), h3.return = a3, a3 = h3);
          }
          return g2(a3);
        case ta:
          a: {
            for (k3 = f3.key; d3 !== null; ) {
              if (d3.key === k3)
                if (d3.tag === 4 && d3.stateNode.containerInfo === f3.containerInfo && d3.stateNode.implementation === f3.implementation) {
                  c3(a3, d3.sibling);
                  d3 = e2(d3, f3.children || []);
                  d3.return = a3;
                  a3 = d3;
                  break a;
                } else {
                  c3(a3, d3);
                  break;
                }
              else
                b2(a3, d3);
              d3 = d3.sibling;
            }
            d3 = Wg(f3, a3.mode, h3);
            d3.return = a3;
            a3 = d3;
          }
          return g2(a3);
      }
    if (typeof f3 === "string" || typeof f3 === "number")
      return f3 = "" + f3, d3 !== null && d3.tag === 6 ? (c3(a3, d3.sibling), d3 = e2(d3, f3), d3.return = a3, a3 = d3) : (c3(a3, d3), d3 = Ug(f3, a3.mode, h3), d3.return = a3, a3 = d3), g2(a3);
    if (Pg(f3))
      return x2(a3, d3, f3, h3);
    if (La(f3))
      return w2(a3, d3, f3, h3);
    l3 && Rg(a3, f3);
    if (typeof f3 === "undefined" && !k3)
      switch (a3.tag) {
        case 1:
        case 22:
        case 0:
        case 11:
        case 15:
          throw Error(y(152, Ra(a3.type) || "Component"));
      }
    return c3(a3, d3);
  };
}
var Yg = Sg(true);
var Zg = Sg(false);
var $g = {};
var ah = Bf($g);
var bh = Bf($g);
var ch = Bf($g);
function dh(a2) {
  if (a2 === $g)
    throw Error(y(174));
  return a2;
}
function eh(a2, b2) {
  I(ch, b2);
  I(bh, a2);
  I(ah, $g);
  a2 = b2.nodeType;
  switch (a2) {
    case 9:
    case 11:
      b2 = (b2 = b2.documentElement) ? b2.namespaceURI : mb(null, "");
      break;
    default:
      a2 = a2 === 8 ? b2.parentNode : b2, b2 = a2.namespaceURI || null, a2 = a2.tagName, b2 = mb(b2, a2);
  }
  H(ah);
  I(ah, b2);
}
function fh() {
  H(ah);
  H(bh);
  H(ch);
}
function gh(a2) {
  dh(ch.current);
  var b2 = dh(ah.current);
  var c3 = mb(b2, a2.type);
  b2 !== c3 && (I(bh, a2), I(ah, c3));
}
function hh(a2) {
  bh.current === a2 && (H(ah), H(bh));
}
var P = Bf(0);
function ih(a2) {
  for (var b2 = a2; b2 !== null; ) {
    if (b2.tag === 13) {
      var c3 = b2.memoizedState;
      if (c3 !== null && (c3 = c3.dehydrated, c3 === null || c3.data === "$?" || c3.data === "$!"))
        return b2;
    } else if (b2.tag === 19 && b2.memoizedProps.revealOrder !== void 0) {
      if ((b2.flags & 64) !== 0)
        return b2;
    } else if (b2.child !== null) {
      b2.child.return = b2;
      b2 = b2.child;
      continue;
    }
    if (b2 === a2)
      break;
    for (; b2.sibling === null; ) {
      if (b2.return === null || b2.return === a2)
        return null;
      b2 = b2.return;
    }
    b2.sibling.return = b2.return;
    b2 = b2.sibling;
  }
  return null;
}
var jh = null;
var kh = null;
var lh = false;
function mh(a2, b2) {
  var c3 = nh(5, null, null, 0);
  c3.elementType = "DELETED";
  c3.type = "DELETED";
  c3.stateNode = b2;
  c3.return = a2;
  c3.flags = 8;
  a2.lastEffect !== null ? (a2.lastEffect.nextEffect = c3, a2.lastEffect = c3) : a2.firstEffect = a2.lastEffect = c3;
}
function oh(a2, b2) {
  switch (a2.tag) {
    case 5:
      var c3 = a2.type;
      b2 = b2.nodeType !== 1 || c3.toLowerCase() !== b2.nodeName.toLowerCase() ? null : b2;
      return b2 !== null ? (a2.stateNode = b2, true) : false;
    case 6:
      return b2 = a2.pendingProps === "" || b2.nodeType !== 3 ? null : b2, b2 !== null ? (a2.stateNode = b2, true) : false;
    case 13:
      return false;
    default:
      return false;
  }
}
function ph(a2) {
  if (lh) {
    var b2 = kh;
    if (b2) {
      var c3 = b2;
      if (!oh(a2, b2)) {
        b2 = rf(c3.nextSibling);
        if (!b2 || !oh(a2, b2)) {
          a2.flags = a2.flags & -1025 | 2;
          lh = false;
          jh = a2;
          return;
        }
        mh(jh, c3);
      }
      jh = a2;
      kh = rf(b2.firstChild);
    } else
      a2.flags = a2.flags & -1025 | 2, lh = false, jh = a2;
  }
}
function qh(a2) {
  for (a2 = a2.return; a2 !== null && a2.tag !== 5 && a2.tag !== 3 && a2.tag !== 13; )
    a2 = a2.return;
  jh = a2;
}
function rh(a2) {
  if (a2 !== jh)
    return false;
  if (!lh)
    return qh(a2), lh = true, false;
  var b2 = a2.type;
  if (a2.tag !== 5 || b2 !== "head" && b2 !== "body" && !nf(b2, a2.memoizedProps))
    for (b2 = kh; b2; )
      mh(a2, b2), b2 = rf(b2.nextSibling);
  qh(a2);
  if (a2.tag === 13) {
    a2 = a2.memoizedState;
    a2 = a2 !== null ? a2.dehydrated : null;
    if (!a2)
      throw Error(y(317));
    a: {
      a2 = a2.nextSibling;
      for (b2 = 0; a2; ) {
        if (a2.nodeType === 8) {
          var c3 = a2.data;
          if (c3 === "/$") {
            if (b2 === 0) {
              kh = rf(a2.nextSibling);
              break a;
            }
            b2--;
          } else
            c3 !== "$" && c3 !== "$!" && c3 !== "$?" || b2++;
        }
        a2 = a2.nextSibling;
      }
      kh = null;
    }
  } else
    kh = jh ? rf(a2.stateNode.nextSibling) : null;
  return true;
}
function sh() {
  kh = jh = null;
  lh = false;
}
var th = [];
function uh() {
  for (var a2 = 0; a2 < th.length; a2++)
    th[a2]._workInProgressVersionPrimary = null;
  th.length = 0;
}
var vh = ra.ReactCurrentDispatcher;
var wh = ra.ReactCurrentBatchConfig;
var xh = 0;
var R = null;
var S = null;
var T = null;
var yh = false;
var zh = false;
function Ah() {
  throw Error(y(321));
}
function Bh(a2, b2) {
  if (b2 === null)
    return false;
  for (var c3 = 0; c3 < b2.length && c3 < a2.length; c3++)
    if (!He(a2[c3], b2[c3]))
      return false;
  return true;
}
function Ch(a2, b2, c3, d2, e2, f2) {
  xh = f2;
  R = b2;
  b2.memoizedState = null;
  b2.updateQueue = null;
  b2.lanes = 0;
  vh.current = a2 === null || a2.memoizedState === null ? Dh : Eh;
  a2 = c3(d2, e2);
  if (zh) {
    f2 = 0;
    do {
      zh = false;
      if (!(25 > f2))
        throw Error(y(301));
      f2 += 1;
      T = S = null;
      b2.updateQueue = null;
      vh.current = Fh;
      a2 = c3(d2, e2);
    } while (zh);
  }
  vh.current = Gh;
  b2 = S !== null && S.next !== null;
  xh = 0;
  T = S = R = null;
  yh = false;
  if (b2)
    throw Error(y(300));
  return a2;
}
function Hh() {
  var a2 = {memoizedState: null, baseState: null, baseQueue: null, queue: null, next: null};
  T === null ? R.memoizedState = T = a2 : T = T.next = a2;
  return T;
}
function Ih() {
  if (S === null) {
    var a2 = R.alternate;
    a2 = a2 !== null ? a2.memoizedState : null;
  } else
    a2 = S.next;
  var b2 = T === null ? R.memoizedState : T.next;
  if (b2 !== null)
    T = b2, S = a2;
  else {
    if (a2 === null)
      throw Error(y(310));
    S = a2;
    a2 = {memoizedState: S.memoizedState, baseState: S.baseState, baseQueue: S.baseQueue, queue: S.queue, next: null};
    T === null ? R.memoizedState = T = a2 : T = T.next = a2;
  }
  return T;
}
function Jh(a2, b2) {
  return typeof b2 === "function" ? b2(a2) : b2;
}
function Kh(a2) {
  var b2 = Ih(), c3 = b2.queue;
  if (c3 === null)
    throw Error(y(311));
  c3.lastRenderedReducer = a2;
  var d2 = S, e2 = d2.baseQueue, f2 = c3.pending;
  if (f2 !== null) {
    if (e2 !== null) {
      var g2 = e2.next;
      e2.next = f2.next;
      f2.next = g2;
    }
    d2.baseQueue = e2 = f2;
    c3.pending = null;
  }
  if (e2 !== null) {
    e2 = e2.next;
    d2 = d2.baseState;
    var h2 = g2 = f2 = null, k2 = e2;
    do {
      var l2 = k2.lane;
      if ((xh & l2) === l2)
        h2 !== null && (h2 = h2.next = {lane: 0, action: k2.action, eagerReducer: k2.eagerReducer, eagerState: k2.eagerState, next: null}), d2 = k2.eagerReducer === a2 ? k2.eagerState : a2(d2, k2.action);
      else {
        var n3 = {
          lane: l2,
          action: k2.action,
          eagerReducer: k2.eagerReducer,
          eagerState: k2.eagerState,
          next: null
        };
        h2 === null ? (g2 = h2 = n3, f2 = d2) : h2 = h2.next = n3;
        R.lanes |= l2;
        Dg |= l2;
      }
      k2 = k2.next;
    } while (k2 !== null && k2 !== e2);
    h2 === null ? f2 = d2 : h2.next = g2;
    He(d2, b2.memoizedState) || (ug = true);
    b2.memoizedState = d2;
    b2.baseState = f2;
    b2.baseQueue = h2;
    c3.lastRenderedState = d2;
  }
  return [b2.memoizedState, c3.dispatch];
}
function Lh(a2) {
  var b2 = Ih(), c3 = b2.queue;
  if (c3 === null)
    throw Error(y(311));
  c3.lastRenderedReducer = a2;
  var d2 = c3.dispatch, e2 = c3.pending, f2 = b2.memoizedState;
  if (e2 !== null) {
    c3.pending = null;
    var g2 = e2 = e2.next;
    do
      f2 = a2(f2, g2.action), g2 = g2.next;
    while (g2 !== e2);
    He(f2, b2.memoizedState) || (ug = true);
    b2.memoizedState = f2;
    b2.baseQueue === null && (b2.baseState = f2);
    c3.lastRenderedState = f2;
  }
  return [f2, d2];
}
function Mh(a2, b2, c3) {
  var d2 = b2._getVersion;
  d2 = d2(b2._source);
  var e2 = b2._workInProgressVersionPrimary;
  if (e2 !== null)
    a2 = e2 === d2;
  else if (a2 = a2.mutableReadLanes, a2 = (xh & a2) === a2)
    b2._workInProgressVersionPrimary = d2, th.push(b2);
  if (a2)
    return c3(b2._source);
  th.push(b2);
  throw Error(y(350));
}
function Nh(a2, b2, c3, d2) {
  var e2 = U;
  if (e2 === null)
    throw Error(y(349));
  var f2 = b2._getVersion, g2 = f2(b2._source), h2 = vh.current, k2 = h2.useState(function() {
    return Mh(e2, b2, c3);
  }), l2 = k2[1], n3 = k2[0];
  k2 = T;
  var A2 = a2.memoizedState, p2 = A2.refs, C = p2.getSnapshot, x2 = A2.source;
  A2 = A2.subscribe;
  var w2 = R;
  a2.memoizedState = {refs: p2, source: b2, subscribe: d2};
  h2.useEffect(function() {
    p2.getSnapshot = c3;
    p2.setSnapshot = l2;
    var a3 = f2(b2._source);
    if (!He(g2, a3)) {
      a3 = c3(b2._source);
      He(n3, a3) || (l2(a3), a3 = Ig(w2), e2.mutableReadLanes |= a3 & e2.pendingLanes);
      a3 = e2.mutableReadLanes;
      e2.entangledLanes |= a3;
      for (var d3 = e2.entanglements, h3 = a3; 0 < h3; ) {
        var k3 = 31 - Vc(h3), v2 = 1 << k3;
        d3[k3] |= a3;
        h3 &= ~v2;
      }
    }
  }, [c3, b2, d2]);
  h2.useEffect(function() {
    return d2(b2._source, function() {
      var a3 = p2.getSnapshot, c4 = p2.setSnapshot;
      try {
        c4(a3(b2._source));
        var d3 = Ig(w2);
        e2.mutableReadLanes |= d3 & e2.pendingLanes;
      } catch (q2) {
        c4(function() {
          throw q2;
        });
      }
    });
  }, [b2, d2]);
  He(C, c3) && He(x2, b2) && He(A2, d2) || (a2 = {pending: null, dispatch: null, lastRenderedReducer: Jh, lastRenderedState: n3}, a2.dispatch = l2 = Oh.bind(null, R, a2), k2.queue = a2, k2.baseQueue = null, n3 = Mh(e2, b2, c3), k2.memoizedState = k2.baseState = n3);
  return n3;
}
function Ph(a2, b2, c3) {
  var d2 = Ih();
  return Nh(d2, a2, b2, c3);
}
function Qh(a2) {
  var b2 = Hh();
  typeof a2 === "function" && (a2 = a2());
  b2.memoizedState = b2.baseState = a2;
  a2 = b2.queue = {pending: null, dispatch: null, lastRenderedReducer: Jh, lastRenderedState: a2};
  a2 = a2.dispatch = Oh.bind(null, R, a2);
  return [b2.memoizedState, a2];
}
function Rh(a2, b2, c3, d2) {
  a2 = {tag: a2, create: b2, destroy: c3, deps: d2, next: null};
  b2 = R.updateQueue;
  b2 === null ? (b2 = {lastEffect: null}, R.updateQueue = b2, b2.lastEffect = a2.next = a2) : (c3 = b2.lastEffect, c3 === null ? b2.lastEffect = a2.next = a2 : (d2 = c3.next, c3.next = a2, a2.next = d2, b2.lastEffect = a2));
  return a2;
}
function Sh(a2) {
  var b2 = Hh();
  a2 = {current: a2};
  return b2.memoizedState = a2;
}
function Th() {
  return Ih().memoizedState;
}
function Uh(a2, b2, c3, d2) {
  var e2 = Hh();
  R.flags |= a2;
  e2.memoizedState = Rh(1 | b2, c3, void 0, d2 === void 0 ? null : d2);
}
function Vh(a2, b2, c3, d2) {
  var e2 = Ih();
  d2 = d2 === void 0 ? null : d2;
  var f2 = void 0;
  if (S !== null) {
    var g2 = S.memoizedState;
    f2 = g2.destroy;
    if (d2 !== null && Bh(d2, g2.deps)) {
      Rh(b2, c3, f2, d2);
      return;
    }
  }
  R.flags |= a2;
  e2.memoizedState = Rh(1 | b2, c3, f2, d2);
}
function Wh(a2, b2) {
  return Uh(516, 4, a2, b2);
}
function Xh(a2, b2) {
  return Vh(516, 4, a2, b2);
}
function Yh(a2, b2) {
  return Vh(4, 2, a2, b2);
}
function Zh(a2, b2) {
  if (typeof b2 === "function")
    return a2 = a2(), b2(a2), function() {
      b2(null);
    };
  if (b2 !== null && b2 !== void 0)
    return a2 = a2(), b2.current = a2, function() {
      b2.current = null;
    };
}
function $h(a2, b2, c3) {
  c3 = c3 !== null && c3 !== void 0 ? c3.concat([a2]) : null;
  return Vh(4, 2, Zh.bind(null, b2, a2), c3);
}
function ai() {
}
function bi(a2, b2) {
  var c3 = Ih();
  b2 = b2 === void 0 ? null : b2;
  var d2 = c3.memoizedState;
  if (d2 !== null && b2 !== null && Bh(b2, d2[1]))
    return d2[0];
  c3.memoizedState = [a2, b2];
  return a2;
}
function ci(a2, b2) {
  var c3 = Ih();
  b2 = b2 === void 0 ? null : b2;
  var d2 = c3.memoizedState;
  if (d2 !== null && b2 !== null && Bh(b2, d2[1]))
    return d2[0];
  a2 = a2();
  c3.memoizedState = [a2, b2];
  return a2;
}
function di(a2, b2) {
  var c3 = eg();
  gg(98 > c3 ? 98 : c3, function() {
    a2(true);
  });
  gg(97 < c3 ? 97 : c3, function() {
    var c4 = wh.transition;
    wh.transition = 1;
    try {
      a2(false), b2();
    } finally {
      wh.transition = c4;
    }
  });
}
function Oh(a2, b2, c3) {
  var d2 = Hg(), e2 = Ig(a2), f2 = {lane: e2, action: c3, eagerReducer: null, eagerState: null, next: null}, g2 = b2.pending;
  g2 === null ? f2.next = f2 : (f2.next = g2.next, g2.next = f2);
  b2.pending = f2;
  g2 = a2.alternate;
  if (a2 === R || g2 !== null && g2 === R)
    zh = yh = true;
  else {
    if (a2.lanes === 0 && (g2 === null || g2.lanes === 0) && (g2 = b2.lastRenderedReducer, g2 !== null))
      try {
        var h2 = b2.lastRenderedState, k2 = g2(h2, c3);
        f2.eagerReducer = g2;
        f2.eagerState = k2;
        if (He(k2, h2))
          return;
      } catch (l2) {
      } finally {
      }
    Jg(a2, e2, d2);
  }
}
var Gh = {readContext: vg, useCallback: Ah, useContext: Ah, useEffect: Ah, useImperativeHandle: Ah, useLayoutEffect: Ah, useMemo: Ah, useReducer: Ah, useRef: Ah, useState: Ah, useDebugValue: Ah, useDeferredValue: Ah, useTransition: Ah, useMutableSource: Ah, useOpaqueIdentifier: Ah, unstable_isNewReconciler: false};
var Dh = {readContext: vg, useCallback: function(a2, b2) {
  Hh().memoizedState = [a2, b2 === void 0 ? null : b2];
  return a2;
}, useContext: vg, useEffect: Wh, useImperativeHandle: function(a2, b2, c3) {
  c3 = c3 !== null && c3 !== void 0 ? c3.concat([a2]) : null;
  return Uh(4, 2, Zh.bind(null, b2, a2), c3);
}, useLayoutEffect: function(a2, b2) {
  return Uh(4, 2, a2, b2);
}, useMemo: function(a2, b2) {
  var c3 = Hh();
  b2 = b2 === void 0 ? null : b2;
  a2 = a2();
  c3.memoizedState = [a2, b2];
  return a2;
}, useReducer: function(a2, b2, c3) {
  var d2 = Hh();
  b2 = c3 !== void 0 ? c3(b2) : b2;
  d2.memoizedState = d2.baseState = b2;
  a2 = d2.queue = {pending: null, dispatch: null, lastRenderedReducer: a2, lastRenderedState: b2};
  a2 = a2.dispatch = Oh.bind(null, R, a2);
  return [d2.memoizedState, a2];
}, useRef: Sh, useState: Qh, useDebugValue: ai, useDeferredValue: function(a2) {
  var b2 = Qh(a2), c3 = b2[0], d2 = b2[1];
  Wh(function() {
    var b3 = wh.transition;
    wh.transition = 1;
    try {
      d2(a2);
    } finally {
      wh.transition = b3;
    }
  }, [a2]);
  return c3;
}, useTransition: function() {
  var a2 = Qh(false), b2 = a2[0];
  a2 = di.bind(null, a2[1]);
  Sh(a2);
  return [a2, b2];
}, useMutableSource: function(a2, b2, c3) {
  var d2 = Hh();
  d2.memoizedState = {refs: {getSnapshot: b2, setSnapshot: null}, source: a2, subscribe: c3};
  return Nh(d2, a2, b2, c3);
}, useOpaqueIdentifier: function() {
  if (lh) {
    var a2 = false, b2 = uf(function() {
      a2 || (a2 = true, c3("r:" + (tf++).toString(36)));
      throw Error(y(355));
    }), c3 = Qh(b2)[1];
    (R.mode & 2) === 0 && (R.flags |= 516, Rh(5, function() {
      c3("r:" + (tf++).toString(36));
    }, void 0, null));
    return b2;
  }
  b2 = "r:" + (tf++).toString(36);
  Qh(b2);
  return b2;
}, unstable_isNewReconciler: false};
var Eh = {readContext: vg, useCallback: bi, useContext: vg, useEffect: Xh, useImperativeHandle: $h, useLayoutEffect: Yh, useMemo: ci, useReducer: Kh, useRef: Th, useState: function() {
  return Kh(Jh);
}, useDebugValue: ai, useDeferredValue: function(a2) {
  var b2 = Kh(Jh), c3 = b2[0], d2 = b2[1];
  Xh(function() {
    var b3 = wh.transition;
    wh.transition = 1;
    try {
      d2(a2);
    } finally {
      wh.transition = b3;
    }
  }, [a2]);
  return c3;
}, useTransition: function() {
  var a2 = Kh(Jh)[0];
  return [
    Th().current,
    a2
  ];
}, useMutableSource: Ph, useOpaqueIdentifier: function() {
  return Kh(Jh)[0];
}, unstable_isNewReconciler: false};
var Fh = {readContext: vg, useCallback: bi, useContext: vg, useEffect: Xh, useImperativeHandle: $h, useLayoutEffect: Yh, useMemo: ci, useReducer: Lh, useRef: Th, useState: function() {
  return Lh(Jh);
}, useDebugValue: ai, useDeferredValue: function(a2) {
  var b2 = Lh(Jh), c3 = b2[0], d2 = b2[1];
  Xh(function() {
    var b3 = wh.transition;
    wh.transition = 1;
    try {
      d2(a2);
    } finally {
      wh.transition = b3;
    }
  }, [a2]);
  return c3;
}, useTransition: function() {
  var a2 = Lh(Jh)[0];
  return [
    Th().current,
    a2
  ];
}, useMutableSource: Ph, useOpaqueIdentifier: function() {
  return Lh(Jh)[0];
}, unstable_isNewReconciler: false};
var ei = ra.ReactCurrentOwner;
var ug = false;
function fi(a2, b2, c3, d2) {
  b2.child = a2 === null ? Zg(b2, null, c3, d2) : Yg(b2, a2.child, c3, d2);
}
function gi(a2, b2, c3, d2, e2) {
  c3 = c3.render;
  var f2 = b2.ref;
  tg(b2, e2);
  d2 = Ch(a2, b2, c3, d2, f2, e2);
  if (a2 !== null && !ug)
    return b2.updateQueue = a2.updateQueue, b2.flags &= -517, a2.lanes &= ~e2, hi(a2, b2, e2);
  b2.flags |= 1;
  fi(a2, b2, d2, e2);
  return b2.child;
}
function ii(a2, b2, c3, d2, e2, f2) {
  if (a2 === null) {
    var g2 = c3.type;
    if (typeof g2 === "function" && !ji(g2) && g2.defaultProps === void 0 && c3.compare === null && c3.defaultProps === void 0)
      return b2.tag = 15, b2.type = g2, ki(a2, b2, g2, d2, e2, f2);
    a2 = Vg(c3.type, null, d2, b2, b2.mode, f2);
    a2.ref = b2.ref;
    a2.return = b2;
    return b2.child = a2;
  }
  g2 = a2.child;
  if ((e2 & f2) === 0 && (e2 = g2.memoizedProps, c3 = c3.compare, c3 = c3 !== null ? c3 : Je, c3(e2, d2) && a2.ref === b2.ref))
    return hi(a2, b2, f2);
  b2.flags |= 1;
  a2 = Tg(g2, d2);
  a2.ref = b2.ref;
  a2.return = b2;
  return b2.child = a2;
}
function ki(a2, b2, c3, d2, e2, f2) {
  if (a2 !== null && Je(a2.memoizedProps, d2) && a2.ref === b2.ref)
    if (ug = false, (f2 & e2) !== 0)
      (a2.flags & 16384) !== 0 && (ug = true);
    else
      return b2.lanes = a2.lanes, hi(a2, b2, f2);
  return li(a2, b2, c3, d2, f2);
}
function mi(a2, b2, c3) {
  var d2 = b2.pendingProps, e2 = d2.children, f2 = a2 !== null ? a2.memoizedState : null;
  if (d2.mode === "hidden" || d2.mode === "unstable-defer-without-hiding")
    if ((b2.mode & 4) === 0)
      b2.memoizedState = {baseLanes: 0}, ni(b2, c3);
    else if ((c3 & 1073741824) !== 0)
      b2.memoizedState = {baseLanes: 0}, ni(b2, f2 !== null ? f2.baseLanes : c3);
    else
      return a2 = f2 !== null ? f2.baseLanes | c3 : c3, b2.lanes = b2.childLanes = 1073741824, b2.memoizedState = {baseLanes: a2}, ni(b2, a2), null;
  else
    f2 !== null ? (d2 = f2.baseLanes | c3, b2.memoizedState = null) : d2 = c3, ni(b2, d2);
  fi(a2, b2, e2, c3);
  return b2.child;
}
function oi(a2, b2) {
  var c3 = b2.ref;
  if (a2 === null && c3 !== null || a2 !== null && a2.ref !== c3)
    b2.flags |= 128;
}
function li(a2, b2, c3, d2, e2) {
  var f2 = Ff(c3) ? Df : M.current;
  f2 = Ef(b2, f2);
  tg(b2, e2);
  c3 = Ch(a2, b2, c3, d2, f2, e2);
  if (a2 !== null && !ug)
    return b2.updateQueue = a2.updateQueue, b2.flags &= -517, a2.lanes &= ~e2, hi(a2, b2, e2);
  b2.flags |= 1;
  fi(a2, b2, c3, e2);
  return b2.child;
}
function pi(a2, b2, c3, d2, e2) {
  if (Ff(c3)) {
    var f2 = true;
    Jf(b2);
  } else
    f2 = false;
  tg(b2, e2);
  if (b2.stateNode === null)
    a2 !== null && (a2.alternate = null, b2.alternate = null, b2.flags |= 2), Mg(b2, c3, d2), Og(b2, c3, d2, e2), d2 = true;
  else if (a2 === null) {
    var g2 = b2.stateNode, h2 = b2.memoizedProps;
    g2.props = h2;
    var k2 = g2.context, l2 = c3.contextType;
    typeof l2 === "object" && l2 !== null ? l2 = vg(l2) : (l2 = Ff(c3) ? Df : M.current, l2 = Ef(b2, l2));
    var n3 = c3.getDerivedStateFromProps, A2 = typeof n3 === "function" || typeof g2.getSnapshotBeforeUpdate === "function";
    A2 || typeof g2.UNSAFE_componentWillReceiveProps !== "function" && typeof g2.componentWillReceiveProps !== "function" || (h2 !== d2 || k2 !== l2) && Ng(b2, g2, d2, l2);
    wg = false;
    var p2 = b2.memoizedState;
    g2.state = p2;
    Cg(b2, d2, g2, e2);
    k2 = b2.memoizedState;
    h2 !== d2 || p2 !== k2 || N.current || wg ? (typeof n3 === "function" && (Gg(b2, c3, n3, d2), k2 = b2.memoizedState), (h2 = wg || Lg(b2, c3, h2, d2, p2, k2, l2)) ? (A2 || typeof g2.UNSAFE_componentWillMount !== "function" && typeof g2.componentWillMount !== "function" || (typeof g2.componentWillMount === "function" && g2.componentWillMount(), typeof g2.UNSAFE_componentWillMount === "function" && g2.UNSAFE_componentWillMount()), typeof g2.componentDidMount === "function" && (b2.flags |= 4)) : (typeof g2.componentDidMount === "function" && (b2.flags |= 4), b2.memoizedProps = d2, b2.memoizedState = k2), g2.props = d2, g2.state = k2, g2.context = l2, d2 = h2) : (typeof g2.componentDidMount === "function" && (b2.flags |= 4), d2 = false);
  } else {
    g2 = b2.stateNode;
    yg(a2, b2);
    h2 = b2.memoizedProps;
    l2 = b2.type === b2.elementType ? h2 : lg(b2.type, h2);
    g2.props = l2;
    A2 = b2.pendingProps;
    p2 = g2.context;
    k2 = c3.contextType;
    typeof k2 === "object" && k2 !== null ? k2 = vg(k2) : (k2 = Ff(c3) ? Df : M.current, k2 = Ef(b2, k2));
    var C = c3.getDerivedStateFromProps;
    (n3 = typeof C === "function" || typeof g2.getSnapshotBeforeUpdate === "function") || typeof g2.UNSAFE_componentWillReceiveProps !== "function" && typeof g2.componentWillReceiveProps !== "function" || (h2 !== A2 || p2 !== k2) && Ng(b2, g2, d2, k2);
    wg = false;
    p2 = b2.memoizedState;
    g2.state = p2;
    Cg(b2, d2, g2, e2);
    var x2 = b2.memoizedState;
    h2 !== A2 || p2 !== x2 || N.current || wg ? (typeof C === "function" && (Gg(b2, c3, C, d2), x2 = b2.memoizedState), (l2 = wg || Lg(b2, c3, l2, d2, p2, x2, k2)) ? (n3 || typeof g2.UNSAFE_componentWillUpdate !== "function" && typeof g2.componentWillUpdate !== "function" || (typeof g2.componentWillUpdate === "function" && g2.componentWillUpdate(d2, x2, k2), typeof g2.UNSAFE_componentWillUpdate === "function" && g2.UNSAFE_componentWillUpdate(d2, x2, k2)), typeof g2.componentDidUpdate === "function" && (b2.flags |= 4), typeof g2.getSnapshotBeforeUpdate === "function" && (b2.flags |= 256)) : (typeof g2.componentDidUpdate !== "function" || h2 === a2.memoizedProps && p2 === a2.memoizedState || (b2.flags |= 4), typeof g2.getSnapshotBeforeUpdate !== "function" || h2 === a2.memoizedProps && p2 === a2.memoizedState || (b2.flags |= 256), b2.memoizedProps = d2, b2.memoizedState = x2), g2.props = d2, g2.state = x2, g2.context = k2, d2 = l2) : (typeof g2.componentDidUpdate !== "function" || h2 === a2.memoizedProps && p2 === a2.memoizedState || (b2.flags |= 4), typeof g2.getSnapshotBeforeUpdate !== "function" || h2 === a2.memoizedProps && p2 === a2.memoizedState || (b2.flags |= 256), d2 = false);
  }
  return qi(a2, b2, c3, d2, f2, e2);
}
function qi(a2, b2, c3, d2, e2, f2) {
  oi(a2, b2);
  var g2 = (b2.flags & 64) !== 0;
  if (!d2 && !g2)
    return e2 && Kf(b2, c3, false), hi(a2, b2, f2);
  d2 = b2.stateNode;
  ei.current = b2;
  var h2 = g2 && typeof c3.getDerivedStateFromError !== "function" ? null : d2.render();
  b2.flags |= 1;
  a2 !== null && g2 ? (b2.child = Yg(b2, a2.child, null, f2), b2.child = Yg(b2, null, h2, f2)) : fi(a2, b2, h2, f2);
  b2.memoizedState = d2.state;
  e2 && Kf(b2, c3, true);
  return b2.child;
}
function ri(a2) {
  var b2 = a2.stateNode;
  b2.pendingContext ? Hf(a2, b2.pendingContext, b2.pendingContext !== b2.context) : b2.context && Hf(a2, b2.context, false);
  eh(a2, b2.containerInfo);
}
var si = {dehydrated: null, retryLane: 0};
function ti(a2, b2, c3) {
  var d2 = b2.pendingProps, e2 = P.current, f2 = false, g2;
  (g2 = (b2.flags & 64) !== 0) || (g2 = a2 !== null && a2.memoizedState === null ? false : (e2 & 2) !== 0);
  g2 ? (f2 = true, b2.flags &= -65) : a2 !== null && a2.memoizedState === null || d2.fallback === void 0 || d2.unstable_avoidThisFallback === true || (e2 |= 1);
  I(P, e2 & 1);
  if (a2 === null) {
    d2.fallback !== void 0 && ph(b2);
    a2 = d2.children;
    e2 = d2.fallback;
    if (f2)
      return a2 = ui(b2, a2, e2, c3), b2.child.memoizedState = {baseLanes: c3}, b2.memoizedState = si, a2;
    if (typeof d2.unstable_expectedLoadTime === "number")
      return a2 = ui(b2, a2, e2, c3), b2.child.memoizedState = {baseLanes: c3}, b2.memoizedState = si, b2.lanes = 33554432, a2;
    c3 = vi({mode: "visible", children: a2}, b2.mode, c3, null);
    c3.return = b2;
    return b2.child = c3;
  }
  if (a2.memoizedState !== null) {
    if (f2)
      return d2 = wi(a2, b2, d2.children, d2.fallback, c3), f2 = b2.child, e2 = a2.child.memoizedState, f2.memoizedState = e2 === null ? {baseLanes: c3} : {baseLanes: e2.baseLanes | c3}, f2.childLanes = a2.childLanes & ~c3, b2.memoizedState = si, d2;
    c3 = xi(a2, b2, d2.children, c3);
    b2.memoizedState = null;
    return c3;
  }
  if (f2)
    return d2 = wi(a2, b2, d2.children, d2.fallback, c3), f2 = b2.child, e2 = a2.child.memoizedState, f2.memoizedState = e2 === null ? {baseLanes: c3} : {baseLanes: e2.baseLanes | c3}, f2.childLanes = a2.childLanes & ~c3, b2.memoizedState = si, d2;
  c3 = xi(a2, b2, d2.children, c3);
  b2.memoizedState = null;
  return c3;
}
function ui(a2, b2, c3, d2) {
  var e2 = a2.mode, f2 = a2.child;
  b2 = {mode: "hidden", children: b2};
  (e2 & 2) === 0 && f2 !== null ? (f2.childLanes = 0, f2.pendingProps = b2) : f2 = vi(b2, e2, 0, null);
  c3 = Xg(c3, e2, d2, null);
  f2.return = a2;
  c3.return = a2;
  f2.sibling = c3;
  a2.child = f2;
  return c3;
}
function xi(a2, b2, c3, d2) {
  var e2 = a2.child;
  a2 = e2.sibling;
  c3 = Tg(e2, {mode: "visible", children: c3});
  (b2.mode & 2) === 0 && (c3.lanes = d2);
  c3.return = b2;
  c3.sibling = null;
  a2 !== null && (a2.nextEffect = null, a2.flags = 8, b2.firstEffect = b2.lastEffect = a2);
  return b2.child = c3;
}
function wi(a2, b2, c3, d2, e2) {
  var f2 = b2.mode, g2 = a2.child;
  a2 = g2.sibling;
  var h2 = {mode: "hidden", children: c3};
  (f2 & 2) === 0 && b2.child !== g2 ? (c3 = b2.child, c3.childLanes = 0, c3.pendingProps = h2, g2 = c3.lastEffect, g2 !== null ? (b2.firstEffect = c3.firstEffect, b2.lastEffect = g2, g2.nextEffect = null) : b2.firstEffect = b2.lastEffect = null) : c3 = Tg(g2, h2);
  a2 !== null ? d2 = Tg(a2, d2) : (d2 = Xg(d2, f2, e2, null), d2.flags |= 2);
  d2.return = b2;
  c3.return = b2;
  c3.sibling = d2;
  b2.child = c3;
  return d2;
}
function yi(a2, b2) {
  a2.lanes |= b2;
  var c3 = a2.alternate;
  c3 !== null && (c3.lanes |= b2);
  sg(a2.return, b2);
}
function zi(a2, b2, c3, d2, e2, f2) {
  var g2 = a2.memoizedState;
  g2 === null ? a2.memoizedState = {isBackwards: b2, rendering: null, renderingStartTime: 0, last: d2, tail: c3, tailMode: e2, lastEffect: f2} : (g2.isBackwards = b2, g2.rendering = null, g2.renderingStartTime = 0, g2.last = d2, g2.tail = c3, g2.tailMode = e2, g2.lastEffect = f2);
}
function Ai(a2, b2, c3) {
  var d2 = b2.pendingProps, e2 = d2.revealOrder, f2 = d2.tail;
  fi(a2, b2, d2.children, c3);
  d2 = P.current;
  if ((d2 & 2) !== 0)
    d2 = d2 & 1 | 2, b2.flags |= 64;
  else {
    if (a2 !== null && (a2.flags & 64) !== 0)
      a:
        for (a2 = b2.child; a2 !== null; ) {
          if (a2.tag === 13)
            a2.memoizedState !== null && yi(a2, c3);
          else if (a2.tag === 19)
            yi(a2, c3);
          else if (a2.child !== null) {
            a2.child.return = a2;
            a2 = a2.child;
            continue;
          }
          if (a2 === b2)
            break a;
          for (; a2.sibling === null; ) {
            if (a2.return === null || a2.return === b2)
              break a;
            a2 = a2.return;
          }
          a2.sibling.return = a2.return;
          a2 = a2.sibling;
        }
    d2 &= 1;
  }
  I(P, d2);
  if ((b2.mode & 2) === 0)
    b2.memoizedState = null;
  else
    switch (e2) {
      case "forwards":
        c3 = b2.child;
        for (e2 = null; c3 !== null; )
          a2 = c3.alternate, a2 !== null && ih(a2) === null && (e2 = c3), c3 = c3.sibling;
        c3 = e2;
        c3 === null ? (e2 = b2.child, b2.child = null) : (e2 = c3.sibling, c3.sibling = null);
        zi(b2, false, e2, c3, f2, b2.lastEffect);
        break;
      case "backwards":
        c3 = null;
        e2 = b2.child;
        for (b2.child = null; e2 !== null; ) {
          a2 = e2.alternate;
          if (a2 !== null && ih(a2) === null) {
            b2.child = e2;
            break;
          }
          a2 = e2.sibling;
          e2.sibling = c3;
          c3 = e2;
          e2 = a2;
        }
        zi(b2, true, c3, null, f2, b2.lastEffect);
        break;
      case "together":
        zi(b2, false, null, null, void 0, b2.lastEffect);
        break;
      default:
        b2.memoizedState = null;
    }
  return b2.child;
}
function hi(a2, b2, c3) {
  a2 !== null && (b2.dependencies = a2.dependencies);
  Dg |= b2.lanes;
  if ((c3 & b2.childLanes) !== 0) {
    if (a2 !== null && b2.child !== a2.child)
      throw Error(y(153));
    if (b2.child !== null) {
      a2 = b2.child;
      c3 = Tg(a2, a2.pendingProps);
      b2.child = c3;
      for (c3.return = b2; a2.sibling !== null; )
        a2 = a2.sibling, c3 = c3.sibling = Tg(a2, a2.pendingProps), c3.return = b2;
      c3.sibling = null;
    }
    return b2.child;
  }
  return null;
}
var Bi;
var Ci;
var Di;
var Ei;
Bi = function(a2, b2) {
  for (var c3 = b2.child; c3 !== null; ) {
    if (c3.tag === 5 || c3.tag === 6)
      a2.appendChild(c3.stateNode);
    else if (c3.tag !== 4 && c3.child !== null) {
      c3.child.return = c3;
      c3 = c3.child;
      continue;
    }
    if (c3 === b2)
      break;
    for (; c3.sibling === null; ) {
      if (c3.return === null || c3.return === b2)
        return;
      c3 = c3.return;
    }
    c3.sibling.return = c3.return;
    c3 = c3.sibling;
  }
};
Ci = function() {
};
Di = function(a2, b2, c3, d2) {
  var e2 = a2.memoizedProps;
  if (e2 !== d2) {
    a2 = b2.stateNode;
    dh(ah.current);
    var f2 = null;
    switch (c3) {
      case "input":
        e2 = Ya(a2, e2);
        d2 = Ya(a2, d2);
        f2 = [];
        break;
      case "option":
        e2 = eb(a2, e2);
        d2 = eb(a2, d2);
        f2 = [];
        break;
      case "select":
        e2 = objectAssign({}, e2, {value: void 0});
        d2 = objectAssign({}, d2, {value: void 0});
        f2 = [];
        break;
      case "textarea":
        e2 = gb(a2, e2);
        d2 = gb(a2, d2);
        f2 = [];
        break;
      default:
        typeof e2.onClick !== "function" && typeof d2.onClick === "function" && (a2.onclick = jf);
    }
    vb(c3, d2);
    var g2;
    c3 = null;
    for (l2 in e2)
      if (!d2.hasOwnProperty(l2) && e2.hasOwnProperty(l2) && e2[l2] != null)
        if (l2 === "style") {
          var h2 = e2[l2];
          for (g2 in h2)
            h2.hasOwnProperty(g2) && (c3 || (c3 = {}), c3[g2] = "");
        } else
          l2 !== "dangerouslySetInnerHTML" && l2 !== "children" && l2 !== "suppressContentEditableWarning" && l2 !== "suppressHydrationWarning" && l2 !== "autoFocus" && (ca.hasOwnProperty(l2) ? f2 || (f2 = []) : (f2 = f2 || []).push(l2, null));
    for (l2 in d2) {
      var k2 = d2[l2];
      h2 = e2 != null ? e2[l2] : void 0;
      if (d2.hasOwnProperty(l2) && k2 !== h2 && (k2 != null || h2 != null))
        if (l2 === "style")
          if (h2) {
            for (g2 in h2)
              !h2.hasOwnProperty(g2) || k2 && k2.hasOwnProperty(g2) || (c3 || (c3 = {}), c3[g2] = "");
            for (g2 in k2)
              k2.hasOwnProperty(g2) && h2[g2] !== k2[g2] && (c3 || (c3 = {}), c3[g2] = k2[g2]);
          } else
            c3 || (f2 || (f2 = []), f2.push(l2, c3)), c3 = k2;
        else
          l2 === "dangerouslySetInnerHTML" ? (k2 = k2 ? k2.__html : void 0, h2 = h2 ? h2.__html : void 0, k2 != null && h2 !== k2 && (f2 = f2 || []).push(l2, k2)) : l2 === "children" ? typeof k2 !== "string" && typeof k2 !== "number" || (f2 = f2 || []).push(l2, "" + k2) : l2 !== "suppressContentEditableWarning" && l2 !== "suppressHydrationWarning" && (ca.hasOwnProperty(l2) ? (k2 != null && l2 === "onScroll" && G("scroll", a2), f2 || h2 === k2 || (f2 = [])) : typeof k2 === "object" && k2 !== null && k2.$$typeof === Ga ? k2.toString() : (f2 = f2 || []).push(l2, k2));
    }
    c3 && (f2 = f2 || []).push("style", c3);
    var l2 = f2;
    if (b2.updateQueue = l2)
      b2.flags |= 4;
  }
};
Ei = function(a2, b2, c3, d2) {
  c3 !== d2 && (b2.flags |= 4);
};
function Fi(a2, b2) {
  if (!lh)
    switch (a2.tailMode) {
      case "hidden":
        b2 = a2.tail;
        for (var c3 = null; b2 !== null; )
          b2.alternate !== null && (c3 = b2), b2 = b2.sibling;
        c3 === null ? a2.tail = null : c3.sibling = null;
        break;
      case "collapsed":
        c3 = a2.tail;
        for (var d2 = null; c3 !== null; )
          c3.alternate !== null && (d2 = c3), c3 = c3.sibling;
        d2 === null ? b2 || a2.tail === null ? a2.tail = null : a2.tail.sibling = null : d2.sibling = null;
    }
}
function Gi(a2, b2, c3) {
  var d2 = b2.pendingProps;
  switch (b2.tag) {
    case 2:
    case 16:
    case 15:
    case 0:
    case 11:
    case 7:
    case 8:
    case 12:
    case 9:
    case 14:
      return null;
    case 1:
      return Ff(b2.type) && Gf(), null;
    case 3:
      fh();
      H(N);
      H(M);
      uh();
      d2 = b2.stateNode;
      d2.pendingContext && (d2.context = d2.pendingContext, d2.pendingContext = null);
      if (a2 === null || a2.child === null)
        rh(b2) ? b2.flags |= 4 : d2.hydrate || (b2.flags |= 256);
      Ci(b2);
      return null;
    case 5:
      hh(b2);
      var e2 = dh(ch.current);
      c3 = b2.type;
      if (a2 !== null && b2.stateNode != null)
        Di(a2, b2, c3, d2, e2), a2.ref !== b2.ref && (b2.flags |= 128);
      else {
        if (!d2) {
          if (b2.stateNode === null)
            throw Error(y(166));
          return null;
        }
        a2 = dh(ah.current);
        if (rh(b2)) {
          d2 = b2.stateNode;
          c3 = b2.type;
          var f2 = b2.memoizedProps;
          d2[wf] = b2;
          d2[xf] = f2;
          switch (c3) {
            case "dialog":
              G("cancel", d2);
              G("close", d2);
              break;
            case "iframe":
            case "object":
            case "embed":
              G("load", d2);
              break;
            case "video":
            case "audio":
              for (a2 = 0; a2 < Xe.length; a2++)
                G(Xe[a2], d2);
              break;
            case "source":
              G("error", d2);
              break;
            case "img":
            case "image":
            case "link":
              G("error", d2);
              G("load", d2);
              break;
            case "details":
              G("toggle", d2);
              break;
            case "input":
              Za(d2, f2);
              G("invalid", d2);
              break;
            case "select":
              d2._wrapperState = {wasMultiple: !!f2.multiple};
              G("invalid", d2);
              break;
            case "textarea":
              hb(d2, f2), G("invalid", d2);
          }
          vb(c3, f2);
          a2 = null;
          for (var g2 in f2)
            f2.hasOwnProperty(g2) && (e2 = f2[g2], g2 === "children" ? typeof e2 === "string" ? d2.textContent !== e2 && (a2 = ["children", e2]) : typeof e2 === "number" && d2.textContent !== "" + e2 && (a2 = ["children", "" + e2]) : ca.hasOwnProperty(g2) && e2 != null && g2 === "onScroll" && G("scroll", d2));
          switch (c3) {
            case "input":
              Va(d2);
              cb(d2, f2, true);
              break;
            case "textarea":
              Va(d2);
              jb(d2);
              break;
            case "select":
            case "option":
              break;
            default:
              typeof f2.onClick === "function" && (d2.onclick = jf);
          }
          d2 = a2;
          b2.updateQueue = d2;
          d2 !== null && (b2.flags |= 4);
        } else {
          g2 = e2.nodeType === 9 ? e2 : e2.ownerDocument;
          a2 === kb.html && (a2 = lb(c3));
          a2 === kb.html ? c3 === "script" ? (a2 = g2.createElement("div"), a2.innerHTML = "<script></script>", a2 = a2.removeChild(a2.firstChild)) : typeof d2.is === "string" ? a2 = g2.createElement(c3, {is: d2.is}) : (a2 = g2.createElement(c3), c3 === "select" && (g2 = a2, d2.multiple ? g2.multiple = true : d2.size && (g2.size = d2.size))) : a2 = g2.createElementNS(a2, c3);
          a2[wf] = b2;
          a2[xf] = d2;
          Bi(a2, b2, false, false);
          b2.stateNode = a2;
          g2 = wb(c3, d2);
          switch (c3) {
            case "dialog":
              G("cancel", a2);
              G("close", a2);
              e2 = d2;
              break;
            case "iframe":
            case "object":
            case "embed":
              G("load", a2);
              e2 = d2;
              break;
            case "video":
            case "audio":
              for (e2 = 0; e2 < Xe.length; e2++)
                G(Xe[e2], a2);
              e2 = d2;
              break;
            case "source":
              G("error", a2);
              e2 = d2;
              break;
            case "img":
            case "image":
            case "link":
              G("error", a2);
              G("load", a2);
              e2 = d2;
              break;
            case "details":
              G("toggle", a2);
              e2 = d2;
              break;
            case "input":
              Za(a2, d2);
              e2 = Ya(a2, d2);
              G("invalid", a2);
              break;
            case "option":
              e2 = eb(a2, d2);
              break;
            case "select":
              a2._wrapperState = {wasMultiple: !!d2.multiple};
              e2 = objectAssign({}, d2, {value: void 0});
              G("invalid", a2);
              break;
            case "textarea":
              hb(a2, d2);
              e2 = gb(a2, d2);
              G("invalid", a2);
              break;
            default:
              e2 = d2;
          }
          vb(c3, e2);
          var h2 = e2;
          for (f2 in h2)
            if (h2.hasOwnProperty(f2)) {
              var k2 = h2[f2];
              f2 === "style" ? tb(a2, k2) : f2 === "dangerouslySetInnerHTML" ? (k2 = k2 ? k2.__html : void 0, k2 != null && ob(a2, k2)) : f2 === "children" ? typeof k2 === "string" ? (c3 !== "textarea" || k2 !== "") && pb(a2, k2) : typeof k2 === "number" && pb(a2, "" + k2) : f2 !== "suppressContentEditableWarning" && f2 !== "suppressHydrationWarning" && f2 !== "autoFocus" && (ca.hasOwnProperty(f2) ? k2 != null && f2 === "onScroll" && G("scroll", a2) : k2 != null && qa(a2, f2, k2, g2));
            }
          switch (c3) {
            case "input":
              Va(a2);
              cb(a2, d2, false);
              break;
            case "textarea":
              Va(a2);
              jb(a2);
              break;
            case "option":
              d2.value != null && a2.setAttribute("value", "" + Sa(d2.value));
              break;
            case "select":
              a2.multiple = !!d2.multiple;
              f2 = d2.value;
              f2 != null ? fb(a2, !!d2.multiple, f2, false) : d2.defaultValue != null && fb(a2, !!d2.multiple, d2.defaultValue, true);
              break;
            default:
              typeof e2.onClick === "function" && (a2.onclick = jf);
          }
          mf(c3, d2) && (b2.flags |= 4);
        }
        b2.ref !== null && (b2.flags |= 128);
      }
      return null;
    case 6:
      if (a2 && b2.stateNode != null)
        Ei(a2, b2, a2.memoizedProps, d2);
      else {
        if (typeof d2 !== "string" && b2.stateNode === null)
          throw Error(y(166));
        c3 = dh(ch.current);
        dh(ah.current);
        rh(b2) ? (d2 = b2.stateNode, c3 = b2.memoizedProps, d2[wf] = b2, d2.nodeValue !== c3 && (b2.flags |= 4)) : (d2 = (c3.nodeType === 9 ? c3 : c3.ownerDocument).createTextNode(d2), d2[wf] = b2, b2.stateNode = d2);
      }
      return null;
    case 13:
      H(P);
      d2 = b2.memoizedState;
      if ((b2.flags & 64) !== 0)
        return b2.lanes = c3, b2;
      d2 = d2 !== null;
      c3 = false;
      a2 === null ? b2.memoizedProps.fallback !== void 0 && rh(b2) : c3 = a2.memoizedState !== null;
      if (d2 && !c3 && (b2.mode & 2) !== 0)
        if (a2 === null && b2.memoizedProps.unstable_avoidThisFallback !== true || (P.current & 1) !== 0)
          V === 0 && (V = 3);
        else {
          if (V === 0 || V === 3)
            V = 4;
          U === null || (Dg & 134217727) === 0 && (Hi & 134217727) === 0 || Ii(U, W);
        }
      if (d2 || c3)
        b2.flags |= 4;
      return null;
    case 4:
      return fh(), Ci(b2), a2 === null && cf(b2.stateNode.containerInfo), null;
    case 10:
      return rg(b2), null;
    case 17:
      return Ff(b2.type) && Gf(), null;
    case 19:
      H(P);
      d2 = b2.memoizedState;
      if (d2 === null)
        return null;
      f2 = (b2.flags & 64) !== 0;
      g2 = d2.rendering;
      if (g2 === null)
        if (f2)
          Fi(d2, false);
        else {
          if (V !== 0 || a2 !== null && (a2.flags & 64) !== 0)
            for (a2 = b2.child; a2 !== null; ) {
              g2 = ih(a2);
              if (g2 !== null) {
                b2.flags |= 64;
                Fi(d2, false);
                f2 = g2.updateQueue;
                f2 !== null && (b2.updateQueue = f2, b2.flags |= 4);
                d2.lastEffect === null && (b2.firstEffect = null);
                b2.lastEffect = d2.lastEffect;
                d2 = c3;
                for (c3 = b2.child; c3 !== null; )
                  f2 = c3, a2 = d2, f2.flags &= 2, f2.nextEffect = null, f2.firstEffect = null, f2.lastEffect = null, g2 = f2.alternate, g2 === null ? (f2.childLanes = 0, f2.lanes = a2, f2.child = null, f2.memoizedProps = null, f2.memoizedState = null, f2.updateQueue = null, f2.dependencies = null, f2.stateNode = null) : (f2.childLanes = g2.childLanes, f2.lanes = g2.lanes, f2.child = g2.child, f2.memoizedProps = g2.memoizedProps, f2.memoizedState = g2.memoizedState, f2.updateQueue = g2.updateQueue, f2.type = g2.type, a2 = g2.dependencies, f2.dependencies = a2 === null ? null : {lanes: a2.lanes, firstContext: a2.firstContext}), c3 = c3.sibling;
                I(P, P.current & 1 | 2);
                return b2.child;
              }
              a2 = a2.sibling;
            }
          d2.tail !== null && O() > Ji && (b2.flags |= 64, f2 = true, Fi(d2, false), b2.lanes = 33554432);
        }
      else {
        if (!f2)
          if (a2 = ih(g2), a2 !== null) {
            if (b2.flags |= 64, f2 = true, c3 = a2.updateQueue, c3 !== null && (b2.updateQueue = c3, b2.flags |= 4), Fi(d2, true), d2.tail === null && d2.tailMode === "hidden" && !g2.alternate && !lh)
              return b2 = b2.lastEffect = d2.lastEffect, b2 !== null && (b2.nextEffect = null), null;
          } else
            2 * O() - d2.renderingStartTime > Ji && c3 !== 1073741824 && (b2.flags |= 64, f2 = true, Fi(d2, false), b2.lanes = 33554432);
        d2.isBackwards ? (g2.sibling = b2.child, b2.child = g2) : (c3 = d2.last, c3 !== null ? c3.sibling = g2 : b2.child = g2, d2.last = g2);
      }
      return d2.tail !== null ? (c3 = d2.tail, d2.rendering = c3, d2.tail = c3.sibling, d2.lastEffect = b2.lastEffect, d2.renderingStartTime = O(), c3.sibling = null, b2 = P.current, I(P, f2 ? b2 & 1 | 2 : b2 & 1), c3) : null;
    case 23:
    case 24:
      return Ki(), a2 !== null && a2.memoizedState !== null !== (b2.memoizedState !== null) && d2.mode !== "unstable-defer-without-hiding" && (b2.flags |= 4), null;
  }
  throw Error(y(156, b2.tag));
}
function Li(a2) {
  switch (a2.tag) {
    case 1:
      Ff(a2.type) && Gf();
      var b2 = a2.flags;
      return b2 & 4096 ? (a2.flags = b2 & -4097 | 64, a2) : null;
    case 3:
      fh();
      H(N);
      H(M);
      uh();
      b2 = a2.flags;
      if ((b2 & 64) !== 0)
        throw Error(y(285));
      a2.flags = b2 & -4097 | 64;
      return a2;
    case 5:
      return hh(a2), null;
    case 13:
      return H(P), b2 = a2.flags, b2 & 4096 ? (a2.flags = b2 & -4097 | 64, a2) : null;
    case 19:
      return H(P), null;
    case 4:
      return fh(), null;
    case 10:
      return rg(a2), null;
    case 23:
    case 24:
      return Ki(), null;
    default:
      return null;
  }
}
function Mi(a2, b2) {
  try {
    var c3 = "", d2 = b2;
    do
      c3 += Qa(d2), d2 = d2.return;
    while (d2);
    var e2 = c3;
  } catch (f2) {
    e2 = "\nError generating stack: " + f2.message + "\n" + f2.stack;
  }
  return {value: a2, source: b2, stack: e2};
}
function Ni(a2, b2) {
  try {
    console.error(b2.value);
  } catch (c3) {
    setTimeout(function() {
      throw c3;
    });
  }
}
var Oi = typeof WeakMap === "function" ? WeakMap : Map;
function Pi(a2, b2, c3) {
  c3 = zg(-1, c3);
  c3.tag = 3;
  c3.payload = {element: null};
  var d2 = b2.value;
  c3.callback = function() {
    Qi || (Qi = true, Ri = d2);
    Ni(a2, b2);
  };
  return c3;
}
function Si(a2, b2, c3) {
  c3 = zg(-1, c3);
  c3.tag = 3;
  var d2 = a2.type.getDerivedStateFromError;
  if (typeof d2 === "function") {
    var e2 = b2.value;
    c3.payload = function() {
      Ni(a2, b2);
      return d2(e2);
    };
  }
  var f2 = a2.stateNode;
  f2 !== null && typeof f2.componentDidCatch === "function" && (c3.callback = function() {
    typeof d2 !== "function" && (Ti === null ? Ti = new Set([this]) : Ti.add(this), Ni(a2, b2));
    var c4 = b2.stack;
    this.componentDidCatch(b2.value, {componentStack: c4 !== null ? c4 : ""});
  });
  return c3;
}
var Ui = typeof WeakSet === "function" ? WeakSet : Set;
function Vi(a2) {
  var b2 = a2.ref;
  if (b2 !== null)
    if (typeof b2 === "function")
      try {
        b2(null);
      } catch (c3) {
        Wi(a2, c3);
      }
    else
      b2.current = null;
}
function Xi(a2, b2) {
  switch (b2.tag) {
    case 0:
    case 11:
    case 15:
    case 22:
      return;
    case 1:
      if (b2.flags & 256 && a2 !== null) {
        var c3 = a2.memoizedProps, d2 = a2.memoizedState;
        a2 = b2.stateNode;
        b2 = a2.getSnapshotBeforeUpdate(b2.elementType === b2.type ? c3 : lg(b2.type, c3), d2);
        a2.__reactInternalSnapshotBeforeUpdate = b2;
      }
      return;
    case 3:
      b2.flags & 256 && qf(b2.stateNode.containerInfo);
      return;
    case 5:
    case 6:
    case 4:
    case 17:
      return;
  }
  throw Error(y(163));
}
function Yi(a2, b2, c3) {
  switch (c3.tag) {
    case 0:
    case 11:
    case 15:
    case 22:
      b2 = c3.updateQueue;
      b2 = b2 !== null ? b2.lastEffect : null;
      if (b2 !== null) {
        a2 = b2 = b2.next;
        do {
          if ((a2.tag & 3) === 3) {
            var d2 = a2.create;
            a2.destroy = d2();
          }
          a2 = a2.next;
        } while (a2 !== b2);
      }
      b2 = c3.updateQueue;
      b2 = b2 !== null ? b2.lastEffect : null;
      if (b2 !== null) {
        a2 = b2 = b2.next;
        do {
          var e2 = a2;
          d2 = e2.next;
          e2 = e2.tag;
          (e2 & 4) !== 0 && (e2 & 1) !== 0 && (Zi(c3, a2), $i(c3, a2));
          a2 = d2;
        } while (a2 !== b2);
      }
      return;
    case 1:
      a2 = c3.stateNode;
      c3.flags & 4 && (b2 === null ? a2.componentDidMount() : (d2 = c3.elementType === c3.type ? b2.memoizedProps : lg(c3.type, b2.memoizedProps), a2.componentDidUpdate(d2, b2.memoizedState, a2.__reactInternalSnapshotBeforeUpdate)));
      b2 = c3.updateQueue;
      b2 !== null && Eg(c3, b2, a2);
      return;
    case 3:
      b2 = c3.updateQueue;
      if (b2 !== null) {
        a2 = null;
        if (c3.child !== null)
          switch (c3.child.tag) {
            case 5:
              a2 = c3.child.stateNode;
              break;
            case 1:
              a2 = c3.child.stateNode;
          }
        Eg(c3, b2, a2);
      }
      return;
    case 5:
      a2 = c3.stateNode;
      b2 === null && c3.flags & 4 && mf(c3.type, c3.memoizedProps) && a2.focus();
      return;
    case 6:
      return;
    case 4:
      return;
    case 12:
      return;
    case 13:
      c3.memoizedState === null && (c3 = c3.alternate, c3 !== null && (c3 = c3.memoizedState, c3 !== null && (c3 = c3.dehydrated, c3 !== null && Cc(c3))));
      return;
    case 19:
    case 17:
    case 20:
    case 21:
    case 23:
    case 24:
      return;
  }
  throw Error(y(163));
}
function aj(a2, b2) {
  for (var c3 = a2; ; ) {
    if (c3.tag === 5) {
      var d2 = c3.stateNode;
      if (b2)
        d2 = d2.style, typeof d2.setProperty === "function" ? d2.setProperty("display", "none", "important") : d2.display = "none";
      else {
        d2 = c3.stateNode;
        var e2 = c3.memoizedProps.style;
        e2 = e2 !== void 0 && e2 !== null && e2.hasOwnProperty("display") ? e2.display : null;
        d2.style.display = sb("display", e2);
      }
    } else if (c3.tag === 6)
      c3.stateNode.nodeValue = b2 ? "" : c3.memoizedProps;
    else if ((c3.tag !== 23 && c3.tag !== 24 || c3.memoizedState === null || c3 === a2) && c3.child !== null) {
      c3.child.return = c3;
      c3 = c3.child;
      continue;
    }
    if (c3 === a2)
      break;
    for (; c3.sibling === null; ) {
      if (c3.return === null || c3.return === a2)
        return;
      c3 = c3.return;
    }
    c3.sibling.return = c3.return;
    c3 = c3.sibling;
  }
}
function bj(a2, b2) {
  if (Mf && typeof Mf.onCommitFiberUnmount === "function")
    try {
      Mf.onCommitFiberUnmount(Lf, b2);
    } catch (f2) {
    }
  switch (b2.tag) {
    case 0:
    case 11:
    case 14:
    case 15:
    case 22:
      a2 = b2.updateQueue;
      if (a2 !== null && (a2 = a2.lastEffect, a2 !== null)) {
        var c3 = a2 = a2.next;
        do {
          var d2 = c3, e2 = d2.destroy;
          d2 = d2.tag;
          if (e2 !== void 0)
            if ((d2 & 4) !== 0)
              Zi(b2, c3);
            else {
              d2 = b2;
              try {
                e2();
              } catch (f2) {
                Wi(d2, f2);
              }
            }
          c3 = c3.next;
        } while (c3 !== a2);
      }
      break;
    case 1:
      Vi(b2);
      a2 = b2.stateNode;
      if (typeof a2.componentWillUnmount === "function")
        try {
          a2.props = b2.memoizedProps, a2.state = b2.memoizedState, a2.componentWillUnmount();
        } catch (f2) {
          Wi(b2, f2);
        }
      break;
    case 5:
      Vi(b2);
      break;
    case 4:
      cj(a2, b2);
  }
}
function dj(a2) {
  a2.alternate = null;
  a2.child = null;
  a2.dependencies = null;
  a2.firstEffect = null;
  a2.lastEffect = null;
  a2.memoizedProps = null;
  a2.memoizedState = null;
  a2.pendingProps = null;
  a2.return = null;
  a2.updateQueue = null;
}
function ej(a2) {
  return a2.tag === 5 || a2.tag === 3 || a2.tag === 4;
}
function fj(a2) {
  a: {
    for (var b2 = a2.return; b2 !== null; ) {
      if (ej(b2))
        break a;
      b2 = b2.return;
    }
    throw Error(y(160));
  }
  var c3 = b2;
  b2 = c3.stateNode;
  switch (c3.tag) {
    case 5:
      var d2 = false;
      break;
    case 3:
      b2 = b2.containerInfo;
      d2 = true;
      break;
    case 4:
      b2 = b2.containerInfo;
      d2 = true;
      break;
    default:
      throw Error(y(161));
  }
  c3.flags & 16 && (pb(b2, ""), c3.flags &= -17);
  a:
    b:
      for (c3 = a2; ; ) {
        for (; c3.sibling === null; ) {
          if (c3.return === null || ej(c3.return)) {
            c3 = null;
            break a;
          }
          c3 = c3.return;
        }
        c3.sibling.return = c3.return;
        for (c3 = c3.sibling; c3.tag !== 5 && c3.tag !== 6 && c3.tag !== 18; ) {
          if (c3.flags & 2)
            continue b;
          if (c3.child === null || c3.tag === 4)
            continue b;
          else
            c3.child.return = c3, c3 = c3.child;
        }
        if (!(c3.flags & 2)) {
          c3 = c3.stateNode;
          break a;
        }
      }
  d2 ? gj(a2, c3, b2) : hj(a2, c3, b2);
}
function gj(a2, b2, c3) {
  var d2 = a2.tag, e2 = d2 === 5 || d2 === 6;
  if (e2)
    a2 = e2 ? a2.stateNode : a2.stateNode.instance, b2 ? c3.nodeType === 8 ? c3.parentNode.insertBefore(a2, b2) : c3.insertBefore(a2, b2) : (c3.nodeType === 8 ? (b2 = c3.parentNode, b2.insertBefore(a2, c3)) : (b2 = c3, b2.appendChild(a2)), c3 = c3._reactRootContainer, c3 !== null && c3 !== void 0 || b2.onclick !== null || (b2.onclick = jf));
  else if (d2 !== 4 && (a2 = a2.child, a2 !== null))
    for (gj(a2, b2, c3), a2 = a2.sibling; a2 !== null; )
      gj(a2, b2, c3), a2 = a2.sibling;
}
function hj(a2, b2, c3) {
  var d2 = a2.tag, e2 = d2 === 5 || d2 === 6;
  if (e2)
    a2 = e2 ? a2.stateNode : a2.stateNode.instance, b2 ? c3.insertBefore(a2, b2) : c3.appendChild(a2);
  else if (d2 !== 4 && (a2 = a2.child, a2 !== null))
    for (hj(a2, b2, c3), a2 = a2.sibling; a2 !== null; )
      hj(a2, b2, c3), a2 = a2.sibling;
}
function cj(a2, b2) {
  for (var c3 = b2, d2 = false, e2, f2; ; ) {
    if (!d2) {
      d2 = c3.return;
      a:
        for (; ; ) {
          if (d2 === null)
            throw Error(y(160));
          e2 = d2.stateNode;
          switch (d2.tag) {
            case 5:
              f2 = false;
              break a;
            case 3:
              e2 = e2.containerInfo;
              f2 = true;
              break a;
            case 4:
              e2 = e2.containerInfo;
              f2 = true;
              break a;
          }
          d2 = d2.return;
        }
      d2 = true;
    }
    if (c3.tag === 5 || c3.tag === 6) {
      a:
        for (var g2 = a2, h2 = c3, k2 = h2; ; )
          if (bj(g2, k2), k2.child !== null && k2.tag !== 4)
            k2.child.return = k2, k2 = k2.child;
          else {
            if (k2 === h2)
              break a;
            for (; k2.sibling === null; ) {
              if (k2.return === null || k2.return === h2)
                break a;
              k2 = k2.return;
            }
            k2.sibling.return = k2.return;
            k2 = k2.sibling;
          }
      f2 ? (g2 = e2, h2 = c3.stateNode, g2.nodeType === 8 ? g2.parentNode.removeChild(h2) : g2.removeChild(h2)) : e2.removeChild(c3.stateNode);
    } else if (c3.tag === 4) {
      if (c3.child !== null) {
        e2 = c3.stateNode.containerInfo;
        f2 = true;
        c3.child.return = c3;
        c3 = c3.child;
        continue;
      }
    } else if (bj(a2, c3), c3.child !== null) {
      c3.child.return = c3;
      c3 = c3.child;
      continue;
    }
    if (c3 === b2)
      break;
    for (; c3.sibling === null; ) {
      if (c3.return === null || c3.return === b2)
        return;
      c3 = c3.return;
      c3.tag === 4 && (d2 = false);
    }
    c3.sibling.return = c3.return;
    c3 = c3.sibling;
  }
}
function ij(a2, b2) {
  switch (b2.tag) {
    case 0:
    case 11:
    case 14:
    case 15:
    case 22:
      var c3 = b2.updateQueue;
      c3 = c3 !== null ? c3.lastEffect : null;
      if (c3 !== null) {
        var d2 = c3 = c3.next;
        do
          (d2.tag & 3) === 3 && (a2 = d2.destroy, d2.destroy = void 0, a2 !== void 0 && a2()), d2 = d2.next;
        while (d2 !== c3);
      }
      return;
    case 1:
      return;
    case 5:
      c3 = b2.stateNode;
      if (c3 != null) {
        d2 = b2.memoizedProps;
        var e2 = a2 !== null ? a2.memoizedProps : d2;
        a2 = b2.type;
        var f2 = b2.updateQueue;
        b2.updateQueue = null;
        if (f2 !== null) {
          c3[xf] = d2;
          a2 === "input" && d2.type === "radio" && d2.name != null && $a(c3, d2);
          wb(a2, e2);
          b2 = wb(a2, d2);
          for (e2 = 0; e2 < f2.length; e2 += 2) {
            var g2 = f2[e2], h2 = f2[e2 + 1];
            g2 === "style" ? tb(c3, h2) : g2 === "dangerouslySetInnerHTML" ? ob(c3, h2) : g2 === "children" ? pb(c3, h2) : qa(c3, g2, h2, b2);
          }
          switch (a2) {
            case "input":
              ab(c3, d2);
              break;
            case "textarea":
              ib(c3, d2);
              break;
            case "select":
              a2 = c3._wrapperState.wasMultiple, c3._wrapperState.wasMultiple = !!d2.multiple, f2 = d2.value, f2 != null ? fb(c3, !!d2.multiple, f2, false) : a2 !== !!d2.multiple && (d2.defaultValue != null ? fb(c3, !!d2.multiple, d2.defaultValue, true) : fb(c3, !!d2.multiple, d2.multiple ? [] : "", false));
          }
        }
      }
      return;
    case 6:
      if (b2.stateNode === null)
        throw Error(y(162));
      b2.stateNode.nodeValue = b2.memoizedProps;
      return;
    case 3:
      c3 = b2.stateNode;
      c3.hydrate && (c3.hydrate = false, Cc(c3.containerInfo));
      return;
    case 12:
      return;
    case 13:
      b2.memoizedState !== null && (jj = O(), aj(b2.child, true));
      kj(b2);
      return;
    case 19:
      kj(b2);
      return;
    case 17:
      return;
    case 23:
    case 24:
      aj(b2, b2.memoizedState !== null);
      return;
  }
  throw Error(y(163));
}
function kj(a2) {
  var b2 = a2.updateQueue;
  if (b2 !== null) {
    a2.updateQueue = null;
    var c3 = a2.stateNode;
    c3 === null && (c3 = a2.stateNode = new Ui());
    b2.forEach(function(b3) {
      var d2 = lj.bind(null, a2, b3);
      c3.has(b3) || (c3.add(b3), b3.then(d2, d2));
    });
  }
}
function mj(a2, b2) {
  return a2 !== null && (a2 = a2.memoizedState, a2 === null || a2.dehydrated !== null) ? (b2 = b2.memoizedState, b2 !== null && b2.dehydrated === null) : false;
}
var nj = Math.ceil;
var oj = ra.ReactCurrentDispatcher;
var pj = ra.ReactCurrentOwner;
var X = 0;
var U = null;
var Y = null;
var W = 0;
var qj = 0;
var rj = Bf(0);
var V = 0;
var sj = null;
var tj = 0;
var Dg = 0;
var Hi = 0;
var uj = 0;
var vj = null;
var jj = 0;
var Ji = Infinity;
function wj() {
  Ji = O() + 500;
}
var Z = null;
var Qi = false;
var Ri = null;
var Ti = null;
var xj = false;
var yj = null;
var zj = 90;
var Aj = [];
var Bj = [];
var Cj = null;
var Dj = 0;
var Ej = null;
var Fj = -1;
var Gj = 0;
var Hj = 0;
var Ij = null;
var Jj = false;
function Hg() {
  return (X & 48) !== 0 ? O() : Fj !== -1 ? Fj : Fj = O();
}
function Ig(a2) {
  a2 = a2.mode;
  if ((a2 & 2) === 0)
    return 1;
  if ((a2 & 4) === 0)
    return eg() === 99 ? 1 : 2;
  Gj === 0 && (Gj = tj);
  if (kg.transition !== 0) {
    Hj !== 0 && (Hj = vj !== null ? vj.pendingLanes : 0);
    a2 = Gj;
    var b2 = 4186112 & ~Hj;
    b2 &= -b2;
    b2 === 0 && (a2 = 4186112 & ~a2, b2 = a2 & -a2, b2 === 0 && (b2 = 8192));
    return b2;
  }
  a2 = eg();
  (X & 4) !== 0 && a2 === 98 ? a2 = Xc(12, Gj) : (a2 = Sc(a2), a2 = Xc(a2, Gj));
  return a2;
}
function Jg(a2, b2, c3) {
  if (50 < Dj)
    throw Dj = 0, Ej = null, Error(y(185));
  a2 = Kj(a2, b2);
  if (a2 === null)
    return null;
  $c(a2, b2, c3);
  a2 === U && (Hi |= b2, V === 4 && Ii(a2, W));
  var d2 = eg();
  b2 === 1 ? (X & 8) !== 0 && (X & 48) === 0 ? Lj(a2) : (Mj(a2, c3), X === 0 && (wj(), ig())) : ((X & 4) === 0 || d2 !== 98 && d2 !== 99 || (Cj === null ? Cj = new Set([a2]) : Cj.add(a2)), Mj(a2, c3));
  vj = a2;
}
function Kj(a2, b2) {
  a2.lanes |= b2;
  var c3 = a2.alternate;
  c3 !== null && (c3.lanes |= b2);
  c3 = a2;
  for (a2 = a2.return; a2 !== null; )
    a2.childLanes |= b2, c3 = a2.alternate, c3 !== null && (c3.childLanes |= b2), c3 = a2, a2 = a2.return;
  return c3.tag === 3 ? c3.stateNode : null;
}
function Mj(a2, b2) {
  for (var c3 = a2.callbackNode, d2 = a2.suspendedLanes, e2 = a2.pingedLanes, f2 = a2.expirationTimes, g2 = a2.pendingLanes; 0 < g2; ) {
    var h2 = 31 - Vc(g2), k2 = 1 << h2, l2 = f2[h2];
    if (l2 === -1) {
      if ((k2 & d2) === 0 || (k2 & e2) !== 0) {
        l2 = b2;
        Rc(k2);
        var n3 = F;
        f2[h2] = 10 <= n3 ? l2 + 250 : 6 <= n3 ? l2 + 5e3 : -1;
      }
    } else
      l2 <= b2 && (a2.expiredLanes |= k2);
    g2 &= ~k2;
  }
  d2 = Uc(a2, a2 === U ? W : 0);
  b2 = F;
  if (d2 === 0)
    c3 !== null && (c3 !== Zf && Pf(c3), a2.callbackNode = null, a2.callbackPriority = 0);
  else {
    if (c3 !== null) {
      if (a2.callbackPriority === b2)
        return;
      c3 !== Zf && Pf(c3);
    }
    b2 === 15 ? (c3 = Lj.bind(null, a2), ag === null ? (ag = [c3], bg = Of(Uf, jg)) : ag.push(c3), c3 = Zf) : b2 === 14 ? c3 = hg(99, Lj.bind(null, a2)) : (c3 = Tc(b2), c3 = hg(c3, Nj.bind(null, a2)));
    a2.callbackPriority = b2;
    a2.callbackNode = c3;
  }
}
function Nj(a2) {
  Fj = -1;
  Hj = Gj = 0;
  if ((X & 48) !== 0)
    throw Error(y(327));
  var b2 = a2.callbackNode;
  if (Oj() && a2.callbackNode !== b2)
    return null;
  var c3 = Uc(a2, a2 === U ? W : 0);
  if (c3 === 0)
    return null;
  var d2 = c3;
  var e2 = X;
  X |= 16;
  var f2 = Pj();
  if (U !== a2 || W !== d2)
    wj(), Qj(a2, d2);
  do
    try {
      Rj();
      break;
    } catch (h2) {
      Sj(a2, h2);
    }
  while (1);
  qg();
  oj.current = f2;
  X = e2;
  Y !== null ? d2 = 0 : (U = null, W = 0, d2 = V);
  if ((tj & Hi) !== 0)
    Qj(a2, 0);
  else if (d2 !== 0) {
    d2 === 2 && (X |= 64, a2.hydrate && (a2.hydrate = false, qf(a2.containerInfo)), c3 = Wc(a2), c3 !== 0 && (d2 = Tj(a2, c3)));
    if (d2 === 1)
      throw b2 = sj, Qj(a2, 0), Ii(a2, c3), Mj(a2, O()), b2;
    a2.finishedWork = a2.current.alternate;
    a2.finishedLanes = c3;
    switch (d2) {
      case 0:
      case 1:
        throw Error(y(345));
      case 2:
        Uj(a2);
        break;
      case 3:
        Ii(a2, c3);
        if ((c3 & 62914560) === c3 && (d2 = jj + 500 - O(), 10 < d2)) {
          if (Uc(a2, 0) !== 0)
            break;
          e2 = a2.suspendedLanes;
          if ((e2 & c3) !== c3) {
            Hg();
            a2.pingedLanes |= a2.suspendedLanes & e2;
            break;
          }
          a2.timeoutHandle = of(Uj.bind(null, a2), d2);
          break;
        }
        Uj(a2);
        break;
      case 4:
        Ii(a2, c3);
        if ((c3 & 4186112) === c3)
          break;
        d2 = a2.eventTimes;
        for (e2 = -1; 0 < c3; ) {
          var g2 = 31 - Vc(c3);
          f2 = 1 << g2;
          g2 = d2[g2];
          g2 > e2 && (e2 = g2);
          c3 &= ~f2;
        }
        c3 = e2;
        c3 = O() - c3;
        c3 = (120 > c3 ? 120 : 480 > c3 ? 480 : 1080 > c3 ? 1080 : 1920 > c3 ? 1920 : 3e3 > c3 ? 3e3 : 4320 > c3 ? 4320 : 1960 * nj(c3 / 1960)) - c3;
        if (10 < c3) {
          a2.timeoutHandle = of(Uj.bind(null, a2), c3);
          break;
        }
        Uj(a2);
        break;
      case 5:
        Uj(a2);
        break;
      default:
        throw Error(y(329));
    }
  }
  Mj(a2, O());
  return a2.callbackNode === b2 ? Nj.bind(null, a2) : null;
}
function Ii(a2, b2) {
  b2 &= ~uj;
  b2 &= ~Hi;
  a2.suspendedLanes |= b2;
  a2.pingedLanes &= ~b2;
  for (a2 = a2.expirationTimes; 0 < b2; ) {
    var c3 = 31 - Vc(b2), d2 = 1 << c3;
    a2[c3] = -1;
    b2 &= ~d2;
  }
}
function Lj(a2) {
  if ((X & 48) !== 0)
    throw Error(y(327));
  Oj();
  if (a2 === U && (a2.expiredLanes & W) !== 0) {
    var b2 = W;
    var c3 = Tj(a2, b2);
    (tj & Hi) !== 0 && (b2 = Uc(a2, b2), c3 = Tj(a2, b2));
  } else
    b2 = Uc(a2, 0), c3 = Tj(a2, b2);
  a2.tag !== 0 && c3 === 2 && (X |= 64, a2.hydrate && (a2.hydrate = false, qf(a2.containerInfo)), b2 = Wc(a2), b2 !== 0 && (c3 = Tj(a2, b2)));
  if (c3 === 1)
    throw c3 = sj, Qj(a2, 0), Ii(a2, b2), Mj(a2, O()), c3;
  a2.finishedWork = a2.current.alternate;
  a2.finishedLanes = b2;
  Uj(a2);
  Mj(a2, O());
  return null;
}
function Vj() {
  if (Cj !== null) {
    var a2 = Cj;
    Cj = null;
    a2.forEach(function(a3) {
      a3.expiredLanes |= 24 & a3.pendingLanes;
      Mj(a3, O());
    });
  }
  ig();
}
function Wj(a2, b2) {
  var c3 = X;
  X |= 1;
  try {
    return a2(b2);
  } finally {
    X = c3, X === 0 && (wj(), ig());
  }
}
function Xj(a2, b2) {
  var c3 = X;
  X &= -2;
  X |= 8;
  try {
    return a2(b2);
  } finally {
    X = c3, X === 0 && (wj(), ig());
  }
}
function ni(a2, b2) {
  I(rj, qj);
  qj |= b2;
  tj |= b2;
}
function Ki() {
  qj = rj.current;
  H(rj);
}
function Qj(a2, b2) {
  a2.finishedWork = null;
  a2.finishedLanes = 0;
  var c3 = a2.timeoutHandle;
  c3 !== -1 && (a2.timeoutHandle = -1, pf(c3));
  if (Y !== null)
    for (c3 = Y.return; c3 !== null; ) {
      var d2 = c3;
      switch (d2.tag) {
        case 1:
          d2 = d2.type.childContextTypes;
          d2 !== null && d2 !== void 0 && Gf();
          break;
        case 3:
          fh();
          H(N);
          H(M);
          uh();
          break;
        case 5:
          hh(d2);
          break;
        case 4:
          fh();
          break;
        case 13:
          H(P);
          break;
        case 19:
          H(P);
          break;
        case 10:
          rg(d2);
          break;
        case 23:
        case 24:
          Ki();
      }
      c3 = c3.return;
    }
  U = a2;
  Y = Tg(a2.current, null);
  W = qj = tj = b2;
  V = 0;
  sj = null;
  uj = Hi = Dg = 0;
}
function Sj(a2, b2) {
  do {
    var c3 = Y;
    try {
      qg();
      vh.current = Gh;
      if (yh) {
        for (var d2 = R.memoizedState; d2 !== null; ) {
          var e2 = d2.queue;
          e2 !== null && (e2.pending = null);
          d2 = d2.next;
        }
        yh = false;
      }
      xh = 0;
      T = S = R = null;
      zh = false;
      pj.current = null;
      if (c3 === null || c3.return === null) {
        V = 1;
        sj = b2;
        Y = null;
        break;
      }
      a: {
        var f2 = a2, g2 = c3.return, h2 = c3, k2 = b2;
        b2 = W;
        h2.flags |= 2048;
        h2.firstEffect = h2.lastEffect = null;
        if (k2 !== null && typeof k2 === "object" && typeof k2.then === "function") {
          var l2 = k2;
          if ((h2.mode & 2) === 0) {
            var n3 = h2.alternate;
            n3 ? (h2.updateQueue = n3.updateQueue, h2.memoizedState = n3.memoizedState, h2.lanes = n3.lanes) : (h2.updateQueue = null, h2.memoizedState = null);
          }
          var A2 = (P.current & 1) !== 0, p2 = g2;
          do {
            var C;
            if (C = p2.tag === 13) {
              var x2 = p2.memoizedState;
              if (x2 !== null)
                C = x2.dehydrated !== null ? true : false;
              else {
                var w2 = p2.memoizedProps;
                C = w2.fallback === void 0 ? false : w2.unstable_avoidThisFallback !== true ? true : A2 ? false : true;
              }
            }
            if (C) {
              var z2 = p2.updateQueue;
              if (z2 === null) {
                var u = new Set();
                u.add(l2);
                p2.updateQueue = u;
              } else
                z2.add(l2);
              if ((p2.mode & 2) === 0) {
                p2.flags |= 64;
                h2.flags |= 16384;
                h2.flags &= -2981;
                if (h2.tag === 1)
                  if (h2.alternate === null)
                    h2.tag = 17;
                  else {
                    var t5 = zg(-1, 1);
                    t5.tag = 2;
                    Ag(h2, t5);
                  }
                h2.lanes |= 1;
                break a;
              }
              k2 = void 0;
              h2 = b2;
              var q2 = f2.pingCache;
              q2 === null ? (q2 = f2.pingCache = new Oi(), k2 = new Set(), q2.set(l2, k2)) : (k2 = q2.get(l2), k2 === void 0 && (k2 = new Set(), q2.set(l2, k2)));
              if (!k2.has(h2)) {
                k2.add(h2);
                var v2 = Yj.bind(null, f2, l2, h2);
                l2.then(v2, v2);
              }
              p2.flags |= 4096;
              p2.lanes = b2;
              break a;
            }
            p2 = p2.return;
          } while (p2 !== null);
          k2 = Error((Ra(h2.type) || "A React component") + " suspended while rendering, but no fallback UI was specified.\n\nAdd a <Suspense fallback=...> component higher in the tree to provide a loading indicator or placeholder to display.");
        }
        V !== 5 && (V = 2);
        k2 = Mi(k2, h2);
        p2 = g2;
        do {
          switch (p2.tag) {
            case 3:
              f2 = k2;
              p2.flags |= 4096;
              b2 &= -b2;
              p2.lanes |= b2;
              var J = Pi(p2, f2, b2);
              Bg(p2, J);
              break a;
            case 1:
              f2 = k2;
              var K = p2.type, Q = p2.stateNode;
              if ((p2.flags & 64) === 0 && (typeof K.getDerivedStateFromError === "function" || Q !== null && typeof Q.componentDidCatch === "function" && (Ti === null || !Ti.has(Q)))) {
                p2.flags |= 4096;
                b2 &= -b2;
                p2.lanes |= b2;
                var L = Si(p2, f2, b2);
                Bg(p2, L);
                break a;
              }
          }
          p2 = p2.return;
        } while (p2 !== null);
      }
      Zj(c3);
    } catch (va) {
      b2 = va;
      Y === c3 && c3 !== null && (Y = c3 = c3.return);
      continue;
    }
    break;
  } while (1);
}
function Pj() {
  var a2 = oj.current;
  oj.current = Gh;
  return a2 === null ? Gh : a2;
}
function Tj(a2, b2) {
  var c3 = X;
  X |= 16;
  var d2 = Pj();
  U === a2 && W === b2 || Qj(a2, b2);
  do
    try {
      ak();
      break;
    } catch (e2) {
      Sj(a2, e2);
    }
  while (1);
  qg();
  X = c3;
  oj.current = d2;
  if (Y !== null)
    throw Error(y(261));
  U = null;
  W = 0;
  return V;
}
function ak() {
  for (; Y !== null; )
    bk(Y);
}
function Rj() {
  for (; Y !== null && !Qf(); )
    bk(Y);
}
function bk(a2) {
  var b2 = ck(a2.alternate, a2, qj);
  a2.memoizedProps = a2.pendingProps;
  b2 === null ? Zj(a2) : Y = b2;
  pj.current = null;
}
function Zj(a2) {
  var b2 = a2;
  do {
    var c3 = b2.alternate;
    a2 = b2.return;
    if ((b2.flags & 2048) === 0) {
      c3 = Gi(c3, b2, qj);
      if (c3 !== null) {
        Y = c3;
        return;
      }
      c3 = b2;
      if (c3.tag !== 24 && c3.tag !== 23 || c3.memoizedState === null || (qj & 1073741824) !== 0 || (c3.mode & 4) === 0) {
        for (var d2 = 0, e2 = c3.child; e2 !== null; )
          d2 |= e2.lanes | e2.childLanes, e2 = e2.sibling;
        c3.childLanes = d2;
      }
      a2 !== null && (a2.flags & 2048) === 0 && (a2.firstEffect === null && (a2.firstEffect = b2.firstEffect), b2.lastEffect !== null && (a2.lastEffect !== null && (a2.lastEffect.nextEffect = b2.firstEffect), a2.lastEffect = b2.lastEffect), 1 < b2.flags && (a2.lastEffect !== null ? a2.lastEffect.nextEffect = b2 : a2.firstEffect = b2, a2.lastEffect = b2));
    } else {
      c3 = Li(b2);
      if (c3 !== null) {
        c3.flags &= 2047;
        Y = c3;
        return;
      }
      a2 !== null && (a2.firstEffect = a2.lastEffect = null, a2.flags |= 2048);
    }
    b2 = b2.sibling;
    if (b2 !== null) {
      Y = b2;
      return;
    }
    Y = b2 = a2;
  } while (b2 !== null);
  V === 0 && (V = 5);
}
function Uj(a2) {
  var b2 = eg();
  gg(99, dk.bind(null, a2, b2));
  return null;
}
function dk(a2, b2) {
  do
    Oj();
  while (yj !== null);
  if ((X & 48) !== 0)
    throw Error(y(327));
  var c3 = a2.finishedWork;
  if (c3 === null)
    return null;
  a2.finishedWork = null;
  a2.finishedLanes = 0;
  if (c3 === a2.current)
    throw Error(y(177));
  a2.callbackNode = null;
  var d2 = c3.lanes | c3.childLanes, e2 = d2, f2 = a2.pendingLanes & ~e2;
  a2.pendingLanes = e2;
  a2.suspendedLanes = 0;
  a2.pingedLanes = 0;
  a2.expiredLanes &= e2;
  a2.mutableReadLanes &= e2;
  a2.entangledLanes &= e2;
  e2 = a2.entanglements;
  for (var g2 = a2.eventTimes, h2 = a2.expirationTimes; 0 < f2; ) {
    var k2 = 31 - Vc(f2), l2 = 1 << k2;
    e2[k2] = 0;
    g2[k2] = -1;
    h2[k2] = -1;
    f2 &= ~l2;
  }
  Cj !== null && (d2 & 24) === 0 && Cj.has(a2) && Cj.delete(a2);
  a2 === U && (Y = U = null, W = 0);
  1 < c3.flags ? c3.lastEffect !== null ? (c3.lastEffect.nextEffect = c3, d2 = c3.firstEffect) : d2 = c3 : d2 = c3.firstEffect;
  if (d2 !== null) {
    e2 = X;
    X |= 32;
    pj.current = null;
    kf = fd;
    g2 = Ne();
    if (Oe(g2)) {
      if ("selectionStart" in g2)
        h2 = {start: g2.selectionStart, end: g2.selectionEnd};
      else
        a:
          if (h2 = (h2 = g2.ownerDocument) && h2.defaultView || window, (l2 = h2.getSelection && h2.getSelection()) && l2.rangeCount !== 0) {
            h2 = l2.anchorNode;
            f2 = l2.anchorOffset;
            k2 = l2.focusNode;
            l2 = l2.focusOffset;
            try {
              h2.nodeType, k2.nodeType;
            } catch (va) {
              h2 = null;
              break a;
            }
            var n3 = 0, A2 = -1, p2 = -1, C = 0, x2 = 0, w2 = g2, z2 = null;
            b:
              for (; ; ) {
                for (var u; ; ) {
                  w2 !== h2 || f2 !== 0 && w2.nodeType !== 3 || (A2 = n3 + f2);
                  w2 !== k2 || l2 !== 0 && w2.nodeType !== 3 || (p2 = n3 + l2);
                  w2.nodeType === 3 && (n3 += w2.nodeValue.length);
                  if ((u = w2.firstChild) === null)
                    break;
                  z2 = w2;
                  w2 = u;
                }
                for (; ; ) {
                  if (w2 === g2)
                    break b;
                  z2 === h2 && ++C === f2 && (A2 = n3);
                  z2 === k2 && ++x2 === l2 && (p2 = n3);
                  if ((u = w2.nextSibling) !== null)
                    break;
                  w2 = z2;
                  z2 = w2.parentNode;
                }
                w2 = u;
              }
            h2 = A2 === -1 || p2 === -1 ? null : {start: A2, end: p2};
          } else
            h2 = null;
      h2 = h2 || {start: 0, end: 0};
    } else
      h2 = null;
    lf = {focusedElem: g2, selectionRange: h2};
    fd = false;
    Ij = null;
    Jj = false;
    Z = d2;
    do
      try {
        ek();
      } catch (va) {
        if (Z === null)
          throw Error(y(330));
        Wi(Z, va);
        Z = Z.nextEffect;
      }
    while (Z !== null);
    Ij = null;
    Z = d2;
    do
      try {
        for (g2 = a2; Z !== null; ) {
          var t5 = Z.flags;
          t5 & 16 && pb(Z.stateNode, "");
          if (t5 & 128) {
            var q2 = Z.alternate;
            if (q2 !== null) {
              var v2 = q2.ref;
              v2 !== null && (typeof v2 === "function" ? v2(null) : v2.current = null);
            }
          }
          switch (t5 & 1038) {
            case 2:
              fj(Z);
              Z.flags &= -3;
              break;
            case 6:
              fj(Z);
              Z.flags &= -3;
              ij(Z.alternate, Z);
              break;
            case 1024:
              Z.flags &= -1025;
              break;
            case 1028:
              Z.flags &= -1025;
              ij(Z.alternate, Z);
              break;
            case 4:
              ij(Z.alternate, Z);
              break;
            case 8:
              h2 = Z;
              cj(g2, h2);
              var J = h2.alternate;
              dj(h2);
              J !== null && dj(J);
          }
          Z = Z.nextEffect;
        }
      } catch (va) {
        if (Z === null)
          throw Error(y(330));
        Wi(Z, va);
        Z = Z.nextEffect;
      }
    while (Z !== null);
    v2 = lf;
    q2 = Ne();
    t5 = v2.focusedElem;
    g2 = v2.selectionRange;
    if (q2 !== t5 && t5 && t5.ownerDocument && Me(t5.ownerDocument.documentElement, t5)) {
      g2 !== null && Oe(t5) && (q2 = g2.start, v2 = g2.end, v2 === void 0 && (v2 = q2), "selectionStart" in t5 ? (t5.selectionStart = q2, t5.selectionEnd = Math.min(v2, t5.value.length)) : (v2 = (q2 = t5.ownerDocument || document) && q2.defaultView || window, v2.getSelection && (v2 = v2.getSelection(), h2 = t5.textContent.length, J = Math.min(g2.start, h2), g2 = g2.end === void 0 ? J : Math.min(g2.end, h2), !v2.extend && J > g2 && (h2 = g2, g2 = J, J = h2), h2 = Le(t5, J), f2 = Le(t5, g2), h2 && f2 && (v2.rangeCount !== 1 || v2.anchorNode !== h2.node || v2.anchorOffset !== h2.offset || v2.focusNode !== f2.node || v2.focusOffset !== f2.offset) && (q2 = q2.createRange(), q2.setStart(h2.node, h2.offset), v2.removeAllRanges(), J > g2 ? (v2.addRange(q2), v2.extend(f2.node, f2.offset)) : (q2.setEnd(f2.node, f2.offset), v2.addRange(q2))))));
      q2 = [];
      for (v2 = t5; v2 = v2.parentNode; )
        v2.nodeType === 1 && q2.push({element: v2, left: v2.scrollLeft, top: v2.scrollTop});
      typeof t5.focus === "function" && t5.focus();
      for (t5 = 0; t5 < q2.length; t5++)
        v2 = q2[t5], v2.element.scrollLeft = v2.left, v2.element.scrollTop = v2.top;
    }
    fd = !!kf;
    lf = kf = null;
    a2.current = c3;
    Z = d2;
    do
      try {
        for (t5 = a2; Z !== null; ) {
          var K = Z.flags;
          K & 36 && Yi(t5, Z.alternate, Z);
          if (K & 128) {
            q2 = void 0;
            var Q = Z.ref;
            if (Q !== null) {
              var L = Z.stateNode;
              switch (Z.tag) {
                case 5:
                  q2 = L;
                  break;
                default:
                  q2 = L;
              }
              typeof Q === "function" ? Q(q2) : Q.current = q2;
            }
          }
          Z = Z.nextEffect;
        }
      } catch (va) {
        if (Z === null)
          throw Error(y(330));
        Wi(Z, va);
        Z = Z.nextEffect;
      }
    while (Z !== null);
    Z = null;
    $f();
    X = e2;
  } else
    a2.current = c3;
  if (xj)
    xj = false, yj = a2, zj = b2;
  else
    for (Z = d2; Z !== null; )
      b2 = Z.nextEffect, Z.nextEffect = null, Z.flags & 8 && (K = Z, K.sibling = null, K.stateNode = null), Z = b2;
  d2 = a2.pendingLanes;
  d2 === 0 && (Ti = null);
  d2 === 1 ? a2 === Ej ? Dj++ : (Dj = 0, Ej = a2) : Dj = 0;
  c3 = c3.stateNode;
  if (Mf && typeof Mf.onCommitFiberRoot === "function")
    try {
      Mf.onCommitFiberRoot(Lf, c3, void 0, (c3.current.flags & 64) === 64);
    } catch (va) {
    }
  Mj(a2, O());
  if (Qi)
    throw Qi = false, a2 = Ri, Ri = null, a2;
  if ((X & 8) !== 0)
    return null;
  ig();
  return null;
}
function ek() {
  for (; Z !== null; ) {
    var a2 = Z.alternate;
    Jj || Ij === null || ((Z.flags & 8) !== 0 ? dc(Z, Ij) && (Jj = true) : Z.tag === 13 && mj(a2, Z) && dc(Z, Ij) && (Jj = true));
    var b2 = Z.flags;
    (b2 & 256) !== 0 && Xi(a2, Z);
    (b2 & 512) === 0 || xj || (xj = true, hg(97, function() {
      Oj();
      return null;
    }));
    Z = Z.nextEffect;
  }
}
function Oj() {
  if (zj !== 90) {
    var a2 = 97 < zj ? 97 : zj;
    zj = 90;
    return gg(a2, fk);
  }
  return false;
}
function $i(a2, b2) {
  Aj.push(b2, a2);
  xj || (xj = true, hg(97, function() {
    Oj();
    return null;
  }));
}
function Zi(a2, b2) {
  Bj.push(b2, a2);
  xj || (xj = true, hg(97, function() {
    Oj();
    return null;
  }));
}
function fk() {
  if (yj === null)
    return false;
  var a2 = yj;
  yj = null;
  if ((X & 48) !== 0)
    throw Error(y(331));
  var b2 = X;
  X |= 32;
  var c3 = Bj;
  Bj = [];
  for (var d2 = 0; d2 < c3.length; d2 += 2) {
    var e2 = c3[d2], f2 = c3[d2 + 1], g2 = e2.destroy;
    e2.destroy = void 0;
    if (typeof g2 === "function")
      try {
        g2();
      } catch (k2) {
        if (f2 === null)
          throw Error(y(330));
        Wi(f2, k2);
      }
  }
  c3 = Aj;
  Aj = [];
  for (d2 = 0; d2 < c3.length; d2 += 2) {
    e2 = c3[d2];
    f2 = c3[d2 + 1];
    try {
      var h2 = e2.create;
      e2.destroy = h2();
    } catch (k2) {
      if (f2 === null)
        throw Error(y(330));
      Wi(f2, k2);
    }
  }
  for (h2 = a2.current.firstEffect; h2 !== null; )
    a2 = h2.nextEffect, h2.nextEffect = null, h2.flags & 8 && (h2.sibling = null, h2.stateNode = null), h2 = a2;
  X = b2;
  ig();
  return true;
}
function gk(a2, b2, c3) {
  b2 = Mi(c3, b2);
  b2 = Pi(a2, b2, 1);
  Ag(a2, b2);
  b2 = Hg();
  a2 = Kj(a2, 1);
  a2 !== null && ($c(a2, 1, b2), Mj(a2, b2));
}
function Wi(a2, b2) {
  if (a2.tag === 3)
    gk(a2, a2, b2);
  else
    for (var c3 = a2.return; c3 !== null; ) {
      if (c3.tag === 3) {
        gk(c3, a2, b2);
        break;
      } else if (c3.tag === 1) {
        var d2 = c3.stateNode;
        if (typeof c3.type.getDerivedStateFromError === "function" || typeof d2.componentDidCatch === "function" && (Ti === null || !Ti.has(d2))) {
          a2 = Mi(b2, a2);
          var e2 = Si(c3, a2, 1);
          Ag(c3, e2);
          e2 = Hg();
          c3 = Kj(c3, 1);
          if (c3 !== null)
            $c(c3, 1, e2), Mj(c3, e2);
          else if (typeof d2.componentDidCatch === "function" && (Ti === null || !Ti.has(d2)))
            try {
              d2.componentDidCatch(b2, a2);
            } catch (f2) {
            }
          break;
        }
      }
      c3 = c3.return;
    }
}
function Yj(a2, b2, c3) {
  var d2 = a2.pingCache;
  d2 !== null && d2.delete(b2);
  b2 = Hg();
  a2.pingedLanes |= a2.suspendedLanes & c3;
  U === a2 && (W & c3) === c3 && (V === 4 || V === 3 && (W & 62914560) === W && 500 > O() - jj ? Qj(a2, 0) : uj |= c3);
  Mj(a2, b2);
}
function lj(a2, b2) {
  var c3 = a2.stateNode;
  c3 !== null && c3.delete(b2);
  b2 = 0;
  b2 === 0 && (b2 = a2.mode, (b2 & 2) === 0 ? b2 = 1 : (b2 & 4) === 0 ? b2 = eg() === 99 ? 1 : 2 : (Gj === 0 && (Gj = tj), b2 = Yc(62914560 & ~Gj), b2 === 0 && (b2 = 4194304)));
  c3 = Hg();
  a2 = Kj(a2, b2);
  a2 !== null && ($c(a2, b2, c3), Mj(a2, c3));
}
var ck;
ck = function(a2, b2, c3) {
  var d2 = b2.lanes;
  if (a2 !== null)
    if (a2.memoizedProps !== b2.pendingProps || N.current)
      ug = true;
    else if ((c3 & d2) !== 0)
      ug = (a2.flags & 16384) !== 0 ? true : false;
    else {
      ug = false;
      switch (b2.tag) {
        case 3:
          ri(b2);
          sh();
          break;
        case 5:
          gh(b2);
          break;
        case 1:
          Ff(b2.type) && Jf(b2);
          break;
        case 4:
          eh(b2, b2.stateNode.containerInfo);
          break;
        case 10:
          d2 = b2.memoizedProps.value;
          var e2 = b2.type._context;
          I(mg, e2._currentValue);
          e2._currentValue = d2;
          break;
        case 13:
          if (b2.memoizedState !== null) {
            if ((c3 & b2.child.childLanes) !== 0)
              return ti(a2, b2, c3);
            I(P, P.current & 1);
            b2 = hi(a2, b2, c3);
            return b2 !== null ? b2.sibling : null;
          }
          I(P, P.current & 1);
          break;
        case 19:
          d2 = (c3 & b2.childLanes) !== 0;
          if ((a2.flags & 64) !== 0) {
            if (d2)
              return Ai(a2, b2, c3);
            b2.flags |= 64;
          }
          e2 = b2.memoizedState;
          e2 !== null && (e2.rendering = null, e2.tail = null, e2.lastEffect = null);
          I(P, P.current);
          if (d2)
            break;
          else
            return null;
        case 23:
        case 24:
          return b2.lanes = 0, mi(a2, b2, c3);
      }
      return hi(a2, b2, c3);
    }
  else
    ug = false;
  b2.lanes = 0;
  switch (b2.tag) {
    case 2:
      d2 = b2.type;
      a2 !== null && (a2.alternate = null, b2.alternate = null, b2.flags |= 2);
      a2 = b2.pendingProps;
      e2 = Ef(b2, M.current);
      tg(b2, c3);
      e2 = Ch(null, b2, d2, a2, e2, c3);
      b2.flags |= 1;
      if (typeof e2 === "object" && e2 !== null && typeof e2.render === "function" && e2.$$typeof === void 0) {
        b2.tag = 1;
        b2.memoizedState = null;
        b2.updateQueue = null;
        if (Ff(d2)) {
          var f2 = true;
          Jf(b2);
        } else
          f2 = false;
        b2.memoizedState = e2.state !== null && e2.state !== void 0 ? e2.state : null;
        xg(b2);
        var g2 = d2.getDerivedStateFromProps;
        typeof g2 === "function" && Gg(b2, d2, g2, a2);
        e2.updater = Kg;
        b2.stateNode = e2;
        e2._reactInternals = b2;
        Og(b2, d2, a2, c3);
        b2 = qi(null, b2, d2, true, f2, c3);
      } else
        b2.tag = 0, fi(null, b2, e2, c3), b2 = b2.child;
      return b2;
    case 16:
      e2 = b2.elementType;
      a: {
        a2 !== null && (a2.alternate = null, b2.alternate = null, b2.flags |= 2);
        a2 = b2.pendingProps;
        f2 = e2._init;
        e2 = f2(e2._payload);
        b2.type = e2;
        f2 = b2.tag = hk(e2);
        a2 = lg(e2, a2);
        switch (f2) {
          case 0:
            b2 = li(null, b2, e2, a2, c3);
            break a;
          case 1:
            b2 = pi(null, b2, e2, a2, c3);
            break a;
          case 11:
            b2 = gi(null, b2, e2, a2, c3);
            break a;
          case 14:
            b2 = ii(null, b2, e2, lg(e2.type, a2), d2, c3);
            break a;
        }
        throw Error(y(306, e2, ""));
      }
      return b2;
    case 0:
      return d2 = b2.type, e2 = b2.pendingProps, e2 = b2.elementType === d2 ? e2 : lg(d2, e2), li(a2, b2, d2, e2, c3);
    case 1:
      return d2 = b2.type, e2 = b2.pendingProps, e2 = b2.elementType === d2 ? e2 : lg(d2, e2), pi(a2, b2, d2, e2, c3);
    case 3:
      ri(b2);
      d2 = b2.updateQueue;
      if (a2 === null || d2 === null)
        throw Error(y(282));
      d2 = b2.pendingProps;
      e2 = b2.memoizedState;
      e2 = e2 !== null ? e2.element : null;
      yg(a2, b2);
      Cg(b2, d2, null, c3);
      d2 = b2.memoizedState.element;
      if (d2 === e2)
        sh(), b2 = hi(a2, b2, c3);
      else {
        e2 = b2.stateNode;
        if (f2 = e2.hydrate)
          kh = rf(b2.stateNode.containerInfo.firstChild), jh = b2, f2 = lh = true;
        if (f2) {
          a2 = e2.mutableSourceEagerHydrationData;
          if (a2 != null)
            for (e2 = 0; e2 < a2.length; e2 += 2)
              f2 = a2[e2], f2._workInProgressVersionPrimary = a2[e2 + 1], th.push(f2);
          c3 = Zg(b2, null, d2, c3);
          for (b2.child = c3; c3; )
            c3.flags = c3.flags & -3 | 1024, c3 = c3.sibling;
        } else
          fi(a2, b2, d2, c3), sh();
        b2 = b2.child;
      }
      return b2;
    case 5:
      return gh(b2), a2 === null && ph(b2), d2 = b2.type, e2 = b2.pendingProps, f2 = a2 !== null ? a2.memoizedProps : null, g2 = e2.children, nf(d2, e2) ? g2 = null : f2 !== null && nf(d2, f2) && (b2.flags |= 16), oi(a2, b2), fi(a2, b2, g2, c3), b2.child;
    case 6:
      return a2 === null && ph(b2), null;
    case 13:
      return ti(a2, b2, c3);
    case 4:
      return eh(b2, b2.stateNode.containerInfo), d2 = b2.pendingProps, a2 === null ? b2.child = Yg(b2, null, d2, c3) : fi(a2, b2, d2, c3), b2.child;
    case 11:
      return d2 = b2.type, e2 = b2.pendingProps, e2 = b2.elementType === d2 ? e2 : lg(d2, e2), gi(a2, b2, d2, e2, c3);
    case 7:
      return fi(a2, b2, b2.pendingProps, c3), b2.child;
    case 8:
      return fi(a2, b2, b2.pendingProps.children, c3), b2.child;
    case 12:
      return fi(a2, b2, b2.pendingProps.children, c3), b2.child;
    case 10:
      a: {
        d2 = b2.type._context;
        e2 = b2.pendingProps;
        g2 = b2.memoizedProps;
        f2 = e2.value;
        var h2 = b2.type._context;
        I(mg, h2._currentValue);
        h2._currentValue = f2;
        if (g2 !== null)
          if (h2 = g2.value, f2 = He(h2, f2) ? 0 : (typeof d2._calculateChangedBits === "function" ? d2._calculateChangedBits(h2, f2) : 1073741823) | 0, f2 === 0) {
            if (g2.children === e2.children && !N.current) {
              b2 = hi(a2, b2, c3);
              break a;
            }
          } else
            for (h2 = b2.child, h2 !== null && (h2.return = b2); h2 !== null; ) {
              var k2 = h2.dependencies;
              if (k2 !== null) {
                g2 = h2.child;
                for (var l2 = k2.firstContext; l2 !== null; ) {
                  if (l2.context === d2 && (l2.observedBits & f2) !== 0) {
                    h2.tag === 1 && (l2 = zg(-1, c3 & -c3), l2.tag = 2, Ag(h2, l2));
                    h2.lanes |= c3;
                    l2 = h2.alternate;
                    l2 !== null && (l2.lanes |= c3);
                    sg(h2.return, c3);
                    k2.lanes |= c3;
                    break;
                  }
                  l2 = l2.next;
                }
              } else
                g2 = h2.tag === 10 ? h2.type === b2.type ? null : h2.child : h2.child;
              if (g2 !== null)
                g2.return = h2;
              else
                for (g2 = h2; g2 !== null; ) {
                  if (g2 === b2) {
                    g2 = null;
                    break;
                  }
                  h2 = g2.sibling;
                  if (h2 !== null) {
                    h2.return = g2.return;
                    g2 = h2;
                    break;
                  }
                  g2 = g2.return;
                }
              h2 = g2;
            }
        fi(a2, b2, e2.children, c3);
        b2 = b2.child;
      }
      return b2;
    case 9:
      return e2 = b2.type, f2 = b2.pendingProps, d2 = f2.children, tg(b2, c3), e2 = vg(e2, f2.unstable_observedBits), d2 = d2(e2), b2.flags |= 1, fi(a2, b2, d2, c3), b2.child;
    case 14:
      return e2 = b2.type, f2 = lg(e2, b2.pendingProps), f2 = lg(e2.type, f2), ii(a2, b2, e2, f2, d2, c3);
    case 15:
      return ki(a2, b2, b2.type, b2.pendingProps, d2, c3);
    case 17:
      return d2 = b2.type, e2 = b2.pendingProps, e2 = b2.elementType === d2 ? e2 : lg(d2, e2), a2 !== null && (a2.alternate = null, b2.alternate = null, b2.flags |= 2), b2.tag = 1, Ff(d2) ? (a2 = true, Jf(b2)) : a2 = false, tg(b2, c3), Mg(b2, d2, e2), Og(b2, d2, e2, c3), qi(null, b2, d2, true, a2, c3);
    case 19:
      return Ai(a2, b2, c3);
    case 23:
      return mi(a2, b2, c3);
    case 24:
      return mi(a2, b2, c3);
  }
  throw Error(y(156, b2.tag));
};
function ik(a2, b2, c3, d2) {
  this.tag = a2;
  this.key = c3;
  this.sibling = this.child = this.return = this.stateNode = this.type = this.elementType = null;
  this.index = 0;
  this.ref = null;
  this.pendingProps = b2;
  this.dependencies = this.memoizedState = this.updateQueue = this.memoizedProps = null;
  this.mode = d2;
  this.flags = 0;
  this.lastEffect = this.firstEffect = this.nextEffect = null;
  this.childLanes = this.lanes = 0;
  this.alternate = null;
}
function nh(a2, b2, c3, d2) {
  return new ik(a2, b2, c3, d2);
}
function ji(a2) {
  a2 = a2.prototype;
  return !(!a2 || !a2.isReactComponent);
}
function hk(a2) {
  if (typeof a2 === "function")
    return ji(a2) ? 1 : 0;
  if (a2 !== void 0 && a2 !== null) {
    a2 = a2.$$typeof;
    if (a2 === Aa)
      return 11;
    if (a2 === Da)
      return 14;
  }
  return 2;
}
function Tg(a2, b2) {
  var c3 = a2.alternate;
  c3 === null ? (c3 = nh(a2.tag, b2, a2.key, a2.mode), c3.elementType = a2.elementType, c3.type = a2.type, c3.stateNode = a2.stateNode, c3.alternate = a2, a2.alternate = c3) : (c3.pendingProps = b2, c3.type = a2.type, c3.flags = 0, c3.nextEffect = null, c3.firstEffect = null, c3.lastEffect = null);
  c3.childLanes = a2.childLanes;
  c3.lanes = a2.lanes;
  c3.child = a2.child;
  c3.memoizedProps = a2.memoizedProps;
  c3.memoizedState = a2.memoizedState;
  c3.updateQueue = a2.updateQueue;
  b2 = a2.dependencies;
  c3.dependencies = b2 === null ? null : {lanes: b2.lanes, firstContext: b2.firstContext};
  c3.sibling = a2.sibling;
  c3.index = a2.index;
  c3.ref = a2.ref;
  return c3;
}
function Vg(a2, b2, c3, d2, e2, f2) {
  var g2 = 2;
  d2 = a2;
  if (typeof a2 === "function")
    ji(a2) && (g2 = 1);
  else if (typeof a2 === "string")
    g2 = 5;
  else
    a:
      switch (a2) {
        case ua:
          return Xg(c3.children, e2, f2, b2);
        case Ha:
          g2 = 8;
          e2 |= 16;
          break;
        case wa:
          g2 = 8;
          e2 |= 1;
          break;
        case xa:
          return a2 = nh(12, c3, b2, e2 | 8), a2.elementType = xa, a2.type = xa, a2.lanes = f2, a2;
        case Ba:
          return a2 = nh(13, c3, b2, e2), a2.type = Ba, a2.elementType = Ba, a2.lanes = f2, a2;
        case Ca:
          return a2 = nh(19, c3, b2, e2), a2.elementType = Ca, a2.lanes = f2, a2;
        case Ia:
          return vi(c3, e2, f2, b2);
        case Ja:
          return a2 = nh(24, c3, b2, e2), a2.elementType = Ja, a2.lanes = f2, a2;
        default:
          if (typeof a2 === "object" && a2 !== null)
            switch (a2.$$typeof) {
              case ya:
                g2 = 10;
                break a;
              case za:
                g2 = 9;
                break a;
              case Aa:
                g2 = 11;
                break a;
              case Da:
                g2 = 14;
                break a;
              case Ea:
                g2 = 16;
                d2 = null;
                break a;
              case Fa:
                g2 = 22;
                break a;
            }
          throw Error(y(130, a2 == null ? a2 : typeof a2, ""));
      }
  b2 = nh(g2, c3, b2, e2);
  b2.elementType = a2;
  b2.type = d2;
  b2.lanes = f2;
  return b2;
}
function Xg(a2, b2, c3, d2) {
  a2 = nh(7, a2, d2, b2);
  a2.lanes = c3;
  return a2;
}
function vi(a2, b2, c3, d2) {
  a2 = nh(23, a2, d2, b2);
  a2.elementType = Ia;
  a2.lanes = c3;
  return a2;
}
function Ug(a2, b2, c3) {
  a2 = nh(6, a2, null, b2);
  a2.lanes = c3;
  return a2;
}
function Wg(a2, b2, c3) {
  b2 = nh(4, a2.children !== null ? a2.children : [], a2.key, b2);
  b2.lanes = c3;
  b2.stateNode = {containerInfo: a2.containerInfo, pendingChildren: null, implementation: a2.implementation};
  return b2;
}
function jk(a2, b2, c3) {
  this.tag = b2;
  this.containerInfo = a2;
  this.finishedWork = this.pingCache = this.current = this.pendingChildren = null;
  this.timeoutHandle = -1;
  this.pendingContext = this.context = null;
  this.hydrate = c3;
  this.callbackNode = null;
  this.callbackPriority = 0;
  this.eventTimes = Zc(0);
  this.expirationTimes = Zc(-1);
  this.entangledLanes = this.finishedLanes = this.mutableReadLanes = this.expiredLanes = this.pingedLanes = this.suspendedLanes = this.pendingLanes = 0;
  this.entanglements = Zc(0);
  this.mutableSourceEagerHydrationData = null;
}
function kk(a2, b2, c3) {
  var d2 = 3 < arguments.length && arguments[3] !== void 0 ? arguments[3] : null;
  return {$$typeof: ta, key: d2 == null ? null : "" + d2, children: a2, containerInfo: b2, implementation: c3};
}
function lk(a2, b2, c3, d2) {
  var e2 = b2.current, f2 = Hg(), g2 = Ig(e2);
  a:
    if (c3) {
      c3 = c3._reactInternals;
      b: {
        if (Zb(c3) !== c3 || c3.tag !== 1)
          throw Error(y(170));
        var h2 = c3;
        do {
          switch (h2.tag) {
            case 3:
              h2 = h2.stateNode.context;
              break b;
            case 1:
              if (Ff(h2.type)) {
                h2 = h2.stateNode.__reactInternalMemoizedMergedChildContext;
                break b;
              }
          }
          h2 = h2.return;
        } while (h2 !== null);
        throw Error(y(171));
      }
      if (c3.tag === 1) {
        var k2 = c3.type;
        if (Ff(k2)) {
          c3 = If(c3, k2, h2);
          break a;
        }
      }
      c3 = h2;
    } else
      c3 = Cf;
  b2.context === null ? b2.context = c3 : b2.pendingContext = c3;
  b2 = zg(f2, g2);
  b2.payload = {element: a2};
  d2 = d2 === void 0 ? null : d2;
  d2 !== null && (b2.callback = d2);
  Ag(e2, b2);
  Jg(e2, g2, f2);
  return g2;
}
function mk(a2) {
  a2 = a2.current;
  if (!a2.child)
    return null;
  switch (a2.child.tag) {
    case 5:
      return a2.child.stateNode;
    default:
      return a2.child.stateNode;
  }
}
function nk(a2, b2) {
  a2 = a2.memoizedState;
  if (a2 !== null && a2.dehydrated !== null) {
    var c3 = a2.retryLane;
    a2.retryLane = c3 !== 0 && c3 < b2 ? c3 : b2;
  }
}
function ok(a2, b2) {
  nk(a2, b2);
  (a2 = a2.alternate) && nk(a2, b2);
}
function pk() {
  return null;
}
function qk(a2, b2, c3) {
  var d2 = c3 != null && c3.hydrationOptions != null && c3.hydrationOptions.mutableSources || null;
  c3 = new jk(a2, b2, c3 != null && c3.hydrate === true);
  b2 = nh(3, null, null, b2 === 2 ? 7 : b2 === 1 ? 3 : 0);
  c3.current = b2;
  b2.stateNode = c3;
  xg(b2);
  a2[ff] = c3.current;
  cf(a2.nodeType === 8 ? a2.parentNode : a2);
  if (d2)
    for (a2 = 0; a2 < d2.length; a2++) {
      b2 = d2[a2];
      var e2 = b2._getVersion;
      e2 = e2(b2._source);
      c3.mutableSourceEagerHydrationData == null ? c3.mutableSourceEagerHydrationData = [b2, e2] : c3.mutableSourceEagerHydrationData.push(b2, e2);
    }
  this._internalRoot = c3;
}
qk.prototype.render = function(a2) {
  lk(a2, this._internalRoot, null, null);
};
qk.prototype.unmount = function() {
  var a2 = this._internalRoot, b2 = a2.containerInfo;
  lk(null, a2, null, function() {
    b2[ff] = null;
  });
};
function rk(a2) {
  return !(!a2 || a2.nodeType !== 1 && a2.nodeType !== 9 && a2.nodeType !== 11 && (a2.nodeType !== 8 || a2.nodeValue !== " react-mount-point-unstable "));
}
function sk(a2, b2) {
  b2 || (b2 = a2 ? a2.nodeType === 9 ? a2.documentElement : a2.firstChild : null, b2 = !(!b2 || b2.nodeType !== 1 || !b2.hasAttribute("data-reactroot")));
  if (!b2)
    for (var c3; c3 = a2.lastChild; )
      a2.removeChild(c3);
  return new qk(a2, 0, b2 ? {hydrate: true} : void 0);
}
function tk(a2, b2, c3, d2, e2) {
  var f2 = c3._reactRootContainer;
  if (f2) {
    var g2 = f2._internalRoot;
    if (typeof e2 === "function") {
      var h2 = e2;
      e2 = function() {
        var a3 = mk(g2);
        h2.call(a3);
      };
    }
    lk(b2, g2, a2, e2);
  } else {
    f2 = c3._reactRootContainer = sk(c3, d2);
    g2 = f2._internalRoot;
    if (typeof e2 === "function") {
      var k2 = e2;
      e2 = function() {
        var a3 = mk(g2);
        k2.call(a3);
      };
    }
    Xj(function() {
      lk(b2, g2, a2, e2);
    });
  }
  return mk(g2);
}
ec = function(a2) {
  if (a2.tag === 13) {
    var b2 = Hg();
    Jg(a2, 4, b2);
    ok(a2, 4);
  }
};
fc = function(a2) {
  if (a2.tag === 13) {
    var b2 = Hg();
    Jg(a2, 67108864, b2);
    ok(a2, 67108864);
  }
};
gc = function(a2) {
  if (a2.tag === 13) {
    var b2 = Hg(), c3 = Ig(a2);
    Jg(a2, c3, b2);
    ok(a2, c3);
  }
};
hc = function(a2, b2) {
  return b2();
};
yb = function(a2, b2, c3) {
  switch (b2) {
    case "input":
      ab(a2, c3);
      b2 = c3.name;
      if (c3.type === "radio" && b2 != null) {
        for (c3 = a2; c3.parentNode; )
          c3 = c3.parentNode;
        c3 = c3.querySelectorAll("input[name=" + JSON.stringify("" + b2) + '][type="radio"]');
        for (b2 = 0; b2 < c3.length; b2++) {
          var d2 = c3[b2];
          if (d2 !== a2 && d2.form === a2.form) {
            var e2 = Db(d2);
            if (!e2)
              throw Error(y(90));
            Wa(d2);
            ab(d2, e2);
          }
        }
      }
      break;
    case "textarea":
      ib(a2, c3);
      break;
    case "select":
      b2 = c3.value, b2 != null && fb(a2, !!c3.multiple, b2, false);
  }
};
Gb = Wj;
Hb = function(a2, b2, c3, d2, e2) {
  var f2 = X;
  X |= 4;
  try {
    return gg(98, a2.bind(null, b2, c3, d2, e2));
  } finally {
    X = f2, X === 0 && (wj(), ig());
  }
};
Ib = function() {
  (X & 49) === 0 && (Vj(), Oj());
};
Jb = function(a2, b2) {
  var c3 = X;
  X |= 2;
  try {
    return a2(b2);
  } finally {
    X = c3, X === 0 && (wj(), ig());
  }
};
function uk(a2, b2) {
  var c3 = 2 < arguments.length && arguments[2] !== void 0 ? arguments[2] : null;
  if (!rk(b2))
    throw Error(y(200));
  return kk(a2, b2, null, c3);
}
var vk = {Events: [Cb, ue, Db, Eb, Fb, Oj, {current: false}]};
var wk = {findFiberByHostInstance: wc, bundleType: 0, version: "17.0.2", rendererPackageName: "react-dom"};
var xk = {bundleType: wk.bundleType, version: wk.version, rendererPackageName: wk.rendererPackageName, rendererConfig: wk.rendererConfig, overrideHookState: null, overrideHookStateDeletePath: null, overrideHookStateRenamePath: null, overrideProps: null, overridePropsDeletePath: null, overridePropsRenamePath: null, setSuspenseHandler: null, scheduleUpdate: null, currentDispatcherRef: ra.ReactCurrentDispatcher, findHostInstanceByFiber: function(a2) {
  a2 = cc(a2);
  return a2 === null ? null : a2.stateNode;
}, findFiberByHostInstance: wk.findFiberByHostInstance || pk, findHostInstancesForRefresh: null, scheduleRefresh: null, scheduleRoot: null, setRefreshHandler: null, getCurrentFiber: null};
if (typeof __REACT_DEVTOOLS_GLOBAL_HOOK__ !== "undefined") {
  yk = __REACT_DEVTOOLS_GLOBAL_HOOK__;
  if (!yk.isDisabled && yk.supportsFiber)
    try {
      Lf = yk.inject(xk), Mf = yk;
    } catch (a2) {
    }
}
var yk;
var __SECRET_INTERNALS_DO_NOT_USE_OR_YOU_WILL_BE_FIRED = vk;
var createPortal = uk;
var findDOMNode = function(a2) {
  if (a2 == null)
    return null;
  if (a2.nodeType === 1)
    return a2;
  var b2 = a2._reactInternals;
  if (b2 === void 0) {
    if (typeof a2.render === "function")
      throw Error(y(188));
    throw Error(y(268, Object.keys(a2)));
  }
  a2 = cc(b2);
  a2 = a2 === null ? null : a2.stateNode;
  return a2;
};
var flushSync = function(a2, b2) {
  var c3 = X;
  if ((c3 & 48) !== 0)
    return a2(b2);
  X |= 1;
  try {
    if (a2)
      return gg(99, a2.bind(null, b2));
  } finally {
    X = c3, ig();
  }
};
var hydrate = function(a2, b2, c3) {
  if (!rk(b2))
    throw Error(y(200));
  return tk(null, a2, b2, true, c3);
};
var render = function(a2, b2, c3) {
  if (!rk(b2))
    throw Error(y(200));
  return tk(null, a2, b2, false, c3);
};
var unmountComponentAtNode = function(a2) {
  if (!rk(a2))
    throw Error(y(40));
  return a2._reactRootContainer ? (Xj(function() {
    tk(null, null, a2, false, function() {
      a2._reactRootContainer = null;
      a2[ff] = null;
    });
  }), true) : false;
};
var unstable_batchedUpdates = Wj;
var unstable_createPortal = function(a2, b2) {
  return uk(a2, b2, 2 < arguments.length && arguments[2] !== void 0 ? arguments[2] : null);
};
var unstable_renderSubtreeIntoContainer = function(a2, b2, c3, d2) {
  if (!rk(c3))
    throw Error(y(200));
  if (a2 == null || a2._reactInternals === void 0)
    throw Error(y(38));
  return tk(a2, b2, c3, false, d2);
};
var version = "17.0.2";
var reactDom_production_min = {
  __SECRET_INTERNALS_DO_NOT_USE_OR_YOU_WILL_BE_FIRED,
  createPortal,
  findDOMNode,
  flushSync,
  hydrate,
  render,
  unmountComponentAtNode,
  unstable_batchedUpdates,
  unstable_createPortal,
  unstable_renderSubtreeIntoContainer,
  version
};
var reactDom = createCommonjsModule(function(module2) {
  function checkDCE() {
    if (typeof __REACT_DEVTOOLS_GLOBAL_HOOK__ === "undefined" || typeof __REACT_DEVTOOLS_GLOBAL_HOOK__.checkDCE !== "function") {
      return;
    }
    try {
      __REACT_DEVTOOLS_GLOBAL_HOOK__.checkDCE(checkDCE);
    } catch (err) {
      console.error(err);
    }
  }
  {
    checkDCE();
    module2.exports = reactDom_production_min;
  }
});

// build/_snowpack/pkg/common/createIcon-1a4b25a9.js
/*! *****************************************************************************
Copyright (c) Microsoft Corporation.

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THIS SOFTWARE.
***************************************************************************** */
function __rest(s2, e2) {
  var t5 = {};
  for (var p2 in s2)
    if (Object.prototype.hasOwnProperty.call(s2, p2) && e2.indexOf(p2) < 0)
      t5[p2] = s2[p2];
  if (s2 != null && typeof Object.getOwnPropertySymbols === "function")
    for (var i3 = 0, p2 = Object.getOwnPropertySymbols(s2); i3 < p2.length; i3++) {
      if (e2.indexOf(p2[i3]) < 0 && Object.prototype.propertyIsEnumerable.call(s2, p2[i3]))
        t5[p2[i3]] = s2[p2[i3]];
    }
  return t5;
}
function __awaiter(thisArg, _arguments, P2, generator) {
  function adopt(value) {
    return value instanceof P2 ? value : new P2(function(resolve2) {
      resolve2(value);
    });
  }
  return new (P2 || (P2 = Promise))(function(resolve2, reject) {
    function fulfilled(value) {
      try {
        step(generator.next(value));
      } catch (e2) {
        reject(e2);
      }
    }
    function rejected(value) {
      try {
        step(generator["throw"](value));
      } catch (e2) {
        reject(e2);
      }
    }
    function step(result) {
      result.done ? resolve2(result.value) : adopt(result.value).then(fulfilled, rejected);
    }
    step((generator = generator.apply(thisArg, _arguments || [])).next());
  });
}
function __generator(thisArg, body) {
  var _23 = {label: 0, sent: function() {
    if (t5[0] & 1)
      throw t5[1];
    return t5[1];
  }, trys: [], ops: []}, f2, y3, t5, g2;
  return g2 = {next: verb(0), throw: verb(1), return: verb(2)}, typeof Symbol === "function" && (g2[Symbol.iterator] = function() {
    return this;
  }), g2;
  function verb(n3) {
    return function(v2) {
      return step([n3, v2]);
    };
  }
  function step(op) {
    if (f2)
      throw new TypeError("Generator is already executing.");
    while (_23)
      try {
        if (f2 = 1, y3 && (t5 = op[0] & 2 ? y3["return"] : op[0] ? y3["throw"] || ((t5 = y3["return"]) && t5.call(y3), 0) : y3.next) && !(t5 = t5.call(y3, op[1])).done)
          return t5;
        if (y3 = 0, t5)
          op = [op[0] & 2, t5.value];
        switch (op[0]) {
          case 0:
          case 1:
            t5 = op;
            break;
          case 4:
            _23.label++;
            return {value: op[1], done: false};
          case 5:
            _23.label++;
            y3 = op[1];
            op = [0];
            continue;
          case 7:
            op = _23.ops.pop();
            _23.trys.pop();
            continue;
          default:
            if (!(t5 = _23.trys, t5 = t5.length > 0 && t5[t5.length - 1]) && (op[0] === 6 || op[0] === 2)) {
              _23 = 0;
              continue;
            }
            if (op[0] === 3 && (!t5 || op[1] > t5[0] && op[1] < t5[3])) {
              _23.label = op[1];
              break;
            }
            if (op[0] === 6 && _23.label < t5[1]) {
              _23.label = t5[1];
              t5 = op;
              break;
            }
            if (t5 && _23.label < t5[2]) {
              _23.label = t5[2];
              _23.ops.push(op);
              break;
            }
            if (t5[2])
              _23.ops.pop();
            _23.trys.pop();
            continue;
        }
        op = body.call(thisArg, _23);
      } catch (e2) {
        op = [6, e2];
        y3 = 0;
      } finally {
        f2 = t5 = 0;
      }
    if (op[0] & 5)
      throw op[1];
    return {value: op[0] ? op[1] : void 0, done: true};
  }
}
function __read(o, n3) {
  var m2 = typeof Symbol === "function" && o[Symbol.iterator];
  if (!m2)
    return o;
  var i3 = m2.call(o), r3, ar = [], e2;
  try {
    while ((n3 === void 0 || n3-- > 0) && !(r3 = i3.next()).done)
      ar.push(r3.value);
  } catch (error2) {
    e2 = {error: error2};
  } finally {
    try {
      if (r3 && !r3.done && (m2 = i3["return"]))
        m2.call(i3);
    } finally {
      if (e2)
        throw e2.error;
    }
  }
  return ar;
}
function __spread() {
  for (var ar = [], i3 = 0; i3 < arguments.length; i3++)
    ar = ar.concat(__read(arguments[i3]));
  return ar;
}
var IconSize;
(function(IconSize2) {
  IconSize2["sm"] = "sm";
  IconSize2["md"] = "md";
  IconSize2["lg"] = "lg";
  IconSize2["xl"] = "xl";
})(IconSize || (IconSize = {}));
var getSize = (size2) => {
  switch (size2) {
    case IconSize.sm:
      return "1em";
    case IconSize.md:
      return "1.5em";
    case IconSize.lg:
      return "2em";
    case IconSize.xl:
      return "3em";
    default:
      return "1em";
  }
};
var currentId = 0;
function createIcon({name, xOffset = 0, yOffset = 0, width: width2, height, svgPath}) {
  var _a;
  return _a = class SVGIcon extends react.Component {
    constructor() {
      super(...arguments);
      this.id = `icon-title-${currentId++}`;
    }
    render() {
      const _a2 = this.props, {size: size2, color: color2, title: title3, noVerticalAlign} = _a2, props = __rest(_a2, ["size", "color", "title", "noVerticalAlign"]);
      const hasTitle = Boolean(title3);
      const heightWidth = getSize(size2);
      const baseAlign = -0.125 * Number.parseFloat(heightWidth);
      const style = noVerticalAlign ? null : {verticalAlign: `${baseAlign}em`};
      const viewBox = [xOffset, yOffset, width2, height].join(" ");
      return react.createElement("svg", Object.assign({style, fill: color2, height: heightWidth, width: heightWidth, viewBox, "aria-labelledby": hasTitle ? this.id : null, "aria-hidden": hasTitle ? null : true, role: "img"}, props), hasTitle && react.createElement("title", {id: this.id}, title3), react.createElement("path", {d: svgPath}));
    }
  }, _a.displayName = name, _a.defaultProps = {
    color: "currentColor",
    size: IconSize.sm,
    noVerticalAlign: false
  }, _a;
}

// build/_snowpack/pkg/common/EmptyState-cea4cc03.js
function css(...args) {
  const classes = [];
  const hasOwn = {}.hasOwnProperty;
  args.filter(Boolean).forEach((arg) => {
    const argType = typeof arg;
    if (argType === "string" || argType === "number") {
      classes.push(arg);
    } else if (Array.isArray(arg) && arg.length) {
      const inner = css(...arg);
      if (inner) {
        classes.push(inner);
      }
    } else if (argType === "object") {
      for (const key in arg) {
        if (hasOwn.call(arg, key) && arg[key]) {
          classes.push(key);
        }
      }
    }
  });
  return classes.join(" ");
}
var KEY_CODES = {ARROW_UP: 38, ARROW_DOWN: 40, ESCAPE_KEY: 27, TAB: 9, ENTER: 13, SPACE: 32};
var KEYHANDLER_DIRECTION = {UP: "up", DOWN: "down", RIGHT: "right", LEFT: "left"};
var ValidatedOptions;
(function(ValidatedOptions2) {
  ValidatedOptions2["success"] = "success";
  ValidatedOptions2["error"] = "error";
  ValidatedOptions2["warning"] = "warning";
  ValidatedOptions2["default"] = "default";
})(ValidatedOptions || (ValidatedOptions = {}));
var uid = 0;
var ouiaPrefix = "OUIA-Generated-";
var ouiaIdByRoute = {};
function getOUIAProps(componentType, id3, ouiaSafe = true) {
  return {
    "data-ouia-component-type": `PF4/${componentType}`,
    "data-ouia-safe": ouiaSafe,
    "data-ouia-component-id": id3
  };
}
var useOUIAProps = (componentType, id3, ouiaSafe = true, variant) => ({
  "data-ouia-component-type": `PF4/${componentType}`,
  "data-ouia-safe": ouiaSafe,
  "data-ouia-component-id": useOUIAId(componentType, id3, variant)
});
var useOUIAId = (componentType, id3, variant) => {
  if (id3 !== void 0) {
    return id3;
  }
  return react.useMemo(() => getDefaultOUIAId(componentType, variant), [componentType, variant]);
};
function getDefaultOUIAId(componentType, variant) {
  try {
    const key = `${window.location.href}-${componentType}-${variant || ""}`;
    if (!ouiaIdByRoute[key]) {
      ouiaIdByRoute[key] = 0;
    }
    return `${ouiaPrefix}${componentType}-${variant ? `${variant}-` : ""}${++ouiaIdByRoute[key]}`;
  } catch (exception) {
    return `${ouiaPrefix}${componentType}-${variant ? `${variant}-` : ""}${++uid}`;
  }
}
function capitalize2(input) {
  return input[0].toUpperCase() + input.substring(1);
}
function getUniqueId(prefix2 = "pf") {
  const uid2 = new Date().getTime() + Math.random().toString(36).slice(2);
  return `${prefix2}-${uid2}`;
}
function debounce(func, wait) {
  let timeout3;
  return (...args) => {
    clearTimeout(timeout3);
    timeout3 = setTimeout(() => func.apply(this, args), wait);
  };
}
function isElementInView(container, element, partial) {
  if (!container || !element) {
    return false;
  }
  const containerBounds = container.getBoundingClientRect();
  const elementBounds = element.getBoundingClientRect();
  const containerBoundsLeft = Math.floor(containerBounds.left);
  const containerBoundsRight = Math.floor(containerBounds.right);
  const elementBoundsLeft = Math.floor(elementBounds.left);
  const elementBoundsRight = Math.floor(elementBounds.right);
  const isTotallyInView = elementBoundsLeft >= containerBoundsLeft && elementBoundsRight <= containerBoundsRight;
  const isPartiallyInView = partial && (elementBoundsLeft < containerBoundsLeft && elementBoundsRight > containerBoundsLeft || elementBoundsRight > containerBoundsRight && elementBoundsLeft < containerBoundsRight);
  return isTotallyInView || isPartiallyInView;
}
function fillTemplate(templateString, templateVars) {
  return templateString.replace(/\${(.*?)}/g, (_23, match2) => templateVars[match2] || "");
}
function keyHandler(index3, innerIndex, position2, refsCollection, kids, custom = false) {
  if (!Array.isArray(kids)) {
    return;
  }
  const isMultiDimensional = refsCollection.filter((ref) => ref)[0].constructor === Array;
  let nextIndex = index3;
  let nextInnerIndex = innerIndex;
  if (position2 === "up") {
    if (index3 === 0) {
      nextIndex = kids.length - 1;
    } else {
      nextIndex = index3 - 1;
    }
  } else if (position2 === "down") {
    if (index3 === kids.length - 1) {
      nextIndex = 0;
    } else {
      nextIndex = index3 + 1;
    }
  } else if (position2 === "left") {
    if (innerIndex === 0) {
      nextInnerIndex = refsCollection[index3].length - 1;
    } else {
      nextInnerIndex = innerIndex - 1;
    }
  } else if (position2 === "right") {
    if (innerIndex === refsCollection[index3].length - 1) {
      nextInnerIndex = 0;
    } else {
      nextInnerIndex = innerIndex + 1;
    }
  }
  if (refsCollection[nextIndex] === null || refsCollection[nextIndex] === void 0 || isMultiDimensional && (refsCollection[nextIndex][nextInnerIndex] === null || refsCollection[nextIndex][nextInnerIndex] === void 0)) {
    keyHandler(nextIndex, nextInnerIndex, position2, refsCollection, kids, custom);
  } else if (custom) {
    if (refsCollection[nextIndex].focus) {
      refsCollection[nextIndex].focus();
    }
    const element = reactDom.findDOMNode(refsCollection[nextIndex]);
    element.focus();
  } else if (position2 !== "tab") {
    if (isMultiDimensional) {
      refsCollection[nextIndex][nextInnerIndex].focus();
    } else {
      refsCollection[nextIndex].focus();
    }
  }
}
function getNextIndex(index3, position2, collection) {
  let nextIndex;
  if (position2 === "up") {
    if (index3 === 0) {
      nextIndex = collection.length - 1;
    } else {
      nextIndex = index3 - 1;
    }
  } else if (index3 === collection.length - 1) {
    nextIndex = 0;
  } else {
    nextIndex = index3 + 1;
  }
  if (collection[nextIndex] === void 0 || collection[nextIndex][0] === null) {
    return getNextIndex(nextIndex, position2, collection);
  } else {
    return nextIndex;
  }
}
function pluralize(i3, singular, plural) {
  if (!plural) {
    plural = `${singular}s`;
  }
  return `${i3 || 0} ${i3 === 1 ? singular : plural}`;
}
var setBreakpointCssVars = (mods, cssVar) => Object.entries(mods || {}).reduce((acc, [breakpoint, value]) => breakpoint === "default" ? Object.assign(Object.assign({}, acc), {[cssVar]: value}) : Object.assign(Object.assign({}, acc), {[`${cssVar}-on-${breakpoint}`]: value}), {});
var formatBreakpointMods = (mods, styles6, stylePrefix = "") => Object.entries(mods || {}).map(([breakpoint, mod]) => `${stylePrefix}${mod}${breakpoint !== "default" ? `-on-${breakpoint}` : ""}`).map(toCamel).map((mod) => mod.replace(/-?(\dxl)/gi, (_res, group) => `_${group}`)).map((modifierKey) => styles6.modifiers[modifierKey]).filter(Boolean).join(" ");
var camelize = (s2) => s2.toUpperCase().replace("-", "").replace("_", "");
var toCamel = (s2) => s2.replace(/([-_][a-z])/gi, camelize);
var canUseDOM = !!(typeof window !== "undefined" && window.document && window.document.createElement);
var getTextWidth = (text, node) => {
  const computedStyle = getComputedStyle(node);
  const getFontFromComputedStyle = () => {
    let computedFont = "";
    const fontStretchLookupTable = {
      "50%": "ultra-condensed",
      "62.5%": "extra-condensed",
      "75%": "condensed",
      "87.5%": "semi-condensed",
      "100%": "normal",
      "112.5%": "semi-expanded",
      "125%": "expanded",
      "150%": "extra-expanded",
      "200%": "ultra-expanded"
    };
    let fontStretch;
    if (computedStyle.fontStretch in fontStretchLookupTable) {
      fontStretch = fontStretchLookupTable[computedStyle.fontStretch];
    } else {
      fontStretch = "normal";
    }
    computedFont = computedStyle.fontStyle + " " + computedStyle.fontVariant + " " + computedStyle.fontWeight + " " + fontStretch + " " + computedStyle.fontSize + "/" + computedStyle.lineHeight + " " + computedStyle.fontFamily;
    return computedFont;
  };
  const canvas = document.createElement("canvas");
  const context2 = canvas.getContext("2d");
  context2.font = computedStyle.font || getFontFromComputedStyle();
  return context2.measureText(text).width;
};
var innerDimensions = (node) => {
  const computedStyle = getComputedStyle(node);
  let width2 = node.clientWidth;
  let height = node.clientHeight;
  height -= parseFloat(computedStyle.paddingTop) + parseFloat(computedStyle.paddingBottom);
  width2 -= parseFloat(computedStyle.paddingLeft) + parseFloat(computedStyle.paddingRight);
  return {height, width: width2};
};
var trimLeft = (node, value) => {
  const availableWidth = innerDimensions(node).width;
  let newValue = value;
  if (getTextWidth(value, node) > availableWidth) {
    while (getTextWidth(`...${newValue}`, node) > availableWidth) {
      newValue = newValue.substring(1);
    }
    if (node.value) {
      node.value = `...${newValue}`;
    } else {
      node.innerText = `...${newValue}`;
    }
  } else {
    if (node.value) {
      node.value = value;
    } else {
      node.innerText = value;
    }
  }
};
var preventedEvents = (events) => events.reduce((handlers, eventToPrevent) => Object.assign(Object.assign({}, handlers), {[eventToPrevent]: (event) => {
  event.preventDefault();
}}), {});
var FindRefWrapper = class extends react.Component {
  componentDidMount() {
    const root4 = reactDom.findDOMNode(this);
    this.props.onFoundRef(root4);
  }
  render() {
    return this.props.children || null;
  }
};
FindRefWrapper.displayName = "FindRefWrapper";
function getBoundingClientRect(element) {
  const rect = element.getBoundingClientRect();
  return {
    width: rect.width,
    height: rect.height,
    top: rect.top,
    right: rect.right,
    bottom: rect.bottom,
    left: rect.left,
    x: rect.left,
    y: rect.top
  };
}
function getWindow(node) {
  if (node.toString() !== "[object Window]") {
    const ownerDocument = node.ownerDocument;
    return ownerDocument ? ownerDocument.defaultView : window;
  }
  return node;
}
function getWindowScroll(node) {
  const win = getWindow(node);
  const scrollLeft = win.pageXOffset;
  const scrollTop = win.pageYOffset;
  return {
    scrollLeft,
    scrollTop
  };
}
function isElement(node) {
  const OwnElement = getWindow(node).Element;
  return node instanceof OwnElement || node instanceof Element;
}
function isHTMLElement(node) {
  const OwnElement = getWindow(node).HTMLElement;
  return node instanceof OwnElement || node instanceof HTMLElement;
}
function getHTMLElementScroll(element) {
  return {
    scrollLeft: element.scrollLeft,
    scrollTop: element.scrollTop
  };
}
function getNodeScroll(node) {
  if (node === getWindow(node) || !isHTMLElement(node)) {
    return getWindowScroll(node);
  } else {
    return getHTMLElementScroll(node);
  }
}
function getNodeName(element) {
  return element ? (element.nodeName || "").toLowerCase() : null;
}
function getDocumentElement(element) {
  return (isElement(element) ? element.ownerDocument : element.document).documentElement;
}
function getWindowScrollBarX(element) {
  return getBoundingClientRect(getDocumentElement(element)).left + getWindowScroll(element).scrollLeft;
}
function getComputedStyle$1(element) {
  return getWindow(element).getComputedStyle(element);
}
function isScrollParent(element) {
  const {overflow, overflowX, overflowY} = getComputedStyle$1(element);
  return /auto|scroll|overlay|hidden/.test(overflow + overflowY + overflowX);
}
function getCompositeRect(elementOrVirtualElement, offsetParent2, isFixed = false) {
  const documentElement = getDocumentElement(offsetParent2);
  const rect = getBoundingClientRect(elementOrVirtualElement);
  const isOffsetParentAnElement = isHTMLElement(offsetParent2);
  let scroll = {scrollLeft: 0, scrollTop: 0};
  let offsets = {x: 0, y: 0};
  if (isOffsetParentAnElement || !isOffsetParentAnElement && !isFixed) {
    if (getNodeName(offsetParent2) !== "body" || isScrollParent(documentElement)) {
      scroll = getNodeScroll(offsetParent2);
    }
    if (isHTMLElement(offsetParent2)) {
      offsets = getBoundingClientRect(offsetParent2);
      offsets.x += offsetParent2.clientLeft;
      offsets.y += offsetParent2.clientTop;
    } else if (documentElement) {
      offsets.x = getWindowScrollBarX(documentElement);
    }
  }
  return {
    x: rect.left + scroll.scrollLeft - offsets.x,
    y: rect.top + scroll.scrollTop - offsets.y,
    width: rect.width,
    height: rect.height
  };
}
function getLayoutRect(element) {
  return {
    x: element.offsetLeft,
    y: element.offsetTop,
    width: element.offsetWidth,
    height: element.offsetHeight
  };
}
function getParentNode(element) {
  if (getNodeName(element) === "html") {
    return element;
  }
  return element.assignedSlot || element.parentNode || element.host || getDocumentElement(element);
}
function getScrollParent(node) {
  if (["html", "body", "#document"].indexOf(getNodeName(node)) >= 0) {
    return node.ownerDocument.body;
  }
  if (isHTMLElement(node) && isScrollParent(node)) {
    return node;
  }
  return getScrollParent(getParentNode(node));
}
function listScrollParents(element, list3 = []) {
  const scrollParent = getScrollParent(element);
  const isBody = getNodeName(scrollParent) === "body";
  const win = getWindow(scrollParent);
  const target = isBody ? [win].concat(win.visualViewport || [], isScrollParent(scrollParent) ? scrollParent : []) : scrollParent;
  const updatedList = list3.concat(target);
  return isBody ? updatedList : updatedList.concat(listScrollParents(getParentNode(target)));
}
function isTableElement(element) {
  return ["table", "td", "th"].indexOf(getNodeName(element)) >= 0;
}
function getTrueOffsetParent(element) {
  if (!isHTMLElement(element) || getComputedStyle$1(element).position === "fixed") {
    return null;
  }
  const offsetParent2 = element.offsetParent;
  if (offsetParent2) {
    const html = getDocumentElement(offsetParent2);
    if (getNodeName(offsetParent2) === "body" && getComputedStyle$1(offsetParent2).position === "static" && getComputedStyle$1(html).position !== "static") {
      return html;
    }
  }
  return offsetParent2;
}
function getContainingBlock(element) {
  let currentNode = getParentNode(element);
  while (isHTMLElement(currentNode) && ["html", "body"].indexOf(getNodeName(currentNode)) < 0) {
    const css2 = getComputedStyle$1(currentNode);
    if (css2.transform !== "none" || css2.perspective !== "none" || css2.willChange && css2.willChange !== "auto") {
      return currentNode;
    } else {
      currentNode = currentNode.parentNode;
    }
  }
  return null;
}
function getOffsetParent(element) {
  const window2 = getWindow(element);
  let offsetParent2 = getTrueOffsetParent(element);
  while (offsetParent2 && isTableElement(offsetParent2) && getComputedStyle$1(offsetParent2).position === "static") {
    offsetParent2 = getTrueOffsetParent(offsetParent2);
  }
  if (offsetParent2 && getNodeName(offsetParent2) === "body" && getComputedStyle$1(offsetParent2).position === "static") {
    return window2;
  }
  return offsetParent2 || getContainingBlock(element) || window2;
}
var top = "top";
var bottom = "bottom";
var right = "right";
var left = "left";
var auto = "auto";
var basePlacements = [top, bottom, right, left];
var start = "start";
var end = "end";
var clippingParents = "clippingParents";
var viewport = "viewport";
var popper = "popper";
var reference = "reference";
var variationPlacements = basePlacements.reduce((acc, placement) => acc.concat([`${placement}-${start}`, `${placement}-${end}`]), []);
var placements = [...basePlacements, auto].reduce((acc, placement) => acc.concat([placement, `${placement}-${start}`, `${placement}-${end}`]), []);
var beforeRead = "beforeRead";
var read = "read";
var afterRead = "afterRead";
var beforeMain = "beforeMain";
var main = "main";
var afterMain = "afterMain";
var beforeWrite = "beforeWrite";
var write = "write";
var afterWrite = "afterWrite";
var modifierPhases = [
  beforeRead,
  read,
  afterRead,
  beforeMain,
  main,
  afterMain,
  beforeWrite,
  write,
  afterWrite
];
function order(modifiers) {
  const map2 = new Map();
  const visited = new Set();
  const result = [];
  modifiers.forEach((modifier) => {
    map2.set(modifier.name, modifier);
  });
  function sort2(modifier) {
    visited.add(modifier.name);
    const requires = [...modifier.requires || [], ...modifier.requiresIfExists || []];
    requires.forEach((dep) => {
      if (!visited.has(dep)) {
        const depModifier = map2.get(dep);
        if (depModifier) {
          sort2(depModifier);
        }
      }
    });
    result.push(modifier);
  }
  modifiers.forEach((modifier) => {
    if (!visited.has(modifier.name)) {
      sort2(modifier);
    }
  });
  return result;
}
function orderModifiers(modifiers) {
  const orderedModifiers = order(modifiers);
  return modifierPhases.reduce((acc, phase) => acc.concat(orderedModifiers.filter((modifier) => modifier.phase === phase)), []);
}
function debounce$1(fn) {
  let pending;
  return () => {
    if (!pending) {
      pending = new Promise((resolve2) => {
        Promise.resolve().then(() => {
          pending = void 0;
          resolve2(fn());
        });
      });
    }
    return pending;
  };
}
function getBasePlacement(placement) {
  return placement.split("-")[0];
}
function mergeByName(modifiers) {
  const merged = modifiers.reduce((merged2, current) => {
    const existing = merged2[current.name];
    merged2[current.name] = existing ? Object.assign(Object.assign(Object.assign({}, existing), current), {options: Object.assign(Object.assign({}, existing.options), current.options), data: Object.assign(Object.assign({}, existing.data), current.data)}) : current;
    return merged2;
  }, {});
  return Object.keys(merged).map((key) => merged[key]);
}
function getViewportRect(element) {
  const win = getWindow(element);
  const html = getDocumentElement(element);
  const visualViewport = win.visualViewport;
  let width2 = html.clientWidth;
  let height = html.clientHeight;
  let x2 = 0;
  let y3 = 0;
  if (visualViewport) {
    width2 = visualViewport.width;
    height = visualViewport.height;
    if (!/^((?!chrome|android).)*safari/i.test(navigator.userAgent)) {
      x2 = visualViewport.offsetLeft;
      y3 = visualViewport.offsetTop;
    }
  }
  return {
    width: width2,
    height,
    x: x2 + getWindowScrollBarX(element),
    y: y3
  };
}
function getDocumentRect(element) {
  const html = getDocumentElement(element);
  const winScroll = getWindowScroll(element);
  const body = element.ownerDocument.body;
  const width2 = Math.max(html.scrollWidth, html.clientWidth, body ? body.scrollWidth : 0, body ? body.clientWidth : 0);
  const height = Math.max(html.scrollHeight, html.clientHeight, body ? body.scrollHeight : 0, body ? body.clientHeight : 0);
  let x2 = -winScroll.scrollLeft + getWindowScrollBarX(element);
  const y3 = -winScroll.scrollTop;
  if (getComputedStyle$1(body || html).direction === "rtl") {
    x2 += Math.max(html.clientWidth, body ? body.clientWidth : 0) - width2;
  }
  return {width: width2, height, x: x2, y: y3};
}
function contains(parent, child) {
  const isShadow = Boolean(child.getRootNode && child.getRootNode().host);
  if (parent.contains(child)) {
    return true;
  } else if (isShadow) {
    let next = child;
    do {
      if (next && parent.isSameNode(next)) {
        return true;
      }
      next = next.parentNode || next.host;
    } while (next);
  }
  return false;
}
function rectToClientRect(rect) {
  return Object.assign(Object.assign({}, rect), {left: rect.x, top: rect.y, right: rect.x + rect.width, bottom: rect.y + rect.height});
}
function getInnerBoundingClientRect(element) {
  const rect = getBoundingClientRect(element);
  rect.top = rect.top + element.clientTop;
  rect.left = rect.left + element.clientLeft;
  rect.bottom = rect.top + element.clientHeight;
  rect.right = rect.left + element.clientWidth;
  rect.width = element.clientWidth;
  rect.height = element.clientHeight;
  rect.x = rect.left;
  rect.y = rect.top;
  return rect;
}
function getClientRectFromMixedType(element, clippingParent) {
  return clippingParent === viewport ? rectToClientRect(getViewportRect(element)) : isHTMLElement(clippingParent) ? getInnerBoundingClientRect(clippingParent) : rectToClientRect(getDocumentRect(getDocumentElement(element)));
}
function getClippingParents(element) {
  const clippingParents2 = listScrollParents(getParentNode(element));
  const canEscapeClipping = ["absolute", "fixed"].indexOf(getComputedStyle$1(element).position) >= 0;
  const clipperElement = canEscapeClipping && isHTMLElement(element) ? getOffsetParent(element) : element;
  if (!isElement(clipperElement)) {
    return [];
  }
  return clippingParents2.filter((clippingParent) => isElement(clippingParent) && contains(clippingParent, clipperElement) && getNodeName(clippingParent) !== "body");
}
function getClippingRect(element, boundary, rootBoundary) {
  const mainClippingParents = boundary === "clippingParents" ? getClippingParents(element) : [].concat(boundary);
  const clippingParents2 = [...mainClippingParents, rootBoundary];
  const firstClippingParent = clippingParents2[0];
  const clippingRect = clippingParents2.reduce((accRect, clippingParent) => {
    const rect = getClientRectFromMixedType(element, clippingParent);
    accRect.top = Math.max(rect.top, accRect.top);
    accRect.right = Math.min(rect.right, accRect.right);
    accRect.bottom = Math.min(rect.bottom, accRect.bottom);
    accRect.left = Math.max(rect.left, accRect.left);
    return accRect;
  }, getClientRectFromMixedType(element, firstClippingParent));
  clippingRect.width = clippingRect.right - clippingRect.left;
  clippingRect.height = clippingRect.bottom - clippingRect.top;
  clippingRect.x = clippingRect.left;
  clippingRect.y = clippingRect.top;
  return clippingRect;
}
function getVariation(placement) {
  return placement.split("-")[1];
}
function getMainAxisFromPlacement(placement) {
  return ["top", "bottom"].indexOf(placement) >= 0 ? "x" : "y";
}
function computeOffsets({reference: reference2, element, placement}) {
  const basePlacement = placement ? getBasePlacement(placement) : null;
  const variation = placement ? getVariation(placement) : null;
  const commonX = reference2.x + reference2.width / 2 - element.width / 2;
  const commonY = reference2.y + reference2.height / 2 - element.height / 2;
  let offsets;
  switch (basePlacement) {
    case top:
      offsets = {
        x: commonX,
        y: reference2.y - element.height
      };
      break;
    case bottom:
      offsets = {
        x: commonX,
        y: reference2.y + reference2.height
      };
      break;
    case right:
      offsets = {
        x: reference2.x + reference2.width,
        y: commonY
      };
      break;
    case left:
      offsets = {
        x: reference2.x - element.width,
        y: commonY
      };
      break;
    default:
      offsets = {
        x: reference2.x,
        y: reference2.y
      };
  }
  const mainAxis = basePlacement ? getMainAxisFromPlacement(basePlacement) : null;
  if (mainAxis != null) {
    const len2 = mainAxis === "y" ? "height" : "width";
    switch (variation) {
      case start:
        offsets[mainAxis] = Math.floor(offsets[mainAxis]) - Math.floor(reference2[len2] / 2 - element[len2] / 2);
        break;
      case end:
        offsets[mainAxis] = Math.floor(offsets[mainAxis]) + Math.ceil(reference2[len2] / 2 - element[len2] / 2);
        break;
    }
  }
  return offsets;
}
function getFreshSideObject() {
  return {
    top: 0,
    right: 0,
    bottom: 0,
    left: 0
  };
}
function mergePaddingObject(paddingObject) {
  return Object.assign(Object.assign({}, getFreshSideObject()), paddingObject);
}
function expandToHashMap(value, keys2) {
  return keys2.reduce((hashMap, key) => {
    hashMap[key] = value;
    return hashMap;
  }, {});
}
function detectOverflow(state, options = {}) {
  const {placement = state.placement, boundary = clippingParents, rootBoundary = viewport, elementContext = popper, altBoundary = false, padding = 0} = options;
  const paddingObject = mergePaddingObject(typeof padding !== "number" ? padding : expandToHashMap(padding, basePlacements));
  const altContext = elementContext === popper ? reference : popper;
  const referenceElement = state.elements.reference;
  const popperRect = state.rects.popper;
  const element = state.elements[altBoundary ? altContext : elementContext];
  const clippingClientRect = getClippingRect(isElement(element) ? element : element.contextElement || getDocumentElement(state.elements.popper), boundary, rootBoundary);
  const referenceClientRect = getBoundingClientRect(referenceElement);
  const popperOffsets2 = computeOffsets({
    reference: referenceClientRect,
    element: popperRect,
    strategy: "absolute",
    placement
  });
  const popperClientRect = rectToClientRect(Object.assign(Object.assign({}, popperRect), popperOffsets2));
  const elementClientRect = elementContext === popper ? popperClientRect : referenceClientRect;
  const overflowOffsets = {
    top: clippingClientRect.top - elementClientRect.top + paddingObject.top,
    bottom: elementClientRect.bottom - clippingClientRect.bottom + paddingObject.bottom,
    left: clippingClientRect.left - elementClientRect.left + paddingObject.left,
    right: elementClientRect.right - clippingClientRect.right + paddingObject.right
  };
  const offsetData = state.modifiersData.offset;
  if (elementContext === popper && offsetData) {
    const offset2 = offsetData[placement];
    Object.keys(overflowOffsets).forEach((key) => {
      const multiply = [right, bottom].indexOf(key) >= 0 ? 1 : -1;
      const axis = [top, bottom].indexOf(key) >= 0 ? "y" : "x";
      overflowOffsets[key] += offset2[axis] * multiply;
    });
  }
  return overflowOffsets;
}
var DEFAULT_OPTIONS = {
  placement: "bottom",
  modifiers: [],
  strategy: "absolute"
};
function areValidElements(...args) {
  return !args.some((element) => !(element && typeof element.getBoundingClientRect === "function"));
}
function popperGenerator(generatorOptions = {}) {
  const {defaultModifiers: defaultModifiers2 = [], defaultOptions: defaultOptions3 = DEFAULT_OPTIONS} = generatorOptions;
  return function createPopper2(reference2, popper2, options = defaultOptions3) {
    let state = {
      placement: "bottom",
      orderedModifiers: [],
      options: Object.assign(Object.assign({}, DEFAULT_OPTIONS), defaultOptions3),
      modifiersData: {},
      elements: {
        reference: reference2,
        popper: popper2
      },
      attributes: {},
      styles: {}
    };
    let effectCleanupFns = [];
    let isDestroyed = false;
    const instance2 = {
      state,
      setOptions(options2) {
        cleanupModifierEffects();
        state.options = Object.assign(Object.assign(Object.assign({}, defaultOptions3), state.options), options2);
        state.scrollParents = {
          reference: isElement(reference2) ? listScrollParents(reference2) : reference2.contextElement ? listScrollParents(reference2.contextElement) : [],
          popper: listScrollParents(popper2)
        };
        const orderedModifiers = orderModifiers(mergeByName([...defaultModifiers2, ...state.options.modifiers]));
        state.orderedModifiers = orderedModifiers.filter((m2) => m2.enabled);
        runModifierEffects();
        return instance2.update();
      },
      forceUpdate() {
        if (isDestroyed) {
          return;
        }
        const {reference: reference3, popper: popper3} = state.elements;
        if (!areValidElements(reference3, popper3)) {
          return;
        }
        state.rects = {
          reference: getCompositeRect(reference3, getOffsetParent(popper3), state.options.strategy === "fixed"),
          popper: getLayoutRect(popper3)
        };
        state.reset = false;
        state.placement = state.options.placement;
        state.orderedModifiers.forEach((modifier) => state.modifiersData[modifier.name] = Object.assign({}, modifier.data));
        for (let index3 = 0; index3 < state.orderedModifiers.length; index3++) {
          if (state.reset === true) {
            state.reset = false;
            index3 = -1;
            continue;
          }
          const {fn, options: options2 = {}, name} = state.orderedModifiers[index3];
          if (typeof fn === "function") {
            state = fn({state, options: options2, name, instance: instance2}) || state;
          }
        }
      },
      update: debounce$1(() => new Promise((resolve2) => {
        instance2.forceUpdate();
        resolve2(state);
      })),
      destroy() {
        cleanupModifierEffects();
        isDestroyed = true;
      }
    };
    if (!areValidElements(reference2, popper2)) {
      return instance2;
    }
    instance2.setOptions(options).then((state2) => {
      if (!isDestroyed && options.onFirstUpdate) {
        options.onFirstUpdate(state2);
      }
    });
    function runModifierEffects() {
      state.orderedModifiers.forEach(({name, options: options2 = {}, effect: effect2}) => {
        if (typeof effect2 === "function") {
          const cleanupFn = effect2({state, name, instance: instance2, options: options2});
          const noopFn = () => {
          };
          effectCleanupFns.push(cleanupFn || noopFn);
        }
      });
    }
    function cleanupModifierEffects() {
      effectCleanupFns.forEach((fn) => fn());
      effectCleanupFns = [];
    }
    return instance2;
  };
}
var passive = {passive: true};
function effect({state, instance: instance2, options}) {
  const {scroll = true, resize = true} = options;
  const window2 = getWindow(state.elements.popper);
  const scrollParents = [...state.scrollParents.reference, ...state.scrollParents.popper];
  if (scroll) {
    scrollParents.forEach((scrollParent) => {
      scrollParent.addEventListener("scroll", instance2.update, passive);
    });
  }
  if (resize) {
    window2.addEventListener("resize", instance2.update, passive);
  }
  return () => {
    if (scroll) {
      scrollParents.forEach((scrollParent) => {
        scrollParent.removeEventListener("scroll", instance2.update, passive);
      });
    }
    if (resize) {
      window2.removeEventListener("resize", instance2.update, passive);
    }
  };
}
var eventListeners = {
  name: "eventListeners",
  enabled: true,
  phase: "write",
  fn: () => {
  },
  effect,
  data: {}
};
function popperOffsets({state, name}) {
  state.modifiersData[name] = computeOffsets({
    reference: state.rects.reference,
    element: state.rects.popper,
    strategy: "absolute",
    placement: state.placement
  });
}
var popperOffsets$1 = {
  name: "popperOffsets",
  enabled: true,
  phase: "read",
  fn: popperOffsets,
  data: {}
};
var unsetSides = {
  top: "auto",
  right: "auto",
  bottom: "auto",
  left: "auto"
};
function roundOffsets({x: x2, y: y3}) {
  const win = window;
  const dpr = win.devicePixelRatio || 1;
  return {
    x: Math.round(x2 * dpr) / dpr || 0,
    y: Math.round(y3 * dpr) / dpr || 0
  };
}
function mapToStyles({popper: popper2, popperRect, placement, offsets, position: position2, gpuAcceleration, adaptive}) {
  let {x: x2, y: y3} = roundOffsets(offsets);
  const hasX = offsets.hasOwnProperty("x");
  const hasY = offsets.hasOwnProperty("y");
  let sideX = left;
  let sideY = top;
  const win = window;
  if (adaptive) {
    let offsetParent2 = getOffsetParent(popper2);
    if (offsetParent2 === getWindow(popper2)) {
      offsetParent2 = getDocumentElement(popper2);
    }
    if (placement === top) {
      sideY = bottom;
      y3 -= offsetParent2.clientHeight - popperRect.height;
      y3 *= gpuAcceleration ? 1 : -1;
    }
    if (placement === left) {
      sideX = right;
      x2 -= offsetParent2.clientWidth - popperRect.width;
      x2 *= gpuAcceleration ? 1 : -1;
    }
  }
  const commonStyles = Object.assign({position: position2}, adaptive && unsetSides);
  if (gpuAcceleration) {
    return Object.assign(Object.assign({}, commonStyles), {
      [sideY]: hasY ? "0" : "",
      [sideX]: hasX ? "0" : "",
      transform: (win.devicePixelRatio || 1) < 2 ? `translate(${x2}px, ${y3}px)` : `translate3d(${x2}px, ${y3}px, 0)`
    });
  }
  return Object.assign(Object.assign({}, commonStyles), {[sideY]: hasY ? `${y3}px` : "", [sideX]: hasX ? `${x2}px` : "", transform: ""});
}
function computeStyles({state, options}) {
  const {gpuAcceleration = true, adaptive = true} = options;
  const commonStyles = {
    placement: getBasePlacement(state.placement),
    popper: state.elements.popper,
    popperRect: state.rects.popper,
    gpuAcceleration
  };
  if (state.modifiersData.popperOffsets != null) {
    state.styles.popper = Object.assign(Object.assign({}, state.styles.popper), mapToStyles(Object.assign(Object.assign({}, commonStyles), {offsets: state.modifiersData.popperOffsets, position: state.options.strategy, adaptive})));
  }
  if (state.modifiersData.arrow != null) {
    state.styles.arrow = Object.assign(Object.assign({}, state.styles.arrow), mapToStyles(Object.assign(Object.assign({}, commonStyles), {offsets: state.modifiersData.arrow, position: "absolute", adaptive: false})));
  }
  state.attributes.popper = Object.assign(Object.assign({}, state.attributes.popper), {"data-popper-placement": state.placement});
}
var computeStyles$1 = {
  name: "computeStyles",
  enabled: true,
  phase: "beforeWrite",
  fn: computeStyles,
  data: {}
};
function applyStyles({state}) {
  Object.keys(state.elements).forEach((name) => {
    const style = state.styles[name] || {};
    const attributes = state.attributes[name] || {};
    const element = state.elements[name];
    if (!isHTMLElement(element) || !getNodeName(element)) {
      return;
    }
    Object.assign(element.style, style);
    Object.keys(attributes).forEach((name2) => {
      const value = attributes[name2];
      if (value === false) {
        element.removeAttribute(name2);
      } else {
        element.setAttribute(name2, value === true ? "" : value);
      }
    });
  });
}
function effect$1({state}) {
  const initialStyles = {
    popper: {
      position: state.options.strategy,
      left: "0",
      top: "0",
      margin: "0"
    },
    arrow: {
      position: "absolute"
    },
    reference: {}
  };
  Object.assign(state.elements.popper.style, initialStyles.popper);
  if (state.elements.arrow) {
    Object.assign(state.elements.arrow.style, initialStyles.arrow);
  }
  return () => {
    Object.keys(state.elements).forEach((name) => {
      const element = state.elements[name];
      const attributes = state.attributes[name] || {};
      const styleProperties = Object.keys(state.styles.hasOwnProperty(name) ? state.styles[name] : initialStyles[name]);
      const style = styleProperties.reduce((style2, property2) => {
        style2[property2] = "";
        return style2;
      }, {});
      if (!isHTMLElement(element) || !getNodeName(element)) {
        return;
      }
      Object.assign(element.style, style);
      Object.keys(attributes).forEach((attribute) => {
        element.removeAttribute(attribute);
      });
    });
  };
}
var applyStyles$1 = {
  name: "applyStyles",
  enabled: true,
  phase: "write",
  fn: applyStyles,
  effect: effect$1,
  requires: ["computeStyles"]
};
function distanceAndSkiddingToXY(placement, rects, offset2) {
  const basePlacement = getBasePlacement(placement);
  const invertDistance = [left, top].indexOf(basePlacement) >= 0 ? -1 : 1;
  let [skidding, distance] = typeof offset2 === "function" ? offset2(Object.assign(Object.assign({}, rects), {placement})) : offset2;
  skidding = skidding || 0;
  distance = (distance || 0) * invertDistance;
  return [left, right].indexOf(basePlacement) >= 0 ? {x: distance, y: skidding} : {x: skidding, y: distance};
}
function offset({state, options, name}) {
  const {offset: offset2 = [0, 0]} = options;
  const data2 = placements.reduce((acc, placement) => {
    acc[placement] = distanceAndSkiddingToXY(placement, state.rects, offset2);
    return acc;
  }, {});
  const {x: x2, y: y3} = data2[state.placement];
  if (state.modifiersData.popperOffsets != null) {
    state.modifiersData.popperOffsets.x += x2;
    state.modifiersData.popperOffsets.y += y3;
  }
  state.modifiersData[name] = data2;
}
var offset$1 = {
  name: "offset",
  enabled: true,
  phase: "main",
  requires: ["popperOffsets"],
  fn: offset
};
var hash = {left: "right", right: "left", bottom: "top", top: "bottom"};
function getOppositePlacement(placement) {
  return placement.replace(/left|right|bottom|top/g, (matched) => hash[matched]);
}
var hash$1 = {start: "end", end: "start"};
function getOppositeVariationPlacement(placement) {
  return placement.replace(/start|end/g, (matched) => hash$1[matched]);
}
function computeAutoPlacement(state, options = {}) {
  const {placement, boundary, rootBoundary, padding, flipVariations, allowedAutoPlacements = placements} = options;
  const variation = getVariation(placement);
  const placements$1 = variation ? flipVariations ? variationPlacements : variationPlacements.filter((placement2) => getVariation(placement2) === variation) : basePlacements;
  let allowedPlacements = placements$1.filter((placement2) => allowedAutoPlacements.indexOf(placement2) >= 0);
  if (allowedPlacements.length === 0) {
    allowedPlacements = placements$1;
  }
  const overflows = allowedPlacements.reduce((acc, placement2) => {
    acc[placement2] = detectOverflow(state, {
      placement: placement2,
      boundary,
      rootBoundary,
      padding
    })[getBasePlacement(placement2)];
    return acc;
  }, {});
  return Object.keys(overflows).sort((a2, b2) => overflows[a2] - overflows[b2]);
}
function getExpandedFallbackPlacements(placement) {
  if (getBasePlacement(placement) === auto) {
    return [];
  }
  const oppositePlacement = getOppositePlacement(placement);
  return [
    getOppositeVariationPlacement(placement),
    oppositePlacement,
    getOppositeVariationPlacement(oppositePlacement)
  ];
}
function flip({state, options, name}) {
  if (state.modifiersData[name]._skip) {
    return;
  }
  const {mainAxis: checkMainAxis = true, altAxis: checkAltAxis = true, fallbackPlacements: specifiedFallbackPlacements, padding, boundary, rootBoundary, altBoundary, flipVariations = true, allowedAutoPlacements} = options;
  const preferredPlacement = state.options.placement;
  const basePlacement = getBasePlacement(preferredPlacement);
  const isBasePlacement = basePlacement === preferredPlacement;
  const fallbackPlacements = specifiedFallbackPlacements || (isBasePlacement || !flipVariations ? [getOppositePlacement(preferredPlacement)] : getExpandedFallbackPlacements(preferredPlacement));
  const placements2 = [preferredPlacement, ...fallbackPlacements].reduce((acc, placement) => acc.concat(getBasePlacement(placement) === auto ? computeAutoPlacement(state, {
    placement,
    boundary,
    rootBoundary,
    padding,
    flipVariations,
    allowedAutoPlacements
  }) : placement), []);
  const referenceRect = state.rects.reference;
  const popperRect = state.rects.popper;
  const checksMap = new Map();
  let makeFallbackChecks = true;
  let firstFittingPlacement = placements2[0];
  for (let i3 = 0; i3 < placements2.length; i3++) {
    const placement = placements2[i3];
    const basePlacement2 = getBasePlacement(placement);
    const isStartVariation = getVariation(placement) === start;
    const isVertical = [top, bottom].indexOf(basePlacement2) >= 0;
    const len2 = isVertical ? "width" : "height";
    const overflow = detectOverflow(state, {
      placement,
      boundary,
      rootBoundary,
      altBoundary,
      padding
    });
    let mainVariationSide = isVertical ? isStartVariation ? right : left : isStartVariation ? bottom : top;
    if (referenceRect[len2] > popperRect[len2]) {
      mainVariationSide = getOppositePlacement(mainVariationSide);
    }
    const altVariationSide = getOppositePlacement(mainVariationSide);
    const checks = [];
    if (checkMainAxis) {
      checks.push(overflow[basePlacement2] <= 0);
    }
    if (checkAltAxis) {
      checks.push(overflow[mainVariationSide] <= 0, overflow[altVariationSide] <= 0);
    }
    if (checks.every((check2) => check2)) {
      firstFittingPlacement = placement;
      makeFallbackChecks = false;
      break;
    }
    checksMap.set(placement, checks);
  }
  if (makeFallbackChecks) {
    const numberOfChecks = flipVariations ? 3 : 1;
    for (let i3 = numberOfChecks; i3 > 0; i3--) {
      const fittingPlacement = placements2.find((placement) => {
        const checks = checksMap.get(placement);
        if (checks) {
          return checks.slice(0, i3).every((check2) => check2);
        }
      });
      if (fittingPlacement) {
        firstFittingPlacement = fittingPlacement;
        break;
      }
    }
  }
  if (state.placement !== firstFittingPlacement) {
    state.modifiersData[name]._skip = true;
    state.placement = firstFittingPlacement;
    state.reset = true;
  }
}
var flip$1 = {
  name: "flip",
  enabled: true,
  phase: "main",
  fn: flip,
  requiresIfExists: ["offset"],
  data: {_skip: false}
};
function getAltAxis(axis) {
  return axis === "x" ? "y" : "x";
}
function within(min2, value, max2) {
  return Math.max(min2, Math.min(value, max2));
}
function preventOverflow({state, options, name}) {
  const {mainAxis: checkMainAxis = true, altAxis: checkAltAxis = false, boundary, rootBoundary, altBoundary, padding, tether = true, tetherOffset = 0} = options;
  const overflow = detectOverflow(state, {
    boundary,
    rootBoundary,
    padding,
    altBoundary
  });
  const basePlacement = getBasePlacement(state.placement);
  const variation = getVariation(state.placement);
  const isBasePlacement = !variation;
  const mainAxis = getMainAxisFromPlacement(basePlacement);
  const altAxis = getAltAxis(mainAxis);
  const popperOffsets2 = state.modifiersData.popperOffsets;
  const referenceRect = state.rects.reference;
  const popperRect = state.rects.popper;
  const tetherOffsetValue = typeof tetherOffset === "function" ? tetherOffset(Object.assign(Object.assign({}, state.rects), {placement: state.placement})) : tetherOffset;
  const data2 = {x: 0, y: 0};
  if (!popperOffsets2) {
    return;
  }
  if (checkMainAxis) {
    const mainSide = mainAxis === "y" ? top : left;
    const altSide = mainAxis === "y" ? bottom : right;
    const len2 = mainAxis === "y" ? "height" : "width";
    const offset2 = popperOffsets2[mainAxis];
    const min2 = popperOffsets2[mainAxis] + overflow[mainSide];
    const max2 = popperOffsets2[mainAxis] - overflow[altSide];
    const additive = tether ? -popperRect[len2] / 2 : 0;
    const minLen = variation === start ? referenceRect[len2] : popperRect[len2];
    const maxLen = variation === start ? -popperRect[len2] : -referenceRect[len2];
    const arrowElement = state.elements.arrow;
    const arrowRect = tether && arrowElement ? getLayoutRect(arrowElement) : {width: 0, height: 0};
    const arrowPaddingObject = state.modifiersData["arrow#persistent"] ? state.modifiersData["arrow#persistent"].padding : getFreshSideObject();
    const arrowPaddingMin = arrowPaddingObject[mainSide];
    const arrowPaddingMax = arrowPaddingObject[altSide];
    const arrowLen = within(0, referenceRect[len2], arrowRect[len2]);
    const minOffset = isBasePlacement ? referenceRect[len2] / 2 - additive - arrowLen - arrowPaddingMin - tetherOffsetValue : minLen - arrowLen - arrowPaddingMin - tetherOffsetValue;
    const maxOffset = isBasePlacement ? -referenceRect[len2] / 2 + additive + arrowLen + arrowPaddingMax + tetherOffsetValue : maxLen + arrowLen + arrowPaddingMax + tetherOffsetValue;
    const arrowOffsetParent = state.elements.arrow && getOffsetParent(state.elements.arrow);
    const clientOffset = arrowOffsetParent ? mainAxis === "y" ? arrowOffsetParent.clientTop || 0 : arrowOffsetParent.clientLeft || 0 : 0;
    const offsetModifierValue = state.modifiersData.offset ? state.modifiersData.offset[state.placement][mainAxis] : 0;
    const tetherMin = popperOffsets2[mainAxis] + minOffset - offsetModifierValue - clientOffset;
    const tetherMax = popperOffsets2[mainAxis] + maxOffset - offsetModifierValue;
    const preventedOffset = within(tether ? Math.min(min2, tetherMin) : min2, offset2, tether ? Math.max(max2, tetherMax) : max2);
    popperOffsets2[mainAxis] = preventedOffset;
    data2[mainAxis] = preventedOffset - offset2;
  }
  if (checkAltAxis) {
    const mainSide = mainAxis === "x" ? top : left;
    const altSide = mainAxis === "x" ? bottom : right;
    const offset2 = popperOffsets2[altAxis];
    const min2 = offset2 + overflow[mainSide];
    const max2 = offset2 - overflow[altSide];
    const preventedOffset = within(min2, offset2, max2);
    popperOffsets2[altAxis] = preventedOffset;
    data2[altAxis] = preventedOffset - offset2;
  }
  state.modifiersData[name] = data2;
}
var preventOverflow$1 = {
  name: "preventOverflow",
  enabled: true,
  phase: "main",
  fn: preventOverflow,
  requiresIfExists: ["offset"]
};
function arrow({state, name}) {
  const arrowElement = state.elements.arrow;
  const popperOffsets2 = state.modifiersData.popperOffsets;
  const basePlacement = getBasePlacement(state.placement);
  const axis = getMainAxisFromPlacement(basePlacement);
  const isVertical = [left, right].indexOf(basePlacement) >= 0;
  const len2 = isVertical ? "height" : "width";
  if (!arrowElement || !popperOffsets2) {
    return;
  }
  const paddingObject = state.modifiersData[`${name}#persistent`].padding;
  const arrowRect = getLayoutRect(arrowElement);
  const minProp = axis === "y" ? top : left;
  const maxProp = axis === "y" ? bottom : right;
  const endDiff = state.rects.reference[len2] + state.rects.reference[axis] - popperOffsets2[axis] - state.rects.popper[len2];
  const startDiff = popperOffsets2[axis] - state.rects.reference[axis];
  const arrowOffsetParent = getOffsetParent(arrowElement);
  const clientSize = arrowOffsetParent ? axis === "y" ? arrowOffsetParent.clientHeight || 0 : arrowOffsetParent.clientWidth || 0 : 0;
  const centerToReference = endDiff / 2 - startDiff / 2;
  const min2 = paddingObject[minProp];
  const max2 = clientSize - arrowRect[len2] - paddingObject[maxProp];
  const center = clientSize / 2 - arrowRect[len2] / 2 + centerToReference;
  const offset2 = within(min2, center, max2);
  const axisProp = axis;
  state.modifiersData[name] = {
    [axisProp]: offset2,
    centerOffset: offset2 - center
  };
}
function effect$2({state, options, name}) {
  let {element: arrowElement = "[data-popper-arrow]", padding = 0} = options;
  if (arrowElement == null) {
    return;
  }
  if (typeof arrowElement === "string") {
    arrowElement = state.elements.popper.querySelector(arrowElement);
    if (!arrowElement) {
      return;
    }
  }
  if (!contains(state.elements.popper, arrowElement)) {
    return;
  }
  state.elements.arrow = arrowElement;
  state.modifiersData[`${name}#persistent`] = {
    padding: mergePaddingObject(typeof padding !== "number" ? padding : expandToHashMap(padding, basePlacements))
  };
}
var arrow$1 = {
  name: "arrow",
  enabled: true,
  phase: "main",
  fn: arrow,
  effect: effect$2,
  requires: ["popperOffsets"],
  requiresIfExists: ["preventOverflow"]
};
function getSideOffsets(overflow, rect, preventedOffsets = {x: 0, y: 0}) {
  return {
    top: overflow.top - rect.height - preventedOffsets.y,
    right: overflow.right - rect.width + preventedOffsets.x,
    bottom: overflow.bottom - rect.height + preventedOffsets.y,
    left: overflow.left - rect.width - preventedOffsets.x
  };
}
function isAnySideFullyClipped(overflow) {
  return [top, right, bottom, left].some((side) => overflow[side] >= 0);
}
function hide({state, name}) {
  const referenceRect = state.rects.reference;
  const popperRect = state.rects.popper;
  const preventedOffsets = state.modifiersData.preventOverflow;
  const referenceOverflow = detectOverflow(state, {
    elementContext: "reference"
  });
  const popperAltOverflow = detectOverflow(state, {
    altBoundary: true
  });
  const referenceClippingOffsets = getSideOffsets(referenceOverflow, referenceRect);
  const popperEscapeOffsets = getSideOffsets(popperAltOverflow, popperRect, preventedOffsets);
  const isReferenceHidden = isAnySideFullyClipped(referenceClippingOffsets);
  const hasPopperEscaped = isAnySideFullyClipped(popperEscapeOffsets);
  state.modifiersData[name] = {
    referenceClippingOffsets,
    popperEscapeOffsets,
    isReferenceHidden,
    hasPopperEscaped
  };
  state.attributes.popper = Object.assign(Object.assign({}, state.attributes.popper), {"data-popper-reference-hidden": isReferenceHidden, "data-popper-escaped": hasPopperEscaped});
}
var hide$1 = {
  name: "hide",
  enabled: true,
  phase: "main",
  requiresIfExists: ["preventOverflow"],
  fn: hide
};
var defaultModifiers = [
  eventListeners,
  popperOffsets$1,
  computeStyles$1,
  applyStyles$1,
  offset$1,
  flip$1,
  preventOverflow$1,
  arrow$1,
  hide$1
];
var createPopper = popperGenerator({defaultModifiers});
var useIsomorphicLayoutEffect = canUseDOM ? react.useLayoutEffect : react.useEffect;
var isEqual = (a2, b2) => JSON.stringify(a2) === JSON.stringify(b2);
var fromEntries = (entries) => entries.reduce((acc, [key, value]) => {
  acc[key] = value;
  return acc;
}, {});
var EMPTY_MODIFIERS = [];
var usePopper = (referenceElement, popperElement, options = {}) => {
  const prevOptions = react.useRef(null);
  const optionsWithDefaults = {
    onFirstUpdate: options.onFirstUpdate,
    placement: options.placement || "bottom",
    strategy: options.strategy || "absolute",
    modifiers: options.modifiers || EMPTY_MODIFIERS
  };
  const [state, setState] = react.useState({
    styles: {
      popper: {
        position: optionsWithDefaults.strategy,
        left: "0",
        top: "0"
      }
    },
    attributes: {}
  });
  const updateStateModifier = react.useMemo(() => ({
    name: "updateState",
    enabled: true,
    phase: "write",
    fn: ({state: state2}) => {
      const elements = Object.keys(state2.elements);
      setState({
        styles: fromEntries(elements.map((element) => [element, state2.styles[element] || {}])),
        attributes: fromEntries(elements.map((element) => [element, state2.attributes[element]]))
      });
    },
    requires: ["computeStyles"]
  }), []);
  const popperOptions = react.useMemo(() => {
    const newOptions = {
      onFirstUpdate: optionsWithDefaults.onFirstUpdate,
      placement: optionsWithDefaults.placement,
      strategy: optionsWithDefaults.strategy,
      modifiers: [...optionsWithDefaults.modifiers, updateStateModifier, {name: "applyStyles", enabled: false}]
    };
    if (isEqual(prevOptions.current, newOptions)) {
      return prevOptions.current || newOptions;
    } else {
      prevOptions.current = newOptions;
      return newOptions;
    }
  }, [
    optionsWithDefaults.onFirstUpdate,
    optionsWithDefaults.placement,
    optionsWithDefaults.strategy,
    optionsWithDefaults.modifiers,
    updateStateModifier
  ]);
  const popperInstanceRef = react.useRef();
  useIsomorphicLayoutEffect(() => {
    if (popperInstanceRef && popperInstanceRef.current) {
      popperInstanceRef.current.setOptions(popperOptions);
    }
  }, [popperOptions]);
  useIsomorphicLayoutEffect(() => {
    if (referenceElement == null || popperElement == null) {
      return;
    }
    const createPopper$1 = options.createPopper || createPopper;
    const popperInstance = createPopper$1(referenceElement, popperElement, popperOptions);
    popperInstanceRef.current = popperInstance;
    return () => {
      popperInstance.destroy();
      popperInstanceRef.current = null;
    };
  }, [referenceElement, popperElement, options.createPopper]);
  return {
    state: popperInstanceRef.current ? popperInstanceRef.current.state : null,
    styles: state.styles,
    attributes: state.attributes,
    update: popperInstanceRef.current ? popperInstanceRef.current.update : null,
    forceUpdate: popperInstanceRef.current ? popperInstanceRef.current.forceUpdate : null
  };
};
var hash$2 = {left: "right", right: "left", bottom: "top", top: "bottom"};
var getOppositePlacement$1 = (placement) => placement.replace(/left|right|bottom|top/g, (matched) => hash$2[matched]);
var getOpacityTransition = (animationDuration) => `opacity ${animationDuration}ms cubic-bezier(.54, 1.5, .38, 1.11)`;
var Popper = ({trigger, popper: popper2, popperMatchesTriggerWidth = true, direction = "down", position: position2 = "left", placement, appendTo = () => document.body, zIndex = 9999, isVisible = true, positionModifiers, distance = 0, onMouseEnter, onMouseLeave, onFocus, onBlur, onDocumentClick, onTriggerClick, onTriggerEnter, onPopperClick, onDocumentKeyDown, enableFlip = true, flipBehavior = "flip", reference: reference2}) => {
  const [triggerElement, setTriggerElement] = react.useState(null);
  const [refElement, setRefElement] = react.useState(null);
  const [popperElement, setPopperElement] = react.useState(null);
  const [ready, setReady] = react.useState(false);
  const refOrTrigger = refElement || triggerElement;
  const onDocumentClickCallback = react.useCallback((event) => onDocumentClick(event, refOrTrigger, popperElement), [
    isVisible,
    triggerElement,
    refElement,
    popperElement,
    onDocumentClick
  ]);
  react.useEffect(() => {
    setReady(true);
  }, []);
  react.useEffect(() => {
    if (reference2) {
      if (reference2.current) {
        setRefElement(reference2.current);
      } else if (typeof reference2 === "function") {
        setRefElement(reference2());
      }
    }
  }, [reference2]);
  const addEventListener = (listener, element, event) => {
    if (listener && element) {
      element.addEventListener(event, listener);
    }
  };
  const removeEventListener = (listener, element, event) => {
    if (listener && element) {
      element.removeEventListener(event, listener);
    }
  };
  react.useEffect(() => {
    addEventListener(onMouseEnter, refOrTrigger, "mouseenter");
    addEventListener(onMouseLeave, refOrTrigger, "mouseleave");
    addEventListener(onFocus, refOrTrigger, "focus");
    addEventListener(onBlur, refOrTrigger, "blur");
    addEventListener(onTriggerClick, refOrTrigger, "click");
    addEventListener(onTriggerEnter, refOrTrigger, "keydown");
    addEventListener(onPopperClick, popperElement, "click");
    onDocumentClick && addEventListener(onDocumentClickCallback, document, "click");
    addEventListener(onDocumentKeyDown, document, "keydown");
    return () => {
      removeEventListener(onMouseEnter, refOrTrigger, "mouseenter");
      removeEventListener(onMouseLeave, refOrTrigger, "mouseleave");
      removeEventListener(onFocus, refOrTrigger, "focus");
      removeEventListener(onBlur, refOrTrigger, "blur");
      removeEventListener(onTriggerClick, refOrTrigger, "click");
      removeEventListener(onTriggerEnter, refOrTrigger, "keydown");
      removeEventListener(onPopperClick, popperElement, "click");
      onDocumentClick && removeEventListener(onDocumentClickCallback, document, "click");
      removeEventListener(onDocumentKeyDown, document, "keydown");
    };
  }, [
    triggerElement,
    popperElement,
    onMouseEnter,
    onMouseLeave,
    onFocus,
    onBlur,
    onTriggerClick,
    onTriggerEnter,
    onPopperClick,
    onDocumentClick,
    onDocumentKeyDown,
    refElement
  ]);
  const getPlacement = () => {
    if (placement) {
      return placement;
    }
    let convertedPlacement = direction === "up" ? "top" : "bottom";
    if (position2 !== "center") {
      convertedPlacement = `${convertedPlacement}-${position2 === "right" ? "end" : "start"}`;
    }
    return convertedPlacement;
  };
  const getPlacementMemo = react.useMemo(getPlacement, [direction, position2, placement]);
  const getOppositePlacementMemo = react.useMemo(() => getOppositePlacement$1(getPlacement()), [
    direction,
    position2,
    placement
  ]);
  const sameWidthMod = react.useMemo(() => ({
    name: "sameWidth",
    enabled: popperMatchesTriggerWidth,
    phase: "beforeWrite",
    requires: ["computeStyles"],
    fn: ({state}) => {
      state.styles.popper.width = `${state.rects.reference.width}px`;
    },
    effect: ({state}) => {
      state.elements.popper.style.width = `${state.elements.reference.offsetWidth}px`;
      return () => {
      };
    }
  }), [popperMatchesTriggerWidth]);
  const {styles: popperStyles, attributes, forceUpdate} = usePopper(refOrTrigger, popperElement, {
    placement: getPlacementMemo,
    modifiers: [
      {
        name: "offset",
        options: {
          offset: [0, distance]
        }
      },
      {
        name: "preventOverflow",
        enabled: false
      },
      {
        name: "hide",
        enabled: true
      },
      {
        name: "flip",
        enabled: getPlacementMemo.startsWith("auto") || enableFlip,
        options: {
          fallbackPlacements: flipBehavior === "flip" ? [getOppositePlacementMemo] : flipBehavior
        }
      },
      sameWidthMod
    ]
  });
  react.useEffect(() => {
    forceUpdate && forceUpdate();
  }, [popper2]);
  const modifierFromPopperPosition = () => {
    if (attributes && attributes.popper && attributes.popper["data-popper-placement"]) {
      const popperPlacement = attributes.popper["data-popper-placement"];
      return positionModifiers[popperPlacement];
    }
    return positionModifiers.top;
  };
  const menuWithPopper = react.cloneElement(popper2, Object.assign({className: css(popper2.props && popper2.props.className, positionModifiers && modifierFromPopperPosition()), style: Object.assign(Object.assign(Object.assign({}, popper2.props && popper2.props.style || {}), popperStyles.popper), {zIndex})}, attributes.popper));
  const getTarget = () => {
    if (typeof appendTo === "function") {
      return appendTo();
    }
    return appendTo;
  };
  return react.createElement(react.Fragment, null, !reference2 && trigger && react.createElement(FindRefWrapper, {onFoundRef: (foundRef) => setTriggerElement(foundRef)}, trigger), ready && isVisible && reactDom.createPortal(react.createElement(FindRefWrapper, {onFoundRef: (foundRef) => setPopperElement(foundRef)}, menuWithPopper), getTarget()));
};
Popper.displayName = "Popper";
var title = createCommonjsModule(function(module2, exports2) {
  exports2.__esModule = true;
  exports2.default = {
    modifiers: {
      "4xl": "pf-m-4xl",
      "3xl": "pf-m-3xl",
      "2xl": "pf-m-2xl",
      xl: "pf-m-xl",
      lg: "pf-m-lg",
      md: "pf-m-md",
      overpassFont: "pf-m-overpass-font"
    },
    title: "pf-c-title"
  };
});
var styles = /* @__PURE__ */ getDefaultExportFromCjs(title);
var TitleSizes;
(function(TitleSizes2) {
  TitleSizes2["md"] = "md";
  TitleSizes2["lg"] = "lg";
  TitleSizes2["xl"] = "xl";
  TitleSizes2["2xl"] = "2xl";
  TitleSizes2["3xl"] = "3xl";
  TitleSizes2["4xl"] = "4xl";
})(TitleSizes || (TitleSizes = {}));
var headingLevelSizeMap;
(function(headingLevelSizeMap2) {
  headingLevelSizeMap2["h1"] = "2xl";
  headingLevelSizeMap2["h2"] = "xl";
  headingLevelSizeMap2["h3"] = "lg";
  headingLevelSizeMap2["h4"] = "md";
  headingLevelSizeMap2["h5"] = "md";
  headingLevelSizeMap2["h6"] = "md";
})(headingLevelSizeMap || (headingLevelSizeMap = {}));
var Title = (_a) => {
  var {className = "", children: children2 = "", headingLevel: HeadingLevel, size: size2 = headingLevelSizeMap[HeadingLevel], ouiaId, ouiaSafe = true} = _a, props = __rest(_a, ["className", "children", "headingLevel", "size", "ouiaId", "ouiaSafe"]);
  const ouiaProps = useOUIAProps(Title.displayName, ouiaId, ouiaSafe);
  return react.createElement(HeadingLevel, Object.assign({}, ouiaProps, props, {className: css(styles.title, size2 && styles.modifiers[size2], className)}), children2);
};
Title.displayName = "Title";
var button = createCommonjsModule(function(module2, exports2) {
  exports2.__esModule = true;
  exports2.default = {
    button: "pf-c-button",
    buttonIcon: "pf-c-button__icon",
    buttonProgress: "pf-c-button__progress",
    modifiers: {
      active: "pf-m-active",
      block: "pf-m-block",
      small: "pf-m-small",
      primary: "pf-m-primary",
      displayLg: "pf-m-display-lg",
      secondary: "pf-m-secondary",
      tertiary: "pf-m-tertiary",
      link: "pf-m-link",
      inline: "pf-m-inline",
      danger: "pf-m-danger",
      warning: "pf-m-warning",
      control: "pf-m-control",
      expanded: "pf-m-expanded",
      plain: "pf-m-plain",
      disabled: "pf-m-disabled",
      ariaDisabled: "pf-m-aria-disabled",
      progress: "pf-m-progress",
      inProgress: "pf-m-in-progress",
      start: "pf-m-start",
      end: "pf-m-end",
      overpassFont: "pf-m-overpass-font"
    },
    spinner: "pf-c-spinner"
  };
});
var buttonStyles = /* @__PURE__ */ getDefaultExportFromCjs(button);
var spinner = createCommonjsModule(function(module2, exports2) {
  exports2.__esModule = true;
  exports2.default = {
    modifiers: {
      sm: "pf-m-sm",
      md: "pf-m-md",
      lg: "pf-m-lg",
      xl: "pf-m-xl"
    },
    spinner: "pf-c-spinner",
    spinnerClipper: "pf-c-spinner__clipper",
    spinnerLeadBall: "pf-c-spinner__lead-ball",
    spinnerPath: "pf-c-spinner__path",
    spinnerTailBall: "pf-c-spinner__tail-ball"
  };
});
var styles$1 = /* @__PURE__ */ getDefaultExportFromCjs(spinner);
var spinnerSize;
(function(spinnerSize2) {
  spinnerSize2["sm"] = "sm";
  spinnerSize2["md"] = "md";
  spinnerSize2["lg"] = "lg";
  spinnerSize2["xl"] = "xl";
})(spinnerSize || (spinnerSize = {}));
var Spinner = (_a) => {
  var {
    className = "",
    size: size2 = "xl",
    "aria-valuetext": ariaValueText = "Loading...",
    isSVG = false,
    diameter
  } = _a, props = __rest(_a, ["className", "size", "aria-valuetext", "isSVG", "diameter"]);
  const Component = isSVG ? "svg" : "span";
  return react.createElement(Component, Object.assign({className: css(styles$1.spinner, styles$1.modifiers[size2], className), role: "progressbar", "aria-valuetext": ariaValueText}, isSVG && {viewBox: "0 0 100 100"}, diameter && {style: {"--pf-c-spinner--diameter": diameter}}, props), isSVG ? react.createElement("circle", {className: styles$1.spinnerPath, cx: "50", cy: "50", r: "45", fill: "none"}) : react.createElement(react.Fragment, null, react.createElement("span", {className: css(styles$1.spinnerClipper)}), react.createElement("span", {className: css(styles$1.spinnerLeadBall)}), react.createElement("span", {className: css(styles$1.spinnerTailBall)})));
};
Spinner.displayName = "Spinner";
var ButtonVariant;
(function(ButtonVariant2) {
  ButtonVariant2["primary"] = "primary";
  ButtonVariant2["secondary"] = "secondary";
  ButtonVariant2["tertiary"] = "tertiary";
  ButtonVariant2["danger"] = "danger";
  ButtonVariant2["warning"] = "warning";
  ButtonVariant2["link"] = "link";
  ButtonVariant2["plain"] = "plain";
  ButtonVariant2["control"] = "control";
})(ButtonVariant || (ButtonVariant = {}));
var ButtonType;
(function(ButtonType2) {
  ButtonType2["button"] = "button";
  ButtonType2["submit"] = "submit";
  ButtonType2["reset"] = "reset";
})(ButtonType || (ButtonType = {}));
var ButtonBase = (_a) => {
  var {children: children2 = null, className = "", component = "button", isActive = false, isBlock = false, isDisabled = false, isAriaDisabled = false, isLoading = null, isDanger = false, spinnerAriaValueText, isSmall = false, isLarge = false, inoperableEvents = ["onClick", "onKeyPress"], isInline = false, type = ButtonType.button, variant = ButtonVariant.primary, iconPosition = "left", "aria-label": ariaLabel = null, icon = null, ouiaId, ouiaSafe = true, tabIndex = null, innerRef} = _a, props = __rest(_a, ["children", "className", "component", "isActive", "isBlock", "isDisabled", "isAriaDisabled", "isLoading", "isDanger", "spinnerAriaValueText", "isSmall", "isLarge", "inoperableEvents", "isInline", "type", "variant", "iconPosition", "aria-label", "icon", "ouiaId", "ouiaSafe", "tabIndex", "innerRef"]);
  const ouiaProps = useOUIAProps(Button.displayName, ouiaId, ouiaSafe, variant);
  const Component = component;
  const isButtonElement = Component === "button";
  const isInlineSpan = isInline && Component === "span";
  const preventedEvents2 = inoperableEvents.reduce((handlers, eventToPrevent) => Object.assign(Object.assign({}, handlers), {[eventToPrevent]: (event) => {
    event.preventDefault();
  }}), {});
  const getDefaultTabIdx = () => {
    if (isDisabled) {
      return isButtonElement ? null : -1;
    } else if (isAriaDisabled) {
      return null;
    } else if (isInlineSpan) {
      return 0;
    }
  };
  return react.createElement(Component, Object.assign({}, props, isAriaDisabled ? preventedEvents2 : null, {"aria-disabled": isDisabled || isAriaDisabled, "aria-label": ariaLabel, className: css(buttonStyles.button, buttonStyles.modifiers[variant], isBlock && buttonStyles.modifiers.block, isDisabled && buttonStyles.modifiers.disabled, isAriaDisabled && buttonStyles.modifiers.ariaDisabled, isActive && buttonStyles.modifiers.active, isInline && variant === ButtonVariant.link && buttonStyles.modifiers.inline, isDanger && (variant === ButtonVariant.secondary || variant === ButtonVariant.link) && buttonStyles.modifiers.danger, isLoading !== null && buttonStyles.modifiers.progress, isLoading && buttonStyles.modifiers.inProgress, isSmall && buttonStyles.modifiers.small, isLarge && buttonStyles.modifiers.displayLg, className), disabled: isButtonElement ? isDisabled : null, tabIndex: tabIndex !== null ? tabIndex : getDefaultTabIdx(), type: isButtonElement || isInlineSpan ? type : null, role: isInlineSpan ? "button" : null, ref: innerRef}, ouiaProps), isLoading && react.createElement("span", {className: css(buttonStyles.buttonProgress)}, react.createElement(Spinner, {size: spinnerSize.md, "aria-valuetext": spinnerAriaValueText})), variant !== ButtonVariant.plain && icon && iconPosition === "left" && react.createElement("span", {className: css(buttonStyles.buttonIcon, buttonStyles.modifiers.start)}, icon), children2, variant !== ButtonVariant.plain && icon && iconPosition === "right" && react.createElement("span", {className: css(buttonStyles.buttonIcon, buttonStyles.modifiers.end)}, icon));
};
var Button = react.forwardRef((props, ref) => react.createElement(ButtonBase, Object.assign({innerRef: ref}, props)));
Button.displayName = "Button";
var tooltip = createCommonjsModule(function(module2, exports2) {
  exports2.__esModule = true;
  exports2.default = {
    modifiers: {
      top: "pf-m-top",
      topLeft: "pf-m-top-left",
      topRight: "pf-m-top-right",
      bottom: "pf-m-bottom",
      bottomLeft: "pf-m-bottom-left",
      bottomRight: "pf-m-bottom-right",
      left: "pf-m-left",
      leftTop: "pf-m-left-top",
      leftBottom: "pf-m-left-bottom",
      right: "pf-m-right",
      rightTop: "pf-m-right-top",
      rightBottom: "pf-m-right-bottom",
      textAlignLeft: "pf-m-text-align-left"
    },
    tooltip: "pf-c-tooltip",
    tooltipArrow: "pf-c-tooltip__arrow",
    tooltipContent: "pf-c-tooltip__content"
  };
});
var styles$2 = /* @__PURE__ */ getDefaultExportFromCjs(tooltip);
var TooltipContent = (_a) => {
  var {className, children: children2, isLeftAligned} = _a, props = __rest(_a, ["className", "children", "isLeftAligned"]);
  return react.createElement("div", Object.assign({className: css(styles$2.tooltipContent, isLeftAligned && styles$2.modifiers.textAlignLeft, className)}, props), children2);
};
TooltipContent.displayName = "TooltipContent";
var TooltipArrow = (_a) => {
  var {className} = _a, props = __rest(_a, ["className"]);
  return react.createElement("div", Object.assign({className: css(styles$2.tooltipArrow, className)}, props));
};
TooltipArrow.displayName = "TooltipArrow";
var c_tooltip_MaxWidth = {
  name: "--pf-c-tooltip--MaxWidth",
  value: "18.75rem",
  var: "var(--pf-c-tooltip--MaxWidth)"
};
var TooltipPosition;
(function(TooltipPosition2) {
  TooltipPosition2["auto"] = "auto";
  TooltipPosition2["top"] = "top";
  TooltipPosition2["bottom"] = "bottom";
  TooltipPosition2["left"] = "left";
  TooltipPosition2["right"] = "right";
})(TooltipPosition || (TooltipPosition = {}));
var pfTooltipIdCounter = 1;
var Tooltip = (_a) => {
  var {
    content: bodyContent,
    position: position2 = "top",
    trigger = "mouseenter focus",
    isVisible = false,
    isContentLeftAligned = false,
    enableFlip = true,
    className = "",
    entryDelay = 300,
    exitDelay = 0,
    appendTo = () => document.body,
    zIndex = 9999,
    maxWidth = c_tooltip_MaxWidth.value,
    distance = 15,
    aria = "describedby",
    flipBehavior = ["top", "right", "bottom", "left", "top", "right", "bottom"],
    id: id3 = `pf-tooltip-${pfTooltipIdCounter++}`,
    children: children2,
    animationDuration = 300,
    reference: reference2,
    boundary,
    isAppLauncher,
    tippyProps
  } = _a, rest = __rest(_a, ["content", "position", "trigger", "isVisible", "isContentLeftAligned", "enableFlip", "className", "entryDelay", "exitDelay", "appendTo", "zIndex", "maxWidth", "distance", "aria", "flipBehavior", "id", "children", "animationDuration", "reference", "boundary", "isAppLauncher", "tippyProps"]);
  const triggerOnMouseenter = trigger.includes("mouseenter");
  const triggerOnFocus = trigger.includes("focus");
  const triggerOnClick = trigger.includes("click");
  const triggerManually = trigger === "manual";
  const [visible, setVisible] = react.useState(false);
  const [opacity, setOpacity] = react.useState(0);
  const transitionTimerRef = react.useRef(null);
  const showTimerRef = react.useRef(null);
  const hideTimerRef = react.useRef(null);
  const clearTimeouts = (timeoutRefs) => {
    timeoutRefs.forEach((ref) => {
      if (ref.current) {
        clearTimeout(ref.current);
      }
    });
  };
  react.useEffect(() => () => {
    clearTimeouts([transitionTimerRef, hideTimerRef, showTimerRef]);
  }, []);
  const onDocumentKeyDown = (event) => {
    if (!triggerManually) {
      if (event.keyCode === KEY_CODES.ESCAPE_KEY && visible) {
        hide3();
      }
    }
  };
  const onTriggerEnter = (event) => {
    if (event.keyCode === KEY_CODES.ENTER) {
      if (!visible) {
        show2();
      } else {
        hide3();
      }
    }
  };
  react.useEffect(() => {
    if (isVisible) {
      show2();
    } else {
      hide3();
    }
  }, [isVisible]);
  const show2 = () => {
    clearTimeouts([transitionTimerRef, hideTimerRef]);
    showTimerRef.current = setTimeout(() => {
      setVisible(true);
      setOpacity(1);
    }, entryDelay);
  };
  const hide3 = () => {
    clearTimeouts([showTimerRef]);
    hideTimerRef.current = setTimeout(() => {
      setOpacity(0);
      transitionTimerRef.current = setTimeout(() => setVisible(false), animationDuration);
    }, exitDelay);
  };
  const positionModifiers = {
    top: styles$2.modifiers.top,
    bottom: styles$2.modifiers.bottom,
    left: styles$2.modifiers.left,
    right: styles$2.modifiers.right
  };
  const hasCustomMaxWidth = maxWidth !== c_tooltip_MaxWidth.value;
  const content2 = react.createElement("div", Object.assign({className: css(styles$2.to