"use strict";

(function (global, factory) {
  if (typeof define === "function" && define.amd) {
    define(["exports", "prop-types", "react", "@patternfly/react-styles", "../../@patternfly/patternfly/components/Alert/alert.css.js", "../../@patternfly/patternfly/utilities/Accessibility/accessibility.css.js", "./AlertIcon", "../../helpers/util"], factory);
  } else if (typeof exports !== "undefined") {
    factory(exports, require("prop-types"), require("react"), require("@patternfly/react-styles"), require("../../@patternfly/patternfly/components/Alert/alert.css.js"), require("../../@patternfly/patternfly/utilities/Accessibility/accessibility.css.js"), require("./AlertIcon"), require("../../helpers/util"));
  } else {
    var mod = {
      exports: {}
    };
    factory(mod.exports, global.propTypes, global.react, global.reactStyles, global.alertCss, global.accessibilityCss, global.AlertIcon, global.util);
    global.undefined = mod.exports;
  }
})(void 0, function (exports, _propTypes, _react, _reactStyles, _alertCss, _accessibilityCss, _AlertIcon, _util) {
  "use strict";

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.Alert = exports.AlertVariant = undefined;

  var _propTypes2 = _interopRequireDefault(_propTypes);

  var React = _interopRequireWildcard(_react);

  var _alertCss2 = _interopRequireDefault(_alertCss);

  var _accessibilityCss2 = _interopRequireDefault(_accessibilityCss);

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    } else {
      var newObj = {};

      if (obj != null) {
        for (var key in obj) {
          if (Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {};

            if (desc.get || desc.set) {
              Object.defineProperty(newObj, key, desc);
            } else {
              newObj[key] = obj[key];
            }
          }
        }
      }

      newObj.default = obj;
      return newObj;
    }
  }

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : {
      default: obj
    };
  }

  function _extends() {
    _extends = Object.assign || function (target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i];

        for (var key in source) {
          if (Object.prototype.hasOwnProperty.call(source, key)) {
            target[key] = source[key];
          }
        }
      }

      return target;
    };

    return _extends.apply(this, arguments);
  }

  function _objectWithoutProperties(source, excluded) {
    if (source == null) return {};

    var target = _objectWithoutPropertiesLoose(source, excluded);

    var key, i;

    if (Object.getOwnPropertySymbols) {
      var sourceSymbolKeys = Object.getOwnPropertySymbols(source);

      for (i = 0; i < sourceSymbolKeys.length; i++) {
        key = sourceSymbolKeys[i];
        if (excluded.indexOf(key) >= 0) continue;
        if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue;
        target[key] = source[key];
      }
    }

    return target;
  }

  function _objectWithoutPropertiesLoose(source, excluded) {
    if (source == null) return {};
    var target = {};
    var sourceKeys = Object.keys(source);
    var key, i;

    for (i = 0; i < sourceKeys.length; i++) {
      key = sourceKeys[i];
      if (excluded.indexOf(key) >= 0) continue;
      target[key] = source[key];
    }

    return target;
  }

  var AlertVariant = exports.AlertVariant = undefined;

  (function (AlertVariant) {
    AlertVariant["success"] = "success";
    AlertVariant["danger"] = "danger";
    AlertVariant["warning"] = "warning";
    AlertVariant["info"] = "info";
  })(AlertVariant || (exports.AlertVariant = AlertVariant = {}));

  ;

  var Alert = exports.Alert = function Alert(_ref) {
    var variant = _ref.variant,
        _ref$variantLabel = _ref.variantLabel,
        variantLabel = _ref$variantLabel === void 0 ? "".concat((0, _util.capitalize)(variant), " alert:") : _ref$variantLabel,
        _ref$ariaLabel = _ref['aria-label'],
        ariaLabel = _ref$ariaLabel === void 0 ? "".concat((0, _util.capitalize)(variant), " Alert") : _ref$ariaLabel,
        _ref$action = _ref.action,
        action = _ref$action === void 0 ? null : _ref$action,
        title = _ref.title,
        _ref$children = _ref.children,
        children = _ref$children === void 0 ? '' : _ref$children,
        _ref$className = _ref.className,
        className = _ref$className === void 0 ? '' : _ref$className,
        props = _objectWithoutProperties(_ref, ["variant", "variantLabel", "aria-label", "action", "title", "children", "className"]);

    var readerTitle = React.createElement(React.Fragment, null, React.createElement("span", {
      className: (0, _reactStyles.css)(_accessibilityCss2["default"].screenReader)
    }, variantLabel), title);
    var customClassName = (0, _reactStyles.css)(_alertCss2["default"].alert, (0, _reactStyles.getModifier)(_alertCss2["default"], variant, _alertCss2["default"].modifiers.info), className);
    return React.createElement("div", _extends({}, props, {
      className: customClassName,
      "aria-label": ariaLabel
    }), React.createElement(_AlertIcon.AlertIcon, {
      variant: variant
    }), React.createElement("h4", {
      className: (0, _reactStyles.css)(_alertCss2["default"].alertTitle)
    }, readerTitle), children && React.createElement("div", {
      className: (0, _reactStyles.css)(_alertCss2["default"].alertDescription)
    }, React.createElement("p", null, children)), action && React.createElement("div", {
      className: (0, _reactStyles.css)(_alertCss2["default"].alertAction)
    }, React.cloneElement(action, {
      title: title,
      variantLabel: variantLabel
    })));
  };

  Alert.propTypes = {
    variant: _propTypes2["default"].oneOf(['success', 'danger', 'warning', 'info']).isRequired,
    title: _propTypes2["default"].node.isRequired,
    action: _propTypes2["default"].node,
    children: _propTypes2["default"].node,
    className: _propTypes2["default"].string,
    'aria-label': _propTypes2["default"].string,
    variantLabel: _propTypes2["default"].string
  };
});