/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.file.adapter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.keycloak.connections.file.InMemoryModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleContainerModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.entities.ClientEntity;
import org.keycloak.models.entities.ProtocolMapperEntity;
import org.keycloak.models.entities.RoleEntity;
import org.keycloak.models.file.adapter.RoleAdapter;
import org.keycloak.models.utils.KeycloakModelUtils;

public class ClientAdapter
implements ClientModel {
    private final RealmModel realm;
    private KeycloakSession session;
    private final ClientEntity entity;
    private final InMemoryModel inMemoryModel;
    private final Map<String, RoleAdapter> allRoles = new HashMap<String, RoleAdapter>();
    private final Map<String, RoleModel> allScopeMappings = new HashMap<String, RoleModel>();

    public ClientAdapter(KeycloakSession session, RealmModel realm, ClientEntity entity, InMemoryModel inMemoryModel) {
        this.realm = realm;
        this.session = session;
        this.entity = entity;
        this.inMemoryModel = inMemoryModel;
    }

    public void updateClient() {
    }

    public String getId() {
        return this.entity.getId();
    }

    public String getName() {
        return this.entity.getName();
    }

    public void setName(String name) {
        this.entity.setName(name);
    }

    public Set<String> getWebOrigins() {
        HashSet<String> result = new HashSet<String>();
        if (this.entity.getWebOrigins() != null) {
            result.addAll(this.entity.getWebOrigins());
        }
        return result;
    }

    public void setWebOrigins(Set<String> webOrigins) {
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(webOrigins);
        this.entity.setWebOrigins(result);
    }

    public void addWebOrigin(String webOrigin) {
        Set<String> webOrigins = this.getWebOrigins();
        webOrigins.add(webOrigin);
        this.setWebOrigins(webOrigins);
    }

    public void removeWebOrigin(String webOrigin) {
        Set<String> webOrigins = this.getWebOrigins();
        webOrigins.remove(webOrigin);
        this.setWebOrigins(webOrigins);
    }

    public Set<String> getRedirectUris() {
        HashSet<String> result = new HashSet<String>();
        if (this.entity.getRedirectUris() != null) {
            result.addAll(this.entity.getRedirectUris());
        }
        return result;
    }

    public void setRedirectUris(Set<String> redirectUris) {
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(redirectUris);
        this.entity.setRedirectUris(result);
    }

    public void addRedirectUri(String redirectUri) {
        if (this.entity.getRedirectUris().contains(redirectUri)) {
            return;
        }
        this.entity.getRedirectUris().add(redirectUri);
    }

    public void removeRedirectUri(String redirectUri) {
        this.entity.getRedirectUris().remove(redirectUri);
    }

    public boolean isEnabled() {
        return this.entity.isEnabled();
    }

    public void setEnabled(boolean enabled) {
        this.entity.setEnabled(enabled);
    }

    public boolean validateSecret(String secret) {
        return secret.equals(this.entity.getSecret());
    }

    public String getSecret() {
        return this.entity.getSecret();
    }

    public void setSecret(String secret) {
        this.entity.setSecret(secret);
    }

    public boolean isPublicClient() {
        return this.entity.isPublicClient();
    }

    public void setPublicClient(boolean flag) {
        this.entity.setPublicClient(flag);
    }

    public boolean isFrontchannelLogout() {
        return this.entity.isFrontchannelLogout();
    }

    public void setFrontchannelLogout(boolean flag) {
        this.entity.setFrontchannelLogout(flag);
    }

    public boolean isFullScopeAllowed() {
        return this.entity.isFullScopeAllowed();
    }

    public void setFullScopeAllowed(boolean value) {
        this.entity.setFullScopeAllowed(value);
    }

    public RealmModel getRealm() {
        return this.realm;
    }

    public int getNotBefore() {
        return this.entity.getNotBefore();
    }

    public void setNotBefore(int notBefore) {
        this.entity.setNotBefore(notBefore);
    }

    public Set<RoleModel> getScopeMappings() {
        return new HashSet<RoleModel>(this.allScopeMappings.values());
    }

    public Set<RoleModel> getRealmScopeMappings() {
        Set<RoleModel> allScopes = this.getScopeMappings();
        HashSet<RoleModel> realmRoles = new HashSet<RoleModel>();
        for (RoleModel role : allScopes) {
            RoleAdapter roleAdapter = (RoleAdapter)role;
            if (!roleAdapter.isRealmRole()) continue;
            realmRoles.add(role);
        }
        return realmRoles;
    }

    public void addScopeMapping(RoleModel role) {
        this.allScopeMappings.put(role.getId(), role);
    }

    public void deleteScopeMapping(RoleModel role) {
        this.allScopeMappings.remove(role.getId());
    }

    public String getProtocol() {
        return this.entity.getProtocol();
    }

    public void setProtocol(String protocol) {
        this.entity.setProtocol(protocol);
    }

    public void setAttribute(String name, String value) {
        this.entity.getAttributes().put(name, value);
    }

    public void removeAttribute(String name) {
        this.entity.getAttributes().remove(name);
    }

    public String getAttribute(String name) {
        return (String)this.entity.getAttributes().get(name);
    }

    public Map<String, String> getAttributes() {
        HashMap<String, String> copy = new HashMap<String, String>();
        copy.putAll(this.entity.getAttributes());
        return copy;
    }

    public Set<ProtocolMapperModel> getProtocolMappers() {
        HashSet<ProtocolMapperModel> result = new HashSet<ProtocolMapperModel>();
        for (ProtocolMapperEntity entity : this.entity.getProtocolMappers()) {
            ProtocolMapperModel model = this.getProtocolMapperById(entity.getId());
            if (model == null) continue;
            result.add(model);
        }
        return result;
    }

    public ProtocolMapperModel addProtocolMapper(ProtocolMapperModel model) {
        if (this.getProtocolMapperByName(model.getProtocol(), model.getName()) != null) {
            throw new RuntimeException("protocol mapper name must be unique per protocol");
        }
        ProtocolMapperEntity entity = new ProtocolMapperEntity();
        String id = model.getId() != null ? model.getId() : KeycloakModelUtils.generateId();
        entity.setId(id);
        entity.setProtocol(model.getProtocol());
        entity.setName(model.getName());
        entity.setProtocolMapper(model.getProtocolMapper());
        entity.setConfig(model.getConfig());
        entity.setConsentRequired(model.isConsentRequired());
        entity.setConsentText(model.getConsentText());
        this.entity.getProtocolMappers().add(entity);
        return this.entityToModel(entity);
    }

    public void removeProtocolMapper(ProtocolMapperModel mapping) {
        ProtocolMapperEntity toBeRemoved = null;
        for (ProtocolMapperEntity e : this.entity.getProtocolMappers()) {
            if (!e.getId().equals(mapping.getId())) continue;
            toBeRemoved = e;
            break;
        }
        this.entity.getProtocolMappers().remove(toBeRemoved);
    }

    public void updateProtocolMapper(ProtocolMapperModel mapping) {
        ProtocolMapperEntity entity = this.getProtocolMapperEntityById(mapping.getId());
        entity.setProtocolMapper(mapping.getProtocolMapper());
        entity.setConsentRequired(mapping.isConsentRequired());
        entity.setConsentText(mapping.getConsentText());
        if (entity.getConfig() != null) {
            entity.getConfig().clear();
            entity.getConfig().putAll(mapping.getConfig());
        } else {
            entity.setConfig(mapping.getConfig());
        }
    }

    protected ProtocolMapperEntity getProtocolMapperEntityById(String id) {
        for (ProtocolMapperEntity e : this.entity.getProtocolMappers()) {
            if (!e.getId().equals(id)) continue;
            return e;
        }
        return null;
    }

    protected ProtocolMapperEntity getProtocolMapperEntityByName(String protocol, String name) {
        for (ProtocolMapperEntity e : this.entity.getProtocolMappers()) {
            if (!e.getProtocol().equals(protocol) || !e.getName().equals(name)) continue;
            return e;
        }
        return null;
    }

    public ProtocolMapperModel getProtocolMapperById(String id) {
        ProtocolMapperEntity entity = this.getProtocolMapperEntityById(id);
        if (entity == null) {
            return null;
        }
        return this.entityToModel(entity);
    }

    public ProtocolMapperModel getProtocolMapperByName(String protocol, String name) {
        ProtocolMapperEntity entity = this.getProtocolMapperEntityByName(protocol, name);
        if (entity == null) {
            return null;
        }
        return this.entityToModel(entity);
    }

    protected ProtocolMapperModel entityToModel(ProtocolMapperEntity entity) {
        ProtocolMapperModel mapping = new ProtocolMapperModel();
        mapping.setId(entity.getId());
        mapping.setName(entity.getName());
        mapping.setProtocol(entity.getProtocol());
        mapping.setProtocolMapper(entity.getProtocolMapper());
        mapping.setConsentRequired(entity.isConsentRequired());
        mapping.setConsentText(entity.getConsentText());
        HashMap config = new HashMap();
        if (entity.getConfig() != null) {
            config.putAll(entity.getConfig());
        }
        mapping.setConfig(config);
        return mapping;
    }

    public String getClientId() {
        return this.entity.getClientId();
    }

    public void setClientId(String clientId) {
        if (this.appNameExists(clientId)) {
            throw new ModelDuplicateException("Application named " + clientId + " already exists.");
        }
        this.entity.setClientId(clientId);
    }

    private boolean appNameExists(String name) {
        for (ClientModel app : this.realm.getClients()) {
            if (app == this || !app.getClientId().equals(name)) continue;
            return true;
        }
        return false;
    }

    public boolean isSurrogateAuthRequired() {
        return this.entity.isSurrogateAuthRequired();
    }

    public void setSurrogateAuthRequired(boolean surrogateAuthRequired) {
        this.entity.setSurrogateAuthRequired(surrogateAuthRequired);
    }

    public String getManagementUrl() {
        return this.entity.getManagementUrl();
    }

    public void setManagementUrl(String url) {
        this.entity.setManagementUrl(url);
    }

    public void setBaseUrl(String url) {
        this.entity.setBaseUrl(url);
    }

    public String getBaseUrl() {
        return this.entity.getBaseUrl();
    }

    public boolean isBearerOnly() {
        return this.entity.isBearerOnly();
    }

    public void setBearerOnly(boolean only) {
        this.entity.setBearerOnly(only);
    }

    public boolean isConsentRequired() {
        return this.entity.isConsentRequired();
    }

    public void setConsentRequired(boolean consentRequired) {
        this.entity.setConsentRequired(consentRequired);
    }

    public boolean isDirectGrantsOnly() {
        return this.entity.isDirectGrantsOnly();
    }

    public void setDirectGrantsOnly(boolean flag) {
        this.entity.setDirectGrantsOnly(flag);
    }

    public RoleAdapter getRole(String name) {
        for (RoleAdapter role : this.allRoles.values()) {
            if (!role.getName().equals(name)) continue;
            return role;
        }
        return null;
    }

    public RoleAdapter addRole(String name) {
        return this.addRole(KeycloakModelUtils.generateId(), name);
    }

    public RoleAdapter addRole(String id, String name) {
        if (this.roleNameExists(name)) {
            throw new ModelDuplicateException("Role named " + name + " already exists.");
        }
        RoleEntity roleEntity = new RoleEntity();
        roleEntity.setId(id);
        roleEntity.setName(name);
        roleEntity.setClientId(this.getId());
        RoleAdapter role = new RoleAdapter(this.getRealm(), roleEntity, (RoleContainerModel)this);
        this.allRoles.put(id, role);
        return role;
    }

    private boolean roleNameExists(String name) {
        for (RoleModel roleModel : this.allRoles.values()) {
            if (!roleModel.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public boolean removeRole(RoleModel role) {
        boolean removed = this.allRoles.remove(role.getId()) != null;
        for (UserModel user : this.inMemoryModel.getUsers(this.realm.getId())) {
            user.deleteRoleMapping(role);
        }
        for (ClientModel app : this.realm.getClients()) {
            app.deleteScopeMapping(role);
        }
        this.realm.removeRole(role);
        this.deleteScopeMapping(role);
        return removed;
    }

    public Set<RoleModel> getRoles() {
        return new HashSet<RoleModel>(this.allRoles.values());
    }

    public boolean hasScope(RoleModel role) {
        if (this.isFullScopeAllowed()) {
            return true;
        }
        Set<RoleModel> roles = this.getScopeMappings();
        if (roles.contains(role)) {
            return true;
        }
        for (RoleModel mapping : roles) {
            if (!mapping.hasRole(role)) continue;
            return true;
        }
        roles = this.getRoles();
        if (roles.contains(role)) {
            return true;
        }
        for (RoleModel mapping : roles) {
            if (!mapping.hasRole(role)) continue;
            return true;
        }
        return false;
    }

    public Set<RoleModel> getClientScopeMappings(ClientModel client) {
        Set allScopes = client.getScopeMappings();
        HashSet<RoleModel> appRoles = new HashSet<RoleModel>();
        for (RoleModel role : allScopes) {
            RoleAdapter roleAdapter = (RoleAdapter)role;
            if (!this.getId().equals(roleAdapter.getRoleEntity().getClientId())) continue;
            appRoles.add(role);
        }
        return appRoles;
    }

    public List<String> getDefaultRoles() {
        return this.entity.getDefaultRoles();
    }

    public void addDefaultRole(String name) {
        List<String> defaultRoles;
        RoleAdapter role = this.getRole(name);
        if (role == null) {
            this.addRole(name);
        }
        if ((defaultRoles = this.getDefaultRoles()).contains(name)) {
            return;
        }
        String[] defaultRoleNames = defaultRoles.toArray(new String[defaultRoles.size() + 1]);
        defaultRoleNames[defaultRoleNames.length - 1] = name;
        this.updateDefaultRoles(defaultRoleNames);
    }

    public void updateDefaultRoles(String[] defaultRoles) {
        ArrayList<String> roleNames = new ArrayList<String>();
        for (String roleName : defaultRoles) {
            RoleAdapter role = this.getRole(roleName);
            if (role == null) {
                this.addRole(roleName);
            }
            roleNames.add(roleName);
        }
        this.entity.setDefaultRoles(roleNames);
    }

    public int getNodeReRegistrationTimeout() {
        return this.entity.getNodeReRegistrationTimeout();
    }

    public void setNodeReRegistrationTimeout(int timeout) {
        this.entity.setNodeReRegistrationTimeout(timeout);
    }

    public Map<String, Integer> getRegisteredNodes() {
        return this.entity.getRegisteredNodes() == null ? Collections.emptyMap() : Collections.unmodifiableMap(this.entity.getRegisteredNodes());
    }

    public void registerNode(String nodeHost, int registrationTime) {
        if (this.entity.getRegisteredNodes() == null) {
            this.entity.setRegisteredNodes(new HashMap());
        }
        this.entity.getRegisteredNodes().put(nodeHost, registrationTime);
    }

    public void unregisterNode(String nodeHost) {
        if (this.entity.getRegisteredNodes() == null) {
            return;
        }
        this.entity.getRegisteredNodes().remove(nodeHost);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof ClientModel)) {
            return false;
        }
        ClientModel that = (ClientModel)o;
        return that.getId().equals(this.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }
}

