/*
 * Decompiled with CFR 0.152.
 */
package liquibase.resource;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashSet;
import java.util.Set;
import liquibase.resource.AbstractResourceAccessor;

public class FileSystemResourceAccessor
extends AbstractResourceAccessor {
    private File baseDirectory;

    public FileSystemResourceAccessor() {
        this.baseDirectory = null;
    }

    public FileSystemResourceAccessor(String base) {
        this.baseDirectory = new File(base);
        if (!this.baseDirectory.isDirectory()) {
            throw new IllegalArgumentException(base + " must be a directory");
        }
    }

    @Override
    public Set<InputStream> getResourcesAsStream(String path) throws IOException {
        File absoluteFile = new File(path);
        File relativeFile = this.baseDirectory == null ? new File(path) : new File(this.baseDirectory, path);
        BufferedInputStream fileStream = null;
        if (absoluteFile.exists() && absoluteFile.isFile() && absoluteFile.isAbsolute()) {
            fileStream = new BufferedInputStream(new FileInputStream(absoluteFile));
        } else if (relativeFile.exists() && relativeFile.isFile()) {
            fileStream = new BufferedInputStream(new FileInputStream(relativeFile));
        }
        if (fileStream == null) {
            return null;
        }
        HashSet<InputStream> returnSet = new HashSet<InputStream>();
        returnSet.add(fileStream);
        return returnSet;
    }

    @Override
    public Set<String> list(String relativeTo, String path, boolean includeFiles, boolean includeDirectories, boolean recursive) throws IOException {
        File relativeFile;
        File absoluteFile = new File(path);
        File file = relativeFile = this.baseDirectory == null ? new File(path) : new File(this.baseDirectory, path);
        if (absoluteFile.exists() && absoluteFile.isDirectory()) {
            HashSet<String> returnSet = new HashSet<String>();
            this.getContents(absoluteFile, recursive, includeFiles, includeDirectories, path, returnSet);
            return returnSet;
        }
        if (relativeFile.exists() && relativeFile.isDirectory()) {
            HashSet<String> returnSet = new HashSet<String>();
            this.getContents(relativeFile, recursive, includeFiles, includeDirectories, path, returnSet);
            return returnSet;
        }
        return null;
    }

    @Override
    public ClassLoader toClassLoader() {
        try {
            return new URLClassLoader(new URL[]{new URL("file://" + this.baseDirectory)});
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        File dir = this.baseDirectory;
        if (dir == null) {
            dir = new File(".");
        }
        return this.getClass().getName() + "(" + dir.getAbsolutePath() + ")";
    }
}

