/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.mongo;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.keycloak.connections.mongo.api.MongoIdentifiableEntity;
import org.keycloak.connections.mongo.api.context.MongoStoreInvocationContext;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientSessionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.sessions.mongo.AbstractMongoAdapter;
import org.keycloak.models.sessions.mongo.MongoUserSessionProvider;
import org.keycloak.models.sessions.mongo.entities.MongoClientSessionEntity;
import org.keycloak.models.sessions.mongo.entities.MongoUserSessionEntity;

public class ClientSessionAdapter
extends AbstractMongoAdapter<MongoClientSessionEntity>
implements ClientSessionModel {
    private KeycloakSession session;
    private MongoUserSessionProvider provider;
    private RealmModel realm;
    private MongoClientSessionEntity entity;

    public ClientSessionAdapter(KeycloakSession session, MongoUserSessionProvider provider, RealmModel realm, MongoClientSessionEntity entity, MongoStoreInvocationContext invContext) {
        super(invContext);
        this.session = session;
        this.provider = provider;
        this.realm = realm;
        this.entity = entity;
    }

    public String getId() {
        return this.entity.getId();
    }

    public RealmModel getRealm() {
        return this.session.realms().getRealm(this.entity.getRealmId());
    }

    public ClientModel getClient() {
        return this.realm.getClientById(this.entity.getClientId());
    }

    public UserSessionModel getUserSession() {
        if (this.entity.getSessionId() == null) {
            return null;
        }
        return this.provider.getUserSession(this.realm, this.entity.getSessionId());
    }

    public void setUserSession(UserSessionModel userSession) {
        if (userSession == null) {
            if (this.entity.getSessionId() != null) {
                MongoUserSessionEntity userSessionEntity = this.provider.getUserSessionEntity(this.realm, this.entity.getSessionId());
                this.provider.getMongoStore().pullItemFromList((MongoIdentifiableEntity)userSessionEntity, "clientSessions", (Object)this.entity.getSessionId(), this.invocationContext);
            }
            this.entity.setSessionId(null);
        } else {
            MongoUserSessionEntity userSessionEntity = this.provider.getUserSessionEntity(this.realm, userSession.getId());
            this.entity.setSessionId(userSessionEntity.getId());
            this.updateMongoEntity();
            this.provider.getMongoStore().pushItemToList((MongoIdentifiableEntity)userSessionEntity, "clientSessions", (Object)this.entity.getId(), true, this.invocationContext);
        }
    }

    public void setRedirectUri(String uri) {
        this.entity.setRedirectUri(uri);
        this.updateMongoEntity();
    }

    public void setRoles(Set<String> roles) {
        if (roles == null) {
            this.entity.setRoles(null);
        } else {
            LinkedList<String> list = new LinkedList<String>();
            list.addAll(roles);
            this.entity.setRoles(list);
        }
        this.updateMongoEntity();
    }

    public String getRedirectUri() {
        return this.entity.getRedirectUri();
    }

    public int getTimestamp() {
        return this.entity.getTimestamp();
    }

    public void setTimestamp(int timestamp) {
        this.entity.setTimestamp(timestamp);
        this.updateMongoEntity();
    }

    public String getAction() {
        return this.entity.getAction();
    }

    public void setAction(String action) {
        this.entity.setAction(action);
        this.updateMongoEntity();
    }

    public Set<String> getRoles() {
        return this.entity.getRoles() != null ? new HashSet<String>(this.entity.getRoles()) : null;
    }

    public Set<String> getProtocolMappers() {
        return this.entity.getProtocolMappers() != null ? new HashSet<String>(this.entity.getProtocolMappers()) : null;
    }

    public void setProtocolMappers(Set<String> protocolMappers) {
        if (protocolMappers == null) {
            this.entity.setProtocolMappers(null);
        } else {
            LinkedList<String> list = new LinkedList<String>();
            list.addAll(protocolMappers);
            this.entity.setProtocolMappers(list);
        }
        this.updateMongoEntity();
    }

    public String getNote(String name) {
        return this.entity.getNotes().get(name);
    }

    public void setNote(String name, String value) {
        this.entity.getNotes().put(name, value);
        this.updateMongoEntity();
    }

    public void removeNote(String name) {
        this.entity.getNotes().remove(name);
        this.updateMongoEntity();
    }

    public void setUserSessionNote(String name, String value) {
        this.entity.getUserSessionNotes().put(name, value);
        this.updateMongoEntity();
    }

    public Map<String, String> getUserSessionNotes() {
        HashMap<String, String> copy = new HashMap<String, String>();
        copy.putAll(this.entity.getUserSessionNotes());
        return copy;
    }

    public Map<String, UserSessionModel.AuthenticatorStatus> getAuthenticators() {
        return this.entity.getAuthenticatorStatus();
    }

    public void setAuthenticatorStatus(String authenticator, UserSessionModel.AuthenticatorStatus status) {
        this.entity.getAuthenticatorStatus().put(authenticator, status);
        this.updateMongoEntity();
    }

    public void setAuthenticatorStatus(Map<String, UserSessionModel.AuthenticatorStatus> status) {
        this.entity.setAuthenticatorStatus(status);
        this.updateMongoEntity();
    }

    public UserModel getAuthenticatedUser() {
        return this.session.users().getUserById(this.entity.getAuthUserId(), this.realm);
    }

    public void setAuthenticatedUser(UserModel user) {
        this.entity.setAuthUserId(user.getId());
        this.updateMongoEntity();
    }

    public String getAuthMethod() {
        return this.entity.getAuthMethod();
    }

    public void setAuthMethod(String method) {
        this.entity.setAuthMethod(method);
        this.updateMongoEntity();
    }

    @Override
    protected MongoClientSessionEntity getMongoEntity() {
        return this.entity;
    }
}

