/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.mongo.entities;

import com.mongodb.DBObject;
import com.mongodb.QueryBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.keycloak.connections.mongo.api.MongoCollection;
import org.keycloak.connections.mongo.api.MongoIdentifiableEntity;
import org.keycloak.connections.mongo.api.context.MongoStoreInvocationContext;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.entities.AbstractIdentifiableEntity;
import org.keycloak.models.sessions.mongo.entities.MongoClientSessionEntity;

@MongoCollection(collectionName="sessions")
public class MongoUserSessionEntity
extends AbstractIdentifiableEntity
implements MongoIdentifiableEntity {
    private String realmId;
    private String brokerSessionId;
    private String brokerUserId;
    private String user;
    private String loginUsername;
    private String ipAddress;
    private String authMethod;
    private boolean rememberMe;
    private int started;
    private int lastSessionRefresh;
    private List<String> clientSessions = new ArrayList<String>();
    private Map<String, String> notes = new HashMap<String, String>();
    private UserSessionModel.State state;

    public String getRealmId() {
        return this.realmId;
    }

    public void setRealmId(String realmId) {
        this.realmId = realmId;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getLoginUsername() {
        return this.loginUsername;
    }

    public void setLoginUsername(String loginUsername) {
        this.loginUsername = loginUsername;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public String getAuthMethod() {
        return this.authMethod;
    }

    public void setAuthMethod(String authMethod) {
        this.authMethod = authMethod;
    }

    public boolean isRememberMe() {
        return this.rememberMe;
    }

    public void setRememberMe(boolean rememberMe) {
        this.rememberMe = rememberMe;
    }

    public int getStarted() {
        return this.started;
    }

    public void setStarted(int started) {
        this.started = started;
    }

    public int getLastSessionRefresh() {
        return this.lastSessionRefresh;
    }

    public void setLastSessionRefresh(int lastSessionRefresh) {
        this.lastSessionRefresh = lastSessionRefresh;
    }

    public List<String> getClientSessions() {
        return this.clientSessions;
    }

    public void setClientSessions(List<String> clientSessions) {
        this.clientSessions = clientSessions;
    }

    public void afterRemove(MongoStoreInvocationContext context) {
        DBObject query = new QueryBuilder().and("sessionId").is((Object)this.getId()).get();
        context.getMongoStore().removeEntities(MongoClientSessionEntity.class, query, true, context);
    }

    public Map<String, String> getNotes() {
        return this.notes;
    }

    public void setNotes(Map<String, String> notes) {
        this.notes = notes;
    }

    public UserSessionModel.State getState() {
        return this.state;
    }

    public void setState(UserSessionModel.State state) {
        this.state = state;
    }

    public String getBrokerSessionId() {
        return this.brokerSessionId;
    }

    public void setBrokerSessionId(String brokerSessionId) {
        this.brokerSessionId = brokerSessionId;
    }

    public String getBrokerUserId() {
        return this.brokerUserId;
    }

    public void setBrokerUserId(String brokerUserId) {
        this.brokerUserId = brokerUserId;
    }
}

