/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Providers;
import org.jboss.logging.Logger;
import org.jboss.resteasy.spi.HttpRequest;
import org.keycloak.ClientConnection;
import org.keycloak.authentication.AuthenticationProcessor;
import org.keycloak.authentication.AuthenticatorUtil;
import org.keycloak.authentication.RequiredActionContext;
import org.keycloak.authentication.RequiredActionProvider;
import org.keycloak.email.EmailException;
import org.keycloak.email.EmailProvider;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.login.LoginFormsProvider;
import org.keycloak.models.AuthenticationFlowModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientSessionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelException;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserConsentModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.utils.FormMessage;
import org.keycloak.models.utils.TimeBasedOTP;
import org.keycloak.protocol.LoginProtocol;
import org.keycloak.protocol.oidc.OIDCLoginProtocolService;
import org.keycloak.protocol.oidc.TokenManager;
import org.keycloak.services.ErrorPage;
import org.keycloak.services.Urls;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.managers.ClientSessionCode;
import org.keycloak.services.resources.AttributeFormDataProcessor;
import org.keycloak.services.resources.RealmsResource;
import org.keycloak.services.util.CookieHelper;
import org.keycloak.services.validation.Validation;

public class LoginActionsService {
    protected static final Logger logger = Logger.getLogger(LoginActionsService.class);
    public static final String ACTION_COOKIE = "KEYCLOAK_ACTION";
    private RealmModel realm;
    @Context
    private HttpRequest request;
    @Context
    protected HttpHeaders headers;
    @Context
    private UriInfo uriInfo;
    @Context
    private ClientConnection clientConnection;
    @Context
    protected Providers providers;
    @Context
    protected KeycloakSession session;
    private AuthenticationManager authManager;
    private EventBuilder event;

    public static UriBuilder loginActionsBaseUrl(UriInfo uriInfo) {
        UriBuilder baseUriBuilder = uriInfo.getBaseUriBuilder();
        return LoginActionsService.loginActionsBaseUrl(baseUriBuilder);
    }

    public static UriBuilder authenticationFormProcessor(UriInfo uriInfo) {
        return LoginActionsService.loginActionsBaseUrl(uriInfo).path(LoginActionsService.class, "authForm");
    }

    public static UriBuilder loginActionsBaseUrl(UriBuilder baseUriBuilder) {
        return baseUriBuilder.path(RealmsResource.class).path(RealmsResource.class, "getLoginActionsService");
    }

    public static UriBuilder processOAuthUrl(UriInfo uriInfo) {
        UriBuilder baseUriBuilder = uriInfo.getBaseUriBuilder();
        return LoginActionsService.processOAuthUrl(baseUriBuilder);
    }

    public static UriBuilder processOAuthUrl(UriBuilder baseUriBuilder) {
        UriBuilder uriBuilder = LoginActionsService.loginActionsBaseUrl(baseUriBuilder);
        return uriBuilder.path(OIDCLoginProtocolService.class, "processOAuth");
    }

    public LoginActionsService(RealmModel realm, AuthenticationManager authManager, EventBuilder event) {
        this.realm = realm;
        this.authManager = authManager;
        this.event = event;
    }

    private boolean checkSsl() {
        if (this.uriInfo.getBaseUri().getScheme().equals("https")) {
            return true;
        }
        return !this.realm.getSslRequired().isRequired(this.clientConnection);
    }

    @Path(value="login")
    @GET
    public Response loginPage(@QueryParam(value="code") String code) {
        this.event.event(EventType.LOGIN);
        Checks checks = new Checks();
        if (!checks.check(code)) {
            return checks.response;
        }
        this.event.detail("code_id", code);
        ClientSessionCode clientSessionCode = checks.clientCode;
        ClientSessionModel clientSession = clientSessionCode.getClientSession();
        if (clientSession.getAction().equals(ClientSessionModel.Action.RECOVER_PASSWORD.name())) {
            TokenManager.dettachClientSession(this.session.sessions(), this.realm, clientSession);
            clientSession.setAction(ClientSessionModel.Action.AUTHENTICATE.name());
        }
        AuthenticationFlowModel flow = this.realm.getFlowByAlias("browser");
        String flowId = flow.getId();
        AuthenticationProcessor processor = new AuthenticationProcessor();
        processor.setClientSession(clientSession).setFlowId(flowId).setConnection(this.clientConnection).setEventBuilder(this.event).setProtector(this.authManager.getProtector()).setRealm(this.realm).setSession(this.session).setUriInfo(this.uriInfo).setRequest(this.request);
        try {
            return processor.authenticate();
        }
        catch (Exception e) {
            return processor.handleBrowserException(e);
        }
    }

    @Path(value="registration")
    @GET
    public Response registerPage(@QueryParam(value="code") String code) {
        this.event.event(EventType.REGISTER);
        if (!this.realm.isRegistrationAllowed()) {
            this.event.error("registration_disabled");
            return ErrorPage.error(this.session, "registrationNotAllowedMessage", new Object[0]);
        }
        Checks checks = new Checks();
        if (!checks.check(code)) {
            return checks.response;
        }
        this.event.detail("code_id", code);
        ClientSessionCode clientSessionCode = checks.clientCode;
        ClientSessionModel clientSession = clientSessionCode.getClientSession();
        AuthenticationManager.expireIdentityCookie(this.realm, this.uriInfo, this.clientConnection);
        return ((LoginFormsProvider)this.session.getProvider(LoginFormsProvider.class)).setClientSessionCode(clientSessionCode.getCode()).setAttribute("passwordRequired", (Object)this.isPasswordRequired()).createRegistration();
    }

    @Path(value="auth-form")
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response authForm(@QueryParam(value="code") String code, @QueryParam(value="action") String action) {
        this.event.event(EventType.LOGIN);
        Checks checks = new Checks();
        if (!checks.check(code, ClientSessionModel.Action.AUTHENTICATE.name())) {
            return checks.response;
        }
        ClientSessionCode clientCode = checks.clientCode;
        ClientSessionModel clientSession = clientCode.getClientSession();
        String flowAlias = "browser";
        AuthenticationFlowModel flow = this.realm.getFlowByAlias(flowAlias);
        AuthenticationProcessor processor = new AuthenticationProcessor();
        processor.setClientSession(clientSession).setFlowId(flow.getId()).setConnection(this.clientConnection).setEventBuilder(this.event).setProtector(this.authManager.getProtector()).setRealm(this.realm).setSession(this.session).setUriInfo(this.uriInfo).setAction(action).setRequest(this.request);
        try {
            return processor.authenticate();
        }
        catch (Exception e) {
            return processor.handleBrowserException(e);
        }
    }

    @Path(value="request/registration")
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response processRegister(@QueryParam(value="code") String code) {
        List<FormMessage> errors;
        MultivaluedMap formData = this.request.getDecodedFormParameters();
        this.event.event(EventType.REGISTER);
        if (!this.checkSsl()) {
            this.event.error("ssl_required");
            return ErrorPage.error(this.session, "httpsRequiredMessage", new Object[0]);
        }
        if (!this.realm.isEnabled()) {
            this.event.error("realm_disabled");
            return ErrorPage.error(this.session, "realmNotEnabledMessage", new Object[0]);
        }
        if (!this.realm.isRegistrationAllowed()) {
            this.event.error("registration_disabled");
            return ErrorPage.error(this.session, "registrationNotAllowedMessage", new Object[0]);
        }
        ClientSessionCode clientCode = ClientSessionCode.parse(code, this.session, this.realm);
        if (clientCode == null) {
            this.event.error("invalid_code");
            return ErrorPage.error(this.session, "invalidCodeMessage", new Object[0]);
        }
        if (!clientCode.isValid(ClientSessionModel.Action.AUTHENTICATE.name())) {
            this.event.error("invalid_code");
            return ErrorPage.error(this.session, "invalidCodeMessage", new Object[0]);
        }
        String username = (String)formData.getFirst((Object)"username");
        String email = (String)formData.getFirst((Object)"email");
        if (this.realm.isRegistrationEmailAsUsername()) {
            username = email;
            formData.putSingle((Object)"username", (Object)username);
        }
        ClientSessionModel clientSession = clientCode.getClientSession();
        this.event.client(clientSession.getClient()).detail("redirect_uri", clientSession.getRedirectUri()).detail("response_type", "code").detail("username", username).detail("email", email).detail("register_method", "form");
        if (!this.realm.isEnabled()) {
            this.event.error("realm_disabled");
            return ErrorPage.error(this.session, "realmNotEnabledMessage", new Object[0]);
        }
        ClientModel client = clientSession.getClient();
        if (client == null) {
            this.event.error("client_not_found");
            return ErrorPage.error(this.session, "unknownLoginRequesterMessage", new Object[0]);
        }
        if (!client.isEnabled()) {
            this.event.error("client_disabled");
            return ErrorPage.error(this.session, "loginRequesterNotEnabledMessage", new Object[0]);
        }
        this.session.getContext().setClient(client);
        LinkedList<String> requiredCredentialTypes = new LinkedList<String>();
        boolean passwordRequired = this.isPasswordRequired();
        if (passwordRequired) {
            requiredCredentialTypes.add("password");
        }
        if ((errors = Validation.validateRegistrationForm(this.realm, (MultivaluedMap<String, String>)formData, requiredCredentialTypes, this.realm.getPasswordPolicy())) != null && !errors.isEmpty()) {
            this.event.error("invalid_registration");
            return ((LoginFormsProvider)this.session.getProvider(LoginFormsProvider.class)).setErrors(errors).setFormData(formData).setClientSessionCode(clientCode.getCode()).setAttribute("passwordRequired", (Object)this.isPasswordRequired()).createRegistration();
        }
        if (this.session.users().getUserByUsername(username, this.realm) != null) {
            this.event.error("username_in_use");
            return ((LoginFormsProvider)this.session.getProvider(LoginFormsProvider.class)).setError("usernameExistsMessage", new Object[0]).setFormData(formData).setClientSessionCode(clientCode.getCode()).setAttribute("passwordRequired", (Object)this.isPasswordRequired()).createRegistration();
        }
        if (email != null && this.session.users().getUserByEmail(email, this.realm) != null) {
            this.event.error("email_in_use");
            return ((LoginFormsProvider)this.session.getProvider(LoginFormsProvider.class)).setError("emailExistsMessage", new Object[0]).setFormData(formData).setClientSessionCode(clientCode.getCode()).setAttribute("passwordRequired", (Object)this.isPasswordRequired()).createRegistration();
        }
        UserModel user = this.session.users().addUser(this.realm, username);
        user.setEnabled(true);
        user.setFirstName((String)formData.getFirst((Object)"firstName"));
        user.setLastName((String)formData.getFirst((Object)"lastName"));
        user.setEmail(email);
        if (passwordRequired) {
            boolean passwordUpdateSuccessful;
            UserCredentialModel credentials = new UserCredentialModel();
            credentials.setType("password");
            credentials.setValue((String)formData.getFirst((Object)"password"));
            String passwordUpdateError = null;
            Object[] passwordUpdateErrorParameters = null;
            try {
                this.session.users().updateCredential(this.realm, user, UserCredentialModel.password((String)((String)formData.getFirst((Object)"password"))));
                passwordUpdateSuccessful = true;
            }
            catch (ModelException me) {
                passwordUpdateSuccessful = false;
                passwordUpdateError = me.getMessage();
                passwordUpdateErrorParameters = me.getParameters();
            }
            catch (Exception ape) {
                passwordUpdateSuccessful = false;
                passwordUpdateError = ape.getMessage();
            }
            if (!passwordUpdateSuccessful) {
                user.addRequiredAction(UserModel.RequiredAction.UPDATE_PASSWORD);
                return ((LoginFormsProvider)this.session.getProvider(LoginFormsProvider.class)).setError(passwordUpdateError, passwordUpdateErrorParameters).setClientSessionCode(clientCode.getCode()).createResponse(UserModel.RequiredAction.UPDATE_PASSWORD);
            }
        }
        clientSession.setNote("login_hint", username);
        AttributeFormDataProcessor.process((MultivaluedMap<String, String>)formData, this.realm, user);
        this.event.user(user).success();
        this.event = new EventBuilder(this.realm, this.session, this.clientConnection);
        clientSession.setAuthenticatedUser(user);
        AuthenticationFlowModel flow = this.realm.getFlowByAlias("browser");
        AuthenticationProcessor processor = new AuthenticationProcessor();
        processor.setClientSession(clientSession).setFlowId(flow.getId()).setConnection(this.clientConnection).setEventBuilder(this.event).setProtector(this.authManager.getProtector()).setRealm(this.realm).setAction("registration_form").setSession(this.session).setUriInfo(this.uriInfo).setRequest(this.request);
        try {
            return processor.authenticate();
        }
        catch (Exception e) {
            return processor.handleBrowserException(e);
        }
    }

    public boolean isPasswordRequired() {
        AuthenticationFlowModel browserFlow = this.realm.getFlowByAlias("browser");
        return AuthenticatorUtil.isRequired(this.realm, browserFlow.getId(), "auth-login-form-password");
    }

    @Path(value="consent")
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response processConsent(MultivaluedMap<String, String> formData) {
        this.event.event(EventType.LOGIN).detail("response_type", "code");
        if (!this.checkSsl()) {
            return ErrorPage.error(this.session, "httpsRequiredMessage", new Object[0]);
        }
        String code = (String)formData.getFirst((Object)"code");
        ClientSessionCode accessCode = ClientSessionCode.parse(code, this.session, this.realm);
        if (accessCode == null || !accessCode.isValid(ClientSessionModel.Action.OAUTH_GRANT.name())) {
            this.event.error("invalid_code");
            return ErrorPage.error(this.session, "invalidAccessCodeMessage", new Object[0]);
        }
        ClientSessionModel clientSession = accessCode.getClientSession();
        this.event.detail("code_id", clientSession.getId());
        String redirect = clientSession.getRedirectUri();
        UserSessionModel userSession = clientSession.getUserSession();
        UserModel user = userSession.getUser();
        ClientModel client = clientSession.getClient();
        this.event.client(client).user(user).detail("response_type", "code").detail("redirect_uri", redirect);
        this.event.detail("auth_method", userSession.getAuthMethod());
        this.event.detail("username", userSession.getLoginUsername());
        if (userSession.isRememberMe()) {
            this.event.detail("remember_me", "true");
        }
        if (!AuthenticationManager.isSessionValid(this.realm, userSession)) {
            AuthenticationManager.backchannelLogout(this.session, this.realm, userSession, this.uriInfo, this.clientConnection, this.headers, true);
            this.event.error("invalid_code");
            return ErrorPage.error(this.session, "sessionNotActiveMessage", new Object[0]);
        }
        this.event.session(userSession);
        if (formData.containsKey((Object)"cancel")) {
            LoginProtocol protocol = (LoginProtocol)this.session.getProvider(LoginProtocol.class, clientSession.getAuthMethod());
            protocol.setRealm(this.realm).setHttpHeaders(this.headers).setUriInfo(this.uriInfo);
            this.event.error("rejected_by_user");
            return protocol.consentDenied(clientSession);
        }
        UserConsentModel grantedConsent = user.getConsentByClient(client.getId());
        if (grantedConsent == null) {
            grantedConsent = new UserConsentModel(client);
            user.addConsent(grantedConsent);
        }
        for (RoleModel role : accessCode.getRequestedRoles()) {
            grantedConsent.addGrantedRole(role);
        }
        for (ProtocolMapperModel protocolMapper : accessCode.getRequestedProtocolMappers()) {
            if (!protocolMapper.isConsentRequired() || protocolMapper.getConsentText() == null) continue;
            grantedConsent.addGrantedProtocolMapper(protocolMapper);
        }
        user.updateConsent(grantedConsent);
        this.event.detail("consent", "consent_granted");
        this.event.success();
        return AuthenticationManager.redirectAfterSuccessfulFlow(this.session, this.realm, userSession, clientSession, this.request, this.uriInfo, this.clientConnection);
    }

    @Path(value="profile")
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response updateProfile(@QueryParam(value="code") String code, MultivaluedMap<String, String> formData) {
        boolean emailChanged;
        this.event.event(EventType.UPDATE_PROFILE);
        Checks checks = new Checks();
        if (!checks.check(code, ClientSessionModel.Action.UPDATE_PROFILE.name())) {
            return checks.response;
        }
        ClientSessionCode accessCode = checks.clientCode;
        ClientSessionModel clientSession = accessCode.getClientSession();
        UserSessionModel userSession = clientSession.getUserSession();
        UserModel user = userSession.getUser();
        this.initEvent(clientSession);
        List<FormMessage> errors = Validation.validateUpdateProfileForm(formData);
        if (errors != null && !errors.isEmpty()) {
            return ((LoginFormsProvider)this.session.getProvider(LoginFormsProvider.class)).setClientSessionCode(accessCode.getCode()).setUser(user).setErrors(errors).createResponse(UserModel.RequiredAction.UPDATE_PROFILE);
        }
        user.setFirstName((String)formData.getFirst((Object)"firstName"));
        user.setLastName((String)formData.getFirst((Object)"lastName"));
        String email = (String)formData.getFirst((Object)"email");
        String oldEmail = user.getEmail();
        boolean bl = oldEmail != null ? !oldEmail.equals(email) : (emailChanged = email != null);
        if (emailChanged) {
            UserModel userByEmail = this.session.users().getUserByEmail(email, this.realm);
            if (userByEmail != null && !userByEmail.getId().equals(user.getId())) {
                return ((LoginFormsProvider)this.session.getProvider(LoginFormsProvider.class)).setUser(user).setError("emailExistsMessage", new Object[0]).setClientSessionCode(accessCode.getCode()).createResponse(UserModel.RequiredAction.UPDATE_PROFILE);
            }
            user.setEmail(email);
            user.setEmailVerified(false);
        }
        AttributeFormDataProcessor.process(formData, this.realm, user);
        user.removeRequiredAction(UserModel.RequiredAction.UPDATE_PROFILE);
        this.event.clone().event(EventType.UPDATE_PROFILE).success();
        if (emailChanged) {
            this.event.clone().event(EventType.UPDATE_EMAIL).detail("previous_email", oldEmail).detail("updated_email", email).success();
        }
        return AuthenticationManager.nextActionAfterAuthentication(this.session, userSession, clientSession, this.clientConnection, this.request, this.uriInfo, this.event);
    }

    @Path(value="totp")
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response updateTotp(@QueryParam(value="code") String code, MultivaluedMap<String, String> formData) {
        this.event.event(EventType.UPDATE_TOTP);
        Checks checks = new Checks();
        if (!checks.check(code, ClientSessionModel.Action.CONFIGURE_TOTP.name())) {
            return checks.response;
        }
        ClientSessionCode accessCode = checks.clientCode;
        ClientSessionModel clientSession = accessCode.getClientSession();
        UserSessionModel userSession = clientSession.getUserSession();
        UserModel user = userSession.getUser();
        this.initEvent(clientSession);
        String totp = (String)formData.getFirst((Object)"totp");
        String totpSecret = (String)formData.getFirst((Object)"totpSecret");
        LoginFormsProvider loginForms = ((LoginFormsProvider)this.session.getProvider(LoginFormsProvider.class)).setUser(user);
        if (Validation.isBlank(totp)) {
            return loginForms.setError("missingTotpMessage", new Object[0]).setClientSessionCode(accessCode.getCode()).createResponse(UserModel.RequiredAction.CONFIGURE_TOTP);
        }
        if (!new TimeBasedOTP().validate(totp, totpSecret.getBytes())) {
            return loginForms.setError("invalidTotpMessage", new Object[0]).setClientSessionCode(accessCode.getCode()).createResponse(UserModel.RequiredAction.CONFIGURE_TOTP);
        }
        UserCredentialModel credentials = new UserCredentialModel();
        credentials.setType("totp");
        credentials.setValue(totpSecret);
        this.session.users().updateCredential(this.realm, user, credentials);
        user.setTotp(true);
        user.removeRequiredAction(UserModel.RequiredAction.CONFIGURE_TOTP);
        this.event.clone().event(EventType.UPDATE_TOTP).success();
        return AuthenticationManager.nextActionAfterAuthentication(this.session, userSession, clientSession, this.clientConnection, this.request, this.uriInfo, this.event);
    }

    @Path(value="password")
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response updatePassword(@QueryParam(value="code") String code, MultivaluedMap<String, String> formData) {
        String actionCookieValue;
        this.event.event(EventType.UPDATE_PASSWORD);
        Checks checks = new Checks();
        if (!checks.check(code, ClientSessionModel.Action.UPDATE_PASSWORD.name(), ClientSessionModel.Action.RECOVER_PASSWORD.name())) {
            return checks.response;
        }
        ClientSessionCode accessCode = checks.clientCode;
        ClientSessionModel clientSession = accessCode.getClientSession();
        UserSessionModel userSession = clientSession.getUserSession();
        UserModel user = userSession.getUser();
        this.initEvent(clientSession);
        String passwordNew = (String)formData.getFirst((Object)"password-new");
        String passwordConfirm = (String)formData.getFirst((Object)"password-confirm");
        LoginFormsProvider loginForms = ((LoginFormsProvider)this.session.getProvider(LoginFormsProvider.class)).setUser(user);
        if (Validation.isBlank(passwordNew)) {
            return loginForms.setError("missingPasswordMessage", new Object[0]).setClientSessionCode(accessCode.getCode()).createResponse(UserModel.RequiredAction.UPDATE_PASSWORD);
        }
        if (!passwordNew.equals(passwordConfirm)) {
            return loginForms.setError("notMatchPasswordMessage", new Object[0]).setClientSessionCode(accessCode.getCode()).createResponse(UserModel.RequiredAction.UPDATE_PASSWORD);
        }
        try {
            this.session.users().updateCredential(this.realm, user, UserCredentialModel.password((String)passwordNew));
        }
        catch (ModelException me) {
            return loginForms.setError(me.getMessage(), me.getParameters()).setClientSessionCode(accessCode.getCode()).createResponse(UserModel.RequiredAction.UPDATE_PASSWORD);
        }
        catch (Exception ape) {
            return loginForms.setError(ape.getMessage(), new Object[0]).setClientSessionCode(accessCode.getCode()).createResponse(UserModel.RequiredAction.UPDATE_PASSWORD);
        }
        user.removeRequiredAction(UserModel.RequiredAction.UPDATE_PASSWORD);
        this.event.event(EventType.UPDATE_PASSWORD).success();
        if (clientSession.getAction().equals(ClientSessionModel.Action.RECOVER_PASSWORD.name()) && ((actionCookieValue = this.getActionCookie()) == null || !actionCookieValue.equals(userSession.getId()))) {
            return ((LoginFormsProvider)this.session.getProvider(LoginFormsProvider.class)).setSuccess("accountPasswordUpdatedMessage", new Object[0]).createInfoPage();
        }
        this.event = this.event.clone().event(EventType.LOGIN);
        return AuthenticationManager.nextActionAfterAuthentication(this.session, userSession, clientSession, this.clientConnection, this.request, this.uriInfo, this.event);
    }

    @Path(value="email-verification")
    @GET
    public Response emailVerification(@QueryParam(value="code") String code, @QueryParam(value="key") String key) {
        this.event.event(EventType.VERIFY_EMAIL);
        if (key != null) {
            Checks checks = new Checks();
            if (!checks.check(key, ClientSessionModel.Action.VERIFY_EMAIL.name())) {
                return checks.response;
            }
            ClientSessionCode accessCode = checks.clientCode;
            ClientSessionModel clientSession = accessCode.getClientSession();
            UserSessionModel userSession = clientSession.getUserSession();
            UserModel user = userSession.getUser();
            this.initEvent(clientSession);
            user.setEmailVerified(true);
            user.removeRequiredAction(UserModel.RequiredAction.VERIFY_EMAIL);
            this.event.event(EventType.VERIFY_EMAIL).detail("email", user.getEmail()).success();
            String actionCookieValue = this.getActionCookie();
            if (actionCookieValue == null || !actionCookieValue.equals(userSession.getId())) {
                return ((LoginFormsProvider)this.session.getProvider(LoginFormsProvider.class)).setSuccess("emailVerifiedMessage", new Object[0]).createInfoPage();
            }
            this.event = this.event.clone().removeDetail("email").event(EventType.LOGIN);
            return AuthenticationManager.nextActionAfterAuthentication(this.session, userSession, clientSession, this.clientConnection, this.request, this.uriInfo, this.event);
        }
        Checks checks = new Checks();
        if (!checks.check(code, ClientSessionModel.Action.VERIFY_EMAIL.name())) {
            return checks.response;
        }
        ClientSessionCode accessCode = checks.clientCode;
        ClientSessionModel clientSession = accessCode.getClientSession();
        UserSessionModel userSession = clientSession.getUserSession();
        this.initEvent(clientSession);
        LoginActionsService.createActionCookie(this.realm, this.uriInfo, this.clientConnection, userSession.getId());
        return ((LoginFormsProvider)this.session.getProvider(LoginFormsProvider.class)).setClientSessionCode(accessCode.getCode()).setUser(userSession.getUser()).createResponse(UserModel.RequiredAction.VERIFY_EMAIL);
    }

    @Path(value="password-reset")
    @GET
    public Response passwordReset(@QueryParam(value="code") String code, @QueryParam(value="key") String key) {
        this.event.event(EventType.RESET_PASSWORD);
        if (key != null) {
            Checks checks = new Checks();
            if (!checks.check(key, ClientSessionModel.Action.RECOVER_PASSWORD.name())) {
                return checks.response;
            }
            ClientSessionCode accessCode = checks.clientCode;
            return ((LoginFormsProvider)this.session.getProvider(LoginFormsProvider.class)).setClientSessionCode(accessCode.getCode()).createResponse(UserModel.RequiredAction.UPDATE_PASSWORD);
        }
        return ((LoginFormsProvider)this.session.getProvider(LoginFormsProvider.class)).setClientSessionCode(code).createPasswordReset();
    }

    @Path(value="password-reset")
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response sendPasswordReset(@QueryParam(value="code") String code, MultivaluedMap<String, String> formData) {
        this.event.event(EventType.SEND_RESET_PASSWORD);
        Checks checks = new Checks();
        if (!checks.check(code)) {
            return checks.response;
        }
        ClientSessionCode accessCode = checks.clientCode;
        ClientSessionModel clientSession = accessCode.getClientSession();
        ClientModel client = clientSession.getClient();
        String username = (String)formData.getFirst((Object)"username");
        if (username == null || username.isEmpty()) {
            this.event.error("username_missing");
            return ((LoginFormsProvider)this.session.getProvider(LoginFormsProvider.class)).setError("missingUsernameMessage", new Object[0]).setClientSessionCode(accessCode.getCode()).createPasswordReset();
        }
        this.event.client(client.getClientId()).detail("redirect_uri", clientSession.getRedirectUri()).detail("response_type", "code").detail("auth_method", "form").detail("username", username);
        UserModel user = this.session.users().getUserByUsername(username, this.realm);
        if (user == null && username.contains("@")) {
            user = this.session.users().getUserByEmail(username, this.realm);
        }
        if (user == null) {
            this.event.error("user_not_found");
        } else if (!user.isEnabled()) {
            this.event.user(user).error("user_disabled");
        } else if (user.getEmail() == null || user.getEmail().trim().length() == 0) {
            this.event.user(user).error("invalid_email");
        } else {
            this.event.user(user);
            UserSessionModel userSession = this.session.sessions().createUserSession(this.realm, user, username, this.clientConnection.getRemoteAddr(), "form", false, null, null);
            this.event.session(userSession);
            TokenManager.attachClientSession(userSession, clientSession);
            accessCode.setAction(ClientSessionModel.Action.RECOVER_PASSWORD.name());
            try {
                UriBuilder builder = Urls.loginPasswordResetBuilder(this.uriInfo.getBaseUri());
                builder.queryParam("key", new Object[]{accessCode.getCode()});
                String link = builder.build(new Object[]{this.realm.getName()}).toString();
                long expiration = TimeUnit.SECONDS.toMinutes(this.realm.getAccessCodeLifespanUserAction());
                ((EmailProvider)this.session.getProvider(EmailProvider.class)).setRealm(this.realm).setUser(user).sendPasswordReset(link, expiration);
                this.event.detail("email", user.getEmail()).detail("code_id", clientSession.getId()).success();
            }
            catch (EmailException e) {
                this.event.error("email_send_failed");
                logger.error((Object)"Failed to send password reset email", (Throwable)e);
                return ((LoginFormsProvider)this.session.getProvider(LoginFormsProvider.class)).setError("emailSendErrorMessage", new Object[0]).setClientSessionCode(accessCode.getCode()).createErrorPage();
            }
            LoginActionsService.createActionCookie(this.realm, this.uriInfo, this.clientConnection, userSession.getId());
        }
        return ((LoginFormsProvider)this.session.getProvider(LoginFormsProvider.class)).setSuccess("emailSentMessage", new Object[0]).setClientSessionCode(accessCode.getCode()).createPasswordReset();
    }

    private String getActionCookie() {
        Cookie cookie = (Cookie)this.headers.getCookies().get(ACTION_COOKIE);
        AuthenticationManager.expireCookie(this.realm, ACTION_COOKIE, AuthenticationManager.getRealmCookiePath(this.realm, this.uriInfo), this.realm.getSslRequired().isRequired(this.clientConnection), this.clientConnection);
        return cookie != null ? cookie.getValue() : null;
    }

    public static void createActionCookie(RealmModel realm, UriInfo uriInfo, ClientConnection clientConnection, String sessionId) {
        CookieHelper.addCookie(ACTION_COOKIE, sessionId, AuthenticationManager.getRealmCookiePath(realm, uriInfo), null, null, -1, realm.getSslRequired().isRequired(clientConnection), true);
    }

    private void initEvent(ClientSessionModel clientSession) {
        this.event.event(EventType.LOGIN).client(clientSession.getClient()).user(clientSession.getUserSession().getUser()).session(clientSession.getUserSession().getId()).detail("code_id", clientSession.getId()).detail("redirect_uri", clientSession.getRedirectUri()).detail("response_type", "code");
        UserSessionModel userSession = clientSession.getUserSession();
        if (userSession != null) {
            this.event.detail("auth_method", userSession.getAuthMethod());
            this.event.detail("username", userSession.getLoginUsername());
            if (userSession.isRememberMe()) {
                this.event.detail("remember_me", "true");
            }
        }
    }

    @Path(value="required-actions/{action}")
    public Object requiredAction(@QueryParam(value="code") String code, @PathParam(value="action") String action) {
        this.event.event(EventType.LOGIN);
        if (action == null) {
            logger.error((Object)"required action was null");
            this.event.error("invalid_code");
            throw new WebApplicationException(ErrorPage.error(this.session, "invalidCodeMessage", new Object[0]));
        }
        RequiredActionProvider provider = (RequiredActionProvider)this.session.getProvider(RequiredActionProvider.class, action);
        if (provider == null) {
            logger.error((Object)"required action provider was null");
            this.event.error("invalid_code");
            throw new WebApplicationException(ErrorPage.error(this.session, "invalidCodeMessage", new Object[0]));
        }
        Checks checks = new Checks();
        if (!checks.check(code, action)) {
            return checks.response;
        }
        ClientSessionCode clientCode = checks.clientCode;
        final ClientSessionModel clientSession = clientCode.getClientSession();
        if (clientSession.getUserSession() == null) {
            logger.error((Object)"user session was null");
            this.event.error("user_session_not_found");
            throw new WebApplicationException(ErrorPage.error(this.session, "sessionNotActiveMessage", new Object[0]));
        }
        RequiredActionContext context = new RequiredActionContext(){

            @Override
            public EventBuilder getEvent() {
                return LoginActionsService.this.event;
            }

            @Override
            public UserModel getUser() {
                return this.getUserSession().getUser();
            }

            @Override
            public RealmModel getRealm() {
                return LoginActionsService.this.realm;
            }

            @Override
            public ClientSessionModel getClientSession() {
                return clientSession;
            }

            @Override
            public UserSessionModel getUserSession() {
                return clientSession.getUserSession();
            }

            @Override
            public ClientConnection getConnection() {
                return LoginActionsService.this.clientConnection;
            }

            @Override
            public UriInfo getUriInfo() {
                return LoginActionsService.this.uriInfo;
            }

            @Override
            public KeycloakSession getSession() {
                return LoginActionsService.this.session;
            }

            @Override
            public HttpRequest getHttpRequest() {
                return LoginActionsService.this.request;
            }

            @Override
            public String generateAccessCode(String action) {
                ClientSessionCode code = new ClientSessionCode(this.getRealm(), this.getClientSession());
                code.setAction(action);
                return code.getCode();
            }
        };
        return provider.jaxrsService(context);
    }

    private class Checks {
        ClientSessionCode clientCode;
        Response response;

        private Checks() {
        }

        boolean check(String code, String requiredAction) {
            if (!this.check(code)) {
                return false;
            }
            if (!this.clientCode.isValidAction(requiredAction)) {
                LoginActionsService.this.event.client(this.clientCode.getClientSession().getClient());
                LoginActionsService.this.event.error("invalid_code");
                this.response = ErrorPage.error(LoginActionsService.this.session, "invalidCodeMessage", new Object[0]);
                return false;
            }
            if (!this.clientCode.isActionActive(requiredAction)) {
                LoginActionsService.this.event.client(this.clientCode.getClientSession().getClient());
                LoginActionsService.this.event.error("expired_code");
                this.response = ErrorPage.error(LoginActionsService.this.session, "invalidCodeMessage", new Object[0]);
                return false;
            }
            return true;
        }

        boolean check(String code, String requiredAction, String alternativeRequiredAction) {
            if (!this.check(code)) {
                return false;
            }
            if (!this.clientCode.isValidAction(requiredAction) && !this.clientCode.isValidAction(alternativeRequiredAction)) {
                LoginActionsService.this.event.client(this.clientCode.getClientSession().getClient());
                LoginActionsService.this.event.error("invalid_code");
                this.response = ErrorPage.error(LoginActionsService.this.session, "invalidCodeMessage", new Object[0]);
                return false;
            }
            if (!this.clientCode.isActionActive(requiredAction) && !this.clientCode.isActionActive(alternativeRequiredAction)) {
                LoginActionsService.this.event.client(this.clientCode.getClientSession().getClient());
                LoginActionsService.this.event.error("expired_code");
                this.response = ErrorPage.error(LoginActionsService.this.session, "invalidCodeMessage", new Object[0]);
                return false;
            }
            return true;
        }

        public boolean check(String code) {
            if (!LoginActionsService.this.checkSsl()) {
                LoginActionsService.this.event.error("ssl_required");
                this.response = ErrorPage.error(LoginActionsService.this.session, "httpsRequiredMessage", new Object[0]);
                return false;
            }
            if (!LoginActionsService.this.realm.isEnabled()) {
                LoginActionsService.this.event.error("realm_disabled");
                this.response = ErrorPage.error(LoginActionsService.this.session, "realmNotEnabledMessage", new Object[0]);
                return false;
            }
            this.clientCode = ClientSessionCode.parse(code, LoginActionsService.this.session, LoginActionsService.this.realm);
            if (this.clientCode == null) {
                LoginActionsService.this.event.error("invalid_code");
                this.response = ErrorPage.error(LoginActionsService.this.session, "invalidCodeMessage", new Object[0]);
                return false;
            }
            ClientSessionModel clientSession = this.clientCode.getClientSession();
            LoginActionsService.this.event.detail("code_id", clientSession.getId());
            ClientModel client = clientSession.getClient();
            if (client == null) {
                LoginActionsService.this.event.error("client_not_found");
                this.response = ErrorPage.error(LoginActionsService.this.session, "unknownLoginRequesterMessage", new Object[0]);
                return false;
            }
            LoginActionsService.this.session.getContext().setClient(client);
            if (!client.isEnabled()) {
                LoginActionsService.this.event.error("client_not_found");
                this.response = ErrorPage.error(LoginActionsService.this.session, "loginRequesterNotEnabledMessage", new Object[0]);
                return false;
            }
            LoginActionsService.this.session.getContext().setClient(this.clientCode.getClientSession().getClient());
            return true;
        }
    }
}

