/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.keycloak.ClientConnection;
import org.keycloak.events.EventListenerProvider;
import org.keycloak.events.EventStoreProvider;
import org.keycloak.events.admin.AdminEvent;
import org.keycloak.events.admin.AuthDetails;
import org.keycloak.events.admin.OperationType;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.services.resources.admin.AdminAuth;
import org.keycloak.util.JsonSerialization;
import org.keycloak.util.Time;

public class AdminEventBuilder {
    private static final Logger log = Logger.getLogger(AdminEventBuilder.class);
    private EventStoreProvider store;
    private List<EventListenerProvider> listeners;
    private RealmModel realm;
    private AdminEvent adminEvent;

    public AdminEventBuilder(RealmModel realm, AdminAuth auth, KeycloakSession session, ClientConnection clientConnection) {
        this.realm = realm;
        this.adminEvent = new AdminEvent();
        if (realm.isAdminEventsEnabled()) {
            EventStoreProvider store = (EventStoreProvider)session.getProvider(EventStoreProvider.class);
            if (store != null) {
                this.store = store;
            } else {
                log.error((Object)"Admin Events enabled, but no event store provider configured");
            }
        }
        if (realm.getEventsListeners() != null && !realm.getEventsListeners().isEmpty()) {
            this.listeners = new LinkedList<EventListenerProvider>();
            for (String id : realm.getEventsListeners()) {
                EventListenerProvider listener = (EventListenerProvider)session.getProvider(EventListenerProvider.class, id);
                if (listener != null) {
                    this.listeners.add(listener);
                    continue;
                }
                log.error((Object)("Event listener '" + id + "' registered, but provider not found"));
            }
        }
        this.authRealm(auth.getRealm());
        this.authClient(auth.getClient());
        this.authUser(auth.getUser());
        this.authIpAddress(clientConnection.getRemoteAddr());
    }

    public AdminEventBuilder realm(RealmModel realm) {
        this.adminEvent.setRealmId(realm.getId());
        return this;
    }

    public AdminEventBuilder realm(String realmId) {
        this.adminEvent.setRealmId(realmId);
        return this;
    }

    public AdminEventBuilder operation(OperationType e) {
        this.adminEvent.setOperationType(e);
        return this;
    }

    public AdminEventBuilder authRealm(RealmModel realm) {
        AuthDetails authDetails = this.adminEvent.getAuthDetails();
        if (authDetails == null) {
            authDetails = new AuthDetails();
            authDetails.setRealmId(realm.getId());
        } else {
            authDetails.setRealmId(realm.getId());
        }
        this.adminEvent.setAuthDetails(authDetails);
        return this;
    }

    public AdminEventBuilder authClient(ClientModel client) {
        AuthDetails authDetails = this.adminEvent.getAuthDetails();
        if (authDetails == null) {
            authDetails = new AuthDetails();
            authDetails.setClientId(client.getId());
        } else {
            authDetails.setClientId(client.getId());
        }
        this.adminEvent.setAuthDetails(authDetails);
        return this;
    }

    public AdminEventBuilder authUser(UserModel user) {
        AuthDetails authDetails = this.adminEvent.getAuthDetails();
        if (authDetails == null) {
            authDetails = new AuthDetails();
            authDetails.setUserId(user.getId());
        } else {
            authDetails.setUserId(user.getId());
        }
        this.adminEvent.setAuthDetails(authDetails);
        return this;
    }

    public AdminEventBuilder authIpAddress(String ipAddress) {
        AuthDetails authDetails = this.adminEvent.getAuthDetails();
        if (authDetails == null) {
            authDetails = new AuthDetails();
            authDetails.setIpAddress(ipAddress);
        } else {
            authDetails.setIpAddress(ipAddress);
        }
        this.adminEvent.setAuthDetails(authDetails);
        return this;
    }

    public AdminEventBuilder resourcePath(UriInfo uriInfo) {
        String path = this.getResourcePath(uriInfo);
        this.adminEvent.setResourcePath(path);
        return this;
    }

    public AdminEventBuilder resourcePath(UriInfo uriInfo, String id) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getResourcePath(uriInfo));
        sb.append("/");
        sb.append(id);
        this.adminEvent.setResourcePath(sb.toString());
        return this;
    }

    private String getResourcePath(UriInfo uriInfo) {
        String path = uriInfo.getPath();
        StringBuilder sb = new StringBuilder();
        sb.append("/realms/");
        sb.append(this.realm.getName());
        sb.append("/");
        String realmRelative = sb.toString();
        return path.substring(path.indexOf(realmRelative) + realmRelative.length());
    }

    public void error(String error) {
        this.adminEvent.setOperationType(OperationType.valueOf((String)(this.adminEvent.getOperationType().name() + "_ERROR")));
        this.adminEvent.setError(error);
        this.send();
    }

    public AdminEventBuilder representation(Object value) {
        if (value == null || value.equals("")) {
            return this;
        }
        try {
            this.adminEvent.setRepresentation(JsonSerialization.writeValueAsString((Object)value));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public AdminEvent getEvent() {
        return this.adminEvent;
    }

    public void success() {
        this.send();
    }

    private void send() {
        boolean includeRepresentation = false;
        if (this.realm.isAdminEventsDetailsEnabled()) {
            includeRepresentation = true;
        }
        this.adminEvent.setTime(Time.toMillis((int)Time.currentTime()));
        if (this.store != null) {
            try {
                this.store.onEvent(this.adminEvent, includeRepresentation);
            }
            catch (Throwable t) {
                log.error((Object)"Failed to save event", t);
            }
        }
        if (this.listeners != null) {
            for (EventListenerProvider l : this.listeners) {
                try {
                    l.onEvent(this.adminEvent, includeRepresentation);
                }
                catch (Throwable t) {
                    log.error((Object)("Failed to send type to " + l), t);
                }
            }
        }
    }
}

