/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import java.net.URI;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.jboss.resteasy.spi.NotFoundException;
import org.keycloak.events.admin.OperationType;
import org.keycloak.mappers.MapperConfigValidationException;
import org.keycloak.mappers.UserFederationMapper;
import org.keycloak.mappers.UserFederationMapperFactory;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserFederationMapperModel;
import org.keycloak.models.UserFederationProviderModel;
import org.keycloak.models.UserFederationSyncResult;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.models.utils.RepresentationToModel;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.provider.ProviderFactory;
import org.keycloak.representations.idm.ConfigPropertyRepresentation;
import org.keycloak.representations.idm.UserFederationMapperRepresentation;
import org.keycloak.representations.idm.UserFederationMapperTypeRepresentation;
import org.keycloak.representations.idm.UserFederationProviderRepresentation;
import org.keycloak.services.ErrorResponseException;
import org.keycloak.services.managers.UsersSyncManager;
import org.keycloak.services.resources.admin.AdminEventBuilder;
import org.keycloak.services.resources.admin.RealmAuth;
import org.keycloak.timer.TimerProvider;

public class UserFederationProviderResource {
    protected static final Logger logger = Logger.getLogger(UserFederationProviderResource.class);
    private final KeycloakSession session;
    private final RealmModel realm;
    private final RealmAuth auth;
    private final UserFederationProviderModel federationProviderModel;
    private final AdminEventBuilder adminEvent;
    @Context
    private UriInfo uriInfo;

    public UserFederationProviderResource(KeycloakSession session, RealmModel realm, RealmAuth auth, UserFederationProviderModel federationProviderModel, AdminEventBuilder adminEvent) {
        this.session = session;
        this.realm = realm;
        this.auth = auth;
        this.federationProviderModel = federationProviderModel;
        this.adminEvent = adminEvent;
    }

    @PUT
    @NoCache
    @Consumes(value={"application/json"})
    public void updateProviderInstance(UserFederationProviderRepresentation rep) {
        this.auth.requireManage();
        String displayName = rep.getDisplayName();
        if (displayName != null && displayName.trim().equals("")) {
            displayName = null;
        }
        UserFederationProviderModel model = new UserFederationProviderModel(rep.getId(), rep.getProviderName(), rep.getConfig(), rep.getPriority(), displayName, rep.getFullSyncPeriod(), rep.getChangedSyncPeriod(), rep.getLastSync());
        this.realm.updateUserFederationProvider(model);
        new UsersSyncManager().refreshPeriodicSyncForProvider(this.session.getKeycloakSessionFactory(), (TimerProvider)this.session.getProvider(TimerProvider.class), model, this.realm.getId());
        boolean kerberosCredsAdded = KeycloakModelUtils.checkKerberosCredential((RealmModel)this.realm, (UserFederationProviderModel)model);
        if (kerberosCredsAdded) {
            logger.info((Object)"Added 'kerberos' to required realm credentials");
        }
        this.adminEvent.operation(OperationType.UPDATE).resourcePath(this.uriInfo).representation(rep).success();
    }

    @GET
    @NoCache
    @Produces(value={"application/json"})
    public UserFederationProviderRepresentation getProviderInstance() {
        this.auth.requireView();
        return ModelToRepresentation.toRepresentation((UserFederationProviderModel)this.federationProviderModel);
    }

    @DELETE
    @NoCache
    public void deleteProviderInstance() {
        this.auth.requireManage();
        this.realm.removeUserFederationProvider(this.federationProviderModel);
        new UsersSyncManager().removePeriodicSyncForProvider((TimerProvider)this.session.getProvider(TimerProvider.class), this.federationProviderModel);
        this.adminEvent.operation(OperationType.DELETE).resourcePath(this.uriInfo).success();
    }

    @POST
    @Path(value="sync")
    @NoCache
    public UserFederationSyncResult syncUsers(@QueryParam(value="action") String action) {
        logger.debug((Object)"Syncing users");
        this.auth.requireManage();
        UsersSyncManager syncManager = new UsersSyncManager();
        UserFederationSyncResult syncResult = null;
        if ("triggerFullSync".equals(action)) {
            syncResult = syncManager.syncAllUsers(this.session.getKeycloakSessionFactory(), this.realm.getId(), this.federationProviderModel);
        } else if ("triggerChangedUsersSync".equals(action)) {
            syncResult = syncManager.syncChangedUsers(this.session.getKeycloakSessionFactory(), this.realm.getId(), this.federationProviderModel);
        }
        this.adminEvent.operation(OperationType.ACTION).resourcePath(this.uriInfo).success();
        return syncResult;
    }

    @GET
    @Path(value="mapper-types")
    @NoCache
    public Map<String, UserFederationMapperTypeRepresentation> getMapperTypes() {
        this.auth.requireView();
        KeycloakSessionFactory sessionFactory = this.session.getKeycloakSessionFactory();
        HashMap<String, UserFederationMapperTypeRepresentation> types = new HashMap<String, UserFederationMapperTypeRepresentation>();
        List factories = sessionFactory.getProviderFactories(UserFederationMapper.class);
        for (ProviderFactory factory : factories) {
            UserFederationMapperFactory mapperFactory = (UserFederationMapperFactory)factory;
            if (!mapperFactory.getFederationProviderType().equals(this.federationProviderModel.getProviderName())) continue;
            UserFederationMapperTypeRepresentation rep = new UserFederationMapperTypeRepresentation();
            rep.setId(mapperFactory.getId());
            rep.setCategory(mapperFactory.getDisplayCategory());
            rep.setName(mapperFactory.getDisplayType());
            rep.setHelpText(mapperFactory.getHelpText());
            List configProperties = mapperFactory.getConfigProperties();
            for (ProviderConfigProperty prop : configProperties) {
                ConfigPropertyRepresentation propRep = new ConfigPropertyRepresentation();
                propRep.setName(prop.getName());
                propRep.setLabel(prop.getLabel());
                propRep.setType(prop.getType());
                propRep.setDefaultValue(prop.getDefaultValue());
                propRep.setHelpText(prop.getHelpText());
                rep.getProperties().add(propRep);
            }
            types.put(rep.getId(), rep);
        }
        return types;
    }

    @GET
    @Path(value="mappers")
    @Produces(value={"application/json"})
    @NoCache
    public List<UserFederationMapperRepresentation> getMappers() {
        this.auth.requireView();
        LinkedList<UserFederationMapperRepresentation> mappers = new LinkedList<UserFederationMapperRepresentation>();
        for (UserFederationMapperModel model : this.realm.getUserFederationMappersByFederationProvider(this.federationProviderModel.getId())) {
            mappers.add(ModelToRepresentation.toRepresentation((RealmModel)this.realm, (UserFederationMapperModel)model));
        }
        Collections.sort(mappers, new Comparator<UserFederationMapperRepresentation>(){

            @Override
            public int compare(UserFederationMapperRepresentation o1, UserFederationMapperRepresentation o2) {
                UserFederationMapperFactory factory1 = (UserFederationMapperFactory)UserFederationProviderResource.this.session.getKeycloakSessionFactory().getProviderFactory(UserFederationMapper.class, o1.getFederationMapperType());
                UserFederationMapperFactory factory2 = (UserFederationMapperFactory)UserFederationProviderResource.this.session.getKeycloakSessionFactory().getProviderFactory(UserFederationMapper.class, o2.getFederationMapperType());
                int compare = factory1.getDisplayCategory().compareTo(factory2.getDisplayCategory());
                if (compare != 0) {
                    return compare;
                }
                compare = factory1.getDisplayType().compareTo(factory2.getDisplayType());
                if (compare != 0) {
                    return compare;
                }
                compare = o1.getName().compareTo(o2.getName());
                return compare;
            }
        });
        return mappers;
    }

    @POST
    @Path(value="mappers")
    @Consumes(value={"application/json"})
    public Response addMapper(UserFederationMapperRepresentation mapper) {
        this.auth.requireManage();
        UserFederationMapperModel model = RepresentationToModel.toModel((RealmModel)this.realm, (UserFederationMapperRepresentation)mapper);
        this.validateModel(model);
        model = this.realm.addUserFederationMapper(model);
        this.adminEvent.operation(OperationType.CREATE).resourcePath(this.uriInfo, model.getId()).representation(mapper).success();
        return Response.created((URI)this.uriInfo.getAbsolutePathBuilder().path(model.getId()).build(new Object[0])).build();
    }

    @GET
    @NoCache
    @Path(value="mappers/{id}")
    @Produces(value={"application/json"})
    public UserFederationMapperRepresentation getMapperById(@PathParam(value="id") String id) {
        this.auth.requireView();
        UserFederationMapperModel model = this.realm.getUserFederationMapperById(id);
        if (model == null) {
            throw new NotFoundException("Model not found");
        }
        return ModelToRepresentation.toRepresentation((RealmModel)this.realm, (UserFederationMapperModel)model);
    }

    @PUT
    @NoCache
    @Path(value="mappers/{id}")
    @Consumes(value={"application/json"})
    public void update(@PathParam(value="id") String id, UserFederationMapperRepresentation rep) {
        this.auth.requireManage();
        UserFederationMapperModel model = this.realm.getUserFederationMapperById(id);
        if (model == null) {
            throw new NotFoundException("Model not found");
        }
        model = RepresentationToModel.toModel((RealmModel)this.realm, (UserFederationMapperRepresentation)rep);
        this.validateModel(model);
        this.realm.updateUserFederationMapper(model);
        this.adminEvent.operation(OperationType.UPDATE).resourcePath(this.uriInfo).representation(rep).success();
    }

    @DELETE
    @NoCache
    @Path(value="mappers/{id}")
    public void delete(@PathParam(value="id") String id) {
        this.auth.requireManage();
        UserFederationMapperModel model = this.realm.getUserFederationMapperById(id);
        if (model == null) {
            throw new NotFoundException("Model not found");
        }
        this.realm.removeUserFederationMapper(model);
        this.adminEvent.operation(OperationType.DELETE).resourcePath(this.uriInfo).success();
    }

    private void validateModel(UserFederationMapperModel model) {
        try {
            UserFederationMapperFactory mapperFactory = (UserFederationMapperFactory)this.session.getKeycloakSessionFactory().getProviderFactory(UserFederationMapper.class, model.getFederationMapperType());
            mapperFactory.validateConfig(model);
        }
        catch (MapperConfigValidationException ex) {
            throw new ErrorResponseException("Validation error", ex.getMessage(), Response.Status.BAD_REQUEST);
        }
    }
}

