/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.broker.saml.mappers;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.keycloak.broker.provider.AbstractIdentityProviderMapper;
import org.keycloak.broker.provider.BrokeredIdentityContext;
import org.keycloak.dom.saml.v2.assertion.AssertionType;
import org.keycloak.dom.saml.v2.assertion.AttributeStatementType;
import org.keycloak.dom.saml.v2.assertion.AttributeType;
import org.keycloak.dom.saml.v2.assertion.NameIDType;
import org.keycloak.dom.saml.v2.assertion.SubjectType;
import org.keycloak.models.IdentityProviderMapperModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.provider.ProviderConfigProperty;

public class UsernameTemplateMapper
extends AbstractIdentityProviderMapper {
    public static final String[] COMPATIBLE_PROVIDERS = new String[]{"saml"};
    private static final List<ProviderConfigProperty> configProperties = new ArrayList<ProviderConfigProperty>();
    public static final String TEMPLATE = "template";
    public static final String PROVIDER_ID = "saml-username-idp-mapper";
    static Pattern substitution;

    public List<ProviderConfigProperty> getConfigProperties() {
        return configProperties;
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public String[] getCompatibleProviders() {
        return COMPATIBLE_PROVIDERS;
    }

    public String getDisplayCategory() {
        return "Preprocessor";
    }

    public String getDisplayType() {
        return "Username Template Importer";
    }

    public void importNewUser(KeycloakSession session, RealmModel realm, UserModel user, IdentityProviderMapperModel mapperModel, BrokeredIdentityContext context) {
    }

    public void updateBrokeredUser(KeycloakSession session, RealmModel realm, UserModel user, IdentityProviderMapperModel mapperModel, BrokeredIdentityContext context) {
    }

    public void preprocessFederatedIdentity(KeycloakSession session, RealmModel realm, IdentityProviderMapperModel mapperModel, BrokeredIdentityContext context) {
        AssertionType assertion = (AssertionType)context.getContextData().get("SAML_ASSERTION");
        String template = (String)mapperModel.getConfig().get(TEMPLATE);
        Matcher m = substitution.matcher(template);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String variable = m.group(1);
            if (variable.equals("ALIAS")) {
                m.appendReplacement(sb, context.getIdpConfig().getAlias());
                continue;
            }
            if (variable.equals("UUID")) {
                m.appendReplacement(sb, KeycloakModelUtils.generateId());
                continue;
            }
            if (variable.equals("NAMEID")) {
                SubjectType subject = assertion.getSubject();
                SubjectType.STSubType subType = subject.getSubType();
                NameIDType subjectNameID = (NameIDType)subType.getBaseID();
                m.appendReplacement(sb, subjectNameID.getValue());
                continue;
            }
            if (variable.startsWith("ATTRIBUTE.")) {
                String name = variable.substring("ATTRIBUTE.".length());
                String value = "";
                block1: for (AttributeStatementType statement : assertion.getAttributeStatements()) {
                    for (AttributeStatementType.ASTChoiceType choice : statement.getAttributes()) {
                        AttributeType attr = choice.getAttribute();
                        if (!name.equals(attr.getName()) && !name.equals(attr.getFriendlyName())) continue;
                        List attributeValue = attr.getAttributeValue();
                        if (attributeValue == null || attributeValue.isEmpty()) continue block1;
                        value = attributeValue.get(0).toString();
                        continue block1;
                    }
                }
                m.appendReplacement(sb, value);
                continue;
            }
            m.appendReplacement(sb, m.group(1));
        }
        m.appendTail(sb);
        context.setModelUsername(sb.toString());
    }

    public String getHelpText() {
        return "Format the username to import.";
    }

    static {
        ProviderConfigProperty property = new ProviderConfigProperty();
        property.setName(TEMPLATE);
        property.setLabel("Template");
        property.setHelpText("Template to use to format the username to import.  Substitutions are enclosed in ${}.  For example: '${ALIAS}.${NAMEID}'.  ALIAS is the provider alias.  NAMEID is that SAML name id assertion.  ATTRIBUTE.<NAME> references a SAML attribute where name is the attribute name or friendly name.");
        property.setType("String");
        property.setDefaultValue((Object)"${ALIAS}.${NAMEID}");
        configProperties.add(property);
        substitution = Pattern.compile("\\$\\{([^}]+)\\}");
    }
}

