/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.representations;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonProperty;
import org.keycloak.representations.IDToken;

public class AccessToken
extends IDToken {
    @JsonProperty(value="client_session")
    protected String clientSession;
    @JsonProperty(value="trusted-certs")
    protected Set<String> trustedCertificates;
    @JsonProperty(value="allowed-origins")
    protected Set<String> allowedOrigins;
    @JsonProperty(value="realm_access")
    protected Access realmAccess;
    @JsonProperty(value="resource_access")
    protected Map<String, Access> resourceAccess = new HashMap<String, Access>();

    public Map<String, Access> getResourceAccess() {
        return this.resourceAccess;
    }

    public void setResourceAccess(Map<String, Access> resourceAccess) {
        this.resourceAccess = resourceAccess;
    }

    @JsonIgnore
    public boolean isVerifyCaller() {
        if (this.getRealmAccess() != null && this.getRealmAccess().getVerifyCaller() != null) {
            return this.getRealmAccess().getVerifyCaller();
        }
        return false;
    }

    @JsonIgnore
    public boolean isVerifyCaller(String resource) {
        Access access = this.getResourceAccess(resource);
        if (access != null && access.getVerifyCaller() != null) {
            return access.getVerifyCaller();
        }
        return false;
    }

    @JsonIgnore
    public Access getResourceAccess(String resource) {
        return this.resourceAccess.get(resource);
    }

    public String getClientSession() {
        return this.clientSession;
    }

    public Access addAccess(String service) {
        Access access = this.resourceAccess.get(service);
        if (access != null) {
            return access;
        }
        access = new Access();
        this.resourceAccess.put(service, access);
        return access;
    }

    public AccessToken clientSession(String session) {
        this.clientSession = session;
        return this;
    }

    @Override
    public AccessToken id(String id) {
        return (AccessToken)super.id(id);
    }

    @Override
    public AccessToken expiration(int expiration) {
        return (AccessToken)super.expiration(expiration);
    }

    @Override
    public AccessToken notBefore(int notBefore) {
        return (AccessToken)super.notBefore(notBefore);
    }

    @Override
    public AccessToken issuedAt(int issuedAt) {
        return (AccessToken)super.issuedAt(issuedAt);
    }

    @Override
    public AccessToken issuer(String issuer) {
        return (AccessToken)super.issuer(issuer);
    }

    @Override
    public AccessToken audience(String audience) {
        return (AccessToken)super.audience(audience);
    }

    @Override
    public AccessToken subject(String subject) {
        return (AccessToken)super.subject(subject);
    }

    @Override
    public AccessToken type(String type) {
        return (AccessToken)super.type(type);
    }

    public Set<String> getAllowedOrigins() {
        return this.allowedOrigins;
    }

    public void setAllowedOrigins(Set<String> allowedOrigins) {
        this.allowedOrigins = allowedOrigins;
    }

    public Access getRealmAccess() {
        return this.realmAccess;
    }

    public void setRealmAccess(Access realmAccess) {
        this.realmAccess = realmAccess;
    }

    public Set<String> getTrustedCertificates() {
        return this.trustedCertificates;
    }

    public void setTrustedCertificates(Set<String> trustedCertificates) {
        this.trustedCertificates = trustedCertificates;
    }

    @Override
    public AccessToken issuedFor(String issuedFor) {
        return (AccessToken)super.issuedFor(issuedFor);
    }

    public static class Access
    implements Serializable {
        @JsonProperty(value="roles")
        protected Set<String> roles;
        @JsonProperty(value="verify_caller")
        protected Boolean verifyCaller;

        public Access clone() {
            Access access = new Access();
            access.verifyCaller = this.verifyCaller;
            if (this.roles != null) {
                access.roles = new HashSet<String>();
                access.roles.addAll(this.roles);
            }
            return access;
        }

        public Set<String> getRoles() {
            return this.roles;
        }

        public Access roles(Set<String> roles) {
            this.roles = roles;
            return this;
        }

        @JsonIgnore
        public boolean isUserInRole(String role) {
            if (this.roles == null) {
                return false;
            }
            return this.roles.contains(role);
        }

        public Access addRole(String role) {
            if (this.roles == null) {
                this.roles = new HashSet<String>();
            }
            this.roles.add(role);
            return this;
        }

        public Boolean getVerifyCaller() {
            return this.verifyCaller;
        }

        public Access verifyCaller(Boolean required) {
            this.verifyCaller = required;
            return this;
        }
    }
}

