/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.jpa;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.keycloak.models.ClientModel;
import org.keycloak.models.CredentialValidationOutput;
import org.keycloak.models.FederatedIdentityModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserFederationProviderModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserProvider;
import org.keycloak.models.jpa.UserAdapter;
import org.keycloak.models.jpa.entities.FederatedIdentityEntity;
import org.keycloak.models.jpa.entities.UserEntity;
import org.keycloak.models.utils.CredentialValidation;
import org.keycloak.models.utils.KeycloakModelUtils;

public class JpaUserProvider
implements UserProvider {
    private static final String EMAIL = "email";
    private static final String USERNAME = "username";
    private static final String FIRST_NAME = "firstName";
    private static final String LAST_NAME = "lastName";
    private final KeycloakSession session;
    protected EntityManager em;

    public JpaUserProvider(KeycloakSession session, EntityManager em) {
        this.session = session;
        this.em = em;
    }

    public UserModel addUser(RealmModel realm, String id, String username, boolean addDefaultRoles, boolean addDefaultRequiredActions) {
        if (id == null) {
            id = KeycloakModelUtils.generateId();
        }
        UserEntity entity = new UserEntity();
        entity.setId(id);
        entity.setCreatedTimestamp(System.currentTimeMillis());
        entity.setUsername(username.toLowerCase());
        entity.setRealmId(realm.getId());
        this.em.persist((Object)entity);
        this.em.flush();
        UserAdapter userModel = new UserAdapter(realm, this.em, entity);
        if (addDefaultRoles) {
            for (String r : realm.getDefaultRoles()) {
                userModel.grantRole(realm.getRole(r));
            }
            for (ClientModel application : realm.getClients()) {
                for (String r : application.getDefaultRoles()) {
                    userModel.grantRole(application.getRole(r));
                }
            }
        }
        for (String r : realm.getRequiredActionProviders()) {
            if (!r.isEnabled() || !r.isDefaultAction()) continue;
            userModel.addRequiredAction(r.getAlias());
        }
        return userModel;
    }

    public UserModel addUser(RealmModel realm, String username) {
        return this.addUser(realm, KeycloakModelUtils.generateId(), username.toLowerCase(), true, true);
    }

    public boolean removeUser(RealmModel realm, UserModel user) {
        UserEntity userEntity = (UserEntity)this.em.find(UserEntity.class, (Object)user.getId());
        if (userEntity == null) {
            return false;
        }
        this.removeUser(userEntity);
        return true;
    }

    private void removeUser(UserEntity user) {
        String id = user.getId();
        this.em.createNamedQuery("deleteUserRoleMappingsByUser").setParameter("user", (Object)user).executeUpdate();
        this.em.createNamedQuery("deleteFederatedIdentityByUser").setParameter("user", (Object)user).executeUpdate();
        this.em.createNamedQuery("deleteUserConsentRolesByUser").setParameter("user", (Object)user).executeUpdate();
        this.em.createNamedQuery("deleteUserConsentProtMappersByUser").setParameter("user", (Object)user).executeUpdate();
        this.em.createNamedQuery("deleteUserConsentsByUser").setParameter("user", (Object)user).executeUpdate();
        this.em.flush();
        this.em.clear();
        user = (UserEntity)this.em.find(UserEntity.class, (Object)id);
        if (user != null) {
            this.em.remove((Object)user);
        }
        this.em.flush();
    }

    public void addFederatedIdentity(RealmModel realm, UserModel user, FederatedIdentityModel identity) {
        FederatedIdentityEntity entity = new FederatedIdentityEntity();
        entity.setRealmId(realm.getId());
        entity.setIdentityProvider(identity.getIdentityProvider());
        entity.setUserId(identity.getUserId());
        entity.setUserName(identity.getUserName().toLowerCase());
        entity.setToken(identity.getToken());
        UserEntity userEntity = (UserEntity)this.em.getReference(UserEntity.class, (Object)user.getId());
        entity.setUser(userEntity);
        this.em.persist((Object)entity);
        this.em.flush();
    }

    public void updateFederatedIdentity(RealmModel realm, UserModel federatedUser, FederatedIdentityModel federatedIdentityModel) {
        FederatedIdentityEntity federatedIdentity = this.findFederatedIdentity(federatedUser, federatedIdentityModel.getIdentityProvider());
        federatedIdentity.setToken(federatedIdentityModel.getToken());
        this.em.persist((Object)federatedIdentity);
        this.em.flush();
    }

    public boolean removeFederatedIdentity(RealmModel realm, UserModel user, String identityProvider) {
        FederatedIdentityEntity entity = this.findFederatedIdentity(user, identityProvider);
        if (entity != null) {
            this.em.remove((Object)entity);
            this.em.flush();
            return true;
        }
        return false;
    }

    public void preRemove(RealmModel realm) {
        int num = this.em.createNamedQuery("deleteUserConsentRolesByRealm").setParameter("realmId", (Object)realm.getId()).executeUpdate();
        num = this.em.createNamedQuery("deleteUserConsentProtMappersByRealm").setParameter("realmId", (Object)realm.getId()).executeUpdate();
        num = this.em.createNamedQuery("deleteUserConsentsByRealm").setParameter("realmId", (Object)realm.getId()).executeUpdate();
        num = this.em.createNamedQuery("deleteUserRoleMappingsByRealm").setParameter("realmId", (Object)realm.getId()).executeUpdate();
        num = this.em.createNamedQuery("deleteUserRequiredActionsByRealm").setParameter("realmId", (Object)realm.getId()).executeUpdate();
        num = this.em.createNamedQuery("deleteFederatedIdentityByRealm").setParameter("realmId", (Object)realm.getId()).executeUpdate();
        num = this.em.createNamedQuery("deleteCredentialsByRealm").setParameter("realmId", (Object)realm.getId()).executeUpdate();
        num = this.em.createNamedQuery("deleteUserAttributesByRealm").setParameter("realmId", (Object)realm.getId()).executeUpdate();
        num = this.em.createNamedQuery("deleteUsersByRealm").setParameter("realmId", (Object)realm.getId()).executeUpdate();
    }

    public void preRemove(RealmModel realm, UserFederationProviderModel link) {
        int num = this.em.createNamedQuery("deleteUserRoleMappingsByRealmAndLink").setParameter("realmId", (Object)realm.getId()).setParameter("link", (Object)link.getId()).executeUpdate();
        num = this.em.createNamedQuery("deleteUserRequiredActionsByRealmAndLink").setParameter("realmId", (Object)realm.getId()).setParameter("link", (Object)link.getId()).executeUpdate();
        num = this.em.createNamedQuery("deleteFederatedIdentityByRealmAndLink").setParameter("realmId", (Object)realm.getId()).setParameter("link", (Object)link.getId()).executeUpdate();
        num = this.em.createNamedQuery("deleteCredentialsByRealmAndLink").setParameter("realmId", (Object)realm.getId()).setParameter("link", (Object)link.getId()).executeUpdate();
        num = this.em.createNamedQuery("deleteUserAttributesByRealmAndLink").setParameter("realmId", (Object)realm.getId()).setParameter("link", (Object)link.getId()).executeUpdate();
        num = this.em.createNamedQuery("deleteUsersByRealmAndLink").setParameter("realmId", (Object)realm.getId()).setParameter("link", (Object)link.getId()).executeUpdate();
    }

    public void preRemove(RealmModel realm, RoleModel role) {
        this.em.createNamedQuery("deleteUserConsentRolesByRole").setParameter("roleId", (Object)role.getId()).executeUpdate();
        this.em.createNamedQuery("deleteUserRoleMappingsByRole").setParameter("roleId", (Object)role.getId()).executeUpdate();
    }

    public void preRemove(RealmModel realm, ClientModel client) {
        this.em.createNamedQuery("deleteUserConsentProtMappersByClient").setParameter("clientId", (Object)client.getId()).executeUpdate();
        this.em.createNamedQuery("deleteUserConsentRolesByClient").setParameter("clientId", (Object)client.getId()).executeUpdate();
        this.em.createNamedQuery("deleteUserConsentsByClient").setParameter("clientId", (Object)client.getId()).executeUpdate();
    }

    public void preRemove(ClientModel client, ProtocolMapperModel protocolMapper) {
        this.em.createNamedQuery("deleteUserConsentProtMappersByProtocolMapper").setParameter("protocolMapperId", (Object)protocolMapper.getId()).executeUpdate();
    }

    public UserModel getUserById(String id, RealmModel realm) {
        TypedQuery query = this.em.createNamedQuery("getRealmUserById", UserEntity.class);
        query.setParameter("id", (Object)id);
        query.setParameter("realmId", (Object)realm.getId());
        List entities = query.getResultList();
        if (entities.size() == 0) {
            return null;
        }
        return new UserAdapter(realm, this.em, (UserEntity)entities.get(0));
    }

    public UserModel getUserByUsername(String username, RealmModel realm) {
        TypedQuery query = this.em.createNamedQuery("getRealmUserByUsername", UserEntity.class);
        query.setParameter(USERNAME, (Object)username.toLowerCase());
        query.setParameter("realmId", (Object)realm.getId());
        List results = query.getResultList();
        if (results.size() == 0) {
            return null;
        }
        return new UserAdapter(realm, this.em, (UserEntity)results.get(0));
    }

    public UserModel getUserByEmail(String email, RealmModel realm) {
        TypedQuery query = this.em.createNamedQuery("getRealmUserByEmail", UserEntity.class);
        query.setParameter(EMAIL, (Object)email.toLowerCase());
        query.setParameter("realmId", (Object)realm.getId());
        List results = query.getResultList();
        return results.isEmpty() ? null : new UserAdapter(realm, this.em, (UserEntity)results.get(0));
    }

    public void close() {
    }

    public UserModel getUserByFederatedIdentity(FederatedIdentityModel identity, RealmModel realm) {
        TypedQuery query = this.em.createNamedQuery("findUserByFederatedIdentityAndRealm", UserEntity.class);
        query.setParameter("realmId", (Object)realm.getId());
        query.setParameter("identityProvider", (Object)identity.getIdentityProvider());
        query.setParameter("userId", (Object)identity.getUserId());
        List results = query.getResultList();
        if (results.isEmpty()) {
            return null;
        }
        if (results.size() > 1) {
            throw new IllegalStateException("More results found for identityProvider=" + identity.getIdentityProvider() + ", userId=" + identity.getUserId() + ", results=" + results);
        }
        UserEntity user = (UserEntity)results.get(0);
        return new UserAdapter(realm, this.em, user);
    }

    public UserModel getUserByServiceAccountClient(ClientModel client) {
        TypedQuery query = this.em.createNamedQuery("getRealmUserByServiceAccount", UserEntity.class);
        query.setParameter("realmId", (Object)client.getRealm().getId());
        query.setParameter("clientInternalId", (Object)client.getId());
        List results = query.getResultList();
        if (results.isEmpty()) {
            return null;
        }
        if (results.size() > 1) {
            throw new IllegalStateException("More service account linked users found for client=" + client.getClientId() + ", results=" + results);
        }
        UserEntity user = (UserEntity)results.get(0);
        return new UserAdapter(client.getRealm(), this.em, user);
    }

    public List<UserModel> getUsers(RealmModel realm, boolean includeServiceAccounts) {
        return this.getUsers(realm, -1, -1, includeServiceAccounts);
    }

    public int getUsersCount(RealmModel realm) {
        Object count = this.em.createNamedQuery("getRealmUserCount").setParameter("realmId", (Object)realm.getId()).getSingleResult();
        return ((Number)count).intValue();
    }

    public List<UserModel> getUsers(RealmModel realm, int firstResult, int maxResults, boolean includeServiceAccounts) {
        String queryName = includeServiceAccounts ? "getAllUsersByRealm" : "getAllUsersByRealmExcludeServiceAccount";
        TypedQuery query = this.em.createNamedQuery(queryName, UserEntity.class);
        query.setParameter("realmId", (Object)realm.getId());
        if (firstResult != -1) {
            query.setFirstResult(firstResult);
        }
        if (maxResults != -1) {
            query.setMaxResults(maxResults);
        }
        List results = query.getResultList();
        ArrayList<UserModel> users = new ArrayList<UserModel>();
        for (UserEntity entity : results) {
            users.add(new UserAdapter(realm, this.em, entity));
        }
        return users;
    }

    public List<UserModel> searchForUser(String search, RealmModel realm) {
        return this.searchForUser(search, realm, -1, -1);
    }

    public List<UserModel> searchForUser(String search, RealmModel realm, int firstResult, int maxResults) {
        TypedQuery query = this.em.createNamedQuery("searchForUser", UserEntity.class);
        query.setParameter("realmId", (Object)realm.getId());
        query.setParameter("search", (Object)("%" + search.toLowerCase() + "%"));
        if (firstResult != -1) {
            query.setFirstResult(firstResult);
        }
        if (maxResults != -1) {
            query.setMaxResults(maxResults);
        }
        List results = query.getResultList();
        ArrayList<UserModel> users = new ArrayList<UserModel>();
        for (UserEntity entity : results) {
            users.add(new UserAdapter(realm, this.em, entity));
        }
        return users;
    }

    public List<UserModel> searchForUserByAttributes(Map<String, String> attributes, RealmModel realm) {
        return this.searchForUserByAttributes(attributes, realm, -1, -1);
    }

    public List<UserModel> searchForUserByAttributes(Map<String, String> attributes, RealmModel realm, int firstResult, int maxResults) {
        StringBuilder builder = new StringBuilder("select u from UserEntity u where u.realmId = :realmId");
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            String attribute = null;
            String parameterName = null;
            if (entry.getKey().equals(USERNAME)) {
                attribute = "lower(u.username)";
                parameterName = USERNAME;
            } else if (entry.getKey().equalsIgnoreCase(FIRST_NAME)) {
                attribute = "lower(u.firstName)";
                parameterName = FIRST_NAME;
            } else if (entry.getKey().equalsIgnoreCase(LAST_NAME)) {
                attribute = "lower(u.lastName)";
                parameterName = LAST_NAME;
            } else if (entry.getKey().equalsIgnoreCase(EMAIL)) {
                attribute = "lower(u.email)";
                parameterName = EMAIL;
            }
            if (attribute == null) continue;
            builder.append(" and ");
            builder.append(attribute).append(" like :").append(parameterName);
        }
        builder.append(" order by u.username");
        String q = builder.toString();
        TypedQuery query = this.em.createQuery(q, UserEntity.class);
        query.setParameter("realmId", (Object)realm.getId());
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            String parameterName = null;
            if (entry.getKey().equals(USERNAME)) {
                parameterName = USERNAME;
            } else if (entry.getKey().equalsIgnoreCase(FIRST_NAME)) {
                parameterName = FIRST_NAME;
            } else if (entry.getKey().equalsIgnoreCase(LAST_NAME)) {
                parameterName = LAST_NAME;
            } else if (entry.getKey().equalsIgnoreCase(EMAIL)) {
                parameterName = EMAIL;
            }
            if (parameterName == null) continue;
            query.setParameter(parameterName, (Object)("%" + entry.getValue().toLowerCase() + "%"));
        }
        if (firstResult != -1) {
            query.setFirstResult(firstResult);
        }
        if (maxResults != -1) {
            query.setMaxResults(maxResults);
        }
        List results = query.getResultList();
        ArrayList<UserModel> users = new ArrayList<UserModel>();
        for (UserEntity entity : results) {
            users.add(new UserAdapter(realm, this.em, entity));
        }
        return users;
    }

    public List<UserModel> searchForUserByUserAttributes(Map<String, String> attributes, RealmModel realm) {
        StringBuilder builder = new StringBuilder("select attr.user,count(attr.user) from UserAttributeEntity attr where attr.user.realmId = :realmId");
        boolean first = true;
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            String attrName = entry.getKey();
            if (first) {
                builder.append(" and ");
                first = false;
            } else {
                builder.append(" or ");
            }
            builder.append(" ( attr.name like :").append(attrName);
            builder.append(" and attr.value like :").append(attrName).append("val )");
        }
        builder.append(" group by attr.user having count(attr.user) = " + attributes.size());
        Query query = this.em.createQuery(builder.toString());
        query.setParameter("realmId", (Object)realm.getId());
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            query.setParameter(entry.getKey(), (Object)entry.getKey());
            query.setParameter(entry.getKey() + "val", (Object)entry.getValue());
        }
        List results = query.getResultList();
        ArrayList<UserModel> users = new ArrayList<UserModel>();
        for (Object o : results) {
            UserEntity user = (UserEntity)((Object[])o)[0];
            users.add(new UserAdapter(realm, this.em, user));
        }
        return users;
    }

    private FederatedIdentityEntity findFederatedIdentity(UserModel user, String identityProvider) {
        TypedQuery query = this.em.createNamedQuery("findFederatedIdentityByUserAndProvider", FederatedIdentityEntity.class);
        UserEntity userEntity = (UserEntity)this.em.getReference(UserEntity.class, (Object)user.getId());
        query.setParameter("user", (Object)userEntity);
        query.setParameter("identityProvider", (Object)identityProvider);
        List results = query.getResultList();
        return results.size() > 0 ? (FederatedIdentityEntity)results.get(0) : null;
    }

    public Set<FederatedIdentityModel> getFederatedIdentities(UserModel user, RealmModel realm) {
        TypedQuery query = this.em.createNamedQuery("findFederatedIdentityByUser", FederatedIdentityEntity.class);
        UserEntity userEntity = (UserEntity)this.em.getReference(UserEntity.class, (Object)user.getId());
        query.setParameter("user", (Object)userEntity);
        List results = query.getResultList();
        HashSet<FederatedIdentityModel> set = new HashSet<FederatedIdentityModel>();
        for (FederatedIdentityEntity entity : results) {
            set.add(new FederatedIdentityModel(entity.getIdentityProvider(), entity.getUserId(), entity.getUserName(), entity.getToken()));
        }
        return set;
    }

    public FederatedIdentityModel getFederatedIdentity(UserModel user, String identityProvider, RealmModel realm) {
        FederatedIdentityEntity entity = this.findFederatedIdentity(user, identityProvider);
        return entity != null ? new FederatedIdentityModel(entity.getIdentityProvider(), entity.getUserId(), entity.getUserName(), entity.getToken()) : null;
    }

    public boolean validCredentials(RealmModel realm, UserModel user, List<UserCredentialModel> input) {
        return CredentialValidation.validCredentials((RealmModel)realm, (UserModel)user, input);
    }

    public boolean validCredentials(RealmModel realm, UserModel user, UserCredentialModel ... input) {
        return CredentialValidation.validCredentials((RealmModel)realm, (UserModel)user, (UserCredentialModel[])input);
    }

    public CredentialValidationOutput validCredentials(RealmModel realm, UserCredentialModel ... input) {
        return null;
    }
}

