/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.exportimport.util;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.iharder.Base64;
import org.codehaus.jackson.JsonEncoding;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.keycloak.models.ClientModel;
import org.keycloak.models.FederatedIdentityModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleContainerModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserConsentModel;
import org.keycloak.models.UserCredentialValueModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.CredentialRepresentation;
import org.keycloak.representations.idm.FederatedIdentityRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.RolesRepresentation;
import org.keycloak.representations.idm.ScopeMappingRepresentation;
import org.keycloak.representations.idm.UserConsentRepresentation;
import org.keycloak.representations.idm.UserRepresentation;

public class ExportUtils {
    public static RealmRepresentation exportRealm(KeycloakSession session, RealmModel realm, boolean includeUsers) {
        RealmRepresentation rep = ModelToRepresentation.toRepresentation((RealmModel)realm, (boolean)true);
        List clients = realm.getClients();
        ArrayList<ClientRepresentation> clientReps = new ArrayList<ClientRepresentation>();
        for (ClientModel app : clients) {
            ClientRepresentation clientRep = ExportUtils.exportClient(app);
            clientReps.add(clientRep);
        }
        rep.setClients(clientReps);
        List<RoleRepresentation> realmRoleReps = null;
        HashMap<String, List<RoleRepresentation>> clientRolesReps = new HashMap<String, List<RoleRepresentation>>();
        Set realmRoles = realm.getRoles();
        if (realmRoles != null && realmRoles.size() > 0) {
            realmRoleReps = ExportUtils.exportRoles(realmRoles);
        }
        for (ClientModel client : clients) {
            Set currentAppRoles = client.getRoles();
            List<RoleRepresentation> currentAppRoleReps = ExportUtils.exportRoles(currentAppRoles);
            clientRolesReps.put(client.getClientId(), currentAppRoleReps);
        }
        RolesRepresentation rolesRep = new RolesRepresentation();
        if (realmRoleReps != null) {
            rolesRep.setRealm(realmRoleReps);
        }
        if (clientRolesReps.size() > 0) {
            rolesRep.setClient(clientRolesReps);
        }
        rep.setRoles(rolesRep);
        ArrayList allClients = new ArrayList(clients);
        HashMap clientScopeReps = new HashMap();
        for (ClientModel client : allClients) {
            Set clientScopes = client.getScopeMappings();
            ScopeMappingRepresentation scopeMappingRep = null;
            for (RoleModel scope : clientScopes) {
                if (scope.getContainer() instanceof RealmModel) {
                    if (scopeMappingRep == null) {
                        scopeMappingRep = rep.scopeMapping(client.getClientId());
                    }
                    scopeMappingRep.role(scope.getName());
                    continue;
                }
                ClientModel app = (ClientModel)scope.getContainer();
                String appName = app.getClientId();
                ArrayList<ScopeMappingRepresentation> currentAppScopes = (ArrayList<ScopeMappingRepresentation>)clientScopeReps.get(appName);
                if (currentAppScopes == null) {
                    currentAppScopes = new ArrayList<ScopeMappingRepresentation>();
                    clientScopeReps.put(appName, currentAppScopes);
                }
                ScopeMappingRepresentation currentClientScope = null;
                for (ScopeMappingRepresentation scopeMapping : currentAppScopes) {
                    if (!scopeMapping.getClient().equals(client.getClientId())) continue;
                    currentClientScope = scopeMapping;
                    break;
                }
                if (currentClientScope == null) {
                    currentClientScope = new ScopeMappingRepresentation();
                    currentClientScope.setClient(client.getClientId());
                    currentAppScopes.add(currentClientScope);
                }
                currentClientScope.role(scope.getName());
            }
        }
        if (clientScopeReps.size() > 0) {
            rep.setClientScopeMappings(clientScopeReps);
        }
        if (includeUsers) {
            List allUsers = session.users().getUsers(realm, true);
            ArrayList<UserRepresentation> users = new ArrayList<UserRepresentation>();
            for (UserModel user : allUsers) {
                UserRepresentation userRep = ExportUtils.exportUser(session, realm, user);
                users.add(userRep);
            }
            if (users.size() > 0) {
                rep.setUsers(users);
            }
        }
        return rep;
    }

    public static ClientRepresentation exportClient(ClientModel client) {
        ClientRepresentation clientRep = ModelToRepresentation.toRepresentation((ClientModel)client);
        clientRep.setSecret(client.getSecret());
        return clientRep;
    }

    public static List<RoleRepresentation> exportRoles(Collection<RoleModel> roles) {
        ArrayList<RoleRepresentation> roleReps = new ArrayList<RoleRepresentation>();
        for (RoleModel role : roles) {
            RoleRepresentation roleRep = ExportUtils.exportRole(role);
            roleReps.add(roleRep);
        }
        return roleReps;
    }

    public static List<String> getRoleNames(Collection<RoleModel> roles) {
        ArrayList<String> roleNames = new ArrayList<String>();
        for (RoleModel role : roles) {
            roleNames.add(role.getName());
        }
        return roleNames;
    }

    public static RoleRepresentation exportRole(RoleModel role) {
        RoleRepresentation roleRep = ModelToRepresentation.toRepresentation((RoleModel)role);
        Set composites = role.getComposites();
        if (composites != null && composites.size() > 0) {
            HashSet<String> compositeRealmRoles = null;
            HashMap<String, ArrayList<String>> compositeClientRoles = null;
            for (RoleModel composite : composites) {
                ClientModel app;
                String appName;
                ArrayList<String> currentAppComposites;
                RoleContainerModel crContainer = composite.getContainer();
                if (crContainer instanceof RealmModel) {
                    if (compositeRealmRoles == null) {
                        compositeRealmRoles = new HashSet<String>();
                    }
                    compositeRealmRoles.add(composite.getName());
                    continue;
                }
                if (compositeClientRoles == null) {
                    compositeClientRoles = new HashMap<String, ArrayList<String>>();
                }
                if ((currentAppComposites = (ArrayList<String>)compositeClientRoles.get(appName = (app = (ClientModel)crContainer).getClientId())) == null) {
                    currentAppComposites = new ArrayList<String>();
                    compositeClientRoles.put(appName, currentAppComposites);
                }
                currentAppComposites.add(composite.getName());
            }
            RoleRepresentation.Composites compRep = new RoleRepresentation.Composites();
            if (compositeRealmRoles != null) {
                compRep.setRealm(compositeRealmRoles);
            }
            if (compositeClientRoles != null) {
                compRep.setClient(compositeClientRoles);
            }
            roleRep.setComposites(compRep);
        }
        return roleRep;
    }

    public static UserRepresentation exportUser(KeycloakSession session, RealmModel realm, UserModel user) {
        String clientInternalId;
        ClientModel client;
        UserRepresentation userRep = ModelToRepresentation.toRepresentation((UserModel)user);
        Set socialLinks = session.users().getFederatedIdentities(user, realm);
        ArrayList<FederatedIdentityRepresentation> socialLinkReps = new ArrayList<FederatedIdentityRepresentation>();
        for (FederatedIdentityModel socialLink : socialLinks) {
            FederatedIdentityRepresentation socialLinkRep = ExportUtils.exportSocialLink(socialLink);
            socialLinkReps.add(socialLinkRep);
        }
        if (socialLinkReps.size() > 0) {
            userRep.setFederatedIdentities(socialLinkReps);
        }
        Set roles = user.getRoleMappings();
        ArrayList<String> realmRoleNames = new ArrayList<String>();
        HashMap<String, ArrayList<String>> clientRoleNames = new HashMap<String, ArrayList<String>>();
        for (RoleModel role : roles) {
            if (role.getContainer() instanceof RealmModel) {
                realmRoleNames.add(role.getName());
                continue;
            }
            ClientModel client2 = (ClientModel)role.getContainer();
            String clientId = client2.getClientId();
            ArrayList<String> currentClientRoles = (ArrayList<String>)clientRoleNames.get(clientId);
            if (currentClientRoles == null) {
                currentClientRoles = new ArrayList<String>();
                clientRoleNames.put(clientId, currentClientRoles);
            }
            currentClientRoles.add(role.getName());
        }
        if (realmRoleNames.size() > 0) {
            userRep.setRealmRoles(realmRoleNames);
        }
        if (clientRoleNames.size() > 0) {
            userRep.setClientRoles(clientRoleNames);
        }
        List creds = user.getCredentialsDirectly();
        ArrayList<CredentialRepresentation> credReps = new ArrayList<CredentialRepresentation>();
        for (UserCredentialValueModel cred : creds) {
            CredentialRepresentation credRep = ExportUtils.exportCredential(cred);
            credReps.add(credRep);
        }
        userRep.setCredentials(credReps);
        userRep.setFederationLink(user.getFederationLink());
        List consents = user.getConsents();
        LinkedList<UserConsentRepresentation> consentReps = new LinkedList<UserConsentRepresentation>();
        for (UserConsentModel consent : consents) {
            UserConsentRepresentation consentRep = ModelToRepresentation.toRepresentation((UserConsentModel)consent);
            consentReps.add(consentRep);
        }
        if (consentReps.size() > 0) {
            userRep.setClientConsents(consentReps);
        }
        if (user.getServiceAccountClientLink() != null && (client = realm.getClientById(clientInternalId = user.getServiceAccountClientLink())) != null) {
            userRep.setServiceAccountClientId(client.getClientId());
        }
        return userRep;
    }

    public static FederatedIdentityRepresentation exportSocialLink(FederatedIdentityModel socialLink) {
        FederatedIdentityRepresentation socialLinkRep = new FederatedIdentityRepresentation();
        socialLinkRep.setIdentityProvider(socialLink.getIdentityProvider());
        socialLinkRep.setUserId(socialLink.getUserId());
        socialLinkRep.setUserName(socialLink.getUserName());
        return socialLinkRep;
    }

    public static CredentialRepresentation exportCredential(UserCredentialValueModel userCred) {
        CredentialRepresentation credRep = new CredentialRepresentation();
        credRep.setType(userCred.getType());
        credRep.setDevice(userCred.getDevice());
        credRep.setHashedSaltedValue(userCred.getValue());
        if (userCred.getSalt() != null) {
            credRep.setSalt(Base64.encodeBytes((byte[])userCred.getSalt()));
        }
        credRep.setHashIterations(Integer.valueOf(userCred.getHashIterations()));
        return credRep;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportUsersToStream(KeycloakSession session, RealmModel realm, List<UserModel> usersToExport, ObjectMapper mapper, OutputStream os) throws IOException {
        JsonFactory factory = mapper.getJsonFactory();
        try (JsonGenerator generator = factory.createJsonGenerator(os, JsonEncoding.UTF8);){
            if (mapper.isEnabled(SerializationConfig.Feature.INDENT_OUTPUT)) {
                generator.useDefaultPrettyPrinter();
            }
            generator.writeStartObject();
            generator.writeStringField("realm", realm.getName());
            generator.writeFieldName("users");
            generator.writeStartArray();
            for (UserModel user : usersToExport) {
                UserRepresentation userRep = ExportUtils.exportUser(session, realm, user);
                generator.writeObject((Object)userRep);
            }
            generator.writeEndArray();
            generator.writeEndObject();
        }
    }
}

