/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.broker.oidc;

import java.io.IOException;
import java.security.PublicKey;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.codehaus.jackson.JsonNode;
import org.jboss.logging.Logger;
import org.keycloak.ClientConnection;
import org.keycloak.broker.oidc.AbstractOAuth2IdentityProvider;
import org.keycloak.broker.oidc.OIDCIdentityProviderConfig;
import org.keycloak.broker.oidc.mappers.AbstractJsonUserAttributeMapper;
import org.keycloak.broker.oidc.util.JsonSimpleHttp;
import org.keycloak.broker.provider.AuthenticationRequest;
import org.keycloak.broker.provider.BrokeredIdentityContext;
import org.keycloak.broker.provider.IdentityBrokerException;
import org.keycloak.broker.provider.IdentityProvider;
import org.keycloak.broker.provider.util.SimpleHttp;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.jose.jws.crypto.RSAProvider;
import org.keycloak.models.ClientSessionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.representations.AccessTokenResponse;
import org.keycloak.representations.JsonWebToken;
import org.keycloak.services.ErrorPage;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.resources.IdentityBrokerService;
import org.keycloak.services.resources.RealmsResource;
import org.keycloak.util.JsonSerialization;
import org.keycloak.util.PemUtils;

public class OIDCIdentityProvider
extends AbstractOAuth2IdentityProvider<OIDCIdentityProviderConfig> {
    protected static final Logger logger = Logger.getLogger(OIDCIdentityProvider.class);
    public static final String OAUTH2_PARAMETER_PROMPT = "prompt";
    public static final String SCOPE_OPENID = "openid";
    public static final String FEDERATED_ID_TOKEN = "FEDERATED_ID_TOKEN";
    public static final String USER_INFO = "UserInfo";
    public static final String FEDERATED_ACCESS_TOKEN_RESPONSE = "FEDERATED_ACCESS_TOKEN_RESPONSE";
    public static final String VALIDATED_ID_TOKEN = "VALIDATED_ID_TOKEN";

    public OIDCIdentityProvider(OIDCIdentityProviderConfig config) {
        super(config);
        String defaultScope = config.getDefaultScope();
        if (!defaultScope.contains(SCOPE_OPENID)) {
            config.setDefaultScope("openid " + defaultScope);
        }
    }

    @Override
    public Object callback(RealmModel realm, IdentityProvider.AuthenticationCallback callback, EventBuilder event) {
        return new OIDCEndpoint(callback, realm, event);
    }

    protected PublicKey getExternalIdpKey() {
        String signingCert = ((OIDCIdentityProviderConfig)this.getConfig()).getCertificateSignatureVerifier();
        try {
            if (signingCert != null && !signingCert.trim().equals("")) {
                return PemUtils.decodeCertificate((String)signingCert).getPublicKey();
            }
            if (((OIDCIdentityProviderConfig)this.getConfig()).getPublicKeySignatureVerifier() != null && !((OIDCIdentityProviderConfig)this.getConfig()).getPublicKeySignatureVerifier().trim().equals("")) {
                return PemUtils.decodePublicKey((String)((OIDCIdentityProviderConfig)this.getConfig()).getPublicKeySignatureVerifier());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    public void backchannelLogout(UserSessionModel userSession, UriInfo uriInfo, RealmModel realm) {
        if (((OIDCIdentityProviderConfig)this.getConfig()).getLogoutUrl() == null || ((OIDCIdentityProviderConfig)this.getConfig()).getLogoutUrl().trim().equals("") || !((OIDCIdentityProviderConfig)this.getConfig()).isBackchannelSupported()) {
            return;
        }
        String idToken = userSession.getNote(FEDERATED_ID_TOKEN);
        if (idToken == null) {
            return;
        }
        this.backchannelLogout(userSession, idToken);
    }

    protected void backchannelLogout(UserSessionModel userSession, String idToken) {
        String sessionId = userSession.getId();
        UriBuilder logoutUri = UriBuilder.fromUri((String)((OIDCIdentityProviderConfig)this.getConfig()).getLogoutUrl()).queryParam("state", new Object[]{sessionId});
        logoutUri.queryParam("id_token_hint", new Object[]{idToken});
        String url = logoutUri.build(new Object[0]).toString();
        try {
            boolean success;
            int status = JsonSimpleHttp.doGet(url).asStatus();
            boolean bl = success = status >= 200 && status < 400;
            if (!success) {
                logger.warn((Object)("Failed backchannel broker logout to: " + url));
            }
        }
        catch (Exception e) {
            logger.warn((Object)("Failed backchannel broker logout to: " + url), (Throwable)e);
        }
    }

    public Response keycloakInitiatedBrowserLogout(UserSessionModel userSession, UriInfo uriInfo, RealmModel realm) {
        if (((OIDCIdentityProviderConfig)this.getConfig()).getLogoutUrl() == null || ((OIDCIdentityProviderConfig)this.getConfig()).getLogoutUrl().trim().equals("")) {
            return null;
        }
        String idToken = userSession.getNote(FEDERATED_ID_TOKEN);
        if (idToken != null && ((OIDCIdentityProviderConfig)this.getConfig()).isBackchannelSupported()) {
            this.backchannelLogout(userSession, idToken);
            return null;
        }
        String sessionId = userSession.getId();
        UriBuilder logoutUri = UriBuilder.fromUri((String)((OIDCIdentityProviderConfig)this.getConfig()).getLogoutUrl()).queryParam("state", new Object[]{sessionId});
        if (idToken != null) {
            logoutUri.queryParam("id_token_hint", new Object[]{idToken});
        }
        String redirect = RealmsResource.brokerUrl((UriInfo)uriInfo).path(IdentityBrokerService.class, "getEndpoint").path(OIDCEndpoint.class, "logoutResponse").build(new Object[]{realm.getName(), ((OIDCIdentityProviderConfig)this.getConfig()).getAlias()}).toString();
        logoutUri.queryParam("post_logout_redirect_uri", new Object[]{redirect});
        Response response = Response.status((int)302).location(logoutUri.build(new Object[0])).build();
        return response;
    }

    @Override
    protected UriBuilder createAuthorizationUrl(AuthenticationRequest request) {
        UriBuilder authorizationUrl = super.createAuthorizationUrl(request);
        String prompt = ((OIDCIdentityProviderConfig)this.getConfig()).getPrompt();
        if (prompt != null && !prompt.isEmpty()) {
            authorizationUrl.queryParam(OAUTH2_PARAMETER_PROMPT, new Object[]{prompt});
        }
        return authorizationUrl;
    }

    protected void processAccessTokenResponse(BrokeredIdentityContext context, PublicKey idpKey, AccessTokenResponse response) {
    }

    @Override
    protected BrokeredIdentityContext getFederatedIdentity(String response) {
        AccessTokenResponse tokenResponse = null;
        try {
            tokenResponse = (AccessTokenResponse)JsonSerialization.readValue((String)response, AccessTokenResponse.class);
        }
        catch (IOException e) {
            throw new IdentityBrokerException("Could not decode access token response.", (Throwable)e);
        }
        PublicKey key = this.getExternalIdpKey();
        String accessToken = this.verifyAccessToken(key, tokenResponse);
        String encodedIdToken = tokenResponse.getIdToken();
        JsonWebToken idToken = this.validateToken(key, encodedIdToken);
        try {
            String id = idToken.getSubject();
            BrokeredIdentityContext identity = new BrokeredIdentityContext(id);
            String name = (String)idToken.getOtherClaims().get("name");
            String preferredUsername = (String)idToken.getOtherClaims().get("preferred_username");
            String email = (String)idToken.getOtherClaims().get("email");
            if (((OIDCIdentityProviderConfig)this.getConfig()).getUserInfoUrl() != null && (id == null || name == null || preferredUsername == null || email == null)) {
                SimpleHttp request = JsonSimpleHttp.doGet(((OIDCIdentityProviderConfig)this.getConfig()).getUserInfoUrl()).header("Authorization", "Bearer " + accessToken);
                JsonNode userInfo = JsonSimpleHttp.asJson(request);
                id = this.getJsonProperty(userInfo, "sub");
                name = this.getJsonProperty(userInfo, "name");
                preferredUsername = this.getJsonProperty(userInfo, "preferred_username");
                email = this.getJsonProperty(userInfo, "email");
                AbstractJsonUserAttributeMapper.storeUserProfileForMapper(identity, userInfo, ((OIDCIdentityProviderConfig)this.getConfig()).getAlias());
            }
            identity.getContextData().put(FEDERATED_ACCESS_TOKEN_RESPONSE, tokenResponse);
            identity.getContextData().put(VALIDATED_ID_TOKEN, idToken);
            this.processAccessTokenResponse(identity, key, tokenResponse);
            identity.setId(id);
            identity.setName(name);
            identity.setEmail(email);
            identity.setBrokerUserId(((OIDCIdentityProviderConfig)this.getConfig()).getAlias() + "." + id);
            if (tokenResponse.getSessionState() != null) {
                identity.setBrokerSessionId(((OIDCIdentityProviderConfig)this.getConfig()).getAlias() + "." + tokenResponse.getSessionState());
            }
            if (preferredUsername == null) {
                preferredUsername = email;
            }
            if (preferredUsername == null) {
                preferredUsername = id;
            }
            identity.setUsername(preferredUsername);
            if (((OIDCIdentityProviderConfig)this.getConfig()).isStoreToken()) {
                identity.setToken(response);
            }
            return identity;
        }
        catch (Exception e) {
            throw new IdentityBrokerException("Could not fetch attributes from userinfo endpoint.", (Throwable)e);
        }
    }

    private String verifyAccessToken(PublicKey key, AccessTokenResponse tokenResponse) {
        String accessToken = tokenResponse.getToken();
        if (accessToken == null) {
            throw new IdentityBrokerException("No access_token from server.");
        }
        return accessToken;
    }

    protected boolean verify(JWSInput jws, PublicKey key) {
        if (key == null) {
            return true;
        }
        if (!((OIDCIdentityProviderConfig)this.getConfig()).isValidateSignature()) {
            return true;
        }
        return RSAProvider.verify((JWSInput)jws, (PublicKey)key);
    }

    protected JsonWebToken validateToken(PublicKey key, String encodedToken) {
        if (encodedToken == null) {
            throw new IdentityBrokerException("No token from server.");
        }
        try {
            JWSInput jws = new JWSInput(encodedToken);
            if (!this.verify(jws, key)) {
                throw new IdentityBrokerException("token signature validation failed");
            }
            JsonWebToken token = (JsonWebToken)jws.readJsonContent(JsonWebToken.class);
            String iss = token.getIssuer();
            if (!token.hasAudience(((OIDCIdentityProviderConfig)this.getConfig()).getClientId())) {
                throw new IdentityBrokerException("Wrong audience from token.");
            }
            if (!token.isActive()) {
                throw new IdentityBrokerException("Token is no longer valid");
            }
            String trustedIssuers = ((OIDCIdentityProviderConfig)this.getConfig()).getIssuer();
            if (trustedIssuers != null) {
                String[] issuers;
                for (String trustedIssuer : issuers = trustedIssuers.split(",")) {
                    if (iss == null || !iss.equals(trustedIssuer.trim())) continue;
                    return token;
                }
                throw new IdentityBrokerException("Wrong issuer from token. Got: " + iss + " expected: " + ((OIDCIdentityProviderConfig)this.getConfig()).getIssuer());
            }
            return token;
        }
        catch (IOException e) {
            throw new IdentityBrokerException("Could not decode token.", (Throwable)e);
        }
    }

    public void attachUserSession(UserSessionModel userSession, ClientSessionModel clientSession, BrokeredIdentityContext context) {
        AccessTokenResponse tokenResponse = (AccessTokenResponse)context.getContextData().get(FEDERATED_ACCESS_TOKEN_RESPONSE);
        userSession.setNote("FEDERATED_ACCESS_TOKEN", tokenResponse.getToken());
        userSession.setNote(FEDERATED_ID_TOKEN, tokenResponse.getIdToken());
    }

    @Override
    protected String getDefaultScopes() {
        return SCOPE_OPENID;
    }

    protected class OIDCEndpoint
    extends AbstractOAuth2IdentityProvider.Endpoint {
        public OIDCEndpoint(IdentityProvider.AuthenticationCallback callback, RealmModel realm, EventBuilder event) {
            super(callback, realm, event);
        }

        @GET
        @Path(value="logout_response")
        public Response logoutResponse(@Context UriInfo uriInfo, @QueryParam(value="state") String state) {
            UserSessionModel userSession = this.session.sessions().getUserSession(this.realm, state);
            if (userSession == null) {
                logger.error((Object)"no valid user session");
                EventBuilder event = new EventBuilder(this.realm, this.session, this.clientConnection);
                event.event(EventType.LOGOUT);
                event.error("user_session_not_found");
                return ErrorPage.error((KeycloakSession)this.session, (String)"identityProviderUnexpectedErrorMessage", (Object[])new Object[0]);
            }
            if (userSession.getState() != UserSessionModel.State.LOGGING_OUT) {
                logger.error((Object)"usersession in different state");
                EventBuilder event = new EventBuilder(this.realm, this.session, this.clientConnection);
                event.event(EventType.LOGOUT);
                event.error("user_session_not_found");
                return ErrorPage.error((KeycloakSession)this.session, (String)"sessionNotActiveMessage", (Object[])new Object[0]);
            }
            return AuthenticationManager.finishBrowserLogout((KeycloakSession)this.session, (RealmModel)this.realm, (UserSessionModel)userSession, (UriInfo)uriInfo, (ClientConnection)this.clientConnection, (HttpHeaders)this.headers);
        }
    }
}

