/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc;

import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientSessionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.protocol.LoginProtocol;
import org.keycloak.protocol.RestartLoginCookie;
import org.keycloak.services.managers.ClientSessionCode;
import org.keycloak.services.managers.ResourceAdminManager;

public class OIDCLoginProtocol
implements LoginProtocol {
    public static final String LOGIN_PROTOCOL = "openid-connect";
    public static final String STATE_PARAM = "state";
    public static final String LOGOUT_STATE_PARAM = "OIDC_LOGOUT_STATE_PARAM";
    public static final String SCOPE_PARAM = "scope";
    public static final String CODE_PARAM = "code";
    public static final String RESPONSE_TYPE_PARAM = "response_type";
    public static final String GRANT_TYPE_PARAM = "grant_type";
    public static final String REDIRECT_URI_PARAM = "redirect_uri";
    public static final String CLIENT_ID_PARAM = "client_id";
    public static final String NONCE_PARAM = "nonce";
    public static final String PROMPT_PARAM = "prompt";
    public static final String LOGIN_HINT_PARAM = "login_hint";
    public static final String LOGOUT_REDIRECT_URI = "OIDC_LOGOUT_REDIRECT_URI";
    public static final String ISSUER = "iss";
    private static final Logger log = Logger.getLogger(OIDCLoginProtocol.class);
    protected KeycloakSession session;
    protected RealmModel realm;
    protected UriInfo uriInfo;
    protected HttpHeaders headers;
    protected EventBuilder event;

    public OIDCLoginProtocol(KeycloakSession session, RealmModel realm, UriInfo uriInfo, HttpHeaders headers, EventBuilder event) {
        this.session = session;
        this.realm = realm;
        this.uriInfo = uriInfo;
        this.headers = headers;
        this.event = event;
    }

    public OIDCLoginProtocol() {
    }

    @Override
    public OIDCLoginProtocol setSession(KeycloakSession session) {
        this.session = session;
        return this;
    }

    @Override
    public OIDCLoginProtocol setRealm(RealmModel realm) {
        this.realm = realm;
        return this;
    }

    @Override
    public OIDCLoginProtocol setUriInfo(UriInfo uriInfo) {
        this.uriInfo = uriInfo;
        return this;
    }

    @Override
    public OIDCLoginProtocol setHttpHeaders(HttpHeaders headers) {
        this.headers = headers;
        return this;
    }

    @Override
    public OIDCLoginProtocol setEventBuilder(EventBuilder event) {
        this.event = event;
        return this;
    }

    @Override
    public Response cancelLogin(ClientSessionModel clientSession) {
        String redirect = clientSession.getRedirectUri();
        String state = clientSession.getNote(STATE_PARAM);
        UriBuilder redirectUri = UriBuilder.fromUri((String)redirect).queryParam("error", new Object[]{"access_denied"});
        if (state != null) {
            redirectUri.queryParam(STATE_PARAM, new Object[]{state});
        }
        this.session.sessions().removeClientSession(this.realm, clientSession);
        RestartLoginCookie.expireRestartCookie(this.realm, this.session.getContext().getConnection(), this.uriInfo);
        return Response.status((int)302).location(redirectUri.build(new Object[0])).build();
    }

    @Override
    public Response authenticated(UserSessionModel userSession, ClientSessionCode accessCode) {
        ClientSessionModel clientSession = accessCode.getClientSession();
        String redirect = clientSession.getRedirectUri();
        String state = clientSession.getNote(STATE_PARAM);
        accessCode.setAction(ClientSessionModel.Action.CODE_TO_TOKEN.name());
        UriBuilder redirectUri = UriBuilder.fromUri((String)redirect).queryParam(CODE_PARAM, new Object[]{accessCode.getCode()});
        log.debugv("redirectAccessCode: state: {0}", (Object)state);
        if (state != null) {
            redirectUri.queryParam(STATE_PARAM, new Object[]{state});
        }
        Response.ResponseBuilder location = Response.status((int)302).location(redirectUri.build(new Object[0]));
        return location.build();
    }

    @Override
    public Response consentDenied(ClientSessionModel clientSession) {
        String redirect = clientSession.getRedirectUri();
        String state = clientSession.getNote(STATE_PARAM);
        UriBuilder redirectUri = UriBuilder.fromUri((String)redirect).queryParam("error", new Object[]{"access_denied"});
        if (state != null) {
            redirectUri.queryParam(STATE_PARAM, new Object[]{state});
        }
        this.session.sessions().removeClientSession(this.realm, clientSession);
        RestartLoginCookie.expireRestartCookie(this.realm, this.session.getContext().getConnection(), this.uriInfo);
        Response.ResponseBuilder location = Response.status((int)302).location(redirectUri.build(new Object[0]));
        return location.build();
    }

    public Response invalidSessionError(ClientSessionModel clientSession) {
        String redirect = clientSession.getRedirectUri();
        String state = clientSession.getNote(STATE_PARAM);
        UriBuilder redirectUri = UriBuilder.fromUri((String)redirect).queryParam("error", new Object[]{"access_denied"});
        if (state != null) {
            redirectUri.queryParam(STATE_PARAM, new Object[]{state});
        }
        return Response.status((int)302).location(redirectUri.build(new Object[0])).build();
    }

    @Override
    public void backchannelLogout(UserSessionModel userSession, ClientSessionModel clientSession) {
        if (!(clientSession.getClient() instanceof ClientModel)) {
            return;
        }
        ClientModel app = clientSession.getClient();
        new ResourceAdminManager(this.session).logoutClientSession(this.uriInfo.getRequestUri(), this.realm, app, clientSession);
    }

    @Override
    public Response frontchannelLogout(UserSessionModel userSession, ClientSessionModel clientSession) {
        throw new RuntimeException("NOT IMPLEMENTED");
    }

    @Override
    public Response finishLogout(UserSessionModel userSession) {
        String redirectUri = userSession.getNote(LOGOUT_REDIRECT_URI);
        String state = userSession.getNote(LOGOUT_STATE_PARAM);
        this.event.event(EventType.LOGOUT);
        if (redirectUri != null) {
            this.event.detail(REDIRECT_URI_PARAM, redirectUri);
        }
        this.event.user(userSession.getUser()).session(userSession).success();
        if (redirectUri != null) {
            UriBuilder uriBuilder = UriBuilder.fromUri((String)redirectUri);
            if (state != null) {
                uriBuilder.queryParam(STATE_PARAM, new Object[]{state});
            }
            return Response.status((int)302).location(uriBuilder.build(new Object[0])).build();
        }
        return Response.ok().build();
    }

    public void close() {
    }
}

