/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.mongo.keycloak.adapters;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.keycloak.connections.mongo.api.context.MongoStoreInvocationContext;
import org.keycloak.models.ClientTemplateModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.entities.ProtocolMapperEntity;
import org.keycloak.models.mongo.keycloak.adapters.AbstractMongoAdapter;
import org.keycloak.models.mongo.keycloak.entities.MongoClientTemplateEntity;
import org.keycloak.models.utils.KeycloakModelUtils;

public class ClientTemplateAdapter
extends AbstractMongoAdapter<MongoClientTemplateEntity>
implements ClientTemplateModel {
    protected final MongoClientTemplateEntity clientTemplateEntity;
    private final RealmModel realm;
    protected KeycloakSession session;

    public ClientTemplateAdapter(KeycloakSession session, RealmModel realm, MongoClientTemplateEntity clientEntity, MongoStoreInvocationContext invContext) {
        super(invContext);
        this.session = session;
        this.realm = realm;
        this.clientTemplateEntity = clientEntity;
    }

    @Override
    public MongoClientTemplateEntity getMongoEntity() {
        return this.clientTemplateEntity;
    }

    public RealmModel getRealm() {
        return this.realm;
    }

    public String getId() {
        return this.getMongoEntity().getId();
    }

    public String getName() {
        return this.getMongoEntity().getName();
    }

    public void setName(String name) {
        this.getMongoEntity().setName(name);
        this.updateMongoEntity();
    }

    public String getDescription() {
        return this.getMongoEntity().getDescription();
    }

    public String getProtocol() {
        return this.getMongoEntity().getProtocol();
    }

    public void setProtocol(String protocol) {
        this.getMongoEntity().setProtocol(protocol);
        this.updateMongoEntity();
    }

    public void setDescription(String description) {
        this.getMongoEntity().setDescription(description);
        this.updateMongoEntity();
    }

    public Set<ProtocolMapperModel> getProtocolMappers() {
        HashSet<ProtocolMapperModel> result = new HashSet<ProtocolMapperModel>();
        for (ProtocolMapperEntity entity : this.getMongoEntity().getProtocolMappers()) {
            ProtocolMapperModel mapping = new ProtocolMapperModel();
            mapping.setId(entity.getId());
            mapping.setName(entity.getName());
            mapping.setProtocol(entity.getProtocol());
            mapping.setProtocolMapper(entity.getProtocolMapper());
            mapping.setConsentRequired(entity.isConsentRequired());
            mapping.setConsentText(entity.getConsentText());
            HashMap config = new HashMap();
            if (entity.getConfig() != null) {
                config.putAll(entity.getConfig());
            }
            mapping.setConfig(config);
            result.add(mapping);
        }
        return result;
    }

    public ProtocolMapperModel addProtocolMapper(ProtocolMapperModel model) {
        if (this.getProtocolMapperByName(model.getProtocol(), model.getName()) != null) {
            throw new ModelDuplicateException("Protocol mapper name must be unique per protocol");
        }
        ProtocolMapperEntity entity = new ProtocolMapperEntity();
        String id = model.getId() != null ? model.getId() : KeycloakModelUtils.generateId();
        entity.setId(id);
        entity.setProtocol(model.getProtocol());
        entity.setName(model.getName());
        entity.setProtocolMapper(model.getProtocolMapper());
        entity.setConfig(model.getConfig());
        entity.setConsentRequired(model.isConsentRequired());
        entity.setConsentText(model.getConsentText());
        this.getMongoEntity().getProtocolMappers().add(entity);
        this.updateMongoEntity();
        return this.entityToModel(entity);
    }

    public void removeProtocolMapper(ProtocolMapperModel mapping) {
        for (ProtocolMapperEntity entity : this.getMongoEntity().getProtocolMappers()) {
            if (!entity.getId().equals(mapping.getId())) continue;
            this.session.users().preRemove(mapping);
            this.getMongoEntity().getProtocolMappers().remove(entity);
            this.updateMongoEntity();
            break;
        }
    }

    protected ProtocolMapperEntity getProtocolMapperyEntityById(String id) {
        for (ProtocolMapperEntity entity : this.getMongoEntity().getProtocolMappers()) {
            if (!entity.getId().equals(id)) continue;
            return entity;
        }
        return null;
    }

    protected ProtocolMapperEntity getProtocolMapperEntityByName(String protocol, String name) {
        for (ProtocolMapperEntity entity : this.getMongoEntity().getProtocolMappers()) {
            if (!entity.getProtocol().equals(protocol) || !entity.getName().equals(name)) continue;
            return entity;
        }
        return null;
    }

    public void updateProtocolMapper(ProtocolMapperModel mapping) {
        ProtocolMapperEntity entity = this.getProtocolMapperyEntityById(mapping.getId());
        entity.setProtocolMapper(mapping.getProtocolMapper());
        entity.setConsentRequired(mapping.isConsentRequired());
        entity.setConsentText(mapping.getConsentText());
        if (entity.getConfig() != null) {
            entity.getConfig().clear();
            entity.getConfig().putAll(mapping.getConfig());
        } else {
            entity.setConfig(mapping.getConfig());
        }
        this.updateMongoEntity();
    }

    public ProtocolMapperModel getProtocolMapperById(String id) {
        ProtocolMapperEntity entity = this.getProtocolMapperyEntityById(id);
        if (entity == null) {
            return null;
        }
        return this.entityToModel(entity);
    }

    public ProtocolMapperModel getProtocolMapperByName(String protocol, String name) {
        ProtocolMapperEntity entity = this.getProtocolMapperEntityByName(protocol, name);
        if (entity == null) {
            return null;
        }
        return this.entityToModel(entity);
    }

    protected ProtocolMapperModel entityToModel(ProtocolMapperEntity entity) {
        ProtocolMapperModel mapping = new ProtocolMapperModel();
        mapping.setId(entity.getId());
        mapping.setName(entity.getName());
        mapping.setProtocol(entity.getProtocol());
        mapping.setProtocolMapper(entity.getProtocolMapper());
        mapping.setConsentRequired(entity.isConsentRequired());
        mapping.setConsentText(entity.getConsentText());
        HashMap config = new HashMap();
        if (entity.getConfig() != null) {
            config.putAll(entity.getConfig());
        }
        mapping.setConfig(config);
        return mapping;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof ClientTemplateModel)) {
            return false;
        }
        ClientTemplateModel that = (ClientTemplateModel)o;
        return that.getId().equals(this.getId());
    }

    @Override
    public int hashCode() {
        return this.getId().hashCode();
    }
}

