/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.jpa;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.EntityManager;
import org.keycloak.models.ClientTemplateModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.jpa.entities.ClientTemplateEntity;
import org.keycloak.models.jpa.entities.ProtocolMapperEntity;
import org.keycloak.models.utils.KeycloakModelUtils;

public class ClientTemplateAdapter
implements ClientTemplateModel {
    protected KeycloakSession session;
    protected RealmModel realm;
    protected EntityManager em;
    protected ClientTemplateEntity entity;

    public ClientTemplateAdapter(RealmModel realm, EntityManager em, KeycloakSession session, ClientTemplateEntity entity) {
        this.session = session;
        this.realm = realm;
        this.em = em;
        this.entity = entity;
    }

    public ClientTemplateEntity getEntity() {
        return this.entity;
    }

    public String getId() {
        return this.entity.getId();
    }

    public RealmModel getRealm() {
        return this.realm;
    }

    public String getName() {
        return this.entity.getName();
    }

    public void setName(String name) {
        this.entity.setName(name);
    }

    public String getDescription() {
        return this.entity.getDescription();
    }

    public void setDescription(String description) {
        this.entity.setDescription(description);
    }

    public String getProtocol() {
        return this.entity.getProtocol();
    }

    public void setProtocol(String protocol) {
        this.entity.setProtocol(protocol);
    }

    public Set<ProtocolMapperModel> getProtocolMappers() {
        HashSet<ProtocolMapperModel> mappings = new HashSet<ProtocolMapperModel>();
        for (ProtocolMapperEntity entity : this.entity.getProtocolMappers()) {
            ProtocolMapperModel mapping = new ProtocolMapperModel();
            mapping.setId(entity.getId());
            mapping.setName(entity.getName());
            mapping.setProtocol(entity.getProtocol());
            mapping.setProtocolMapper(entity.getProtocolMapper());
            mapping.setConsentRequired(entity.isConsentRequired());
            mapping.setConsentText(entity.getConsentText());
            HashMap<String, String> config = new HashMap<String, String>();
            if (entity.getConfig() != null) {
                config.putAll(entity.getConfig());
            }
            mapping.setConfig(config);
            mappings.add(mapping);
        }
        return mappings;
    }

    public ProtocolMapperModel addProtocolMapper(ProtocolMapperModel model) {
        if (this.getProtocolMapperByName(model.getProtocol(), model.getName()) != null) {
            throw new ModelDuplicateException("Protocol mapper name must be unique per protocol");
        }
        String id = model.getId() != null ? model.getId() : KeycloakModelUtils.generateId();
        ProtocolMapperEntity entity = new ProtocolMapperEntity();
        entity.setId(id);
        entity.setName(model.getName());
        entity.setProtocol(model.getProtocol());
        entity.setProtocolMapper(model.getProtocolMapper());
        entity.setClientTemplate(this.entity);
        entity.setConfig(model.getConfig());
        entity.setConsentRequired(model.isConsentRequired());
        entity.setConsentText(model.getConsentText());
        this.em.persist((Object)entity);
        this.entity.getProtocolMappers().add(entity);
        return this.entityToModel(entity);
    }

    protected ProtocolMapperEntity getProtocolMapperEntity(String id) {
        for (ProtocolMapperEntity entity : this.entity.getProtocolMappers()) {
            if (!entity.getId().equals(id)) continue;
            return entity;
        }
        return null;
    }

    protected ProtocolMapperEntity getProtocolMapperEntityByName(String protocol, String name) {
        for (ProtocolMapperEntity entity : this.entity.getProtocolMappers()) {
            if (!entity.getProtocol().equals(protocol) || !entity.getName().equals(name)) continue;
            return entity;
        }
        return null;
    }

    public void removeProtocolMapper(ProtocolMapperModel mapping) {
        ProtocolMapperEntity toDelete = this.getProtocolMapperEntity(mapping.getId());
        if (toDelete != null) {
            this.session.users().preRemove(mapping);
            this.entity.getProtocolMappers().remove(toDelete);
            this.em.remove((Object)toDelete);
        }
    }

    public void updateProtocolMapper(ProtocolMapperModel mapping) {
        ProtocolMapperEntity entity = this.getProtocolMapperEntity(mapping.getId());
        entity.setProtocolMapper(mapping.getProtocolMapper());
        entity.setConsentRequired(mapping.isConsentRequired());
        entity.setConsentText(mapping.getConsentText());
        if (entity.getConfig() == null) {
            entity.setConfig(mapping.getConfig());
        } else {
            entity.getConfig().clear();
            entity.getConfig().putAll(mapping.getConfig());
        }
        this.em.flush();
    }

    public ProtocolMapperModel getProtocolMapperById(String id) {
        ProtocolMapperEntity entity = this.getProtocolMapperEntity(id);
        if (entity == null) {
            return null;
        }
        return this.entityToModel(entity);
    }

    public ProtocolMapperModel getProtocolMapperByName(String protocol, String name) {
        ProtocolMapperEntity entity = this.getProtocolMapperEntityByName(protocol, name);
        if (entity == null) {
            return null;
        }
        return this.entityToModel(entity);
    }

    protected ProtocolMapperModel entityToModel(ProtocolMapperEntity entity) {
        ProtocolMapperModel mapping = new ProtocolMapperModel();
        mapping.setId(entity.getId());
        mapping.setName(entity.getName());
        mapping.setProtocol(entity.getProtocol());
        mapping.setProtocolMapper(entity.getProtocolMapper());
        mapping.setConsentRequired(entity.isConsentRequired());
        mapping.setConsentText(entity.getConsentText());
        HashMap<String, String> config = new HashMap<String, String>();
        if (entity.getConfig() != null) {
            config.putAll(entity.getConfig());
        }
        mapping.setConfig(config);
        return mapping;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof ClientTemplateModel)) {
            return false;
        }
        ClientTemplateModel that = (ClientTemplateModel)o;
        return that.getId().equals(this.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }
}

