/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.keycloak.events.EventBuilder;
import org.keycloak.jose.jwk.JWK;
import org.keycloak.jose.jwk.JWKBuilder;
import org.keycloak.login.LoginFormsProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.protocol.oidc.TokenManager;
import org.keycloak.protocol.oidc.endpoints.AuthorizationEndpoint;
import org.keycloak.protocol.oidc.endpoints.LoginStatusIframeEndpoint;
import org.keycloak.protocol.oidc.endpoints.LogoutEndpoint;
import org.keycloak.protocol.oidc.endpoints.TokenEndpoint;
import org.keycloak.protocol.oidc.endpoints.UserInfoEndpoint;
import org.keycloak.protocol.oidc.endpoints.ValidateTokenEndpoint;
import org.keycloak.protocol.oidc.representations.JSONWebKeySet;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.resources.RealmsResource;

public class OIDCLoginProtocolService {
    protected static final Logger logger = Logger.getLogger(OIDCLoginProtocolService.class);
    private RealmModel realm;
    private TokenManager tokenManager;
    private EventBuilder event;
    private AuthenticationManager authManager;
    @Context
    private UriInfo uriInfo;
    @Context
    private KeycloakSession session;
    @Context
    private HttpHeaders headers;

    public OIDCLoginProtocolService(RealmModel realm, EventBuilder event, AuthenticationManager authManager) {
        this.realm = realm;
        this.tokenManager = new TokenManager();
        this.event = event;
        this.authManager = authManager;
    }

    public static UriBuilder tokenServiceBaseUrl(UriInfo uriInfo) {
        UriBuilder baseUriBuilder = uriInfo.getBaseUriBuilder();
        return OIDCLoginProtocolService.tokenServiceBaseUrl(baseUriBuilder);
    }

    public static UriBuilder tokenServiceBaseUrl(UriBuilder baseUriBuilder) {
        return baseUriBuilder.path(RealmsResource.class).path("{realm}/protocol/openid-connect");
    }

    public static UriBuilder authUrl(UriInfo uriInfo) {
        UriBuilder baseUriBuilder = uriInfo.getBaseUriBuilder();
        return OIDCLoginProtocolService.authUrl(baseUriBuilder);
    }

    public static UriBuilder authUrl(UriBuilder baseUriBuilder) {
        UriBuilder uriBuilder = OIDCLoginProtocolService.tokenServiceBaseUrl(baseUriBuilder);
        return uriBuilder.path(OIDCLoginProtocolService.class, "auth");
    }

    public static UriBuilder tokenUrl(UriBuilder baseUriBuilder) {
        UriBuilder uriBuilder = OIDCLoginProtocolService.tokenServiceBaseUrl(baseUriBuilder);
        return uriBuilder.path(OIDCLoginProtocolService.class, "token");
    }

    public static UriBuilder tokenIntrospectionUrl(UriBuilder baseUriBuilder) {
        return OIDCLoginProtocolService.tokenUrl(baseUriBuilder).path(TokenEndpoint.class, "introspect");
    }

    @Deprecated
    public static UriBuilder validateAccessTokenUrl(UriBuilder baseUriBuilder) {
        UriBuilder uriBuilder = OIDCLoginProtocolService.tokenServiceBaseUrl(baseUriBuilder);
        return uriBuilder.path(OIDCLoginProtocolService.class, "validateAccessToken");
    }

    public static UriBuilder logoutUrl(UriInfo uriInfo) {
        UriBuilder baseUriBuilder = uriInfo.getBaseUriBuilder();
        return OIDCLoginProtocolService.logoutUrl(baseUriBuilder);
    }

    public static UriBuilder logoutUrl(UriBuilder baseUriBuilder) {
        UriBuilder uriBuilder = OIDCLoginProtocolService.tokenServiceBaseUrl(baseUriBuilder);
        return uriBuilder.path(OIDCLoginProtocolService.class, "logout");
    }

    @Path(value="auth")
    public Object auth() {
        AuthorizationEndpoint endpoint = new AuthorizationEndpoint(this.authManager, this.realm, this.event);
        ResteasyProviderFactory.getInstance().injectProperties((Object)endpoint);
        return endpoint;
    }

    @Path(value="registrations")
    public Object registerPage() {
        AuthorizationEndpoint endpoint = new AuthorizationEndpoint(this.authManager, this.realm, this.event);
        ResteasyProviderFactory.getInstance().injectProperties((Object)endpoint);
        return endpoint.register();
    }

    @Path(value="forgot-credentials")
    public Object forgotCredentialsPage() {
        AuthorizationEndpoint endpoint = new AuthorizationEndpoint(this.authManager, this.realm, this.event);
        ResteasyProviderFactory.getInstance().injectProperties((Object)endpoint);
        return endpoint.forgotCredentials();
    }

    @Path(value="token")
    public Object token() {
        TokenEndpoint endpoint = new TokenEndpoint(this.tokenManager, this.authManager, this.realm, this.event);
        ResteasyProviderFactory.getInstance().injectProperties((Object)endpoint);
        return endpoint;
    }

    @Path(value="login")
    @Deprecated
    public Object loginPage() {
        AuthorizationEndpoint endpoint = new AuthorizationEndpoint(this.authManager, this.realm, this.event);
        ResteasyProviderFactory.getInstance().injectProperties((Object)endpoint);
        return endpoint.legacy("code");
    }

    @Path(value="login-status-iframe.html")
    public Object getLoginStatusIframe() {
        LoginStatusIframeEndpoint endpoint = new LoginStatusIframeEndpoint(this.realm);
        ResteasyProviderFactory.getInstance().injectProperties((Object)endpoint);
        return endpoint;
    }

    @Path(value="grants/access")
    @Deprecated
    public Object grantAccessToken() {
        TokenEndpoint endpoint = new TokenEndpoint(this.tokenManager, this.authManager, this.realm, this.event);
        ResteasyProviderFactory.getInstance().injectProperties((Object)endpoint);
        return endpoint.legacy("password");
    }

    @Path(value="refresh")
    @Deprecated
    public Object refreshAccessToken() {
        TokenEndpoint endpoint = new TokenEndpoint(this.tokenManager, this.authManager, this.realm, this.event);
        ResteasyProviderFactory.getInstance().injectProperties((Object)endpoint);
        return endpoint.legacy("refresh_token");
    }

    @Path(value="access/codes")
    @Deprecated
    public Object accessCodeToToken() {
        TokenEndpoint endpoint = new TokenEndpoint(this.tokenManager, this.authManager, this.realm, this.event);
        ResteasyProviderFactory.getInstance().injectProperties((Object)endpoint);
        return endpoint.legacy("authorization_code");
    }

    @Path(value="validate")
    @Deprecated
    public Object validateAccessToken(@QueryParam(value="access_token") String tokenString) {
        logger.warnv("Invoking deprecated endpoint {0}", (Object)this.uriInfo.getRequestUri());
        ValidateTokenEndpoint endpoint = new ValidateTokenEndpoint(this.tokenManager, this.realm, this.event);
        ResteasyProviderFactory.getInstance().injectProperties((Object)endpoint);
        return endpoint;
    }

    @GET
    @Path(value="certs")
    @Produces(value={"application/json"})
    @NoCache
    public JSONWebKeySet certs() {
        JSONWebKeySet keySet = new JSONWebKeySet();
        keySet.setKeys(new JWK[]{JWKBuilder.create().rs256(this.realm.getPublicKey())});
        return keySet;
    }

    @Path(value="userinfo")
    public Object issueUserInfo() {
        UserInfoEndpoint endpoint = new UserInfoEndpoint(this.tokenManager, this.realm);
        ResteasyProviderFactory.getInstance().injectProperties((Object)endpoint);
        return endpoint;
    }

    @Path(value="logout")
    public Object logout() {
        LogoutEndpoint endpoint = new LogoutEndpoint(this.tokenManager, this.authManager, this.realm, this.event);
        ResteasyProviderFactory.getInstance().injectProperties((Object)endpoint);
        return endpoint;
    }

    @Path(value="oauth/oob")
    @GET
    public Response installedAppUrnCallback(@QueryParam(value="code") String code, @QueryParam(value="error") String error, @QueryParam(value="error_description") String errorDescription) {
        LoginFormsProvider forms = (LoginFormsProvider)this.session.getProvider(LoginFormsProvider.class);
        if (code != null) {
            return forms.setClientSessionCode(code).createCode();
        }
        return forms.setError(error, new Object[0]).createCode();
    }
}

