/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.migration.migrators;

import java.util.List;
import org.keycloak.Config;
import org.keycloak.migration.MigrationProvider;
import org.keycloak.migration.ModelVersion;
import org.keycloak.models.AdminRoles;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.utils.KeycloakModelUtils;

public class MigrateTo1_6_0 {
    public static final ModelVersion VERSION = new ModelVersion("1.6.0");

    public void migrate(KeycloakSession session) {
        MigrationProvider provider = session.getProvider(MigrationProvider.class);
        List<ProtocolMapperModel> builtinMappers = provider.getBuiltinMappers("openid-connect");
        ProtocolMapperModel localeMapper = null;
        for (ProtocolMapperModel m : builtinMappers) {
            if (!m.getName().equals("locale")) continue;
            localeMapper = m;
        }
        if (localeMapper == null) {
            throw new RuntimeException("Can't find default locale mapper");
        }
        List<RealmModel> realms = session.realms().getRealms();
        for (RealmModel realm : realms) {
            RoleModel role;
            ClientModel adminConsoleClient;
            ClientModel client2;
            realm.setOfflineSessionIdleTimeout(2592000);
            if (realm.getRole("offline_access") == null) {
                for (RoleModel realmRole : realm.getRoles()) {
                    realmRole.setScopeParamRequired(false);
                }
                for (ClientModel client2 : realm.getClients()) {
                    for (RoleModel clientRole : client2.getRoles()) {
                        clientRole.setScopeParamRequired(false);
                    }
                }
                KeycloakModelUtils.setupOfflineTokens(realm);
                RoleModel role2 = realm.getRole("offline_access");
                session.users().grantToAllUsers(realm, role2);
            }
            if ((adminConsoleClient = realm.getClientByClientId("security-admin-console")) != null && !this.localeMapperAdded(adminConsoleClient)) {
                adminConsoleClient.addProtocolMapper(localeMapper);
            }
            if ((client2 = realm.getMasterAdminClient()).getRole(AdminRoles.CREATE_CLIENT) == null) {
                role = client2.addRole(AdminRoles.CREATE_CLIENT);
                role.setDescription("${role_" + AdminRoles.CREATE_CLIENT + "}");
                role.setScopeParamRequired(false);
                client2.getRealm().getRole(AdminRoles.ADMIN).addCompositeRole(role);
            }
            if (realm.getName().equals(Config.getAdminRealm()) || (client2 = realm.getClientByClientId("realm-management")).getRole(AdminRoles.CREATE_CLIENT) != null) continue;
            role = client2.addRole(AdminRoles.CREATE_CLIENT);
            role.setDescription("${role_" + AdminRoles.CREATE_CLIENT + "}");
            role.setScopeParamRequired(false);
            client2.getRole(AdminRoles.REALM_ADMIN).addCompositeRole(role);
        }
    }

    private boolean localeMapperAdded(ClientModel adminConsoleClient) {
        return adminConsoleClient.getProtocolMapperByName("openid-connect", "locale") != null;
    }
}

