/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientregistration;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.keycloak.authentication.AuthenticationProcessor;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.protocol.oidc.utils.AuthorizeClientUtil;
import org.keycloak.services.ForbiddenException;
import org.keycloak.services.clientregistration.ClientRegistrationAuth;
import org.keycloak.services.clientregistration.ClientRegistrationProvider;
import org.keycloak.services.managers.ClientManager;
import org.keycloak.services.managers.RealmManager;

public class AdapterInstallationClientRegistrationProvider
implements ClientRegistrationProvider {
    private KeycloakSession session;
    private EventBuilder event;
    private ClientRegistrationAuth auth;

    public AdapterInstallationClientRegistrationProvider(KeycloakSession session) {
        this.session = session;
    }

    @GET
    @Path(value="{clientId}")
    @Produces(value={"application/json"})
    public Response get(@PathParam(value="clientId") String clientId) {
        this.event.event(EventType.CLIENT_INFO);
        ClientModel client = this.session.getContext().getRealm().getClientByClientId(clientId);
        if (this.auth.isAuthenticated()) {
            this.auth.requireView(client);
        } else {
            this.authenticateClient(client);
        }
        ClientManager clientManager = new ClientManager(new RealmManager(this.session));
        ClientManager.InstallationAdapterConfig rep = clientManager.toInstallationRepresentation(this.session.getContext().getRealm(), client, this.session.getContext().getAuthServerUrl());
        this.event.client(client.getClientId()).success();
        return Response.ok((Object)((Object)rep)).build();
    }

    @Override
    public void setAuth(ClientRegistrationAuth auth) {
        this.auth = auth;
    }

    @Override
    public void setEvent(EventBuilder event) {
        this.event = event;
    }

    public void close() {
    }

    private void authenticateClient(ClientModel client) {
        if (client.isPublicClient()) {
            return;
        }
        AuthenticationProcessor processor = AuthorizeClientUtil.getAuthenticationProcessor(this.session, this.event);
        Response response = processor.authenticateClient();
        if (response != null) {
            this.event.client(client.getClientId()).error("not_allowed");
            throw new ForbiddenException();
        }
        ClientModel authClient = processor.getClient();
        if (client == null) {
            this.event.client(client.getClientId()).error("not_allowed");
            throw new ForbiddenException();
        }
        if (!authClient.getClientId().equals(client.getClientId())) {
            this.event.client(client.getClientId()).error("not_allowed");
            throw new ForbiddenException();
        }
    }
}

