/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.federation.ldap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.logging.Logger;
import org.keycloak.federation.kerberos.impl.KerberosUsernamePasswordAuthenticator;
import org.keycloak.federation.kerberos.impl.SPNEGOAuthenticator;
import org.keycloak.federation.ldap.LDAPFederationProviderFactory;
import org.keycloak.federation.ldap.LDAPUtils;
import org.keycloak.federation.ldap.ReadonlyLDAPUserModelDelegate;
import org.keycloak.federation.ldap.UnsyncedLDAPUserModelDelegate;
import org.keycloak.federation.ldap.WritableLDAPUserModelDelegate;
import org.keycloak.federation.ldap.idm.model.LDAPObject;
import org.keycloak.federation.ldap.idm.query.Condition;
import org.keycloak.federation.ldap.idm.query.QueryParameter;
import org.keycloak.federation.ldap.idm.query.internal.LDAPIdentityQuery;
import org.keycloak.federation.ldap.idm.query.internal.LDAPQueryConditionsBuilder;
import org.keycloak.federation.ldap.idm.store.ldap.LDAPIdentityStore;
import org.keycloak.federation.ldap.kerberos.LDAPProviderKerberosConfig;
import org.keycloak.federation.ldap.mappers.LDAPFederationMapper;
import org.keycloak.mappers.UserFederationMapper;
import org.keycloak.models.CredentialValidationOutput;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserCredentialValueModel;
import org.keycloak.models.UserFederationMapperModel;
import org.keycloak.models.UserFederationProvider;
import org.keycloak.models.UserFederationProviderModel;
import org.keycloak.models.UserFederationSyncResult;
import org.keycloak.models.UserModel;

public class LDAPFederationProvider
implements UserFederationProvider {
    private static final Logger logger = Logger.getLogger(LDAPFederationProvider.class);
    protected LDAPFederationProviderFactory factory;
    protected KeycloakSession session;
    protected UserFederationProviderModel model;
    protected LDAPIdentityStore ldapIdentityStore;
    protected UserFederationProvider.EditMode editMode;
    protected LDAPProviderKerberosConfig kerberosConfig;
    protected final Set<String> supportedCredentialTypes = new HashSet<String>();

    public LDAPFederationProvider(LDAPFederationProviderFactory factory, KeycloakSession session, UserFederationProviderModel model, LDAPIdentityStore ldapIdentityStore) {
        this.factory = factory;
        this.session = session;
        this.model = model;
        this.ldapIdentityStore = ldapIdentityStore;
        this.kerberosConfig = new LDAPProviderKerberosConfig(model);
        this.editMode = ldapIdentityStore.getConfig().getEditMode();
        this.supportedCredentialTypes.add("password");
        if (this.kerberosConfig.isAllowKerberosAuthentication()) {
            this.supportedCredentialTypes.add("kerberos");
        }
    }

    public KeycloakSession getSession() {
        return this.session;
    }

    public UserFederationProviderModel getModel() {
        return this.model;
    }

    public LDAPIdentityStore getLdapIdentityStore() {
        return this.ldapIdentityStore;
    }

    public UserFederationProvider.EditMode getEditMode() {
        return this.editMode;
    }

    public UserModel validateAndProxy(RealmModel realm, UserModel local) {
        LDAPObject ldapObject = this.loadAndValidateUser(realm, local);
        if (ldapObject == null) {
            return null;
        }
        return this.proxy(realm, local, ldapObject);
    }

    protected UserModel proxy(RealmModel realm, UserModel local, LDAPObject ldapObject) {
        UserModel proxied = local;
        switch (this.editMode) {
            case READ_ONLY: {
                proxied = new ReadonlyLDAPUserModelDelegate(local, this);
                break;
            }
            case WRITABLE: {
                proxied = new WritableLDAPUserModelDelegate(local, this, ldapObject);
                break;
            }
            case UNSYNCED: {
                proxied = new UnsyncedLDAPUserModelDelegate(local, this);
            }
        }
        Set federationMappers = realm.getUserFederationMappersByFederationProvider(this.model.getId());
        for (UserFederationMapperModel mapperModel : federationMappers) {
            LDAPFederationMapper ldapMapper = this.getMapper(mapperModel);
            proxied = ldapMapper.proxy(mapperModel, this, ldapObject, proxied, realm);
        }
        return proxied;
    }

    public Set<String> getSupportedCredentialTypes(UserModel local) {
        HashSet<String> supportedCredentialTypes = new HashSet<String>(this.supportedCredentialTypes);
        if (this.editMode == UserFederationProvider.EditMode.UNSYNCED) {
            for (UserCredentialValueModel cred : local.getCredentialsDirectly()) {
                if (!cred.getType().equals("password")) continue;
                supportedCredentialTypes.remove("password");
            }
        }
        return supportedCredentialTypes;
    }

    public Set<String> getSupportedCredentialTypes() {
        return new HashSet<String>(this.supportedCredentialTypes);
    }

    public boolean synchronizeRegistrations() {
        return "true".equalsIgnoreCase((String)this.model.getConfig().get("syncRegistrations")) && this.editMode == UserFederationProvider.EditMode.WRITABLE;
    }

    public UserModel register(RealmModel realm, UserModel user) {
        if (this.editMode == UserFederationProvider.EditMode.READ_ONLY || this.editMode == UserFederationProvider.EditMode.UNSYNCED) {
            throw new IllegalStateException("Registration is not supported by this ldap server");
        }
        if (!this.synchronizeRegistrations()) {
            throw new IllegalStateException("Registration is not supported by this ldap server");
        }
        LDAPObject ldapObject = LDAPUtils.addUserToLDAP(this, realm, user);
        user.setAttribute("LDAP_ID", ldapObject.getUuid());
        user.setAttribute("LDAP_ENTRY_DN", ldapObject.getDn().toString());
        return this.proxy(realm, user, ldapObject);
    }

    public boolean removeUser(RealmModel realm, UserModel user) {
        if (this.editMode == UserFederationProvider.EditMode.READ_ONLY || this.editMode == UserFederationProvider.EditMode.UNSYNCED) {
            logger.warnf("User '%s' can't be deleted in LDAP as editMode is '%s'", (Object)user.getUsername(), (Object)this.editMode.toString());
            return false;
        }
        LDAPObject ldapObject = this.loadAndValidateUser(realm, user);
        if (ldapObject == null) {
            logger.warnf("User '%s' can't be deleted from LDAP as it doesn't exist here", (Object)user.getUsername());
            return false;
        }
        this.ldapIdentityStore.remove(ldapObject);
        return true;
    }

    public List<UserModel> searchByAttributes(Map<String, String> attributes, RealmModel realm, int maxResults) {
        LinkedList<UserModel> searchResults = new LinkedList<UserModel>();
        List<LDAPObject> ldapUsers = this.searchLDAP(realm, attributes, maxResults);
        for (LDAPObject ldapUser : ldapUsers) {
            String ldapUsername = LDAPUtils.getUsername(ldapUser, this.ldapIdentityStore.getConfig());
            if (this.session.userStorage().getUserByUsername(ldapUsername, realm) != null) continue;
            UserModel imported = this.importUserFromLDAP(realm, ldapUser);
            searchResults.add(imported);
        }
        return searchResults;
    }

    protected List<LDAPObject> searchLDAP(RealmModel realm, Map<String, String> attributes, int maxResults) {
        LDAPObject user;
        ArrayList<LDAPObject> results = new ArrayList<LDAPObject>();
        if (attributes.containsKey("username") && (user = this.loadLDAPUserByUsername(realm, attributes.get("username"))) != null) {
            results.add(user);
        }
        if (attributes.containsKey("email") && (user = this.queryByEmail(realm, attributes.get("email"))) != null) {
            results.add(user);
        }
        if (attributes.containsKey("firstName") || attributes.containsKey("lastName")) {
            LDAPIdentityQuery ldapQuery = LDAPUtils.createQueryForUserSearch(this, realm);
            LDAPQueryConditionsBuilder conditionsBuilder = new LDAPQueryConditionsBuilder();
            if (attributes.containsKey("firstName")) {
                ldapQuery.where(conditionsBuilder.equal(new QueryParameter("firstName"), attributes.get("firstName")));
            }
            if (attributes.containsKey("lastName")) {
                ldapQuery.where(conditionsBuilder.equal(new QueryParameter("lastName"), attributes.get("lastName")));
            }
            List<LDAPObject> ldapObjects = ldapQuery.getResultList();
            results.addAll(ldapObjects);
        }
        return results;
    }

    protected LDAPObject loadAndValidateUser(RealmModel realm, UserModel local) {
        LDAPObject ldapUser = this.loadLDAPUserByUsername(realm, local.getUsername());
        if (ldapUser == null) {
            return null;
        }
        if (ldapUser.getUuid().equals(local.getAttribute("LDAP_ID"))) {
            return ldapUser;
        }
        logger.warnf("LDAP User invalid. ID doesn't match. ID from LDAP [%s], ID from local DB: [%s]", (Object)ldapUser.getUuid(), (Object)local.getAttribute("LDAP_ID"));
        return null;
    }

    public boolean isValid(RealmModel realm, UserModel local) {
        return this.loadAndValidateUser(realm, local) != null;
    }

    public UserModel getUserByUsername(RealmModel realm, String username) {
        LDAPObject ldapUser = this.loadLDAPUserByUsername(realm, username);
        if (ldapUser == null) {
            return null;
        }
        return this.importUserFromLDAP(realm, ldapUser);
    }

    protected UserModel importUserFromLDAP(RealmModel realm, LDAPObject ldapUser) {
        String ldapUsername = LDAPUtils.getUsername(ldapUser, this.ldapIdentityStore.getConfig());
        if (ldapUsername == null) {
            throw new ModelException("User returned from LDAP has null username! Check configuration of your LDAP mappings. Mapped username LDAP attribute: " + this.ldapIdentityStore.getConfig().getUsernameLdapAttribute() + ", attributes from LDAP: " + ldapUser.getAttributes());
        }
        UserModel imported = this.session.userStorage().addUser(realm, ldapUsername);
        imported.setEnabled(true);
        Set federationMappers = realm.getUserFederationMappersByFederationProvider(this.getModel().getId());
        for (UserFederationMapperModel mapperModel : federationMappers) {
            LDAPFederationMapper ldapMapper = this.getMapper(mapperModel);
            ldapMapper.onImportUserFromLDAP(mapperModel, this, ldapUser, imported, realm, true);
        }
        String userDN = ldapUser.getDn().toString();
        imported.setFederationLink(this.model.getId());
        imported.setAttribute("LDAP_ID", ldapUser.getUuid());
        imported.setAttribute("LDAP_ENTRY_DN", userDN);
        logger.debugf("Imported new user from LDAP to Keycloak DB. Username: [%s], Email: [%s], LDAP_ID: [%s], LDAP Entry DN: [%s]", new Object[]{imported.getUsername(), imported.getEmail(), ldapUser.getUuid(), userDN});
        return this.proxy(realm, imported, ldapUser);
    }

    protected LDAPObject queryByEmail(RealmModel realm, String email) {
        LDAPIdentityQuery ldapQuery = LDAPUtils.createQueryForUserSearch(this, realm);
        LDAPQueryConditionsBuilder conditionsBuilder = new LDAPQueryConditionsBuilder();
        Condition emailCondition = conditionsBuilder.equal(new QueryParameter("email"), email);
        ldapQuery.where(emailCondition);
        return ldapQuery.getFirstResult();
    }

    public UserModel getUserByEmail(RealmModel realm, String email) {
        LDAPObject ldapUser = this.queryByEmail(realm, email);
        if (ldapUser == null) {
            return null;
        }
        return this.importUserFromLDAP(realm, ldapUser);
    }

    public void preRemove(RealmModel realm) {
    }

    public void preRemove(RealmModel realm, RoleModel role) {
    }

    public boolean validPassword(RealmModel realm, UserModel user, String password) {
        if (this.kerberosConfig.isAllowKerberosAuthentication() && this.kerberosConfig.isUseKerberosForPasswordAuthentication()) {
            KerberosUsernamePasswordAuthenticator authenticator = this.factory.createKerberosUsernamePasswordAuthenticator(this.kerberosConfig);
            return authenticator.validUser(user.getUsername(), password);
        }
        LDAPObject ldapUser = this.loadAndValidateUser(realm, user);
        return this.ldapIdentityStore.validatePassword(ldapUser, password);
    }

    public boolean validCredentials(RealmModel realm, UserModel user, List<UserCredentialModel> input) {
        Iterator<UserCredentialModel> i$ = input.iterator();
        if (i$.hasNext()) {
            UserCredentialModel cred = i$.next();
            if (cred.getType().equals("password")) {
                return this.validPassword(realm, user, cred.getValue());
            }
            return false;
        }
        return true;
    }

    public boolean validCredentials(RealmModel realm, UserModel user, UserCredentialModel ... input) {
        return this.validCredentials(realm, user, Arrays.asList(input));
    }

    public CredentialValidationOutput validCredentials(RealmModel realm, UserCredentialModel credential) {
        if (credential.getType().equals("kerberos") && this.kerberosConfig.isAllowKerberosAuthentication()) {
            String spnegoToken = credential.getValue();
            SPNEGOAuthenticator spnegoAuthenticator = this.factory.createSPNEGOAuthenticator(spnegoToken, this.kerberosConfig);
            spnegoAuthenticator.authenticate();
            HashMap<String, String> state = new HashMap<String, String>();
            if (spnegoAuthenticator.isAuthenticated()) {
                String username = spnegoAuthenticator.getAuthenticatedUsername();
                UserModel user = this.findOrCreateAuthenticatedUser(realm, username);
                if (user == null) {
                    logger.warnf("Kerberos/SPNEGO authentication succeeded with username [%s], but couldn't find or create user with federation provider [%s]", (Object)username, (Object)this.model.getDisplayName());
                    return CredentialValidationOutput.failed();
                }
                String delegationCredential = spnegoAuthenticator.getSerializedDelegationCredential();
                if (delegationCredential != null) {
                    state.put("gss_delegation_credential", delegationCredential);
                }
                return new CredentialValidationOutput(user, CredentialValidationOutput.Status.AUTHENTICATED, state);
            }
            state.put("SpnegoResponseToken", spnegoAuthenticator.getResponseToken());
            return new CredentialValidationOutput(null, CredentialValidationOutput.Status.CONTINUE, state);
        }
        return CredentialValidationOutput.failed();
    }

    public void close() {
    }

    protected UserFederationSyncResult importLDAPUsers(RealmModel realm, List<LDAPObject> ldapUsers, UserFederationProviderModel fedModel) {
        UserFederationSyncResult syncResult = new UserFederationSyncResult();
        for (LDAPObject ldapUser : ldapUsers) {
            String username = LDAPUtils.getUsername(ldapUser, this.ldapIdentityStore.getConfig());
            UserModel currentUser = this.session.userStorage().getUserByUsername(username, realm);
            if (currentUser == null) {
                this.importUserFromLDAP(realm, ldapUser);
                syncResult.increaseAdded();
                continue;
            }
            if (fedModel.getId().equals(currentUser.getFederationLink()) && ldapUser.getUuid().equals(currentUser.getAttribute("LDAP_ID"))) {
                Set federationMappers = realm.getUserFederationMappersByFederationProvider(this.model.getId());
                for (UserFederationMapperModel mapperModel : federationMappers) {
                    LDAPFederationMapper ldapMapper = this.getMapper(mapperModel);
                    ldapMapper.onImportUserFromLDAP(mapperModel, this, ldapUser, currentUser, realm, false);
                }
                logger.debugf("Updated user from LDAP: %s", (Object)currentUser.getUsername());
                syncResult.increaseUpdated();
                continue;
            }
            logger.warnf("User '%s' is not updated during sync as he is not linked to federation provider '%s'", (Object)username, (Object)fedModel.getDisplayName());
        }
        return syncResult;
    }

    protected UserModel findOrCreateAuthenticatedUser(RealmModel realm, String username) {
        UserModel user = this.session.userStorage().getUserByUsername(username, realm);
        if (user != null) {
            logger.debugf("Kerberos authenticated user [%s] found in Keycloak storage", (Object)username);
            if (!this.model.getId().equals(user.getFederationLink())) {
                logger.warnf("User with username [%s] already exists, but is not linked to provider [%s]", (Object)username, (Object)this.model.getDisplayName());
                return null;
            }
            LDAPObject ldapObject = this.loadAndValidateUser(realm, user);
            if (ldapObject != null) {
                return this.proxy(realm, user, ldapObject);
            }
            logger.warnf("User with username [%s] aready exists and is linked to provider [%s] but is not valid. Stale LDAP_ID on local user is: %s", (Object)username, (Object)this.model.getDisplayName(), (Object)user.getAttribute("LDAP_ID"));
            logger.warn((Object)"Will re-create user");
            this.session.userStorage().removeUser(realm, user);
        }
        logger.debugf("Kerberos authenticated user [%s] not in Keycloak storage. Creating him", (Object)username);
        return this.getUserByUsername(realm, username);
    }

    public LDAPObject loadLDAPUserByUsername(RealmModel realm, String username) {
        LDAPIdentityQuery ldapQuery = LDAPUtils.createQueryForUserSearch(this, realm);
        LDAPQueryConditionsBuilder conditionsBuilder = new LDAPQueryConditionsBuilder();
        String usernameMappedAttribute = this.ldapIdentityStore.getConfig().getUsernameLdapAttribute();
        Condition usernameCondition = conditionsBuilder.equal(new QueryParameter(usernameMappedAttribute), username);
        ldapQuery.where(usernameCondition);
        LDAPObject ldapUser = ldapQuery.getFirstResult();
        if (ldapUser == null) {
            return null;
        }
        String ldapUsername = LDAPUtils.getUsername(ldapUser, this.ldapIdentityStore.getConfig());
        if (!username.equals(ldapUsername)) {
            logger.warnf("User found in LDAP but with different username. LDAP username: %s, Searched username: %s", (Object)username, (Object)ldapUsername);
            return null;
        }
        return ldapUser;
    }

    public LDAPFederationMapper getMapper(UserFederationMapperModel mapperModel) {
        LDAPFederationMapper ldapMapper = (LDAPFederationMapper)this.getSession().getProvider(UserFederationMapper.class, mapperModel.getFederationMapperType());
        if (ldapMapper == null) {
            throw new ModelException("Can't find mapper type with ID: " + mapperModel.getFederationMapperType());
        }
        return ldapMapper;
    }
}

