/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.keycloak.models.CredentialValidationOutput;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserModel;
import org.keycloak.provider.Provider;

public interface UserFederationProvider
extends Provider {
    public static final String USERNAME = "username";
    public static final String EMAIL = "email";
    public static final String FIRST_NAME = "firstName";
    public static final String LAST_NAME = "lastName";

    public UserModel validateAndProxy(RealmModel var1, UserModel var2);

    public boolean synchronizeRegistrations();

    public UserModel register(RealmModel var1, UserModel var2);

    public boolean removeUser(RealmModel var1, UserModel var2);

    public UserModel getUserByUsername(RealmModel var1, String var2);

    public UserModel getUserByEmail(RealmModel var1, String var2);

    public List<UserModel> searchByAttributes(Map<String, String> var1, RealmModel var2, int var3);

    public void preRemove(RealmModel var1);

    public void preRemove(RealmModel var1, RoleModel var2);

    public boolean isValid(RealmModel var1, UserModel var2);

    public Set<String> getSupportedCredentialTypes(UserModel var1);

    public Set<String> getSupportedCredentialTypes();

    public boolean validCredentials(RealmModel var1, UserModel var2, List<UserCredentialModel> var3);

    public boolean validCredentials(RealmModel var1, UserModel var2, UserCredentialModel ... var3);

    public CredentialValidationOutput validCredentials(RealmModel var1, UserCredentialModel var2);

    @Override
    public void close();

    public static enum EditMode {
        READ_ONLY,
        WRITABLE,
        UNSYNCED;

    }
}

