/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication;

import java.util.LinkedList;
import java.util.List;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.AuthenticatorModel;
import org.keycloak.models.RealmModel;

public class AuthenticatorUtil {
    public static List<AuthenticationExecutionModel> getEnabledExecutionsRecursively(RealmModel realm, String flowId) {
        LinkedList<AuthenticationExecutionModel> executions = new LinkedList<AuthenticationExecutionModel>();
        AuthenticatorUtil.recurseExecutions(realm, flowId, executions);
        return executions;
    }

    public static void recurseExecutions(RealmModel realm, String flowId, List<AuthenticationExecutionModel> executions) {
        for (AuthenticationExecutionModel model : realm.getAuthenticationExecutions(flowId)) {
            executions.add(model);
            if (!model.isAutheticatorFlow() || !model.isEnabled()) continue;
            AuthenticatorUtil.recurseExecutions(realm, model.getAuthenticator(), executions);
        }
    }

    public static AuthenticationExecutionModel findExecutionByAuthenticator(RealmModel realm, String flowId, String authProviderId) {
        for (AuthenticationExecutionModel model : realm.getAuthenticationExecutions(flowId)) {
            AuthenticationExecutionModel recurse;
            if (model.isAutheticatorFlow() && (recurse = AuthenticatorUtil.findExecutionByAuthenticator(realm, model.getAuthenticator(), authProviderId)) != null) {
                return recurse;
            }
            AuthenticatorModel authenticator = realm.getAuthenticatorById(model.getAuthenticator());
            if (!authenticator.getProviderId().equals(authProviderId)) continue;
            return model;
        }
        return null;
    }

    public static boolean isEnabled(RealmModel realm, String flowId, String authProviderId) {
        AuthenticationExecutionModel execution = AuthenticatorUtil.findExecutionByAuthenticator(realm, flowId, authProviderId);
        if (execution == null) {
            return false;
        }
        return execution.isEnabled();
    }

    public static boolean isRequired(RealmModel realm, String flowId, String authProviderId) {
        AuthenticationExecutionModel execution = AuthenticatorUtil.findExecutionByAuthenticator(realm, flowId, authProviderId);
        if (execution == null) {
            return false;
        }
        return execution.isRequired();
    }
}

