/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.actions;

import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.Response;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.authentication.RequiredActionContext;
import org.keycloak.authentication.RequiredActionFactory;
import org.keycloak.authentication.RequiredActionProvider;
import org.keycloak.login.LoginFormsProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.UserCredentialValueModel;
import org.keycloak.models.UserModel;
import org.keycloak.util.Time;

public class UpdatePassword
implements RequiredActionProvider,
RequiredActionFactory {
    protected static Logger logger = Logger.getLogger(UpdatePassword.class);

    @Override
    public void evaluateTriggers(RequiredActionContext context) {
        int daysToExpirePassword = context.getRealm().getPasswordPolicy().getDaysToExpirePassword();
        if (daysToExpirePassword != -1) {
            for (UserCredentialValueModel entity : context.getUser().getCredentialsDirectly()) {
                long timeToExpire;
                if (!entity.getType().equals("password")) continue;
                if (entity.getCreatedDate() == null) {
                    context.getUser().addRequiredAction(UserModel.RequiredAction.UPDATE_PASSWORD);
                    logger.debug((Object)"User is required to update password");
                    break;
                }
                long timeElapsed = Time.toMillis((int)Time.currentTime()) - entity.getCreatedDate();
                if (timeElapsed <= (timeToExpire = TimeUnit.DAYS.toMillis(daysToExpirePassword))) break;
                context.getUser().addRequiredAction(UserModel.RequiredAction.UPDATE_PASSWORD);
                logger.debug((Object)"User is required to update password");
                break;
            }
        }
    }

    @Override
    public Response invokeRequiredAction(RequiredActionContext context) {
        LoginFormsProvider loginFormsProvider = ((LoginFormsProvider)context.getSession().getProvider(LoginFormsProvider.class)).setClientSessionCode(context.generateAccessCode(this.getProviderId())).setUser(context.getUser());
        return loginFormsProvider.createResponse(UserModel.RequiredAction.UPDATE_PASSWORD);
    }

    @Override
    public Object jaxrsService(RequiredActionContext context) {
        return null;
    }

    public void close() {
    }

    public RequiredActionProvider create(KeycloakSession session) {
        return this;
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    @Override
    public String getDisplayText() {
        return "Update Password";
    }

    public String getId() {
        return UserModel.RequiredAction.UPDATE_PASSWORD.name();
    }

    @Override
    public String getProviderId() {
        return this.getId();
    }
}

